/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model.geojson.codecs;

import com.mongodb.assertions.Assertions;
import com.mongodb.client.model.geojson.Point;
import com.mongodb.client.model.geojson.codecs.GeometryCodecHelper;
import org.bson.BsonReader;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.configuration.CodecRegistry;

public class PointCodec
implements Codec<Point> {
    private final CodecRegistry registry;

    public PointCodec(CodecRegistry registry) {
        this.registry = Assertions.notNull("registry", registry);
    }

    @Override
    public void encode(final BsonWriter writer, final Point value, EncoderContext encoderContext) {
        GeometryCodecHelper.encodeGeometry(writer, value, encoderContext, this.registry, new Runnable(){

            @Override
            public void run() {
                GeometryCodecHelper.encodePosition(writer, value.getPosition());
            }
        });
    }

    @Override
    public Class<Point> getEncoderClass() {
        return Point.class;
    }

    @Override
    public Point decode(BsonReader reader, DecoderContext decoderContext) {
        throw new UnsupportedOperationException("Not implemented yet!");
    }
}

