require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_CEC_UAPI_FUNCS_H)) {
    eval 'sub _CEC_UAPI_FUNCS_H () {1;}' unless defined(&_CEC_UAPI_FUNCS_H);
    require 'linux/cec.ph';
    eval 'sub cec_ops_active_source {
        my($msg,$phys_addr) = @_;
	    eval q({ *$phys_addr = ( ($msg->{msg[2]}) << 8) |  ($msg->{msg[3]}); });
    }' unless defined(&cec_ops_active_source);
    eval 'sub cec_msg_image_view_on {
        my($msg) = @_;
	    eval q({  ($msg->{len}) = 2;  ($msg->{msg[1]}) =  &CEC_MSG_IMAGE_VIEW_ON; });
    }' unless defined(&cec_msg_image_view_on);
    eval 'sub cec_msg_text_view_on {
        my($msg) = @_;
	    eval q({  ($msg->{len}) = 2;  ($msg->{msg[1]}) =  &CEC_MSG_TEXT_VIEW_ON; });
    }' unless defined(&cec_msg_text_view_on);
    eval 'sub cec_ops_inactive_source {
        my($msg,$phys_addr) = @_;
	    eval q({ *$phys_addr = ( ($msg->{msg[2]}) << 8) |  ($msg->{msg[3]}); });
    }' unless defined(&cec_ops_inactive_source);
    eval 'sub cec_msg_request_active_source {
        my($msg,$reply) = @_;
	    eval q({  ($msg->{len}) = 2;  ($msg->{msg[0]}) |= 0xf;  ($msg->{msg[1]}) =  &CEC_MSG_REQUEST_ACTIVE_SOURCE;  ($msg->{reply}) = $reply ?  &CEC_MSG_ACTIVE_SOURCE : 0; });
    }' unless defined(&cec_msg_request_active_source);
    eval 'sub cec_msg_routing_information {
        my($msg,$phys_addr) = @_;
	    eval q({  ($msg->{len}) = 4;  ($msg->{msg[0]}) |= 0xf;  ($msg->{msg[1]}) =  &CEC_MSG_ROUTING_INFORMATION;  ($msg->{msg[2]}) = $phys_addr >> 8;  ($msg->{msg[3]}) = $phys_addr & 0xff; });
    }' unless defined(&cec_msg_routing_information);
    eval 'sub cec_ops_routing_information {
        my($msg,$phys_addr) = @_;
	    eval q({ *$phys_addr = ( ($msg->{msg[2]}) << 8) |  ($msg->{msg[3]}); });
    }' unless defined(&cec_ops_routing_information);
    eval 'sub cec_msg_routing_change {
        my($msg,$reply,$orig_phys_addr,$new_phys_addr) = @_;
	    eval q({  ($msg->{len}) = 6;  ($msg->{msg[0]}) |= 0xf;  ($msg->{msg[1]}) =  &CEC_MSG_ROUTING_CHANGE;  ($msg->{msg[2]}) = $orig_phys_addr >> 8;  ($msg->{msg[3]}) = $orig_phys_addr & 0xff;  ($msg->{msg[4]}) = $new_phys_addr >> 8;  ($msg->{msg[5]}) = $new_phys_addr & 0xff;  ($msg->{reply}) = $reply ?  &CEC_MSG_ROUTING_INFORMATION : 0; });
    }' unless defined(&cec_msg_routing_change);
    eval 'sub cec_ops_routing_change {
        my($msg,$orig_phys_addr,$new_phys_addr) = @_;
	    eval q({ *$orig_phys_addr = ( ($msg->{msg[2]}) << 8) |  ($msg->{msg[3]}); *$new_phys_addr = ( ($msg->{msg[4]}) << 8) |  ($msg->{msg[5]}); });
    }' unless defined(&cec_ops_routing_change);
    eval 'sub cec_msg_set_stream_path {
        my($msg,$phys_addr) = @_;
	    eval q({  ($msg->{len}) = 4;  ($msg->{msg[0]}) |= 0xf;  ($msg->{msg[1]}) =  &CEC_MSG_SET_STREAM_PATH;  ($msg->{msg[2]}) = $phys_addr >> 8;  ($msg->{msg[3]}) = $phys_addr & 0xff; });
    }' unless defined(&cec_msg_set_stream_path);
    eval 'sub cec_ops_set_stream_path {
        my($msg,$phys_addr) = @_;
	    eval q({ *$phys_addr = ( ($msg->{msg[2]}) << 8) |  ($msg->{msg[3]}); });
    }' unless defined(&cec_ops_set_stream_path);
    eval 'sub cec_set_digital_service_id {
        my($msg,$digital) = @_;
	    eval q({ *$msg++ = ( ($digital->{service_id_method}) << 7) |  ($digital->{dig_bcast_system});  &if ( ($digital->{service_id_method}) ==  &CEC_OP_SERVICE_ID_METHOD_BY_CHANNEL) { *$msg++ = ( ($digital->{channel}->{channel_number_fmt}) << 2) | ( ($digital->{channel}->{major}) >> 8); *$msg++ =  ($digital->{channel}->{major}) & 0xff; *$msg++ =  ($digital->{channel}->{minor}) >> 8; *$msg++ =  ($digital->{channel}->{minor}) & 0xff; *$msg++ = 0; *$msg++ = 0; ; }  &switch ( ($digital->{dig_bcast_system})) {  &case  &CEC_OP_DIG_SERVICE_BCAST_SYSTEM_ATSC_GEN:  &case  &CEC_OP_DIG_SERVICE_BCAST_SYSTEM_ATSC_CABLE:  &case  &CEC_OP_DIG_SERVICE_BCAST_SYSTEM_ATSC_SAT:  &case  &CEC_OP_DIG_SERVICE_BCAST_SYSTEM_ATSC_T: *$msg++ =  ($digital->{atsc}->{transport_id}) >> 8; *$msg++ =  ($digital->{atsc}->{transport_id}) & 0xff; *$msg++ =  ($digital->{atsc}->{program_number}) >> 8; *$msg++ =  ($digital->{atsc}->{program_number}) & 0xff; *$msg++ = 0; *$msg++ = 0;  &break;  &default: *$msg++ =  ($digital->{dvb}->{transport_id}) >> 8; *$msg++ =  ($digital->{dvb}->{transport_id}) & 0xff; *$msg++ =  ($digital->{dvb}->{service_id}) >> 8; *$msg++ =  ($digital->{dvb}->{service_id}) & 0xff; *$msg++ =  ($digital->{dvb}->{orig_network_id}) >> 8; *$msg++ =  ($digital->{dvb}->{orig_network_id}) & 0xff;  &break; } });
    }' unless defined(&cec_set_digital_service_id);
    eval 'sub cec_get_digital_service_id {
        my($msg,$digital) = @_;
	    eval q({  ($digital->{service_id_method}) = $msg->[0] >> 7;  ($digital->{dig_bcast_system}) = $msg->[0] & 0x7f;  &if ( ($digital->{service_id_method}) ==  &CEC_OP_SERVICE_ID_METHOD_BY_CHANNEL) {  ($digital->{channel}->{channel_number_fmt}) = $msg->[1] >> 2;  ($digital->{channel}->{major}) = (($msg->[1] & 3) << 6) | $msg->[2];  ($digital->{channel}->{minor}) = ($msg->[3] << 8) | $msg->[4]; ; }  ($digital->{dvb}->{transport_id}) = ($msg->[1] << 8) | $msg->[2];  ($digital->{dvb}->{service_id}) = ($msg->[3] << 8) | $msg->[4];  ($digital->{dvb}->{orig_network_id}) = ($msg->[5] << 8) | $msg->[6]; });
    }' unless defined(&cec_get_digital_service_id);
    eval 'sub cec_msg_record_on_own {
        my($msg) = @_;
	    eval q({  ($msg->{len}) = 3;  ($msg->{msg[1]}) =  &CEC_MSG_RECORD_ON;  ($msg->{msg[2]}) =  &CEC_OP_RECORD_SRC_OWN; });
    }' unless defined(&cec_msg_record_on_own);
    eval 'sub cec_msg_record_on_digital {
        my($msg,$digital) = @_;
	    eval q({  ($msg->{len}) = 10;  ($msg->{msg[1]}) =  &CEC_MSG_RECORD_ON;  ($msg->{msg[2]}) =  &CEC_OP_RECORD_SRC_DIGITAL;  &cec_set_digital_service_id( ($msg->{msg}) + 3, $digital); });
    }' unless defined(&cec_msg_record_on_digital);
    eval 'sub cec_msg_record_on_analog {
        my($msg,$ana_bcast_type,$ana_freq,$bcast_system) = @_;
	    eval q({  ($msg->{len}) = 7;  ($msg->{msg[1]}) =  &CEC_MSG_RECORD_ON;  ($msg->{msg[2]}) =  &CEC_OP_RECORD_SRC_ANALOG;  ($msg->{msg[3]}) = $ana_bcast_type;  ($msg->{msg[4]}) = $ana_freq >> 8;  ($msg->{msg[5]}) = $ana_freq & 0xff;  ($msg->{msg[6]}) = $bcast_system; });
    }' unless defined(&cec_msg_record_on_analog);
    eval 'sub cec_msg_record_on_plug {
        my($msg,$plug) = @_;
	    eval q({  ($msg->{len}) = 4;  ($msg->{msg[1]}) =  &CEC_MSG_RECORD_ON;  ($msg->{msg[2]}) =  &CEC_OP_RECORD_SRC_EXT_PLUG;  ($msg->{msg[3]}) = $plug; });
    }' unless defined(&cec_msg_record_on_plug);
    eval 'sub cec_msg_record_on_phys_addr {
        my($msg,$phys_addr) = @_;
	    eval q({  ($msg->{len}) = 5;  ($msg->{msg[1]}) =  &CEC_MSG_RECORD_ON;  ($msg->{msg[2]}) =  &CEC_OP_RECORD_SRC_EXT_PHYS_ADDR;  ($msg->{msg[3]}) = $phys_addr >> 8;  ($msg->{msg[4]}) = $phys_addr & 0xff; });
    }' unless defined(&cec_msg_record_on_phys_addr);
    eval 'sub cec_msg_record_on {
        my($msg,$reply,$rec_src) = @_;
	    eval q({  &switch ( ($rec_src->{type})) {  &case  &CEC_OP_RECORD_SRC_OWN:  &cec_msg_record_on_own($msg);  &break;  &case  &CEC_OP_RECORD_SRC_DIGITAL:  &cec_msg_record_on_digital($msg,  ($rec_src->{digital}));  &break;  &case  &CEC_OP_RECORD_SRC_ANALOG:  &cec_msg_record_on_analog($msg,  ($rec_src->{analog}->{ana_bcast_type}),  ($rec_src->{analog}->{ana_freq}),  ($rec_src->{analog}->{bcast_system}));  &break;  &case  &CEC_OP_RECORD_SRC_EXT_PLUG:  &cec_msg_record_on_plug($msg,  ($rec_src->{ext_plug}->{plug}));  &break;  &case  &CEC_OP_RECORD_SRC_EXT_PHYS_ADDR:  &cec_msg_record_on_phys_addr($msg,  ($rec_src->{ext_phys_addr}->{phys_addr}));  &break; }  ($msg->{reply}) = $reply ?  &CEC_MSG_RECORD_STATUS : 0; });
    }' unless defined(&cec_msg_record_on);
    eval 'sub cec_ops_record_on {
        my($msg,$rec_src) = @_;
	    eval q({  ($rec_src->{type}) =  ($msg->{msg[2]});  &switch ( ($rec_src->{type})) {  &case  &CEC_OP_RECORD_SRC_OWN:  &break;  &case  &CEC_OP_RECORD_SRC_DIGITAL:  &cec_get_digital_service_id( ($msg->{msg}) + 3,  ($rec_src->{digital}));  &break;  &case  &CEC_OP_RECORD_SRC_ANALOG:  ($rec_src->{analog}->{ana_bcast_type}) =  ($msg->{msg[3]});  ($rec_src->{analog}->{ana_freq}) = ( ($msg->{msg[4]}) << 8) |  ($msg->{msg[5]});  ($rec_src->{analog}->{bcast_system}) =  ($msg->{msg[6]});  &break;  &case  &CEC_OP_RECORD_SRC_EXT_PLUG:  ($rec_src->{ext_plug}->{plug}) =  ($msg->{msg[3]});  &break;  &case  &CEC_OP_RECORD_SRC_EXT_PHYS_ADDR:  ($rec_src->{ext_phys_addr}->{phys_addr}) = ( ($msg->{msg[3]}) << 8) |  ($msg->{msg[4]});  &break; } });
    }' unless defined(&cec_ops_record_on);
    eval 'sub cec_msg_record_status {
        my($msg,$rec_status) = @_;
	    eval q({  ($msg->{len}) = 3;  ($msg->{msg[1]}) =  &CEC_MSG_RECORD_STATUS;  ($msg->{msg[2]}) = $rec_status; });
    }' unless defined(&cec_msg_record_status);
    eval 'sub cec_ops_record_status {
        my($msg,$rec_status) = @_;
	    eval q({ *$rec_status =  ($msg->{msg[2]}); });
    }' unless defined(&cec_ops_record_status);
    eval 'sub cec_msg_record_tv_screen {
        my($msg,$reply) = @_;
	    eval q({  ($msg->{len}) = 2;  ($msg->{msg[1]}) =  &CEC_MSG_RECORD_TV_SCREEN;  ($msg->{reply}) = $reply ?  &CEC_MSG_RECORD_ON : 0; });
    }' unless defined(&cec_msg_record_tv_screen);
    eval 'sub cec_ops_timer_status {
        my($msg,$timer_overlap_warning,$media_info,$prog_info,$prog_error,$duration_hr,$duration_min) = @_;
	    eval q({ *$timer_overlap_warning =  ($msg->{msg[2]}) >> 7; *$media_info = ( ($msg->{msg[2]}) >> 5) & 3;  &if ( ($msg->{msg[2]}) & 0x10) { *$prog_info =  ($msg->{msg[2]}) & 0xf; *$prog_error = 0; }  &else { *$prog_info = 0; *$prog_error =  ($msg->{msg[2]}) & 0xf; }  &if (*$prog_info ==  &CEC_OP_PROG_INFO_NOT_ENOUGH_SPACE || *$prog_info ==  &CEC_OP_PROG_INFO_MIGHT_NOT_BE_ENOUGH_SPACE || *$prog_error ==  &CEC_OP_PROG_ERROR_DUPLICATE) { *$duration_hr = ( ($msg->{msg[3]}) >> 4) * 10+ ( ($msg->{msg[3]}) & 0xf); *$duration_min = ( ($msg->{msg[4]}) >> 4) * 10+ ( ($msg->{msg[4]}) & 0xf); }  &else { *$duration_hr = *$duration_min = 0; } });
    }' unless defined(&cec_ops_timer_status);
    eval 'sub cec_msg_timer_cleared_status {
        my($msg,$timer_cleared_status) = @_;
	    eval q({  ($msg->{len}) = 3;  ($msg->{msg[1]}) =  &CEC_MSG_TIMER_CLEARED_STATUS;  ($msg->{msg[2]}) = $timer_cleared_status; });
    }' unless defined(&cec_msg_timer_cleared_status);
    eval 'sub cec_ops_timer_cleared_status {
        my($msg,$timer_cleared_status) = @_;
	    eval q({ *$timer_cleared_status =  ($msg->{msg[2]}); });
    }' unless defined(&cec_ops_timer_cleared_status);
    eval 'sub cec_msg_clear_analogue_timer {
        my($msg,$reply,$day,$month,$start_hr,$start_min,$duration_hr,$duration_min,$recording_seq,$ana_bcast_type,$ana_freq,$bcast_system) = @_;
	    eval q({  ($msg->{len}) = 13;  ($msg->{msg[1]}) =  &CEC_MSG_CLEAR_ANALOGUE_TIMER;  ($msg->{msg[2]}) = $day;  ($msg->{msg[3]}) = $month;  ($msg->{msg[4]}) = (($start_hr / 10) << 4) | ($start_hr % 10);  ($msg->{msg[5]}) = (($start_min / 10) << 4) | ($start_min % 10);  ($msg->{msg[6]}) = (($duration_hr / 10) << 4) | ($duration_hr % 10);  ($msg->{msg[7]}) = (($duration_min / 10) << 4) | ($duration_min % 10);  ($msg->{msg[8]}) = $recording_seq;  ($msg->{msg[9]}) = $ana_bcast_type;  ($msg->{msg[10]}) = $ana_freq >> 8;  ($msg->{msg[11]}) = $ana_freq & 0xff;  ($msg->{msg[12]}) = $bcast_system;  ($msg->{reply}) = $reply ?  &CEC_MSG_TIMER_CLEARED_STATUS : 0; });
    }' unless defined(&cec_msg_clear_analogue_timer);
    eval 'sub cec_ops_clear_analogue_timer {
        my($msg,$day,$month,$start_hr,$start_min,$duration_hr,$duration_min,$recording_seq,$ana_bcast_type,$ana_freq,$bcast_system) = @_;
	    eval q({ *$day =  ($msg->{msg[2]}); *$month =  ($msg->{msg[3]}); *$start_hr = ( ($msg->{msg[4]}) >> 4) * 10+ ( ($msg->{msg[4]}) & 0xf); *$start_min = ( ($msg->{msg[5]}) >> 4) * 10+ ( ($msg->{msg[5]}) & 0xf); *$duration_hr = ( ($msg->{msg[6]}) >> 4) * 10+ ( ($msg->{msg[6]}) & 0xf); *$duration_min = ( ($msg->{msg[7]}) >> 4) * 10+ ( ($msg->{msg[7]}) & 0xf); *$recording_seq =  ($msg->{msg[8]}); *$ana_bcast_type =  ($msg->{msg[9]}); *$ana_freq = ( ($msg->{msg[10]}) << 8) |  ($msg->{msg[11]}); *$bcast_system =  ($msg->{msg[12]}); });
    }' unless defined(&cec_ops_clear_analogue_timer);
    eval 'sub cec_msg_clear_digital_timer {
        my($msg,$reply,$day,$month,$start_hr,$start_min,$duration_hr,$duration_min,$recording_seq,$digital) = @_;
	    eval q({  ($msg->{len}) = 16;  ($msg->{reply}) = $reply ?  &CEC_MSG_TIMER_CLEARED_STATUS : 0;  ($msg->{msg[1]}) =  &CEC_MSG_CLEAR_DIGITAL_TIMER;  ($msg->{msg[2]}) = $day;  ($msg->{msg[3]}) = $month;  ($msg->{msg[4]}) = (($start_hr / 10) << 4) | ($start_hr % 10);  ($msg->{msg[5]}) = (($start_min / 10) << 4) | ($start_min % 10);  ($msg->{msg[6]}) = (($duration_hr / 10) << 4) | ($duration_hr % 10);  ($msg->{msg[7]}) = (($duration_min / 10) << 4) | ($duration_min % 10);  ($msg->{msg[8]}) = $recording_seq;  &cec_set_digital_service_id( ($msg->{msg}) + 9, $digital); });
    }' unless defined(&cec_msg_clear_digital_timer);
    eval 'sub cec_ops_clear_digital_timer {
        my($msg,$day,$month,$start_hr,$start_min,$duration_hr,$duration_min,$recording_seq,$digital) = @_;
	    eval q({ *$day =  ($msg->{msg[2]}); *$month =  ($msg->{msg[3]}); *$start_hr = ( ($msg->{msg[4]}) >> 4) * 10+ ( ($msg->{msg[4]}) & 0xf); *$start_min = ( ($msg->{msg[5]}) >> 4) * 10+ ( ($msg->{msg[5]}) & 0xf); *$duration_hr = ( ($msg->{msg[6]}) >> 4) * 10+ ( ($msg->{msg[6]}) & 0xf); *$duration_min = ( ($msg->{msg[7]}) >> 4) * 10+ ( ($msg->{msg[7]}) & 0xf); *$recording_seq =  ($msg->{msg[8]});  &cec_get_digital_service_id( ($msg->{msg}) + 9, $digital); });
    }' unless defined(&cec_ops_clear_digital_timer);
    eval 'sub cec_msg_clear_ext_timer {
        my($msg,$reply,$day,$month,$start_hr,$start_min,$duration_hr,$duration_min,$recording_seq,$ext_src_spec,$plug,$phys_addr) = @_;
	    eval q({  ($msg->{len}) = 13;  ($msg->{msg[1]}) =  &CEC_MSG_CLEAR_EXT_TIMER;  ($msg->{msg[2]}) = $day;  ($msg->{msg[3]}) = $month;  ($msg->{msg[4]}) = (($start_hr / 10) << 4) | ($start_hr % 10);  ($msg->{msg[5]}) = (($start_min / 10) << 4) | ($start_min % 10);  ($msg->{msg[6]}) = (($duration_hr / 10) << 4) | ($duration_hr % 10);  ($msg->{msg[7]}) = (($duration_min / 10) << 4) | ($duration_min % 10);  ($msg->{msg[8]}) = $recording_seq;  ($msg->{msg[9]}) = $ext_src_spec;  ($msg->{msg[10]}) = $plug;  ($msg->{msg[11]}) = $phys_addr >> 8;  ($msg->{msg[12]}) = $phys_addr & 0xff;  ($msg->{reply}) = $reply ?  &CEC_MSG_TIMER_CLEARED_STATUS : 0; });
    }' unless defined(&cec_msg_clear_ext_timer);
    eval 'sub cec_ops_clear_ext_timer {
        my($msg,$day,$month,$start_hr,$start_min,$duration_hr,$duration_min,$recording_seq,$ext_src_spec,$plug,$phys_addr) = @_;
	    eval q({ *$day =  ($msg->{msg[2]}); *$month =  ($msg->{msg[3]}); *$start_hr = ( ($msg->{msg[4]}) >> 4) * 10+ ( ($msg->{msg[4]}) & 0xf); *$start_min = ( ($msg->{msg[5]}) >> 4) * 10+ ( ($msg->{msg[5]}) & 0xf); *$duration_hr = ( ($msg->{msg[6]}) >> 4) * 10+ ( ($msg->{msg[6]}) & 0xf); *$duration_min = ( ($msg->{msg[7]}) >> 4) * 10+ ( ($msg->{msg[7]}) & 0xf); *$recording_seq =  ($msg->{msg[8]}); *$ext_src_spec =  ($msg->{msg[9]}); *$plug =  ($msg->{msg[10]}); *$phys_addr = ( ($msg->{msg[11]}) << 8) |  ($msg->{msg[12]}); });
    }' unless defined(&cec_ops_clear_ext_timer);
    eval 'sub cec_msg_set_analogue_timer {
        my($msg,$reply,$day,$month,$start_hr,$start_min,$duration_hr,$duration_min,$recording_seq,$ana_bcast_type,$ana_freq,$bcast_system) = @_;
	    eval q({  ($msg->{len}) = 13;  ($msg->{msg[1]}) =  &CEC_MSG_SET_ANALOGUE_TIMER;  ($msg->{msg[2]}) = $day;  ($msg->{msg[3]}) = $month;  ($msg->{msg[4]}) = (($start_hr / 10) << 4) | ($start_hr % 10);  ($msg->{msg[5]}) = (($start_min / 10) << 4) | ($start_min % 10);  ($msg->{msg[6]}) = (($duration_hr / 10) << 4) | ($duration_hr % 10);  ($msg->{msg[7]}) = (($duration_min / 10) << 4) | ($duration_min % 10);  ($msg->{msg[8]}) = $recording_seq;  ($msg->{msg[9]}) = $ana_bcast_type;  ($msg->{msg[10]}) = $ana_freq >> 8;  ($msg->{msg[11]}) = $ana_freq & 0xff;  ($msg->{msg[12]}) = $bcast_system;  ($msg->{reply}) = $reply ?  &CEC_MSG_TIMER_STATUS : 0; });
    }' unless defined(&cec_msg_set_analogue_timer);
    eval 'sub cec_ops_set_analogue_timer {
        my($msg,$day,$month,$start_hr,$start_min,$duration_hr,$duration_min,$recording_seq,$ana_bcast_type,$ana_freq,$bcast_system) = @_;
	    eval q({ *$day =  ($msg->{msg[2]}); *$month =  ($msg->{msg[3]}); *$start_hr = ( ($msg->{msg[4]}) >> 4) * 10+ ( ($msg->{msg[4]}) & 0xf); *$start_min = ( ($msg->{msg[5]}) >> 4) * 10+ ( ($msg->{msg[5]}) & 0xf); *$duration_hr = ( ($msg->{msg[6]}) >> 4) * 10+ ( ($msg->{msg[6]}) & 0xf); *$duration_min = ( ($msg->{msg[7]}) >> 4) * 10+ ( ($msg->{msg[7]}) & 0xf); *$recording_seq =  ($msg->{msg[8]}); *$ana_bcast_type =  ($msg->{msg[9]}); *$ana_freq = ( ($msg->{msg[10]}) << 8) |  ($msg->{msg[11]}); *$bcast_system =  ($msg->{msg[12]}); });
    }' unless defined(&cec_ops_set_analogue_timer);
    eval 'sub cec_msg_set_digital_timer {
        my($msg,$reply,$day,$month,$start_hr,$start_min,$duration_hr,$duration_min,$recording_seq,$digital) = @_;
	    eval q({  ($msg->{len}) = 16;  ($msg->{reply}) = $reply ?  &CEC_MSG_TIMER_STATUS : 0;  ($msg->{msg[1]}) =  &CEC_MSG_SET_DIGITAL_TIMER;  ($msg->{msg[2]}) = $day;  ($msg->{msg[3]}) = $month;  ($msg->{msg[4]}) = (($start_hr / 10) << 4) | ($start_hr % 10);  ($msg->{msg[5]}) = (($start_min / 10) << 4) | ($start_min % 10);  ($msg->{msg[6]}) = (($duration_hr / 10) << 4) | ($duration_hr % 10);  ($msg->{msg[7]}) = (($duration_min / 10) << 4) | ($duration_min % 10);  ($msg->{msg[8]}) = $recording_seq;  &cec_set_digital_service_id( ($msg->{msg}) + 9, $digital); });
    }' unless defined(&cec_msg_set_digital_timer);
    eval 'sub cec_ops_set_digital_timer {
        my($msg,$day,$month,$start_hr,$start_min,$duration_hr,$duration_min,$recording_seq,$digital) = @_;
	    eval q({ *$day =  ($msg->{msg[2]}); *$month =  ($msg->{msg[3]}); *$start_hr = ( ($msg->{msg[4]}) >> 4) * 10+ ( ($msg->{msg[4]}) & 0xf); *$start_min = ( ($msg->{msg[5]}) >> 4) * 10+ ( ($msg->{msg[5]}) & 0xf); *$duration_hr = ( ($msg->{msg[6]}) >> 4) * 10+ ( ($msg->{msg[6]}) & 0xf); *$duration_min = ( ($msg->{msg[7]}) >> 4) * 10+ ( ($msg->{msg[7]}) & 0xf); *$recording_seq =  ($msg->{msg[8]});  &cec_get_digital_service_id( ($msg->{msg}) + 9, $digital); });
    }' unless defined(&cec_ops_set_digital_timer);
    eval 'sub cec_msg_set_ext_timer {
        my($msg,$reply,$day,$month,$start_hr,$start_min,$duration_hr,$duration_min,$recording_seq,$ext_src_spec,$plug,$phys_addr) = @_;
	    eval q({  ($msg->{len}) = 13;  ($msg->{msg[1]}) =  &CEC_MSG_SET_EXT_TIMER;  ($msg->{msg[2]}) = $day;  ($msg->{msg[3]}) = $month;  ($msg->{msg[4]}) = (($start_hr / 10) << 4) | ($start_hr % 10);  ($msg->{msg[5]}) = (($start_min / 10) << 4) | ($start_min % 10);  ($msg->{msg[6]}) = (($duration_hr / 10) << 4) | ($duration_hr % 10);  ($msg->{msg[7]}) = (($duration_min / 10) << 4) | ($duration_min % 10);  ($msg->{msg[8]}) = $recording_seq;  ($msg->{msg[9]}) = $ext_src_spec;  ($msg->{msg[10]}) = $plug;  ($msg->{msg[11]}) = $phys_addr >> 8;  ($msg->{msg[12]}) = $phys_addr & 0xff;  ($msg->{reply}) = $reply ?  &CEC_MSG_TIMER_STATUS : 0; });
    }' unless defined(&cec_msg_set_ext_timer);
    eval 'sub cec_ops_set_ext_timer {
        my($msg,$day,$month,$start_hr,$start_min,$duration_hr,$duration_min,$recording_seq,$ext_src_spec,$plug,$phys_addr) = @_;
	    eval q({ *$day =  ($msg->{msg[2]}); *$month =  ($msg->{msg[3]}); *$start_hr = ( ($msg->{msg[4]}) >> 4) * 10+ ( ($msg->{msg[4]}) & 0xf); *$start_min = ( ($msg->{msg[5]}) >> 4) * 10+ ( ($msg->{msg[5]}) & 0xf); *$duration_hr = ( ($msg->{msg[6]}) >> 4) * 10+ ( ($msg->{msg[6]}) & 0xf); *$duration_min = ( ($msg->{msg[7]}) >> 4) * 10+ ( ($msg->{msg[7]}) & 0xf); *$recording_seq =  ($msg->{msg[8]}); *$ext_src_spec =  ($msg->{msg[9]}); *$plug =  ($msg->{msg[10]}); *$phys_addr = ( ($msg->{msg[11]}) << 8) |  ($msg->{msg[12]}); });
    }' unless defined(&cec_ops_set_ext_timer);
    eval 'sub cec_msg_set_timer_program_title {
        my($msg,$prog_title) = @_;
	    eval q({ my $len =  &strlen($prog_title);  &if ( $len > 14)  $len = 14;  ($msg->{len}) = 2+  $len;  ($msg->{msg[1]}) =  &CEC_MSG_SET_TIMER_PROGRAM_TITLE;  &memcpy( ($msg->{msg}) + 2, $prog_title,  $len); });
    }' unless defined(&cec_msg_set_timer_program_title);
    eval 'sub cec_ops_set_timer_program_title {
        my($msg,$prog_title) = @_;
	    eval q({ my $len =  ($msg->{len}) > 2?  ($msg->{len}) - 2: 0;  &if ( $len > 14)  $len = 14;  &memcpy($prog_title,  ($msg->{msg}) + 2,  $len); $prog_title->[ $len] = ord(\'\\\\0\'); });
    }' unless defined(&cec_ops_set_timer_program_title);
    eval 'sub cec_ops_cec_version {
        my($msg,$cec_version) = @_;
	    eval q({ *$cec_version =  ($msg->{msg[2]}); });
    }' unless defined(&cec_ops_cec_version);
    eval 'sub cec_msg_get_cec_version {
        my($msg,$reply) = @_;
	    eval q({  ($msg->{len}) = 2;  ($msg->{msg[1]}) =  &CEC_MSG_GET_CEC_VERSION;  ($msg->{reply}) = $reply ?  &CEC_MSG_CEC_VERSION : 0; });
    }' unless defined(&cec_msg_get_cec_version);
    eval 'sub cec_msg_report_physical_addr {
        my($msg,$phys_addr,$prim_devtype) = @_;
	    eval q({  ($msg->{len}) = 5;  ($msg->{msg[0]}) |= 0xf;  ($msg->{msg[1]}) =  &CEC_MSG_REPORT_PHYSICAL_ADDR;  ($msg->{msg[2]}) = $phys_addr >> 8;  ($msg->{msg[3]}) = $phys_addr & 0xff;  ($msg->{msg[4]}) = $prim_devtype; });
    }' unless defined(&cec_msg_report_physical_addr);
    eval 'sub cec_ops_report_physical_addr {
        my($msg,$phys_addr,$prim_devtype) = @_;
	    eval q({ *$phys_addr = ( ($msg->{msg[2]}) << 8) |  ($msg->{msg[3]}); *$prim_devtype =  ($msg->{msg[4]}); });
    }' unless defined(&cec_ops_report_physical_addr);
    eval 'sub cec_msg_give_physical_addr {
        my($msg,$reply) = @_;
	    eval q({  ($msg->{len}) = 2;  ($msg->{msg[1]}) =  &CEC_MSG_GIVE_PHYSICAL_ADDR;  ($msg->{reply}) = $reply ?  &CEC_MSG_REPORT_PHYSICAL_ADDR : 0; });
    }' unless defined(&cec_msg_give_physical_addr);
    eval 'sub cec_msg_set_menu_language {
        my($msg,$language) = @_;
	    eval q({  ($msg->{len}) = 5;  ($msg->{msg[0]}) |= 0xf;  ($msg->{msg[1]}) =  &CEC_MSG_SET_MENU_LANGUAGE;  &memcpy( ($msg->{msg}) + 2, $language, 3); });
    }' unless defined(&cec_msg_set_menu_language);
    eval 'sub cec_ops_set_menu_language {
        my($msg,$language) = @_;
	    eval q({  &memcpy($language,  ($msg->{msg}) + 2, 3); $language->[3] = ord(\'\\\\0\'); });
    }' unless defined(&cec_ops_set_menu_language);
    eval 'sub cec_msg_get_menu_language {
        my($msg,$reply) = @_;
	    eval q({  ($msg->{len}) = 2;  ($msg->{msg[1]}) =  &CEC_MSG_GET_MENU_LANGUAGE;  ($msg->{reply}) = $reply ?  &CEC_MSG_SET_MENU_LANGUAGE : 0; });
    }' unless defined(&cec_msg_get_menu_language);
    eval 'sub cec_ops_report_features {
        my($msg,$cec_version,$all_device_types,$rc_profile,$dev_features) = @_;
	    eval q({  &const  &__u8 * &p =  ($msg->{msg[4]}); *$cec_version =  ($msg->{msg[2]}); *$all_device_types =  ($msg->{msg[3]}); *$rc_profile =  &p; *$dev_features =  &NULL;  &while ( &p <  ($msg->{msg[14]})  && (* &p &  &CEC_OP_FEAT_EXT))  &p++;  &if (!(* &p &  &CEC_OP_FEAT_EXT)) { *$dev_features =  &p + 1;  &while ( &p <  ($msg->{msg[15]})  && (* &p &  &CEC_OP_FEAT_EXT))  &p++; }  &if (* &p &  &CEC_OP_FEAT_EXT) *$rc_profile = *$dev_features =  &NULL; });
    }' unless defined(&cec_ops_report_features);
    eval 'sub cec_msg_give_features {
        my($msg,$reply) = @_;
	    eval q({  ($msg->{len}) = 2;  ($msg->{msg[1]}) =  &CEC_MSG_GIVE_FEATURES;  ($msg->{reply}) = $reply ?  &CEC_MSG_REPORT_FEATURES : 0; });
    }' unless defined(&cec_msg_give_features);
    eval 'sub cec_ops_deck_control {
        my($msg,$deck_control_mode) = @_;
	    eval q({ *$deck_control_mode =  ($msg->{msg[2]}); });
    }' unless defined(&cec_ops_deck_control);
    eval 'sub cec_msg_deck_status {
        my($msg,$deck_info) = @_;
	    eval q({  ($msg->{len}) = 3;  ($msg->{msg[1]}) =  &CEC_MSG_DECK_STATUS;  ($msg->{msg[2]}) = $deck_info; });
    }' unless defined(&cec_msg_deck_status);
    eval 'sub cec_ops_deck_status {
        my($msg,$deck_info) = @_;
	    eval q({ *$deck_info =  ($msg->{msg[2]}); });
    }' unless defined(&cec_ops_deck_status);
    eval 'sub cec_msg_give_deck_status {
        my($msg,$reply,$status_req) = @_;
	    eval q({  ($msg->{len}) = 3;  ($msg->{msg[1]}) =  &CEC_MSG_GIVE_DECK_STATUS;  ($msg->{msg[2]}) = $status_req;  ($msg->{reply}) = $reply ?  &CEC_MSG_DECK_STATUS : 0; });
    }' unless defined(&cec_msg_give_deck_status);
    eval 'sub cec_ops_give_deck_status {
        my($msg,$status_req) = @_;
	    eval q({ *$status_req =  ($msg->{msg[2]}); });
    }' unless defined(&cec_ops_give_deck_status);
    eval 'sub cec_msg_play {
        my($msg,$play_mode) = @_;
	    eval q({  ($msg->{len}) = 3;  ($msg->{msg[1]}) =  &CEC_MSG_PLAY;  ($msg->{msg[2]}) = $play_mode; });
    }' unless defined(&cec_msg_play);
    eval 'sub cec_ops_play {
        my($msg,$play_mode) = @_;
	    eval q({ *$play_mode =  ($msg->{msg[2]}); });
    }' unless defined(&cec_ops_play);
    eval 'sub cec_msg_tuner_device_status_analog {
        my($msg,$rec_flag,$tuner_display_info,$ana_bcast_type,$ana_freq,$bcast_system) = @_;
	    eval q({  ($msg->{len}) = 7;  ($msg->{msg[1]}) =  &CEC_MSG_TUNER_DEVICE_STATUS;  ($msg->{msg[2]}) = ($rec_flag << 7) | $tuner_display_info;  ($msg->{msg[3]}) = $ana_bcast_type;  ($msg->{msg[4]}) = $ana_freq >> 8;  ($msg->{msg[5]}) = $ana_freq & 0xff;  ($msg->{msg[6]}) = $bcast_system; });
    }' unless defined(&cec_msg_tuner_device_status_analog);
    eval 'sub cec_msg_tuner_device_status_digital {
        my($msg,$rec_flag,$tuner_display_info,$digital) = @_;
	    eval q({  ($msg->{len}) = 10;  ($msg->{msg[1]}) =  &CEC_MSG_TUNER_DEVICE_STATUS;  ($msg->{msg[2]}) = ($rec_flag << 7) | $tuner_display_info;  &cec_set_digital_service_id( ($msg->{msg}) + 3, $digital); });
    }' unless defined(&cec_msg_tuner_device_status_digital);
    eval 'sub cec_msg_tuner_device_status {
        my($msg,$tuner_dev_info) = @_;
	    eval q({  &if ( ($tuner_dev_info->{is_analog}))  &cec_msg_tuner_device_status_analog($msg,  ($tuner_dev_info->{rec_flag}),  ($tuner_dev_info->{tuner_display_info}),  ($tuner_dev_info->{analog}->{ana_bcast_type}),  ($tuner_dev_info->{analog}->{ana_freq}),  ($tuner_dev_info->{analog}->{bcast_system}));  &else  &cec_msg_tuner_device_status_digital($msg,  ($tuner_dev_info->{rec_flag}),  ($tuner_dev_info->{tuner_display_info}),  ($tuner_dev_info->{digital})); });
    }' unless defined(&cec_msg_tuner_device_status);
    eval 'sub cec_ops_tuner_device_status {
        my($msg,$tuner_dev_info) = @_;
	    eval q({  ($tuner_dev_info->{is_analog}) =  ($msg->{len}) < 10;  ($tuner_dev_info->{rec_flag}) =  ($msg->{msg[2]}) >> 7;  ($tuner_dev_info->{tuner_display_info}) =  ($msg->{msg[2]}) & 0x7f;  &if ( ($tuner_dev_info->{is_analog})) {  ($tuner_dev_info->{analog}->{ana_bcast_type}) =  ($msg->{msg[3]});  ($tuner_dev_info->{analog}->{ana_freq}) = ( ($msg->{msg[4]}) << 8) |  ($msg->{msg[5]});  ($tuner_dev_info->{analog}->{bcast_system}) =  ($msg->{msg[6]}); ; }  &cec_get_digital_service_id( ($msg->{msg}) + 3,  ($tuner_dev_info->{digital})); });
    }' unless defined(&cec_ops_tuner_device_status);
    eval 'sub cec_msg_give_tuner_device_status {
        my($msg,$reply,$status_req) = @_;
	    eval q({  ($msg->{len}) = 3;  ($msg->{msg[1]}) =  &CEC_MSG_GIVE_TUNER_DEVICE_STATUS;  ($msg->{msg[2]}) = $status_req;  ($msg->{reply}) = $reply ?  &CEC_MSG_TUNER_DEVICE_STATUS : 0; });
    }' unless defined(&cec_msg_give_tuner_device_status);
    eval 'sub cec_ops_give_tuner_device_status {
        my($msg,$status_req) = @_;
	    eval q({ *$status_req =  ($msg->{msg[2]}); });
    }' unless defined(&cec_ops_give_tuner_device_status);
    eval 'sub cec_msg_select_analogue_service {
        my($msg,$ana_bcast_type,$ana_freq,$bcast_system) = @_;
	    eval q({  ($msg->{len}) = 6;  ($msg->{msg[1]}) =  &CEC_MSG_SELECT_ANALOGUE_SERVICE;  ($msg->{msg[2]}) = $ana_bcast_type;  ($msg->{msg[3]}) = $ana_freq >> 8;  ($msg->{msg[4]}) = $ana_freq & 0xff;  ($msg->{msg[5]}) = $bcast_system; });
    }' unless defined(&cec_msg_select_analogue_service);
    eval 'sub cec_ops_select_analogue_service {
        my($msg,$ana_bcast_type,$ana_freq,$bcast_system) = @_;
	    eval q({ *$ana_bcast_type =  ($msg->{msg[2]}); *$ana_freq = ( ($msg->{msg[3]}) << 8) |  ($msg->{msg[4]}); *$bcast_system =  ($msg->{msg[5]}); });
    }' unless defined(&cec_ops_select_analogue_service);
    eval 'sub cec_msg_select_digital_service {
        my($msg,$digital) = @_;
	    eval q({  ($msg->{len}) = 9;  ($msg->{msg[1]}) =  &CEC_MSG_SELECT_DIGITAL_SERVICE;  &cec_set_digital_service_id( ($msg->{msg}) + 2, $digital); });
    }' unless defined(&cec_msg_select_digital_service);
    eval 'sub cec_ops_select_digital_service {
        my($msg,$digital) = @_;
	    eval q({  &cec_get_digital_service_id( ($msg->{msg}) + 2, $digital); });
    }' unless defined(&cec_ops_select_digital_service);
    eval 'sub cec_msg_tuner_step_decrement {
        my($msg) = @_;
	    eval q({  ($msg->{len}) = 2;  ($msg->{msg[1]}) =  &CEC_MSG_TUNER_STEP_DECREMENT; });
    }' unless defined(&cec_msg_tuner_step_decrement);
    eval 'sub cec_msg_tuner_step_increment {
        my($msg) = @_;
	    eval q({  ($msg->{len}) = 2;  ($msg->{msg[1]}) =  &CEC_MSG_TUNER_STEP_INCREMENT; });
    }' unless defined(&cec_msg_tuner_step_increment);
    eval 'sub cec_ops_device_vendor_id {
        my($msg,$vendor_id) = @_;
	    eval q({ *$vendor_id = ( ($msg->{msg[2]}) << 16) | ( ($msg->{msg[3]}) << 8) |  ($msg->{msg[4]}); });
    }' unless defined(&cec_ops_device_vendor_id);
    eval 'sub cec_msg_give_device_vendor_id {
        my($msg,$reply) = @_;
	    eval q({  ($msg->{len}) = 2;  ($msg->{msg[1]}) =  &CEC_MSG_GIVE_DEVICE_VENDOR_ID;  ($msg->{reply}) = $reply ?  &CEC_MSG_DEVICE_VENDOR_ID : 0; });
    }' unless defined(&cec_msg_give_device_vendor_id);
    eval 'sub cec_msg_vendor_command {
        my($msg,$size,$vendor_cmd) = @_;
	    eval q({  &if ($size > 14) $size = 14;  ($msg->{len}) = 2+ $size;  ($msg->{msg[1]}) =  &CEC_MSG_VENDOR_COMMAND;  &memcpy( ($msg->{msg}) + 2, $vendor_cmd, $size); });
    }' unless defined(&cec_msg_vendor_command);
    eval 'sub cec_ops_vendor_command {
        my($msg,$size,$vendor_cmd) = @_;
	    eval q({ *$size =  ($msg->{len}) - 2;  &if (*$size > 14) *$size = 14; *$vendor_cmd =  ($msg->{msg}) + 2; });
    }' unless defined(&cec_ops_vendor_command);
    eval 'sub cec_msg_vendor_command_with_id {
        my($msg,$vendor_id,$size,$vendor_cmd) = @_;
	    eval q({  &if ($size > 11) $size = 11;  ($msg->{len}) = 5+ $size;  ($msg->{msg[1]}) =  &CEC_MSG_VENDOR_COMMAND_WITH_ID;  ($msg->{msg[2]}) = $vendor_id >> 16;  ($msg->{msg[3]}) = ($vendor_id >> 8) & 0xff;  ($msg->{msg[4]}) = $vendor_id & 0xff;  &memcpy( ($msg->{msg}) + 5, $vendor_cmd, $size); });
    }' unless defined(&cec_msg_vendor_command_with_id);
    eval 'sub cec_ops_vendor_command_with_id {
        my($msg,$vendor_id,$size,$vendor_cmd) = @_;
	    eval q({ *$size =  ($msg->{len}) - 5;  &if (*$size > 11) *$size = 11; *$vendor_id = ( ($msg->{msg[2]}) << 16) | ( ($msg->{msg[3]}) << 8) |  ($msg->{msg[4]}); *$vendor_cmd =  ($msg->{msg}) + 5; });
    }' unless defined(&cec_ops_vendor_command_with_id);
    eval 'sub cec_msg_vendor_remote_button_down {
        my($msg,$size,$rc_code) = @_;
	    eval q({  &if ($size > 14) $size = 14;  ($msg->{len}) = 2+ $size;  ($msg->{msg[1]}) =  &CEC_MSG_VENDOR_REMOTE_BUTTON_DOWN;  &memcpy( ($msg->{msg}) + 2, $rc_code, $size); });
    }' unless defined(&cec_msg_vendor_remote_button_down);
    eval 'sub cec_ops_vendor_remote_button_down {
        my($msg,$size,$rc_code) = @_;
	    eval q({ *$size =  ($msg->{len}) - 2;  &if (*$size > 14) *$size = 14; *$rc_code =  ($msg->{msg}) + 2; });
    }' unless defined(&cec_ops_vendor_remote_button_down);
    eval 'sub cec_msg_vendor_remote_button_up {
        my($msg) = @_;
	    eval q({  ($msg->{len}) = 2;  ($msg->{msg[1]}) =  &CEC_MSG_VENDOR_REMOTE_BUTTON_UP; });
    }' unless defined(&cec_msg_vendor_remote_button_up);
    eval 'sub cec_ops_set_osd_string {
        my($msg,$disp_ctl,$osd) = @_;
	    eval q({ my $len =  ($msg->{len}) > 3?  ($msg->{len}) - 3: 0; *$disp_ctl =  ($msg->{msg[2]});  &if ( $len > 13)  $len = 13;  &memcpy($osd,  ($msg->{msg}) + 3,  $len); $osd->[ $len] = ord(\'\\\\0\'); });
    }' unless defined(&cec_ops_set_osd_string);
    eval 'sub cec_ops_set_osd_name {
        my($msg,$name) = @_;
	    eval q({ my $len =  ($msg->{len}) > 2?  ($msg->{len}) - 2: 0;  &if ( $len > 14)  $len = 14;  &memcpy($name,  ($msg->{msg}) + 2,  $len); $name->[ $len] = ord(\'\\\\0\'); });
    }' unless defined(&cec_ops_set_osd_name);
    eval 'sub cec_msg_give_osd_name {
        my($msg,$reply) = @_;
	    eval q({  ($msg->{len}) = 2;  ($msg->{msg[1]}) =  &CEC_MSG_GIVE_OSD_NAME;  ($msg->{reply}) = $reply ?  &CEC_MSG_SET_OSD_NAME : 0; });
    }' unless defined(&cec_msg_give_osd_name);
    eval 'sub cec_ops_menu_status {
        my($msg,$menu_state) = @_;
	    eval q({ *$menu_state =  ($msg->{msg[2]}); });
    }' unless defined(&cec_ops_menu_status);
    eval 'sub cec_msg_menu_request {
        my($msg,$reply,$menu_req) = @_;
	    eval q({  ($msg->{len}) = 3;  ($msg->{msg[1]}) =  &CEC_MSG_MENU_REQUEST;  ($msg->{msg[2]}) = $menu_req;  ($msg->{reply}) = $reply ?  &CEC_MSG_MENU_STATUS : 0; });
    }' unless defined(&cec_msg_menu_request);
    eval 'sub cec_ops_menu_request {
        my($msg,$menu_req) = @_;
	    eval q({ *$menu_req =  ($msg->{msg[2]}); });
    }' unless defined(&cec_ops_menu_request);
    eval 'sub cec_msg_user_control_pressed {
        my($msg,$ui_cmd) = @_;
	    eval q({  ($msg->{len}) = 3;  ($msg->{msg[1]}) =  &CEC_MSG_USER_CONTROL_PRESSED;  ($msg->{msg[2]}) =  ($ui_cmd->{ui_cmd});  &if (! ($ui_cmd->{has_opt_arg})) ;  &switch ( ($ui_cmd->{ui_cmd})) {  &case 0x56:  &case 0x57:  &case 0x60:  &case 0x68:  &case 0x69:  &case 0x6a:  ($msg->{len})++;  ($msg->{msg[3]}) =  ($ui_cmd->{play_mode});  &break;  &case 0x67:  ($msg->{len}) += 4;  ($msg->{msg[3]}) = ( ($ui_cmd->{channel_identifier}->{channel_number_fmt}) << 2) | ( ($ui_cmd->{channel_identifier}->{major}) >> 8);  ($msg->{msg[4]}) =  ($ui_cmd->{channel_identifier}->{major}) & 0xff;  ($msg->{msg[5]}) =  ($ui_cmd->{channel_identifier}->{minor}) >> 8;  ($msg->{msg[6]}) =  ($ui_cmd->{channel_identifier}->{minor}) & 0xff;  &break; } });
    }' unless defined(&cec_msg_user_control_pressed);
    eval 'sub cec_ops_user_control_pressed {
        my($msg,$ui_cmd) = @_;
	    eval q({  ($ui_cmd->{ui_cmd}) =  ($msg->{msg[2]});  ($ui_cmd->{has_opt_arg}) = 0;  &if ( ($msg->{len}) == 3) ;  &switch ( ($ui_cmd->{ui_cmd})) {  &case 0x56:  &case 0x57:  &case 0x60:  &case 0x68:  &case 0x69:  &case 0x6a:  ($ui_cmd->{play_mode}) =  ($msg->{msg[3]});  ($ui_cmd->{has_opt_arg}) = 1;  &break;  &case 0x67:  &if ( ($msg->{len}) < 7)  &break;  ($ui_cmd->{has_opt_arg}) = 1;  ($ui_cmd->{channel_identifier}->{channel_number_fmt}) =  ($msg->{msg[3]}) >> 2;  ($ui_cmd->{channel_identifier}->{major}) = (( ($msg->{msg[3]}) & 3) << 6) |  ($msg->{msg[4]});  ($ui_cmd->{channel_identifier}->{minor}) = ( ($msg->{msg[5]}) << 8) |  ($msg->{msg[6]});  &break; } });
    }' unless defined(&cec_ops_user_control_pressed);
    eval 'sub cec_msg_user_control_released {
        my($msg) = @_;
	    eval q({  ($msg->{len}) = 2;  ($msg->{msg[1]}) =  &CEC_MSG_USER_CONTROL_RELEASED; });
    }' unless defined(&cec_msg_user_control_released);
    eval 'sub cec_ops_report_power_status {
        my($msg,$pwr_state) = @_;
	    eval q({ *$pwr_state =  ($msg->{msg[2]}); });
    }' unless defined(&cec_ops_report_power_status);
    eval 'sub cec_msg_give_device_power_status {
        my($msg,$reply) = @_;
	    eval q({  ($msg->{len}) = 2;  ($msg->{msg[1]}) =  &CEC_MSG_GIVE_DEVICE_POWER_STATUS;  ($msg->{reply}) = $reply ?  &CEC_MSG_REPORT_POWER_STATUS : 0; });
    }' unless defined(&cec_msg_give_device_power_status);
    eval 'sub cec_ops_feature_abort {
        my($msg,$abort_msg,$reason) = @_;
	    eval q({ *$abort_msg =  ($msg->{msg[2]}); *$reason =  ($msg->{msg[3]}); });
    }' unless defined(&cec_ops_feature_abort);
    eval 'sub cec_msg_abort {
        my($msg) = @_;
	    eval q({  ($msg->{len}) = 2;  ($msg->{msg[1]}) =  &CEC_MSG_ABORT; });
    }' unless defined(&cec_msg_abort);
    eval 'sub cec_ops_report_audio_status {
        my($msg,$aud_mute_status,$aud_vol_status) = @_;
	    eval q({ *$aud_mute_status =  ($msg->{msg[2]}) >> 7; *$aud_vol_status =  ($msg->{msg[2]}) & 0x7f; });
    }' unless defined(&cec_ops_report_audio_status);
    eval 'sub cec_msg_give_audio_status {
        my($msg,$reply) = @_;
	    eval q({  ($msg->{len}) = 2;  ($msg->{msg[1]}) =  &CEC_MSG_GIVE_AUDIO_STATUS;  ($msg->{reply}) = $reply ?  &CEC_MSG_REPORT_AUDIO_STATUS : 0; });
    }' unless defined(&cec_msg_give_audio_status);
    eval 'sub cec_msg_set_system_audio_mode {
        my($msg,$sys_aud_status) = @_;
	    eval q({  ($msg->{len}) = 3;  ($msg->{msg[1]}) =  &CEC_MSG_SET_SYSTEM_AUDIO_MODE;  ($msg->{msg[2]}) = $sys_aud_status; });
    }' unless defined(&cec_msg_set_system_audio_mode);
    eval 'sub cec_ops_set_system_audio_mode {
        my($msg,$sys_aud_status) = @_;
	    eval q({ *$sys_aud_status =  ($msg->{msg[2]}); });
    }' unless defined(&cec_ops_set_system_audio_mode);
    eval 'sub cec_msg_system_audio_mode_request {
        my($msg,$reply,$phys_addr) = @_;
	    eval q({  ($msg->{len}) = $phys_addr == 0xffff ? 2: 4;  ($msg->{msg[1]}) =  &CEC_MSG_SYSTEM_AUDIO_MODE_REQUEST;  ($msg->{msg[2]}) = $phys_addr >> 8;  ($msg->{msg[3]}) = $phys_addr & 0xff;  ($msg->{reply}) = $reply ?  &CEC_MSG_SET_SYSTEM_AUDIO_MODE : 0; });
    }' unless defined(&cec_msg_system_audio_mode_request);
    eval 'sub cec_ops_system_audio_mode_request {
        my($msg,$phys_addr) = @_;
	    eval q({  &if ( ($msg->{len}) < 4) *$phys_addr = 0xffff;  &else *$phys_addr = ( ($msg->{msg[2]}) << 8) |  ($msg->{msg[3]}); });
    }' unless defined(&cec_ops_system_audio_mode_request);
    eval 'sub cec_msg_system_audio_mode_status {
        my($msg,$sys_aud_status) = @_;
	    eval q({  ($msg->{len}) = 3;  ($msg->{msg[1]}) =  &CEC_MSG_SYSTEM_AUDIO_MODE_STATUS;  ($msg->{msg[2]}) = $sys_aud_status; });
    }' unless defined(&cec_msg_system_audio_mode_status);
    eval 'sub cec_ops_system_audio_mode_status {
        my($msg,$sys_aud_status) = @_;
	    eval q({ *$sys_aud_status =  ($msg->{msg[2]}); });
    }' unless defined(&cec_ops_system_audio_mode_status);
    eval 'sub cec_msg_give_system_audio_mode_status {
        my($msg,$reply) = @_;
	    eval q({  ($msg->{len}) = 2;  ($msg->{msg[1]}) =  &CEC_MSG_GIVE_SYSTEM_AUDIO_MODE_STATUS;  ($msg->{reply}) = $reply ?  &CEC_MSG_SYSTEM_AUDIO_MODE_STATUS : 0; });
    }' unless defined(&cec_msg_give_system_audio_mode_status);
    eval 'sub cec_msg_report_short_audio_descriptor {
        my($msg,$num_descriptors,$descriptors) = @_;
	    eval q({ my $i;  &if ($num_descriptors > 4) $num_descriptors = 4;  ($msg->{len}) = 2+ $num_descriptors * 3;  ($msg->{msg[1]}) =  &CEC_MSG_REPORT_SHORT_AUDIO_DESCRIPTOR;  &for ( $i = 0;  $i < $num_descriptors;  $i++) {  ($msg->{msg[2 + i * 3]}) = ($descriptors->[ $i] >> 16) & 0xff;  ($msg->{msg[3 + i * 3]}) = ($descriptors->[ $i] >> 8) & 0xff;  ($msg->{msg[4 + i * 3]}) = $descriptors->[ $i] & 0xff; } });
    }' unless defined(&cec_msg_report_short_audio_descriptor);
    eval 'sub cec_ops_report_short_audio_descriptor {
        my($msg,$num_descriptors,$descriptors) = @_;
	    eval q({ my $i; *$num_descriptors = ( ($msg->{len}) - 2) / 3;  &if (*$num_descriptors > 4) *$num_descriptors = 4;  &for ( $i = 0;  $i < *$num_descriptors;  $i++) $descriptors->[ $i] = ( ($msg->{msg[2 + i * 3]}) << 16) | ( ($msg->{msg[3 + i * 3]}) << 8) |  ($msg->{msg[4 + i * 3]}); });
    }' unless defined(&cec_ops_report_short_audio_descriptor);
    eval 'sub cec_msg_request_short_audio_descriptor {
        my($msg,$reply,$num_descriptors,$audio_format_id,$audio_format_code) = @_;
	    eval q({ my $i;  &if ($num_descriptors > 4) $num_descriptors = 4;  ($msg->{len}) = 2+ $num_descriptors;  ($msg->{msg[1]}) =  &CEC_MSG_REQUEST_SHORT_AUDIO_DESCRIPTOR;  ($msg->{reply}) = $reply ?  &CEC_MSG_REPORT_SHORT_AUDIO_DESCRIPTOR : 0;  &for ( $i = 0;  $i < $num_descriptors;  $i++)  ($msg->{msg[2 + i]}) = ($audio_format_id->[ $i] << 6) | ($audio_format_code->[ $i] & 0x3f); });
    }' unless defined(&cec_msg_request_short_audio_descriptor);
    eval 'sub cec_ops_request_short_audio_descriptor {
        my($msg,$num_descriptors,$audio_format_id,$audio_format_code) = @_;
	    eval q({ my $i; *$num_descriptors =  ($msg->{len}) - 2;  &if (*$num_descriptors > 4) *$num_descriptors = 4;  &for ( $i = 0;  $i < *$num_descriptors;  $i++) { $audio_format_id->[ $i] =  ($msg->{msg[2 + i]}) >> 6; $audio_format_code->[ $i] =  ($msg->{msg[2 + i]}) & 0x3f; } });
    }' unless defined(&cec_ops_request_short_audio_descriptor);
    eval 'sub cec_ops_set_audio_rate {
        my($msg,$audio_rate) = @_;
	    eval q({ *$audio_rate =  ($msg->{msg[2]}); });
    }' unless defined(&cec_ops_set_audio_rate);
    eval 'sub cec_msg_initiate_arc {
        my($msg,$reply) = @_;
	    eval q({  ($msg->{len}) = 2;  ($msg->{msg[1]}) =  &CEC_MSG_INITIATE_ARC;  ($msg->{reply}) = $reply ?  &CEC_MSG_REPORT_ARC_INITIATED : 0; });
    }' unless defined(&cec_msg_initiate_arc);
    eval 'sub cec_msg_request_arc_initiation {
        my($msg,$reply) = @_;
	    eval q({  ($msg->{len}) = 2;  ($msg->{msg[1]}) =  &CEC_MSG_REQUEST_ARC_INITIATION;  ($msg->{reply}) = $reply ?  &CEC_MSG_INITIATE_ARC : 0; });
    }' unless defined(&cec_msg_request_arc_initiation);
    eval 'sub cec_msg_report_arc_terminated {
        my($msg) = @_;
	    eval q({  ($msg->{len}) = 2;  ($msg->{msg[1]}) =  &CEC_MSG_REPORT_ARC_TERMINATED; });
    }' unless defined(&cec_msg_report_arc_terminated);
    eval 'sub cec_msg_terminate_arc {
        my($msg,$reply) = @_;
	    eval q({  ($msg->{len}) = 2;  ($msg->{msg[1]}) =  &CEC_MSG_TERMINATE_ARC;  ($msg->{reply}) = $reply ?  &CEC_MSG_REPORT_ARC_TERMINATED : 0; });
    }' unless defined(&cec_msg_terminate_arc);
    eval 'sub cec_msg_request_arc_termination {
        my($msg,$reply) = @_;
	    eval q({  ($msg->{len}) = 2;  ($msg->{msg[1]}) =  &CEC_MSG_REQUEST_ARC_TERMINATION;  ($msg->{reply}) = $reply ?  &CEC_MSG_TERMINATE_ARC : 0; });
    }' unless defined(&cec_msg_request_arc_termination);
    eval 'sub cec_ops_report_current_latency {
        my($msg,$phys_addr,$video_latency,$low_latency_mode,$audio_out_compensated,$audio_out_delay) = @_;
	    eval q({ *$phys_addr = ( ($msg->{msg[2]}) << 8) |  ($msg->{msg[3]}); *$video_latency =  ($msg->{msg[4]}); *$low_latency_mode = ( ($msg->{msg[5]}) >> 2) & 1; *$audio_out_compensated =  ($msg->{msg[5]}) & 3;  &if (*$audio_out_compensated == 3 &&  ($msg->{len}) >= 7) *$audio_out_delay =  ($msg->{msg[6]});  &else *$audio_out_delay = 0; });
    }' unless defined(&cec_ops_report_current_latency);
    eval 'sub cec_msg_request_current_latency {
        my($msg,$reply,$phys_addr) = @_;
	    eval q({  ($msg->{len}) = 4;  ($msg->{msg[0]}) |= 0xf;  ($msg->{msg[1]}) =  &CEC_MSG_REQUEST_CURRENT_LATENCY;  ($msg->{msg[2]}) = $phys_addr >> 8;  ($msg->{msg[3]}) = $phys_addr & 0xff;  ($msg->{reply}) = $reply ?  &CEC_MSG_REPORT_CURRENT_LATENCY : 0; });
    }' unless defined(&cec_msg_request_current_latency);
    eval 'sub cec_ops_request_current_latency {
        my($msg,$phys_addr) = @_;
	    eval q({ *$phys_addr = ( ($msg->{msg[2]}) << 8) |  ($msg->{msg[3]}); });
    }' unless defined(&cec_ops_request_current_latency);
    eval 'sub cec_ops_cdc_hec_inquire_state {
        my($msg,$phys_addr,$phys_addr1,$phys_addr2) = @_;
	    eval q({ *$phys_addr = ( ($msg->{msg[2]}) << 8) |  ($msg->{msg[3]}); *$phys_addr1 = ( ($msg->{msg[5]}) << 8) |  ($msg->{msg[6]}); *$phys_addr2 = ( ($msg->{msg[7]}) << 8) |  ($msg->{msg[8]}); });
    }' unless defined(&cec_ops_cdc_hec_inquire_state);
    eval 'sub cec_msg_cdc_hec_report_state {
        my($msg,$target_phys_addr,$hec_func_state,$host_func_state,$enc_func_state,$cdc_errcode,$has_field,$hec_field) = @_;
	    eval q({  ($msg->{len}) = $has_field ? 10: 8;  ($msg->{msg[0]}) |= 0xf;  ($msg->{msg[1]}) =  &CEC_MSG_CDC_MESSAGE;  ($msg->{msg[4]}) =  &CEC_MSG_CDC_HEC_REPORT_STATE;  ($msg->{msg[5]}) = $target_phys_addr >> 8;  ($msg->{msg[6]}) = $target_phys_addr & 0xff;  ($msg->{msg[7]}) = ($hec_func_state << 6) | ($host_func_state << 4) | ($enc_func_state << 2) | $cdc_errcode;  &if ($has_field) {  ($msg->{msg[8]}) = $hec_field >> 8;  ($msg->{msg[9]}) = $hec_field & 0xff; } });
    }' unless defined(&cec_msg_cdc_hec_report_state);
    eval 'sub cec_ops_cdc_hec_report_state {
        my($msg,$phys_addr,$target_phys_addr,$hec_func_state,$host_func_state,$enc_func_state,$cdc_errcode,$has_field,$hec_field) = @_;
	    eval q({ *$phys_addr = ( ($msg->{msg[2]}) << 8) |  ($msg->{msg[3]}); *$target_phys_addr = ( ($msg->{msg[5]}) << 8) |  ($msg->{msg[6]}); *$hec_func_state =  ($msg->{msg[7]}) >> 6; *$host_func_state = ( ($msg->{msg[7]}) >> 4) & 3; *$enc_func_state = ( ($msg->{msg[7]}) >> 4) & 3; *$cdc_errcode =  ($msg->{msg[7]}) & 3; *$has_field =  ($msg->{len}) >= 10; *$hec_field = *$has_field ? (( ($msg->{msg[8]}) << 8) |  ($msg->{msg[9]})) : 0; });
    }' unless defined(&cec_ops_cdc_hec_report_state);
    eval 'sub cec_msg_cdc_hec_set_state {
        my($msg,$phys_addr1,$phys_addr2,$hec_set_state,$phys_addr3,$phys_addr4,$phys_addr5) = @_;
	    eval q({  ($msg->{len}) = 10;  ($msg->{msg[0]}) |= 0xf;  ($msg->{msg[1]}) =  &CEC_MSG_CDC_MESSAGE;  ($msg->{msg[4]}) =  &CEC_MSG_CDC_HEC_INQUIRE_STATE;  ($msg->{msg[5]}) = $phys_addr1 >> 8;  ($msg->{msg[6]}) = $phys_addr1 & 0xff;  ($msg->{msg[7]}) = $phys_addr2 >> 8;  ($msg->{msg[8]}) = $phys_addr2 & 0xff;  ($msg->{msg[9]}) = $hec_set_state;  &if ($phys_addr3 !=  &CEC_PHYS_ADDR_INVALID) {  ($msg->{msg[$msg}->{len++]}) = $phys_addr3 >> 8;  ($msg->{msg[$msg}->{len++]}) = $phys_addr3 & 0xff;  &if ($phys_addr4 !=  &CEC_PHYS_ADDR_INVALID) {  ($msg->{msg[$msg}->{len++]}) = $phys_addr4 >> 8;  ($msg->{msg[$msg}->{len++]}) = $phys_addr4 & 0xff;  &if ($phys_addr5 !=  &CEC_PHYS_ADDR_INVALID) {  ($msg->{msg[$msg}->{len++]}) = $phys_addr5 >> 8;  ($msg->{msg[$msg}->{len++]}) = $phys_addr5 & 0xff; } } } });
    }' unless defined(&cec_msg_cdc_hec_set_state);
    eval 'sub cec_ops_cdc_hec_set_state {
        my($msg,$phys_addr,$phys_addr1,$phys_addr2,$hec_set_state,$phys_addr3,$phys_addr4,$phys_addr5) = @_;
	    eval q({ *$phys_addr = ( ($msg->{msg[2]}) << 8) |  ($msg->{msg[3]}); *$phys_addr1 = ( ($msg->{msg[5]}) << 8) |  ($msg->{msg[6]}); *$phys_addr2 = ( ($msg->{msg[7]}) << 8) |  ($msg->{msg[8]}); *$hec_set_state =  ($msg->{msg[9]}); *$phys_addr3 = *$phys_addr4 = *$phys_addr5 =  &CEC_PHYS_ADDR_INVALID;  &if ( ($msg->{len}) >= 12) *$phys_addr3 = ( ($msg->{msg[10]}) << 8) |  ($msg->{msg[11]});  &if ( ($msg->{len}) >= 14) *$phys_addr4 = ( ($msg->{msg[12]}) << 8) |  ($msg->{msg[13]});  &if ( ($msg->{len}) >= 16) *$phys_addr5 = ( ($msg->{msg[14]}) << 8) |  ($msg->{msg[15]}); });
    }' unless defined(&cec_ops_cdc_hec_set_state);
    eval 'sub cec_msg_cdc_hec_set_state_adjacent {
        my($msg,$phys_addr1,$hec_set_state) = @_;
	    eval q({  ($msg->{len}) = 8;  ($msg->{msg[0]}) |= 0xf;  ($msg->{msg[1]}) =  &CEC_MSG_CDC_MESSAGE;  ($msg->{msg[4]}) =  &CEC_MSG_CDC_HEC_SET_STATE_ADJACENT;  ($msg->{msg[5]}) = $phys_addr1 >> 8;  ($msg->{msg[6]}) = $phys_addr1 & 0xff;  ($msg->{msg[7]}) = $hec_set_state; });
    }' unless defined(&cec_msg_cdc_hec_set_state_adjacent);
    eval 'sub cec_ops_cdc_hec_set_state_adjacent {
        my($msg,$phys_addr,$phys_addr1,$hec_set_state) = @_;
	    eval q({ *$phys_addr = ( ($msg->{msg[2]}) << 8) |  ($msg->{msg[3]}); *$phys_addr1 = ( ($msg->{msg[5]}) << 8) |  ($msg->{msg[6]}); *$hec_set_state =  ($msg->{msg[7]}); });
    }' unless defined(&cec_ops_cdc_hec_set_state_adjacent);
    eval 'sub cec_msg_cdc_hec_request_deactivation {
        my($msg,$phys_addr1,$phys_addr2,$phys_addr3) = @_;
	    eval q({  ($msg->{len}) = 11;  ($msg->{msg[0]}) |= 0xf;  ($msg->{msg[1]}) =  &CEC_MSG_CDC_MESSAGE;  ($msg->{msg[4]}) =  &CEC_MSG_CDC_HEC_REQUEST_DEACTIVATION;  ($msg->{msg[5]}) = $phys_addr1 >> 8;  ($msg->{msg[6]}) = $phys_addr1 & 0xff;  ($msg->{msg[7]}) = $phys_addr2 >> 8;  ($msg->{msg[8]}) = $phys_addr2 & 0xff;  ($msg->{msg[9]}) = $phys_addr3 >> 8;  ($msg->{msg[10]}) = $phys_addr3 & 0xff; });
    }' unless defined(&cec_msg_cdc_hec_request_deactivation);
    eval 'sub cec_ops_cdc_hec_request_deactivation {
        my($msg,$phys_addr,$phys_addr1,$phys_addr2,$phys_addr3) = @_;
	    eval q({ *$phys_addr = ( ($msg->{msg[2]}) << 8) |  ($msg->{msg[3]}); *$phys_addr1 = ( ($msg->{msg[5]}) << 8) |  ($msg->{msg[6]}); *$phys_addr2 = ( ($msg->{msg[7]}) << 8) |  ($msg->{msg[8]}); *$phys_addr3 = ( ($msg->{msg[9]}) << 8) |  ($msg->{msg[10]}); });
    }' unless defined(&cec_ops_cdc_hec_request_deactivation);
    eval 'sub cec_msg_cdc_hec_notify_alive {
        my($msg) = @_;
	    eval q({  ($msg->{len}) = 5;  ($msg->{msg[0]}) |= 0xf;  ($msg->{msg[1]}) =  &CEC_MSG_CDC_MESSAGE;  ($msg->{msg[4]}) =  &CEC_MSG_CDC_HEC_NOTIFY_ALIVE; });
    }' unless defined(&cec_msg_cdc_hec_notify_alive);
    eval 'sub cec_ops_cdc_hec_notify_alive {
        my($msg,$phys_addr) = @_;
	    eval q({ *$phys_addr = ( ($msg->{msg[2]}) << 8) |  ($msg->{msg[3]}); });
    }' unless defined(&cec_ops_cdc_hec_notify_alive);
    eval 'sub cec_msg_cdc_hec_discover {
        my($msg) = @_;
	    eval q({  ($msg->{len}) = 5;  ($msg->{msg[0]}) |= 0xf;  ($msg->{msg[1]}) =  &CEC_MSG_CDC_MESSAGE;  ($msg->{msg[4]}) =  &CEC_MSG_CDC_HEC_DISCOVER; });
    }' unless defined(&cec_msg_cdc_hec_discover);
    eval 'sub cec_ops_cdc_hec_discover {
        my($msg,$phys_addr) = @_;
	    eval q({ *$phys_addr = ( ($msg->{msg[2]}) << 8) |  ($msg->{msg[3]}); });
    }' unless defined(&cec_ops_cdc_hec_discover);
    eval 'sub cec_msg_cdc_hpd_set_state {
        my($msg,$input_port,$hpd_state) = @_;
	    eval q({  ($msg->{len}) = 6;  ($msg->{msg[0]}) |= 0xf;  ($msg->{msg[1]}) =  &CEC_MSG_CDC_MESSAGE;  ($msg->{msg[4]}) =  &CEC_MSG_CDC_HPD_SET_STATE;  ($msg->{msg[5]}) = ($input_port << 4) | $hpd_state; });
    }' unless defined(&cec_msg_cdc_hpd_set_state);
    eval 'sub cec_ops_cdc_hpd_set_state {
        my($msg,$phys_addr,$input_port,$hpd_state) = @_;
	    eval q({ *$phys_addr = ( ($msg->{msg[2]}) << 8) |  ($msg->{msg[3]}); *$input_port =  ($msg->{msg[5]}) >> 4; *$hpd_state =  ($msg->{msg[5]}) & 0xf; });
    }' unless defined(&cec_ops_cdc_hpd_set_state);
    eval 'sub cec_msg_cdc_hpd_report_state {
        my($msg,$hpd_state,$hpd_error) = @_;
	    eval q({  ($msg->{len}) = 6;  ($msg->{msg[0]}) |= 0xf;  ($msg->{msg[1]}) =  &CEC_MSG_CDC_MESSAGE;  ($msg->{msg[4]}) =  &CEC_MSG_CDC_HPD_REPORT_STATE;  ($msg->{msg[5]}) = ($hpd_state << 4) | $hpd_error; });
    }' unless defined(&cec_msg_cdc_hpd_report_state);
    eval 'sub cec_ops_cdc_hpd_report_state {
        my($msg,$phys_addr,$hpd_state,$hpd_error) = @_;
	    eval q({ *$phys_addr = ( ($msg->{msg[2]}) << 8) |  ($msg->{msg[3]}); *$hpd_state =  ($msg->{msg[5]}) >> 4; *$hpd_error =  ($msg->{msg[5]}) & 0xf; });
    }' unless defined(&cec_ops_cdc_hpd_report_state);
}
1;
