# This file was automatically generated by SWIG (https://www.swig.org).
# Version 4.3.0
#
# Do not make changes to this file unless you know what you are doing - modify
# the SWIG interface file instead.

from sys import version_info as _swig_python_version_info
# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _gen
else:
    import _gen

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

_swig_new_instance_method = _gen.SWIG_PyInstanceMethod_New
_swig_new_static_method = _gen.SWIG_PyStaticMethod_New

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "this":
            set(self, name, value)
        elif name == "thisown":
            self.this.own(value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


SHARED_PTR_DISOWN = _gen.SHARED_PTR_DISOWN
import spot.impl
AUT_BEGIN = _gen.AUT_BEGIN
AUT_KS_NCA = _gen.AUT_KS_NCA
AUT_L_NBA = _gen.AUT_L_NBA
AUT_L_DSA = _gen.AUT_L_DSA
AUT_M_NBA = _gen.AUT_M_NBA
AUT_CYCLIST_TRACE_NBA = _gen.AUT_CYCLIST_TRACE_NBA
AUT_CYCLIST_PROOF_DBA = _gen.AUT_CYCLIST_PROOF_DBA
AUT_CYCLE_LOG_NBA = _gen.AUT_CYCLE_LOG_NBA
AUT_CYCLE_ONEHOT_NBA = _gen.AUT_CYCLE_ONEHOT_NBA
AUT_END = _gen.AUT_END
aut_pattern = _gen.aut_pattern
aut_pattern_name = _gen.aut_pattern_name
LTL_BEGIN = _gen.LTL_BEGIN
LTL_AND_F = _gen.LTL_AND_F
LTL_AND_FG = _gen.LTL_AND_FG
LTL_AND_GF = _gen.LTL_AND_GF
LTL_CCJ_ALPHA = _gen.LTL_CCJ_ALPHA
LTL_CCJ_BETA = _gen.LTL_CCJ_BETA
LTL_CCJ_BETA_PRIME = _gen.LTL_CCJ_BETA_PRIME
LTL_DAC_PATTERNS = _gen.LTL_DAC_PATTERNS
LTL_EH_PATTERNS = _gen.LTL_EH_PATTERNS
LTL_EIL_GSI = _gen.LTL_EIL_GSI
LTL_FXG_OR = _gen.LTL_FXG_OR
LTL_GF_EQUIV = _gen.LTL_GF_EQUIV
LTL_GF_EQUIV_XN = _gen.LTL_GF_EQUIV_XN
LTL_GF_IMPLIES = _gen.LTL_GF_IMPLIES
LTL_GF_IMPLIES_XN = _gen.LTL_GF_IMPLIES_XN
LTL_GH_Q = _gen.LTL_GH_Q
LTL_GH_R = _gen.LTL_GH_R
LTL_GO_THETA = _gen.LTL_GO_THETA
LTL_GXF_AND = _gen.LTL_GXF_AND
LTL_HKRSS_PATTERNS = _gen.LTL_HKRSS_PATTERNS
LTL_KR_N = _gen.LTL_KR_N
LTL_KR_NLOGN = _gen.LTL_KR_NLOGN
LTL_KV_PSI = _gen.LTL_KV_PSI
LTL_LILY_PATTERNS = _gen.LTL_LILY_PATTERNS
LTL_MS_EXAMPLE = _gen.LTL_MS_EXAMPLE
LTL_MS_PHI_H = _gen.LTL_MS_PHI_H
LTL_MS_PHI_R = _gen.LTL_MS_PHI_R
LTL_MS_PHI_S = _gen.LTL_MS_PHI_S
LTL_OR_FG = _gen.LTL_OR_FG
LTL_OR_G = _gen.LTL_OR_G
LTL_OR_GF = _gen.LTL_OR_GF
LTL_P_PATTERNS = _gen.LTL_P_PATTERNS
LTL_PPS_ARBITER_STANDARD = _gen.LTL_PPS_ARBITER_STANDARD
LTL_PPS_ARBITER_STRICT = _gen.LTL_PPS_ARBITER_STRICT
LTL_R_LEFT = _gen.LTL_R_LEFT
LTL_R_RIGHT = _gen.LTL_R_RIGHT
LTL_RV_COUNTER = _gen.LTL_RV_COUNTER
LTL_RV_COUNTER_CARRY = _gen.LTL_RV_COUNTER_CARRY
LTL_RV_COUNTER_CARRY_LINEAR = _gen.LTL_RV_COUNTER_CARRY_LINEAR
LTL_RV_COUNTER_LINEAR = _gen.LTL_RV_COUNTER_LINEAR
LTL_SB_PATTERNS = _gen.LTL_SB_PATTERNS
LTL_SEJK_F = _gen.LTL_SEJK_F
LTL_SEJK_J = _gen.LTL_SEJK_J
LTL_SEJK_K = _gen.LTL_SEJK_K
LTL_SEJK_PATTERNS = _gen.LTL_SEJK_PATTERNS
LTL_TV_F1 = _gen.LTL_TV_F1
LTL_TV_F2 = _gen.LTL_TV_F2
LTL_TV_G1 = _gen.LTL_TV_G1
LTL_TV_G2 = _gen.LTL_TV_G2
LTL_TV_UU = _gen.LTL_TV_UU
LTL_U_LEFT = _gen.LTL_U_LEFT
LTL_U_RIGHT = _gen.LTL_U_RIGHT
LTLF_CHOMP_MEALY = _gen.LTLF_CHOMP_MEALY
LTLF_TV_COUNTER_MEALY = _gen.LTLF_TV_COUNTER_MEALY
LTLF_TV_DOUBLE_COUNTERS_MEALY = _gen.LTLF_TV_DOUBLE_COUNTERS_MEALY
LTLF_TV_NIM_MEALY = _gen.LTLF_TV_NIM_MEALY
LTL_END = _gen.LTL_END
ltl_pattern = _gen.ltl_pattern
ltl_pattern_name = _gen.ltl_pattern_name
ltl_pattern_max = _gen.ltl_pattern_max
ltl_pattern_argc = _gen.ltl_pattern_argc

def ltl_patterns(*args):
  """
  Generate LTL patterns.

  Each argument should specify a pattern with a
  range for its parameter(s).

  For single-parameter patterns, arguments of
  ltl_patterns() should be have one of these three forms:
    - (id, n)
    - (id, min, max)
    - id
  In the first case, the pattern id=n is generated.  In the second
  case, all pattern id=n for min<=n<=max are generated.  The
  third case is a shorthand for (id, 1, 10), except when
  id denotes one of the hard-coded list of LTL formulas (like,
  DAC_PATTERNS, EH_PATTERNS, etc.) where all formulas from that
  list are output.

  For two-parameter patterns, arguments of
  ltl_patterns() should be have one of these four forms:
    - (id, n1)
    - (id, n1, n2)
    - (id, min1, max1, min2, max2)
    - id
  In the first case, n2 is assumed to be equal to n1.  In
  the third case, all combination of n1 and n2 such that
  min1<=n1<=max1 and min2<=n2<=max2 are generated.  The
  last case is a shorthand for (id, 1, 3, 1, 3).
  """
  for spec in args:
    min2 = -1
    max2 = -1
    if type(spec) is int:
      pat = spec
      min = 1
      argc = ltl_pattern_argc(spec)
      if argc == 1:
        max = ltl_pattern_max(spec) or 10
      else:
        min2 = 1
        max = max2 = 3
    else:
      argc = ltl_pattern_argc(spec[0])
      ls = len(spec)
      if argc == 1:
        if ls == 2:
          pat, min, max = spec[0], spec[1], spec[1]
        elif ls == 3:
          pat, min, max = spec
        else:
          raise RuntimeError("invalid pattern specification " + str(spec))
      else:
        if ls == 2:
          pat, min, max, min2, max2 = \
            spec[0], spec[1], spec[1], spec[1], spec[1]
        elif ls == 3:
          pat, min, max, min2, max2 = \
            spec[0], spec[1], spec[1], spec[2], spec[2]
        elif ls == 5:
          pat, min, max, min2, max2 = spec
        else:
          raise RuntimeError("invalid pattern specification " + str(spec))
    for n in range(min, max + 1):
      for m in range(min2, max2 + 1):
        yield ltl_pattern(pat, n, m)


# Override aut_pattern now(), because %feature("shadow") does not
# seem to work correctly.  See https://github.com/swig/swig/issues/980
def aut_pattern(pattern: 'spot::gen::aut_pattern_id', n: 'int',
                dict: 'spot::bdd_dict_ptr' = None) -> "spot::twa_graph_ptr":
  return _gen.aut_pattern(pattern, n, dict or spot._bdd_dict)


def aut_patterns(*args):
  """
  Generate automata patterns.

  The arguments should be have one of these three forms:
    - (id, n)
    - (id, min, max)
    - id
  In the first case, the pattern id=n is generated.  In the second
  case, all pattern id=n for min<=n<=max are generated.  The
  third case is a shorthand for (id, 1, 10).
  """
  for spec in args:
    if type(spec) is int:
      pat = spec
      min = 1
      max = 10
    else:
      ls = len(spec)
      if ls == 2:
        pat, min, max = spec[0], spec[1], spec[1]
      elif ls == 3:
        pat, min, max = spec
      else:
        raise RuntimeError("invalid pattern specification")
    for n in range(min, max + 1):
      yield aut_pattern(pat, n)


