/* Automatically generated nanopb header */
/* Generated by nanopb-0.4.9.1 */

#ifndef PB_MESHTASTIC_MESHTASTIC_CONFIG_PB_H_INCLUDED
#define PB_MESHTASTIC_MESHTASTIC_CONFIG_PB_H_INCLUDED
#include <pb.h>
#include "meshtastic/device_ui.pb.h"

#if PB_PROTO_HEADER_VERSION != 40
#error Regenerate this file with the current version of nanopb generator.
#endif

/* Enum definitions */
/* Defines the device's role on the Mesh network */
typedef enum _meshtastic_Config_DeviceConfig_Role {
    /* Description: App connected or stand alone messaging device.
 Technical Details: Default Role */
    meshtastic_Config_DeviceConfig_Role_CLIENT = 0,
    /* Description: Device that does not forward packets from other devices. */
    meshtastic_Config_DeviceConfig_Role_CLIENT_MUTE = 1,
    /* Description: Infrastructure node for extending network coverage by relaying messages. Visible in Nodes list.
 Technical Details: Mesh packets will prefer to be routed over this node. This node will not be used by client apps.
   The wifi radio and the oled screen will be put to sleep.
   This mode may still potentially have higher power usage due to it's preference in message rebroadcasting on the mesh. */
    meshtastic_Config_DeviceConfig_Role_ROUTER = 2,
    meshtastic_Config_DeviceConfig_Role_ROUTER_CLIENT = 3,
    /* Description: Infrastructure node for extending network coverage by relaying messages with minimal overhead. Not visible in Nodes list.
 Technical Details: Mesh packets will simply be rebroadcasted over this node. Nodes configured with this role will not originate NodeInfo, Position, Telemetry
   or any other packet type. They will simply rebroadcast any mesh packets on the same frequency, channel num, spread factor, and coding rate.
 Deprecated in v2.7.11 because it creates "holes" in the mesh rebroadcast chain. */
    meshtastic_Config_DeviceConfig_Role_REPEATER = 4,
    /* Description: Broadcasts GPS position packets as priority.
 Technical Details: Position Mesh packets will be prioritized higher and sent more frequently by default.
   When used in conjunction with power.is_power_saving = true, nodes will wake up,
   send position, and then sleep for position.position_broadcast_secs seconds. */
    meshtastic_Config_DeviceConfig_Role_TRACKER = 5,
    /* Description: Broadcasts telemetry packets as priority.
 Technical Details: Telemetry Mesh packets will be prioritized higher and sent more frequently by default.
   When used in conjunction with power.is_power_saving = true, nodes will wake up,
   send environment telemetry, and then sleep for telemetry.environment_update_interval seconds. */
    meshtastic_Config_DeviceConfig_Role_SENSOR = 6,
    /* Description: Optimized for ATAK system communication and reduces routine broadcasts.
 Technical Details: Used for nodes dedicated for connection to an ATAK EUD.
    Turns off many of the routine broadcasts to favor CoT packet stream
    from the Meshtastic ATAK plugin -> IMeshService -> Node */
    meshtastic_Config_DeviceConfig_Role_TAK = 7,
    /* Description: Device that only broadcasts as needed for stealth or power savings.
 Technical Details: Used for nodes that "only speak when spoken to"
    Turns all of the routine broadcasts but allows for ad-hoc communication
    Still rebroadcasts, but with local only rebroadcast mode (known meshes only)
    Can be used for clandestine operation or to dramatically reduce airtime / power consumption */
    meshtastic_Config_DeviceConfig_Role_CLIENT_HIDDEN = 8,
    /* Description: Broadcasts location as message to default channel regularly for to assist with device recovery.
 Technical Details: Used to automatically send a text message to the mesh
    with the current position of the device on a frequent interval:
    "I'm lost! Position: lat / long" */
    meshtastic_Config_DeviceConfig_Role_LOST_AND_FOUND = 9,
    /* Description: Enables automatic TAK PLI broadcasts and reduces routine broadcasts.
 Technical Details: Turns off many of the routine broadcasts to favor ATAK CoT packet stream
    and automatic TAK PLI (position location information) broadcasts.
    Uses position module configuration to determine TAK PLI broadcast interval. */
    meshtastic_Config_DeviceConfig_Role_TAK_TRACKER = 10,
    /* Description: Will always rebroadcast packets, but will do so after all other modes.
 Technical Details: Used for router nodes that are intended to provide additional coverage
    in areas not already covered by other routers, or to bridge around problematic terrain,
    but should not be given priority over other routers in order to avoid unnecessaraily
    consuming hops. */
    meshtastic_Config_DeviceConfig_Role_ROUTER_LATE = 11,
    /* Description: Treats packets from or to favorited nodes as ROUTER, and all other packets as CLIENT.
 Technical Details: Used for stronger attic/roof nodes to distribute messages more widely
    from weaker, indoor, or less-well-positioned nodes. Recommended for users with multiple nodes
    where one CLIENT_BASE acts as a more powerful base station, such as an attic/roof node. */
    meshtastic_Config_DeviceConfig_Role_CLIENT_BASE = 12
} meshtastic_Config_DeviceConfig_Role;

/* Defines the device's behavior for how messages are rebroadcast */
typedef enum _meshtastic_Config_DeviceConfig_RebroadcastMode {
    /* Default behavior.
 Rebroadcast any observed message, if it was on our private channel or from another mesh with the same lora params. */
    meshtastic_Config_DeviceConfig_RebroadcastMode_ALL = 0,
    /* Same as behavior as ALL but skips packet decoding and simply rebroadcasts them.
 Only available in Repeater role. Setting this on any other roles will result in ALL behavior. */
    meshtastic_Config_DeviceConfig_RebroadcastMode_ALL_SKIP_DECODING = 1,
    /* Ignores observed messages from foreign meshes that are open or those which it cannot decrypt.
 Only rebroadcasts message on the nodes local primary / secondary channels. */
    meshtastic_Config_DeviceConfig_RebroadcastMode_LOCAL_ONLY = 2,
    /* Ignores observed messages from foreign meshes like LOCAL_ONLY,
 but takes it step further by also ignoring messages from nodenums not in the node's known list (NodeDB) */
    meshtastic_Config_DeviceConfig_RebroadcastMode_KNOWN_ONLY = 3,
    /* Only permitted for SENSOR, TRACKER and TAK_TRACKER roles, this will inhibit all rebroadcasts, not unlike CLIENT_MUTE role. */
    meshtastic_Config_DeviceConfig_RebroadcastMode_NONE = 4,
    /* Ignores packets from non-standard portnums such as: TAK, RangeTest, PaxCounter, etc.
 Only rebroadcasts packets with standard portnums: NodeInfo, Text, Position, Telemetry, and Routing. */
    meshtastic_Config_DeviceConfig_RebroadcastMode_CORE_PORTNUMS_ONLY = 5
} meshtastic_Config_DeviceConfig_RebroadcastMode;

/* Defines buzzer behavior for audio feedback */
typedef enum _meshtastic_Config_DeviceConfig_BuzzerMode {
    /* Default behavior.
 Buzzer is enabled for all audio feedback including button presses and alerts. */
    meshtastic_Config_DeviceConfig_BuzzerMode_ALL_ENABLED = 0,
    /* Disabled.
 All buzzer audio feedback is disabled. */
    meshtastic_Config_DeviceConfig_BuzzerMode_DISABLED = 1,
    /* Notifications Only.
 Buzzer is enabled only for notifications and alerts, but not for button presses.
 External notification config determines the specifics of the notification behavior. */
    meshtastic_Config_DeviceConfig_BuzzerMode_NOTIFICATIONS_ONLY = 2,
    /* Non-notification system buzzer tones only.
 Buzzer is enabled only for non-notification tones such as button presses, startup, shutdown, but not for alerts. */
    meshtastic_Config_DeviceConfig_BuzzerMode_SYSTEM_ONLY = 3,
    /* Direct Message notifications only.
 Buzzer is enabled only for direct messages and alerts, but not for button presses.
 External notification config determines the specifics of the notification behavior. */
    meshtastic_Config_DeviceConfig_BuzzerMode_DIRECT_MSG_ONLY = 4
} meshtastic_Config_DeviceConfig_BuzzerMode;

/* Bit field of boolean configuration options, indicating which optional
 fields to include when assembling POSITION messages.
 Longitude, latitude, altitude, speed, heading, and DOP
 are always included (also time if GPS-synced)
 NOTE: the more fields are included, the larger the message will be -
   leading to longer airtime and a higher risk of packet loss */
typedef enum _meshtastic_Config_PositionConfig_PositionFlags {
    /* Required for compilation */
    meshtastic_Config_PositionConfig_PositionFlags_UNSET = 0,
    /* Include an altitude value (if available) */
    meshtastic_Config_PositionConfig_PositionFlags_ALTITUDE = 1,
    /* Altitude value is MSL */
    meshtastic_Config_PositionConfig_PositionFlags_ALTITUDE_MSL = 2,
    /* Include geoidal separation */
    meshtastic_Config_PositionConfig_PositionFlags_GEOIDAL_SEPARATION = 4,
    /* Include the DOP value ; PDOP used by default, see below */
    meshtastic_Config_PositionConfig_PositionFlags_DOP = 8,
    /* If POS_DOP set, send separate HDOP / VDOP values instead of PDOP */
    meshtastic_Config_PositionConfig_PositionFlags_HVDOP = 16,
    /* Include number of "satellites in view" */
    meshtastic_Config_PositionConfig_PositionFlags_SATINVIEW = 32,
    /* Include a sequence number incremented per packet */
    meshtastic_Config_PositionConfig_PositionFlags_SEQ_NO = 64,
    /* Include positional timestamp (from GPS solution) */
    meshtastic_Config_PositionConfig_PositionFlags_TIMESTAMP = 128,
    /* Include positional heading
 Intended for use with vehicle not walking speeds
 walking speeds are likely to be error prone like the compass */
    meshtastic_Config_PositionConfig_PositionFlags_HEADING = 256,
    /* Include positional speed
 Intended for use with vehicle not walking speeds
 walking speeds are likely to be error prone like the compass */
    meshtastic_Config_PositionConfig_PositionFlags_SPEED = 512
} meshtastic_Config_PositionConfig_PositionFlags;

typedef enum _meshtastic_Config_PositionConfig_GpsMode {
    /* GPS is present but disabled */
    meshtastic_Config_PositionConfig_GpsMode_DISABLED = 0,
    /* GPS is present and enabled */
    meshtastic_Config_PositionConfig_GpsMode_ENABLED = 1,
    /* GPS is not present on the device */
    meshtastic_Config_PositionConfig_GpsMode_NOT_PRESENT = 2
} meshtastic_Config_PositionConfig_GpsMode;

typedef enum _meshtastic_Config_NetworkConfig_AddressMode {
    /* obtain ip address via DHCP */
    meshtastic_Config_NetworkConfig_AddressMode_DHCP = 0,
    /* use static ip address */
    meshtastic_Config_NetworkConfig_AddressMode_STATIC = 1
} meshtastic_Config_NetworkConfig_AddressMode;

/* Available flags auxiliary network protocols */
typedef enum _meshtastic_Config_NetworkConfig_ProtocolFlags {
    /* Do not broadcast packets over any network protocol */
    meshtastic_Config_NetworkConfig_ProtocolFlags_NO_BROADCAST = 0,
    /* Enable broadcasting packets via UDP over the local network */
    meshtastic_Config_NetworkConfig_ProtocolFlags_UDP_BROADCAST = 1
} meshtastic_Config_NetworkConfig_ProtocolFlags;

/* Deprecated in 2.7.4: Unused */
typedef enum _meshtastic_Config_DisplayConfig_DeprecatedGpsCoordinateFormat {
    meshtastic_Config_DisplayConfig_DeprecatedGpsCoordinateFormat_UNUSED = 0
} meshtastic_Config_DisplayConfig_DeprecatedGpsCoordinateFormat;

/* Unit display preference */
typedef enum _meshtastic_Config_DisplayConfig_DisplayUnits {
    /* Metric (Default) */
    meshtastic_Config_DisplayConfig_DisplayUnits_METRIC = 0,
    /* Imperial */
    meshtastic_Config_DisplayConfig_DisplayUnits_IMPERIAL = 1
} meshtastic_Config_DisplayConfig_DisplayUnits;

/* Override OLED outo detect with this if it fails. */
typedef enum _meshtastic_Config_DisplayConfig_OledType {
    /* Default / Autodetect */
    meshtastic_Config_DisplayConfig_OledType_OLED_AUTO = 0,
    /* Default / Autodetect */
    meshtastic_Config_DisplayConfig_OledType_OLED_SSD1306 = 1,
    /* Default / Autodetect */
    meshtastic_Config_DisplayConfig_OledType_OLED_SH1106 = 2,
    /* Can not be auto detected but set by proto. Used for 128x64 screens */
    meshtastic_Config_DisplayConfig_OledType_OLED_SH1107 = 3,
    /* Can not be auto detected but set by proto. Used for 128x128 screens */
    meshtastic_Config_DisplayConfig_OledType_OLED_SH1107_128_128 = 4
} meshtastic_Config_DisplayConfig_OledType;

typedef enum _meshtastic_Config_DisplayConfig_DisplayMode {
    /* Default. The old style for the 128x64 OLED screen */
    meshtastic_Config_DisplayConfig_DisplayMode_DEFAULT = 0,
    /* Rearrange display elements to cater for bicolor OLED displays */
    meshtastic_Config_DisplayConfig_DisplayMode_TWOCOLOR = 1,
    /* Same as TwoColor, but with inverted top bar. Not so good for Epaper displays */
    meshtastic_Config_DisplayConfig_DisplayMode_INVERTED = 2,
    /* TFT Full Color Displays (not implemented yet) */
    meshtastic_Config_DisplayConfig_DisplayMode_COLOR = 3
} meshtastic_Config_DisplayConfig_DisplayMode;

typedef enum _meshtastic_Config_DisplayConfig_CompassOrientation {
    /* The compass and the display are in the same orientation. */
    meshtastic_Config_DisplayConfig_CompassOrientation_DEGREES_0 = 0,
    /* Rotate the compass by 90 degrees. */
    meshtastic_Config_DisplayConfig_CompassOrientation_DEGREES_90 = 1,
    /* Rotate the compass by 180 degrees. */
    meshtastic_Config_DisplayConfig_CompassOrientation_DEGREES_180 = 2,
    /* Rotate the compass by 270 degrees. */
    meshtastic_Config_DisplayConfig_CompassOrientation_DEGREES_270 = 3,
    /* Don't rotate the compass, but invert the result. */
    meshtastic_Config_DisplayConfig_CompassOrientation_DEGREES_0_INVERTED = 4,
    /* Rotate the compass by 90 degrees and invert. */
    meshtastic_Config_DisplayConfig_CompassOrientation_DEGREES_90_INVERTED = 5,
    /* Rotate the compass by 180 degrees and invert. */
    meshtastic_Config_DisplayConfig_CompassOrientation_DEGREES_180_INVERTED = 6,
    /* Rotate the compass by 270 degrees and invert. */
    meshtastic_Config_DisplayConfig_CompassOrientation_DEGREES_270_INVERTED = 7
} meshtastic_Config_DisplayConfig_CompassOrientation;

typedef enum _meshtastic_Config_LoRaConfig_RegionCode {
    /* Region is not set */
    meshtastic_Config_LoRaConfig_RegionCode_UNSET = 0,
    /* United States */
    meshtastic_Config_LoRaConfig_RegionCode_US = 1,
    /* European Union 433mhz */
    meshtastic_Config_LoRaConfig_RegionCode_EU_433 = 2,
    /* European Union 868mhz */
    meshtastic_Config_LoRaConfig_RegionCode_EU_868 = 3,
    /* China */
    meshtastic_Config_LoRaConfig_RegionCode_CN = 4,
    /* Japan */
    meshtastic_Config_LoRaConfig_RegionCode_JP = 5,
    /* Australia / New Zealand */
    meshtastic_Config_LoRaConfig_RegionCode_ANZ = 6,
    /* Korea */
    meshtastic_Config_LoRaConfig_RegionCode_KR = 7,
    /* Taiwan */
    meshtastic_Config_LoRaConfig_RegionCode_TW = 8,
    /* Russia */
    meshtastic_Config_LoRaConfig_RegionCode_RU = 9,
    /* India */
    meshtastic_Config_LoRaConfig_RegionCode_IN = 10,
    /* New Zealand 865mhz */
    meshtastic_Config_LoRaConfig_RegionCode_NZ_865 = 11,
    /* Thailand */
    meshtastic_Config_LoRaConfig_RegionCode_TH = 12,
    /* WLAN Band */
    meshtastic_Config_LoRaConfig_RegionCode_LORA_24 = 13,
    /* Ukraine 433mhz */
    meshtastic_Config_LoRaConfig_RegionCode_UA_433 = 14,
    /* Ukraine 868mhz */
    meshtastic_Config_LoRaConfig_RegionCode_UA_868 = 15,
    /* Malaysia 433mhz */
    meshtastic_Config_LoRaConfig_RegionCode_MY_433 = 16,
    /* Malaysia 919mhz */
    meshtastic_Config_LoRaConfig_RegionCode_MY_919 = 17,
    /* Singapore 923mhz */
    meshtastic_Config_LoRaConfig_RegionCode_SG_923 = 18,
    /* Philippines 433mhz */
    meshtastic_Config_LoRaConfig_RegionCode_PH_433 = 19,
    /* Philippines 868mhz */
    meshtastic_Config_LoRaConfig_RegionCode_PH_868 = 20,
    /* Philippines 915mhz */
    meshtastic_Config_LoRaConfig_RegionCode_PH_915 = 21,
    /* Australia / New Zealand 433MHz */
    meshtastic_Config_LoRaConfig_RegionCode_ANZ_433 = 22,
    /* Kazakhstan 433MHz */
    meshtastic_Config_LoRaConfig_RegionCode_KZ_433 = 23,
    /* Kazakhstan 863MHz */
    meshtastic_Config_LoRaConfig_RegionCode_KZ_863 = 24,
    /* Nepal 865MHz */
    meshtastic_Config_LoRaConfig_RegionCode_NP_865 = 25,
    /* Brazil 902MHz */
    meshtastic_Config_LoRaConfig_RegionCode_BR_902 = 26
} meshtastic_Config_LoRaConfig_RegionCode;

/* Standard predefined channel settings
 Note: these mappings must match ModemPreset Choice in the device code. */
typedef enum _meshtastic_Config_LoRaConfig_ModemPreset {
    /* Long Range - Fast */
    meshtastic_Config_LoRaConfig_ModemPreset_LONG_FAST = 0,
    /* Long Range - Slow */
    meshtastic_Config_LoRaConfig_ModemPreset_LONG_SLOW = 1,
    /* Very Long Range - Slow
 Deprecated in 2.5: Works only with txco and is unusably slow */
    meshtastic_Config_LoRaConfig_ModemPreset_VERY_LONG_SLOW = 2,
    /* Medium Range - Slow */
    meshtastic_Config_LoRaConfig_ModemPreset_MEDIUM_SLOW = 3,
    /* Medium Range - Fast */
    meshtastic_Config_LoRaConfig_ModemPreset_MEDIUM_FAST = 4,
    /* Short Range - Slow */
    meshtastic_Config_LoRaConfig_ModemPreset_SHORT_SLOW = 5,
    /* Short Range - Fast */
    meshtastic_Config_LoRaConfig_ModemPreset_SHORT_FAST = 6,
    /* Long Range - Moderately Fast */
    meshtastic_Config_LoRaConfig_ModemPreset_LONG_MODERATE = 7,
    /* Short Range - Turbo
 This is the fastest preset and the only one with 500kHz bandwidth.
 It is not legal to use in all regions due to this wider bandwidth. */
    meshtastic_Config_LoRaConfig_ModemPreset_SHORT_TURBO = 8
} meshtastic_Config_LoRaConfig_ModemPreset;

typedef enum _meshtastic_Config_BluetoothConfig_PairingMode {
    /* Device generates a random PIN that will be shown on the screen of the device for pairing */
    meshtastic_Config_BluetoothConfig_PairingMode_RANDOM_PIN = 0,
    /* Device requires a specified fixed PIN for pairing */
    meshtastic_Config_BluetoothConfig_PairingMode_FIXED_PIN = 1,
    /* Device requires no PIN for pairing */
    meshtastic_Config_BluetoothConfig_PairingMode_NO_PIN = 2
} meshtastic_Config_BluetoothConfig_PairingMode;

/* Struct definitions */
/* Configuration */
typedef struct _meshtastic_Config_DeviceConfig {
    /* Sets the role of node */
    meshtastic_Config_DeviceConfig_Role role;
    /* Disabling this will disable the SerialConsole by not initilizing the StreamAPI
 Moved to SecurityConfig */
    bool serial_enabled;
    /* For boards without a hard wired button, this is the pin number that will be used
 Boards that have more than one button can swap the function with this one. defaults to BUTTON_PIN if defined. */
    uint32_t button_gpio;
    /* For boards without a PWM buzzer, this is the pin number that will be used
 Defaults to PIN_BUZZER if defined. */
    uint32_t buzzer_gpio;
    /* Sets the role of node */
    meshtastic_Config_DeviceConfig_RebroadcastMode rebroadcast_mode;
    /* Send our nodeinfo this often
 Defaults to 900 Seconds (15 minutes) */
    uint32_t node_info_broadcast_secs;
    /* Treat double tap interrupt on supported accelerometers as a button press if set to true */
    bool double_tap_as_button_press;
    /* If true, device is considered to be "managed" by a mesh administrator
 Clients should then limit available configuration and administrative options inside the user interface
 Moved to SecurityConfig */
    bool is_managed;
    /* Disables the triple-press of user button to enable or disable GPS */
    bool disable_triple_click;
    /* POSIX Timezone definition string from https://github.com/nayarsystems/posix_tz_db/blob/master/zones.csv. */
    char tzdef[65];
    /* If true, disable the default blinking LED (LED_PIN) behavior on the device */
    bool led_heartbeat_disabled;
    /* Controls buzzer behavior for audio feedback
 Defaults to ENABLED */
    meshtastic_Config_DeviceConfig_BuzzerMode buzzer_mode;
} meshtastic_Config_DeviceConfig;

/* Position Config */
typedef struct _meshtastic_Config_PositionConfig {
    /* We should send our position this often (but only if it has changed significantly)
 Defaults to 15 minutes */
    uint32_t position_broadcast_secs;
    /* Adaptive position braoadcast, which is now the default. */
    bool position_broadcast_smart_enabled;
    /* If set, this node is at a fixed position.
 We will generate GPS position updates at the regular interval, but use whatever the last lat/lon/alt we have for the node.
 The lat/lon/alt can be set by an internal GPS or with the help of the app. */
    bool fixed_position;
    /* Is GPS enabled for this node? */
    bool gps_enabled;
    /* How often should we try to get GPS position (in seconds)
 or zero for the default of once every 30 seconds
 or a very large value (maxint) to update only once at boot. */
    uint32_t gps_update_interval;
    /* Deprecated in favor of using smart / regular broadcast intervals as implicit attempt time */
    uint32_t gps_attempt_time;
    /* Bit field of boolean configuration options for POSITION messages
 (bitwise OR of PositionFlags) */
    uint32_t position_flags;
    /* (Re)define GPS_RX_PIN for your board. */
    uint32_t rx_gpio;
    /* (Re)define GPS_TX_PIN for your board. */
    uint32_t tx_gpio;
    /* The minimum distance in meters traveled (since the last send) before we can send a position to the mesh if position_broadcast_smart_enabled */
    uint32_t broadcast_smart_minimum_distance;
    /* The minimum number of seconds (since the last send) before we can send a position to the mesh if position_broadcast_smart_enabled */
    uint32_t broadcast_smart_minimum_interval_secs;
    /* (Re)define PIN_GPS_EN for your board. */
    uint32_t gps_en_gpio;
    /* Set where GPS is enabled, disabled, or not present */
    meshtastic_Config_PositionConfig_GpsMode gps_mode;
} meshtastic_Config_PositionConfig;

/* Power Config\
 See [Power Config](/docs/settings/config/power) for additional power config details. */
typedef struct _meshtastic_Config_PowerConfig {
    /* Description: Will sleep everything as much as possible, for the tracker and sensor role this will also include the lora radio.
 Don't use this setting if you want to use your device with the phone apps or are using a device without a user button.
 Technical Details: Works for ESP32 devices and NRF52 devices in the Sensor or Tracker roles */
    bool is_power_saving;
    /* Description: If non-zero, the device will fully power off this many seconds after external power is removed. */
    uint32_t on_battery_shutdown_after_secs;
    /* Ratio of voltage divider for battery pin eg. 3.20 (R1=100k, R2=220k)
 Overrides the ADC_MULTIPLIER defined in variant for battery voltage calculation.
 https://meshtastic.org/docs/configuration/radio/power/#adc-multiplier-override
 Should be set to floating point value between 2 and 6 */
    float adc_multiplier_override;
    /* Description: The number of seconds for to wait before turning off BLE in No Bluetooth states
  Technical Details: ESP32 Only 0 for default of 1 minute */
    uint32_t wait_bluetooth_secs;
    /* Super Deep Sleep Seconds
 While in Light Sleep if mesh_sds_timeout_secs is exceeded we will lower into super deep sleep
 for this value (default 1 year) or a button press
 0 for default of one year */
    uint32_t sds_secs;
    /* Description: In light sleep the CPU is suspended, LoRa radio is on, BLE is off an GPS is on
 Technical Details: ESP32 Only 0 for default of 300 */
    uint32_t ls_secs;
    /* Description: While in light sleep when we receive packets on the LoRa radio we will wake and handle them and stay awake in no BLE mode for this value
 Technical Details: ESP32 Only 0 for default of 10 seconds */
    uint32_t min_wake_secs;
    /* I2C address of INA_2XX to use for reading device battery voltage */
    uint8_t device_battery_ina_address;
    /* If non-zero, we want powermon log outputs.  With the particular (bitfield) sources enabled.
 Note: we picked an ID of 32 so that lower more efficient IDs can be used for more frequently used options. */
    uint64_t powermon_enables;
} meshtastic_Config_PowerConfig;

typedef struct _meshtastic_Config_NetworkConfig_IpV4Config {
    /* Static IP address */
    uint32_t ip;
    /* Static gateway address */
    uint32_t gateway;
    /* Static subnet mask */
    uint32_t subnet;
    /* Static DNS server address */
    uint32_t dns;
} meshtastic_Config_NetworkConfig_IpV4Config;

/* Network Config */
typedef struct _meshtastic_Config_NetworkConfig {
    /* Enable WiFi (disables Bluetooth) */
    bool wifi_enabled;
    /* If set, this node will try to join the specified wifi network and
 acquire an address via DHCP */
    char wifi_ssid[33];
    /* If set, will be use to authenticate to the named wifi */
    char wifi_psk[65];
    /* NTP server to use if WiFi is conneced, defaults to `meshtastic.pool.ntp.org` */
    char ntp_server[33];
    /* Enable Ethernet */
    bool eth_enabled;
    /* acquire an address via DHCP or assign static */
    meshtastic_Config_NetworkConfig_AddressMode address_mode;
    /* struct to keep static address */
    bool has_ipv4_config;
    meshtastic_Config_NetworkConfig_IpV4Config ipv4_config;
    /* rsyslog Server and Port */
    char rsyslog_server[33];
    /* Flags for enabling/disabling network protocols */
    uint32_t enabled_protocols;
    /* Enable/Disable ipv6 support */
    bool ipv6_enabled;
} meshtastic_Config_NetworkConfig;

/* Display Config */
typedef struct _meshtastic_Config_DisplayConfig {
    /* Number of seconds the screen stays on after pressing the user button or receiving a message
 0 for default of one minute MAXUINT for always on */
    uint32_t screen_on_secs;
    /* Deprecated in 2.7.4: Unused
 How the GPS coordinates are formatted on the OLED screen. */
    meshtastic_Config_DisplayConfig_DeprecatedGpsCoordinateFormat gps_format;
    /* Automatically toggles to the next page on the screen like a carousel, based the specified interval in seconds.
 Potentially useful for devices without user buttons. */
    uint32_t auto_screen_carousel_secs;
    /* If this is set, the displayed compass will always point north. if unset, the old behaviour
 (top of display is heading direction) is used. */
    bool compass_north_top;
    /* Flip screen vertically, for cases that mount the screen upside down */
    bool flip_screen;
    /* Perferred display units */
    meshtastic_Config_DisplayConfig_DisplayUnits units;
    /* Override auto-detect in screen */
    meshtastic_Config_DisplayConfig_OledType oled;
    /* Display Mode */
    meshtastic_Config_DisplayConfig_DisplayMode displaymode;
    /* Print first line in pseudo-bold? FALSE is original style, TRUE is bold */
    bool heading_bold;
    /* Should we wake the screen up on accelerometer detected motion or tap */
    bool wake_on_tap_or_motion;
    /* Indicates how to rotate or invert the compass output to accurate display on the display. */
    meshtastic_Config_DisplayConfig_CompassOrientation compass_orientation;
    /* If false (default), the device will display the time in 24-hour format on screen.
 If true, the device will display the time in 12-hour format on screen. */
    bool use_12h_clock;
    /* If false (default), the device will use short names for various display screens.
 If true, node names will show in long format */
    bool use_long_node_name;
} meshtastic_Config_DisplayConfig;

/* Lora Config */
typedef struct _meshtastic_Config_LoRaConfig {
    /* When enabled, the `modem_preset` fields will be adhered to, else the `bandwidth`/`spread_factor`/`coding_rate`
 will be taked from their respective manually defined fields */
    bool use_preset;
    /* Either modem_config or bandwidth/spreading/coding will be specified - NOT BOTH.
 As a heuristic: If bandwidth is specified, do not use modem_config.
 Because protobufs take ZERO space when the value is zero this works out nicely.
 This value is replaced by bandwidth/spread_factor/coding_rate.
 If you'd like to experiment with other options add them to MeshRadio.cpp in the device code. */
    meshtastic_Config_LoRaConfig_ModemPreset modem_preset;
    /* Bandwidth in MHz
 Certain bandwidth numbers are 'special' and will be converted to the
 appropriate floating point value: 31 -> 31.25MHz */
    uint16_t bandwidth;
    /* A number from 7 to 12.
 Indicates number of chirps per symbol as 1<<spread_factor. */
    uint32_t spread_factor;
    /* The denominator of the coding rate.
 ie for 4/5, the value is 5. 4/8 the value is 8. */
    uint8_t coding_rate;
    /* This parameter is for advanced users with advanced test equipment, we do not recommend most users use it.
 A frequency offset that is added to to the calculated band center frequency.
 Used to correct for crystal calibration errors. */
    float frequency_offset;
    /* The region code for the radio (US, CN, EU433, etc...) */
    meshtastic_Config_LoRaConfig_RegionCode region;
    /* Maximum number of hops. This can't be greater than 7.
 Default of 3
 Attempting to set a value > 7 results in the default */
    uint32_t hop_limit;
    /* Disable TX from the LoRa radio. Useful for hot-swapping antennas and other tests.
 Defaults to false */
    bool tx_enabled;
    /* If zero, then use default max legal continuous power (ie. something that won't
 burn out the radio hardware)
 In most cases you should use zero here.
 Units are in dBm. */
    int8_t tx_power;
    /* This controls the actual hardware frequency the radio transmits on.
 Most users should never need to be exposed to this field/concept.
 A channel number between 1 and NUM_CHANNELS (whatever the max is in the current region).
 If ZERO then the rule is "use the old channel name hash based
 algorithm to derive the channel number")
 If using the hash algorithm the channel number will be: hash(channel_name) %
 NUM_CHANNELS (Where num channels depends on the regulatory region). */
    uint16_t channel_num;
    /* If true, duty cycle limits will be exceeded and thus you're possibly not following
 the local regulations if you're not a HAM.
 Has no effect if the duty cycle of the used region is 100%. */
    bool override_duty_cycle;
    /* If true, sets RX boosted gain mode on SX126X based radios */
    bool sx126x_rx_boosted_gain;
    /* This parameter is for advanced users and licensed HAM radio operators.
 Ignore Channel Calculation and use this frequency instead. The frequency_offset
 will still be applied. This will allow you to use out-of-band frequencies.
 Please respect your local laws and regulations. If you are a HAM, make sure you
 enable HAM mode and turn off encryption. */
    float override_frequency;
    /* If true, disable the build-in PA FAN using pin define in RF95_FAN_EN. */
    bool pa_fan_disabled;
    /* For testing it is useful sometimes to force a node to never listen to
 particular other nodes (simulating radio out of range). All nodenums listed
 in ignore_incoming will have packets they send dropped on receive (by router.cpp) */
    pb_size_t ignore_incoming_count;
    uint32_t ignore_incoming[3];
    /* If true, the device will not process any packets received via LoRa that passed via MQTT anywhere on the path towards it. */
    bool ignore_mqtt;
    /* Sets the ok_to_mqtt bit on outgoing packets */
    bool config_ok_to_mqtt;
} meshtastic_Config_LoRaConfig;

typedef struct _meshtastic_Config_BluetoothConfig {
    /* Enable Bluetooth on the device */
    bool enabled;
    /* Determines the pairing strategy for the device */
    meshtastic_Config_BluetoothConfig_PairingMode mode;
    /* Specified PIN for PairingMode.FixedPin */
    uint32_t fixed_pin;
} meshtastic_Config_BluetoothConfig;

typedef PB_BYTES_ARRAY_T(32) meshtastic_Config_SecurityConfig_public_key_t;
typedef PB_BYTES_ARRAY_T(32) meshtastic_Config_SecurityConfig_private_key_t;
typedef PB_BYTES_ARRAY_T(32) meshtastic_Config_SecurityConfig_admin_key_t;
typedef struct _meshtastic_Config_SecurityConfig {
    /* The public key of the user's device.
 Sent out to other nodes on the mesh to allow them to compute a shared secret key. */
    meshtastic_Config_SecurityConfig_public_key_t public_key;
    /* The private key of the device.
 Used to create a shared key with a remote device. */
    meshtastic_Config_SecurityConfig_private_key_t private_key;
    /* The public key authorized to send admin messages to this node. */
    pb_size_t admin_key_count;
    meshtastic_Config_SecurityConfig_admin_key_t admin_key[3];
    /* If true, device is considered to be "managed" by a mesh administrator via admin messages
 Device is managed by a mesh administrator. */
    bool is_managed;
    /* Serial Console over the Stream API." */
    bool serial_enabled;
    /* By default we turn off logging as soon as an API client connects (to keep shared serial link quiet).
 Output live debug logging over serial or bluetooth is set to true. */
    bool debug_log_api_enabled;
    /* Allow incoming device control over the insecure legacy admin channel. */
    bool admin_channel_enabled;
} meshtastic_Config_SecurityConfig;

/* Blank config request, strictly for getting the session key */
typedef struct _meshtastic_Config_SessionkeyConfig {
    char dummy_field;
} meshtastic_Config_SessionkeyConfig;

typedef struct _meshtastic_Config {
    pb_size_t which_payload_variant;
    union {
        meshtastic_Config_DeviceConfig device;
        meshtastic_Config_PositionConfig position;
        meshtastic_Config_PowerConfig power;
        meshtastic_Config_NetworkConfig network;
        meshtastic_Config_DisplayConfig display;
        meshtastic_Config_LoRaConfig lora;
        meshtastic_Config_BluetoothConfig bluetooth;
        meshtastic_Config_SecurityConfig security;
        meshtastic_Config_SessionkeyConfig sessionkey;
        meshtastic_DeviceUIConfig device_ui;
    } payload_variant;
} meshtastic_Config;


#ifdef __cplusplus
extern "C" {
#endif

/* Helper constants for enums */
#define _meshtastic_Config_DeviceConfig_Role_MIN meshtastic_Config_DeviceConfig_Role_CLIENT
#define _meshtastic_Config_DeviceConfig_Role_MAX meshtastic_Config_DeviceConfig_Role_CLIENT_BASE
#define _meshtastic_Config_DeviceConfig_Role_ARRAYSIZE ((meshtastic_Config_DeviceConfig_Role)(meshtastic_Config_DeviceConfig_Role_CLIENT_BASE+1))

#define _meshtastic_Config_DeviceConfig_RebroadcastMode_MIN meshtastic_Config_DeviceConfig_RebroadcastMode_ALL
#define _meshtastic_Config_DeviceConfig_RebroadcastMode_MAX meshtastic_Config_DeviceConfig_RebroadcastMode_CORE_PORTNUMS_ONLY
#define _meshtastic_Config_DeviceConfig_RebroadcastMode_ARRAYSIZE ((meshtastic_Config_DeviceConfig_RebroadcastMode)(meshtastic_Config_DeviceConfig_RebroadcastMode_CORE_PORTNUMS_ONLY+1))

#define _meshtastic_Config_DeviceConfig_BuzzerMode_MIN meshtastic_Config_DeviceConfig_BuzzerMode_ALL_ENABLED
#define _meshtastic_Config_DeviceConfig_BuzzerMode_MAX meshtastic_Config_DeviceConfig_BuzzerMode_DIRECT_MSG_ONLY
#define _meshtastic_Config_DeviceConfig_BuzzerMode_ARRAYSIZE ((meshtastic_Config_DeviceConfig_BuzzerMode)(meshtastic_Config_DeviceConfig_BuzzerMode_DIRECT_MSG_ONLY+1))

#define _meshtastic_Config_PositionConfig_PositionFlags_MIN meshtastic_Config_PositionConfig_PositionFlags_UNSET
#define _meshtastic_Config_PositionConfig_PositionFlags_MAX meshtastic_Config_PositionConfig_PositionFlags_SPEED
#define _meshtastic_Config_PositionConfig_PositionFlags_ARRAYSIZE ((meshtastic_Config_PositionConfig_PositionFlags)(meshtastic_Config_PositionConfig_PositionFlags_SPEED+1))

#define _meshtastic_Config_PositionConfig_GpsMode_MIN meshtastic_Config_PositionConfig_GpsMode_DISABLED
#define _meshtastic_Config_PositionConfig_GpsMode_MAX meshtastic_Config_PositionConfig_GpsMode_NOT_PRESENT
#define _meshtastic_Config_PositionConfig_GpsMode_ARRAYSIZE ((meshtastic_Config_PositionConfig_GpsMode)(meshtastic_Config_PositionConfig_GpsMode_NOT_PRESENT+1))

#define _meshtastic_Config_NetworkConfig_AddressMode_MIN meshtastic_Config_NetworkConfig_AddressMode_DHCP
#define _meshtastic_Config_NetworkConfig_AddressMode_MAX meshtastic_Config_NetworkConfig_AddressMode_STATIC
#define _meshtastic_Config_NetworkConfig_AddressMode_ARRAYSIZE ((meshtastic_Config_NetworkConfig_AddressMode)(meshtastic_Config_NetworkConfig_AddressMode_STATIC+1))

#define _meshtastic_Config_NetworkConfig_ProtocolFlags_MIN meshtastic_Config_NetworkConfig_ProtocolFlags_NO_BROADCAST
#define _meshtastic_Config_NetworkConfig_ProtocolFlags_MAX meshtastic_Config_NetworkConfig_ProtocolFlags_UDP_BROADCAST
#define _meshtastic_Config_NetworkConfig_ProtocolFlags_ARRAYSIZE ((meshtastic_Config_NetworkConfig_ProtocolFlags)(meshtastic_Config_NetworkConfig_ProtocolFlags_UDP_BROADCAST+1))

#define _meshtastic_Config_DisplayConfig_DeprecatedGpsCoordinateFormat_MIN meshtastic_Config_DisplayConfig_DeprecatedGpsCoordinateFormat_UNUSED
#define _meshtastic_Config_DisplayConfig_DeprecatedGpsCoordinateFormat_MAX meshtastic_Config_DisplayConfig_DeprecatedGpsCoordinateFormat_UNUSED
#define _meshtastic_Config_DisplayConfig_DeprecatedGpsCoordinateFormat_ARRAYSIZE ((meshtastic_Config_DisplayConfig_DeprecatedGpsCoordinateFormat)(meshtastic_Config_DisplayConfig_DeprecatedGpsCoordinateFormat_UNUSED+1))

#define _meshtastic_Config_DisplayConfig_DisplayUnits_MIN meshtastic_Config_DisplayConfig_DisplayUnits_METRIC
#define _meshtastic_Config_DisplayConfig_DisplayUnits_MAX meshtastic_Config_DisplayConfig_DisplayUnits_IMPERIAL
#define _meshtastic_Config_DisplayConfig_DisplayUnits_ARRAYSIZE ((meshtastic_Config_DisplayConfig_DisplayUnits)(meshtastic_Config_DisplayConfig_DisplayUnits_IMPERIAL+1))

#define _meshtastic_Config_DisplayConfig_OledType_MIN meshtastic_Config_DisplayConfig_OledType_OLED_AUTO
#define _meshtastic_Config_DisplayConfig_OledType_MAX meshtastic_Config_DisplayConfig_OledType_OLED_SH1107_128_128
#define _meshtastic_Config_DisplayConfig_OledType_ARRAYSIZE ((meshtastic_Config_DisplayConfig_OledType)(meshtastic_Config_DisplayConfig_OledType_OLED_SH1107_128_128+1))

#define _meshtastic_Config_DisplayConfig_DisplayMode_MIN meshtastic_Config_DisplayConfig_DisplayMode_DEFAULT
#define _meshtastic_Config_DisplayConfig_DisplayMode_MAX meshtastic_Config_DisplayConfig_DisplayMode_COLOR
#define _meshtastic_Config_DisplayConfig_DisplayMode_ARRAYSIZE ((meshtastic_Config_DisplayConfig_DisplayMode)(meshtastic_Config_DisplayConfig_DisplayMode_COLOR+1))

#define _meshtastic_Config_DisplayConfig_CompassOrientation_MIN meshtastic_Config_DisplayConfig_CompassOrientation_DEGREES_0
#define _meshtastic_Config_DisplayConfig_CompassOrientation_MAX meshtastic_Config_DisplayConfig_CompassOrientation_DEGREES_270_INVERTED
#define _meshtastic_Config_DisplayConfig_CompassOrientation_ARRAYSIZE ((meshtastic_Config_DisplayConfig_CompassOrientation)(meshtastic_Config_DisplayConfig_CompassOrientation_DEGREES_270_INVERTED+1))

#define _meshtastic_Config_LoRaConfig_RegionCode_MIN meshtastic_Config_LoRaConfig_RegionCode_UNSET
#define _meshtastic_Config_LoRaConfig_RegionCode_MAX meshtastic_Config_LoRaConfig_RegionCode_BR_902
#define _meshtastic_Config_LoRaConfig_RegionCode_ARRAYSIZE ((meshtastic_Config_LoRaConfig_RegionCode)(meshtastic_Config_LoRaConfig_RegionCode_BR_902+1))

#define _meshtastic_Config_LoRaConfig_ModemPreset_MIN meshtastic_Config_LoRaConfig_ModemPreset_LONG_FAST
#define _meshtastic_Config_LoRaConfig_ModemPreset_MAX meshtastic_Config_LoRaConfig_ModemPreset_SHORT_TURBO
#define _meshtastic_Config_LoRaConfig_ModemPreset_ARRAYSIZE ((meshtastic_Config_LoRaConfig_ModemPreset)(meshtastic_Config_LoRaConfig_ModemPreset_SHORT_TURBO+1))

#define _meshtastic_Config_BluetoothConfig_PairingMode_MIN meshtastic_Config_BluetoothConfig_PairingMode_RANDOM_PIN
#define _meshtastic_Config_BluetoothConfig_PairingMode_MAX meshtastic_Config_BluetoothConfig_PairingMode_NO_PIN
#define _meshtastic_Config_BluetoothConfig_PairingMode_ARRAYSIZE ((meshtastic_Config_BluetoothConfig_PairingMode)(meshtastic_Config_BluetoothConfig_PairingMode_NO_PIN+1))


#define meshtastic_Config_DeviceConfig_role_ENUMTYPE meshtastic_Config_DeviceConfig_Role
#define meshtastic_Config_DeviceConfig_rebroadcast_mode_ENUMTYPE meshtastic_Config_DeviceConfig_RebroadcastMode
#define meshtastic_Config_DeviceConfig_buzzer_mode_ENUMTYPE meshtastic_Config_DeviceConfig_BuzzerMode

#define meshtastic_Config_PositionConfig_gps_mode_ENUMTYPE meshtastic_Config_PositionConfig_GpsMode


#define meshtastic_Config_NetworkConfig_address_mode_ENUMTYPE meshtastic_Config_NetworkConfig_AddressMode


#define meshtastic_Config_DisplayConfig_gps_format_ENUMTYPE meshtastic_Config_DisplayConfig_DeprecatedGpsCoordinateFormat
#define meshtastic_Config_DisplayConfig_units_ENUMTYPE meshtastic_Config_DisplayConfig_DisplayUnits
#define meshtastic_Config_DisplayConfig_oled_ENUMTYPE meshtastic_Config_DisplayConfig_OledType
#define meshtastic_Config_DisplayConfig_displaymode_ENUMTYPE meshtastic_Config_DisplayConfig_DisplayMode
#define meshtastic_Config_DisplayConfig_compass_orientation_ENUMTYPE meshtastic_Config_DisplayConfig_CompassOrientation

#define meshtastic_Config_LoRaConfig_modem_preset_ENUMTYPE meshtastic_Config_LoRaConfig_ModemPreset
#define meshtastic_Config_LoRaConfig_region_ENUMTYPE meshtastic_Config_LoRaConfig_RegionCode

#define meshtastic_Config_BluetoothConfig_mode_ENUMTYPE meshtastic_Config_BluetoothConfig_PairingMode




/* Initializer values for message structs */
#define meshtastic_Config_init_default           {0, {meshtastic_Config_DeviceConfig_init_default}}
#define meshtastic_Config_DeviceConfig_init_default {_meshtastic_Config_DeviceConfig_Role_MIN, 0, 0, 0, _meshtastic_Config_DeviceConfig_RebroadcastMode_MIN, 0, 0, 0, 0, "", 0, _meshtastic_Config_DeviceConfig_BuzzerMode_MIN}
#define meshtastic_Config_PositionConfig_init_default {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, _meshtastic_Config_PositionConfig_GpsMode_MIN}
#define meshtastic_Config_PowerConfig_init_default {0, 0, 0, 0, 0, 0, 0, 0, 0}
#define meshtastic_Config_NetworkConfig_init_default {0, "", "", "", 0, _meshtastic_Config_NetworkConfig_AddressMode_MIN, false, meshtastic_Config_NetworkConfig_IpV4Config_init_default, "", 0, 0}
#define meshtastic_Config_NetworkConfig_IpV4Config_init_default {0, 0, 0, 0}
#define meshtastic_Config_DisplayConfig_init_default {0, _meshtastic_Config_DisplayConfig_DeprecatedGpsCoordinateFormat_MIN, 0, 0, 0, _meshtastic_Config_DisplayConfig_DisplayUnits_MIN, _meshtastic_Config_DisplayConfig_OledType_MIN, _meshtastic_Config_DisplayConfig_DisplayMode_MIN, 0, 0, _meshtastic_Config_DisplayConfig_CompassOrientation_MIN, 0, 0}
#define meshtastic_Config_LoRaConfig_init_default {0, _meshtastic_Config_LoRaConfig_ModemPreset_MIN, 0, 0, 0, 0, _meshtastic_Config_LoRaConfig_RegionCode_MIN, 0, 0, 0, 0, 0, 0, 0, 0, 0, {0, 0, 0}, 0, 0}
#define meshtastic_Config_BluetoothConfig_init_default {0, _meshtastic_Config_BluetoothConfig_PairingMode_MIN, 0}
#define meshtastic_Config_SecurityConfig_init_default {{0, {0}}, {0, {0}}, 0, {{0, {0}}, {0, {0}}, {0, {0}}}, 0, 0, 0, 0}
#define meshtastic_Config_SessionkeyConfig_init_default {0}
#define meshtastic_Config_init_zero              {0, {meshtastic_Config_DeviceConfig_init_zero}}
#define meshtastic_Config_DeviceConfig_init_zero {_meshtastic_Config_DeviceConfig_Role_MIN, 0, 0, 0, _meshtastic_Config_DeviceConfig_RebroadcastMode_MIN, 0, 0, 0, 0, "", 0, _meshtastic_Config_DeviceConfig_BuzzerMode_MIN}
#define meshtastic_Config_PositionConfig_init_zero {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, _meshtastic_Config_PositionConfig_GpsMode_MIN}
#define meshtastic_Config_PowerConfig_init_zero  {0, 0, 0, 0, 0, 0, 0, 0, 0}
#define meshtastic_Config_NetworkConfig_init_zero {0, "", "", "", 0, _meshtastic_Config_NetworkConfig_AddressMode_MIN, false, meshtastic_Config_NetworkConfig_IpV4Config_init_zero, "", 0, 0}
#define meshtastic_Config_NetworkConfig_IpV4Config_init_zero {0, 0, 0, 0}
#define meshtastic_Config_DisplayConfig_init_zero {0, _meshtastic_Config_DisplayConfig_DeprecatedGpsCoordinateFormat_MIN, 0, 0, 0, _meshtastic_Config_DisplayConfig_DisplayUnits_MIN, _meshtastic_Config_DisplayConfig_OledType_MIN, _meshtastic_Config_DisplayConfig_DisplayMode_MIN, 0, 0, _meshtastic_Config_DisplayConfig_CompassOrientation_MIN, 0, 0}
#define meshtastic_Config_LoRaConfig_init_zero   {0, _meshtastic_Config_LoRaConfig_ModemPreset_MIN, 0, 0, 0, 0, _meshtastic_Config_LoRaConfig_RegionCode_MIN, 0, 0, 0, 0, 0, 0, 0, 0, 0, {0, 0, 0}, 0, 0}
#define meshtastic_Config_BluetoothConfig_init_zero {0, _meshtastic_Config_BluetoothConfig_PairingMode_MIN, 0}
#define meshtastic_Config_SecurityConfig_init_zero {{0, {0}}, {0, {0}}, 0, {{0, {0}}, {0, {0}}, {0, {0}}}, 0, 0, 0, 0}
#define meshtastic_Config_SessionkeyConfig_init_zero {0}

/* Field tags (for use in manual encoding/decoding) */
#define meshtastic_Config_DeviceConfig_role_tag  1
#define meshtastic_Config_DeviceConfig_serial_enabled_tag 2
#define meshtastic_Config_DeviceConfig_button_gpio_tag 4
#define meshtastic_Config_DeviceConfig_buzzer_gpio_tag 5
#define meshtastic_Config_DeviceConfig_rebroadcast_mode_tag 6
#define meshtastic_Config_DeviceConfig_node_info_broadcast_secs_tag 7
#define meshtastic_Config_DeviceConfig_double_tap_as_button_press_tag 8
#define meshtastic_Config_DeviceConfig_is_managed_tag 9
#define meshtastic_Config_DeviceConfig_disable_triple_click_tag 10
#define meshtastic_Config_DeviceConfig_tzdef_tag 11
#define meshtastic_Config_DeviceConfig_led_heartbeat_disabled_tag 12
#define meshtastic_Config_DeviceConfig_buzzer_mode_tag 13
#define meshtastic_Config_PositionConfig_position_broadcast_secs_tag 1
#define meshtastic_Config_PositionConfig_position_broadcast_smart_enabled_tag 2
#define meshtastic_Config_PositionConfig_fixed_position_tag 3
#define meshtastic_Config_PositionConfig_gps_enabled_tag 4
#define meshtastic_Config_PositionConfig_gps_update_interval_tag 5
#define meshtastic_Config_PositionConfig_gps_attempt_time_tag 6
#define meshtastic_Config_PositionConfig_position_flags_tag 7
#define meshtastic_Config_PositionConfig_rx_gpio_tag 8
#define meshtastic_Config_PositionConfig_tx_gpio_tag 9
#define meshtastic_Config_PositionConfig_broadcast_smart_minimum_distance_tag 10
#define meshtastic_Config_PositionConfig_broadcast_smart_minimum_interval_secs_tag 11
#define meshtastic_Config_PositionConfig_gps_en_gpio_tag 12
#define meshtastic_Config_PositionConfig_gps_mode_tag 13
#define meshtastic_Config_PowerConfig_is_power_saving_tag 1
#define meshtastic_Config_PowerConfig_on_battery_shutdown_after_secs_tag 2
#define meshtastic_Config_PowerConfig_adc_multiplier_override_tag 3
#define meshtastic_Config_PowerConfig_wait_bluetooth_secs_tag 4
#define meshtastic_Config_PowerConfig_sds_secs_tag 6
#define meshtastic_Config_PowerConfig_ls_secs_tag 7
#define meshtastic_Config_PowerConfig_min_wake_secs_tag 8
#define meshtastic_Config_PowerConfig_device_battery_ina_address_tag 9
#define meshtastic_Config_PowerConfig_powermon_enables_tag 32
#define meshtastic_Config_NetworkConfig_IpV4Config_ip_tag 1
#define meshtastic_Config_NetworkConfig_IpV4Config_gateway_tag 2
#define meshtastic_Config_NetworkConfig_IpV4Config_subnet_tag 3
#define meshtastic_Config_NetworkConfig_IpV4Config_dns_tag 4
#define meshtastic_Config_NetworkConfig_wifi_enabled_tag 1
#define meshtastic_Config_NetworkConfig_wifi_ssid_tag 3
#define meshtastic_Config_NetworkConfig_wifi_psk_tag 4
#define meshtastic_Config_NetworkConfig_ntp_server_tag 5
#define meshtastic_Config_NetworkConfig_eth_enabled_tag 6
#define meshtastic_Config_NetworkConfig_address_mode_tag 7
#define meshtastic_Config_NetworkConfig_ipv4_config_tag 8
#define meshtastic_Config_NetworkConfig_rsyslog_server_tag 9
#define meshtastic_Config_NetworkConfig_enabled_protocols_tag 10
#define meshtastic_Config_NetworkConfig_ipv6_enabled_tag 11
#define meshtastic_Config_DisplayConfig_screen_on_secs_tag 1
#define meshtastic_Config_DisplayConfig_gps_format_tag 2
#define meshtastic_Config_DisplayConfig_auto_screen_carousel_secs_tag 3
#define meshtastic_Config_DisplayConfig_compass_north_top_tag 4
#define meshtastic_Config_DisplayConfig_flip_screen_tag 5
#define meshtastic_Config_DisplayConfig_units_tag 6
#define meshtastic_Config_DisplayConfig_oled_tag 7
#define meshtastic_Config_DisplayConfig_displaymode_tag 8
#define meshtastic_Config_DisplayConfig_heading_bold_tag 9
#define meshtastic_Config_DisplayConfig_wake_on_tap_or_motion_tag 10
#define meshtastic_Config_DisplayConfig_compass_orientation_tag 11
#define meshtastic_Config_DisplayConfig_use_12h_clock_tag 12
#define meshtastic_Config_DisplayConfig_use_long_node_name_tag 13
#define meshtastic_Config_LoRaConfig_use_preset_tag 1
#define meshtastic_Config_LoRaConfig_modem_preset_tag 2
#define meshtastic_Config_LoRaConfig_bandwidth_tag 3
#define meshtastic_Config_LoRaConfig_spread_factor_tag 4
#define meshtastic_Config_LoRaConfig_coding_rate_tag 5
#define meshtastic_Config_LoRaConfig_frequency_offset_tag 6
#define meshtastic_Config_LoRaConfig_region_tag  7
#define meshtastic_Config_LoRaConfig_hop_limit_tag 8
#define meshtastic_Config_LoRaConfig_tx_enabled_tag 9
#define meshtastic_Config_LoRaConfig_tx_power_tag 10
#define meshtastic_Config_LoRaConfig_channel_num_tag 11
#define meshtastic_Config_LoRaConfig_override_duty_cycle_tag 12
#define meshtastic_Config_LoRaConfig_sx126x_rx_boosted_gain_tag 13
#define meshtastic_Config_LoRaConfig_override_frequency_tag 14
#define meshtastic_Config_LoRaConfig_pa_fan_disabled_tag 15
#define meshtastic_Config_LoRaConfig_ignore_incoming_tag 103
#define meshtastic_Config_LoRaConfig_ignore_mqtt_tag 104
#define meshtastic_Config_LoRaConfig_config_ok_to_mqtt_tag 105
#define meshtastic_Config_BluetoothConfig_enabled_tag 1
#define meshtastic_Config_BluetoothConfig_mode_tag 2
#define meshtastic_Config_BluetoothConfig_fixed_pin_tag 3
#define meshtastic_Config_SecurityConfig_public_key_tag 1
#define meshtastic_Config_SecurityConfig_private_key_tag 2
#define meshtastic_Config_SecurityConfig_admin_key_tag 3
#define meshtastic_Config_SecurityConfig_is_managed_tag 4
#define meshtastic_Config_SecurityConfig_serial_enabled_tag 5
#define meshtastic_Config_SecurityConfig_debug_log_api_enabled_tag 6
#define meshtastic_Config_SecurityConfig_admin_channel_enabled_tag 8
#define meshtastic_Config_device_tag             1
#define meshtastic_Config_position_tag           2
#define meshtastic_Config_power_tag              3
#define meshtastic_Config_network_tag            4
#define meshtastic_Config_display_tag            5
#define meshtastic_Config_lora_tag               6
#define meshtastic_Config_bluetooth_tag          7
#define meshtastic_Config_security_tag           8
#define meshtastic_Config_sessionkey_tag         9
#define meshtastic_Config_device_ui_tag          10

/* Struct field encoding specification for nanopb */
#define meshtastic_Config_FIELDLIST(X, a) \
X(a, STATIC,   ONEOF,    MESSAGE,  (payload_variant,device,payload_variant.device),   1) \
X(a, STATIC,   ONEOF,    MESSAGE,  (payload_variant,position,payload_variant.position),   2) \
X(a, STATIC,   ONEOF,    MESSAGE,  (payload_variant,power,payload_variant.power),   3) \
X(a, STATIC,   ONEOF,    MESSAGE,  (payload_variant,network,payload_variant.network),   4) \
X(a, STATIC,   ONEOF,    MESSAGE,  (payload_variant,display,payload_variant.display),   5) \
X(a, STATIC,   ONEOF,    MESSAGE,  (payload_variant,lora,payload_variant.lora),   6) \
X(a, STATIC,   ONEOF,    MESSAGE,  (payload_variant,bluetooth,payload_variant.bluetooth),   7) \
X(a, STATIC,   ONEOF,    MESSAGE,  (payload_variant,security,payload_variant.security),   8) \
X(a, STATIC,   ONEOF,    MESSAGE,  (payload_variant,sessionkey,payload_variant.sessionkey),   9) \
X(a, STATIC,   ONEOF,    MESSAGE,  (payload_variant,device_ui,payload_variant.device_ui),  10)
#define meshtastic_Config_CALLBACK NULL
#define meshtastic_Config_DEFAULT NULL
#define meshtastic_Config_payload_variant_device_MSGTYPE meshtastic_Config_DeviceConfig
#define meshtastic_Config_payload_variant_position_MSGTYPE meshtastic_Config_PositionConfig
#define meshtastic_Config_payload_variant_power_MSGTYPE meshtastic_Config_PowerConfig
#define meshtastic_Config_payload_variant_network_MSGTYPE meshtastic_Config_NetworkConfig
#define meshtastic_Config_payload_variant_display_MSGTYPE meshtastic_Config_DisplayConfig
#define meshtastic_Config_payload_variant_lora_MSGTYPE meshtastic_Config_LoRaConfig
#define meshtastic_Config_payload_variant_bluetooth_MSGTYPE meshtastic_Config_BluetoothConfig
#define meshtastic_Config_payload_variant_security_MSGTYPE meshtastic_Config_SecurityConfig
#define meshtastic_Config_payload_variant_sessionkey_MSGTYPE meshtastic_Config_SessionkeyConfig
#define meshtastic_Config_payload_variant_device_ui_MSGTYPE meshtastic_DeviceUIConfig

#define meshtastic_Config_DeviceConfig_FIELDLIST(X, a) \
X(a, STATIC,   SINGULAR, UENUM,    role,              1) \
X(a, STATIC,   SINGULAR, BOOL,     serial_enabled,    2) \
X(a, STATIC,   SINGULAR, UINT32,   button_gpio,       4) \
X(a, STATIC,   SINGULAR, UINT32,   buzzer_gpio,       5) \
X(a, STATIC,   SINGULAR, UENUM,    rebroadcast_mode,   6) \
X(a, STATIC,   SINGULAR, UINT32,   node_info_broadcast_secs,   7) \
X(a, STATIC,   SINGULAR, BOOL,     double_tap_as_button_press,   8) \
X(a, STATIC,   SINGULAR, BOOL,     is_managed,        9) \
X(a, STATIC,   SINGULAR, BOOL,     disable_triple_click,  10) \
X(a, STATIC,   SINGULAR, STRING,   tzdef,            11) \
X(a, STATIC,   SINGULAR, BOOL,     led_heartbeat_disabled,  12) \
X(a, STATIC,   SINGULAR, UENUM,    buzzer_mode,      13)
#define meshtastic_Config_DeviceConfig_CALLBACK NULL
#define meshtastic_Config_DeviceConfig_DEFAULT NULL

#define meshtastic_Config_PositionConfig_FIELDLIST(X, a) \
X(a, STATIC,   SINGULAR, UINT32,   position_broadcast_secs,   1) \
X(a, STATIC,   SINGULAR, BOOL,     position_broadcast_smart_enabled,   2) \
X(a, STATIC,   SINGULAR, BOOL,     fixed_position,    3) \
X(a, STATIC,   SINGULAR, BOOL,     gps_enabled,       4) \
X(a, STATIC,   SINGULAR, UINT32,   gps_update_interval,   5) \
X(a, STATIC,   SINGULAR, UINT32,   gps_attempt_time,   6) \
X(a, STATIC,   SINGULAR, UINT32,   position_flags,    7) \
X(a, STATIC,   SINGULAR, UINT32,   rx_gpio,           8) \
X(a, STATIC,   SINGULAR, UINT32,   tx_gpio,           9) \
X(a, STATIC,   SINGULAR, UINT32,   broadcast_smart_minimum_distance,  10) \
X(a, STATIC,   SINGULAR, UINT32,   broadcast_smart_minimum_interval_secs,  11) \
X(a, STATIC,   SINGULAR, UINT32,   gps_en_gpio,      12) \
X(a, STATIC,   SINGULAR, UENUM,    gps_mode,         13)
#define meshtastic_Config_PositionConfig_CALLBACK NULL
#define meshtastic_Config_PositionConfig_DEFAULT NULL

#define meshtastic_Config_PowerConfig_FIELDLIST(X, a) \
X(a, STATIC,   SINGULAR, BOOL,     is_power_saving,   1) \
X(a, STATIC,   SINGULAR, UINT32,   on_battery_shutdown_after_secs,   2) \
X(a, STATIC,   SINGULAR, FLOAT,    adc_multiplier_override,   3) \
X(a, STATIC,   SINGULAR, UINT32,   wait_bluetooth_secs,   4) \
X(a, STATIC,   SINGULAR, UINT32,   sds_secs,          6) \
X(a, STATIC,   SINGULAR, UINT32,   ls_secs,           7) \
X(a, STATIC,   SINGULAR, UINT32,   min_wake_secs,     8) \
X(a, STATIC,   SINGULAR, UINT32,   device_battery_ina_address,   9) \
X(a, STATIC,   SINGULAR, UINT64,   powermon_enables,  32)
#define meshtastic_Config_PowerConfig_CALLBACK NULL
#define meshtastic_Config_PowerConfig_DEFAULT NULL

#define meshtastic_Config_NetworkConfig_FIELDLIST(X, a) \
X(a, STATIC,   SINGULAR, BOOL,     wifi_enabled,      1) \
X(a, STATIC,   SINGULAR, STRING,   wifi_ssid,         3) \
X(a, STATIC,   SINGULAR, STRING,   wifi_psk,          4) \
X(a, STATIC,   SINGULAR, STRING,   ntp_server,        5) \
X(a, STATIC,   SINGULAR, BOOL,     eth_enabled,       6) \
X(a, STATIC,   SINGULAR, UENUM,    address_mode,      7) \
X(a, STATIC,   OPTIONAL, MESSAGE,  ipv4_config,       8) \
X(a, STATIC,   SINGULAR, STRING,   rsyslog_server,    9) \
X(a, STATIC,   SINGULAR, UINT32,   enabled_protocols,  10) \
X(a, STATIC,   SINGULAR, BOOL,     ipv6_enabled,     11)
#define meshtastic_Config_NetworkConfig_CALLBACK NULL
#define meshtastic_Config_NetworkConfig_DEFAULT NULL
#define meshtastic_Config_NetworkConfig_ipv4_config_MSGTYPE meshtastic_Config_NetworkConfig_IpV4Config

#define meshtastic_Config_NetworkConfig_IpV4Config_FIELDLIST(X, a) \
X(a, STATIC,   SINGULAR, FIXED32,  ip,                1) \
X(a, STATIC,   SINGULAR, FIXED32,  gateway,           2) \
X(a, STATIC,   SINGULAR, FIXED32,  subnet,            3) \
X(a, STATIC,   SINGULAR, FIXED32,  dns,               4)
#define meshtastic_Config_NetworkConfig_IpV4Config_CALLBACK NULL
#define meshtastic_Config_NetworkConfig_IpV4Config_DEFAULT NULL

#define meshtastic_Config_DisplayConfig_FIELDLIST(X, a) \
X(a, STATIC,   SINGULAR, UINT32,   screen_on_secs,    1) \
X(a, STATIC,   SINGULAR, UENUM,    gps_format,        2) \
X(a, STATIC,   SINGULAR, UINT32,   auto_screen_carousel_secs,   3) \
X(a, STATIC,   SINGULAR, BOOL,     compass_north_top,   4) \
X(a, STATIC,   SINGULAR, BOOL,     flip_screen,       5) \
X(a, STATIC,   SINGULAR, UENUM,    units,             6) \
X(a, STATIC,   SINGULAR, UENUM,    oled,              7) \
X(a, STATIC,   SINGULAR, UENUM,    displaymode,       8) \
X(a, STATIC,   SINGULAR, BOOL,     heading_bold,      9) \
X(a, STATIC,   SINGULAR, BOOL,     wake_on_tap_or_motion,  10) \
X(a, STATIC,   SINGULAR, UENUM,    compass_orientation,  11) \
X(a, STATIC,   SINGULAR, BOOL,     use_12h_clock,    12) \
X(a, STATIC,   SINGULAR, BOOL,     use_long_node_name,  13)
#define meshtastic_Config_DisplayConfig_CALLBACK NULL
#define meshtastic_Config_DisplayConfig_DEFAULT NULL

#define meshtastic_Config_LoRaConfig_FIELDLIST(X, a) \
X(a, STATIC,   SINGULAR, BOOL,     use_preset,        1) \
X(a, STATIC,   SINGULAR, UENUM,    modem_preset,      2) \
X(a, STATIC,   SINGULAR, UINT32,   bandwidth,         3) \
X(a, STATIC,   SINGULAR, UINT32,   spread_factor,     4) \
X(a, STATIC,   SINGULAR, UINT32,   coding_rate,       5) \
X(a, STATIC,   SINGULAR, FLOAT,    frequency_offset,   6) \
X(a, STATIC,   SINGULAR, UENUM,    region,            7) \
X(a, STATIC,   SINGULAR, UINT32,   hop_limit,         8) \
X(a, STATIC,   SINGULAR, BOOL,     tx_enabled,        9) \
X(a, STATIC,   SINGULAR, INT32,    tx_power,         10) \
X(a, STATIC,   SINGULAR, UINT32,   channel_num,      11) \
X(a, STATIC,   SINGULAR, BOOL,     override_duty_cycle,  12) \
X(a, STATIC,   SINGULAR, BOOL,     sx126x_rx_boosted_gain,  13) \
X(a, STATIC,   SINGULAR, FLOAT,    override_frequency,  14) \
X(a, STATIC,   SINGULAR, BOOL,     pa_fan_disabled,  15) \
X(a, STATIC,   REPEATED, UINT32,   ignore_incoming, 103) \
X(a, STATIC,   SINGULAR, BOOL,     ignore_mqtt,     104) \
X(a, STATIC,   SINGULAR, BOOL,     config_ok_to_mqtt, 105)
#define meshtastic_Config_LoRaConfig_CALLBACK NULL
#define meshtastic_Config_LoRaConfig_DEFAULT NULL

#define meshtastic_Config_BluetoothConfig_FIELDLIST(X, a) \
X(a, STATIC,   SINGULAR, BOOL,     enabled,           1) \
X(a, STATIC,   SINGULAR, UENUM,    mode,              2) \
X(a, STATIC,   SINGULAR, UINT32,   fixed_pin,         3)
#define meshtastic_Config_BluetoothConfig_CALLBACK NULL
#define meshtastic_Config_BluetoothConfig_DEFAULT NULL

#define meshtastic_Config_SecurityConfig_FIELDLIST(X, a) \
X(a, STATIC,   SINGULAR, BYTES,    public_key,        1) \
X(a, STATIC,   SINGULAR, BYTES,    private_key,       2) \
X(a, STATIC,   REPEATED, BYTES,    admin_key,         3) \
X(a, STATIC,   SINGULAR, BOOL,     is_managed,        4) \
X(a, STATIC,   SINGULAR, BOOL,     serial_enabled,    5) \
X(a, STATIC,   SINGULAR, BOOL,     debug_log_api_enabled,   6) \
X(a, STATIC,   SINGULAR, BOOL,     admin_channel_enabled,   8)
#define meshtastic_Config_SecurityConfig_CALLBACK NULL
#define meshtastic_Config_SecurityConfig_DEFAULT NULL

#define meshtastic_Config_SessionkeyConfig_FIELDLIST(X, a) \

#define meshtastic_Config_SessionkeyConfig_CALLBACK NULL
#define meshtastic_Config_SessionkeyConfig_DEFAULT NULL

extern const pb_msgdesc_t meshtastic_Config_msg;
extern const pb_msgdesc_t meshtastic_Config_DeviceConfig_msg;
extern const pb_msgdesc_t meshtastic_Config_PositionConfig_msg;
extern const pb_msgdesc_t meshtastic_Config_PowerConfig_msg;
extern const pb_msgdesc_t meshtastic_Config_NetworkConfig_msg;
extern const pb_msgdesc_t meshtastic_Config_NetworkConfig_IpV4Config_msg;
extern const pb_msgdesc_t meshtastic_Config_DisplayConfig_msg;
extern const pb_msgdesc_t meshtastic_Config_LoRaConfig_msg;
extern const pb_msgdesc_t meshtastic_Config_BluetoothConfig_msg;
extern const pb_msgdesc_t meshtastic_Config_SecurityConfig_msg;
extern const pb_msgdesc_t meshtastic_Config_SessionkeyConfig_msg;

/* Defines for backwards compatibility with code written before nanopb-0.4.0 */
#define meshtastic_Config_fields &meshtastic_Config_msg
#define meshtastic_Config_DeviceConfig_fields &meshtastic_Config_DeviceConfig_msg
#define meshtastic_Config_PositionConfig_fields &meshtastic_Config_PositionConfig_msg
#define meshtastic_Config_PowerConfig_fields &meshtastic_Config_PowerConfig_msg
#define meshtastic_Config_NetworkConfig_fields &meshtastic_Config_NetworkConfig_msg
#define meshtastic_Config_NetworkConfig_IpV4Config_fields &meshtastic_Config_NetworkConfig_IpV4Config_msg
#define meshtastic_Config_DisplayConfig_fields &meshtastic_Config_DisplayConfig_msg
#define meshtastic_Config_LoRaConfig_fields &meshtastic_Config_LoRaConfig_msg
#define meshtastic_Config_BluetoothConfig_fields &meshtastic_Config_BluetoothConfig_msg
#define meshtastic_Config_SecurityConfig_fields &meshtastic_Config_SecurityConfig_msg
#define meshtastic_Config_SessionkeyConfig_fields &meshtastic_Config_SessionkeyConfig_msg

/* Maximum encoded size of messages (where known) */
#define MESHTASTIC_MESHTASTIC_CONFIG_PB_H_MAX_SIZE meshtastic_Config_size
#define meshtastic_Config_BluetoothConfig_size   10
#define meshtastic_Config_DeviceConfig_size      100
#define meshtastic_Config_DisplayConfig_size     34
#define meshtastic_Config_LoRaConfig_size        85
#define meshtastic_Config_NetworkConfig_IpV4Config_size 20
#define meshtastic_Config_NetworkConfig_size     204
#define meshtastic_Config_PositionConfig_size    62
#define meshtastic_Config_PowerConfig_size       52
#define meshtastic_Config_SecurityConfig_size    178
#define meshtastic_Config_SessionkeyConfig_size  0
#define meshtastic_Config_size                   207

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif
