#include "Thread.h"
#include "ThreadController.h"

ThreadController::ThreadController(unsigned long _interval): Thread(){
	cached_size = 0;

	clear();
	setInterval(_interval);

	#ifdef USE_THREAD_NAMES
		// Overrides name
		ThreadName = "ThreadController ";
		ThreadName = ThreadName + ThreadID;
	#endif
}

/*
	ThreadController run() (cool stuf)
*/
void ThreadController::run(){
	// Run this thread before
	if(_onRun != NULL)
		_onRun();

	unsigned long time = millis();
	int checks = 0;
	for(int i = 0; i < MAX_THREADS && checks < cached_size; i++){
		// Object exists? Is enabled? Timeout exceeded?
		if(thread[i]){
			checks++;
			if(thread[i]->shouldRun(time)){
				thread[i]->run();
			}
		}
	}

	// ThreadController extends Thread, so we should flag as runned thread
	runned();
}

// Try to run our threads, return how long we can sleep before next needed
long ThreadController::runOrDelay(){
	// Run this thread before
	if(_onRun != NULL)
		_onRun();

	unsigned long time = millis();
	int checks = 0;
	long tillNext = __LONG_MAX__;
	nextThread = NULL;
	for(int i = 0; i < MAX_THREADS && checks < cached_size; i++){
		// Object exists? Is enabled? Timeout exceeded?
		Thread *t = thread[i];
		if(t){
			checks++;

			long threadNext = t->tillRun(time);
			if(threadNext <= 0){ // This thread is ready to run right now
				t->run();
				// threadNext = t->tillRun(time); // Check when the current thread's new deadline
		
				if(!t->canSleep) {
					tillNext = 0; // we ran something this tick, therefore tell caller it should skip the delay this time
					nextThread = t;
				}
			}
			else if(threadNext < tillNext && !t->canSleep) {
				tillNext = threadNext;
				nextThread = t;
			}
		}
	}

	// ThreadController extends Thread, so we should flag as runned thread
	runned();

	return tillNext;
}


/*
	List controller (boring part)
*/
bool ThreadController::add(Thread* _thread){
	// Check if the Thread already exists on the array
	for(int i = 0; i < MAX_THREADS; i++){
		if(thread[i] != NULL && thread[i]->ThreadID == _thread->ThreadID)
			return true;
	}

	// Find an empty slot
	for(int i = 0; i < MAX_THREADS; i++){
		if(!thread[i]){
			// Found a empty slot, now add Thread
			thread[i] = _thread;
			cached_size++;
			return true;
		}
	}

	// Array is full
	return false;
}

void ThreadController::remove(size_t id){
	// Find Threads with the id, and removes
	for(int i = 0; i < MAX_THREADS; i++){
		if(thread[i]->ThreadID == id){
			thread[i] = NULL;
			cached_size--;
			return;
		}
	}
}

void ThreadController::remove(Thread* _thread){
	remove(_thread->ThreadID);
}

void ThreadController::clear(){
	for(int i = 0; i < MAX_THREADS; i++){
		thread[i] = NULL;
	}
	cached_size = 0;
}

int ThreadController::size(bool cached){
	if(cached)
		return cached_size;

	int size = 0;
	for(int i = 0; i < MAX_THREADS; i++){
		if(thread[i])
			size++;
	}
	cached_size = size;

	return cached_size;
}

Thread* ThreadController::get(int index){
	int pos = -1;
	for(int i = 0; i < MAX_THREADS; i++){
		if(thread[i] != NULL){
			pos++;

			if(pos == index)
				return thread[i];
		}
	}

	return NULL;
}
