
# FreeRTOS: framework for [PlatformIO](https://platformio.org)

FreeRTOS is a real-time operating system kernel for embedded devices that has been ported to 40 microcontroller platforms.

* [Home](https://platformio.org/frameworks/freertos) (home page in PlatformIO Registry)
* [Documentation](https://docs.platformio.org/page/frameworks/freertos.html)

# Examples

- [CHIPS Alliance](https://github.com/platformio/platform-chipsalliance)
  * [native-asm](https://github.com/platformio/platform-chipsalliance/tree/master/examples/native-asm)
  * [native-bare_c](https://github.com/platformio/platform-chipsalliance/tree/master/examples/native-bare_c)
  * [psp-hello-world](https://github.com/platformio/platform-chipsalliance/tree/master/examples/psp-hello-world)
  * [rtosal-freertos](https://github.com/platformio/platform-chipsalliance/tree/master/examples/rtosal-freertos)

- [SiFive](https://github.com/platformio/platform-sifive)
  * [freedom-e-sdk_freertos-blinky](https://github.com/platformio/platform-sifive/tree/master/examples/freedom-e-sdk_freertos-blinky)
  * [freedom-e-sdk_freertos-blinky-system-view](https://github.com/platformio/platform-sifive/tree/master/examples/freedom-e-sdk_freertos-blinky-system-view)
  * [freedom-e-sdk_freertos-pmp-blinky](https://github.com/platformio/platform-sifive/tree/master/examples/freedom-e-sdk_freertos-pmp-blinky)
  * [freedom-e-sdk_hello](https://github.com/platformio/platform-sifive/tree/master/examples/freedom-e-sdk_hello)
  * [freedom-e-sdk_multicore-hello](https://github.com/platformio/platform-sifive/tree/master/examples/freedom-e-sdk_multicore-hello)
  * [freedom-e-sdk_sifive-welcome](https://github.com/platformio/platform-sifive/tree/master/examples/freedom-e-sdk_sifive-welcome)
  * [freedom-e-sdk_spi](https://github.com/platformio/platform-sifive/tree/master/examples/freedom-e-sdk_spi)
  * [freedom-e-sdk_test-coreip](https://github.com/platformio/platform-sifive/tree/master/examples/freedom-e-sdk_test-coreip)
  * [freedom-e-sdk_timer-interrupt](https://github.com/platformio/platform-sifive/tree/master/examples/freedom-e-sdk_timer-interrupt)
  * [freedom-e-sdk_user-mode](https://github.com/platformio/platform-sifive/tree/master/examples/freedom-e-sdk_user-mode)
  * [freedom-e-sdk_user-syscall](https://github.com/platformio/platform-sifive/tree/master/examples/freedom-e-sdk_user-syscall)
  * [native-blink_asm](https://github.com/platformio/platform-sifive/tree/master/examples/native-blink_asm)
  * [zephyr-blink](https://github.com/platformio/platform-sifive/tree/master/examples/zephyr-blink)
  * [zephyr-hello-world](https://github.com/platformio/platform-sifive/tree/master/examples/zephyr-hello-world)
  * [zephyr-synchronization](https://github.com/platformio/platform-sifive/tree/master/examples/zephyr-synchronization)

