/*******************************************************************************
 * Size: 16 px
 * Bpp: 4
 * Opts: --bpp 4 --size 16 --no-compress --font MontserratZ-Medium.ttf --range 32-127,160-255,256-383,880-1023,1024-1279,1280-1327,7936-131071 --format lvgl
 ******************************************************************************/

#ifdef __has_include
    #if __has_include("lvgl.h")
        #ifndef LV_LVGL_H_INCLUDE_SIMPLE
            #define LV_LVGL_H_INCLUDE_SIMPLE
        #endif
    #endif
#endif

#ifdef LV_LVGL_H_INCLUDE_SIMPLE
    #include "lvgl.h"
#else
    #include "lvgl.h"
#endif

#ifndef UI_FONT_MONTSERRAT_16
#define UI_FONT_MONTSERRAT_16 1
#endif

#if UI_FONT_MONTSERRAT_16

/*-----------------
 *    BITMAPS
 *----------------*/

/*Store the image of the glyphs*/
static LV_ATTRIBUTE_LARGE_CONST const uint8_t glyph_bitmap[] = {
    /* U+0020 " " */

    /* U+0021 "!" */
    0xbf, 0xb, 0xf0, 0xaf, 0xa, 0xe0, 0x9e, 0x8,
    0xd0, 0x8c, 0x7, 0xc0, 0x0, 0x0, 0x10, 0xbf,
    0x1a, 0xd0,

    /* U+0022 "\"" */
    0xf, 0x51, 0xf3, 0xf, 0x41, 0xf3, 0xf, 0x40,
    0xf2, 0xe, 0x30, 0xf2, 0x7, 0x10, 0x81,

    /* U+0023 "#" */
    0x0, 0x6, 0xc0, 0x3, 0xe0, 0x0, 0x0, 0x8a,
    0x0, 0x5c, 0x0, 0x0, 0xa, 0x80, 0x7, 0xa0,
    0x1, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x3, 0x3e,
    0x73, 0x3c, 0x83, 0x30, 0x0, 0xf2, 0x0, 0xc5,
    0x0, 0x0, 0x1f, 0x10, 0xe, 0x30, 0x0, 0x2,
    0xf0, 0x0, 0xf2, 0x0, 0x9f, 0xff, 0xff, 0xff,
    0xff, 0x41, 0x38, 0xc3, 0x36, 0xe3, 0x30, 0x0,
    0x89, 0x0, 0x5c, 0x0, 0x0, 0xa, 0x70, 0x7,
    0xa0, 0x0,

    /* U+0024 "$" */
    0x0, 0x0, 0x79, 0x0, 0x0, 0x0, 0x0, 0x79,
    0x0, 0x0, 0x0, 0x6c, 0xff, 0xda, 0x20, 0x7,
    0xfc, 0xbc, 0x9e, 0x90, 0xe, 0xb0, 0x79, 0x0,
    0x10, 0xf, 0x80, 0x79, 0x0, 0x0, 0xd, 0xe5,
    0x79, 0x0, 0x0, 0x3, 0xef, 0xfd, 0x50, 0x0,
    0x0, 0x6, 0xcf, 0xfe, 0x40, 0x0, 0x0, 0x79,
    0x4e, 0xf1, 0x0, 0x0, 0x79, 0x5, 0xf3, 0x7,
    0x0, 0x79, 0x7, 0xf2, 0x2f, 0xe9, 0xbc, 0xaf,
    0xa0, 0x2, 0xae, 0xff, 0xd7, 0x0, 0x0, 0x0,
    0x79, 0x0, 0x0, 0x0, 0x0, 0x79, 0x0, 0x0,

    /* U+0025 "%" */
    0x3, 0xdf, 0x80, 0x0, 0x5, 0xd0, 0x0, 0xe4,
    0xc, 0x50, 0x1, 0xe3, 0x0, 0x4c, 0x0, 0x5a,
    0x0, 0xa9, 0x0, 0x6, 0xa0, 0x4, 0xc0, 0x4e,
    0x0, 0x0, 0x4c, 0x0, 0x5a, 0xd, 0x50, 0x0,
    0x0, 0xe4, 0x1c, 0x58, 0xa0, 0x0, 0x0, 0x3,
    0xde, 0x83, 0xe1, 0x3d, 0xea, 0x0, 0x0, 0x0,
    0xd6, 0xe, 0x40, 0xa8, 0x0, 0x0, 0x7c, 0x3,
    0xc0, 0x3, 0xd0, 0x0, 0x2e, 0x20, 0x3c, 0x0,
    0x3d, 0x0, 0xb, 0x70, 0x0, 0xe3, 0x9, 0x90,
    0x6, 0xd0, 0x0, 0x4, 0xde, 0xa0,

    /* U+0026 "&" */
    0x0, 0x9, 0xef, 0xb1, 0x0, 0x0, 0x9, 0xe4,
    0x3d, 0xb0, 0x0, 0x0, 0xd9, 0x0, 0x7d, 0x0,
    0x0, 0xb, 0xc0, 0x1c, 0xa0, 0x0, 0x0, 0x3f,
    0xae, 0xd1, 0x0, 0x0, 0x1, 0xdf, 0xc0, 0x0,
    0x0, 0x3, 0xeb, 0x8f, 0x70, 0x18, 0x0, 0xeb,
    0x0, 0x7f, 0x65, 0xf0, 0x3f, 0x40, 0x0, 0x8f,
    0xea, 0x3, 0xf7, 0x0, 0x0, 0xcf, 0x70, 0xb,
    0xf9, 0x67, 0xcf, 0xbf, 0x40, 0x8, 0xdf, 0xea,
    0x20, 0xa5, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+0027 "'" */
    0xf5, 0xf5, 0xe4, 0xe4, 0x72,

    /* U+0028 "(" */
    0x0, 0xda, 0x5, 0xf2, 0xb, 0xd0, 0xf, 0x80,
    0x3f, 0x50, 0x5f, 0x20, 0x6f, 0x10, 0x7f, 0x0,
    0x6f, 0x10, 0x5f, 0x20, 0x3f, 0x50, 0xf, 0x80,
    0xb, 0xc0, 0x5, 0xf2, 0x0, 0xda,

    /* U+0029 ")" */
    0x3f, 0x30, 0xc, 0xb0, 0x6, 0xf1, 0x1, 0xf6,
    0x0, 0xe9, 0x0, 0xbc, 0x0, 0xad, 0x0, 0xae,
    0x0, 0xad, 0x0, 0xbc, 0x0, 0xe9, 0x1, 0xf6,
    0x6, 0xf1, 0xc, 0xb0, 0x3f, 0x30,

    /* U+002A "*" */
    0x0, 0x4a, 0x0, 0x6, 0x74, 0xa4, 0xa0, 0x2b,
    0xff, 0xe5, 0x0, 0x7f, 0xfb, 0x20, 0x7c, 0x7b,
    0x8d, 0x0, 0x4, 0xa0, 0x0, 0x0, 0x13, 0x0,
    0x0,

    /* U+002B "+" */
    0x0, 0x5, 0x10, 0x0, 0x0, 0xf, 0x50, 0x0,
    0x0, 0xf, 0x50, 0x0, 0x1, 0x1f, 0x51, 0x10,
    0xef, 0xff, 0xff, 0xf3, 0x34, 0x4f, 0x74, 0x40,
    0x0, 0xf, 0x50, 0x0, 0x0, 0xf, 0x50, 0x0,

    /* U+002C "," */
    0x9, 0x53, 0xfd, 0xb, 0xa0, 0xc5, 0xf, 0x0,

    /* U+002D "-" */
    0x1, 0x11, 0x10, 0x1f, 0xff, 0xf3, 0x4, 0x44,
    0x40,

    /* U+002E "." */
    0x3, 0x12, 0xfc, 0x1e, 0x90,

    /* U+002F "/" */
    0x0, 0x0, 0x5, 0xf1, 0x0, 0x0, 0xa, 0xb0,
    0x0, 0x0, 0xf, 0x60, 0x0, 0x0, 0x5f, 0x10,
    0x0, 0x0, 0xab, 0x0, 0x0, 0x0, 0xf6, 0x0,
    0x0, 0x5, 0xf1, 0x0, 0x0, 0xa, 0xb0, 0x0,
    0x0, 0xf, 0x60, 0x0, 0x0, 0x4f, 0x10, 0x0,
    0x0, 0xac, 0x0, 0x0, 0x0, 0xf6, 0x0, 0x0,
    0x4, 0xf1, 0x0, 0x0, 0xa, 0xc0, 0x0, 0x0,
    0xe, 0x60, 0x0, 0x0, 0x4f, 0x10, 0x0, 0x0,

    /* U+0030 "0" */
    0x0, 0x8, 0xef, 0xc5, 0x0, 0x0, 0xcf, 0xa8,
    0xcf, 0x70, 0x7, 0xf5, 0x0, 0xa, 0xf2, 0xd,
    0xc0, 0x0, 0x1, 0xf8, 0x1f, 0x80, 0x0, 0x0,
    0xdc, 0x3f, 0x60, 0x0, 0x0, 0xbd, 0x3f, 0x60,
    0x0, 0x0, 0xbd, 0x1f, 0x80, 0x0, 0x0, 0xdc,
    0xd, 0xc0, 0x0, 0x1, 0xf8, 0x7, 0xf5, 0x0,
    0xa, 0xf2, 0x0, 0xcf, 0xa8, 0xcf, 0x70, 0x0,
    0x8, 0xef, 0xc5, 0x0,

    /* U+0031 "1" */
    0xef, 0xff, 0x36, 0x7a, 0xf3, 0x0, 0x5f, 0x30,
    0x5, 0xf3, 0x0, 0x5f, 0x30, 0x5, 0xf3, 0x0,
    0x5f, 0x30, 0x5, 0xf3, 0x0, 0x5f, 0x30, 0x5,
    0xf3, 0x0, 0x5f, 0x30, 0x5, 0xf3,

    /* U+0032 "2" */
    0x4, 0xbe, 0xfd, 0x70, 0x7, 0xfd, 0x98, 0xcf,
    0x90, 0x28, 0x0, 0x0, 0xbf, 0x0, 0x0, 0x0,
    0x7, 0xf1, 0x0, 0x0, 0x0, 0xaf, 0x0, 0x0,
    0x0, 0x4f, 0x80, 0x0, 0x0, 0x3f, 0xc0, 0x0,
    0x0, 0x3e, 0xc1, 0x0, 0x0, 0x2e, 0xd1, 0x0,
    0x0, 0x2e, 0xd1, 0x0, 0x0, 0x2e, 0xf8, 0x77,
    0x77, 0x46, 0xff, 0xff, 0xff, 0xfa,

    /* U+0033 "3" */
    0x6f, 0xff, 0xff, 0xff, 0x2, 0x77, 0x77, 0x9f,
    0xb0, 0x0, 0x0, 0xc, 0xe1, 0x0, 0x0, 0x9,
    0xf3, 0x0, 0x0, 0x5, 0xf6, 0x0, 0x0, 0x0,
    0xdf, 0xea, 0x10, 0x0, 0x4, 0x59, 0xfd, 0x0,
    0x0, 0x0, 0x6, 0xf5, 0x0, 0x0, 0x0, 0x3f,
    0x64, 0x40, 0x0, 0x8, 0xf3, 0xbf, 0xc9, 0x8c,
    0xfb, 0x0, 0x6c, 0xff, 0xd8, 0x0,

    /* U+0034 "4" */
    0x0, 0x0, 0x1, 0xeb, 0x0, 0x0, 0x0, 0x0,
    0xbe, 0x10, 0x0, 0x0, 0x0, 0x6f, 0x50, 0x0,
    0x0, 0x0, 0x2f, 0xa0, 0x0, 0x0, 0x0, 0xc,
    0xe0, 0x0, 0x0, 0x0, 0x8, 0xf4, 0x1, 0xd5,
    0x0, 0x3, 0xf8, 0x0, 0x2f, 0x60, 0x0, 0xee,
    0x22, 0x23, 0xf7, 0x21, 0x6f, 0xff, 0xff, 0xff,
    0xff, 0x81, 0x55, 0x55, 0x56, 0xf9, 0x52, 0x0,
    0x0, 0x0, 0x2f, 0x60, 0x0, 0x0, 0x0, 0x2,
    0xf6, 0x0,

    /* U+0035 "5" */
    0x5, 0xff, 0xff, 0xff, 0x0, 0x7f, 0x77, 0x77,
    0x70, 0x8, 0xe0, 0x0, 0x0, 0x0, 0xad, 0x0,
    0x0, 0x0, 0xb, 0xc2, 0x10, 0x0, 0x0, 0xdf,
    0xff, 0xfb, 0x20, 0x4, 0x55, 0x68, 0xef, 0x10,
    0x0, 0x0, 0x3, 0xf7, 0x0, 0x0, 0x0, 0xf,
    0x92, 0x60, 0x0, 0x5, 0xf6, 0x8f, 0xd9, 0x8b,
    0xfd, 0x0, 0x5b, 0xef, 0xe9, 0x10,

    /* U+0036 "6" */
    0x0, 0x5, 0xce, 0xfc, 0x60, 0x0, 0x9f, 0xc8,
    0x7b, 0x70, 0x5, 0xf8, 0x0, 0x0, 0x0, 0xc,
    0xd0, 0x0, 0x0, 0x0, 0x1f, 0x80, 0x0, 0x0,
    0x0, 0x2f, 0x79, 0xef, 0xfa, 0x10, 0x3f, 0xed,
    0x64, 0x8f, 0xd0, 0x2f, 0xf1, 0x0, 0x5, 0xf4,
    0xe, 0xc0, 0x0, 0x2, 0xf6, 0x9, 0xf1, 0x0,
    0x7, 0xf3, 0x1, 0xde, 0x86, 0x9f, 0xb0, 0x0,
    0x19, 0xef, 0xd8, 0x0,

    /* U+0037 "7" */
    0x8f, 0xff, 0xff, 0xff, 0xe8, 0xf7, 0x77, 0x77,
    0xfc, 0x8f, 0x0, 0x0, 0x5f, 0x55, 0x90, 0x0,
    0xb, 0xe0, 0x0, 0x0, 0x2, 0xf8, 0x0, 0x0,
    0x0, 0x9f, 0x10, 0x0, 0x0, 0xf, 0xb0, 0x0,
    0x0, 0x6, 0xf4, 0x0, 0x0, 0x0, 0xdd, 0x0,
    0x0, 0x0, 0x4f, 0x70, 0x0, 0x0, 0xa, 0xf1,
    0x0, 0x0, 0x1, 0xf9, 0x0, 0x0,

    /* U+0038 "8" */
    0x0, 0x5c, 0xff, 0xd7, 0x0, 0x6, 0xfc, 0x76,
    0xaf, 0xa0, 0xc, 0xd0, 0x0, 0x9, 0xf1, 0xd,
    0xc0, 0x0, 0x7, 0xf2, 0x7, 0xf7, 0x11, 0x5e,
    0xc0, 0x0, 0xbf, 0xff, 0xfe, 0x10, 0x9, 0xf9,
    0x54, 0x7e, 0xd0, 0x2f, 0x80, 0x0, 0x4, 0xf6,
    0x4f, 0x50, 0x0, 0x0, 0xf8, 0x1f, 0xa0, 0x0,
    0x5, 0xf6, 0x9, 0xfb, 0x76, 0xaf, 0xd0, 0x0,
    0x6c, 0xff, 0xd8, 0x10,

    /* U+0039 "9" */
    0x0, 0x8e, 0xfd, 0x80, 0x0, 0xc, 0xf8, 0x68,
    0xfc, 0x0, 0x5f, 0x50, 0x0, 0x3f, 0x70, 0x8f,
    0x0, 0x0, 0xe, 0xc0, 0x7f, 0x30, 0x0, 0x1f,
    0xf0, 0x1f, 0xd4, 0x13, 0xcf, 0xf1, 0x4, 0xef,
    0xff, 0xa9, 0xf0, 0x0, 0x2, 0x31, 0xa, 0xf0,
    0x0, 0x0, 0x0, 0xe, 0xa0, 0x0, 0x0, 0x0,
    0x9f, 0x30, 0x9, 0xa7, 0x8d, 0xf7, 0x0, 0x7,
    0xdf, 0xeb, 0x40, 0x0,

    /* U+003A ":" */
    0x1e, 0x92, 0xfc, 0x3, 0x10, 0x0, 0x0, 0x0,
    0x0, 0x3, 0x12, 0xfc, 0x1e, 0x90,

    /* U+003B ";" */
    0x1e, 0x92, 0xfc, 0x3, 0x10, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1, 0xe9, 0x2f, 0xc0, 0xa8, 0xe,
    0x31, 0xa0,

    /* U+003C "<" */
    0x0, 0x0, 0x0, 0x42, 0x0, 0x1, 0x7d, 0xf3,
    0x3, 0x9f, 0xe8, 0x10, 0xbf, 0xb5, 0x0, 0x0,
    0xee, 0x71, 0x0, 0x0, 0x6, 0xdf, 0xa4, 0x0,
    0x0, 0x4, 0xaf, 0xd2, 0x0, 0x0, 0x1, 0x82,

    /* U+003D "=" */
    0xef, 0xff, 0xff, 0xf3, 0x45, 0x55, 0x55, 0x51,
    0x0, 0x0, 0x0, 0x0, 0x1, 0x11, 0x11, 0x10,
    0xef, 0xff, 0xff, 0xf3, 0x34, 0x44, 0x44, 0x40,

    /* U+003E ">" */
    0x50, 0x0, 0x0, 0x0, 0xef, 0x92, 0x0, 0x0,
    0x6, 0xcf, 0xb5, 0x0, 0x0, 0x3, 0x9f, 0xe2,
    0x0, 0x0, 0x5c, 0xf3, 0x2, 0x8e, 0xe9, 0x20,
    0xbf, 0xc6, 0x0, 0x0, 0x93, 0x0, 0x0, 0x0,

    /* U+003F "?" */
    0x4, 0xbe, 0xfd, 0x80, 0x7, 0xfc, 0x77, 0xcf,
    0xa0, 0x27, 0x0, 0x0, 0xcf, 0x0, 0x0, 0x0,
    0x9, 0xf0, 0x0, 0x0, 0x1, 0xea, 0x0, 0x0,
    0x1, 0xdd, 0x10, 0x0, 0x0, 0xce, 0x10, 0x0,
    0x0, 0x3f, 0x60, 0x0, 0x0, 0x1, 0x30, 0x0,
    0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x6, 0xf5,
    0x0, 0x0, 0x0, 0x5f, 0x40, 0x0,

    /* U+0040 "@" */
    0x0, 0x0, 0x18, 0xce, 0xfe, 0xb5, 0x0, 0x0,
    0x0, 0x6, 0xfb, 0x52, 0x23, 0x7d, 0xd2, 0x0,
    0x0, 0x7e, 0x40, 0x0, 0x0, 0x0, 0x8e, 0x20,
    0x3, 0xf3, 0x1, 0xae, 0xea, 0x3f, 0x48, 0xc0,
    0xa, 0x90, 0x1e, 0xd6, 0x5b, 0xef, 0x40, 0xe3,
    0xf, 0x30, 0x8e, 0x10, 0x0, 0xaf, 0x40, 0x98,
    0x2f, 0x0, 0xd9, 0x0, 0x0, 0x3f, 0x40, 0x6b,
    0x3f, 0x0, 0xe7, 0x0, 0x0, 0x1f, 0x40, 0x5c,
    0x2f, 0x0, 0xd9, 0x0, 0x0, 0x3f, 0x40, 0x6b,
    0xf, 0x30, 0x8e, 0x10, 0x0, 0xaf, 0x40, 0x98,
    0xa, 0x90, 0x1e, 0xd6, 0x4a, 0xde, 0xa5, 0xf2,
    0x2, 0xf3, 0x1, 0xaf, 0xfa, 0x15, 0xee, 0x50,
    0x0, 0x7e, 0x40, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x6, 0xfb, 0x53, 0x23, 0x75, 0x0, 0x0,
    0x0, 0x0, 0x18, 0xce, 0xfd, 0xa3, 0x0, 0x0,

    /* U+0041 "A" */
    0x0, 0x0, 0x2, 0xfd, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x9f, 0xf4, 0x0, 0x0, 0x0, 0x0, 0xf,
    0x9e, 0xb0, 0x0, 0x0, 0x0, 0x6, 0xf2, 0x7f,
    0x20, 0x0, 0x0, 0x0, 0xdc, 0x1, 0xf8, 0x0,
    0x0, 0x0, 0x4f, 0x60, 0xb, 0xe0, 0x0, 0x0,
    0xb, 0xf0, 0x0, 0x4f, 0x60, 0x0, 0x1, 0xfa,
    0x11, 0x11, 0xed, 0x0, 0x0, 0x8f, 0xff, 0xff,
    0xff, 0xf3, 0x0, 0xe, 0xc4, 0x44, 0x44, 0x4f,
    0xa0, 0x6, 0xf4, 0x0, 0x0, 0x0, 0xaf, 0x10,
    0xcd, 0x0, 0x0, 0x0, 0x2, 0xf8,

    /* U+0042 "B" */
    0x5f, 0xff, 0xff, 0xeb, 0x40, 0x5, 0xf8, 0x55,
    0x57, 0xdf, 0x40, 0x5f, 0x40, 0x0, 0x1, 0xfa,
    0x5, 0xf4, 0x0, 0x0, 0xf, 0xa0, 0x5f, 0x51,
    0x11, 0x3a, 0xf4, 0x5, 0xff, 0xff, 0xff, 0xfa,
    0x0, 0x5f, 0x74, 0x44, 0x59, 0xfa, 0x5, 0xf4,
    0x0, 0x0, 0x8, 0xf2, 0x5f, 0x40, 0x0, 0x0,
    0x5f, 0x45, 0xf4, 0x0, 0x0, 0x9, 0xf2, 0x5f,
    0x86, 0x66, 0x6a, 0xfb, 0x5, 0xff, 0xff, 0xff,
    0xd8, 0x0,

    /* U+0043 "C" */
    0x0, 0x2, 0x9d, 0xfe, 0xb4, 0x0, 0x5, 0xff,
    0xb8, 0x9d, 0xf9, 0x3, 0xfd, 0x20, 0x0, 0x8,
    0x50, 0xbf, 0x20, 0x0, 0x0, 0x0, 0xf, 0x90,
    0x0, 0x0, 0x0, 0x3, 0xf6, 0x0, 0x0, 0x0,
    0x0, 0x3f, 0x60, 0x0, 0x0, 0x0, 0x0, 0xf9,
    0x0, 0x0, 0x0, 0x0, 0xb, 0xf2, 0x0, 0x0,
    0x0, 0x0, 0x3f, 0xd2, 0x0, 0x0, 0x85, 0x0,
    0x5f, 0xfb, 0x89, 0xdf, 0x80, 0x0, 0x29, 0xdf,
    0xeb, 0x40,

    /* U+0044 "D" */
    0x5f, 0xff, 0xff, 0xea, 0x30, 0x0, 0x5f, 0x97,
    0x77, 0x9e, 0xf8, 0x0, 0x5f, 0x40, 0x0, 0x0,
    0xaf, 0x60, 0x5f, 0x40, 0x0, 0x0, 0xc, 0xe0,
    0x5f, 0x40, 0x0, 0x0, 0x6, 0xf4, 0x5f, 0x40,
    0x0, 0x0, 0x3, 0xf6, 0x5f, 0x40, 0x0, 0x0,
    0x3, 0xf6, 0x5f, 0x40, 0x0, 0x0, 0x6, 0xf4,
    0x5f, 0x40, 0x0, 0x0, 0xd, 0xe0, 0x5f, 0x40,
    0x0, 0x0, 0xaf, 0x60, 0x5f, 0x97, 0x77, 0x9e,
    0xf8, 0x0, 0x5f, 0xff, 0xff, 0xea, 0x30, 0x0,

    /* U+0045 "E" */
    0x5f, 0xff, 0xff, 0xff, 0x95, 0xf9, 0x77, 0x77,
    0x74, 0x5f, 0x40, 0x0, 0x0, 0x5, 0xf4, 0x0,
    0x0, 0x0, 0x5f, 0x51, 0x11, 0x11, 0x5, 0xff,
    0xff, 0xff, 0xe0, 0x5f, 0x74, 0x44, 0x44, 0x5,
    0xf4, 0x0, 0x0, 0x0, 0x5f, 0x40, 0x0, 0x0,
    0x5, 0xf4, 0x0, 0x0, 0x0, 0x5f, 0x97, 0x77,
    0x77, 0x65, 0xff, 0xff, 0xff, 0xfd,

    /* U+0046 "F" */
    0x5f, 0xff, 0xff, 0xff, 0x95, 0xf9, 0x77, 0x77,
    0x74, 0x5f, 0x40, 0x0, 0x0, 0x5, 0xf4, 0x0,
    0x0, 0x0, 0x5f, 0x40, 0x0, 0x0, 0x5, 0xf5,
    0x22, 0x22, 0x10, 0x5f, 0xff, 0xff, 0xfe, 0x5,
    0xf8, 0x55, 0x55, 0x40, 0x5f, 0x40, 0x0, 0x0,
    0x5, 0xf4, 0x0, 0x0, 0x0, 0x5f, 0x40, 0x0,
    0x0, 0x5, 0xf4, 0x0, 0x0, 0x0,

    /* U+0047 "G" */
    0x0, 0x1, 0x9d, 0xfe, 0xb5, 0x0, 0x0, 0x4f,
    0xfb, 0x89, 0xdf, 0xb0, 0x3, 0xfd, 0x20, 0x0,
    0x6, 0x60, 0xb, 0xf1, 0x0, 0x0, 0x0, 0x0,
    0xf, 0x90, 0x0, 0x0, 0x0, 0x0, 0x3f, 0x60,
    0x0, 0x0, 0x0, 0x0, 0x3f, 0x60, 0x0, 0x0,
    0x9, 0xf0, 0xf, 0xa0, 0x0, 0x0, 0x9, 0xf0,
    0xb, 0xf2, 0x0, 0x0, 0x9, 0xf0, 0x3, 0xfd,
    0x20, 0x0, 0x9, 0xf0, 0x0, 0x5f, 0xfb, 0x89,
    0xdf, 0xc0, 0x0, 0x2, 0x9d, 0xff, 0xc6, 0x0,

    /* U+0048 "H" */
    0x5f, 0x40, 0x0, 0x0, 0x4f, 0x55, 0xf4, 0x0,
    0x0, 0x4, 0xf5, 0x5f, 0x40, 0x0, 0x0, 0x4f,
    0x55, 0xf4, 0x0, 0x0, 0x4, 0xf5, 0x5f, 0x52,
    0x22, 0x22, 0x5f, 0x55, 0xff, 0xff, 0xff, 0xff,
    0xf5, 0x5f, 0x85, 0x55, 0x55, 0x8f, 0x55, 0xf4,
    0x0, 0x0, 0x4, 0xf5, 0x5f, 0x40, 0x0, 0x0,
    0x4f, 0x55, 0xf4, 0x0, 0x0, 0x4, 0xf5, 0x5f,
    0x40, 0x0, 0x0, 0x4f, 0x55, 0xf4, 0x0, 0x0,
    0x4, 0xf5,

    /* U+0049 "I" */
    0x5f, 0x45, 0xf4, 0x5f, 0x45, 0xf4, 0x5f, 0x45,
    0xf4, 0x5f, 0x45, 0xf4, 0x5f, 0x45, 0xf4, 0x5f,
    0x45, 0xf4,

    /* U+004A "J" */
    0x0, 0xff, 0xff, 0xfa, 0x0, 0x77, 0x77, 0xfa,
    0x0, 0x0, 0x0, 0xfa, 0x0, 0x0, 0x0, 0xfa,
    0x0, 0x0, 0x0, 0xfa, 0x0, 0x0, 0x0, 0xfa,
    0x0, 0x0, 0x0, 0xfa, 0x0, 0x0, 0x0, 0xfa,
    0x0, 0x0, 0x0, 0xf9, 0x7, 0x20, 0x3, 0xf6,
    0xd, 0xf9, 0x8e, 0xf1, 0x1, 0xae, 0xfb, 0x30,

    /* U+004B "K" */
    0x5f, 0x40, 0x0, 0x2, 0xeb, 0x5, 0xf4, 0x0,
    0x1, 0xec, 0x0, 0x5f, 0x40, 0x1, 0xde, 0x10,
    0x5, 0xf4, 0x0, 0xce, 0x20, 0x0, 0x5f, 0x40,
    0xbf, 0x30, 0x0, 0x5, 0xf4, 0x9f, 0x90, 0x0,
    0x0, 0x5f, 0xcf, 0xef, 0x40, 0x0, 0x5, 0xff,
    0x81, 0xee, 0x10, 0x0, 0x5f, 0xa0, 0x3, 0xfc,
    0x0, 0x5, 0xf4, 0x0, 0x6, 0xf8, 0x0, 0x5f,
    0x40, 0x0, 0x9, 0xf5, 0x5, 0xf4, 0x0, 0x0,
    0xc, 0xf2,

    /* U+004C "L" */
    0x5f, 0x40, 0x0, 0x0, 0x5, 0xf4, 0x0, 0x0,
    0x0, 0x5f, 0x40, 0x0, 0x0, 0x5, 0xf4, 0x0,
    0x0, 0x0, 0x5f, 0x40, 0x0, 0x0, 0x5, 0xf4,
    0x0, 0x0, 0x0, 0x5f, 0x40, 0x0, 0x0, 0x5,
    0xf4, 0x0, 0x0, 0x0, 0x5f, 0x40, 0x0, 0x0,
    0x5, 0xf4, 0x0, 0x0, 0x0, 0x5f, 0x97, 0x77,
    0x77, 0x25, 0xff, 0xff, 0xff, 0xf5,

    /* U+004D "M" */
    0x5f, 0x40, 0x0, 0x0, 0x0, 0x1e, 0x95, 0xfc,
    0x0, 0x0, 0x0, 0x8, 0xf9, 0x5f, 0xf5, 0x0,
    0x0, 0x2, 0xff, 0x95, 0xfd, 0xe0, 0x0, 0x0,
    0xad, 0xf9, 0x5f, 0x5f, 0x70, 0x0, 0x3f, 0x5f,
    0x95, 0xf3, 0x8f, 0x10, 0xb, 0xc0, 0xf9, 0x5f,
    0x31, 0xe9, 0x4, 0xf3, 0xf, 0x95, 0xf3, 0x7,
    0xf2, 0xda, 0x0, 0xf9, 0x5f, 0x30, 0xd, 0xef,
    0x20, 0xf, 0x95, 0xf3, 0x0, 0x5f, 0x90, 0x0,
    0xf9, 0x5f, 0x30, 0x0, 0x71, 0x0, 0xf, 0x95,
    0xf3, 0x0, 0x0, 0x0, 0x0, 0xf9,

    /* U+004E "N" */
    0x5f, 0x50, 0x0, 0x0, 0x4f, 0x55, 0xff, 0x20,
    0x0, 0x4, 0xf5, 0x5f, 0xfd, 0x0, 0x0, 0x4f,
    0x55, 0xfa, 0xf9, 0x0, 0x4, 0xf5, 0x5f, 0x4a,
    0xf5, 0x0, 0x4f, 0x55, 0xf4, 0xd, 0xf2, 0x4,
    0xf5, 0x5f, 0x40, 0x2f, 0xd0, 0x4f, 0x55, 0xf4,
    0x0, 0x6f, 0x94, 0xf5, 0x5f, 0x40, 0x0, 0xaf,
    0xaf, 0x55, 0xf4, 0x0, 0x0, 0xdf, 0xf5, 0x5f,
    0x40, 0x0, 0x2, 0xff, 0x55, 0xf4, 0x0, 0x0,
    0x6, 0xf5,

    /* U+004F "O" */
    0x0, 0x1, 0x9d, 0xfe, 0xb5, 0x0, 0x0, 0x4,
    0xff, 0xb8, 0x9d, 0xfa, 0x0, 0x3, 0xfd, 0x20,
    0x0, 0x8, 0xf9, 0x0, 0xbf, 0x20, 0x0, 0x0,
    0xa, 0xf2, 0xf, 0x90, 0x0, 0x0, 0x0, 0x2f,
    0x73, 0xf6, 0x0, 0x0, 0x0, 0x0, 0xfa, 0x3f,
    0x60, 0x0, 0x0, 0x0, 0xf, 0xa0, 0xf9, 0x0,
    0x0, 0x0, 0x2, 0xf7, 0xb, 0xf2, 0x0, 0x0,
    0x0, 0xaf, 0x20, 0x2f, 0xd2, 0x0, 0x0, 0x8f,
    0x90, 0x0, 0x4f, 0xfa, 0x89, 0xdf, 0xb0, 0x0,
    0x0, 0x19, 0xdf, 0xeb, 0x50, 0x0,

    /* U+0050 "P" */
    0x5f, 0xff, 0xff, 0xd7, 0x0, 0x5f, 0x97, 0x78,
    0xbf, 0xc0, 0x5f, 0x40, 0x0, 0x7, 0xf6, 0x5f,
    0x40, 0x0, 0x0, 0xfa, 0x5f, 0x40, 0x0, 0x0,
    0xea, 0x5f, 0x40, 0x0, 0x3, 0xf8, 0x5f, 0x62,
    0x23, 0x6e, 0xe1, 0x5f, 0xff, 0xff, 0xfc, 0x30,
    0x5f, 0x85, 0x54, 0x20, 0x0, 0x5f, 0x40, 0x0,
    0x0, 0x0, 0x5f, 0x40, 0x0, 0x0, 0x0, 0x5f,
    0x40, 0x0, 0x0, 0x0,

    /* U+0051 "Q" */
    0x0, 0x1, 0x9d, 0xfe, 0xb5, 0x0, 0x0, 0x0,
    0x4f, 0xfb, 0x89, 0xdf, 0xa0, 0x0, 0x2, 0xfd,
    0x20, 0x0, 0x8, 0xf9, 0x0, 0xb, 0xf2, 0x0,
    0x0, 0x0, 0xaf, 0x20, 0xf, 0xa0, 0x0, 0x0,
    0x0, 0x2f, 0x70, 0x3f, 0x60, 0x0, 0x0, 0x0,
    0xf, 0xa0, 0x3f, 0x60, 0x0, 0x0, 0x0, 0xf,
    0xa0, 0x1f, 0x90, 0x0, 0x0, 0x0, 0x2f, 0x70,
    0xb, 0xf2, 0x0, 0x0, 0x0, 0x9f, 0x20, 0x3,
    0xfc, 0x10, 0x0, 0x7, 0xf9, 0x0, 0x0, 0x5f,
    0xfa, 0x78, 0xdf, 0xb0, 0x0, 0x0, 0x2, 0xae,
    0xff, 0xd6, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3f,
    0xd4, 0x15, 0xb0, 0x0, 0x0, 0x0, 0x2, 0xcf,
    0xff, 0x80, 0x0, 0x0, 0x0, 0x0, 0x2, 0x31,
    0x0,

    /* U+0052 "R" */
    0x5f, 0xff, 0xff, 0xd7, 0x0, 0x5f, 0x97, 0x78,
    0xbf, 0xc0, 0x5f, 0x40, 0x0, 0x7, 0xf6, 0x5f,
    0x40, 0x0, 0x0, 0xfa, 0x5f, 0x40, 0x0, 0x0,
    0xea, 0x5f, 0x40, 0x0, 0x3, 0xf8, 0x5f, 0x52,
    0x23, 0x6e, 0xe1, 0x5f, 0xff, 0xff, 0xfd, 0x30,
    0x5f, 0x85, 0x55, 0xf9, 0x0, 0x5f, 0x40, 0x0,
    0x7f, 0x40, 0x5f, 0x40, 0x0, 0xc, 0xe0, 0x5f,
    0x40, 0x0, 0x2, 0xf9,

    /* U+0053 "S" */
    0x0, 0x5c, 0xef, 0xd9, 0x20, 0x7, 0xfc, 0x77,
    0xaf, 0x90, 0xe, 0xb0, 0x0, 0x0, 0x10, 0xf,
    0x80, 0x0, 0x0, 0x0, 0xd, 0xe5, 0x0, 0x0,
    0x0, 0x2, 0xef, 0xea, 0x50, 0x0, 0x0, 0x5,
    0xae, 0xfe, 0x40, 0x0, 0x0, 0x0, 0x4e, 0xf1,
    0x0, 0x0, 0x0, 0x5, 0xf3, 0x8, 0x0, 0x0,
    0x8, 0xf2, 0x2f, 0xfa, 0x77, 0xbf, 0xa0, 0x2,
    0x9d, 0xff, 0xc6, 0x0,

    /* U+0054 "T" */
    0xff, 0xff, 0xff, 0xff, 0xf5, 0x67, 0x78, 0xfb,
    0x77, 0x72, 0x0, 0x1, 0xf7, 0x0, 0x0, 0x0,
    0x1, 0xf7, 0x0, 0x0, 0x0, 0x1, 0xf7, 0x0,
    0x0, 0x0, 0x1, 0xf7, 0x0, 0x0, 0x0, 0x1,
    0xf7, 0x0, 0x0, 0x0, 0x1, 0xf7, 0x0, 0x0,
    0x0, 0x1, 0xf7, 0x0, 0x0, 0x0, 0x1, 0xf7,
    0x0, 0x0, 0x0, 0x1, 0xf7, 0x0, 0x0, 0x0,
    0x1, 0xf7, 0x0, 0x0,

    /* U+0055 "U" */
    0x6f, 0x30, 0x0, 0x0, 0x8f, 0x16, 0xf3, 0x0,
    0x0, 0x8, 0xf1, 0x6f, 0x30, 0x0, 0x0, 0x8f,
    0x16, 0xf3, 0x0, 0x0, 0x8, 0xf1, 0x6f, 0x30,
    0x0, 0x0, 0x8f, 0x16, 0xf3, 0x0, 0x0, 0x8,
    0xf1, 0x6f, 0x30, 0x0, 0x0, 0x8f, 0x15, 0xf3,
    0x0, 0x0, 0x8, 0xf0, 0x3f, 0x70, 0x0, 0x0,
    0xcd, 0x0, 0xee, 0x20, 0x0, 0x5f, 0x80, 0x4,
    0xff, 0xa8, 0xbf, 0xd1, 0x0, 0x3, 0xbe, 0xfd,
    0x81, 0x0,

    /* U+0056 "V" */
    0xc, 0xe0, 0x0, 0x0, 0x0, 0x6f, 0x30, 0x6f,
    0x50, 0x0, 0x0, 0xc, 0xc0, 0x0, 0xfb, 0x0,
    0x0, 0x3, 0xf6, 0x0, 0x9, 0xf2, 0x0, 0x0,
    0xae, 0x0, 0x0, 0x2f, 0x80, 0x0, 0x1f, 0x90,
    0x0, 0x0, 0xce, 0x0, 0x7, 0xf2, 0x0, 0x0,
    0x5, 0xf5, 0x0, 0xdb, 0x0, 0x0, 0x0, 0xe,
    0xc0, 0x4f, 0x50, 0x0, 0x0, 0x0, 0x8f, 0x3a,
    0xe0, 0x0, 0x0, 0x0, 0x2, 0xfb, 0xf8, 0x0,
    0x0, 0x0, 0x0, 0xb, 0xff, 0x10, 0x0, 0x0,
    0x0, 0x0, 0x4f, 0xb0, 0x0, 0x0,

    /* U+0057 "W" */
    0x5f, 0x40, 0x0, 0x0, 0xdf, 0x0, 0x0, 0x2,
    0xf5, 0xf, 0x90, 0x0, 0x2, 0xff, 0x40, 0x0,
    0x7, 0xf0, 0xb, 0xe0, 0x0, 0x7, 0xfe, 0x90,
    0x0, 0xc, 0xb0, 0x6, 0xf3, 0x0, 0xc, 0xba,
    0xe0, 0x0, 0x1f, 0x60, 0x1, 0xf8, 0x0, 0x1f,
    0x55, 0xf3, 0x0, 0x6f, 0x10, 0x0, 0xcd, 0x0,
    0x6f, 0x10, 0xf8, 0x0, 0xcc, 0x0, 0x0, 0x7f,
    0x20, 0xbb, 0x0, 0xad, 0x1, 0xf7, 0x0, 0x0,
    0x2f, 0x71, 0xf6, 0x0, 0x5f, 0x26, 0xf2, 0x0,
    0x0, 0xd, 0xc6, 0xf1, 0x0, 0xf, 0x7b, 0xd0,
    0x0, 0x0, 0x8, 0xfd, 0xc0, 0x0, 0xb, 0xdf,
    0x80, 0x0, 0x0, 0x3, 0xff, 0x70, 0x0, 0x6,
    0xff, 0x30, 0x0, 0x0, 0x0, 0xef, 0x20, 0x0,
    0x1, 0xfe, 0x0, 0x0,

    /* U+0058 "X" */
    0x3f, 0x90, 0x0, 0x0, 0xcd, 0x0, 0x8f, 0x40,
    0x0, 0x7f, 0x40, 0x0, 0xde, 0x10, 0x2f, 0x80,
    0x0, 0x2, 0xfa, 0xd, 0xd0, 0x0, 0x0, 0x7,
    0xfc, 0xf3, 0x0, 0x0, 0x0, 0xc, 0xf8, 0x0,
    0x0, 0x0, 0x1, 0xef, 0xc0, 0x0, 0x0, 0x0,
    0xbf, 0x7f, 0x70, 0x0, 0x0, 0x6f, 0x60, 0xaf,
    0x20, 0x0, 0x2f, 0xb0, 0x1, 0xed, 0x0, 0xc,
    0xf1, 0x0, 0x4, 0xf8, 0x7, 0xf6, 0x0, 0x0,
    0x9, 0xf3,

    /* U+0059 "Y" */
    0xc, 0xe0, 0x0, 0x0, 0x7, 0xf2, 0x3, 0xf7,
    0x0, 0x0, 0x1f, 0x90, 0x0, 0xaf, 0x10, 0x0,
    0x9e, 0x10, 0x0, 0x1f, 0xa0, 0x2, 0xf6, 0x0,
    0x0, 0x8, 0xf3, 0xb, 0xd0, 0x0, 0x0, 0x0,
    0xec, 0x4f, 0x40, 0x0, 0x0, 0x0, 0x5f, 0xfb,
    0x0, 0x0, 0x0, 0x0, 0xc, 0xf2, 0x0, 0x0,
    0x0, 0x0, 0x9, 0xf0, 0x0, 0x0, 0x0, 0x0,
    0x9, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x9, 0xf0,
    0x0, 0x0, 0x0, 0x0, 0x9, 0xf0, 0x0, 0x0,

    /* U+005A "Z" */
    0x3f, 0xff, 0xff, 0xff, 0xfd, 0x1, 0x77, 0x77,
    0x77, 0xbf, 0x90, 0x0, 0x0, 0x0, 0x1e, 0xc0,
    0x0, 0x0, 0x0, 0xc, 0xf2, 0x0, 0x0, 0x0,
    0x8, 0xf5, 0x0, 0x0, 0x0, 0x4, 0xf9, 0x0,
    0x0, 0x0, 0x1, 0xec, 0x0, 0x0, 0x0, 0x0,
    0xcf, 0x20, 0x0, 0x0, 0x0, 0x8f, 0x50, 0x0,
    0x0, 0x0, 0x4f, 0x90, 0x0, 0x0, 0x0, 0x1e,
    0xf7, 0x77, 0x77, 0x77, 0x5, 0xff, 0xff, 0xff,
    0xff, 0xf0,

    /* U+005B "[" */
    0x5f, 0xff, 0x5, 0xf7, 0x50, 0x5f, 0x30, 0x5,
    0xf3, 0x0, 0x5f, 0x30, 0x5, 0xf3, 0x0, 0x5f,
    0x30, 0x5, 0xf3, 0x0, 0x5f, 0x30, 0x5, 0xf3,
    0x0, 0x5f, 0x30, 0x5, 0xf3, 0x0, 0x5f, 0x30,
    0x5, 0xf7, 0x50, 0x5f, 0xff, 0x0,

    /* U+005C "\\" */
    0x7e, 0x0, 0x0, 0x0, 0x1f, 0x40, 0x0, 0x0,
    0xc, 0x90, 0x0, 0x0, 0x7, 0xe0, 0x0, 0x0,
    0x2, 0xf4, 0x0, 0x0, 0x0, 0xc9, 0x0, 0x0,
    0x0, 0x7e, 0x0, 0x0, 0x0, 0x2f, 0x40, 0x0,
    0x0, 0xc, 0x90, 0x0, 0x0, 0x7, 0xe0, 0x0,
    0x0, 0x2, 0xf3, 0x0, 0x0, 0x0, 0xd9, 0x0,
    0x0, 0x0, 0x7e, 0x0, 0x0, 0x0, 0x2f, 0x30,
    0x0, 0x0, 0xd, 0x90, 0x0, 0x0, 0x7, 0xe0,

    /* U+005D "]" */
    0xbf, 0xfa, 0x35, 0xea, 0x0, 0xea, 0x0, 0xea,
    0x0, 0xea, 0x0, 0xea, 0x0, 0xea, 0x0, 0xea,
    0x0, 0xea, 0x0, 0xea, 0x0, 0xea, 0x0, 0xea,
    0x0, 0xea, 0x35, 0xea, 0xbf, 0xfa,

    /* U+005E "^" */
    0x0, 0x2f, 0x80, 0x0, 0x0, 0x9d, 0xe0, 0x0,
    0x0, 0xf3, 0xd5, 0x0, 0x6, 0xd0, 0x7b, 0x0,
    0xc, 0x60, 0x1f, 0x20, 0x3f, 0x10, 0xb, 0x80,
    0x9a, 0x0, 0x4, 0xe0,

    /* U+005F "_" */
    0xff, 0xff, 0xff, 0xff, 0x11, 0x11, 0x11, 0x11,

    /* U+0060 "`" */
    0x7, 0xf5, 0x0, 0x3, 0xe7,

    /* U+0061 "a" */
    0x0, 0x2a, 0xef, 0xb2, 0xf9, 0x3, 0xfe, 0x87,
    0xbe, 0xf9, 0xc, 0xe1, 0x0, 0x9, 0xf9, 0x1f,
    0x80, 0x0, 0x1, 0xf9, 0x2f, 0x60, 0x0, 0x0,
    0xf9, 0x1f, 0x80, 0x0, 0x1, 0xf9, 0xc, 0xe1,
    0x0, 0x9, 0xf9, 0x3, 0xfe, 0x87, 0xbe, 0xf9,
    0x0, 0x2a, 0xef, 0xb2, 0xe9,

    /* U+0062 "b" */
    0x8f, 0x0, 0x0, 0x0, 0x0, 0x8f, 0x0, 0x0,
    0x0, 0x0, 0x8f, 0x0, 0x0, 0x0, 0x0, 0x8f,
    0x2b, 0xfe, 0xb3, 0x0, 0x8f, 0xec, 0x78, 0xef,
    0x30, 0x8f, 0xa0, 0x0, 0x1e, 0xc0, 0x8f, 0x10,
    0x0, 0x7, 0xf1, 0x8f, 0x0, 0x0, 0x5, 0xf3,
    0x8f, 0x20, 0x0, 0x7, 0xf1, 0x8f, 0xa0, 0x0,
    0x1e, 0xc0, 0x8f, 0xec, 0x78, 0xef, 0x30, 0x8e,
    0x2b, 0xfe, 0xb3, 0x0,

    /* U+0063 "c" */
    0x0, 0x3a, 0xef, 0xc4, 0x0, 0x4f, 0xd8, 0x7c,
    0xf4, 0xd, 0xd0, 0x0, 0x7, 0x13, 0xf5, 0x0,
    0x0, 0x0, 0x4f, 0x30, 0x0, 0x0, 0x3, 0xf6,
    0x0, 0x0, 0x0, 0xd, 0xd0, 0x0, 0x7, 0x10,
    0x4f, 0xd8, 0x7c, 0xf4, 0x0, 0x3a, 0xef, 0xc4,
    0x0,

    /* U+0064 "d" */
    0x0, 0x0, 0x0, 0x1, 0xf7, 0x0, 0x0, 0x0,
    0x1, 0xf7, 0x0, 0x0, 0x0, 0x1, 0xf7, 0x0,
    0x3b, 0xfe, 0xa2, 0xf7, 0x4, 0xfd, 0x87, 0xce,
    0xf7, 0xe, 0xd0, 0x0, 0xb, 0xf7, 0x3f, 0x50,
    0x0, 0x3, 0xf7, 0x4f, 0x30, 0x0, 0x1, 0xf7,
    0x3f, 0x60, 0x0, 0x3, 0xf7, 0xe, 0xd0, 0x0,
    0xb, 0xf7, 0x4, 0xfd, 0x87, 0xcd, 0xf7, 0x0,
    0x3b, 0xfe, 0xa1, 0xf7,

    /* U+0065 "e" */
    0x0, 0x3b, 0xfe, 0xa2, 0x0, 0x4, 0xfc, 0x67,
    0xde, 0x10, 0xe, 0xc0, 0x0, 0xe, 0xa0, 0x3f,
    0x50, 0x0, 0x8, 0xf0, 0x4f, 0xff, 0xff, 0xff,
    0xf1, 0x3f, 0x72, 0x22, 0x22, 0x20, 0xe, 0xc0,
    0x0, 0x2, 0x0, 0x4, 0xfd, 0x87, 0xaf, 0x50,
    0x0, 0x3a, 0xef, 0xd6, 0x0,

    /* U+0066 "f" */
    0x0, 0x5d, 0xfc, 0x0, 0x2f, 0xb5, 0x70, 0x4,
    0xf3, 0x0, 0xc, 0xff, 0xff, 0xa0, 0x48, 0xf7,
    0x53, 0x0, 0x5f, 0x30, 0x0, 0x5, 0xf3, 0x0,
    0x0, 0x5f, 0x30, 0x0, 0x5, 0xf3, 0x0, 0x0,
    0x5f, 0x30, 0x0, 0x5, 0xf3, 0x0, 0x0, 0x5f,
    0x30, 0x0,

    /* U+0067 "g" */
    0x0, 0x3b, 0xff, 0xb2, 0xe9, 0x4, 0xfe, 0x87,
    0xcf, 0xf9, 0xe, 0xd0, 0x0, 0x9, 0xf9, 0x3f,
    0x60, 0x0, 0x1, 0xf9, 0x4f, 0x30, 0x0, 0x0,
    0xf9, 0x3f, 0x60, 0x0, 0x1, 0xf9, 0xe, 0xd0,
    0x0, 0x9, 0xf9, 0x4, 0xfd, 0x87, 0xbe, 0xf8,
    0x0, 0x3b, 0xff, 0xb2, 0xf7, 0x0, 0x0, 0x0,
    0x5, 0xf4, 0x9, 0xe9, 0x77, 0x9f, 0xc0, 0x0,
    0x7c, 0xff, 0xd8, 0x0,

    /* U+0068 "h" */
    0x8f, 0x0, 0x0, 0x0, 0x8, 0xf0, 0x0, 0x0,
    0x0, 0x8f, 0x0, 0x0, 0x0, 0x8, 0xf2, 0xbf,
    0xfa, 0x20, 0x8f, 0xeb, 0x79, 0xfd, 0x8, 0xf8,
    0x0, 0x6, 0xf5, 0x8f, 0x10, 0x0, 0x1f, 0x78,
    0xf0, 0x0, 0x0, 0xf8, 0x8f, 0x0, 0x0, 0xf,
    0x88, 0xf0, 0x0, 0x0, 0xf8, 0x8f, 0x0, 0x0,
    0xf, 0x88, 0xf0, 0x0, 0x0, 0xf8,

    /* U+0069 "i" */
    0x9e, 0x1a, 0xf1, 0x0, 0x9, 0xf0, 0x9f, 0x9,
    0xf0, 0x9f, 0x9, 0xf0, 0x9f, 0x9, 0xf0, 0x9f,
    0x9, 0xf0,

    /* U+006A "j" */
    0x0, 0x8, 0xe2, 0x0, 0x9, 0xf2, 0x0, 0x0,
    0x0, 0x0, 0x7, 0xf1, 0x0, 0x7, 0xf1, 0x0,
    0x7, 0xf1, 0x0, 0x7, 0xf1, 0x0, 0x7, 0xf1,
    0x0, 0x7, 0xf1, 0x0, 0x7, 0xf1, 0x0, 0x7,
    0xf1, 0x0, 0x7, 0xf1, 0x0, 0x8, 0xf0, 0x18,
    0x6e, 0xc0, 0x3e, 0xfb, 0x20,

    /* U+006B "k" */
    0x8f, 0x0, 0x0, 0x0, 0x8, 0xf0, 0x0, 0x0,
    0x0, 0x8f, 0x0, 0x0, 0x0, 0x8, 0xf0, 0x0,
    0x1d, 0xe1, 0x8f, 0x0, 0x1d, 0xe2, 0x8, 0xf0,
    0x1d, 0xe2, 0x0, 0x8f, 0x2d, 0xf3, 0x0, 0x8,
    0xfe, 0xff, 0x70, 0x0, 0x8f, 0xe2, 0xbf, 0x30,
    0x8, 0xf2, 0x1, 0xee, 0x10, 0x8f, 0x0, 0x3,
    0xfb, 0x8, 0xf0, 0x0, 0x7, 0xf7,

    /* U+006C "l" */
    0x8f, 0x8f, 0x8f, 0x8f, 0x8f, 0x8f, 0x8f, 0x8f,
    0x8f, 0x8f, 0x8f, 0x8f,

    /* U+006D "m" */
    0x8e, 0x2b, 0xfe, 0x90, 0x2a, 0xef, 0xb2, 0x8,
    0xfe, 0xa7, 0xbf, 0xbe, 0xc7, 0x9f, 0xe0, 0x8f,
    0x80, 0x0, 0xaf, 0xc0, 0x0, 0x6f, 0x58, 0xf1,
    0x0, 0x5, 0xf6, 0x0, 0x1, 0xf7, 0x8f, 0x0,
    0x0, 0x4f, 0x40, 0x0, 0xf, 0x88, 0xf0, 0x0,
    0x4, 0xf4, 0x0, 0x0, 0xf8, 0x8f, 0x0, 0x0,
    0x4f, 0x40, 0x0, 0xf, 0x88, 0xf0, 0x0, 0x4,
    0xf4, 0x0, 0x0, 0xf8, 0x8f, 0x0, 0x0, 0x4f,
    0x40, 0x0, 0xf, 0x80,

    /* U+006E "n" */
    0x8e, 0x2b, 0xff, 0xa2, 0x8, 0xfe, 0xb7, 0x9f,
    0xd0, 0x8f, 0x80, 0x0, 0x6f, 0x58, 0xf1, 0x0,
    0x1, 0xf7, 0x8f, 0x0, 0x0, 0xf, 0x88, 0xf0,
    0x0, 0x0, 0xf8, 0x8f, 0x0, 0x0, 0xf, 0x88,
    0xf0, 0x0, 0x0, 0xf8, 0x8f, 0x0, 0x0, 0xf,
    0x80,

    /* U+006F "o" */
    0x0, 0x3b, 0xef, 0xc4, 0x0, 0x4, 0xfd, 0x87,
    0xcf, 0x60, 0xd, 0xd0, 0x0, 0xb, 0xf1, 0x3f,
    0x50, 0x0, 0x3, 0xf5, 0x4f, 0x30, 0x0, 0x1,
    0xf7, 0x3f, 0x60, 0x0, 0x3, 0xf5, 0xd, 0xd0,
    0x0, 0xb, 0xf1, 0x4, 0xfd, 0x87, 0xcf, 0x60,
    0x0, 0x3b, 0xef, 0xc4, 0x0,

    /* U+0070 "p" */
    0x8e, 0x2b, 0xfe, 0xb3, 0x0, 0x8f, 0xfb, 0x57,
    0xdf, 0x30, 0x8f, 0x90, 0x0, 0xd, 0xc0, 0x8f,
    0x10, 0x0, 0x7, 0xf1, 0x8f, 0x0, 0x0, 0x5,
    0xf3, 0x8f, 0x20, 0x0, 0x7, 0xf1, 0x8f, 0xa0,
    0x0, 0x1e, 0xc0, 0x8f, 0xec, 0x78, 0xef, 0x30,
    0x8f, 0x2a, 0xfe, 0xb3, 0x0, 0x8f, 0x0, 0x0,
    0x0, 0x0, 0x8f, 0x0, 0x0, 0x0, 0x0, 0x8f,
    0x0, 0x0, 0x0, 0x0,

    /* U+0071 "q" */
    0x0, 0x3b, 0xfe, 0xa2, 0xf7, 0x4, 0xfd, 0x87,
    0xce, 0xf7, 0xe, 0xd0, 0x0, 0xb, 0xf7, 0x3f,
    0x50, 0x0, 0x3, 0xf7, 0x4f, 0x30, 0x0, 0x1,
    0xf7, 0x3f, 0x60, 0x0, 0x3, 0xf7, 0xe, 0xd0,
    0x0, 0xb, 0xf7, 0x4, 0xfd, 0x87, 0xce, 0xf7,
    0x0, 0x3b, 0xfe, 0xa2, 0xf7, 0x0, 0x0, 0x0,
    0x1, 0xf7, 0x0, 0x0, 0x0, 0x1, 0xf7, 0x0,
    0x0, 0x0, 0x1, 0xf7,

    /* U+0072 "r" */
    0x8e, 0x3b, 0xf0, 0x8f, 0xfc, 0x80, 0x8f, 0x90,
    0x0, 0x8f, 0x20, 0x0, 0x8f, 0x0, 0x0, 0x8f,
    0x0, 0x0, 0x8f, 0x0, 0x0, 0x8f, 0x0, 0x0,
    0x8f, 0x0, 0x0,

    /* U+0073 "s" */
    0x3, 0xbf, 0xfd, 0x91, 0x1f, 0xd7, 0x69, 0xd0,
    0x4f, 0x30, 0x0, 0x0, 0x2f, 0xc4, 0x10, 0x0,
    0x5, 0xef, 0xfd, 0x60, 0x0, 0x2, 0x5b, 0xf5,
    0x1, 0x0, 0x0, 0xf8, 0x5f, 0xa7, 0x6b, 0xf3,
    0x18, 0xdf, 0xfc, 0x40,

    /* U+0074 "t" */
    0x5, 0xf3, 0x0, 0x0, 0x5f, 0x30, 0x0, 0xcf,
    0xff, 0xfa, 0x4, 0x8f, 0x75, 0x30, 0x5, 0xf3,
    0x0, 0x0, 0x5f, 0x30, 0x0, 0x5, 0xf3, 0x0,
    0x0, 0x5f, 0x30, 0x0, 0x4, 0xf4, 0x0, 0x0,
    0x1f, 0xc6, 0x80, 0x0, 0x5d, 0xfb, 0x10,

    /* U+0075 "u" */
    0xae, 0x0, 0x0, 0x2f, 0x5a, 0xe0, 0x0, 0x2,
    0xf5, 0xae, 0x0, 0x0, 0x2f, 0x5a, 0xe0, 0x0,
    0x2, 0xf5, 0xae, 0x0, 0x0, 0x2f, 0x59, 0xf0,
    0x0, 0x4, 0xf5, 0x7f, 0x40, 0x0, 0xbf, 0x51,
    0xef, 0x97, 0xce, 0xf5, 0x2, 0xbf, 0xfa, 0x2f,
    0x50,

    /* U+0076 "v" */
    0xd, 0xc0, 0x0, 0x0, 0xcb, 0x6, 0xf2, 0x0,
    0x2, 0xf5, 0x0, 0xf9, 0x0, 0x9, 0xe0, 0x0,
    0x9f, 0x0, 0xf, 0x80, 0x0, 0x2f, 0x60, 0x6f,
    0x10, 0x0, 0xc, 0xc0, 0xdb, 0x0, 0x0, 0x5,
    0xf6, 0xf4, 0x0, 0x0, 0x0, 0xef, 0xd0, 0x0,
    0x0, 0x0, 0x8f, 0x70, 0x0,

    /* U+0077 "w" */
    0xbb, 0x0, 0x0, 0x9f, 0x10, 0x0, 0x4f, 0x16,
    0xf1, 0x0, 0xe, 0xf6, 0x0, 0x9, 0xc0, 0xf,
    0x60, 0x5, 0xfc, 0xc0, 0x0, 0xf6, 0x0, 0xac,
    0x0, 0xab, 0x5f, 0x10, 0x5f, 0x10, 0x5, 0xf1,
    0xf, 0x50, 0xf7, 0xa, 0xb0, 0x0, 0xf, 0x76,
    0xf0, 0x9, 0xc0, 0xf5, 0x0, 0x0, 0xac, 0xba,
    0x0, 0x4f, 0x8f, 0x0, 0x0, 0x4, 0xff, 0x40,
    0x0, 0xef, 0xa0, 0x0, 0x0, 0xe, 0xe0, 0x0,
    0x8, 0xf4, 0x0, 0x0,

    /* U+0078 "x" */
    0x4f, 0x70, 0x0, 0x9f, 0x20, 0x8f, 0x30, 0x5f,
    0x50, 0x0, 0xcd, 0x2e, 0x90, 0x0, 0x2, 0xff,
    0xd0, 0x0, 0x0, 0xa, 0xf7, 0x0, 0x0, 0x4,
    0xfd, 0xe1, 0x0, 0x1, 0xeb, 0xd, 0xc0, 0x0,
    0xbe, 0x10, 0x3f, 0x80, 0x6f, 0x40, 0x0, 0x7f,
    0x40,

    /* U+0079 "y" */
    0xd, 0xc0, 0x0, 0x0, 0xcb, 0x6, 0xf3, 0x0,
    0x2, 0xf4, 0x0, 0xe9, 0x0, 0x9, 0xd0, 0x0,
    0x8f, 0x10, 0x1f, 0x70, 0x0, 0x1f, 0x70, 0x7f,
    0x10, 0x0, 0xa, 0xe0, 0xd9, 0x0, 0x0, 0x3,
    0xfa, 0xf2, 0x0, 0x0, 0x0, 0xcf, 0xb0, 0x0,
    0x0, 0x0, 0x6f, 0x40, 0x0, 0x0, 0x0, 0xad,
    0x0, 0x0, 0xc, 0x79, 0xf5, 0x0, 0x0, 0x1a,
    0xee, 0x70, 0x0, 0x0,

    /* U+007A "z" */
    0x4f, 0xff, 0xff, 0xf9, 0x15, 0x55, 0x5b, 0xf4,
    0x0, 0x0, 0x3f, 0x80, 0x0, 0x1, 0xeb, 0x0,
    0x0, 0xb, 0xe1, 0x0, 0x0, 0x8f, 0x40, 0x0,
    0x4, 0xf7, 0x0, 0x0, 0x1e, 0xe5, 0x55, 0x53,
    0x5f, 0xff, 0xff, 0xfc,

    /* U+007B "{" */
    0x0, 0x2c, 0xf5, 0x0, 0xaf, 0x61, 0x0, 0xcc,
    0x0, 0x0, 0xdb, 0x0, 0x0, 0xdb, 0x0, 0x0,
    0xdb, 0x0, 0x2, 0xea, 0x0, 0x1f, 0xf4, 0x0,
    0x5, 0xf9, 0x0, 0x0, 0xdb, 0x0, 0x0, 0xdb,
    0x0, 0x0, 0xdb, 0x0, 0x0, 0xcc, 0x0, 0x0,
    0xaf, 0x61, 0x0, 0x2c, 0xf5,

    /* U+007C "|" */
    0x5f, 0x15, 0xf1, 0x5f, 0x15, 0xf1, 0x5f, 0x15,
    0xf1, 0x5f, 0x15, 0xf1, 0x5f, 0x15, 0xf1, 0x5f,
    0x15, 0xf1, 0x5f, 0x15, 0xf1, 0x5f, 0x10,

    /* U+007D "}" */
    0xbe, 0x80, 0x3, 0xaf, 0x40, 0x1, 0xf6, 0x0,
    0x1f, 0x70, 0x1, 0xf7, 0x0, 0x1f, 0x70, 0x0,
    0xf9, 0x0, 0xa, 0xfb, 0x0, 0xfb, 0x20, 0x1f,
    0x70, 0x1, 0xf7, 0x0, 0x1f, 0x70, 0x1, 0xf6,
    0x3, 0xaf, 0x40, 0xbe, 0x90, 0x0,

    /* U+007E "~" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3d, 0xe5, 0x0,
    0xb5, 0xc, 0x86, 0xf6, 0x2f, 0x20, 0xf0, 0x4,
    0xef, 0xa0, 0x3, 0x0, 0x1, 0x20, 0x0,

    /* U+00A0 " " */

    /* U+00A1 "¡" */
    0xad, 0xb, 0xf1, 0x1, 0x0, 0x0, 0x7c, 0x8,
    0xc0, 0x8d, 0x9, 0xe0, 0xae, 0xa, 0xf0, 0xbf,
    0x9, 0xc0,

    /* U+00A2 "¢" */
    0x0, 0x0, 0x78, 0x0, 0x0, 0x0, 0x7, 0x80,
    0x0, 0x0, 0x3b, 0xff, 0xd6, 0x0, 0x4f, 0xdb,
    0xbb, 0xf5, 0xe, 0xc0, 0x78, 0x6, 0x3, 0xf5,
    0x7, 0x80, 0x0, 0x4f, 0x30, 0x78, 0x0, 0x3,
    0xf6, 0x7, 0x80, 0x0, 0xe, 0xd0, 0x78, 0x6,
    0x0, 0x4f, 0xdc, 0xbc, 0xf5, 0x0, 0x3b, 0xff,
    0xd5, 0x0, 0x0, 0x7, 0x80, 0x0, 0x0, 0x0,
    0x78, 0x0, 0x0,

    /* U+00A3 "£" */
    0x0, 0x0, 0x6c, 0xfe, 0xc6, 0x0, 0x0, 0xaf,
    0xc8, 0x9c, 0xd0, 0x0, 0x4f, 0x80, 0x0, 0x1,
    0x0, 0x9, 0xf0, 0x0, 0x0, 0x0, 0x0, 0xbd,
    0x0, 0x0, 0x0, 0x0, 0xc, 0xd0, 0x0, 0x0,
    0x0, 0x7f, 0xff, 0xff, 0xff, 0x10, 0x1, 0x2c,
    0xd2, 0x22, 0x20, 0x0, 0x0, 0xcd, 0x0, 0x0,
    0x0, 0x0, 0xc, 0xd0, 0x0, 0x0, 0x0, 0x37,
    0xee, 0x77, 0x77, 0x76, 0x8, 0xff, 0xff, 0xff,
    0xff, 0xd0,

    /* U+00A4 "¤" */
    0x1a, 0x0, 0x0, 0x0, 0x9, 0x32, 0xeb, 0x7e,
    0xfe, 0x99, 0xf4, 0x3, 0xff, 0x84, 0x6e, 0xf5,
    0x0, 0x4f, 0x40, 0x0, 0x1e, 0x70, 0x9, 0xb0,
    0x0, 0x0, 0x7d, 0x0, 0xb8, 0x0, 0x0, 0x5,
    0xe0, 0xa, 0xa0, 0x0, 0x0, 0x6d, 0x0, 0x5f,
    0x20, 0x0, 0xd, 0x80, 0x1, 0xfe, 0x51, 0x4c,
    0xf4, 0x0, 0xce, 0xaf, 0xff, 0xcc, 0xe2, 0x3e,
    0x20, 0x13, 0x20, 0x1c, 0x60, 0x0, 0x0, 0x0,
    0x0, 0x0,

    /* U+00A5 "¥" */
    0xb, 0xe0, 0x0, 0x0, 0x0, 0x9f, 0x10, 0x2f,
    0x90, 0x0, 0x0, 0x3f, 0x60, 0x0, 0x7f, 0x30,
    0x0, 0xd, 0xc0, 0x0, 0x0, 0xdd, 0x0, 0x7,
    0xf2, 0x0, 0x0, 0x3, 0xf7, 0x2, 0xf8, 0x0,
    0x0, 0x0, 0x9, 0xf2, 0xbd, 0x0, 0x0, 0x0,
    0x0, 0xe, 0xef, 0x40, 0x0, 0x0, 0x7, 0xff,
    0xff, 0xff, 0xfc, 0x0, 0x0, 0x0, 0x2, 0xf7,
    0x0, 0x0, 0x0, 0x7, 0xff, 0xff, 0xff, 0xfc,
    0x0, 0x0, 0x0, 0x2, 0xf7, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x2f, 0x70, 0x0, 0x0,

    /* U+00A6 "¦" */
    0x5f, 0x15, 0xf1, 0x5f, 0x15, 0xf1, 0x5f, 0x14,
    0xe1, 0x0, 0x0, 0x0, 0x0, 0x4, 0xe1, 0x5f,
    0x15, 0xf1, 0x5f, 0x15, 0xf1, 0x5f, 0x10,

    /* U+00A7 "§" */
    0x0, 0x9e, 0xfe, 0xa2, 0xb, 0xe6, 0x56, 0xc4,
    0xf, 0x50, 0x0, 0x0, 0xe, 0xc2, 0x0, 0x0,
    0x7, 0xff, 0xe9, 0x20, 0x2f, 0x62, 0x6d, 0xe1,
    0x6f, 0x0, 0x0, 0xf6, 0x3f, 0x81, 0x1, 0xf4,
    0x4, 0xcf, 0xce, 0xa0, 0x0, 0x1, 0x6e, 0xc0,
    0x0, 0x0, 0x5, 0xf1, 0x4a, 0x31, 0x2b, 0xe0,
    0x3c, 0xff, 0xfd, 0x30, 0x0, 0x13, 0x20, 0x0,

    /* U+00A8 "¨" */
    0x39, 0x3, 0x80, 0x5d, 0x5, 0xd0,

    /* U+00A9 "©" */
    0x0, 0x1, 0x8b, 0xcb, 0x70, 0x0, 0x0, 0x4,
    0xc4, 0x0, 0x5, 0xc3, 0x0, 0x2, 0xb0, 0x4c,
    0xed, 0x51, 0xc1, 0x0, 0xa2, 0x3f, 0x83, 0x7d,
    0x4, 0x80, 0xb, 0x9, 0xa0, 0x0, 0x0, 0xc,
    0x3, 0x80, 0xc7, 0x0, 0x0, 0x0, 0xb0, 0x38,
    0xa, 0x90, 0x0, 0x0, 0xb, 0x0, 0xb0, 0x4f,
    0x50, 0x3a, 0x0, 0xc0, 0xb, 0x20, 0x6f, 0xff,
    0x70, 0x58, 0x0, 0x2b, 0x0, 0x2, 0x0, 0x2c,
    0x10, 0x0, 0x4c, 0x40, 0x0, 0x6c, 0x20, 0x0,
    0x0, 0x18, 0xbc, 0xb7, 0x0, 0x0,

    /* U+00AA "ª" */
    0x1a, 0xdd, 0xa0, 0x3, 0x0, 0xd5, 0x9, 0xbb,
    0xe6, 0x5c, 0x0, 0xc6, 0x1a, 0xdb, 0xa6,

    /* U+00AB "«" */
    0x0, 0x6, 0x10, 0x62, 0x0, 0xac, 0x9, 0xd0,
    0x5, 0xf2, 0x4f, 0x20, 0x1f, 0x60, 0xe7, 0x0,
    0xc, 0xa0, 0xbb, 0x0, 0x1, 0xe5, 0x1e, 0x70,
    0x0, 0x5f, 0x24, 0xf2,

    /* U+00AC "¬" */
    0x11, 0x11, 0x11, 0x10, 0xef, 0xff, 0xff, 0xf3,
    0x34, 0x44, 0x45, 0xf3, 0x0, 0x0, 0x2, 0xf3,
    0x0, 0x0, 0x2, 0xf3, 0x0, 0x0, 0x0, 0x40,

    /* U+00AD "­" */
    0x1, 0x11, 0x10, 0x1f, 0xff, 0xf3, 0x4, 0x44,
    0x40,

    /* U+00AE "®" */
    0x0, 0x1, 0x8b, 0xcb, 0x70, 0x0, 0x0, 0x4,
    0xc4, 0x0, 0x5, 0xc3, 0x0, 0x2, 0xb0, 0x0,
    0x0, 0x1, 0xc1, 0x0, 0xa2, 0xd, 0xff, 0xd6,
    0x4, 0x80, 0xb, 0x0, 0xd3, 0x2, 0xe2, 0xc,
    0x3, 0x80, 0xd, 0x30, 0x2e, 0x20, 0xb0, 0x38,
    0x0, 0xdf, 0xff, 0x60, 0xb, 0x0, 0xb0, 0xd,
    0x30, 0xb6, 0x0, 0xc0, 0xb, 0x20, 0xd3, 0x2,
    0xe0, 0x58, 0x0, 0x2b, 0x3, 0x0, 0x2, 0x3c,
    0x10, 0x0, 0x4c, 0x40, 0x0, 0x6c, 0x20, 0x0,
    0x0, 0x18, 0xbc, 0xb7, 0x0, 0x0,

    /* U+00AF "¯" */
    0xce, 0xee, 0xe5, 0x11, 0x11, 0x10,

    /* U+00B0 "°" */
    0x2, 0xcd, 0x90, 0xd, 0x40, 0x89, 0x3b, 0x0,
    0xe, 0x3b, 0x0, 0xe, 0xd, 0x40, 0x89, 0x2,
    0xce, 0x90,

    /* U+00B1 "±" */
    0x0, 0x3, 0x0, 0x0, 0x0, 0xf, 0x50, 0x0,
    0x0, 0xf, 0x50, 0x0, 0x1, 0x1f, 0x51, 0x10,
    0xef, 0xff, 0xff, 0xf3, 0x34, 0x4f, 0x74, 0x40,
    0x0, 0xf, 0x50, 0x0, 0x0, 0xf, 0x50, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x45, 0x55, 0x55, 0x51,
    0xef, 0xff, 0xff, 0xf3,

    /* U+00B2 "²" */
    0x1a, 0xef, 0xb1, 0x2, 0x71, 0xa, 0xa0, 0x0,
    0x0, 0x8a, 0x0, 0x0, 0x4e, 0x20, 0x0, 0x5e,
    0x30, 0x0, 0x7e, 0x20, 0x0, 0x3f, 0xfe, 0xee,
    0x0,

    /* U+00B3 "³" */
    0x5f, 0xff, 0xfb, 0x0, 0x0, 0x3e, 0x20, 0x0,
    0x2e, 0x40, 0x0, 0x5, 0xce, 0x60, 0x0, 0x0,
    0x3f, 0x3, 0x50, 0x5, 0xe0, 0x3b, 0xef, 0xc3,
    0x0,

    /* U+00B4 "´" */
    0x1, 0x30, 0xd, 0xb0, 0x2f, 0x30,

    /* U+00B5 "µ" */
    0x9f, 0x0, 0x0, 0x1f, 0x79, 0xf0, 0x0, 0x1,
    0xf7, 0x9f, 0x0, 0x0, 0x1f, 0x79, 0xf0, 0x0,
    0x1, 0xf7, 0x9f, 0x0, 0x0, 0x1f, 0x79, 0xf0,
    0x0, 0x3, 0xf7, 0x9f, 0x40, 0x0, 0x9f, 0x79,
    0xfe, 0x76, 0xaf, 0xf7, 0x9f, 0x7e, 0xfb, 0x3f,
    0x79, 0xf0, 0x0, 0x0, 0x0, 0x9f, 0x0, 0x0,
    0x0, 0x9, 0xf0, 0x0, 0x0, 0x0,

    /* U+00B6 "¶" */
    0x4, 0xcf, 0xff, 0xff, 0xb4, 0xff, 0xfe, 0x44,
    0xbb, 0xaf, 0xff, 0xe0, 0x9, 0xba, 0xff, 0xfe,
    0x0, 0x9b, 0x4f, 0xff, 0xe0, 0x9, 0xb0, 0x6e,
    0xfe, 0x0, 0x9b, 0x0, 0x6, 0xe0, 0x9, 0xb0,
    0x0, 0x6e, 0x0, 0x9b, 0x0, 0x6, 0xe0, 0x9,
    0xb0, 0x0, 0x6e, 0x0, 0x9b, 0x0, 0x6, 0xe0,
    0x9, 0xb0, 0x0, 0x6e, 0x0, 0x9b, 0x0, 0x6,
    0xe0, 0x9, 0xb0, 0x0, 0x6e, 0x0, 0x9b, 0x0,
    0x1, 0x30, 0x2, 0x20,

    /* U+00B7 "·" */
    0x12, 0xd, 0xf1, 0xad, 0x0,

    /* U+00B8 "¸" */
    0x0, 0xc1, 0x0, 0xb, 0xd1, 0x1, 0xd, 0x50,
    0xbe, 0xa0,

    /* U+00B9 "¹" */
    0x8f, 0xf4, 0x0, 0xd, 0x40, 0x0, 0xd4, 0x0,
    0xd, 0x40, 0x0, 0xd4, 0x0, 0xd, 0x40, 0xae,
    0xff, 0xd0,

    /* U+00BA "º" */
    0x6, 0xde, 0xc3, 0x4, 0xe2, 0x5, 0xe0, 0x7a,
    0x0, 0xf, 0x23, 0xe3, 0x6, 0xe0, 0x5, 0xde,
    0xc2, 0x0,

    /* U+00BB "»" */
    0x26, 0x1, 0x71, 0x0, 0xc, 0x90, 0xba, 0x0,
    0x2, 0xf5, 0x1e, 0x60, 0x0, 0x7e, 0x16, 0xf1,
    0x0, 0xbb, 0xa, 0xc0, 0x6, 0xe1, 0x5f, 0x20,
    0x2f, 0x41, 0xe5, 0x0,

    /* U+00BC "¼" */
    0x9f, 0xf4, 0x0, 0x0, 0x0, 0xd5, 0x0, 0x0,
    0x0, 0xd4, 0x0, 0x0, 0x8, 0xb0, 0x0, 0x0,
    0x0, 0xd4, 0x0, 0x0, 0x3e, 0x10, 0x0, 0x0,
    0x0, 0xd4, 0x0, 0x0, 0xd5, 0x0, 0x0, 0x0,
    0x0, 0xd4, 0x0, 0x8, 0xb0, 0x0, 0x21, 0x0,
    0x0, 0xd4, 0x0, 0x3e, 0x10, 0x4, 0xe1, 0x0,
    0xbf, 0xff, 0xe0, 0xd5, 0x0, 0x1e, 0x30, 0x0,
    0x0, 0x0, 0x8, 0xb0, 0x0, 0xb7, 0x3, 0x0,
    0x0, 0x0, 0x3e, 0x10, 0x7, 0xb0, 0x3c, 0x0,
    0x0, 0x0, 0xd5, 0x0, 0xf, 0xff, 0xff, 0xf1,
    0x0, 0x8, 0xb0, 0x0, 0x0, 0x0, 0x4c, 0x0,
    0x0, 0x7, 0x10, 0x0, 0x0, 0x0, 0x26, 0x0,

    /* U+00BD "½" */
    0x9f, 0xf4, 0x0, 0x0, 0x0, 0xc5, 0x0, 0x0,
    0xd, 0x40, 0x0, 0x0, 0x7b, 0x0, 0x0, 0x0,
    0xd4, 0x0, 0x0, 0x2e, 0x20, 0x0, 0x0, 0xd,
    0x40, 0x0, 0xc, 0x70, 0x0, 0x0, 0x0, 0xd4,
    0x0, 0x6, 0xc0, 0x0, 0x0, 0x0, 0xd, 0x40,
    0x1, 0xe3, 0x3b, 0xdd, 0x70, 0xbf, 0xff, 0xe0,
    0xa8, 0x3, 0x30, 0x2e, 0x40, 0x0, 0x0, 0x4d,
    0x0, 0x0, 0x0, 0xd4, 0x0, 0x0, 0xe, 0x40,
    0x0, 0x0, 0x9c, 0x0, 0x0, 0x9, 0xa0, 0x0,
    0x0, 0xab, 0x0, 0x0, 0x3, 0xe1, 0x0, 0x0,
    0xba, 0x0, 0x0, 0x0, 0xd5, 0x0, 0x0, 0x9f,
    0xff, 0xfb,

    /* U+00BE "¾" */
    0x5f, 0xff, 0xfb, 0x0, 0x0, 0xd, 0x50, 0x0,
    0x0, 0x0, 0x3e, 0x20, 0x0, 0x8, 0xb0, 0x0,
    0x0, 0x0, 0x2e, 0x40, 0x0, 0x3, 0xe1, 0x0,
    0x0, 0x0, 0x6, 0xde, 0x60, 0x0, 0xd5, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x3f, 0x0, 0x8b, 0x0,
    0x2, 0x10, 0x3, 0x50, 0x5, 0xf0, 0x3e, 0x10,
    0x4, 0xe1, 0x0, 0x3c, 0xff, 0xe4, 0xd, 0x50,
    0x1, 0xe3, 0x0, 0x0, 0x0, 0x10, 0x8, 0xb0,
    0x0, 0xb7, 0x3, 0x0, 0x0, 0x0, 0x3, 0xe1,
    0x0, 0x7b, 0x3, 0xc0, 0x0, 0x0, 0x0, 0xd5,
    0x0, 0xf, 0xff, 0xff, 0xf1, 0x0, 0x0, 0x8b,
    0x0, 0x0, 0x0, 0x4, 0xc0, 0x0, 0x0, 0x7,
    0x10, 0x0, 0x0, 0x0, 0x26, 0x0,

    /* U+00BF "¿" */
    0x0, 0x2e, 0x80, 0x0, 0x0, 0x3, 0xf9, 0x0,
    0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x42,
    0x0, 0x0, 0x0, 0x4f, 0x50, 0x0, 0x0, 0x2e,
    0xc0, 0x0, 0x0, 0x2e, 0xc0, 0x0, 0x0, 0xa,
    0xe0, 0x0, 0x0, 0x0, 0xdc, 0x0, 0x0, 0x10,
    0xa, 0xf8, 0x22, 0x6e, 0xb0, 0x1b, 0xff, 0xff,
    0xb1, 0x0, 0x1, 0x43, 0x10, 0x0,

    /* U+00C0 "À" */
    0x0, 0x0, 0x8f, 0x40, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x7f, 0x30, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x56, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2f, 0xd0,
    0x0, 0x0, 0x0, 0x0, 0x9, 0xff, 0x40, 0x0,
    0x0, 0x0, 0x0, 0xf9, 0xea, 0x0, 0x0, 0x0,
    0x0, 0x7f, 0x28, 0xf1, 0x0, 0x0, 0x0, 0xd,
    0xc0, 0x1f, 0x80, 0x0, 0x0, 0x4, 0xf5, 0x0,
    0xbe, 0x0, 0x0, 0x0, 0xbe, 0x0, 0x5, 0xf6,
    0x0, 0x0, 0x2f, 0x91, 0x11, 0x1e, 0xc0, 0x0,
    0x8, 0xff, 0xff, 0xff, 0xff, 0x30, 0x0, 0xec,
    0x44, 0x44, 0x44, 0xfa, 0x0, 0x6f, 0x40, 0x0,
    0x0, 0xa, 0xf1, 0xd, 0xd0, 0x0, 0x0, 0x0,
    0x3f, 0x80,

    /* U+00C1 "Á" */
    0x0, 0x0, 0x0, 0xbe, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xf, 0x50, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x30, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2f, 0xd0,
    0x0, 0x0, 0x0, 0x0, 0x9, 0xff, 0x40, 0x0,
    0x0, 0x0, 0x0, 0xf9, 0xea, 0x0, 0x0, 0x0,
    0x0, 0x7f, 0x28, 0xf1, 0x0, 0x0, 0x0, 0xd,
    0xc0, 0x1f, 0x80, 0x0, 0x0, 0x4, 0xf5, 0x0,
    0xbe, 0x0, 0x0, 0x0, 0xbe, 0x0, 0x5, 0xf6,
    0x0, 0x0, 0x2f, 0x91, 0x11, 0x1e, 0xc0, 0x0,
    0x8, 0xff, 0xff, 0xff, 0xff, 0x30, 0x0, 0xec,
    0x44, 0x44, 0x44, 0xfa, 0x0, 0x6f, 0x40, 0x0,
    0x0, 0xa, 0xf1, 0xd, 0xd0, 0x0, 0x0, 0x0,
    0x3f, 0x80,

    /* U+00C2 "Â" */
    0x0, 0x0, 0x5, 0xfe, 0x10, 0x0, 0x0, 0x0,
    0x3, 0xf6, 0xac, 0x0, 0x0, 0x0, 0x0, 0x64,
    0x0, 0x73, 0x0, 0x0, 0x0, 0x0, 0x2f, 0xd0,
    0x0, 0x0, 0x0, 0x0, 0x9, 0xff, 0x40, 0x0,
    0x0, 0x0, 0x0, 0xf9, 0xea, 0x0, 0x0, 0x0,
    0x0, 0x7f, 0x28, 0xf1, 0x0, 0x0, 0x0, 0xd,
    0xc0, 0x1f, 0x80, 0x0, 0x0, 0x4, 0xf5, 0x0,
    0xbe, 0x0, 0x0, 0x0, 0xbe, 0x0, 0x5, 0xf6,
    0x0, 0x0, 0x2f, 0x91, 0x11, 0x1e, 0xc0, 0x0,
    0x8, 0xff, 0xff, 0xff, 0xff, 0x30, 0x0, 0xec,
    0x44, 0x44, 0x44, 0xfa, 0x0, 0x6f, 0x40, 0x0,
    0x0, 0xa, 0xf1, 0xd, 0xd0, 0x0, 0x0, 0x0,
    0x3f, 0x80,

    /* U+00C3 "Ã" */
    0x0, 0x0, 0x4d, 0xa2, 0x86, 0x0, 0x0, 0x0,
    0xc, 0x35, 0xed, 0x10, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2f, 0xd0,
    0x0, 0x0, 0x0, 0x0, 0x9, 0xff, 0x40, 0x0,
    0x0, 0x0, 0x0, 0xf9, 0xea, 0x0, 0x0, 0x0,
    0x0, 0x7f, 0x28, 0xf1, 0x0, 0x0, 0x0, 0xd,
    0xc0, 0x1f, 0x80, 0x0, 0x0, 0x4, 0xf5, 0x0,
    0xbe, 0x0, 0x0, 0x0, 0xbe, 0x0, 0x5, 0xf6,
    0x0, 0x0, 0x2f, 0x91, 0x11, 0x1e, 0xc0, 0x0,
    0x8, 0xff, 0xff, 0xff, 0xff, 0x30, 0x0, 0xec,
    0x44, 0x44, 0x44, 0xfa, 0x0, 0x6f, 0x40, 0x0,
    0x0, 0xa, 0xf1, 0xd, 0xd0, 0x0, 0x0, 0x0,
    0x3f, 0x80,

    /* U+00C4 "Ä" */
    0x0, 0x0, 0x29, 0x2, 0x90, 0x0, 0x0, 0x0,
    0x4, 0xe0, 0x4d, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2f, 0xd0,
    0x0, 0x0, 0x0, 0x0, 0x9, 0xff, 0x40, 0x0,
    0x0, 0x0, 0x0, 0xf9, 0xea, 0x0, 0x0, 0x0,
    0x0, 0x7f, 0x28, 0xf1, 0x0, 0x0, 0x0, 0xd,
    0xc0, 0x1f, 0x80, 0x0, 0x0, 0x4, 0xf5, 0x0,
    0xbe, 0x0, 0x0, 0x0, 0xbe, 0x0, 0x5, 0xf6,
    0x0, 0x0, 0x2f, 0x91, 0x11, 0x1e, 0xc0, 0x0,
    0x8, 0xff, 0xff, 0xff, 0xff, 0x30, 0x0, 0xec,
    0x44, 0x44, 0x44, 0xfa, 0x0, 0x6f, 0x40, 0x0,
    0x0, 0xa, 0xf1, 0xd, 0xd0, 0x0, 0x0, 0x0,
    0x3f, 0x80,

    /* U+00C5 "Å" */
    0x0, 0x0, 0x3, 0xb9, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xb0, 0x47, 0x0, 0x0, 0x0, 0x0, 0xb,
    0x4, 0x70, 0x0, 0x0, 0x0, 0x0, 0x3a, 0x90,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x2f, 0xd0, 0x0, 0x0, 0x0,
    0x0, 0x9, 0xff, 0x40, 0x0, 0x0, 0x0, 0x0,
    0xf9, 0xea, 0x0, 0x0, 0x0, 0x0, 0x7f, 0x28,
    0xf1, 0x0, 0x0, 0x0, 0xd, 0xc0, 0x1f, 0x80,
    0x0, 0x0, 0x4, 0xf5, 0x0, 0xbe, 0x0, 0x0,
    0x0, 0xbe, 0x0, 0x5, 0xf6, 0x0, 0x0, 0x2f,
    0x91, 0x11, 0x1e, 0xc0, 0x0, 0x8, 0xff, 0xff,
    0xff, 0xff, 0x30, 0x0, 0xec, 0x44, 0x44, 0x44,
    0xfa, 0x0, 0x6f, 0x40, 0x0, 0x0, 0xa, 0xf1,
    0xd, 0xd0, 0x0, 0x0, 0x0, 0x3f, 0x80,

    /* U+00C6 "Æ" */
    0x0, 0x0, 0x0, 0xa, 0xff, 0xff, 0xff, 0xff,
    0xa0, 0x0, 0x0, 0x2, 0xfb, 0xf9, 0x77, 0x77,
    0x74, 0x0, 0x0, 0x0, 0xbd, 0x4f, 0x50, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x4f, 0x54, 0xf5, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xd, 0xc0, 0x4f, 0x61,
    0x11, 0x11, 0x0, 0x0, 0x6, 0xf4, 0x4, 0xff,
    0xff, 0xff, 0xe0, 0x0, 0x0, 0xec, 0x0, 0x4f,
    0x84, 0x44, 0x44, 0x0, 0x0, 0x8f, 0x51, 0x15,
    0xf5, 0x0, 0x0, 0x0, 0x0, 0x1f, 0xff, 0xff,
    0xff, 0x50, 0x0, 0x0, 0x0, 0xa, 0xf5, 0x44,
    0x47, 0xf5, 0x0, 0x0, 0x0, 0x3, 0xf8, 0x0,
    0x0, 0x4f, 0xa7, 0x77, 0x77, 0x60, 0xbe, 0x0,
    0x0, 0x4, 0xff, 0xff, 0xff, 0xfd,

    /* U+00C7 "Ç" */
    0x0, 0x2, 0x9d, 0xfe, 0xb4, 0x0, 0x5, 0xff,
    0xb8, 0x9e, 0xf8, 0x3, 0xfd, 0x20, 0x0, 0x8,
    0x40, 0xbf, 0x20, 0x0, 0x0, 0x0, 0x1f, 0x90,
    0x0, 0x0, 0x0, 0x3, 0xf6, 0x0, 0x0, 0x0,
    0x0, 0x3f, 0x60, 0x0, 0x0, 0x0, 0x1, 0xf9,
    0x0, 0x0, 0x0, 0x0, 0xb, 0xf2, 0x0, 0x0,
    0x0, 0x0, 0x3f, 0xd2, 0x0, 0x0, 0x85, 0x0,
    0x5f, 0xfa, 0x89, 0xef, 0x80, 0x0, 0x29, 0xef,
    0xeb, 0x40, 0x0, 0x0, 0x4, 0xd2, 0x0, 0x0,
    0x0, 0x0, 0x5, 0xe0, 0x0, 0x0, 0x0, 0x3e,
    0xe8, 0x0, 0x0,

    /* U+00C8 "È" */
    0x0, 0xbe, 0x20, 0x0, 0x0, 0x0, 0xad, 0x10,
    0x0, 0x0, 0x0, 0x64, 0x0, 0x5, 0xff, 0xff,
    0xff, 0xf9, 0x5f, 0x97, 0x77, 0x77, 0x45, 0xf4,
    0x0, 0x0, 0x0, 0x5f, 0x40, 0x0, 0x0, 0x5,
    0xf5, 0x11, 0x11, 0x10, 0x5f, 0xff, 0xff, 0xfe,
    0x5, 0xf7, 0x44, 0x44, 0x40, 0x5f, 0x40, 0x0,
    0x0, 0x5, 0xf4, 0x0, 0x0, 0x0, 0x5f, 0x40,
    0x0, 0x0, 0x5, 0xf9, 0x77, 0x77, 0x75, 0x5f,
    0xff, 0xff, 0xff, 0xc0,

    /* U+00C9 "É" */
    0x0, 0x0, 0xea, 0x0, 0x0, 0x0, 0x3f, 0x20,
    0x0, 0x0, 0x1, 0x20, 0x0, 0x5, 0xff, 0xff,
    0xff, 0xf9, 0x5f, 0x97, 0x77, 0x77, 0x45, 0xf4,
    0x0, 0x0, 0x0, 0x5f, 0x40, 0x0, 0x0, 0x5,
    0xf5, 0x11, 0x11, 0x10, 0x5f, 0xff, 0xff, 0xfe,
    0x5, 0xf7, 0x44, 0x44, 0x40, 0x5f, 0x40, 0x0,
    0x0, 0x5, 0xf4, 0x0, 0x0, 0x0, 0x5f, 0x40,
    0x0, 0x0, 0x5, 0xf9, 0x77, 0x77, 0x75, 0x5f,
    0xff, 0xff, 0xff, 0xc0,

    /* U+00CA "Ê" */
    0x0, 0x8, 0xfc, 0x0, 0x0, 0x6, 0xe4, 0xda,
    0x0, 0x0, 0x73, 0x1, 0x72, 0x5, 0xff, 0xff,
    0xff, 0xf9, 0x5f, 0x97, 0x77, 0x77, 0x45, 0xf4,
    0x0, 0x0, 0x0, 0x5f, 0x40, 0x0, 0x0, 0x5,
    0xf5, 0x11, 0x11, 0x10, 0x5f, 0xff, 0xff, 0xfe,
    0x5, 0xf7, 0x44, 0x44, 0x40, 0x5f, 0x40, 0x0,
    0x0, 0x5, 0xf4, 0x0, 0x0, 0x0, 0x5f, 0x40,
    0x0, 0x0, 0x5, 0xf9, 0x77, 0x77, 0x75, 0x5f,
    0xff, 0xff, 0xff, 0xc0,

    /* U+00CB "Ë" */
    0x0, 0x47, 0x5, 0x70, 0x0, 0x7, 0xb0, 0x8b,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x5, 0xff, 0xff,
    0xff, 0xf9, 0x5f, 0x97, 0x77, 0x77, 0x45, 0xf4,
    0x0, 0x0, 0x0, 0x5f, 0x40, 0x0, 0x0, 0x5,
    0xf5, 0x11, 0x11, 0x10, 0x5f, 0xff, 0xff, 0xfe,
    0x5, 0xf7, 0x44, 0x44, 0x40, 0x5f, 0x40, 0x0,
    0x0, 0x5, 0xf4, 0x0, 0x0, 0x0, 0x5f, 0x40,
    0x0, 0x0, 0x5, 0xf9, 0x77, 0x77, 0x75, 0x5f,
    0xff, 0xff, 0xff, 0xc0,

    /* U+00CC "Ì" */
    0x1d, 0xd1, 0x0, 0x1c, 0xc0, 0x0, 0x7, 0x30,
    0x5, 0xf4, 0x0, 0x5f, 0x40, 0x5, 0xf4, 0x0,
    0x5f, 0x40, 0x5, 0xf4, 0x0, 0x5f, 0x40, 0x5,
    0xf4, 0x0, 0x5f, 0x40, 0x5, 0xf4, 0x0, 0x5f,
    0x40, 0x5, 0xf4, 0x0, 0x5f, 0x40,

    /* U+00CD "Í" */
    0x1f, 0x86, 0xe1, 0x12, 0x5, 0xf4, 0x5f, 0x45,
    0xf4, 0x5f, 0x45, 0xf4, 0x5f, 0x45, 0xf4, 0x5f,
    0x45, 0xf4, 0x5f, 0x45, 0xf4, 0x5f, 0x40,

    /* U+00CE "Î" */
    0x0, 0xaf, 0x90, 0x0, 0x8d, 0x4e, 0x70, 0x17,
    0x10, 0x27, 0x10, 0x5, 0xf4, 0x0, 0x0, 0x5f,
    0x40, 0x0, 0x5, 0xf4, 0x0, 0x0, 0x5f, 0x40,
    0x0, 0x5, 0xf4, 0x0, 0x0, 0x5f, 0x40, 0x0,
    0x5, 0xf4, 0x0, 0x0, 0x5f, 0x40, 0x0, 0x5,
    0xf4, 0x0, 0x0, 0x5f, 0x40, 0x0, 0x5, 0xf4,
    0x0, 0x0, 0x5f, 0x40, 0x0,

    /* U+00CF "Ï" */
    0x66, 0x6, 0x5a, 0x90, 0xa8, 0x0, 0x0, 0x0,
    0x5f, 0x40, 0x5, 0xf4, 0x0, 0x5f, 0x40, 0x5,
    0xf4, 0x0, 0x5f, 0x40, 0x5, 0xf4, 0x0, 0x5f,
    0x40, 0x5, 0xf4, 0x0, 0x5f, 0x40, 0x5, 0xf4,
    0x0, 0x5f, 0x40, 0x5, 0xf4, 0x0,

    /* U+00D0 "Ð" */
    0x3, 0xff, 0xff, 0xfe, 0xb4, 0x0, 0x0, 0x3f,
    0xa7, 0x77, 0x9e, 0xfa, 0x0, 0x3, 0xf6, 0x0,
    0x0, 0x8, 0xf8, 0x0, 0x3f, 0x60, 0x0, 0x0,
    0xb, 0xf1, 0x4, 0xf7, 0x11, 0x0, 0x0, 0x4f,
    0x6d, 0xff, 0xff, 0xf8, 0x0, 0x1, 0xf8, 0x37,
    0xfa, 0x44, 0x20, 0x0, 0x1f, 0x80, 0x3f, 0x60,
    0x0, 0x0, 0x4, 0xf5, 0x3, 0xf6, 0x0, 0x0,
    0x0, 0xbf, 0x10, 0x3f, 0x60, 0x0, 0x0, 0x9f,
    0x80, 0x3, 0xfa, 0x77, 0x79, 0xef, 0x90, 0x0,
    0x3f, 0xff, 0xff, 0xea, 0x40, 0x0,

    /* U+00D1 "Ñ" */
    0x0, 0x8, 0xd7, 0x1c, 0x10, 0x0, 0x2, 0xd1,
    0x9f, 0x90, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x5, 0xf5, 0x0, 0x0, 0x4, 0xf4, 0x5f, 0xf2,
    0x0, 0x0, 0x4f, 0x45, 0xff, 0xd0, 0x0, 0x4,
    0xf4, 0x5f, 0xaf, 0x90, 0x0, 0x4f, 0x45, 0xf4,
    0xaf, 0x50, 0x4, 0xf4, 0x5f, 0x40, 0xdf, 0x20,
    0x4f, 0x45, 0xf4, 0x2, 0xfd, 0x4, 0xf4, 0x5f,
    0x40, 0x6, 0xf9, 0x4f, 0x45, 0xf4, 0x0, 0xa,
    0xfa, 0xf4, 0x5f, 0x40, 0x0, 0xd, 0xff, 0x45,
    0xf4, 0x0, 0x0, 0x2f, 0xf4, 0x5f, 0x40, 0x0,
    0x0, 0x6f, 0x40,

    /* U+00D2 "Ò" */
    0x0, 0x0, 0x8f, 0x50, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x4e, 0x60, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x29, 0xdf, 0xeb,
    0x50, 0x0, 0x0, 0x5f, 0xfb, 0x89, 0xef, 0xa0,
    0x0, 0x3f, 0xd2, 0x0, 0x0, 0x8f, 0x90, 0xb,
    0xf2, 0x0, 0x0, 0x0, 0xaf, 0x21, 0xf9, 0x0,
    0x0, 0x0, 0x2, 0xf7, 0x3f, 0x60, 0x0, 0x0,
    0x0, 0xf, 0x93, 0xf6, 0x0, 0x0, 0x0, 0x0,
    0xf9, 0x1f, 0x90, 0x0, 0x0, 0x0, 0x2f, 0x70,
    0xbf, 0x20, 0x0, 0x0, 0xa, 0xf2, 0x3, 0xfd,
    0x20, 0x0, 0x8, 0xf9, 0x0, 0x5, 0xff, 0xa8,
    0x9d, 0xfa, 0x0, 0x0, 0x2, 0x9d, 0xfe, 0xb5,
    0x0, 0x0,

    /* U+00D3 "Ó" */
    0x0, 0x0, 0x0, 0xdc, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x2f, 0x30, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x20, 0x0, 0x0, 0x0, 0x0, 0x29, 0xdf, 0xeb,
    0x50, 0x0, 0x0, 0x5f, 0xfb, 0x89, 0xef, 0xa0,
    0x0, 0x3f, 0xd2, 0x0, 0x0, 0x8f, 0x90, 0xb,
    0xf2, 0x0, 0x0, 0x0, 0xaf, 0x21, 0xf9, 0x0,
    0x0, 0x0, 0x2, 0xf7, 0x3f, 0x60, 0x0, 0x0,
    0x0, 0xf, 0x93, 0xf6, 0x0, 0x0, 0x0, 0x0,
    0xf9, 0x1f, 0x90, 0x0, 0x0, 0x0, 0x2f, 0x70,
    0xbf, 0x20, 0x0, 0x0, 0xa, 0xf2, 0x3, 0xfd,
    0x20, 0x0, 0x8, 0xf9, 0x0, 0x5, 0xff, 0xa8,
    0x9d, 0xfa, 0x0, 0x0, 0x2, 0x9d, 0xfe, 0xb5,
    0x0, 0x0,

    /* U+00D4 "Ô" */
    0x0, 0x0, 0x8, 0xfd, 0x10, 0x0, 0x0, 0x0,
    0x9, 0xc1, 0x7d, 0x20, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x29, 0xdf, 0xeb,
    0x50, 0x0, 0x0, 0x5f, 0xfb, 0x89, 0xef, 0xa0,
    0x0, 0x3f, 0xd2, 0x0, 0x0, 0x8f, 0x90, 0xb,
    0xf2, 0x0, 0x0, 0x0, 0xaf, 0x21, 0xf9, 0x0,
    0x0, 0x0, 0x2, 0xf7, 0x3f, 0x60, 0x0, 0x0,
    0x0, 0xf, 0x93, 0xf6, 0x0, 0x0, 0x0, 0x0,
    0xf9, 0x1f, 0x90, 0x0, 0x0, 0x0, 0x2f, 0x70,
    0xbf, 0x20, 0x0, 0x0, 0xa, 0xf2, 0x3, 0xfd,
    0x20, 0x0, 0x8, 0xf9, 0x0, 0x5, 0xff, 0xa8,
    0x9d, 0xfa, 0x0, 0x0, 0x2, 0x9d, 0xfe, 0xb5,
    0x0, 0x0,

    /* U+00D5 "Õ" */
    0x0, 0x0, 0x5d, 0x91, 0x94, 0x0, 0x0, 0x0,
    0xd, 0x26, 0xec, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x29, 0xdf, 0xeb,
    0x50, 0x0, 0x0, 0x5f, 0xfb, 0x89, 0xef, 0xa0,
    0x0, 0x3f, 0xd2, 0x0, 0x0, 0x8f, 0x90, 0xb,
    0xf2, 0x0, 0x0, 0x0, 0xaf, 0x21, 0xf9, 0x0,
    0x0, 0x0, 0x2, 0xf7, 0x3f, 0x60, 0x0, 0x0,
    0x0, 0xf, 0x93, 0xf6, 0x0, 0x0, 0x0, 0x0,
    0xf9, 0x1f, 0x90, 0x0, 0x0, 0x0, 0x2f, 0x70,
    0xbf, 0x20, 0x0, 0x0, 0xa, 0xf2, 0x3, 0xfd,
    0x20, 0x0, 0x8, 0xf9, 0x0, 0x5, 0xff, 0xa8,
    0x9d, 0xfa, 0x0, 0x0, 0x2, 0x9d, 0xfe, 0xb5,
    0x0, 0x0,

    /* U+00D6 "Ö" */
    0x0, 0x0, 0x6d, 0x6, 0xc0, 0x0, 0x0, 0x0,
    0x3, 0x80, 0x48, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x29, 0xdf, 0xeb,
    0x50, 0x0, 0x0, 0x5f, 0xfb, 0x89, 0xef, 0xa0,
    0x0, 0x3f, 0xd2, 0x0, 0x0, 0x8f, 0x90, 0xb,
    0xf2, 0x0, 0x0, 0x0, 0xaf, 0x21, 0xf9, 0x0,
    0x0, 0x0, 0x2, 0xf7, 0x3f, 0x60, 0x0, 0x0,
    0x0, 0xf, 0x93, 0xf6, 0x0, 0x0, 0x0, 0x0,
    0xf9, 0x1f, 0x90, 0x0, 0x0, 0x0, 0x2f, 0x70,
    0xbf, 0x20, 0x0, 0x0, 0xa, 0xf2, 0x3, 0xfd,
    0x20, 0x0, 0x8, 0xf9, 0x0, 0x5, 0xff, 0xa8,
    0x9d, 0xfa, 0x0, 0x0, 0x2, 0x9d, 0xfe, 0xb5,
    0x0, 0x0,

    /* U+00D7 "×" */
    0x0, 0x0, 0x0, 0x1, 0xc2, 0x0, 0xb4, 0xb,
    0xe2, 0xbe, 0x20, 0xc, 0xfe, 0x20, 0x0, 0x9f,
    0xd1, 0x0, 0x8f, 0x5d, 0xc0, 0x1e, 0x50, 0x1e,
    0x50, 0x10, 0x0, 0x10,

    /* U+00D8 "Ø" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x7c, 0x0, 0x0,
    0x29, 0xdf, 0xeb, 0x7e, 0x20, 0x0, 0x5f, 0xfb,
    0x89, 0xef, 0xf0, 0x0, 0x3f, 0xd2, 0x0, 0x8,
    0xff, 0x90, 0xb, 0xf2, 0x0, 0x3, 0xe1, 0xaf,
    0x21, 0xf9, 0x0, 0x0, 0xd5, 0x2, 0xf7, 0x3f,
    0x60, 0x0, 0x9a, 0x0, 0xf, 0x93, 0xf6, 0x0,
    0x4e, 0x10, 0x0, 0xf9, 0x1f, 0x90, 0xe, 0x40,
    0x0, 0x2f, 0x70, 0xbf, 0x2a, 0x90, 0x0, 0xa,
    0xf2, 0x3, 0xff, 0xf0, 0x0, 0x8, 0xf9, 0x0,
    0x6, 0xff, 0xa8, 0x9d, 0xfa, 0x0, 0x0, 0xba,
    0x9d, 0xfe, 0xb5, 0x0, 0x0, 0x6d, 0x0, 0x0,
    0x0, 0x0, 0x0,

    /* U+00D9 "Ù" */
    0x0, 0x2c, 0xc1, 0x0, 0x0, 0x0, 0x0, 0x9,
    0xd1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x7, 0xf2, 0x0, 0x0, 0x8, 0xf1, 0x7f, 0x20,
    0x0, 0x0, 0x8f, 0x17, 0xf2, 0x0, 0x0, 0x8,
    0xf1, 0x7f, 0x20, 0x0, 0x0, 0x8f, 0x17, 0xf2,
    0x0, 0x0, 0x8, 0xf1, 0x7f, 0x20, 0x0, 0x0,
    0x8f, 0x16, 0xf2, 0x0, 0x0, 0x8, 0xf0, 0x6f,
    0x30, 0x0, 0x0, 0x9f, 0x3, 0xf6, 0x0, 0x0,
    0xc, 0xd0, 0xe, 0xe1, 0x0, 0x5, 0xf8, 0x0,
    0x4f, 0xfa, 0x8b, 0xfd, 0x0, 0x0, 0x3b, 0xef,
    0xd8, 0x10, 0x0,

    /* U+00DA "Ú" */
    0x0, 0x0, 0x3f, 0x50, 0x0, 0x0, 0x0, 0x8,
    0xd0, 0x0, 0x0, 0x0, 0x0, 0x21, 0x0, 0x0,
    0x7, 0xf2, 0x0, 0x0, 0x8, 0xf1, 0x7f, 0x20,
    0x0, 0x0, 0x8f, 0x17, 0xf2, 0x0, 0x0, 0x8,
    0xf1, 0x7f, 0x20, 0x0, 0x0, 0x8f, 0x17, 0xf2,
    0x0, 0x0, 0x8, 0xf1, 0x7f, 0x20, 0x0, 0x0,
    0x8f, 0x16, 0xf2, 0x0, 0x0, 0x8, 0xf0, 0x6f,
    0x30, 0x0, 0x0, 0x9f, 0x3, 0xf6, 0x0, 0x0,
    0xc, 0xd0, 0xe, 0xe1, 0x0, 0x5, 0xf8, 0x0,
    0x4f, 0xfa, 0x8b, 0xfd, 0x0, 0x0, 0x3b, 0xef,
    0xd8, 0x10, 0x0,

    /* U+00DB "Û" */
    0x0, 0x1, 0xdf, 0x90, 0x0, 0x0, 0x2, 0xd7,
    0x1b, 0xa0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x7, 0xf2, 0x0, 0x0, 0x8, 0xf1, 0x7f, 0x20,
    0x0, 0x0, 0x8f, 0x17, 0xf2, 0x0, 0x0, 0x8,
    0xf1, 0x7f, 0x20, 0x0, 0x0, 0x8f, 0x17, 0xf2,
    0x0, 0x0, 0x8, 0xf1, 0x7f, 0x20, 0x0, 0x0,
    0x8f, 0x16, 0xf2, 0x0, 0x0, 0x8, 0xf0, 0x6f,
    0x30, 0x0, 0x0, 0x9f, 0x3, 0xf6, 0x0, 0x0,
    0xc, 0xd0, 0xe, 0xe1, 0x0, 0x5, 0xf8, 0x0,
    0x4f, 0xfa, 0x8b, 0xfd, 0x0, 0x0, 0x3b, 0xef,
    0xd8, 0x10, 0x0,

    /* U+00DC "Ü" */
    0x0, 0xc, 0x70, 0xc6, 0x0, 0x0, 0x0, 0x84,
    0x8, 0x40, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x7, 0xf2, 0x0, 0x0, 0x8, 0xf1, 0x7f, 0x20,
    0x0, 0x0, 0x8f, 0x17, 0xf2, 0x0, 0x0, 0x8,
    0xf1, 0x7f, 0x20, 0x0, 0x0, 0x8f, 0x17, 0xf2,
    0x0, 0x0, 0x8, 0xf1, 0x7f, 0x20, 0x0, 0x0,
    0x8f, 0x16, 0xf2, 0x0, 0x0, 0x8, 0xf0, 0x6f,
    0x30, 0x0, 0x0, 0x9f, 0x3, 0xf6, 0x0, 0x0,
    0xc, 0xd0, 0xe, 0xe1, 0x0, 0x5, 0xf8, 0x0,
    0x4f, 0xfa, 0x8b, 0xfd, 0x0, 0x0, 0x3b, 0xef,
    0xd8, 0x10, 0x0,

    /* U+00DD "Ý" */
    0x0, 0x0, 0x6, 0xf3, 0x0, 0x0, 0x0, 0x0,
    0xb, 0xb0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x10,
    0x0, 0x0, 0xc, 0xd0, 0x0, 0x0, 0x7, 0xf2,
    0x3, 0xf7, 0x0, 0x0, 0x1f, 0x80, 0x0, 0xaf,
    0x10, 0x0, 0x9e, 0x0, 0x0, 0x1f, 0x90, 0x3,
    0xf6, 0x0, 0x0, 0x8, 0xf3, 0xb, 0xd0, 0x0,
    0x0, 0x0, 0xec, 0x5f, 0x40, 0x0, 0x0, 0x0,
    0x6f, 0xfb, 0x0, 0x0, 0x0, 0x0, 0xc, 0xf2,
    0x0, 0x0, 0x0, 0x0, 0xa, 0xf0, 0x0, 0x0,
    0x0, 0x0, 0xa, 0xf0, 0x0, 0x0, 0x0, 0x0,
    0xa, 0xf0, 0x0, 0x0, 0x0, 0x0, 0xa, 0xf0,
    0x0, 0x0,

    /* U+00DE "Þ" */
    0x5f, 0x40, 0x0, 0x0, 0x0, 0x5f, 0x62, 0x21,
    0x0, 0x0, 0x5f, 0xff, 0xff, 0xf9, 0x10, 0x5f,
    0x85, 0x56, 0x9f, 0xd0, 0x5f, 0x40, 0x0, 0x5,
    0xf6, 0x5f, 0x40, 0x0, 0x0, 0xfa, 0x5f, 0x40,
    0x0, 0x0, 0xfa, 0x5f, 0x40, 0x0, 0x3, 0xf7,
    0x5f, 0x52, 0x23, 0x6e, 0xe1, 0x5f, 0xff, 0xff,
    0xfc, 0x20, 0x5f, 0x85, 0x54, 0x20, 0x0, 0x5f,
    0x40, 0x0, 0x0, 0x0,

    /* U+00DF "ß" */
    0x0, 0x8e, 0xfe, 0x80, 0x0, 0xb, 0xf9, 0x79,
    0xfb, 0x0, 0x4f, 0x60, 0x0, 0x7f, 0x10, 0x7f,
    0x0, 0x0, 0x6f, 0x10, 0x8f, 0x0, 0x15, 0xe9,
    0x0, 0x8f, 0x0, 0xef, 0xf6, 0x0, 0x8f, 0x0,
    0x35, 0xaf, 0x80, 0x8f, 0x0, 0x0, 0xa, 0xf0,
    0x8f, 0x0, 0x0, 0x7, 0xf1, 0x8f, 0x0, 0x0,
    0xb, 0xf0, 0x8f, 0x3, 0x77, 0xcf, 0x80, 0x8f,
    0x6, 0xff, 0xd6, 0x0,

    /* U+00E0 "à" */
    0x0, 0x9f, 0x40, 0x0, 0x0, 0x0, 0x4, 0xd5,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x2b, 0xef, 0xb2, 0xf9, 0x3, 0xfe, 0x87, 0xce,
    0xf9, 0xc, 0xe1, 0x0, 0x9, 0xf9, 0x1f, 0x70,
    0x0, 0x1, 0xf9, 0x3f, 0x50, 0x0, 0x0, 0xf9,
    0x1f, 0x80, 0x0, 0x1, 0xf9, 0xc, 0xe1, 0x0,
    0x9, 0xf9, 0x3, 0xfe, 0x87, 0xce, 0xf9, 0x0,
    0x2b, 0xef, 0xb2, 0xe9,

    /* U+00E1 "á" */
    0x0, 0x0, 0xeb, 0x0, 0x0, 0x0, 0x3, 0xf2,
    0x0, 0x0, 0x0, 0x1, 0x20, 0x0, 0x0, 0x0,
    0x2b, 0xef, 0xb2, 0xf9, 0x3, 0xfe, 0x87, 0xce,
    0xf9, 0xc, 0xe1, 0x0, 0x9, 0xf9, 0x1f, 0x70,
    0x0, 0x1, 0xf9, 0x3f, 0x50, 0x0, 0x0, 0xf9,
    0x1f, 0x80, 0x0, 0x1, 0xf9, 0xc, 0xe1, 0x0,
    0x9, 0xf9, 0x3, 0xfe, 0x87, 0xce, 0xf9, 0x0,
    0x2b, 0xef, 0xb2, 0xe9,

    /* U+00E2 "â" */
    0x0, 0xa, 0xfd, 0x10, 0x0, 0x0, 0xaa, 0x7,
    0xc1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x2b, 0xef, 0xb2, 0xf9, 0x3, 0xfe, 0x87, 0xce,
    0xf9, 0xc, 0xe1, 0x0, 0x9, 0xf9, 0x1f, 0x70,
    0x0, 0x1, 0xf9, 0x3f, 0x50, 0x0, 0x0, 0xf9,
    0x1f, 0x80, 0x0, 0x1, 0xf9, 0xc, 0xe1, 0x0,
    0x9, 0xf9, 0x3, 0xfe, 0x87, 0xce, 0xf9, 0x0,
    0x2b, 0xef, 0xb2, 0xe9,

    /* U+00E3 "ã" */
    0x0, 0x7f, 0xa1, 0xb3, 0x0, 0x0, 0xe1, 0x7e,
    0xb0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x2b, 0xef, 0xb2, 0xf9, 0x3, 0xfe, 0x87, 0xce,
    0xf9, 0xc, 0xe1, 0x0, 0x9, 0xf9, 0x1f, 0x70,
    0x0, 0x1, 0xf9, 0x3f, 0x50, 0x0, 0x0, 0xf9,
    0x1f, 0x80, 0x0, 0x1, 0xf9, 0xc, 0xe1, 0x0,
    0x9, 0xf9, 0x3, 0xfe, 0x87, 0xce, 0xf9, 0x0,
    0x2b, 0xef, 0xb2, 0xe9,

    /* U+00E4 "ä" */
    0x0, 0x7b, 0x7, 0xb0, 0x0, 0x0, 0x47, 0x4,
    0x70, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x2b, 0xef, 0xb2, 0xf9, 0x3, 0xfe, 0x87, 0xce,
    0xf9, 0xc, 0xe1, 0x0, 0x9, 0xf9, 0x1f, 0x70,
    0x0, 0x1, 0xf9, 0x3f, 0x50, 0x0, 0x0, 0xf9,
    0x1f, 0x80, 0x0, 0x1, 0xf9, 0xc, 0xe1, 0x0,
    0x9, 0xf9, 0x3, 0xfe, 0x87, 0xce, 0xf9, 0x0,
    0x2b, 0xef, 0xb2, 0xe9,

    /* U+00E5 "å" */
    0x0, 0x5, 0xb8, 0x0, 0x0, 0x0, 0xb, 0x7,
    0x40, 0x0, 0x0, 0xb, 0x7, 0x40, 0x0, 0x0,
    0x5, 0xa8, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x2b, 0xef, 0xb2, 0xf9, 0x3, 0xfe,
    0x87, 0xce, 0xf9, 0xc, 0xe1, 0x0, 0x9, 0xf9,
    0x1f, 0x70, 0x0, 0x1, 0xf9, 0x3f, 0x50, 0x0,
    0x0, 0xf9, 0x1f, 0x80, 0x0, 0x1, 0xf9, 0xc,
    0xe1, 0x0, 0x9, 0xf9, 0x3, 0xfe, 0x87, 0xce,
    0xf9, 0x0, 0x2b, 0xef, 0xb2, 0xe9,

    /* U+00E6 "æ" */
    0x1, 0x9e, 0xfe, 0x80, 0x3b, 0xff, 0xa2, 0x0,
    0xc, 0xe8, 0x7a, 0xfb, 0xfd, 0x78, 0xee, 0x20,
    0x2, 0x0, 0x0, 0xaf, 0xc0, 0x0, 0x1e, 0xb0,
    0x0, 0x0, 0x0, 0x6f, 0x50, 0x0, 0x8, 0xf0,
    0x3, 0xbe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf2,
    0xe, 0xc4, 0x22, 0x7f, 0x72, 0x22, 0x22, 0x20,
    0x2f, 0x60, 0x0, 0xaf, 0xc0, 0x0, 0x2, 0x0,
    0xe, 0xe8, 0x7b, 0xf9, 0xfd, 0x87, 0xaf, 0x50,
    0x2, 0xbe, 0xfc, 0x40, 0x3b, 0xff, 0xd6, 0x0,

    /* U+00E7 "ç" */
    0x0, 0x3b, 0xef, 0xc4, 0x0, 0x4f, 0xd8, 0x7c,
    0xf4, 0xe, 0xd0, 0x0, 0x7, 0x13, 0xf5, 0x0,
    0x0, 0x0, 0x5f, 0x30, 0x0, 0x0, 0x3, 0xf5,
    0x0, 0x0, 0x0, 0xe, 0xd0, 0x0, 0x7, 0x10,
    0x4f, 0xd8, 0x7c, 0xf4, 0x0, 0x3b, 0xff, 0xc4,
    0x0, 0x0, 0xe, 0x50, 0x0, 0x0, 0x0, 0x2d,
    0x40, 0x0, 0x0, 0xce, 0xc1, 0x0,

    /* U+00E8 "è" */
    0x0, 0x6f, 0x70, 0x0, 0x0, 0x0, 0x2, 0xc8,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x3b, 0xfe, 0xa2, 0x0, 0x4, 0xfc, 0x67, 0xde,
    0x10, 0xe, 0xc0, 0x0, 0x1e, 0xa0, 0x3f, 0x50,
    0x0, 0x8, 0xf0, 0x5f, 0xff, 0xff, 0xff, 0xf1,
    0x3f, 0x72, 0x22, 0x22, 0x20, 0xe, 0xc0, 0x0,
    0x2, 0x0, 0x4, 0xfd, 0x87, 0xaf, 0x50, 0x0,
    0x3a, 0xef, 0xd6, 0x0,

    /* U+00E9 "é" */
    0x0, 0x0, 0xae, 0x0, 0x0, 0x0, 0x0, 0xf6,
    0x0, 0x0, 0x0, 0x0, 0x30, 0x0, 0x0, 0x0,
    0x3b, 0xfe, 0xa2, 0x0, 0x4, 0xfc, 0x67, 0xde,
    0x10, 0xe, 0xc0, 0x0, 0x1e, 0xa0, 0x3f, 0x50,
    0x0, 0x8, 0xf0, 0x5f, 0xff, 0xff, 0xff, 0xf1,
    0x3f, 0x72, 0x22, 0x22, 0x20, 0xe, 0xc0, 0x0,
    0x2, 0x0, 0x4, 0xfd, 0x87, 0xaf, 0x50, 0x0,
    0x3a, 0xef, 0xd6, 0x0,

    /* U+00EA "ê" */
    0x0, 0x6, 0xfe, 0x30, 0x0, 0x0, 0x6c, 0x24,
    0xd4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x3b, 0xfe, 0xa2, 0x0, 0x4, 0xfc, 0x67, 0xde,
    0x10, 0xe, 0xc0, 0x0, 0x1e, 0xa0, 0x3f, 0x50,
    0x0, 0x8, 0xf0, 0x5f, 0xff, 0xff, 0xff, 0xf1,
    0x3f, 0x72, 0x22, 0x22, 0x20, 0xe, 0xc0, 0x0,
    0x2, 0x0, 0x4, 0xfd, 0x87, 0xaf, 0x50, 0x0,
    0x3a, 0xef, 0xd6, 0x0,

    /* U+00EB "ë" */
    0x0, 0x3e, 0x14, 0xe1, 0x0, 0x0, 0x29, 0x2,
    0x90, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x3b, 0xfe, 0xa2, 0x0, 0x4, 0xfc, 0x67, 0xde,
    0x10, 0xe, 0xc0, 0x0, 0x1e, 0xa0, 0x3f, 0x50,
    0x0, 0x8, 0xf0, 0x5f, 0xff, 0xff, 0xff, 0xf1,
    0x3f, 0x72, 0x22, 0x22, 0x20, 0xe, 0xc0, 0x0,
    0x2, 0x0, 0x4, 0xfd, 0x87, 0xaf, 0x50, 0x0,
    0x3a, 0xef, 0xd6, 0x0,

    /* U+00EC "ì" */
    0x2d, 0xb1, 0x0, 0x8, 0xb1, 0x0, 0x0, 0x0,
    0x9, 0xf0, 0x0, 0x9f, 0x0, 0x9, 0xf0, 0x0,
    0x9f, 0x0, 0x9, 0xf0, 0x0, 0x9f, 0x0, 0x9,
    0xf0, 0x0, 0x9f, 0x0, 0x9, 0xf0,

    /* U+00ED "í" */
    0x5f, 0x4a, 0xb0, 0x21, 0x9, 0xf0, 0x9f, 0x9,
    0xf0, 0x9f, 0x9, 0xf0, 0x9f, 0x9, 0xf0, 0x9f,
    0x9, 0xf0,

    /* U+00EE "î" */
    0x1, 0xdf, 0x60, 0xb, 0x72, 0xd3, 0x0, 0x0,
    0x0, 0x0, 0x9f, 0x0, 0x0, 0x9f, 0x0, 0x0,
    0x9f, 0x0, 0x0, 0x9f, 0x0, 0x0, 0x9f, 0x0,
    0x0, 0x9f, 0x0, 0x0, 0x9f, 0x0, 0x0, 0x9f,
    0x0, 0x0, 0x9f, 0x0,

    /* U+00EF "ï" */
    0x8a, 0x4d, 0x4, 0x62, 0x80, 0x0, 0x0, 0x0,
    0x9f, 0x0, 0x9, 0xf0, 0x0, 0x9f, 0x0, 0x9,
    0xf0, 0x0, 0x9f, 0x0, 0x9, 0xf0, 0x0, 0x9f,
    0x0, 0x9, 0xf0, 0x0, 0x9f, 0x0,

    /* U+00F0 "ð" */
    0x5, 0xdf, 0xfc, 0x74, 0x70, 0x4, 0x86, 0x7e,
    0xff, 0xa0, 0x0, 0x18, 0xee, 0x8f, 0xa0, 0x0,
    0xcc, 0x50, 0x8, 0xf1, 0x0, 0x0, 0x0, 0x2,
    0xf6, 0x0, 0x8e, 0xff, 0xa2, 0xf7, 0xa, 0xf9,
    0x55, 0xbd, 0xf8, 0x2f, 0x80, 0x0, 0xb, 0xf7,
    0x4f, 0x40, 0x0, 0x7, 0xf3, 0x2f, 0x80, 0x0,
    0xc, 0xd0, 0x9, 0xfa, 0x67, 0xdf, 0x30, 0x0,
    0x7d, 0xfe, 0xa2, 0x0,

    /* U+00F1 "ñ" */
    0x0, 0xae, 0x81, 0xd1, 0x0, 0x2c, 0x19, 0xe8,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x9, 0xe2, 0xbf,
    0xfa, 0x10, 0x9f, 0xeb, 0x79, 0xfd, 0x9, 0xf8,
    0x0, 0x6, 0xf4, 0x9f, 0x10, 0x0, 0x1f, 0x79,
    0xf0, 0x0, 0x0, 0xf8, 0x9f, 0x0, 0x0, 0xf,
    0x89, 0xf0, 0x0, 0x0, 0xf8, 0x9f, 0x0, 0x0,
    0xf, 0x89, 0xf0, 0x0, 0x0, 0xf8,

    /* U+00F2 "ò" */
    0x0, 0x4e, 0x90, 0x0, 0x0, 0x0, 0x1, 0xba,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x3b, 0xef, 0xc4, 0x0, 0x4, 0xfd, 0x87, 0xcf,
    0x60, 0xe, 0xd0, 0x0, 0xb, 0xf1, 0x3f, 0x50,
    0x0, 0x3, 0xf5, 0x5f, 0x30, 0x0, 0x1, 0xf7,
    0x3f, 0x50, 0x0, 0x3, 0xf5, 0xe, 0xd0, 0x0,
    0xb, 0xf1, 0x4, 0xfd, 0x87, 0xcf, 0x60, 0x0,
    0x3b, 0xef, 0xc4, 0x0,

    /* U+00F3 "ó" */
    0x0, 0x0, 0x8f, 0x20, 0x0, 0x0, 0x0, 0xc9,
    0x0, 0x0, 0x0, 0x0, 0x20, 0x0, 0x0, 0x0,
    0x3b, 0xef, 0xc4, 0x0, 0x4, 0xfd, 0x87, 0xcf,
    0x60, 0xe, 0xd0, 0x0, 0xb, 0xf1, 0x3f, 0x50,
    0x0, 0x3, 0xf5, 0x5f, 0x30, 0x0, 0x1, 0xf7,
    0x3f, 0x50, 0x0, 0x3, 0xf5, 0xe, 0xd0, 0x0,
    0xb, 0xf1, 0x4, 0xfd, 0x87, 0xcf, 0x60, 0x0,
    0x3b, 0xef, 0xc4, 0x0,

    /* U+00F4 "ô" */
    0x0, 0x4, 0xff, 0x50, 0x0, 0x0, 0x4d, 0x32,
    0xd6, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x3b, 0xef, 0xc4, 0x0, 0x4, 0xfd, 0x87, 0xcf,
    0x60, 0xe, 0xd0, 0x0, 0xb, 0xf1, 0x3f, 0x50,
    0x0, 0x3, 0xf5, 0x5f, 0x30, 0x0, 0x1, 0xf7,
    0x3f, 0x50, 0x0, 0x3, 0xf5, 0xe, 0xd0, 0x0,
    0xb, 0xf1, 0x4, 0xfd, 0x87, 0xcf, 0x60, 0x0,
    0x3b, 0xef, 0xc4, 0x0,

    /* U+00F5 "õ" */
    0x0, 0x2e, 0xd4, 0x5a, 0x0, 0x0, 0x87, 0x3c,
    0xe3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x3b, 0xef, 0xc4, 0x0, 0x4, 0xfd, 0x87, 0xcf,
    0x60, 0xe, 0xd0, 0x0, 0xb, 0xf1, 0x3f, 0x50,
    0x0, 0x3, 0xf5, 0x5f, 0x30, 0x0, 0x1, 0xf7,
    0x3f, 0x50, 0x0, 0x3, 0xf5, 0xe, 0xd0, 0x0,
    0xb, 0xf1, 0x4, 0xfd, 0x87, 0xcf, 0x60, 0x0,
    0x3b, 0xef, 0xc4, 0x0,

    /* U+00F6 "ö" */
    0x0, 0x1e, 0x31, 0xe3, 0x0, 0x0, 0x9, 0x10,
    0x91, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x3b, 0xef, 0xc4, 0x0, 0x4, 0xfd, 0x87, 0xcf,
    0x60, 0xe, 0xd0, 0x0, 0xb, 0xf1, 0x3f, 0x50,
    0x0, 0x3, 0xf5, 0x5f, 0x30, 0x0, 0x1, 0xf7,
    0x3f, 0x50, 0x0, 0x3, 0xf5, 0xe, 0xd0, 0x0,
    0xb, 0xf1, 0x4, 0xfd, 0x87, 0xcf, 0x60, 0x0,
    0x3b, 0xef, 0xc4, 0x0,

    /* U+00F7 "÷" */
    0x0, 0x1e, 0x60, 0x0, 0x0, 0x1e, 0x60, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1, 0x11, 0x11, 0x10,
    0xef, 0xff, 0xff, 0xf3, 0x34, 0x44, 0x44, 0x40,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1e, 0x60, 0x0,
    0x0, 0x1e, 0x60, 0x0,

    /* U+00F8 "ø" */
    0x0, 0x0, 0x0, 0x3, 0xb0, 0x0, 0x3b, 0xef,
    0xcf, 0x20, 0x4, 0xfd, 0x87, 0xff, 0x60, 0xe,
    0xd0, 0x2, 0xcb, 0xf1, 0x3f, 0x50, 0xc, 0x23,
    0xf5, 0x5f, 0x30, 0x68, 0x1, 0xf7, 0x3f, 0x51,
    0xc0, 0x3, 0xf5, 0xe, 0xdc, 0x30, 0xb, 0xf1,
    0x4, 0xff, 0x87, 0xcf, 0x60, 0x1, 0xfc, 0xef,
    0xc4, 0x0, 0xa, 0x50, 0x0, 0x0, 0x0,

    /* U+00F9 "ù" */
    0x1, 0xbd, 0x20, 0x0, 0x0, 0x0, 0x7c, 0x20,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xa, 0xe0, 0x0,
    0x3, 0xf5, 0xae, 0x0, 0x0, 0x3f, 0x5a, 0xe0,
    0x0, 0x3, 0xf5, 0xae, 0x0, 0x0, 0x3f, 0x5a,
    0xe0, 0x0, 0x3, 0xf5, 0x9f, 0x0, 0x0, 0x4f,
    0x57, 0xf4, 0x0, 0xb, 0xf5, 0x1e, 0xf9, 0x7c,
    0xef, 0x50, 0x3b, 0xff, 0xa3, 0xf5,

    /* U+00FA "ú" */
    0x0, 0x3, 0xf6, 0x0, 0x0, 0x0, 0x8d, 0x0,
    0x0, 0x0, 0x2, 0x10, 0x0, 0xa, 0xe0, 0x0,
    0x3, 0xf5, 0xae, 0x0, 0x0, 0x3f, 0x5a, 0xe0,
    0x0, 0x3, 0xf5, 0xae, 0x0, 0x0, 0x3f, 0x5a,
    0xe0, 0x0, 0x3, 0xf5, 0x9f, 0x0, 0x0, 0x4f,
    0x57, 0xf4, 0x0, 0xb, 0xf5, 0x1e, 0xf9, 0x7c,
    0xef, 0x50, 0x3b, 0xff, 0xa3, 0xf5,

    /* U+00FB "û" */
    0x0, 0x1d, 0xea, 0x0, 0x0, 0x1c, 0x60, 0xa9,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xa, 0xe0, 0x0,
    0x3, 0xf5, 0xae, 0x0, 0x0, 0x3f, 0x5a, 0xe0,
    0x0, 0x3, 0xf5, 0xae, 0x0, 0x0, 0x3f, 0x5a,
    0xe0, 0x0, 0x3, 0xf5, 0x9f, 0x0, 0x0, 0x4f,
    0x57, 0xf4, 0x0, 0xb, 0xf5, 0x1e, 0xf9, 0x7c,
    0xef, 0x50, 0x3b, 0xff, 0xa3, 0xf5,

    /* U+00FC "ü" */
    0x0, 0xb7, 0xc, 0x70, 0x0, 0x7, 0x40, 0x74,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xa, 0xe0, 0x0,
    0x3, 0xf5, 0xae, 0x0, 0x0, 0x3f, 0x5a, 0xe0,
    0x0, 0x3, 0xf5, 0xae, 0x0, 0x0, 0x3f, 0x5a,
    0xe0, 0x0, 0x3, 0xf5, 0x9f, 0x0, 0x0, 0x4f,
    0x57, 0xf4, 0x0, 0xb, 0xf5, 0x1e, 0xf9, 0x7c,
    0xef, 0x50, 0x3b, 0xff, 0xa3, 0xf5,

    /* U+00FD "ý" */
    0x0, 0x0, 0x5f, 0x40, 0x0, 0x0, 0x0, 0x9c,
    0x0, 0x0, 0x0, 0x0, 0x21, 0x0, 0x0, 0xd,
    0xc0, 0x0, 0x0, 0xcb, 0x6, 0xf2, 0x0, 0x3,
    0xf4, 0x0, 0xe9, 0x0, 0x9, 0xd0, 0x0, 0x8f,
    0x10, 0x1f, 0x60, 0x0, 0x1f, 0x70, 0x7f, 0x0,
    0x0, 0xa, 0xd0, 0xe9, 0x0, 0x0, 0x3, 0xfa,
    0xf2, 0x0, 0x0, 0x0, 0xcf, 0xb0, 0x0, 0x0,
    0x0, 0x6f, 0x40, 0x0, 0x0, 0x0, 0xbd, 0x0,
    0x0, 0x1c, 0x79, 0xf5, 0x0, 0x0, 0x1a, 0xee,
    0x70, 0x0, 0x0,

    /* U+00FE "þ" */
    0x8f, 0x0, 0x0, 0x0, 0x0, 0x8f, 0x0, 0x0,
    0x0, 0x0, 0x8f, 0x0, 0x0, 0x0, 0x0, 0x8f,
    0x2b, 0xfe, 0xb3, 0x0, 0x8f, 0xec, 0x78, 0xef,
    0x30, 0x8f, 0xa0, 0x0, 0x1e, 0xc0, 0x8f, 0x10,
    0x0, 0x7, 0xf1, 0x8f, 0x0, 0x0, 0x5, 0xf3,
    0x8f, 0x20, 0x0, 0x7, 0xf1, 0x8f, 0x90, 0x0,
    0x1e, 0xc0, 0x8f, 0xec, 0x78, 0xef, 0x30, 0x8f,
    0x2a, 0xfe, 0xb3, 0x0, 0x8f, 0x0, 0x0, 0x0,
    0x0, 0x8f, 0x0, 0x0, 0x0, 0x0, 0x8f, 0x0,
    0x0, 0x0, 0x0,

    /* U+00FF "ÿ" */
    0x0, 0xd, 0x50, 0xd5, 0x0, 0x0, 0x8, 0x30,
    0x93, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xd,
    0xc0, 0x0, 0x0, 0xcb, 0x6, 0xf2, 0x0, 0x3,
    0xf4, 0x0, 0xe9, 0x0, 0x9, 0xd0, 0x0, 0x8f,
    0x10, 0x1f, 0x60, 0x0, 0x1f, 0x70, 0x7f, 0x0,
    0x0, 0xa, 0xd0, 0xe9, 0x0, 0x0, 0x3, 0xfa,
    0xf2, 0x0, 0x0, 0x0, 0xcf, 0xb0, 0x0, 0x0,
    0x0, 0x6f, 0x40, 0x0, 0x0, 0x0, 0xbd, 0x0,
    0x0, 0x1c, 0x79, 0xf5, 0x0, 0x0, 0x1a, 0xee,
    0x70, 0x0, 0x0,

    /* U+0100 "Ā" */
    0x0, 0x0, 0xbe, 0xee, 0xe6, 0x0, 0x0, 0x0,
    0x1, 0x11, 0x11, 0x0, 0x0, 0x0, 0x0, 0x2,
    0xfd, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9f, 0xf4,
    0x0, 0x0, 0x0, 0x0, 0xf, 0x9e, 0xa0, 0x0,
    0x0, 0x0, 0x7, 0xf2, 0x8f, 0x10, 0x0, 0x0,
    0x0, 0xdc, 0x1, 0xf8, 0x0, 0x0, 0x0, 0x4f,
    0x50, 0xb, 0xe0, 0x0, 0x0, 0xb, 0xe0, 0x0,
    0x5f, 0x60, 0x0, 0x2, 0xf9, 0x11, 0x11, 0xec,
    0x0, 0x0, 0x8f, 0xff, 0xff, 0xff, 0xf3, 0x0,
    0xe, 0xc4, 0x44, 0x44, 0x4f, 0xa0, 0x6, 0xf4,
    0x0, 0x0, 0x0, 0xaf, 0x10, 0xdd, 0x0, 0x0,
    0x0, 0x3, 0xf8,

    /* U+0101 "ā" */
    0x0, 0xff, 0xff, 0xf4, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x2b, 0xef, 0xb2, 0xf9, 0x3, 0xfe, 0x87, 0xce,
    0xf9, 0xc, 0xe1, 0x0, 0x9, 0xf9, 0x1f, 0x70,
    0x0, 0x1, 0xf9, 0x3f, 0x50, 0x0, 0x0, 0xf9,
    0x1f, 0x80, 0x0, 0x1, 0xf9, 0xc, 0xe1, 0x0,
    0x9, 0xf9, 0x3, 0xfe, 0x87, 0xce, 0xf9, 0x0,
    0x2b, 0xef, 0xb2, 0xe9,

    /* U+0102 "Ă" */
    0x0, 0x0, 0x99, 0x1, 0xd4, 0x0, 0x0, 0x0,
    0x1, 0xae, 0xe7, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2f, 0xd0,
    0x0, 0x0, 0x0, 0x0, 0x9, 0xff, 0x40, 0x0,
    0x0, 0x0, 0x0, 0xf9, 0xea, 0x0, 0x0, 0x0,
    0x0, 0x7f, 0x28, 0xf1, 0x0, 0x0, 0x0, 0xd,
    0xc0, 0x1f, 0x80, 0x0, 0x0, 0x4, 0xf5, 0x0,
    0xbe, 0x0, 0x0, 0x0, 0xbe, 0x0, 0x5, 0xf6,
    0x0, 0x0, 0x2f, 0x91, 0x11, 0x1e, 0xc0, 0x0,
    0x8, 0xff, 0xff, 0xff, 0xff, 0x30, 0x0, 0xec,
    0x44, 0x44, 0x44, 0xfa, 0x0, 0x6f, 0x40, 0x0,
    0x0, 0xa, 0xf1, 0xd, 0xd0, 0x0, 0x0, 0x0,
    0x3f, 0x80,

    /* U+0103 "ă" */
    0x0, 0xd6, 0x2, 0xe1, 0x0, 0x0, 0x2b, 0xed,
    0x50, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x2b, 0xef, 0xb2, 0xf9, 0x3, 0xfe, 0x87, 0xce,
    0xf9, 0xc, 0xe1, 0x0, 0x9, 0xf9, 0x1f, 0x70,
    0x0, 0x1, 0xf9, 0x3f, 0x50, 0x0, 0x0, 0xf9,
    0x1f, 0x80, 0x0, 0x1, 0xf9, 0xc, 0xe1, 0x0,
    0x9, 0xf9, 0x3, 0xfe, 0x87, 0xce, 0xf9, 0x0,
    0x2b, 0xef, 0xb2, 0xe9,

    /* U+0104 "Ą" */
    0x0, 0x0, 0x2, 0xfd, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x9, 0xef, 0x40, 0x0, 0x0, 0x0, 0x0,
    0xf, 0x6c, 0xa0, 0x0, 0x0, 0x0, 0x0, 0x7e,
    0x5, 0xf1, 0x0, 0x0, 0x0, 0x0, 0xd8, 0x0,
    0xd8, 0x0, 0x0, 0x0, 0x4, 0xf1, 0x0, 0x6e,
    0x0, 0x0, 0x0, 0xb, 0xa1, 0x11, 0x1f, 0x60,
    0x0, 0x0, 0x2f, 0xff, 0xff, 0xff, 0xc0, 0x0,
    0x0, 0x8c, 0x44, 0x44, 0x45, 0xf3, 0x0, 0x0,
    0xe6, 0x0, 0x0, 0x0, 0xca, 0x0, 0x6, 0xf1,
    0x0, 0x0, 0x0, 0x7f, 0x10, 0xd, 0xc0, 0x0,
    0x0, 0x0, 0x2f, 0xb0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xc9, 0x10, 0x0, 0x0, 0x0, 0x0, 0x3,
    0xe0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xbf,
    0xc0,

    /* U+0105 "ą" */
    0x0, 0x2b, 0xef, 0xb2, 0xf9, 0x3, 0xfe, 0x87,
    0xce, 0xf9, 0xc, 0xe1, 0x0, 0x9, 0xf9, 0x1f,
    0x70, 0x0, 0x1, 0xf9, 0x3f, 0x50, 0x0, 0x0,
    0xf9, 0x1f, 0x80, 0x0, 0x1, 0xf9, 0xc, 0xe1,
    0x0, 0x9, 0xf9, 0x3, 0xfe, 0x87, 0xce, 0xf9,
    0x0, 0x2b, 0xef, 0xea, 0xe9, 0x0, 0x0, 0x5,
    0xc2, 0x0, 0x0, 0x0, 0xc, 0x60, 0x0, 0x0,
    0x0, 0x5, 0xee, 0x40,

    /* U+0106 "Ć" */
    0x0, 0x0, 0x0, 0xf9, 0x0, 0x0, 0x0, 0x0,
    0x4f, 0x10, 0x0, 0x0, 0x0, 0x1, 0x20, 0x0,
    0x0, 0x0, 0x29, 0xdf, 0xeb, 0x40, 0x0, 0x5f,
    0xfb, 0x89, 0xef, 0x80, 0x3f, 0xd2, 0x0, 0x0,
    0x84, 0xb, 0xf2, 0x0, 0x0, 0x0, 0x1, 0xf9,
    0x0, 0x0, 0x0, 0x0, 0x3f, 0x60, 0x0, 0x0,
    0x0, 0x3, 0xf6, 0x0, 0x0, 0x0, 0x0, 0x1f,
    0x90, 0x0, 0x0, 0x0, 0x0, 0xbf, 0x20, 0x0,
    0x0, 0x0, 0x3, 0xfd, 0x20, 0x0, 0x8, 0x50,
    0x5, 0xff, 0xa8, 0x9e, 0xf8, 0x0, 0x2, 0x9e,
    0xfe, 0xb4, 0x0,

    /* U+0107 "ć" */
    0x0, 0x0, 0xbd, 0x0, 0x0, 0x0, 0xf, 0x50,
    0x0, 0x0, 0x0, 0x20, 0x0, 0x0, 0x3, 0xbe,
    0xfc, 0x40, 0x4, 0xfd, 0x87, 0xcf, 0x40, 0xed,
    0x0, 0x0, 0x71, 0x3f, 0x50, 0x0, 0x0, 0x5,
    0xf3, 0x0, 0x0, 0x0, 0x3f, 0x50, 0x0, 0x0,
    0x0, 0xed, 0x0, 0x0, 0x71, 0x4, 0xfd, 0x87,
    0xcf, 0x40, 0x3, 0xbe, 0xfc, 0x40,

    /* U+0108 "Ĉ" */
    0x0, 0x0, 0xa, 0xfc, 0x0, 0x0, 0x0, 0xb,
    0xa0, 0x9c, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x29, 0xdf, 0xeb, 0x40, 0x0, 0x5f,
    0xfb, 0x89, 0xef, 0x80, 0x3f, 0xd2, 0x0, 0x0,
    0x84, 0xb, 0xf2, 0x0, 0x0, 0x0, 0x1, 0xf9,
    0x0, 0x0, 0x0, 0x0, 0x3f, 0x60, 0x0, 0x0,
    0x0, 0x3, 0xf6, 0x0, 0x0, 0x0, 0x0, 0x1f,
    0x90, 0x0, 0x0, 0x0, 0x0, 0xbf, 0x20, 0x0,
    0x0, 0x0, 0x3, 0xfd, 0x20, 0x0, 0x8, 0x50,
    0x5, 0xff, 0xa8, 0x9e, 0xf8, 0x0, 0x2, 0x9e,
    0xfe, 0xb4, 0x0,

    /* U+0109 "ĉ" */
    0x0, 0x7, 0xfe, 0x30, 0x0, 0x7, 0xc2, 0x5d,
    0x30, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0xbe,
    0xfc, 0x40, 0x4, 0xfd, 0x87, 0xcf, 0x40, 0xed,
    0x0, 0x0, 0x71, 0x3f, 0x50, 0x0, 0x0, 0x5,
    0xf3, 0x0, 0x0, 0x0, 0x3f, 0x50, 0x0, 0x0,
    0x0, 0xed, 0x0, 0x0, 0x71, 0x4, 0xfd, 0x87,
    0xcf, 0x40, 0x3, 0xbe, 0xfc, 0x40,

    /* U+010A "Ċ" */
    0x0, 0x0, 0x3, 0xf4, 0x0, 0x0, 0x0, 0x0,
    0x3e, 0x40, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x29, 0xdf, 0xeb, 0x40, 0x0, 0x5f,
    0xfb, 0x89, 0xef, 0x80, 0x3f, 0xd2, 0x0, 0x0,
    0x84, 0xb, 0xf2, 0x0, 0x0, 0x0, 0x1, 0xf9,
    0x0, 0x0, 0x0, 0x0, 0x3f, 0x60, 0x0, 0x0,
    0x0, 0x3, 0xf6, 0x0, 0x0, 0x0, 0x0, 0x1f,
    0x90, 0x0, 0x0, 0x0, 0x0, 0xbf, 0x20, 0x0,
    0x0, 0x0, 0x3, 0xfd, 0x20, 0x0, 0x8, 0x50,
    0x5, 0xff, 0xa8, 0x9e, 0xf8, 0x0, 0x2, 0x9e,
    0xfe, 0xb4, 0x0,

    /* U+010B "ċ" */
    0x0, 0x0, 0xd8, 0x0, 0x0, 0x0, 0xd, 0x80,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0xbe,
    0xfc, 0x40, 0x4, 0xfd, 0x87, 0xcf, 0x40, 0xed,
    0x0, 0x0, 0x71, 0x3f, 0x50, 0x0, 0x0, 0x5,
    0xf3, 0x0, 0x0, 0x0, 0x3f, 0x50, 0x0, 0x0,
    0x0, 0xed, 0x0, 0x0, 0x71, 0x4, 0xfd, 0x87,
    0xcf, 0x40, 0x3, 0xbe, 0xfc, 0x40,

    /* U+010C "Č" */
    0x0, 0x0, 0xba, 0x19, 0xc1, 0x0, 0x0, 0x0,
    0xaf, 0xc0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x29, 0xdf, 0xeb, 0x40, 0x0, 0x5f,
    0xfb, 0x89, 0xef, 0x80, 0x3f, 0xd2, 0x0, 0x0,
    0x84, 0xb, 0xf2, 0x0, 0x0, 0x0, 0x1, 0xf9,
    0x0, 0x0, 0x0, 0x0, 0x3f, 0x60, 0x0, 0x0,
    0x0, 0x3, 0xf6, 0x0, 0x0, 0x0, 0x0, 0x1f,
    0x90, 0x0, 0x0, 0x0, 0x0, 0xbf, 0x20, 0x0,
    0x0, 0x0, 0x3, 0xfd, 0x20, 0x0, 0x8, 0x50,
    0x5, 0xff, 0xa8, 0x9e, 0xf8, 0x0, 0x2, 0x9e,
    0xfe, 0xb4, 0x0,

    /* U+010D "č" */
    0x0, 0x7d, 0x26, 0xe3, 0x0, 0x0, 0x6e, 0xd2,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0xbe,
    0xfc, 0x40, 0x4, 0xfd, 0x87, 0xcf, 0x40, 0xed,
    0x0, 0x0, 0x71, 0x3f, 0x50, 0x0, 0x0, 0x5,
    0xf3, 0x0, 0x0, 0x0, 0x3f, 0x50, 0x0, 0x0,
    0x0, 0xed, 0x0, 0x0, 0x71, 0x4, 0xfd, 0x87,
    0xcf, 0x40, 0x3, 0xbe, 0xfc, 0x40,

    /* U+010E "Ď" */
    0x0, 0x6e, 0x21, 0xd7, 0x0, 0x0, 0x0, 0x8,
    0xed, 0xa0, 0x0, 0x0, 0x0, 0x0, 0x77, 0x0,
    0x0, 0x0, 0x5f, 0xff, 0xff, 0xda, 0x30, 0x0,
    0x5f, 0x97, 0x77, 0x9e, 0xf8, 0x0, 0x5f, 0x40,
    0x0, 0x0, 0xaf, 0x60, 0x5f, 0x40, 0x0, 0x0,
    0xd, 0xe0, 0x5f, 0x40, 0x0, 0x0, 0x6, 0xf4,
    0x5f, 0x40, 0x0, 0x0, 0x3, 0xf6, 0x5f, 0x40,
    0x0, 0x0, 0x3, 0xf6, 0x5f, 0x40, 0x0, 0x0,
    0x6, 0xf3, 0x5f, 0x40, 0x0, 0x0, 0xd, 0xe0,
    0x5f, 0x40, 0x0, 0x0, 0xaf, 0x60, 0x5f, 0x97,
    0x77, 0x9e, 0xf7, 0x0, 0x5f, 0xff, 0xff, 0xea,
    0x30, 0x0,

    /* U+010F "ď" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x2f, 0x10, 0x0,
    0x0, 0x0, 0x1f, 0x72, 0xf0, 0x0, 0x0, 0x0,
    0x1, 0xf7, 0x2f, 0x0, 0x0, 0x0, 0x0, 0x1f,
    0x70, 0x30, 0x0, 0x3b, 0xfe, 0xa2, 0xf7, 0x0,
    0x0, 0x4f, 0xd8, 0x7c, 0xef, 0x70, 0x0, 0xe,
    0xd0, 0x0, 0xb, 0xf7, 0x0, 0x3, 0xf5, 0x0,
    0x0, 0x3f, 0x70, 0x0, 0x5f, 0x30, 0x0, 0x1,
    0xf7, 0x0, 0x3, 0xf5, 0x0, 0x0, 0x3f, 0x70,
    0x0, 0xe, 0xd0, 0x0, 0xb, 0xf7, 0x0, 0x0,
    0x4f, 0xd8, 0x7c, 0xdf, 0x70, 0x0, 0x0, 0x3b,
    0xfe, 0xa1, 0xf7, 0x0, 0x0,

    /* U+0110 "Đ" */
    0x3, 0xff, 0xff, 0xfe, 0xb4, 0x0, 0x0, 0x3f,
    0xa7, 0x77, 0x9e, 0xfa, 0x0, 0x3, 0xf6, 0x0,
    0x0, 0x8, 0xf8, 0x0, 0x3f, 0x60, 0x0, 0x0,
    0xb, 0xf1, 0x4, 0xf7, 0x11, 0x0, 0x0, 0x4f,
    0x6d, 0xff, 0xff, 0xf8, 0x0, 0x1, 0xf8, 0x37,
    0xfa, 0x44, 0x20, 0x0, 0x1f, 0x80, 0x3f, 0x60,
    0x0, 0x0, 0x4, 0xf5, 0x3, 0xf6, 0x0, 0x0,
    0x0, 0xbf, 0x10, 0x3f, 0x60, 0x0, 0x0, 0x9f,
    0x80, 0x3, 0xfa, 0x77, 0x79, 0xef, 0x90, 0x0,
    0x3f, 0xff, 0xff, 0xea, 0x40, 0x0,

    /* U+0111 "đ" */
    0x0, 0x0, 0x0, 0x1, 0xf7, 0x0, 0x0, 0x6,
    0xff, 0xff, 0xfd, 0x0, 0x0, 0x12, 0x24, 0xf9,
    0x20, 0x3, 0xbf, 0xea, 0x2f, 0x70, 0x4, 0xfd,
    0x87, 0xce, 0xf7, 0x0, 0xed, 0x0, 0x0, 0xbf,
    0x70, 0x3f, 0x50, 0x0, 0x3, 0xf7, 0x5, 0xf3,
    0x0, 0x0, 0x1f, 0x70, 0x3f, 0x50, 0x0, 0x3,
    0xf7, 0x0, 0xed, 0x0, 0x0, 0xbf, 0x70, 0x4,
    0xfd, 0x87, 0xcd, 0xf7, 0x0, 0x3, 0xbf, 0xea,
    0x1f, 0x70,

    /* U+0112 "Ē" */
    0x0, 0xee, 0xee, 0xe3, 0x0, 0x1, 0x11, 0x11,
    0x0, 0x5f, 0xff, 0xff, 0xff, 0x95, 0xf9, 0x77,
    0x77, 0x74, 0x5f, 0x40, 0x0, 0x0, 0x5, 0xf4,
    0x0, 0x0, 0x0, 0x5f, 0x51, 0x11, 0x11, 0x5,
    0xff, 0xff, 0xff, 0xe0, 0x5f, 0x74, 0x44, 0x44,
    0x5, 0xf4, 0x0, 0x0, 0x0, 0x5f, 0x40, 0x0,
    0x0, 0x5, 0xf4, 0x0, 0x0, 0x0, 0x5f, 0x97,
    0x77, 0x77, 0x55, 0xff, 0xff, 0xff, 0xfc,

    /* U+0113 "ē" */
    0x0, 0xbf, 0xff, 0xf8, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x3b, 0xfe, 0xa2, 0x0, 0x4, 0xfc, 0x67, 0xde,
    0x10, 0xe, 0xc0, 0x0, 0x1e, 0xa0, 0x3f, 0x50,
    0x0, 0x8, 0xf0, 0x5f, 0xff, 0xff, 0xff, 0xf1,
    0x3f, 0x72, 0x22, 0x22, 0x20, 0xe, 0xc0, 0x0,
    0x2, 0x0, 0x4, 0xfd, 0x87, 0xaf, 0x50, 0x0,
    0x3a, 0xef, 0xd6, 0x0,

    /* U+0114 "Ĕ" */
    0x0, 0xd6, 0x2, 0xe1, 0x0, 0x2, 0xce, 0xd5,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x5, 0xff, 0xff,
    0xff, 0xf9, 0x5f, 0x97, 0x77, 0x77, 0x45, 0xf4,
    0x0, 0x0, 0x0, 0x5f, 0x40, 0x0, 0x0, 0x5,
    0xf5, 0x11, 0x11, 0x10, 0x5f, 0xff, 0xff, 0xfe,
    0x5, 0xf7, 0x44, 0x44, 0x40, 0x5f, 0x40, 0x0,
    0x0, 0x5, 0xf4, 0x0, 0x0, 0x0, 0x5f, 0x40,
    0x0, 0x0, 0x5, 0xf9, 0x77, 0x77, 0x75, 0x5f,
    0xff, 0xff, 0xff, 0xc0,

    /* U+0115 "ĕ" */
    0x0, 0x89, 0x1, 0xc5, 0x0, 0x0, 0xa, 0xed,
    0x80, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x3b, 0xfe, 0xa2, 0x0, 0x4, 0xfc, 0x67, 0xde,
    0x10, 0xe, 0xc0, 0x0, 0x1e, 0xa0, 0x3f, 0x50,
    0x0, 0x8, 0xf0, 0x5f, 0xff, 0xff, 0xff, 0xf1,
    0x3f, 0x72, 0x22, 0x22, 0x20, 0xe, 0xc0, 0x0,
    0x2, 0x0, 0x4, 0xfd, 0x87, 0xaf, 0x50, 0x0,
    0x3a, 0xef, 0xd6, 0x0,

    /* U+0116 "Ė" */
    0x0, 0x2, 0xe6, 0x0, 0x0, 0x0, 0x2e, 0x50,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x5, 0xff, 0xff,
    0xff, 0xf9, 0x5f, 0x97, 0x77, 0x77, 0x45, 0xf4,
    0x0, 0x0, 0x0, 0x5f, 0x40, 0x0, 0x0, 0x5,
    0xf5, 0x11, 0x11, 0x10, 0x5f, 0xff, 0xff, 0xfe,
    0x5, 0xf7, 0x44, 0x44, 0x40, 0x5f, 0x40, 0x0,
    0x0, 0x5, 0xf4, 0x0, 0x0, 0x0, 0x5f, 0x40,
    0x0, 0x0, 0x5, 0xf9, 0x77, 0x77, 0x75, 0x5f,
    0xff, 0xff, 0xff, 0xc0,

    /* U+0117 "ė" */
    0x0, 0x0, 0xd9, 0x0, 0x0, 0x0, 0x0, 0xd9,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x3b, 0xfe, 0xa2, 0x0, 0x4, 0xfc, 0x67, 0xde,
    0x10, 0xe, 0xc0, 0x0, 0x1e, 0xa0, 0x3f, 0x50,
    0x0, 0x8, 0xf0, 0x5f, 0xff, 0xff, 0xff, 0xf1,
    0x3f, 0x72, 0x22, 0x22, 0x20, 0xe, 0xc0, 0x0,
    0x2, 0x0, 0x4, 0xfd, 0x87, 0xaf, 0x50, 0x0,
    0x3a, 0xef, 0xd6, 0x0,

    /* U+0118 "Ę" */
    0x5f, 0xff, 0xff, 0xff, 0x90, 0x5f, 0x97, 0x77,
    0x77, 0x40, 0x5f, 0x40, 0x0, 0x0, 0x0, 0x5f,
    0x40, 0x0, 0x0, 0x0, 0x5f, 0x51, 0x11, 0x11,
    0x0, 0x5f, 0xff, 0xff, 0xfe, 0x0, 0x5f, 0x74,
    0x44, 0x44, 0x0, 0x5f, 0x40, 0x0, 0x0, 0x0,
    0x5f, 0x40, 0x0, 0x0, 0x0, 0x5f, 0x40, 0x0,
    0x0, 0x0, 0x5f, 0x97, 0x77, 0x77, 0x50, 0x5f,
    0xff, 0xff, 0xff, 0xf0, 0x0, 0x0, 0x0, 0xaa,
    0x10, 0x0, 0x0, 0x2, 0xf0, 0x0, 0x0, 0x0,
    0x0, 0xaf, 0xd0,

    /* U+0119 "ę" */
    0x0, 0x3b, 0xff, 0xb3, 0x0, 0x4, 0xfa, 0x67,
    0xbf, 0x40, 0xe, 0x70, 0x0, 0xa, 0xd0, 0x3f,
    0xff, 0xff, 0xff, 0xf1, 0x4f, 0x62, 0x22, 0x22,
    0x20, 0x3f, 0x80, 0x0, 0x0, 0x0, 0xe, 0xf2,
    0x0, 0x6, 0x0, 0x4, 0xff, 0x97, 0xbf, 0x50,
    0x0, 0x3a, 0xef, 0xf6, 0x0, 0x0, 0x0, 0x8,
    0x70, 0x0, 0x0, 0x0, 0xe, 0x40, 0x0, 0x0,
    0x0, 0x7, 0xee, 0x30,

    /* U+011A "Ě" */
    0x0, 0xca, 0x6, 0xe2, 0x0, 0x1, 0xdc, 0xf3,
    0x0, 0x0, 0x2, 0x84, 0x0, 0x5, 0xff, 0xff,
    0xff, 0xf9, 0x5f, 0x97, 0x77, 0x77, 0x45, 0xf4,
    0x0, 0x0, 0x0, 0x5f, 0x40, 0x0, 0x0, 0x5,
    0xf5, 0x11, 0x11, 0x10, 0x5f, 0xff, 0xff, 0xfe,
    0x5, 0xf7, 0x44, 0x44, 0x40, 0x5f, 0x40, 0x0,
    0x0, 0x5, 0xf4, 0x0, 0x0, 0x0, 0x5f, 0x40,
    0x0, 0x0, 0x5, 0xf9, 0x77, 0x77, 0x75, 0x5f,
    0xff, 0xff, 0xff, 0xc0,

    /* U+011B "ě" */
    0x0, 0x6d, 0x35, 0xe4, 0x0, 0x0, 0x5, 0xed,
    0x30, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x3b, 0xfe, 0xa2, 0x0, 0x4, 0xfc, 0x67, 0xde,
    0x10, 0xe, 0xc0, 0x0, 0x1e, 0xa0, 0x3f, 0x50,
    0x0, 0x8, 0xf0, 0x5f, 0xff, 0xff, 0xff, 0xf1,
    0x3f, 0x72, 0x22, 0x22, 0x20, 0xe, 0xc0, 0x0,
    0x2, 0x0, 0x4, 0xfd, 0x87, 0xaf, 0x50, 0x0,
    0x3a, 0xef, 0xd6, 0x0,

    /* U+011C "Ĝ" */
    0x0, 0x0, 0xb, 0xfc, 0x0, 0x0, 0x0, 0x0,
    0xba, 0x9, 0xc1, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x2, 0x9d, 0xfe, 0xb5, 0x0,
    0x0, 0x5f, 0xfb, 0x89, 0xdf, 0xb0, 0x3, 0xfd,
    0x20, 0x0, 0x6, 0x60, 0xb, 0xf1, 0x0, 0x0,
    0x0, 0x0, 0x1f, 0x90, 0x0, 0x0, 0x0, 0x0,
    0x3f, 0x60, 0x0, 0x0, 0x0, 0x0, 0x3f, 0x60,
    0x0, 0x0, 0x9, 0xf0, 0x1f, 0x90, 0x0, 0x0,
    0x9, 0xf0, 0xb, 0xf1, 0x0, 0x0, 0x9, 0xf0,
    0x3, 0xfd, 0x20, 0x0, 0xa, 0xf0, 0x0, 0x5f,
    0xfb, 0x89, 0xdf, 0xc0, 0x0, 0x2, 0x9d, 0xff,
    0xc6, 0x0,

    /* U+011D "ĝ" */
    0x0, 0x2, 0xef, 0x80, 0x0, 0x0, 0x2d, 0x61,
    0xb8, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x3b, 0xfe, 0xb2, 0xe8, 0x4, 0xfd, 0x87, 0xcf,
    0xf8, 0xe, 0xd0, 0x0, 0xa, 0xf8, 0x3f, 0x50,
    0x0, 0x1, 0xf8, 0x5f, 0x30, 0x0, 0x0, 0xf8,
    0x3f, 0x50, 0x0, 0x1, 0xf8, 0xe, 0xd0, 0x0,
    0x9, 0xf8, 0x4, 0xfd, 0x77, 0xce, 0xf8, 0x0,
    0x3b, 0xff, 0xb2, 0xf7, 0x0, 0x0, 0x0, 0x5,
    0xf3, 0xa, 0xe9, 0x77, 0xaf, 0xb0, 0x1, 0x7c,
    0xff, 0xd8, 0x0,

    /* U+011E "Ğ" */
    0x0, 0x0, 0xe4, 0x3, 0xf0, 0x0, 0x0, 0x0,
    0x3c, 0xec, 0x40, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x2, 0x9d, 0xfe, 0xb5, 0x0,
    0x0, 0x5f, 0xfb, 0x89, 0xdf, 0xb0, 0x3, 0xfd,
    0x20, 0x0, 0x6, 0x60, 0xb, 0xf1, 0x0, 0x0,
    0x0, 0x0, 0x1f, 0x90, 0x0, 0x0, 0x0, 0x0,
    0x3f, 0x60, 0x0, 0x0, 0x0, 0x0, 0x3f, 0x60,
    0x0, 0x0, 0x9, 0xf0, 0x1f, 0x90, 0x0, 0x0,
    0x9, 0xf0, 0xb, 0xf1, 0x0, 0x0, 0x9, 0xf0,
    0x3, 0xfd, 0x20, 0x0, 0xa, 0xf0, 0x0, 0x5f,
    0xfb, 0x89, 0xdf, 0xc0, 0x0, 0x2, 0x9d, 0xff,
    0xc6, 0x0,

    /* U+011F "ğ" */
    0x0, 0x3e, 0x10, 0x7b, 0x0, 0x0, 0x6, 0xde,
    0xb1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x3b, 0xfe, 0xb2, 0xe8, 0x4, 0xfd, 0x87, 0xcf,
    0xf8, 0xe, 0xd0, 0x0, 0xa, 0xf8, 0x3f, 0x50,
    0x0, 0x1, 0xf8, 0x5f, 0x30, 0x0, 0x0, 0xf8,
    0x3f, 0x50, 0x0, 0x1, 0xf8, 0xe, 0xd0, 0x0,
    0x9, 0xf8, 0x4, 0xfd, 0x77, 0xce, 0xf8, 0x0,
    0x3b, 0xff, 0xb2, 0xf7, 0x0, 0x0, 0x0, 0x5,
    0xf3, 0xa, 0xe9, 0x77, 0xaf, 0xb0, 0x1, 0x7c,
    0xff, 0xd8, 0x0,

    /* U+0120 "Ġ" */
    0x0, 0x0, 0x3, 0xf4, 0x0, 0x0, 0x0, 0x0,
    0x3, 0xe4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x2, 0x9d, 0xfe, 0xb5, 0x0,
    0x0, 0x5f, 0xfb, 0x89, 0xdf, 0xb0, 0x3, 0xfd,
    0x20, 0x0, 0x6, 0x60, 0xb, 0xf1, 0x0, 0x0,
    0x0, 0x0, 0x1f, 0x90, 0x0, 0x0, 0x0, 0x0,
    0x3f, 0x60, 0x0, 0x0, 0x0, 0x0, 0x3f, 0x60,
    0x0, 0x0, 0x9, 0xf0, 0x1f, 0x90, 0x0, 0x0,
    0x9, 0xf0, 0xb, 0xf1, 0x0, 0x0, 0x9, 0xf0,
    0x3, 0xfd, 0x20, 0x0, 0xa, 0xf0, 0x0, 0x5f,
    0xfb, 0x89, 0xdf, 0xc0, 0x0, 0x2, 0x9d, 0xff,
    0xc6, 0x0,

    /* U+0121 "ġ" */
    0x0, 0x0, 0x7e, 0x10, 0x0, 0x0, 0x0, 0x7e,
    0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x3b, 0xfe, 0xb2, 0xe8, 0x4, 0xfd, 0x87, 0xcf,
    0xf8, 0xe, 0xd0, 0x0, 0xa, 0xf8, 0x3f, 0x50,
    0x0, 0x1, 0xf8, 0x5f, 0x30, 0x0, 0x0, 0xf8,
    0x3f, 0x50, 0x0, 0x1, 0xf8, 0xe, 0xd0, 0x0,
    0x9, 0xf8, 0x4, 0xfd, 0x77, 0xce, 0xf8, 0x0,
    0x3b, 0xff, 0xb2, 0xf7, 0x0, 0x0, 0x0, 0x5,
    0xf3, 0xa, 0xe9, 0x77, 0xaf, 0xb0, 0x1, 0x7c,
    0xff, 0xd8, 0x0,

    /* U+0122 "Ģ" */
    0x0, 0x2, 0x9d, 0xfe, 0xb5, 0x0, 0x0, 0x5f,
    0xfb, 0x89, 0xdf, 0xb0, 0x3, 0xfd, 0x20, 0x0,
    0x6, 0x60, 0xb, 0xf1, 0x0, 0x0, 0x0, 0x0,
    0x1f, 0x90, 0x0, 0x0, 0x0, 0x0, 0x3f, 0x60,
    0x0, 0x0, 0x0, 0x0, 0x3f, 0x60, 0x0, 0x0,
    0x9, 0xf0, 0x1f, 0x90, 0x0, 0x0, 0x9, 0xf0,
    0xb, 0xf1, 0x0, 0x0, 0x9, 0xf0, 0x3, 0xfd,
    0x20, 0x0, 0xa, 0xf0, 0x0, 0x5f, 0xfb, 0x89,
    0xdf, 0xc0, 0x0, 0x2, 0x9d, 0xff, 0xc6, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x2, 0xb1, 0x0, 0x0, 0x0, 0x0, 0x1, 0xf2,
    0x0, 0x0, 0x0, 0x0, 0x1, 0xc0, 0x0, 0x0,

    /* U+0123 "ģ" */
    0x0, 0x0, 0xd, 0x0, 0x0, 0x0, 0x0, 0x6b,
    0x0, 0x0, 0x0, 0x0, 0x8f, 0x0, 0x0, 0x0,
    0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x3b, 0xfe, 0xb2, 0xe8, 0x4, 0xfd,
    0x87, 0xcf, 0xf8, 0xe, 0xd0, 0x0, 0xa, 0xf8,
    0x3f, 0x50, 0x0, 0x1, 0xf8, 0x5f, 0x30, 0x0,
    0x0, 0xf8, 0x3f, 0x50, 0x0, 0x1, 0xf8, 0xe,
    0xd0, 0x0, 0x9, 0xf8, 0x4, 0xfd, 0x77, 0xce,
    0xf8, 0x0, 0x3b, 0xff, 0xb2, 0xf7, 0x0, 0x0,
    0x0, 0x5, 0xf3, 0xa, 0xe9, 0x77, 0xaf, 0xb0,
    0x1, 0x7c, 0xff, 0xd8, 0x0,

    /* U+0124 "Ĥ" */
    0x0, 0x0, 0xaf, 0x90, 0x0, 0x0, 0x0, 0x8d,
    0x4e, 0x70, 0x0, 0x0, 0x17, 0x10, 0x27, 0x10,
    0x5, 0xf4, 0x0, 0x0, 0x4, 0xf4, 0x5f, 0x40,
    0x0, 0x0, 0x4f, 0x45, 0xf4, 0x0, 0x0, 0x4,
    0xf4, 0x5f, 0x40, 0x0, 0x0, 0x4f, 0x45, 0xf5,
    0x22, 0x22, 0x26, 0xf4, 0x5f, 0xff, 0xff, 0xff,
    0xff, 0x45, 0xf7, 0x55, 0x55, 0x58, 0xf4, 0x5f,
    0x40, 0x0, 0x0, 0x4f, 0x45, 0xf4, 0x0, 0x0,
    0x4, 0xf4, 0x5f, 0x40, 0x0, 0x0, 0x4f, 0x45,
    0xf4, 0x0, 0x0, 0x4, 0xf4, 0x5f, 0x40, 0x0,
    0x0, 0x4f, 0x40,

    /* U+0125 "ĥ" */
    0x0, 0x67, 0x10, 0x0, 0x0, 0x0, 0x9d, 0x9d,
    0x20, 0x0, 0x0, 0x37, 0x0, 0x56, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9f,
    0x0, 0x0, 0x0, 0x0, 0x9, 0xf0, 0x0, 0x0,
    0x0, 0x0, 0x9f, 0x0, 0x0, 0x0, 0x0, 0x9,
    0xf2, 0xbf, 0xfa, 0x10, 0x0, 0x9f, 0xfb, 0x79,
    0xfd, 0x0, 0x9, 0xf8, 0x0, 0x6, 0xf4, 0x0,
    0x9f, 0x10, 0x0, 0x1f, 0x70, 0x9, 0xf0, 0x0,
    0x0, 0xf8, 0x0, 0x9f, 0x0, 0x0, 0xf, 0x80,
    0x9, 0xf0, 0x0, 0x0, 0xf8, 0x0, 0x9f, 0x0,
    0x0, 0xf, 0x80, 0x9, 0xf0, 0x0, 0x0, 0xf8,

    /* U+0126 "Ħ" */
    0x3, 0xf6, 0x0, 0x0, 0x2, 0xf6, 0x0, 0x4,
    0xf7, 0x11, 0x11, 0x13, 0xf7, 0x10, 0xef, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf0, 0x37, 0xfa, 0x44,
    0x44, 0x46, 0xfa, 0x40, 0x3, 0xf7, 0x22, 0x22,
    0x24, 0xf6, 0x0, 0x3, 0xff, 0xff, 0xff, 0xff,
    0xf6, 0x0, 0x3, 0xf9, 0x55, 0x55, 0x56, 0xf6,
    0x0, 0x3, 0xf6, 0x0, 0x0, 0x2, 0xf6, 0x0,
    0x3, 0xf6, 0x0, 0x0, 0x2, 0xf6, 0x0, 0x3,
    0xf6, 0x0, 0x0, 0x2, 0xf6, 0x0, 0x3, 0xf6,
    0x0, 0x0, 0x2, 0xf6, 0x0, 0x3, 0xf6, 0x0,
    0x0, 0x2, 0xf6, 0x0,

    /* U+0127 "ħ" */
    0x0, 0x9f, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff,
    0xff, 0x40, 0x0, 0x2, 0xbf, 0x22, 0x20, 0x0,
    0x0, 0x9, 0xf2, 0xbf, 0xfa, 0x10, 0x0, 0x9f,
    0xfb, 0x79, 0xfd, 0x0, 0x9, 0xf8, 0x0, 0x6,
    0xf4, 0x0, 0x9f, 0x10, 0x0, 0x1f, 0x70, 0x9,
    0xf0, 0x0, 0x0, 0xf8, 0x0, 0x9f, 0x0, 0x0,
    0xf, 0x80, 0x9, 0xf0, 0x0, 0x0, 0xf8, 0x0,
    0x9f, 0x0, 0x0, 0xf, 0x80, 0x9, 0xf0, 0x0,
    0x0, 0xf8,

    /* U+0128 "Ĩ" */
    0x8, 0xd7, 0x1c, 0x12, 0xd1, 0x9f, 0x90, 0x0,
    0x0, 0x0, 0x0, 0x5, 0xf4, 0x0, 0x0, 0x5f,
    0x40, 0x0, 0x5, 0xf4, 0x0, 0x0, 0x5f, 0x40,
    0x0, 0x5, 0xf4, 0x0, 0x0, 0x5f, 0x40, 0x0,
    0x5, 0xf4, 0x0, 0x0, 0x5f, 0x40, 0x0, 0x5,
    0xf4, 0x0, 0x0, 0x5f, 0x40, 0x0, 0x5, 0xf4,
    0x0, 0x0, 0x5f, 0x40, 0x0,

    /* U+0129 "ĩ" */
    0x9, 0xe5, 0x77, 0xe, 0x2c, 0xe2, 0x0, 0x0,
    0x0, 0x0, 0x9f, 0x0, 0x0, 0x9f, 0x0, 0x0,
    0x9f, 0x0, 0x0, 0x9f, 0x0, 0x0, 0x9f, 0x0,
    0x0, 0x9f, 0x0, 0x0, 0x9f, 0x0, 0x0, 0x9f,
    0x0, 0x0, 0x9f, 0x0,

    /* U+012A "Ī" */
    0x9e, 0xee, 0x80, 0x11, 0x10, 0x5, 0xf4, 0x0,
    0x5f, 0x40, 0x5, 0xf4, 0x0, 0x5f, 0x40, 0x5,
    0xf4, 0x0, 0x5f, 0x40, 0x5, 0xf4, 0x0, 0x5f,
    0x40, 0x5, 0xf4, 0x0, 0x5f, 0x40, 0x5, 0xf4,
    0x0, 0x5f, 0x40,

    /* U+012B "ī" */
    0xef, 0xff, 0x50, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x9f, 0x0, 0x9, 0xf0, 0x0, 0x9f, 0x0, 0x9,
    0xf0, 0x0, 0x9f, 0x0, 0x9, 0xf0, 0x0, 0x9f,
    0x0, 0x9, 0xf0, 0x0, 0x9f, 0x0,

    /* U+012C "Ĭ" */
    0xf, 0x30, 0x4e, 0x0, 0x4c, 0xec, 0x30, 0x0,
    0x0, 0x0, 0x0, 0x5, 0xf4, 0x0, 0x0, 0x5f,
    0x40, 0x0, 0x5, 0xf4, 0x0, 0x0, 0x5f, 0x40,
    0x0, 0x5, 0xf4, 0x0, 0x0, 0x5f, 0x40, 0x0,
    0x5, 0xf4, 0x0, 0x0, 0x5f, 0x40, 0x0, 0x5,
    0xf4, 0x0, 0x0, 0x5f, 0x40, 0x0, 0x5, 0xf4,
    0x0, 0x0, 0x5f, 0x40, 0x0,

    /* U+012D "ĭ" */
    0xe3, 0xc, 0x44, 0xde, 0x90, 0x0, 0x0, 0x0,
    0x9f, 0x0, 0x9, 0xf0, 0x0, 0x9f, 0x0, 0x9,
    0xf0, 0x0, 0x9f, 0x0, 0x9, 0xf0, 0x0, 0x9f,
    0x0, 0x9, 0xf0, 0x0, 0x9f, 0x0,

    /* U+012E "Į" */
    0x5f, 0x45, 0xf4, 0x5f, 0x45, 0xf4, 0x5f, 0x45,
    0xf4, 0x5f, 0x45, 0xf4, 0x5f, 0x45, 0xf4, 0x5f,
    0x45, 0xf4, 0x5b, 0xb, 0x60, 0x6f, 0xa0,

    /* U+012F "į" */
    0x9, 0xe1, 0xa, 0xf1, 0x0, 0x0, 0x9, 0xf0,
    0x9, 0xf0, 0x9, 0xf0, 0x9, 0xf0, 0x9, 0xf0,
    0x9, 0xf0, 0x9, 0xf0, 0x9, 0xf0, 0x9, 0xf0,
    0xa, 0x70, 0xf, 0x20, 0xa, 0xf5,

    /* U+0130 "İ" */
    0x4f, 0x34, 0xe3, 0x0, 0x5, 0xf4, 0x5f, 0x45,
    0xf4, 0x5f, 0x45, 0xf4, 0x5f, 0x45, 0xf4, 0x5f,
    0x45, 0xf4, 0x5f, 0x45, 0xf4, 0x5f, 0x40,

    /* U+0131 "ı" */
    0x8f, 0x8f, 0x8f, 0x8f, 0x8f, 0x8f, 0x8f, 0x8f,
    0x8f,

    /* U+0132 "Ĳ" */
    0x6f, 0x30, 0x0, 0xa, 0xf6, 0xf3, 0x0, 0x0,
    0xaf, 0x6f, 0x30, 0x0, 0xa, 0xf6, 0xf3, 0x0,
    0x0, 0xaf, 0x6f, 0x30, 0x0, 0xa, 0xf6, 0xf3,
    0x0, 0x0, 0xaf, 0x39, 0x10, 0x0, 0xa, 0xe0,
    0x0, 0x0, 0x0, 0xcd, 0x0, 0x0, 0x0, 0xe,
    0xb1, 0x50, 0x0, 0x8, 0xf5, 0x6f, 0xd9, 0x8c,
    0xfb, 0x0, 0x5c, 0xff, 0xd7, 0x0,

    /* U+0133 "ĳ" */
    0x9e, 0x10, 0x1e, 0x8a, 0xf1, 0x2, 0xfa, 0x0,
    0x0, 0x0, 0x9, 0xf0, 0x0, 0xf8, 0x9f, 0x0,
    0xf, 0x89, 0xf0, 0x0, 0xf8, 0x9f, 0x0, 0xf,
    0x89, 0xf0, 0x0, 0xf8, 0x9f, 0x0, 0xf, 0x89,
    0xf0, 0x0, 0xf8, 0x9f, 0x0, 0xf, 0x89, 0xf0,
    0x0, 0xf8, 0x0, 0x0, 0x1f, 0x70, 0x6, 0x6a,
    0xf3, 0x0, 0xbf, 0xe6, 0x0,

    /* U+0134 "Ĵ" */
    0x0, 0x7, 0xfe, 0x20, 0x0, 0x8d, 0x25, 0xe3,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xf9,
    0x0, 0x77, 0x77, 0xf9, 0x0, 0x0, 0x0, 0xf9,
    0x0, 0x0, 0x0, 0xf9, 0x0, 0x0, 0x0, 0xf9,
    0x0, 0x0, 0x0, 0xf9, 0x0, 0x0, 0x0, 0xf9,
    0x0, 0x0, 0x0, 0xf9, 0x0, 0x0, 0x0, 0xf8,
    0x7, 0x20, 0x4, 0xf6, 0xe, 0xf9, 0x8e, 0xe1,
    0x1, 0xae, 0xeb, 0x20,

    /* U+0135 "ĵ" */
    0x0, 0x1d, 0xf7, 0x0, 0xa, 0x82, 0xc4, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x7f, 0x10, 0x0, 0x7,
    0xf1, 0x0, 0x0, 0x7f, 0x10, 0x0, 0x7, 0xf1,
    0x0, 0x0, 0x7f, 0x10, 0x0, 0x7, 0xf1, 0x0,
    0x0, 0x7f, 0x10, 0x0, 0x7, 0xf1, 0x0, 0x0,
    0x7f, 0x10, 0x0, 0x8, 0xf0, 0x1, 0x86, 0xec,
    0x0, 0x3e, 0xfb, 0x20, 0x0,

    /* U+0136 "Ķ" */
    0x5f, 0x40, 0x0, 0x2, 0xeb, 0x5, 0xf4, 0x0,
    0x1, 0xec, 0x0, 0x5f, 0x40, 0x1, 0xdd, 0x10,
    0x5, 0xf4, 0x0, 0xce, 0x20, 0x0, 0x5f, 0x40,
    0xbf, 0x30, 0x0, 0x5, 0xf4, 0xaf, 0x90, 0x0,
    0x0, 0x5f, 0xcf, 0xef, 0x30, 0x0, 0x5, 0xff,
    0x81, 0xee, 0x10, 0x0, 0x5f, 0xa0, 0x3, 0xfc,
    0x0, 0x5, 0xf4, 0x0, 0x6, 0xf8, 0x0, 0x5f,
    0x40, 0x0, 0x9, 0xf5, 0x5, 0xf4, 0x0, 0x0,
    0xc, 0xf2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xa9,
    0x0, 0x0, 0x0, 0x0, 0x7, 0xa0, 0x0, 0x0,
    0x0, 0x0, 0x73, 0x0, 0x0, 0x0,

    /* U+0137 "ķ" */
    0x9f, 0x0, 0x0, 0x0, 0x9, 0xf0, 0x0, 0x0,
    0x0, 0x9f, 0x0, 0x0, 0x0, 0x9, 0xf0, 0x0,
    0x1d, 0xd1, 0x9f, 0x0, 0x1d, 0xe2, 0x9, 0xf0,
    0x1d, 0xe2, 0x0, 0x9f, 0x2e, 0xf2, 0x0, 0x9,
    0xfe, 0xff, 0x70, 0x0, 0x9f, 0xe2, 0xbf, 0x30,
    0x9, 0xf2, 0x1, 0xee, 0x10, 0x9f, 0x0, 0x3,
    0xfb, 0x9, 0xf0, 0x0, 0x7, 0xf7, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xa, 0xa0, 0x0, 0x0, 0x0, 0x7a, 0x0, 0x0,
    0x0, 0x7, 0x30, 0x0, 0x0,

    /* U+0138 "ĸ" */
    0x8f, 0x0, 0x1, 0xde, 0x18, 0xf0, 0x1, 0xde,
    0x20, 0x8f, 0x1, 0xde, 0x20, 0x8, 0xf2, 0xdf,
    0x30, 0x0, 0x8f, 0xef, 0xf7, 0x0, 0x8, 0xfe,
    0x2b, 0xf3, 0x0, 0x8f, 0x20, 0x1e, 0xe1, 0x8,
    0xf0, 0x0, 0x3f, 0xb0, 0x8f, 0x0, 0x0, 0x7f,
    0x70,

    /* U+0139 "Ĺ" */
    0x1f, 0x80, 0x0, 0x0, 0x6, 0xe1, 0x0, 0x0,
    0x0, 0x12, 0x0, 0x0, 0x0, 0x5, 0xf4, 0x0,
    0x0, 0x0, 0x5f, 0x40, 0x0, 0x0, 0x5, 0xf4,
    0x0, 0x0, 0x0, 0x5f, 0x40, 0x0, 0x0, 0x5,
    0xf4, 0x0, 0x0, 0x0, 0x5f, 0x40, 0x0, 0x0,
    0x5, 0xf4, 0x0, 0x0, 0x0, 0x5f, 0x40, 0x0,
    0x0, 0x5, 0xf4, 0x0, 0x0, 0x0, 0x5f, 0x40,
    0x0, 0x0, 0x5, 0xf9, 0x77, 0x77, 0x72, 0x5f,
    0xff, 0xff, 0xff, 0x50,

    /* U+013A "ĺ" */
    0x5f, 0x4a, 0xb0, 0x21, 0x0, 0x0, 0x9f, 0x9,
    0xf0, 0x9f, 0x9, 0xf0, 0x9f, 0x9, 0xf0, 0x9f,
    0x9, 0xf0, 0x9f, 0x9, 0xf0, 0x9f, 0x9, 0xf0,

    /* U+013B "Ļ" */
    0x5f, 0x40, 0x0, 0x0, 0x5, 0xf4, 0x0, 0x0,
    0x0, 0x5f, 0x40, 0x0, 0x0, 0x5, 0xf4, 0x0,
    0x0, 0x0, 0x5f, 0x40, 0x0, 0x0, 0x5, 0xf4,
    0x0, 0x0, 0x0, 0x5f, 0x40, 0x0, 0x0, 0x5,
    0xf4, 0x0, 0x0, 0x0, 0x5f, 0x40, 0x0, 0x0,
    0x5, 0xf4, 0x0, 0x0, 0x0, 0x5f, 0x97, 0x77,
    0x77, 0x25, 0xff, 0xff, 0xff, 0xf5, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xe5, 0x0, 0x0, 0x0, 0xc, 0x50, 0x0,
    0x0, 0x0, 0xb0, 0x0, 0x0,

    /* U+013C "ļ" */
    0x9f, 0x9, 0xf0, 0x9f, 0x9, 0xf0, 0x9f, 0x9,
    0xf0, 0x9f, 0x9, 0xf0, 0x9f, 0x9, 0xf0, 0x9f,
    0x9, 0xf0, 0x0, 0x0, 0x0, 0x6d, 0x4, 0xd0,
    0x46, 0x0,

    /* U+013D "Ľ" */
    0x5f, 0x40, 0x0, 0xf3, 0x5, 0xf4, 0x0, 0xf,
    0x20, 0x5f, 0x40, 0x0, 0xf1, 0x5, 0xf4, 0x0,
    0x4, 0x0, 0x5f, 0x40, 0x0, 0x0, 0x5, 0xf4,
    0x0, 0x0, 0x0, 0x5f, 0x40, 0x0, 0x0, 0x5,
    0xf4, 0x0, 0x0, 0x0, 0x5f, 0x40, 0x0, 0x0,
    0x5, 0xf4, 0x0, 0x0, 0x0, 0x5f, 0x97, 0x77,
    0x77, 0x25, 0xff, 0xff, 0xff, 0xf5,

    /* U+013E "ľ" */
    0x0, 0x9, 0xa9, 0xf0, 0x99, 0x9f, 0x9, 0x89,
    0xf0, 0x21, 0x9f, 0x0, 0x9, 0xf0, 0x0, 0x9f,
    0x0, 0x9, 0xf0, 0x0, 0x9f, 0x0, 0x9, 0xf0,
    0x0, 0x9f, 0x0, 0x9, 0xf0, 0x0, 0x9f, 0x0,
    0x0,

    /* U+013F "Ŀ" */
    0x5f, 0x40, 0x0, 0x0, 0x5, 0xf4, 0x0, 0x0,
    0x0, 0x5f, 0x40, 0x0, 0x0, 0x5, 0xf4, 0x0,
    0x0, 0x0, 0x5f, 0x40, 0x8, 0xe0, 0x5, 0xf4,
    0x0, 0x9f, 0x10, 0x5f, 0x40, 0x0, 0x0, 0x5,
    0xf4, 0x0, 0x0, 0x0, 0x5f, 0x40, 0x0, 0x0,
    0x5, 0xf4, 0x0, 0x0, 0x0, 0x5f, 0x97, 0x77,
    0x77, 0x25, 0xff, 0xff, 0xff, 0xf5,

    /* U+0140 "ŀ" */
    0x9f, 0x0, 0x9, 0xf0, 0x0, 0x9f, 0x0, 0x9,
    0xf0, 0x0, 0x9f, 0x0, 0x9, 0xf0, 0xba, 0x9f,
    0xa, 0xa9, 0xf0, 0x0, 0x9f, 0x0, 0x9, 0xf0,
    0x0, 0x9f, 0x0, 0x9, 0xf0, 0x0,

    /* U+0141 "Ł" */
    0x3, 0xf6, 0x0, 0x0, 0x0, 0x3, 0xf6, 0x0,
    0x0, 0x0, 0x3, 0xf6, 0x1, 0x0, 0x0, 0x3,
    0xf7, 0xba, 0x0, 0x0, 0x3, 0xff, 0xc1, 0x0,
    0x0, 0x8, 0xff, 0x0, 0x0, 0x0, 0x7f, 0xf6,
    0x0, 0x0, 0x0, 0x56, 0xf6, 0x0, 0x0, 0x0,
    0x3, 0xf6, 0x0, 0x0, 0x0, 0x3, 0xf6, 0x0,
    0x0, 0x0, 0x3, 0xfa, 0x77, 0x77, 0x73, 0x3,
    0xff, 0xff, 0xff, 0xf7,

    /* U+0142 "ł" */
    0x0, 0x7f, 0x10, 0x0, 0x7f, 0x10, 0x0, 0x7f,
    0x10, 0x0, 0x7f, 0x10, 0x0, 0x7f, 0x86, 0x0,
    0x7f, 0xf4, 0x2, 0xff, 0x30, 0xe, 0xff, 0x10,
    0x1, 0x7f, 0x10, 0x0, 0x7f, 0x10, 0x0, 0x7f,
    0x10, 0x0, 0x7f, 0x10,

    /* U+0143 "Ń" */
    0x0, 0x0, 0x1f, 0x80, 0x0, 0x0, 0x0, 0x6,
    0xe1, 0x0, 0x0, 0x0, 0x0, 0x12, 0x0, 0x0,
    0x5, 0xf5, 0x0, 0x0, 0x4, 0xf4, 0x5f, 0xf2,
    0x0, 0x0, 0x4f, 0x45, 0xff, 0xd0, 0x0, 0x4,
    0xf4, 0x5f, 0xaf, 0x90, 0x0, 0x4f, 0x45, 0xf4,
    0xaf, 0x50, 0x4, 0xf4, 0x5f, 0x40, 0xdf, 0x20,
    0x4f, 0x45, 0xf4, 0x2, 0xfd, 0x4, 0xf4, 0x5f,
    0x40, 0x6, 0xf9, 0x4f, 0x45, 0xf4, 0x0, 0xa,
    0xfa, 0xf4, 0x5f, 0x40, 0x0, 0xd, 0xff, 0x45,
    0xf4, 0x0, 0x0, 0x2f, 0xf4, 0x5f, 0x40, 0x0,
    0x0, 0x6f, 0x40,

    /* U+0144 "ń" */
    0x0, 0x1, 0xf8, 0x0, 0x0, 0x0, 0x6e, 0x10,
    0x0, 0x0, 0x1, 0x20, 0x0, 0x9, 0xe2, 0xbf,
    0xfa, 0x10, 0x9f, 0xeb, 0x79, 0xfd, 0x9, 0xf8,
    0x0, 0x6, 0xf4, 0x9f, 0x10, 0x0, 0x1f, 0x79,
    0xf0, 0x0, 0x0, 0xf8, 0x9f, 0x0, 0x0, 0xf,
    0x89, 0xf0, 0x0, 0x0, 0xf8, 0x9f, 0x0, 0x0,
    0xf, 0x89, 0xf0, 0x0, 0x0, 0xf8,

    /* U+0145 "Ņ" */
    0x5f, 0x50, 0x0, 0x0, 0x4f, 0x45, 0xff, 0x20,
    0x0, 0x4, 0xf4, 0x5f, 0xfd, 0x0, 0x0, 0x4f,
    0x45, 0xfa, 0xf9, 0x0, 0x4, 0xf4, 0x5f, 0x4a,
    0xf5, 0x0, 0x4f, 0x45, 0xf4, 0xd, 0xf2, 0x4,
    0xf4, 0x5f, 0x40, 0x2f, 0xd0, 0x4f, 0x45, 0xf4,
    0x0, 0x6f, 0x94, 0xf4, 0x5f, 0x40, 0x0, 0xaf,
    0xaf, 0x45, 0xf4, 0x0, 0x0, 0xdf, 0xf4, 0x5f,
    0x40, 0x0, 0x2, 0xff, 0x45, 0xf4, 0x0, 0x0,
    0x6, 0xf4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3e,
    0x20, 0x0, 0x0, 0x0, 0x1, 0xf1, 0x0, 0x0,
    0x0, 0x0, 0x1a, 0x0, 0x0, 0x0,

    /* U+0146 "ņ" */
    0x9e, 0x2b, 0xff, 0xa1, 0x9, 0xfe, 0xb7, 0x9f,
    0xd0, 0x9f, 0x80, 0x0, 0x6f, 0x49, 0xf1, 0x0,
    0x1, 0xf7, 0x9f, 0x0, 0x0, 0xf, 0x89, 0xf0,
    0x0, 0x0, 0xf8, 0x9f, 0x0, 0x0, 0xf, 0x89,
    0xf0, 0x0, 0x0, 0xf8, 0x9f, 0x0, 0x0, 0xf,
    0x80, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x3e, 0x20, 0x0, 0x0, 0x1,
    0xe1, 0x0, 0x0, 0x0, 0x1a, 0x0, 0x0,

    /* U+0147 "Ň" */
    0x0, 0x1e, 0x70, 0x8d, 0x10, 0x0, 0x0, 0x2f,
    0xce, 0x20, 0x0, 0x0, 0x0, 0x38, 0x30, 0x0,
    0x5, 0xf5, 0x0, 0x0, 0x4, 0xf4, 0x5f, 0xf2,
    0x0, 0x0, 0x4f, 0x45, 0xff, 0xd0, 0x0, 0x4,
    0xf4, 0x5f, 0xaf, 0x90, 0x0, 0x4f, 0x45, 0xf4,
    0xaf, 0x50, 0x4, 0xf4, 0x5f, 0x40, 0xdf, 0x20,
    0x4f, 0x45, 0xf4, 0x2, 0xfd, 0x4, 0xf4, 0x5f,
    0x40, 0x6, 0xf9, 0x4f, 0x45, 0xf4, 0x0, 0xa,
    0xfa, 0xf4, 0x5f, 0x40, 0x0, 0xd, 0xff, 0x45,
    0xf4, 0x0, 0x0, 0x2f, 0xf4, 0x5f, 0x40, 0x0,
    0x0, 0x6f, 0x40,

    /* U+0148 "ň" */
    0x1, 0xc9, 0x1a, 0xb0, 0x0, 0x0, 0xbe, 0xa0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x9, 0xe2, 0xbf,
    0xfa, 0x10, 0x9f, 0xeb, 0x79, 0xfd, 0x9, 0xf8,
    0x0, 0x6, 0xf4, 0x9f, 0x10, 0x0, 0x1f, 0x79,
    0xf0, 0x0, 0x0, 0xf8, 0x9f, 0x0, 0x0, 0xf,
    0x89, 0xf0, 0x0, 0x0, 0xf8, 0x9f, 0x0, 0x0,
    0xf, 0x89, 0xf0, 0x0, 0x0, 0xf8,

    /* U+0149 "ŉ" */
    0xcd, 0x0, 0x0, 0x0, 0x0, 0xb, 0xf1, 0x0,
    0x0, 0x0, 0x0, 0x7d, 0x0, 0x0, 0x0, 0x0,
    0xa, 0x7d, 0xa5, 0xcf, 0xe8, 0x0, 0x92, 0xde,
    0xf9, 0x7b, 0xfa, 0x0, 0xd, 0xf4, 0x0, 0xa,
    0xf1, 0x0, 0xdd, 0x0, 0x0, 0x5f, 0x30, 0xd,
    0xb0, 0x0, 0x4, 0xf4, 0x0, 0xdb, 0x0, 0x0,
    0x4f, 0x40, 0xd, 0xb0, 0x0, 0x4, 0xf4, 0x0,
    0xdb, 0x0, 0x0, 0x4f, 0x40, 0xd, 0xb0, 0x0,
    0x4, 0xf4,

    /* U+014A "Ŋ" */
    0x5f, 0x50, 0x0, 0x0, 0x4f, 0x55, 0xff, 0x20,
    0x0, 0x4, 0xf5, 0x5f, 0xfd, 0x0, 0x0, 0x4f,
    0x55, 0xfa, 0xf9, 0x0, 0x4, 0xf5, 0x5f, 0x4a,
    0xf5, 0x0, 0x4f, 0x55, 0xf4, 0xd, 0xf2, 0x4,
    0xf5, 0x5f, 0x40, 0x2f, 0xd0, 0x4f, 0x55, 0xf4,
    0x0, 0x6f, 0x94, 0xf5, 0x5f, 0x40, 0x0, 0xaf,
    0xaf, 0x55, 0xf4, 0x0, 0x0, 0xdf, 0xf5, 0x5f,
    0x40, 0x0, 0x2, 0xff, 0x45, 0xf4, 0x0, 0x0,
    0x7, 0xf4, 0x0, 0x0, 0x10, 0x0, 0x7f, 0x20,
    0x0, 0xc, 0xc8, 0x9f, 0xb0, 0x0, 0x0, 0x3b,
    0xfe, 0x91, 0x0,

    /* U+014B "ŋ" */
    0x8e, 0x2b, 0xff, 0xb2, 0x8, 0xfe, 0xb7, 0x9f,
    0xe0, 0x8f, 0x80, 0x0, 0x6f, 0x58, 0xf1, 0x0,
    0x1, 0xf7, 0x8f, 0x0, 0x0, 0xf, 0x88, 0xf0,
    0x0, 0x0, 0xf8, 0x8f, 0x0, 0x0, 0xf, 0x88,
    0xf0, 0x0, 0x0, 0xf8, 0x8f, 0x0, 0x0, 0xf,
    0x80, 0x0, 0x0, 0x1, 0xf7, 0x0, 0x0, 0x66,
    0xaf, 0x30, 0x0, 0xb, 0xfe, 0x60,

    /* U+014C "Ō" */
    0x0, 0x0, 0xce, 0xee, 0xe4, 0x0, 0x0, 0x0,
    0x1, 0x11, 0x11, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x29, 0xdf, 0xeb,
    0x50, 0x0, 0x0, 0x5f, 0xfb, 0x89, 0xef, 0xa0,
    0x0, 0x3f, 0xd2, 0x0, 0x0, 0x8f, 0x90, 0xb,
    0xf2, 0x0, 0x0, 0x0, 0xaf, 0x21, 0xf9, 0x0,
    0x0, 0x0, 0x2, 0xf7, 0x3f, 0x60, 0x0, 0x0,
    0x0, 0xf, 0x93, 0xf6, 0x0, 0x0, 0x0, 0x0,
    0xf9, 0x1f, 0x90, 0x0, 0x0, 0x0, 0x2f, 0x70,
    0xbf, 0x20, 0x0, 0x0, 0xa, 0xf2, 0x3, 0xfd,
    0x20, 0x0, 0x8, 0xf9, 0x0, 0x5, 0xff, 0xa8,
    0x9d, 0xfa, 0x0, 0x0, 0x2, 0x9d, 0xfe, 0xb5,
    0x0, 0x0,

    /* U+014D "ō" */
    0x0, 0x8f, 0xff, 0xfa, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x3b, 0xef, 0xc4, 0x0, 0x4, 0xfd, 0x87, 0xcf,
    0x60, 0xe, 0xd0, 0x0, 0xb, 0xf1, 0x3f, 0x50,
    0x0, 0x3, 0xf5, 0x5f, 0x30, 0x0, 0x1, 0xf7,
    0x3f, 0x50, 0x0, 0x3, 0xf5, 0xe, 0xd0, 0x0,
    0xb, 0xf1, 0x4, 0xfd, 0x87, 0xcf, 0x60, 0x0,
    0x3b, 0xef, 0xc4, 0x0,

    /* U+014E "Ŏ" */
    0x0, 0x0, 0xb7, 0x2, 0xe2, 0x0, 0x0, 0x0,
    0x2, 0xbe, 0xd6, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x29, 0xdf, 0xeb,
    0x50, 0x0, 0x0, 0x5f, 0xfb, 0x89, 0xef, 0xa0,
    0x0, 0x3f, 0xd2, 0x0, 0x0, 0x8f, 0x90, 0xb,
    0xf2, 0x0, 0x0, 0x0, 0xaf, 0x21, 0xf9, 0x0,
    0x0, 0x0, 0x2, 0xf7, 0x3f, 0x60, 0x0, 0x0,
    0x0, 0xf, 0x93, 0xf6, 0x0, 0x0, 0x0, 0x0,
    0xf9, 0x1f, 0x90, 0x0, 0x0, 0x0, 0x2f, 0x70,
    0xbf, 0x20, 0x0, 0x0, 0xa, 0xf2, 0x3, 0xfd,
    0x20, 0x0, 0x8, 0xf9, 0x0, 0x5, 0xff, 0xa8,
    0x9d, 0xfa, 0x0, 0x0, 0x2, 0x9d, 0xfe, 0xb5,
    0x0, 0x0,

    /* U+014F "ŏ" */
    0x0, 0x6b, 0x0, 0xa8, 0x0, 0x0, 0x8, 0xde,
    0x90, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x3b, 0xef, 0xc4, 0x0, 0x4, 0xfd, 0x87, 0xcf,
    0x60, 0xe, 0xd0, 0x0, 0xb, 0xf1, 0x3f, 0x50,
    0x0, 0x3, 0xf5, 0x5f, 0x30, 0x0, 0x1, 0xf7,
    0x3f, 0x50, 0x0, 0x3, 0xf5, 0xe, 0xd0, 0x0,
    0xb, 0xf1, 0x4, 0xfd, 0x87, 0xcf, 0x60, 0x0,
    0x3b, 0xef, 0xc4, 0x0,

    /* U+0150 "Ő" */
    0x0, 0x0, 0x3, 0xf5, 0x7f, 0x20, 0x0, 0x0,
    0x0, 0xd8, 0x2f, 0x50, 0x0, 0x0, 0x0, 0x2,
    0x1, 0x20, 0x0, 0x0, 0x0, 0x29, 0xdf, 0xeb,
    0x50, 0x0, 0x0, 0x5f, 0xfb, 0x89, 0xef, 0xa0,
    0x0, 0x3f, 0xd2, 0x0, 0x0, 0x8f, 0x90, 0xb,
    0xf2, 0x0, 0x0, 0x0, 0xaf, 0x21, 0xf9, 0x0,
    0x0, 0x0, 0x2, 0xf7, 0x3f, 0x60, 0x0, 0x0,
    0x0, 0xf, 0x93, 0xf6, 0x0, 0x0, 0x0, 0x0,
    0xf9, 0x1f, 0x90, 0x0, 0x0, 0x0, 0x2f, 0x70,
    0xbf, 0x20, 0x0, 0x0, 0xa, 0xf2, 0x3, 0xfd,
    0x20, 0x0, 0x8, 0xf9, 0x0, 0x5, 0xff, 0xa8,
    0x9d, 0xfa, 0x0, 0x0, 0x2, 0x9d, 0xfe, 0xb5,
    0x0, 0x0,

    /* U+0151 "ő" */
    0x0, 0x0, 0xda, 0x2f, 0x70, 0x0, 0x8, 0xd0,
    0xba, 0x0, 0x0, 0x2, 0x10, 0x30, 0x0, 0x0,
    0x3b, 0xef, 0xc4, 0x0, 0x4, 0xfd, 0x87, 0xcf,
    0x60, 0xe, 0xd0, 0x0, 0xb, 0xf1, 0x3f, 0x50,
    0x0, 0x3, 0xf5, 0x5f, 0x30, 0x0, 0x1, 0xf7,
    0x3f, 0x50, 0x0, 0x3, 0xf5, 0xe, 0xd0, 0x0,
    0xb, 0xf1, 0x4, 0xfd, 0x87, 0xcf, 0x60, 0x0,
    0x3b, 0xef, 0xc4, 0x0,

    /* U+0152 "Œ" */
    0x0, 0x2, 0x9d, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xe0, 0x0, 0x5f, 0xfa, 0x77, 0x7f, 0xc7, 0x77,
    0x77, 0x60, 0x3, 0xfc, 0x10, 0x0, 0xf, 0x90,
    0x0, 0x0, 0x0, 0xb, 0xf1, 0x0, 0x0, 0xf,
    0x90, 0x0, 0x0, 0x0, 0xf, 0x90, 0x0, 0x0,
    0xf, 0x91, 0x11, 0x11, 0x0, 0x2f, 0x60, 0x0,
    0x0, 0xf, 0xff, 0xff, 0xff, 0x30, 0x2f, 0x60,
    0x0, 0x0, 0xf, 0xb4, 0x44, 0x44, 0x0, 0xf,
    0x90, 0x0, 0x0, 0xf, 0x90, 0x0, 0x0, 0x0,
    0xb, 0xf1, 0x0, 0x0, 0xf, 0x90, 0x0, 0x0,
    0x0, 0x3, 0xfc, 0x10, 0x0, 0xf, 0x90, 0x0,
    0x0, 0x0, 0x0, 0x5f, 0xfa, 0x87, 0x7f, 0xc7,
    0x77, 0x77, 0x70, 0x0, 0x2, 0x9d, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf1,

    /* U+0153 "œ" */
    0x0, 0x3b, 0xef, 0xb3, 0x1, 0x9e, 0xfc, 0x40,
    0x0, 0x4f, 0xd7, 0x6c, 0xf5, 0xde, 0x76, 0xbf,
    0x50, 0xd, 0xc0, 0x0, 0xa, 0xff, 0x10, 0x0,
    0xae, 0x3, 0xf5, 0x0, 0x0, 0x3f, 0xa0, 0x0,
    0x3, 0xf3, 0x4f, 0x30, 0x0, 0x1, 0xff, 0xff,
    0xff, 0xff, 0x53, 0xf6, 0x0, 0x0, 0x3f, 0xa2,
    0x22, 0x22, 0x20, 0xd, 0xd0, 0x0, 0xb, 0xff,
    0x20, 0x0, 0x11, 0x0, 0x4f, 0xe8, 0x7c, 0xf6,
    0xdf, 0x97, 0x9e, 0x90, 0x0, 0x3b, 0xef, 0xc4,
    0x1, 0x9e, 0xfe, 0x91, 0x0,

    /* U+0154 "Ŕ" */
    0x0, 0x0, 0xae, 0x0, 0x0, 0x0, 0x0, 0xe7,
    0x0, 0x0, 0x0, 0x0, 0x30, 0x0, 0x0, 0x5f,
    0xff, 0xff, 0xd7, 0x0, 0x5f, 0x97, 0x78, 0xbf,
    0xc0, 0x5f, 0x40, 0x0, 0x7, 0xf6, 0x5f, 0x40,
    0x0, 0x0, 0xfa, 0x5f, 0x40, 0x0, 0x0, 0xfa,
    0x5f, 0x40, 0x0, 0x3, 0xf7, 0x5f, 0x52, 0x23,
    0x6e, 0xe1, 0x5f, 0xff, 0xff, 0xfd, 0x20, 0x5f,
    0x75, 0x55, 0xf9, 0x0, 0x5f, 0x40, 0x0, 0x7f,
    0x40, 0x5f, 0x40, 0x0, 0xc, 0xd0, 0x5f, 0x40,
    0x0, 0x3, 0xf9,

    /* U+0155 "ŕ" */
    0x0, 0xdc, 0x0, 0x2f, 0x40, 0x0, 0x20, 0x9,
    0xe3, 0xbf, 0x9f, 0xfb, 0x89, 0xf9, 0x0, 0x9f,
    0x10, 0x9, 0xf0, 0x0, 0x9f, 0x0, 0x9, 0xf0,
    0x0, 0x9f, 0x0, 0x9, 0xf0, 0x0,

    /* U+0156 "Ŗ" */
    0x5f, 0xff, 0xff, 0xd7, 0x0, 0x5f, 0x97, 0x78,
    0xbf, 0xc0, 0x5f, 0x40, 0x0, 0x7, 0xf6, 0x5f,
    0x40, 0x0, 0x0, 0xfa, 0x5f, 0x40, 0x0, 0x0,
    0xfa, 0x5f, 0x40, 0x0, 0x3, 0xf7, 0x5f, 0x52,
    0x23, 0x6e, 0xe1, 0x5f, 0xff, 0xff, 0xfd, 0x20,
    0x5f, 0x75, 0x55, 0xf9, 0x0, 0x5f, 0x40, 0x0,
    0x7f, 0x40, 0x5f, 0x40, 0x0, 0xc, 0xd0, 0x5f,
    0x40, 0x0, 0x3, 0xf9, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xb8, 0x0, 0x0, 0x0, 0x0, 0x99, 0x0, 0x0,
    0x0, 0x0, 0x82, 0x0, 0x0,

    /* U+0157 "ŗ" */
    0x9e, 0x3b, 0xf9, 0xff, 0xb8, 0x9f, 0x90, 0x9,
    0xf1, 0x0, 0x9f, 0x0, 0x9, 0xf0, 0x0, 0x9f,
    0x0, 0x9, 0xf0, 0x0, 0x9f, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x6, 0xd0, 0x0, 0x4d, 0x0,
    0x4, 0x60, 0x0,

    /* U+0158 "Ř" */
    0x0, 0x8d, 0x12, 0xe5, 0x0, 0x0, 0xa, 0xde,
    0x80, 0x0, 0x0, 0x0, 0x76, 0x0, 0x0, 0x5f,
    0xff, 0xff, 0xd7, 0x0, 0x5f, 0x97, 0x78, 0xbf,
    0xc0, 0x5f, 0x40, 0x0, 0x7, 0xf6, 0x5f, 0x40,
    0x0, 0x0, 0xfa, 0x5f, 0x40, 0x0, 0x0, 0xfa,
    0x5f, 0x40, 0x0, 0x3, 0xf7, 0x5f, 0x52, 0x23,
    0x6e, 0xe1, 0x5f, 0xff, 0xff, 0xfd, 0x20, 0x5f,
    0x75, 0x55, 0xf9, 0x0, 0x5f, 0x40, 0x0, 0x7f,
    0x40, 0x5f, 0x40, 0x0, 0xc, 0xd0, 0x5f, 0x40,
    0x0, 0x3, 0xf9,

    /* U+0159 "ř" */
    0x9, 0xc2, 0x7d, 0x20, 0x7, 0xdc, 0x10, 0x0,
    0x0, 0x0, 0x0, 0x9e, 0x3b, 0xf0, 0x9, 0xff,
    0xb8, 0x0, 0x9f, 0x90, 0x0, 0x9, 0xf1, 0x0,
    0x0, 0x9f, 0x0, 0x0, 0x9, 0xf0, 0x0, 0x0,
    0x9f, 0x0, 0x0, 0x9, 0xf0, 0x0, 0x0, 0x9f,
    0x0, 0x0,

    /* U+015A "Ś" */
    0x0, 0x0, 0x6f, 0x30, 0x0, 0x0, 0x0, 0xba,
    0x0, 0x0, 0x0, 0x0, 0x21, 0x0, 0x0, 0x0,
    0x5c, 0xff, 0xd9, 0x20, 0x7, 0xfc, 0x77, 0xaf,
    0x90, 0xf, 0xb0, 0x0, 0x1, 0x10, 0x1f, 0x80,
    0x0, 0x0, 0x0, 0xe, 0xe5, 0x0, 0x0, 0x0,
    0x3, 0xef, 0xea, 0x50, 0x0, 0x0, 0x5, 0xae,
    0xfe, 0x40, 0x0, 0x0, 0x0, 0x5e, 0xf1, 0x0,
    0x0, 0x0, 0x5, 0xf3, 0x8, 0x0, 0x0, 0x8,
    0xf1, 0x2f, 0xea, 0x77, 0xbf, 0x90, 0x2, 0x9d,
    0xff, 0xc6, 0x0,

    /* U+015B "ś" */
    0x0, 0x9, 0xf1, 0x0, 0x0, 0xe, 0x70, 0x0,
    0x0, 0x3, 0x0, 0x0, 0x3, 0xbf, 0xfd, 0x80,
    0x1f, 0xd7, 0x69, 0xd0, 0x5f, 0x30, 0x0, 0x0,
    0x3f, 0xb4, 0x10, 0x0, 0x6, 0xef, 0xfd, 0x60,
    0x0, 0x2, 0x5b, 0xf5, 0x1, 0x0, 0x0, 0xf7,
    0x6f, 0xa7, 0x6b, 0xf3, 0x18, 0xdf, 0xfc, 0x40,

    /* U+015C "Ŝ" */
    0x0, 0x3, 0xef, 0x60, 0x0, 0x0, 0x4e, 0x52,
    0xd7, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x5c, 0xff, 0xd9, 0x20, 0x7, 0xfc, 0x77, 0xaf,
    0x90, 0xf, 0xb0, 0x0, 0x1, 0x10, 0x1f, 0x80,
    0x0, 0x0, 0x0, 0xe, 0xe5, 0x0, 0x0, 0x0,
    0x3, 0xef, 0xea, 0x50, 0x0, 0x0, 0x5, 0xae,
    0xfe, 0x40, 0x0, 0x0, 0x0, 0x5e, 0xf1, 0x0,
    0x0, 0x0, 0x5, 0xf3, 0x8, 0x0, 0x0, 0x8,
    0xf1, 0x2f, 0xea, 0x77, 0xbf, 0x90, 0x2, 0x9d,
    0xff, 0xc6, 0x0,

    /* U+015D "ŝ" */
    0x0, 0x5f, 0xf4, 0x0, 0x5, 0xd2, 0x3d, 0x40,
    0x0, 0x0, 0x0, 0x0, 0x3, 0xbf, 0xfd, 0x80,
    0x1f, 0xd7, 0x69, 0xd0, 0x5f, 0x30, 0x0, 0x0,
    0x3f, 0xb4, 0x10, 0x0, 0x6, 0xef, 0xfd, 0x60,
    0x0, 0x2, 0x5b, 0xf5, 0x1, 0x0, 0x0, 0xf7,
    0x6f, 0xa7, 0x6b, 0xf3, 0x18, 0xdf, 0xfc, 0x40,

    /* U+015E "Ş" */
    0x0, 0x5c, 0xff, 0xd9, 0x20, 0x7, 0xfc, 0x77,
    0xaf, 0x90, 0xf, 0xb0, 0x0, 0x1, 0x10, 0x1f,
    0x80, 0x0, 0x0, 0x0, 0xe, 0xe5, 0x0, 0x0,
    0x0, 0x3, 0xef, 0xea, 0x50, 0x0, 0x0, 0x5,
    0xae, 0xfe, 0x40, 0x0, 0x0, 0x0, 0x5e, 0xf1,
    0x0, 0x0, 0x0, 0x5, 0xf3, 0x8, 0x0, 0x0,
    0x8, 0xf1, 0x2f, 0xea, 0x77, 0xbf, 0x90, 0x2,
    0x9d, 0xff, 0xc6, 0x0, 0x0, 0x0, 0x8a, 0x10,
    0x0, 0x0, 0x0, 0x9, 0xa0, 0x0, 0x0, 0x7,
    0xed, 0x50, 0x0,

    /* U+015F "ş" */
    0x3, 0xbf, 0xfd, 0x80, 0x1f, 0xd7, 0x69, 0xd0,
    0x5f, 0x30, 0x0, 0x0, 0x3f, 0xb4, 0x10, 0x0,
    0x6, 0xef, 0xfd, 0x60, 0x0, 0x2, 0x5b, 0xf5,
    0x1, 0x0, 0x0, 0xf7, 0x6f, 0xa7, 0x6b, 0xf3,
    0x18, 0xdf, 0xfc, 0x40, 0x0, 0xb, 0x70, 0x0,
    0x0, 0x1, 0xb7, 0x0, 0x0, 0x9e, 0xd3, 0x0,

    /* U+0160 "Š" */
    0x0, 0x4e, 0x52, 0xd7, 0x0, 0x0, 0x3, 0xef,
    0x60, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x5c, 0xff, 0xd9, 0x20, 0x7, 0xfc, 0x77, 0xaf,
    0x90, 0xf, 0xb0, 0x0, 0x1, 0x10, 0x1f, 0x80,
    0x0, 0x0, 0x0, 0xe, 0xe5, 0x0, 0x0, 0x0,
    0x3, 0xef, 0xea, 0x50, 0x0, 0x0, 0x5, 0xae,
    0xfe, 0x40, 0x0, 0x0, 0x0, 0x5e, 0xf1, 0x0,
    0x0, 0x0, 0x5, 0xf3, 0x8, 0x0, 0x0, 0x8,
    0xf1, 0x2f, 0xea, 0x77, 0xbf, 0x90, 0x2, 0x9d,
    0xff, 0xc6, 0x0,

    /* U+0161 "š" */
    0x6, 0xe3, 0x4e, 0x40, 0x0, 0x4e, 0xe3, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x3, 0xbf, 0xfd, 0x80,
    0x1f, 0xd7, 0x69, 0xd0, 0x5f, 0x30, 0x0, 0x0,
    0x3f, 0xb4, 0x10, 0x0, 0x6, 0xef, 0xfd, 0x60,
    0x0, 0x2, 0x5b, 0xf5, 0x1, 0x0, 0x0, 0xf7,
    0x6f, 0xa7, 0x6b, 0xf3, 0x18, 0xdf, 0xfc, 0x40,

    /* U+0162 "Ţ" */
    0xff, 0xff, 0xff, 0xff, 0xf5, 0x67, 0x78, 0xfb,
    0x77, 0x72, 0x0, 0x1, 0xf7, 0x0, 0x0, 0x0,
    0x1, 0xf7, 0x0, 0x0, 0x0, 0x1, 0xf7, 0x0,
    0x0, 0x0, 0x1, 0xf7, 0x0, 0x0, 0x0, 0x1,
    0xf7, 0x0, 0x0, 0x0, 0x1, 0xf7, 0x0, 0x0,
    0x0, 0x1, 0xf7, 0x0, 0x0, 0x0, 0x1, 0xf7,
    0x0, 0x0, 0x0, 0x1, 0xf7, 0x0, 0x0, 0x0,
    0x1, 0xf7, 0x0, 0x0, 0x0, 0x0, 0xe3, 0x0,
    0x0, 0x0, 0x0, 0x2f, 0x20, 0x0, 0x0, 0xd,
    0xeb, 0x0, 0x0,

    /* U+0163 "ţ" */
    0x2, 0x81, 0x0, 0x0, 0x5f, 0x30, 0x0, 0x5,
    0xf3, 0x0, 0xc, 0xff, 0xff, 0xa0, 0x48, 0xf7,
    0x53, 0x0, 0x5f, 0x30, 0x0, 0x5, 0xf3, 0x0,
    0x0, 0x5f, 0x30, 0x0, 0x5, 0xf3, 0x0, 0x0,
    0x4f, 0x40, 0x0, 0x1, 0xfc, 0x68, 0x0, 0x5,
    0xff, 0xb0, 0x0, 0xa, 0x80, 0x0, 0x0, 0x1a,
    0x80, 0x0, 0x8e, 0xd3, 0x0,

    /* U+0164 "Ť" */
    0x0, 0xba, 0x5, 0xe2, 0x0, 0x0, 0x1d, 0xcf,
    0x40, 0x0, 0x0, 0x2, 0x84, 0x0, 0x0, 0xff,
    0xff, 0xff, 0xff, 0xf5, 0x67, 0x78, 0xfb, 0x77,
    0x72, 0x0, 0x1, 0xf7, 0x0, 0x0, 0x0, 0x1,
    0xf7, 0x0, 0x0, 0x0, 0x1, 0xf7, 0x0, 0x0,
    0x0, 0x1, 0xf7, 0x0, 0x0, 0x0, 0x1, 0xf7,
    0x0, 0x0, 0x0, 0x1, 0xf7, 0x0, 0x0, 0x0,
    0x1, 0xf7, 0x0, 0x0, 0x0, 0x1, 0xf7, 0x0,
    0x0, 0x0, 0x1, 0xf7, 0x0, 0x0, 0x0, 0x1,
    0xf7, 0x0, 0x0,

    /* U+0165 "ť" */
    0x0, 0x0, 0x7b, 0x0, 0x0, 0x7, 0xa0, 0x5,
    0xf3, 0x68, 0xc, 0xff, 0xff, 0xa0, 0x48, 0xf7,
    0x53, 0x0, 0x5f, 0x30, 0x0, 0x5, 0xf3, 0x0,
    0x0, 0x5f, 0x30, 0x0, 0x5, 0xf3, 0x0, 0x0,
    0x4f, 0x40, 0x0, 0x1, 0xfc, 0x68, 0x0, 0x5,
    0xdf, 0xb0,

    /* U+0166 "Ŧ" */
    0xff, 0xff, 0xff, 0xff, 0xf5, 0x67, 0x78, 0xfb,
    0x77, 0x72, 0x0, 0x1, 0xf7, 0x0, 0x0, 0x0,
    0x1, 0xf7, 0x0, 0x0, 0x0, 0x1, 0xf7, 0x0,
    0x0, 0x0, 0x12, 0xf8, 0x10, 0x0, 0x8, 0xff,
    0xff, 0xfe, 0x0, 0x2, 0x45, 0xfb, 0x43, 0x0,
    0x0, 0x1, 0xf7, 0x0, 0x0, 0x0, 0x1, 0xf7,
    0x0, 0x0, 0x0, 0x1, 0xf7, 0x0, 0x0, 0x0,
    0x1, 0xf7, 0x0, 0x0,

    /* U+0167 "ŧ" */
    0x4, 0xf4, 0x0, 0x0, 0x4f, 0x40, 0x0, 0xbf,
    0xff, 0xfb, 0x3, 0x7f, 0x85, 0x30, 0x4, 0xf4,
    0x0, 0x7, 0xff, 0xff, 0x80, 0x16, 0xf7, 0x21,
    0x0, 0x4f, 0x40, 0x0, 0x3, 0xf5, 0x0, 0x0,
    0xe, 0xd6, 0x90, 0x0, 0x4d, 0xfc, 0x10,

    /* U+0168 "Ũ" */
    0x0, 0xa, 0xd6, 0x1d, 0x0, 0x0, 0x4, 0xb1,
    0xaf, 0x70, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x7, 0xf2, 0x0, 0x0, 0x8, 0xf1, 0x7f, 0x20,
    0x0, 0x0, 0x8f, 0x17, 0xf2, 0x0, 0x0, 0x8,
    0xf1, 0x7f, 0x20, 0x0, 0x0, 0x8f, 0x17, 0xf2,
    0x0, 0x0, 0x8, 0xf1, 0x7f, 0x20, 0x0, 0x0,
    0x8f, 0x16, 0xf2, 0x0, 0x0, 0x8, 0xf0, 0x6f,
    0x30, 0x0, 0x0, 0x9f, 0x3, 0xf6, 0x0, 0x0,
    0xc, 0xd0, 0xe, 0xe1, 0x0, 0x5, 0xf8, 0x0,
    0x4f, 0xfa, 0x8b, 0xfd, 0x0, 0x0, 0x3b, 0xef,
    0xd8, 0x10, 0x0,

    /* U+0169 "ũ" */
    0x0, 0xbe, 0x71, 0xe0, 0x0, 0x3b, 0x1a, 0xe7,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xa, 0xe0, 0x0,
    0x3, 0xf5, 0xae, 0x0, 0x0, 0x3f, 0x5a, 0xe0,
    0x0, 0x3, 0xf5, 0xae, 0x0, 0x0, 0x3f, 0x5a,
    0xe0, 0x0, 0x3, 0xf5, 0x9f, 0x0, 0x0, 0x4f,
    0x57, 0xf4, 0x0, 0xb, 0xf5, 0x1e, 0xf9, 0x7c,
    0xef, 0x50, 0x3b, 0xff, 0xa3, 0xf5,

    /* U+016A "Ū" */
    0x0, 0x4e, 0xee, 0xed, 0x0, 0x0, 0x0, 0x11,
    0x11, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x7, 0xf2, 0x0, 0x0, 0x8, 0xf1, 0x7f, 0x20,
    0x0, 0x0, 0x8f, 0x17, 0xf2, 0x0, 0x0, 0x8,
    0xf1, 0x7f, 0x20, 0x0, 0x0, 0x8f, 0x17, 0xf2,
    0x0, 0x0, 0x8, 0xf1, 0x7f, 0x20, 0x0, 0x0,
    0x8f, 0x16, 0xf2, 0x0, 0x0, 0x8, 0xf0, 0x6f,
    0x30, 0x0, 0x0, 0x9f, 0x3, 0xf6, 0x0, 0x0,
    0xc, 0xd0, 0xe, 0xe1, 0x0, 0x5, 0xf8, 0x0,
    0x4f, 0xfa, 0x8b, 0xfd, 0x0, 0x0, 0x3b, 0xef,
    0xd8, 0x10, 0x0,

    /* U+016B "ū" */
    0x4, 0xff, 0xff, 0xf0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xa, 0xe0, 0x0,
    0x3, 0xf5, 0xae, 0x0, 0x0, 0x3f, 0x5a, 0xe0,
    0x0, 0x3, 0xf5, 0xae, 0x0, 0x0, 0x3f, 0x5a,
    0xe0, 0x0, 0x3, 0xf5, 0x9f, 0x0, 0x0, 0x4f,
    0x57, 0xf4, 0x0, 0xb, 0xf5, 0x1e, 0xf9, 0x7c,
    0xef, 0x50, 0x3b, 0xff, 0xa3, 0xf5,

    /* U+016C "Ŭ" */
    0x0, 0x2e, 0x20, 0x6c, 0x0, 0x0, 0x0, 0x6d,
    0xeb, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x7, 0xf2, 0x0, 0x0, 0x8, 0xf1, 0x7f, 0x20,
    0x0, 0x0, 0x8f, 0x17, 0xf2, 0x0, 0x0, 0x8,
    0xf1, 0x7f, 0x20, 0x0, 0x0, 0x8f, 0x17, 0xf2,
    0x0, 0x0, 0x8, 0xf1, 0x7f, 0x20, 0x0, 0x0,
    0x8f, 0x16, 0xf2, 0x0, 0x0, 0x8, 0xf0, 0x6f,
    0x30, 0x0, 0x0, 0x9f, 0x3, 0xf6, 0x0, 0x0,
    0xc, 0xd0, 0xe, 0xe1, 0x0, 0x5, 0xf8, 0x0,
    0x4f, 0xfa, 0x8b, 0xfd, 0x0, 0x0, 0x3b, 0xef,
    0xd8, 0x10, 0x0,

    /* U+016D "ŭ" */
    0x1, 0xe2, 0x6, 0xd0, 0x0, 0x5, 0xde, 0xb2,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xa, 0xe0, 0x0,
    0x3, 0xf5, 0xae, 0x0, 0x0, 0x3f, 0x5a, 0xe0,
    0x0, 0x3, 0xf5, 0xae, 0x0, 0x0, 0x3f, 0x5a,
    0xe0, 0x0, 0x3, 0xf5, 0x9f, 0x0, 0x0, 0x4f,
    0x57, 0xf4, 0x0, 0xb, 0xf5, 0x1e, 0xf9, 0x7c,
    0xef, 0x50, 0x3b, 0xff, 0xa3, 0xf5,

    /* U+016E "Ů" */
    0x0, 0x0, 0x8b, 0x40, 0x0, 0x0, 0x0, 0x56,
    0xb, 0x0, 0x0, 0x0, 0x5, 0x60, 0xb0, 0x0,
    0x0, 0x0, 0x8, 0xa4, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x7, 0xf2, 0x0, 0x0, 0x8,
    0xf1, 0x7f, 0x20, 0x0, 0x0, 0x8f, 0x17, 0xf2,
    0x0, 0x0, 0x8, 0xf1, 0x7f, 0x20, 0x0, 0x0,
    0x8f, 0x17, 0xf2, 0x0, 0x0, 0x8, 0xf1, 0x7f,
    0x20, 0x0, 0x0, 0x8f, 0x16, 0xf2, 0x0, 0x0,
    0x8, 0xf0, 0x6f, 0x30, 0x0, 0x0, 0x9f, 0x3,
    0xf6, 0x0, 0x0, 0xc, 0xd0, 0xe, 0xe1, 0x0,
    0x5, 0xf8, 0x0, 0x4f, 0xfa, 0x8b, 0xfd, 0x0,
    0x0, 0x3b, 0xef, 0xd8, 0x10, 0x0,

    /* U+016F "ů" */
    0x0, 0x8, 0xb5, 0x0, 0x0, 0x4, 0x70, 0xb0,
    0x0, 0x0, 0x47, 0xb, 0x0, 0x0, 0x0, 0x8a,
    0x50, 0x0, 0x0, 0x0, 0x0, 0x0, 0xa, 0xe0,
    0x0, 0x3, 0xf5, 0xae, 0x0, 0x0, 0x3f, 0x5a,
    0xe0, 0x0, 0x3, 0xf5, 0xae, 0x0, 0x0, 0x3f,
    0x5a, 0xe0, 0x0, 0x3, 0xf5, 0x9f, 0x0, 0x0,
    0x4f, 0x57, 0xf4, 0x0, 0xb, 0xf5, 0x1e, 0xf9,
    0x7c, 0xef, 0x50, 0x3b, 0xff, 0xa3, 0xf5,

    /* U+0170 "Ű" */
    0x0, 0x0, 0x9d, 0x1c, 0xb0, 0x0, 0x0, 0x4f,
    0x27, 0xd1, 0x0, 0x0, 0x2, 0x10, 0x21, 0x0,
    0x7, 0xf2, 0x0, 0x0, 0x8, 0xf1, 0x7f, 0x20,
    0x0, 0x0, 0x8f, 0x17, 0xf2, 0x0, 0x0, 0x8,
    0xf1, 0x7f, 0x20, 0x0, 0x0, 0x8f, 0x17, 0xf2,
    0x0, 0x0, 0x8, 0xf1, 0x7f, 0x20, 0x0, 0x0,
    0x8f, 0x16, 0xf2, 0x0, 0x0, 0x8, 0xf0, 0x6f,
    0x30, 0x0, 0x0, 0x9f, 0x3, 0xf6, 0x0, 0x0,
    0xc, 0xd0, 0xe, 0xe1, 0x0, 0x5, 0xf8, 0x0,
    0x4f, 0xfa, 0x8b, 0xfd, 0x0, 0x0, 0x3b, 0xef,
    0xd8, 0x10, 0x0,

    /* U+0171 "ű" */
    0x0, 0x9, 0xe1, 0xcb, 0x0, 0x3, 0xf3, 0x7e,
    0x10, 0x0, 0x12, 0x2, 0x10, 0xa, 0xe0, 0x0,
    0x3, 0xf5, 0xae, 0x0, 0x0, 0x3f, 0x5a, 0xe0,
    0x0, 0x3, 0xf5, 0xae, 0x0, 0x0, 0x3f, 0x5a,
    0xe0, 0x0, 0x3, 0xf5, 0x9f, 0x0, 0x0, 0x4f,
    0x57, 0xf4, 0x0, 0xb, 0xf5, 0x1e, 0xf9, 0x7c,
    0xef, 0x50, 0x3b, 0xff, 0xa3, 0xf5,

    /* U+0172 "Ų" */
    0x6f, 0x30, 0x0, 0x0, 0x8f, 0x16, 0xf3, 0x0,
    0x0, 0x8, 0xf1, 0x6f, 0x30, 0x0, 0x0, 0x8f,
    0x16, 0xf3, 0x0, 0x0, 0x8, 0xf1, 0x6f, 0x30,
    0x0, 0x0, 0x8f, 0x16, 0xf3, 0x0, 0x0, 0x8,
    0xf1, 0x6f, 0x30, 0x0, 0x0, 0x8f, 0x6, 0xf3,
    0x0, 0x0, 0x8, 0xf0, 0x3f, 0x60, 0x0, 0x0,
    0xbb, 0x0, 0xed, 0x10, 0x0, 0x4f, 0x40, 0x5,
    0xfe, 0x97, 0xae, 0x50, 0x0, 0x4, 0xcf, 0xf7,
    0x10, 0x0, 0x0, 0x0, 0xa2, 0x0, 0x0, 0x0,
    0x0, 0x2e, 0x10, 0x0, 0x0, 0x0, 0x0, 0xbf,
    0xd0, 0x0, 0x0,

    /* U+0173 "ų" */
    0xae, 0x0, 0x0, 0x3f, 0x5a, 0xe0, 0x0, 0x3,
    0xf5, 0xae, 0x0, 0x0, 0x3f, 0x5a, 0xe0, 0x0,
    0x3, 0xf5, 0xae, 0x0, 0x0, 0x3f, 0x59, 0xf0,
    0x0, 0x4, 0xf5, 0x7f, 0x40, 0x0, 0xbf, 0x51,
    0xef, 0x97, 0xce, 0xf5, 0x3, 0xbf, 0xfa, 0x5f,
    0x60, 0x0, 0x0, 0x3d, 0x40, 0x0, 0x0, 0x9,
    0x90, 0x0, 0x0, 0x0, 0x3d, 0xe7,

    /* U+0174 "Ŵ" */
    0x0, 0x0, 0x0, 0x3, 0xff, 0x30, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1e, 0x88, 0xe1, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x56, 0x0, 0x65,
    0x0, 0x0, 0x0, 0x5f, 0x40, 0x0, 0x0, 0xde,
    0x0, 0x0, 0x3, 0xf5, 0xf, 0x90, 0x0, 0x2,
    0xff, 0x40, 0x0, 0x8, 0xf0, 0xb, 0xe0, 0x0,
    0x7, 0xff, 0x90, 0x0, 0xd, 0xb0, 0x6, 0xf3,
    0x0, 0xc, 0xaa, 0xe0, 0x0, 0x2f, 0x60, 0x1,
    0xf8, 0x0, 0x2f, 0x55, 0xf3, 0x0, 0x7f, 0x10,
    0x0, 0xcd, 0x0, 0x7f, 0x0, 0xf8, 0x0, 0xcc,
    0x0, 0x0, 0x7f, 0x20, 0xcb, 0x0, 0xbd, 0x1,
    0xf7, 0x0, 0x0, 0x2f, 0x71, 0xf6, 0x0, 0x5f,
    0x26, 0xf2, 0x0, 0x0, 0xd, 0xc6, 0xf1, 0x0,
    0x1f, 0x7b, 0xd0, 0x0, 0x0, 0x8, 0xfd, 0xc0,
    0x0, 0xb, 0xdf, 0x80, 0x0, 0x0, 0x3, 0xff,
    0x60, 0x0, 0x6, 0xff, 0x30, 0x0, 0x0, 0x0,
    0xef, 0x10, 0x0, 0x1, 0xfe, 0x0, 0x0,

    /* U+0175 "ŵ" */
    0x0, 0x0, 0x3, 0xef, 0x70, 0x0, 0x0, 0x0,
    0x0, 0x3, 0xd4, 0x2c, 0x70, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xc, 0xb0,
    0x0, 0x9, 0xf0, 0x0, 0x4, 0xf1, 0x6f, 0x10,
    0x0, 0xff, 0x60, 0x0, 0xab, 0x1, 0xf6, 0x0,
    0x5f, 0xcb, 0x0, 0xf, 0x60, 0xb, 0xb0, 0xb,
    0xb5, 0xf1, 0x5, 0xf1, 0x0, 0x5f, 0x11, 0xf5,
    0xf, 0x60, 0xba, 0x0, 0x0, 0xf6, 0x6f, 0x0,
    0xac, 0x1f, 0x50, 0x0, 0xa, 0xcc, 0x90, 0x4,
    0xf8, 0xf0, 0x0, 0x0, 0x4f, 0xf3, 0x0, 0xe,
    0xfa, 0x0, 0x0, 0x0, 0xee, 0x0, 0x0, 0x8f,
    0x40, 0x0,

    /* U+0176 "Ŷ" */
    0x0, 0x0, 0x2d, 0xe5, 0x0, 0x0, 0x0, 0x2,
    0xe7, 0x3e, 0x60, 0x0, 0x0, 0x1, 0x10, 0x0,
    0x10, 0x0, 0xc, 0xd0, 0x0, 0x0, 0x7, 0xf2,
    0x3, 0xf7, 0x0, 0x0, 0x1f, 0x80, 0x0, 0xaf,
    0x10, 0x0, 0x9e, 0x0, 0x0, 0x1f, 0x90, 0x3,
    0xf6, 0x0, 0x0, 0x8, 0xf3, 0xb, 0xd0, 0x0,
    0x0, 0x0, 0xec, 0x5f, 0x40, 0x0, 0x0, 0x0,
    0x6f, 0xfb, 0x0, 0x0, 0x0, 0x0, 0xc, 0xf2,
    0x0, 0x0, 0x0, 0x0, 0xa, 0xf0, 0x0, 0x0,
    0x0, 0x0, 0xa, 0xf0, 0x0, 0x0, 0x0, 0x0,
    0xa, 0xf0, 0x0, 0x0, 0x0, 0x0, 0xa, 0xf0,
    0x0, 0x0,

    /* U+0177 "ŷ" */
    0x0, 0x2, 0xee, 0x80, 0x0, 0x0, 0x2c, 0x51,
    0xb8, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xd,
    0xc0, 0x0, 0x0, 0xcb, 0x6, 0xf2, 0x0, 0x3,
    0xf4, 0x0, 0xe9, 0x0, 0x9, 0xd0, 0x0, 0x8f,
    0x10, 0x1f, 0x60, 0x0, 0x1f, 0x70, 0x7f, 0x0,
    0x0, 0xa, 0xd0, 0xe9, 0x0, 0x0, 0x3, 0xfa,
    0xf2, 0x0, 0x0, 0x0, 0xcf, 0xb0, 0x0, 0x0,
    0x0, 0x6f, 0x40, 0x0, 0x0, 0x0, 0xbd, 0x0,
    0x0, 0x1c, 0x79, 0xf5, 0x0, 0x0, 0x1a, 0xee,
    0x70, 0x0, 0x0,

    /* U+0178 "Ÿ" */
    0x0, 0x0, 0x92, 0x9, 0x20, 0x0, 0x0, 0x0,
    0xe5, 0xe, 0x40, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xc, 0xd0, 0x0, 0x0, 0x7, 0xf2,
    0x3, 0xf7, 0x0, 0x0, 0x1f, 0x80, 0x0, 0xaf,
    0x10, 0x0, 0x9e, 0x0, 0x0, 0x1f, 0x90, 0x3,
    0xf6, 0x0, 0x0, 0x8, 0xf3, 0xb, 0xd0, 0x0,
    0x0, 0x0, 0xec, 0x5f, 0x40, 0x0, 0x0, 0x0,
    0x6f, 0xfb, 0x0, 0x0, 0x0, 0x0, 0xc, 0xf2,
    0x0, 0x0, 0x0, 0x0, 0xa, 0xf0, 0x0, 0x0,
    0x0, 0x0, 0xa, 0xf0, 0x0, 0x0, 0x0, 0x0,
    0xa, 0xf0, 0x0, 0x0, 0x0, 0x0, 0xa, 0xf0,
    0x0, 0x0,

    /* U+0179 "Ź" */
    0x0, 0x0, 0x3f, 0x60, 0x0, 0x0, 0x0, 0x8,
    0xd0, 0x0, 0x0, 0x0, 0x0, 0x21, 0x0, 0x0,
    0x3, 0xff, 0xff, 0xff, 0xff, 0xd0, 0x17, 0x77,
    0x77, 0x7b, 0xf8, 0x0, 0x0, 0x0, 0x2, 0xec,
    0x0, 0x0, 0x0, 0x0, 0xce, 0x20, 0x0, 0x0,
    0x0, 0x9f, 0x50, 0x0, 0x0, 0x0, 0x5f, 0x90,
    0x0, 0x0, 0x0, 0x2e, 0xc0, 0x0, 0x0, 0x0,
    0xc, 0xe2, 0x0, 0x0, 0x0, 0x9, 0xf5, 0x0,
    0x0, 0x0, 0x5, 0xf9, 0x0, 0x0, 0x0, 0x1,
    0xef, 0x77, 0x77, 0x77, 0x70, 0x5f, 0xff, 0xff,
    0xff, 0xff, 0x0,

    /* U+017A "ź" */
    0x0, 0x6, 0xf3, 0x0, 0x0, 0xa, 0xb0, 0x0,
    0x0, 0x2, 0x10, 0x0, 0x4f, 0xff, 0xff, 0xf9,
    0x15, 0x55, 0x5b, 0xf4, 0x0, 0x0, 0x4f, 0x80,
    0x0, 0x1, 0xeb, 0x0, 0x0, 0xb, 0xe1, 0x0,
    0x0, 0x8f, 0x30, 0x0, 0x4, 0xf7, 0x0, 0x0,
    0x1e, 0xe5, 0x55, 0x53, 0x6f, 0xff, 0xff, 0xfb,

    /* U+017B "Ż" */
    0x0, 0x0, 0x6e, 0x20, 0x0, 0x0, 0x0, 0x5,
    0xe2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x3, 0xff, 0xff, 0xff, 0xff, 0xd0, 0x17, 0x77,
    0x77, 0x7b, 0xf8, 0x0, 0x0, 0x0, 0x2, 0xec,
    0x0, 0x0, 0x0, 0x0, 0xce, 0x20, 0x0, 0x0,
    0x0, 0x9f, 0x50, 0x0, 0x0, 0x0, 0x5f, 0x90,
    0x0, 0x0, 0x0, 0x2e, 0xc0, 0x0, 0x0, 0x0,
    0xc, 0xe2, 0x0, 0x0, 0x0, 0x9, 0xf5, 0x0,
    0x0, 0x0, 0x5, 0xf9, 0x0, 0x0, 0x0, 0x1,
    0xef, 0x77, 0x77, 0x77, 0x70, 0x5f, 0xff, 0xff,
    0xff, 0xff, 0x0,

    /* U+017C "ż" */
    0x0, 0x8, 0xd0, 0x0, 0x0, 0x8, 0xd0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x4f, 0xff, 0xff, 0xf9,
    0x15, 0x55, 0x5b, 0xf4, 0x0, 0x0, 0x4f, 0x80,
    0x0, 0x1, 0xeb, 0x0, 0x0, 0xb, 0xe1, 0x0,
    0x0, 0x8f, 0x30, 0x0, 0x4, 0xf7, 0x0, 0x0,
    0x1e, 0xe5, 0x55, 0x53, 0x6f, 0xff, 0xff, 0xfb,

    /* U+017D "Ž" */
    0x0, 0x2e, 0x60, 0xac, 0x0, 0x0, 0x0, 0x3f,
    0xcd, 0x10, 0x0, 0x0, 0x0, 0x48, 0x20, 0x0,
    0x3, 0xff, 0xff, 0xff, 0xff, 0xd0, 0x17, 0x77,
    0x77, 0x7b, 0xf8, 0x0, 0x0, 0x0, 0x2, 0xec,
    0x0, 0x0, 0x0, 0x0, 0xce, 0x20, 0x0, 0x0,
    0x0, 0x9f, 0x50, 0x0, 0x0, 0x0, 0x5f, 0x90,
    0x0, 0x0, 0x0, 0x2e, 0xc0, 0x0, 0x0, 0x0,
    0xc, 0xe2, 0x0, 0x0, 0x0, 0x9, 0xf5, 0x0,
    0x0, 0x0, 0x5, 0xf9, 0x0, 0x0, 0x0, 0x1,
    0xef, 0x77, 0x77, 0x77, 0x70, 0x5f, 0xff, 0xff,
    0xff, 0xff, 0x0,

    /* U+017E "ž" */
    0x3, 0xe6, 0x2d, 0x70, 0x0, 0x2c, 0xd5, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x4f, 0xff, 0xff, 0xf9,
    0x15, 0x55, 0x5b, 0xf4, 0x0, 0x0, 0x4f, 0x80,
    0x0, 0x1, 0xeb, 0x0, 0x0, 0xb, 0xe1, 0x0,
    0x0, 0x8f, 0x30, 0x0, 0x4, 0xf7, 0x0, 0x0,
    0x1e, 0xe5, 0x55, 0x53, 0x6f, 0xff, 0xff, 0xfb,

    /* U+017F "ſ" */
    0x0, 0x4c, 0xfd, 0x20, 0xe, 0xd6, 0x70, 0x2,
    0xf6, 0x0, 0x9, 0xff, 0x60, 0x0, 0x36, 0xf6,
    0x0, 0x0, 0x2f, 0x60, 0x0, 0x2, 0xf6, 0x0,
    0x0, 0x2f, 0x60, 0x0, 0x2, 0xf6, 0x0, 0x0,
    0x2f, 0x60, 0x0, 0x2, 0xf6, 0x0, 0x0, 0x2f,
    0x60, 0x0,

    /* U+0384 "΄" */
    0x3, 0x17, 0xf2, 0xc9, 0x0,

    /* U+0386 "Ά" */
    0x0, 0x22, 0x0, 0x0, 0x0, 0x0, 0x0, 0xd,
    0xb0, 0x2f, 0xd0, 0x0, 0x0, 0x2, 0xf2, 0x9,
    0xff, 0x40, 0x0, 0x0, 0x0, 0x0, 0xfb, 0xfb,
    0x0, 0x0, 0x0, 0x0, 0x6f, 0x49, 0xf2, 0x0,
    0x0, 0x0, 0xd, 0xd0, 0x2f, 0x80, 0x0, 0x0,
    0x4, 0xf7, 0x0, 0xce, 0x0, 0x0, 0x0, 0xbf,
    0x0, 0x5, 0xf6, 0x0, 0x0, 0x1f, 0xa1, 0x11,
    0x1e, 0xd0, 0x0, 0x8, 0xff, 0xff, 0xff, 0xff,
    0x30, 0x0, 0xec, 0x44, 0x44, 0x44, 0xfa, 0x0,
    0x6f, 0x40, 0x0, 0x0, 0xa, 0xf1, 0xc, 0xd0,
    0x0, 0x0, 0x0, 0x2f, 0x80,

    /* U+0388 "Έ" */
    0x9, 0x50, 0x0, 0x0, 0x0, 0x0, 0x5f, 0x15,
    0xff, 0xff, 0xff, 0xf8, 0x44, 0x5, 0xf9, 0x77,
    0x77, 0x73, 0x0, 0x5, 0xf3, 0x0, 0x0, 0x0,
    0x0, 0x5, 0xf3, 0x0, 0x0, 0x0, 0x0, 0x5,
    0xf5, 0x11, 0x11, 0x10, 0x0, 0x5, 0xff, 0xff,
    0xff, 0xd0, 0x0, 0x5, 0xf7, 0x44, 0x44, 0x40,
    0x0, 0x5, 0xf3, 0x0, 0x0, 0x0, 0x0, 0x5,
    0xf3, 0x0, 0x0, 0x0, 0x0, 0x5, 0xf3, 0x0,
    0x0, 0x0, 0x0, 0x5, 0xf9, 0x77, 0x77, 0x75,
    0x0, 0x5, 0xff, 0xff, 0xff, 0xfc,

    /* U+0389 "Ή" */
    0x3, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6f,
    0x28, 0xf1, 0x0, 0x0, 0x8, 0xf1, 0xb9, 0x8,
    0xf1, 0x0, 0x0, 0x8, 0xf1, 0x0, 0x8, 0xf1,
    0x0, 0x0, 0x8, 0xf1, 0x0, 0x8, 0xf1, 0x0,
    0x0, 0x8, 0xf1, 0x0, 0x8, 0xf3, 0x22, 0x22,
    0x29, 0xf1, 0x0, 0x8, 0xff, 0xff, 0xff, 0xff,
    0xf1, 0x0, 0x8, 0xf5, 0x55, 0x55, 0x5a, 0xf1,
    0x0, 0x8, 0xf1, 0x0, 0x0, 0x8, 0xf1, 0x0,
    0x8, 0xf1, 0x0, 0x0, 0x8, 0xf1, 0x0, 0x8,
    0xf1, 0x0, 0x0, 0x8, 0xf1, 0x0, 0x8, 0xf1,
    0x0, 0x0, 0x8, 0xf1, 0x0, 0x8, 0xf1, 0x0,
    0x0, 0x8, 0xf1,

    /* U+038A "Ί" */
    0x3, 0x10, 0x0, 0x6f, 0x27, 0xf2, 0xba, 0x7,
    0xf2, 0x0, 0x7, 0xf2, 0x0, 0x7, 0xf2, 0x0,
    0x7, 0xf2, 0x0, 0x7, 0xf2, 0x0, 0x7, 0xf2,
    0x0, 0x7, 0xf2, 0x0, 0x7, 0xf2, 0x0, 0x7,
    0xf2, 0x0, 0x7, 0xf2, 0x0, 0x7, 0xf2,

    /* U+038C "Ό" */
    0x17, 0x30, 0x0, 0x0, 0x0, 0x0, 0x7, 0xf1,
    0x19, 0xdf, 0xeb, 0x50, 0x0, 0x86, 0x4f, 0xfe,
    0xbc, 0xff, 0xa0, 0x0, 0x3f, 0xe4, 0x0, 0x1,
    0xaf, 0x90, 0xb, 0xf4, 0x0, 0x0, 0x0, 0xbf,
    0x20, 0xfa, 0x0, 0x0, 0x0, 0x3, 0xf7, 0x3f,
    0x60, 0x0, 0x0, 0x0, 0xf, 0xa3, 0xf6, 0x0,
    0x0, 0x0, 0x0, 0xfa, 0xf, 0x90, 0x0, 0x0,
    0x0, 0x2f, 0x70, 0xbf, 0x20, 0x0, 0x0, 0x9,
    0xf2, 0x2, 0xfd, 0x20, 0x0, 0x7, 0xf9, 0x0,
    0x4, 0xff, 0xa8, 0x9d, 0xfb, 0x0, 0x0, 0x1,
    0x9d, 0xfe, 0xb5, 0x0, 0x0,

    /* U+038E "Ύ" */
    0x3, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6f,
    0x33, 0xf8, 0x0, 0x0, 0x0, 0xdb, 0xba, 0x0,
    0xaf, 0x10, 0x0, 0x6, 0xf2, 0x0, 0x0, 0x1f,
    0x90, 0x0, 0xe, 0x90, 0x0, 0x0, 0x8, 0xf2,
    0x0, 0x8f, 0x10, 0x0, 0x0, 0x0, 0xeb, 0x1,
    0xf7, 0x0, 0x0, 0x0, 0x0, 0x6f, 0x39, 0xe0,
    0x0, 0x0, 0x0, 0x0, 0xd, 0xdf, 0x50, 0x0,
    0x0, 0x0, 0x0, 0x4, 0xfc, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xf8, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xf8, 0x0, 0x0,

    /* U+038F "Ώ" */
    0x17, 0x30, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6,
    0xf2, 0x6, 0xcf, 0xfd, 0x81, 0x0, 0x0, 0x77,
    0x1c, 0xff, 0xcb, 0xef, 0xf4, 0x0, 0x0, 0xb,
    0xf9, 0x0, 0x0, 0x5f, 0xf2, 0x0, 0x4, 0xfb,
    0x0, 0x0, 0x0, 0x4f, 0xa0, 0x0, 0x9f, 0x20,
    0x0, 0x0, 0x0, 0xcf, 0x0, 0xb, 0xe0, 0x0,
    0x0, 0x0, 0x8, 0xf1, 0x0, 0xbe, 0x0, 0x0,
    0x0, 0x0, 0x8f, 0x10, 0x8, 0xf1, 0x0, 0x0,
    0x0, 0xb, 0xe0, 0x0, 0x3f, 0x70, 0x0, 0x0,
    0x2, 0xf9, 0x0, 0x0, 0xaf, 0x40, 0x0, 0x1,
    0xde, 0x10, 0x6, 0x77, 0xff, 0x60, 0x2, 0xef,
    0xa7, 0x71, 0xdf, 0xff, 0xfb, 0x0, 0x5f, 0xff,
    0xff, 0x30,

    /* U+0390 "ΐ" */
    0x0, 0x12, 0x0, 0xc, 0xc0, 0x1, 0xf4, 0xc,
    0x70, 0xc6, 0x84, 0x8, 0x40, 0x0, 0x0, 0x6,
    0xf2, 0x0, 0x6f, 0x20, 0x6, 0xf2, 0x0, 0x6f,
    0x20, 0x6, 0xf2, 0x0, 0x6f, 0x20, 0x6, 0xf2,
    0x0, 0x6f, 0x20, 0x6, 0xf2, 0x0,

    /* U+0391 "Α" */
    0x0, 0x0, 0x2, 0xfd, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x9f, 0xf4, 0x0, 0x0, 0x0, 0x0, 0xf,
    0x9e, 0xb0, 0x0, 0x0, 0x0, 0x6, 0xf2, 0x7f,
    0x20, 0x0, 0x0, 0x0, 0xdc, 0x1, 0xf8, 0x0,
    0x0, 0x0, 0x4f, 0x60, 0xb, 0xe0, 0x0, 0x0,
    0xb, 0xf0, 0x0, 0x4f, 0x60, 0x0, 0x1, 0xfa,
    0x11, 0x11, 0xed, 0x0, 0x0, 0x8f, 0xff, 0xff,
    0xff, 0xf3, 0x0, 0xe, 0xc4, 0x44, 0x44, 0x4f,
    0xa0, 0x6, 0xf4, 0x0, 0x0, 0x0, 0xaf, 0x10,
    0xcd, 0x0, 0x0, 0x0, 0x2, 0xf8,

    /* U+0392 "Β" */
    0x5f, 0xff, 0xff, 0xeb, 0x40, 0x5, 0xf8, 0x55,
    0x57, 0xdf, 0x40, 0x5f, 0x40, 0x0, 0x1, 0xfa,
    0x5, 0xf4, 0x0, 0x0, 0xf, 0xa0, 0x5f, 0x51,
    0x11, 0x3a, 0xf4, 0x5, 0xff, 0xff, 0xff, 0xfa,
    0x0, 0x5f, 0x74, 0x44, 0x59, 0xfa, 0x5, 0xf4,
    0x0, 0x0, 0x8, 0xf2, 0x5f, 0x40, 0x0, 0x0,
    0x5f, 0x45, 0xf4, 0x0, 0x0, 0x9, 0xf2, 0x5f,
    0x86, 0x66, 0x6a, 0xfb, 0x5, 0xff, 0xff, 0xff,
    0xd8, 0x0,

    /* U+0393 "Γ" */
    0x4f, 0xff, 0xff, 0xff, 0x14, 0xf9, 0x77, 0x77,
    0x70, 0x4f, 0x50, 0x0, 0x0, 0x4, 0xf5, 0x0,
    0x0, 0x0, 0x4f, 0x50, 0x0, 0x0, 0x4, 0xf5,
    0x0, 0x0, 0x0, 0x4f, 0x50, 0x0, 0x0, 0x4,
    0xf5, 0x0, 0x0, 0x0, 0x4f, 0x50, 0x0, 0x0,
    0x4, 0xf5, 0x0, 0x0, 0x0, 0x4f, 0x50, 0x0,
    0x0, 0x4, 0xf5, 0x0, 0x0, 0x0,

    /* U+0394 "Δ" */
    0x0, 0x0, 0x2, 0xfd, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x9f, 0xf4, 0x0, 0x0, 0x0, 0x0, 0xf,
    0x8d, 0xb0, 0x0, 0x0, 0x0, 0x6, 0xf2, 0x7f,
    0x20, 0x0, 0x0, 0x0, 0xdb, 0x1, 0xf8, 0x0,
    0x0, 0x0, 0x4f, 0x40, 0x9, 0xe0, 0x0, 0x0,
    0xb, 0xd0, 0x0, 0x3f, 0x60, 0x0, 0x1, 0xf7,
    0x0, 0x0, 0xcd, 0x0, 0x0, 0x8f, 0x10, 0x0,
    0x6, 0xf3, 0x0, 0xe, 0xa0, 0x0, 0x0, 0xf,
    0xa0, 0x6, 0xfa, 0x77, 0x77, 0x77, 0xdf, 0x10,
    0xcf, 0xff, 0xff, 0xff, 0xff, 0xf8,

    /* U+0395 "Ε" */
    0x5f, 0xff, 0xff, 0xff, 0x95, 0xf9, 0x77, 0x77,
    0x74, 0x5f, 0x40, 0x0, 0x0, 0x5, 0xf4, 0x0,
    0x0, 0x0, 0x5f, 0x51, 0x11, 0x11, 0x5, 0xff,
    0xff, 0xff, 0xe0, 0x5f, 0x74, 0x44, 0x44, 0x5,
    0xf4, 0x0, 0x0, 0x0, 0x5f, 0x40, 0x0, 0x0,
    0x5, 0xf4, 0x0, 0x0, 0x0, 0x5f, 0x97, 0x77,
    0x77, 0x65, 0xff, 0xff, 0xff, 0xfd,

    /* U+0396 "Ζ" */
    0x3f, 0xff, 0xff, 0xff, 0xfd, 0x1, 0x77, 0x77,
    0x77, 0xbf, 0x90, 0x0, 0x0, 0x0, 0x1e, 0xc0,
    0x0, 0x0, 0x0, 0xc, 0xf2, 0x0, 0x0, 0x0,
    0x8, 0xf5, 0x0, 0x0, 0x0, 0x4, 0xf9, 0x0,
    0x0, 0x0, 0x1, 0xec, 0x0, 0x0, 0x0, 0x0,
    0xcf, 0x20, 0x0, 0x0, 0x0, 0x8f, 0x50, 0x0,
    0x0, 0x0, 0x4f, 0x90, 0x0, 0x0, 0x0, 0x1e,
    0xf7, 0x77, 0x77, 0x77, 0x5, 0xff, 0xff, 0xff,
    0xff, 0xf0,

    /* U+0397 "Η" */
    0x5f, 0x40, 0x0, 0x0, 0x4f, 0x55, 0xf4, 0x0,
    0x0, 0x4, 0xf5, 0x5f, 0x40, 0x0, 0x0, 0x4f,
    0x55, 0xf4, 0x0, 0x0, 0x4, 0xf5, 0x5f, 0x52,
    0x22, 0x22, 0x5f, 0x55, 0xff, 0xff, 0xff, 0xff,
    0xf5, 0x5f, 0x85, 0x55, 0x55, 0x8f, 0x55, 0xf4,
    0x0, 0x0, 0x4, 0xf5, 0x5f, 0x40, 0x0, 0x0,
    0x4f, 0x55, 0xf4, 0x0, 0x0, 0x4, 0xf5, 0x5f,
    0x40, 0x0, 0x0, 0x4f, 0x55, 0xf4, 0x0, 0x0,
    0x4, 0xf5,

    /* U+0398 "Θ" */
    0x0, 0x1, 0x9d, 0xfe, 0xb5, 0x0, 0x0, 0x4,
    0xff, 0xb8, 0x9d, 0xfa, 0x0, 0x3, 0xfd, 0x20,
    0x0, 0x8, 0xf9, 0x0, 0xbf, 0x20, 0x0, 0x0,
    0xa, 0xf2, 0xf, 0x90, 0x0, 0x0, 0x0, 0x2f,
    0x73, 0xf6, 0x7f, 0xff, 0xff, 0xf0, 0xfa, 0x3f,
    0x64, 0x88, 0x88, 0x88, 0xf, 0xa0, 0xf9, 0x0,
    0x0, 0x0, 0x2, 0xf7, 0xb, 0xf2, 0x0, 0x0,
    0x0, 0xaf, 0x20, 0x2f, 0xd2, 0x0, 0x0, 0x8f,
    0x90, 0x0, 0x4f, 0xfa, 0x89, 0xdf, 0xb0, 0x0,
    0x0, 0x19, 0xdf, 0xeb, 0x50, 0x0,

    /* U+0399 "Ι" */
    0x5f, 0x45, 0xf4, 0x5f, 0x45, 0xf4, 0x5f, 0x45,
    0xf4, 0x5f, 0x45, 0xf4, 0x5f, 0x45, 0xf4, 0x5f,
    0x45, 0xf4,

    /* U+039A "Κ" */
    0x5f, 0x40, 0x0, 0x2, 0xeb, 0x5, 0xf4, 0x0,
    0x1, 0xec, 0x0, 0x5f, 0x40, 0x1, 0xde, 0x10,
    0x5, 0xf4, 0x0, 0xce, 0x20, 0x0, 0x5f, 0x40,
    0xbf, 0x30, 0x0, 0x5, 0xf4, 0x9f, 0x90, 0x0,
    0x0, 0x5f, 0xcf, 0xef, 0x40, 0x0, 0x5, 0xff,
    0x81, 0xee, 0x10, 0x0, 0x5f, 0xa0, 0x3, 0xfc,
    0x0, 0x5, 0xf4, 0x0, 0x6, 0xf8, 0x0, 0x5f,
    0x40, 0x0, 0x9, 0xf5, 0x5, 0xf4, 0x0, 0x0,
    0xc, 0xf2,

    /* U+039B "Λ" */
    0x0, 0x0, 0x2, 0xfd, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x9f, 0xf4, 0x0, 0x0, 0x0, 0x0, 0xf,
    0x8d, 0xb0, 0x0, 0x0, 0x0, 0x6, 0xf2, 0x7f,
    0x20, 0x0, 0x0, 0x0, 0xdb, 0x1, 0xf8, 0x0,
    0x0, 0x0, 0x4f, 0x40, 0x9, 0xe0, 0x0, 0x0,
    0xb, 0xe0, 0x0, 0x3f, 0x60, 0x0, 0x1, 0xf7,
    0x0, 0x0, 0xcd, 0x0, 0x0, 0x8f, 0x10, 0x0,
    0x6, 0xf3, 0x0, 0xe, 0xa0, 0x0, 0x0, 0xf,
    0xa0, 0x6, 0xf3, 0x0, 0x0, 0x0, 0x9f, 0x10,
    0xcd, 0x0, 0x0, 0x0, 0x2, 0xf8,

    /* U+039C "Μ" */
    0x5f, 0x40, 0x0, 0x0, 0x0, 0x1e, 0x95, 0xfc,
    0x0, 0x0, 0x0, 0x8, 0xf9, 0x5f, 0xf5, 0x0,
    0x0, 0x2, 0xff, 0x95, 0xfd, 0xe0, 0x0, 0x0,
    0xad, 0xf9, 0x5f, 0x5f, 0x70, 0x0, 0x3f, 0x5f,
    0x95, 0xf3, 0x8f, 0x10, 0xb, 0xc0, 0xf9, 0x5f,
    0x31, 0xe9, 0x4, 0xf3, 0xf, 0x95, 0xf3, 0x7,
    0xf2, 0xda, 0x0, 0xf9, 0x5f, 0x30, 0xd, 0xef,
    0x20, 0xf, 0x95, 0xf3, 0x0, 0x5f, 0x90, 0x0,
    0xf9, 0x5f, 0x30, 0x0, 0x71, 0x0, 0xf, 0x95,
    0xf3, 0x0, 0x0, 0x0, 0x0, 0xf9,

    /* U+039D "Ν" */
    0x5f, 0x50, 0x0, 0x0, 0x4f, 0x55, 0xff, 0x20,
    0x0, 0x4, 0xf5, 0x5f, 0xfd, 0x0, 0x0, 0x4f,
    0x55, 0xfa, 0xf9, 0x0, 0x4, 0xf5, 0x5f, 0x4a,
    0xf5, 0x0, 0x4f, 0x55, 0xf4, 0xd, 0xf2, 0x4,
    0xf5, 0x5f, 0x40, 0x2f, 0xd0, 0x4f, 0x55, 0xf4,
    0x0, 0x6f, 0x94, 0xf5, 0x5f, 0x40, 0x0, 0xaf,
    0xaf, 0x55, 0xf4, 0x0, 0x0, 0xdf, 0xf5, 0x5f,
    0x40, 0x0, 0x2, 0xff, 0x55, 0xf4, 0x0, 0x0,
    0x6, 0xf5,

    /* U+039E "Ξ" */
    0x1f, 0xff, 0xff, 0xff, 0xff, 0x20, 0x77, 0x77,
    0x77, 0x77, 0x70, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x11,
    0x11, 0x11, 0x10, 0x0, 0xf, 0xff, 0xff, 0xff,
    0x0, 0x0, 0x44, 0x44, 0x44, 0x40, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x27,
    0x77, 0x77, 0x77, 0x77, 0x25, 0xff, 0xff, 0xff,
    0xff, 0xf5,

    /* U+039F "Ο" */
    0x0, 0x1, 0x9d, 0xfe, 0xb5, 0x0, 0x0, 0x4,
    0xff, 0xb8, 0x9d, 0xfa, 0x0, 0x3, 0xfd, 0x20,
    0x0, 0x8, 0xf9, 0x0, 0xbf, 0x20, 0x0, 0x0,
    0xa, 0xf2, 0xf, 0x90, 0x0, 0x0, 0x0, 0x2f,
    0x73, 0xf6, 0x0, 0x0, 0x0, 0x0, 0xfa, 0x3f,
    0x60, 0x0, 0x0, 0x0, 0xf, 0xa0, 0xf9, 0x0,
    0x0, 0x0, 0x2, 0xf7, 0xb, 0xf2, 0x0, 0x0,
    0x0, 0xaf, 0x20, 0x2f, 0xd2, 0x0, 0x0, 0x8f,
    0x90, 0x0, 0x4f, 0xfa, 0x89, 0xdf, 0xb0, 0x0,
    0x0, 0x19, 0xdf, 0xeb, 0x50, 0x0,

    /* U+03A0 "Π" */
    0x4f, 0xff, 0xff, 0xff, 0xff, 0x64, 0xfa, 0x77,
    0x77, 0x78, 0xf6, 0x4f, 0x50, 0x0, 0x0, 0x2f,
    0x64, 0xf5, 0x0, 0x0, 0x2, 0xf6, 0x4f, 0x50,
    0x0, 0x0, 0x2f, 0x64, 0xf5, 0x0, 0x0, 0x2,
    0xf6, 0x4f, 0x50, 0x0, 0x0, 0x2f, 0x64, 0xf5,
    0x0, 0x0, 0x2, 0xf6, 0x4f, 0x50, 0x0, 0x0,
    0x2f, 0x64, 0xf5, 0x0, 0x0, 0x2, 0xf6, 0x4f,
    0x50, 0x0, 0x0, 0x2f, 0x64, 0xf5, 0x0, 0x0,
    0x2, 0xf6,

    /* U+03A1 "Ρ" */
    0x5f, 0xff, 0xff, 0xd7, 0x0, 0x5f, 0x97, 0x78,
    0xbf, 0xc0, 0x5f, 0x40, 0x0, 0x7, 0xf6, 0x5f,
    0x40, 0x0, 0x0, 0xfa, 0x5f, 0x40, 0x0, 0x0,
    0xea, 0x5f, 0x40, 0x0, 0x3, 0xf8, 0x5f, 0x62,
    0x23, 0x6e, 0xe1, 0x5f, 0xff, 0xff, 0xfc, 0x30,
    0x5f, 0x85, 0x54, 0x20, 0x0, 0x5f, 0x40, 0x0,
    0x0, 0x0, 0x5f, 0x40, 0x0, 0x0, 0x0, 0x5f,
    0x40, 0x0, 0x0, 0x0,

    /* U+03A3 "Σ" */
    0x4f, 0xff, 0xff, 0xff, 0xf4, 0x2f, 0xfb, 0x99,
    0x99, 0x92, 0x4, 0xfc, 0x0, 0x0, 0x0, 0x0,
    0x6f, 0xb0, 0x0, 0x0, 0x0, 0x8, 0xf9, 0x0,
    0x0, 0x0, 0x0, 0x9f, 0x70, 0x0, 0x0, 0x0,
    0xaf, 0x70, 0x0, 0x0, 0x8, 0xfa, 0x0, 0x0,
    0x0, 0x6f, 0xb0, 0x0, 0x0, 0x4, 0xfc, 0x0,
    0x0, 0x0, 0x2f, 0xfb, 0x99, 0x99, 0x92, 0x4f,
    0xff, 0xff, 0xff, 0xf4,

    /* U+03A4 "Τ" */
    0xff, 0xff, 0xff, 0xff, 0xf5, 0x67, 0x78, 0xfb,
    0x77, 0x72, 0x0, 0x1, 0xf7, 0x0, 0x0, 0x0,
    0x1, 0xf7, 0x0, 0x0, 0x0, 0x1, 0xf7, 0x0,
    0x0, 0x0, 0x1, 0xf7, 0x0, 0x0, 0x0, 0x1,
    0xf7, 0x0, 0x0, 0x0, 0x1, 0xf7, 0x0, 0x0,
    0x0, 0x1, 0xf7, 0x0, 0x0, 0x0, 0x1, 0xf7,
    0x0, 0x0, 0x0, 0x1, 0xf7, 0x0, 0x0, 0x0,
    0x1, 0xf7, 0x0, 0x0,

    /* U+03A5 "Υ" */
    0xc, 0xe0, 0x0, 0x0, 0x7, 0xf2, 0x3, 0xf7,
    0x0, 0x0, 0x1f, 0x90, 0x0, 0xaf, 0x10, 0x0,
    0x9e, 0x10, 0x0, 0x1f, 0xa0, 0x2, 0xf6, 0x0,
    0x0, 0x8, 0xf3, 0xb, 0xd0, 0x0, 0x0, 0x0,
    0xec, 0x4f, 0x40, 0x0, 0x0, 0x0, 0x5f, 0xfb,
    0x0, 0x0, 0x0, 0x0, 0xc, 0xf2, 0x0, 0x0,
    0x0, 0x0, 0x9, 0xf0, 0x0, 0x0, 0x0, 0x0,
    0x9, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x9, 0xf0,
    0x0, 0x0, 0x0, 0x0, 0x9, 0xf0, 0x0, 0x0,

    /* U+03A6 "Φ" */
    0x0, 0x0, 0x0, 0x95, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xe9, 0x0, 0x0, 0x0, 0x0, 0x3a,
    0xef, 0xff, 0xfd, 0x91, 0x0, 0x8, 0xfc, 0x74,
    0xeb, 0x58, 0xef, 0x40, 0x5f, 0x80, 0x0, 0xe9,
    0x0, 0x1c, 0xe0, 0xbe, 0x0, 0x0, 0xe9, 0x0,
    0x3, 0xf5, 0xdb, 0x0, 0x0, 0xe9, 0x0, 0x0,
    0xf7, 0xbd, 0x0, 0x0, 0xe9, 0x0, 0x2, 0xf6,
    0x6f, 0x60, 0x0, 0xe9, 0x0, 0xa, 0xf1, 0xb,
    0xf9, 0x31, 0xe9, 0x25, 0xcf, 0x60, 0x0, 0x6d,
    0xff, 0xff, 0xff, 0xc4, 0x0, 0x0, 0x0, 0x13,
    0xea, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0xe9,
    0x0, 0x0, 0x0,

    /* U+03A7 "Χ" */
    0x3f, 0x90, 0x0, 0x0, 0xcd, 0x0, 0x8f, 0x40,
    0x0, 0x7f, 0x40, 0x0, 0xde, 0x10, 0x2f, 0x80,
    0x0, 0x2, 0xfa, 0xd, 0xd0, 0x0, 0x0, 0x7,
    0xfc, 0xf3, 0x0, 0x0, 0x0, 0xc, 0xf8, 0x0,
    0x0, 0x0, 0x1, 0xef, 0xc0, 0x0, 0x0, 0x0,
    0xbf, 0x7f, 0x70, 0x0, 0x0, 0x6f, 0x60, 0xaf,
    0x20, 0x0, 0x2f, 0xb0, 0x1, 0xed, 0x0, 0xc,
    0xf1, 0x0, 0x4, 0xf8, 0x7, 0xf6, 0x0, 0x0,
    0x9, 0xf3,

    /* U+03A8 "Ψ" */
    0x0, 0x0, 0x0, 0x95, 0x0, 0x0, 0x0, 0xdb,
    0x0, 0x0, 0xe9, 0x0, 0x1, 0xf7, 0xdb, 0x0,
    0x0, 0xe9, 0x0, 0x1, 0xf7, 0xdb, 0x0, 0x0,
    0xe9, 0x0, 0x1, 0xf7, 0xdb, 0x0, 0x0, 0xe9,
    0x0, 0x1, 0xf6, 0xbe, 0x0, 0x0, 0xe9, 0x0,
    0x3, 0xf4, 0x6f, 0x30, 0x0, 0xe9, 0x0, 0x9,
    0xf0, 0x1e, 0xc0, 0x0, 0xe9, 0x0, 0x2f, 0xa0,
    0x4, 0xfc, 0x41, 0xe9, 0x27, 0xfd, 0x10, 0x0,
    0x3c, 0xff, 0xff, 0xff, 0x91, 0x0, 0x0, 0x0,
    0x13, 0xfa, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xe9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xe9,
    0x0, 0x0, 0x0,

    /* U+03A9 "Ω" */
    0x0, 0x0, 0x6c, 0xff, 0xd8, 0x10, 0x0, 0x0,
    0x1, 0xcf, 0xd9, 0x8b, 0xff, 0x40, 0x0, 0x0,
    0xbf, 0x60, 0x0, 0x2, 0xdf, 0x20, 0x0, 0x4f,
    0x90, 0x0, 0x0, 0x2, 0xfa, 0x0, 0x9, 0xf1,
    0x0, 0x0, 0x0, 0xb, 0xf0, 0x0, 0xbe, 0x0,
    0x0, 0x0, 0x0, 0x8f, 0x10, 0xb, 0xe0, 0x0,
    0x0, 0x0, 0x8, 0xf1, 0x0, 0x8f, 0x10, 0x0,
    0x0, 0x0, 0xbe, 0x0, 0x3, 0xf8, 0x0, 0x0,
    0x0, 0x2f, 0x90, 0x0, 0xa, 0xf4, 0x0, 0x0,
    0x1d, 0xe1, 0x0, 0x67, 0x7f, 0xf6, 0x0, 0x2e,
    0xfa, 0x77, 0x1d, 0xff, 0xff, 0xb0, 0x5, 0xff,
    0xff, 0xf3,

    /* U+03AA "Ϊ" */
    0x57, 0x5, 0x68, 0xb0, 0x9a, 0x0, 0x0, 0x0,
    0x2f, 0x70, 0x2, 0xf7, 0x0, 0x2f, 0x70, 0x2,
    0xf7, 0x0, 0x2f, 0x70, 0x2, 0xf7, 0x0, 0x2f,
    0x70, 0x2, 0xf7, 0x0, 0x2f, 0x70, 0x2, 0xf7,
    0x0, 0x2f, 0x70, 0x2, 0xf7, 0x0,

    /* U+03AB "Ϋ" */
    0x0, 0x0, 0xd5, 0xd, 0x50, 0x0, 0x0, 0x0,
    0x93, 0x9, 0x30, 0x0, 0xc, 0xe0, 0x0, 0x0,
    0x7, 0xf2, 0x3, 0xf7, 0x0, 0x0, 0x1f, 0x90,
    0x0, 0xaf, 0x10, 0x0, 0x9e, 0x10, 0x0, 0x1f,
    0xa0, 0x2, 0xf6, 0x0, 0x0, 0x8, 0xf3, 0xb,
    0xd0, 0x0, 0x0, 0x0, 0xec, 0x4f, 0x40, 0x0,
    0x0, 0x0, 0x5f, 0xfb, 0x0, 0x0, 0x0, 0x0,
    0xc, 0xf2, 0x0, 0x0, 0x0, 0x0, 0x9, 0xf0,
    0x0, 0x0, 0x0, 0x0, 0x9, 0xf0, 0x0, 0x0,
    0x0, 0x0, 0x9, 0xf0, 0x0, 0x0, 0x0, 0x0,
    0x9, 0xf0, 0x0, 0x0,

    /* U+03AC "ά" */
    0x0, 0x0, 0x0, 0x22, 0x0, 0x0, 0x0, 0x2,
    0xf6, 0x0, 0x0, 0x0, 0x7, 0xd0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x2a, 0xef, 0xb2,
    0xf9, 0x3, 0xfe, 0x87, 0xce, 0xf9, 0xc, 0xe1,
    0x0, 0x9, 0xf9, 0x1f, 0x80, 0x0, 0x1, 0xf9,
    0x2f, 0x60, 0x0, 0x0, 0xf9, 0x1f, 0x80, 0x0,
    0x1, 0xf9, 0xc, 0xe1, 0x0, 0x9, 0xf9, 0x3,
    0xfe, 0x87, 0xce, 0xf9, 0x0, 0x2b, 0xef, 0xb2,
    0xe9,

    /* U+03AD "έ" */
    0x0, 0x0, 0x3, 0x10, 0x0, 0x0, 0x5, 0xf3,
    0x0, 0x0, 0x0, 0xab, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x7d, 0xfe, 0xc7, 0x0, 0x8f,
    0x95, 0x58, 0xa0, 0xe, 0xb0, 0x0, 0x0, 0x0,
    0xce, 0x20, 0x0, 0x0, 0x3, 0xff, 0xff, 0xc0,
    0x1, 0xeb, 0x43, 0x32, 0x0, 0x4f, 0x50, 0x0,
    0x1, 0x0, 0xee, 0x86, 0x69, 0xf3, 0x2, 0x9d,
    0xff, 0xc7, 0x0,

    /* U+03AE "ή" */
    0x0, 0x0, 0x8f, 0x20, 0x0, 0x0, 0xd, 0x90,
    0x0, 0x0, 0x0, 0x20, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x8e, 0x2b, 0xff, 0xb2, 0x8, 0xfe,
    0xb7, 0x9f, 0xe0, 0x8f, 0x80, 0x0, 0x6f, 0x58,
    0xf1, 0x0, 0x1, 0xf7, 0x8f, 0x0, 0x0, 0xf,
    0x88, 0xf0, 0x0, 0x0, 0xf8, 0x8f, 0x0, 0x0,
    0xf, 0x88, 0xf0, 0x0, 0x0, 0xf8, 0x8f, 0x0,
    0x0, 0xf, 0x80, 0x0, 0x0, 0x0, 0xf8, 0x0,
    0x0, 0x0, 0xf, 0x80, 0x0, 0x0, 0x0, 0xf8,

    /* U+03AF "ί" */
    0x2, 0x20, 0xe, 0xa0, 0x3f, 0x20, 0x0, 0x0,
    0x8f, 0x0, 0x8f, 0x0, 0x8f, 0x0, 0x8f, 0x0,
    0x8f, 0x0, 0x8f, 0x0, 0x8f, 0x0, 0x8f, 0x0,
    0x8f, 0x0,

    /* U+03B0 "ΰ" */
    0x0, 0x0, 0x13, 0x10, 0x0, 0x0, 0x8, 0xf1,
    0x0, 0x0, 0x0, 0xd7, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x8b, 0x9, 0xa0, 0x0, 0x5,
    0x70, 0x57, 0x0, 0x0, 0x0, 0x0, 0x0, 0xa,
    0xe0, 0x0, 0x2, 0xf5, 0xae, 0x0, 0x0, 0x2f,
    0x5a, 0xe0, 0x0, 0x2, 0xf5, 0xae, 0x0, 0x0,
    0x2f, 0x59, 0xe0, 0x0, 0x2, 0xf5, 0x8f, 0x0,
    0x0, 0x4f, 0x45, 0xf6, 0x0, 0x9, 0xf1, 0xc,
    0xf9, 0x7b, 0xf9, 0x0, 0x19, 0xef, 0xd7, 0x0,

    /* U+03B1 "α" */
    0x0, 0x2a, 0xef, 0xb2, 0xf9, 0x3, 0xfe, 0x87,
    0xbe, 0xf9, 0xc, 0xe1, 0x0, 0x9, 0xf9, 0x1f,
    0x80, 0x0, 0x1, 0xf9, 0x2f, 0x60, 0x0, 0x0,
    0xf9, 0x1f, 0x80, 0x0, 0x1, 0xf9, 0xc, 0xe1,
    0x0, 0x9, 0xf9, 0x3, 0xfe, 0x87, 0xbe, 0xf9,
    0x0, 0x2a, 0xef, 0xb2, 0xe9,

    /* U+03B2 "β" */
    0x0, 0x5c, 0xef, 0xb1, 0x0, 0x8, 0xfd, 0x77,
    0xfc, 0x0, 0x3f, 0xa0, 0x0, 0xaf, 0x0, 0x9f,
    0x10, 0x2, 0xfc, 0x0, 0xbd, 0x0, 0x1e, 0xe2,
    0x0, 0xcc, 0x1, 0xdf, 0xea, 0x10, 0xcc, 0xc,
    0xf7, 0x8f, 0xd0, 0xcc, 0xaf, 0x30, 0x6, 0xf3,
    0xcf, 0xf3, 0x0, 0x5, 0xf4, 0xcf, 0x40, 0x0,
    0xb, 0xf1, 0xcf, 0xfa, 0x78, 0xdf, 0xa0, 0xcd,
    0x9d, 0xff, 0xd8, 0x0, 0xcc, 0x0, 0x0, 0x0,
    0x0, 0xcc, 0x0, 0x0, 0x0, 0x0, 0xcc, 0x0,
    0x0, 0x0, 0x0,

    /* U+03B3 "γ" */
    0x2f, 0x80, 0x0, 0x2, 0xf7, 0xa, 0xe0, 0x0,
    0x9, 0xf0, 0x3, 0xf6, 0x0, 0xf, 0x80, 0x0,
    0xcd, 0x0, 0x7f, 0x10, 0x0, 0x5f, 0x40, 0xda,
    0x0, 0x0, 0xd, 0xb5, 0xf2, 0x0, 0x0, 0x6,
    0xfd, 0xb0, 0x0, 0x0, 0x0, 0xef, 0x40, 0x0,
    0x0, 0x0, 0xae, 0x0, 0x0, 0x0, 0x0, 0xae,
    0x0, 0x0, 0x0, 0x0, 0xae, 0x0, 0x0, 0x0,
    0x0, 0xae, 0x0, 0x0,

    /* U+03B4 "δ" */
    0x0, 0x8, 0xdf, 0xeb, 0x40, 0x0, 0x9f, 0x96,
    0x8c, 0x50, 0x0, 0xdb, 0x0, 0x0, 0x0, 0x0,
    0x7f, 0xc8, 0x50, 0x0, 0x0, 0x6f, 0xfd, 0xfe,
    0x40, 0x4, 0xf8, 0x0, 0x1b, 0xf2, 0xd, 0xc0,
    0x0, 0x1, 0xf9, 0xf, 0x80, 0x0, 0x0, 0xdb,
    0xf, 0xa0, 0x0, 0x0, 0xeb, 0xa, 0xf2, 0x0,
    0x6, 0xf6, 0x1, 0xef, 0x97, 0xaf, 0xb0, 0x0,
    0x19, 0xef, 0xd7, 0x0,

    /* U+03B5 "ε" */
    0x0, 0x7d, 0xfe, 0xc7, 0x0, 0x8f, 0x95, 0x58,
    0xa0, 0xe, 0xb0, 0x0, 0x0, 0x0, 0xce, 0x20,
    0x0, 0x0, 0x3, 0xff, 0xff, 0xc0, 0x1, 0xeb,
    0x43, 0x32, 0x0, 0x4f, 0x50, 0x0, 0x1, 0x0,
    0xee, 0x86, 0x69, 0xf3, 0x2, 0x9d, 0xff, 0xc7,
    0x0,

    /* U+03B6 "ζ" */
    0x7f, 0xff, 0xff, 0xe3, 0x77, 0x7a, 0xfc, 0x0,
    0x1, 0xef, 0x20, 0x0, 0xbf, 0x50, 0x0, 0x6f,
    0x90, 0x0, 0x1f, 0xd0, 0x0, 0xa, 0xf3, 0x0,
    0x2, 0xfa, 0x0, 0x0, 0x9f, 0x30, 0x0, 0xc,
    0xf2, 0x0, 0x0, 0x8f, 0xea, 0x85, 0x0, 0x9e,
    0xff, 0xf6, 0x0, 0x0, 0x3f, 0xa0, 0x0, 0x0,
    0xf8, 0x0, 0x0, 0x6f, 0x40,

    /* U+03B7 "η" */
    0x8e, 0x2b, 0xff, 0xb2, 0x8, 0xfe, 0xb7, 0x9f,
    0xe0, 0x8f, 0x80, 0x0, 0x6f, 0x58, 0xf1, 0x0,
    0x1, 0xf7, 0x8f, 0x0, 0x0, 0xf, 0x88, 0xf0,
    0x0, 0x0, 0xf8, 0x8f, 0x0, 0x0, 0xf, 0x88,
    0xf0, 0x0, 0x0, 0xf8, 0x8f, 0x0, 0x0, 0xf,
    0x80, 0x0, 0x0, 0x0, 0xf8, 0x0, 0x0, 0x0,
    0xf, 0x80, 0x0, 0x0, 0x0, 0xf8,

    /* U+03B8 "θ" */
    0x0, 0x6, 0xcf, 0xeb, 0x30, 0x0, 0xa, 0xfc,
    0x89, 0xef, 0x50, 0x6, 0xf9, 0x0, 0x1, 0xdf,
    0x20, 0xdf, 0x0, 0x0, 0x4, 0xf8, 0x1f, 0x90,
    0x0, 0x0, 0xe, 0xc3, 0xfc, 0x88, 0x88, 0x88,
    0xee, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xe1, 0xf7,
    0x0, 0x0, 0x0, 0xcc, 0xd, 0xd0, 0x0, 0x0,
    0x2f, 0x80, 0x6f, 0x70, 0x0, 0xb, 0xf2, 0x0,
    0xaf, 0xc8, 0x9d, 0xf6, 0x0, 0x0, 0x6c, 0xff,
    0xb4, 0x0,

    /* U+03B9 "ι" */
    0x8f, 0x8, 0xf0, 0x8f, 0x8, 0xf0, 0x8f, 0x8,
    0xf0, 0x8f, 0x8, 0xf0, 0x8f, 0x0,

    /* U+03BA "κ" */
    0x8f, 0x0, 0x1, 0xde, 0x18, 0xf0, 0x1, 0xde,
    0x20, 0x8f, 0x1, 0xde, 0x20, 0x8, 0xf1, 0xdf,
    0x30, 0x0, 0x8f, 0xdf, 0xf7, 0x0, 0x8, 0xfe,
    0x3b, 0xf3, 0x0, 0x8f, 0x20, 0x1e, 0xe1, 0x8,
    0xf0, 0x0, 0x3f, 0xb0, 0x8f, 0x0, 0x0, 0x7f,
    0x70,

    /* U+03BB "λ" */
    0x1a, 0xee, 0x70, 0x0, 0x0, 0xc, 0x79, 0xf6,
    0x0, 0x0, 0x0, 0x0, 0xad, 0x0, 0x0, 0x0,
    0x0, 0x6f, 0x40, 0x0, 0x0, 0x0, 0xcf, 0xb0,
    0x0, 0x0, 0x3, 0xfa, 0xf2, 0x0, 0x0, 0xa,
    0xe0, 0xd9, 0x0, 0x0, 0x1f, 0x70, 0x7f, 0x10,
    0x0, 0x8f, 0x10, 0xf, 0x70, 0x0, 0xea, 0x0,
    0x9, 0xe0, 0x5, 0xf3, 0x0, 0x2, 0xf5, 0xc,
    0xc0, 0x0, 0x0, 0xbc,

    /* U+03BC "μ" */
    0xae, 0x0, 0x0, 0x2f, 0x6a, 0xe0, 0x0, 0x2,
    0xf6, 0xae, 0x0, 0x0, 0x2f, 0x6a, 0xe0, 0x0,
    0x2, 0xf6, 0xae, 0x0, 0x0, 0x2f, 0x6a, 0xf0,
    0x0, 0x4, 0xf6, 0xaf, 0x30, 0x0, 0xaf, 0x6a,
    0xfe, 0x76, 0xaf, 0xf6, 0xae, 0x8e, 0xfb, 0x4f,
    0x6a, 0xe0, 0x0, 0x0, 0x0, 0xae, 0x0, 0x0,
    0x0, 0xa, 0xe0, 0x0, 0x0, 0x0,

    /* U+03BD "ν" */
    0x5f, 0x40, 0x0, 0x3, 0xf4, 0xe, 0xa0, 0x0,
    0xa, 0xd0, 0x7, 0xf1, 0x0, 0x1f, 0x60, 0x1,
    0xf7, 0x0, 0x7f, 0x10, 0x0, 0xae, 0x0, 0xe9,
    0x0, 0x0, 0x4f, 0x45, 0xf3, 0x0, 0x0, 0xd,
    0xbb, 0xc0, 0x0, 0x0, 0x7, 0xff, 0x50, 0x0,
    0x0, 0x1, 0xfe, 0x0, 0x0,

    /* U+03BE "ξ" */
    0x2f, 0xff, 0xff, 0xe0, 0x19, 0xef, 0xca, 0x80,
    0x9, 0xf3, 0x0, 0x0, 0xe, 0xd0, 0x0, 0x0,
    0xd, 0xf5, 0x0, 0x0, 0x3, 0xcf, 0xff, 0x40,
    0x9, 0xfe, 0xcb, 0x30, 0x4f, 0x80, 0x0, 0x0,
    0x6f, 0x10, 0x0, 0x0, 0x5f, 0x40, 0x0, 0x0,
    0x1f, 0xfb, 0x96, 0x0, 0x3, 0xcf, 0xff, 0xa0,
    0x0, 0x0, 0x1e, 0xd0, 0x0, 0x0, 0xd, 0xb0,
    0x0, 0x0, 0x2f, 0x70,

    /* U+03BF "ο" */
    0x0, 0x3b, 0xef, 0xc4, 0x0, 0x4, 0xfd, 0x87,
    0xcf, 0x60, 0xd, 0xd0, 0x0, 0xb, 0xf1, 0x3f,
    0x50, 0x0, 0x3, 0xf5, 0x4f, 0x30, 0x0, 0x1,
    0xf7, 0x3f, 0x60, 0x0, 0x3, 0xf5, 0xd, 0xd0,
    0x0, 0xb, 0xf1, 0x4, 0xfd, 0x87, 0xcf, 0x60,
    0x0, 0x3b, 0xef, 0xc4, 0x0,

    /* U+03C0 "π" */
    0xbf, 0xff, 0xff, 0xff, 0x5b, 0xe5, 0x55, 0x57,
    0xf5, 0xbd, 0x0, 0x0, 0x2f, 0x5b, 0xd0, 0x0,
    0x2, 0xf5, 0xbd, 0x0, 0x0, 0x2f, 0x5b, 0xd0,
    0x0, 0x2, 0xf5, 0xbd, 0x0, 0x0, 0x2f, 0x5b,
    0xd0, 0x0, 0x2, 0xf5, 0xbd, 0x0, 0x0, 0x2f,
    0x50,

    /* U+03C1 "ρ" */
    0x0, 0x2a, 0xef, 0xc5, 0x0, 0x2, 0xfe, 0x87,
    0xbf, 0x80, 0xc, 0xe1, 0x0, 0x9, 0xf2, 0x1f,
    0x80, 0x0, 0x1, 0xf7, 0x3f, 0x50, 0x0, 0x0,
    0xf9, 0x3f, 0x80, 0x0, 0x1, 0xf7, 0x3f, 0xe1,
    0x0, 0x9, 0xf2, 0x3f, 0xfe, 0x87, 0xbf, 0x80,
    0x3f, 0x6a, 0xef, 0xc5, 0x0, 0x3f, 0x40, 0x0,
    0x0, 0x0, 0x3f, 0x40, 0x0, 0x0, 0x0, 0x3f,
    0x40, 0x0, 0x0, 0x0,

    /* U+03C2 "ς" */
    0x3, 0xbf, 0xfd, 0x91, 0x1f, 0xd7, 0x69, 0xd0,
    0x4f, 0x30, 0x0, 0x0, 0x2f, 0xc4, 0x10, 0x0,
    0x5, 0xef, 0xfd, 0x60, 0x0, 0x2, 0x5b, 0xf5,
    0x1, 0x0, 0x0, 0xf8, 0x5f, 0xa7, 0x6b, 0xf3,
    0x18, 0xdf, 0xfc, 0x40,

    /* U+03C3 "σ" */
    0x0, 0x3b, 0xef, 0xff, 0xff, 0x20, 0x4f, 0xb4,
    0x39, 0xf9, 0x30, 0xd, 0xb0, 0x0, 0x9, 0xf1,
    0x3, 0xf5, 0x0, 0x0, 0x2f, 0x50, 0x4f, 0x30,
    0x0, 0x1, 0xf7, 0x3, 0xf6, 0x0, 0x0, 0x3f,
    0x50, 0xd, 0xd1, 0x0, 0xb, 0xf1, 0x0, 0x4f,
    0xe8, 0x7c, 0xf6, 0x0, 0x0, 0x3b, 0xef, 0xc4,
    0x0, 0x0,

    /* U+03C4 "τ" */
    0xbf, 0xff, 0xff, 0xff, 0x53, 0x55, 0xaf, 0x65,
    0x51, 0x0, 0x7, 0xf1, 0x0, 0x0, 0x0, 0x7f,
    0x10, 0x0, 0x0, 0x7, 0xf1, 0x0, 0x0, 0x0,
    0x7f, 0x10, 0x0, 0x0, 0x7, 0xf1, 0x0, 0x0,
    0x0, 0x7f, 0x10, 0x0, 0x0, 0x7, 0xf1, 0x0,
    0x0,

    /* U+03C5 "υ" */
    0x9e, 0x0, 0x0, 0x2f, 0x59, 0xe0, 0x0, 0x2,
    0xf5, 0x9e, 0x0, 0x0, 0x2f, 0x59, 0xe0, 0x0,
    0x2, 0xf5, 0x9e, 0x0, 0x0, 0x2f, 0x58, 0xf0,
    0x0, 0x4, 0xf4, 0x5f, 0x60, 0x0, 0x9f, 0x10,
    0xcf, 0x97, 0xbf, 0x90, 0x1, 0x9e, 0xfd, 0x70,
    0x0,

    /* U+03C6 "φ" */
    0x0, 0x0, 0x3, 0x80, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x6f, 0x10, 0x0, 0x0, 0x0, 0x0, 0x6,
    0xf1, 0x0, 0x0, 0x0, 0x1, 0xae, 0xff, 0xfd,
    0x70, 0x0, 0x2, 0xee, 0x9a, 0xf8, 0xaf, 0xb0,
    0x0, 0xce, 0x20, 0x6f, 0x10, 0x5f, 0x70, 0x2f,
    0x70, 0x6, 0xf1, 0x0, 0xcd, 0x4, 0xf4, 0x0,
    0x6f, 0x10, 0x9, 0xf0, 0x3f, 0x60, 0x6, 0xf1,
    0x0, 0xbe, 0x0, 0xde, 0x10, 0x6f, 0x10, 0x5f,
    0x80, 0x3, 0xfe, 0x8a, 0xf8, 0xaf, 0xc0, 0x0,
    0x2, 0xae, 0xff, 0xfd, 0x80, 0x0, 0x0, 0x0,
    0x6, 0xf2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6f,
    0x20, 0x0, 0x0, 0x0, 0x0, 0x6, 0xf2, 0x0,
    0x0, 0x0,

    /* U+03C7 "χ" */
    0x5f, 0x50, 0x0, 0x8f, 0x20, 0xcd, 0x0, 0x1f,
    0x90, 0x3, 0xf5, 0x8, 0xf1, 0x0, 0xb, 0xd1,
    0xf8, 0x0, 0x0, 0x2f, 0xce, 0x0, 0x0, 0x0,
    0x9f, 0x60, 0x0, 0x0, 0xa, 0xf7, 0x0, 0x0,
    0x3, 0xfb, 0xf1, 0x0, 0x0, 0xcc, 0xe, 0x90,
    0x0, 0x5f, 0x30, 0x7f, 0x30, 0xe, 0xb0, 0x0,
    0xec, 0x8, 0xf3, 0x0, 0x6, 0xf5,

    /* U+03C8 "ψ" */
    0x0, 0x0, 0x2, 0x30, 0x0, 0x0, 0x0, 0x0,
    0xa, 0xe0, 0x0, 0x0, 0x0, 0x0, 0xa, 0xe0,
    0x0, 0x0, 0x4f, 0x60, 0xa, 0xe0, 0x2, 0xf8,
    0x5f, 0x40, 0xa, 0xe0, 0x0, 0xf9, 0x5f, 0x30,
    0xa, 0xe0, 0x0, 0xf9, 0x5f, 0x30, 0xa, 0xe0,
    0x0, 0xf9, 0x3f, 0x60, 0xa, 0xe0, 0x2, 0xf7,
    0xe, 0xc0, 0xa, 0xe0, 0x8, 0xf2, 0x7, 0xfb,
    0x1a, 0xe0, 0x8f, 0xb0, 0x0, 0x9f, 0xff, 0xff,
    0xfc, 0x10, 0x0, 0x3, 0x9e, 0xfa, 0x50, 0x0,
    0x0, 0x0, 0xa, 0xe0, 0x0, 0x0, 0x0, 0x0,
    0xa, 0xe0, 0x0, 0x0, 0x0, 0x0, 0xa, 0xe0,
    0x0, 0x0,

    /* U+03C9 "ω" */
    0x0, 0x40, 0x0, 0x0, 0x0, 0x22, 0x0, 0x5f,
    0x40, 0x0, 0x0, 0xb, 0xe1, 0xd, 0xd0, 0x0,
    0x0, 0x0, 0x3f, 0x82, 0xf5, 0x0, 0xf, 0x90,
    0x0, 0xcd, 0x4f, 0x20, 0x0, 0xf9, 0x0, 0xa,
    0xe4, 0xf4, 0x0, 0xf, 0xa0, 0x0, 0xae, 0x1f,
    0xb0, 0x6, 0xfd, 0x0, 0x3f, 0xb0, 0x8f, 0xdc,
    0xfb, 0xfe, 0xcf, 0xf3, 0x0, 0x8e, 0xe9, 0x4,
    0xdf, 0xc3, 0x0,

    /* U+03CA "ϊ" */
    0xc7, 0xc, 0x68, 0x40, 0x84, 0x0, 0x0, 0x0,
    0x8f, 0x0, 0x8, 0xf0, 0x0, 0x8f, 0x0, 0x8,
    0xf0, 0x0, 0x8f, 0x0, 0x8, 0xf0, 0x0, 0x8f,
    0x0, 0x8, 0xf0, 0x0, 0x8f, 0x0,

    /* U+03CB "ϋ" */
    0x0, 0xa8, 0xb, 0x80, 0x0, 0x6, 0x50, 0x75,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xa, 0xe0, 0x0,
    0x2, 0xf5, 0xae, 0x0, 0x0, 0x2f, 0x5a, 0xe0,
    0x0, 0x2, 0xf5, 0xae, 0x0, 0x0, 0x2f, 0x59,
    0xe0, 0x0, 0x2, 0xf5, 0x8f, 0x0, 0x0, 0x4f,
    0x45, 0xf6, 0x0, 0x9, 0xf1, 0xc, 0xf9, 0x7b,
    0xf9, 0x0, 0x19, 0xef, 0xd7, 0x0,

    /* U+03CC "ό" */
    0x0, 0x0, 0x2, 0x20, 0x0, 0x0, 0x0, 0x1f,
    0x70, 0x0, 0x0, 0x0, 0x6e, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3b, 0xef, 0xc4,
    0x0, 0x4, 0xfd, 0x87, 0xcf, 0x60, 0xd, 0xd0,
    0x0, 0xb, 0xf1, 0x3f, 0x50, 0x0, 0x3, 0xf5,
    0x4f, 0x30, 0x0, 0x1, 0xf7, 0x3f, 0x60, 0x0,
    0x3, 0xf5, 0xd, 0xd0, 0x0, 0xb, 0xf1, 0x4,
    0xfd, 0x87, 0xcf, 0x60, 0x0, 0x3b, 0xef, 0xc4,
    0x0,

    /* U+03CD "ύ" */
    0x0, 0x0, 0x13, 0x0, 0x0, 0x0, 0xc, 0xc0,
    0x0, 0x0, 0x1, 0xf4, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xae, 0x0, 0x0, 0x3f, 0x5a, 0xe0,
    0x0, 0x3, 0xf5, 0xae, 0x0, 0x0, 0x3f, 0x5a,
    0xe0, 0x0, 0x3, 0xf5, 0xae, 0x0, 0x0, 0x3f,
    0x59, 0xf0, 0x0, 0x4, 0xf4, 0x5f, 0x50, 0x0,
    0xaf, 0x10, 0xdf, 0x97, 0xbf, 0x80, 0x1, 0x9e,
    0xfd, 0x70, 0x0,

    /* U+03CE "ώ" */
    0x0, 0x0, 0x0, 0x3, 0x10, 0x0, 0x0, 0x0,
    0x0, 0x5, 0xf3, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xab, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x40, 0x0, 0x0, 0x0, 0x22,
    0x0, 0x5f, 0x40, 0x0, 0x0, 0xb, 0xe1, 0xd,
    0xc0, 0x0, 0x0, 0x0, 0x3f, 0x82, 0xf3, 0x0,
    0xf, 0x90, 0x0, 0xcd, 0x4f, 0x20, 0x0, 0xf9,
    0x0, 0xa, 0xe3, 0xf4, 0x0, 0xf, 0xa0, 0x0,
    0xae, 0x1f, 0xc0, 0x6, 0xfe, 0x0, 0x4f, 0xb0,
    0x8f, 0xfe, 0xfd, 0xff, 0xef, 0xf3, 0x0, 0x8e,
    0xfb, 0x15, 0xdf, 0xb3, 0x0,

    /* U+0400 "Ѐ" */
    0x0, 0xaf, 0x30, 0x0, 0x0, 0x0, 0x9e, 0x10,
    0x0, 0x0, 0x0, 0x65, 0x0, 0x4, 0xff, 0xff,
    0xff, 0xfa, 0x4f, 0xa7, 0x77, 0x77, 0x44, 0xf5,
    0x0, 0x0, 0x0, 0x4f, 0x50, 0x0, 0x0, 0x4,
    0xf6, 0x11, 0x11, 0x10, 0x4f, 0xff, 0xff, 0xff,
    0x4, 0xf8, 0x44, 0x44, 0x40, 0x4f, 0x50, 0x0,
    0x0, 0x4, 0xf5, 0x0, 0x0, 0x0, 0x4f, 0x50,
    0x0, 0x0, 0x4, 0xfa, 0x77, 0x77, 0x76, 0x4f,
    0xff, 0xff, 0xff, 0xd0,

    /* U+0401 "Ё" */
    0x0, 0x48, 0x4, 0x80, 0x0, 0x6, 0xc0, 0x6c,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0xff, 0xff,
    0xff, 0xfa, 0x4f, 0xa7, 0x77, 0x77, 0x44, 0xf5,
    0x0, 0x0, 0x0, 0x4f, 0x50, 0x0, 0x0, 0x4,
    0xf6, 0x11, 0x11, 0x10, 0x4f, 0xff, 0xff, 0xff,
    0x4, 0xf8, 0x44, 0x44, 0x40, 0x4f, 0x50, 0x0,
    0x0, 0x4, 0xf5, 0x0, 0x0, 0x0, 0x4f, 0x50,
    0x0, 0x0, 0x4, 0xfa, 0x77, 0x77, 0x76, 0x4f,
    0xff, 0xff, 0xff, 0xd0,

    /* U+0402 "Ђ" */
    0xcf, 0xff, 0xff, 0xff, 0xfd, 0x0, 0x5, 0x77,
    0x7f, 0xc7, 0x77, 0x60, 0x0, 0x0, 0x0, 0xfa,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xa0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xfa, 0x0, 0x10, 0x0,
    0x0, 0x0, 0xf, 0xdc, 0xff, 0xfd, 0x40, 0x0,
    0x0, 0xff, 0xb6, 0x46, 0xdf, 0x30, 0x0, 0xf,
    0xa0, 0x0, 0x1, 0xf9, 0x0, 0x0, 0xfa, 0x0,
    0x0, 0xe, 0xb0, 0x0, 0xf, 0xa0, 0x0, 0x2,
    0xf9, 0x0, 0x0, 0xfa, 0x1, 0x78, 0xef, 0x20,
    0x0, 0xf, 0xa0, 0x4f, 0xfc, 0x30,

    /* U+0403 "Ѓ" */
    0x0, 0x4, 0xf5, 0x0, 0x0, 0x0, 0x9c, 0x0,
    0x0, 0x0, 0x2, 0x10, 0x0, 0x4, 0xff, 0xff,
    0xff, 0xf1, 0x4f, 0x97, 0x77, 0x77, 0x4, 0xf4,
    0x0, 0x0, 0x0, 0x4f, 0x40, 0x0, 0x0, 0x4,
    0xf4, 0x0, 0x0, 0x0, 0x4f, 0x40, 0x0, 0x0,
    0x4, 0xf4, 0x0, 0x0, 0x0, 0x4f, 0x40, 0x0,
    0x0, 0x4, 0xf4, 0x0, 0x0, 0x0, 0x4f, 0x40,
    0x0, 0x0, 0x4, 0xf4, 0x0, 0x0, 0x0, 0x4f,
    0x40, 0x0, 0x0, 0x0,

    /* U+0404 "Є" */
    0x0, 0x2, 0x9e, 0xfe, 0xa3, 0x0, 0x5, 0xff,
    0xa8, 0x9e, 0xf7, 0x2, 0xfc, 0x10, 0x0, 0x6,
    0x30, 0xae, 0x10, 0x0, 0x0, 0x0, 0xf, 0xa1,
    0x11, 0x11, 0x0, 0x1, 0xff, 0xff, 0xff, 0xe0,
    0x0, 0x1f, 0xb4, 0x44, 0x44, 0x0, 0x0, 0xfd,
    0x0, 0x0, 0x0, 0x0, 0xa, 0xf5, 0x0, 0x0,
    0x0, 0x0, 0x2f, 0xe3, 0x0, 0x1, 0xb5, 0x0,
    0x5f, 0xfb, 0x8a, 0xef, 0x60, 0x0, 0x2a, 0xef,
    0xea, 0x30,

    /* U+0405 "Ѕ" */
    0x0, 0x4b, 0xef, 0xea, 0x30, 0x5, 0xfd, 0x87,
    0x9e, 0xb0, 0xc, 0xd0, 0x0, 0x0, 0x20, 0xe,
    0xa0, 0x0, 0x0, 0x0, 0xb, 0xf6, 0x0, 0x0,
    0x0, 0x1, 0xdf, 0xfa, 0x60, 0x0, 0x0, 0x4,
    0x9e, 0xff, 0x50, 0x0, 0x0, 0x0, 0x4d, 0xf2,
    0x0, 0x0, 0x0, 0x3, 0xf5, 0x7, 0x10, 0x0,
    0x6, 0xf3, 0x1f, 0xfa, 0x77, 0xaf, 0xb0, 0x1,
    0x8d, 0xff, 0xd7, 0x0,

    /* U+0406 "І" */
    0x4f, 0x54, 0xf5, 0x4f, 0x54, 0xf5, 0x4f, 0x54,
    0xf5, 0x4f, 0x54, 0xf5, 0x4f, 0x54, 0xf5, 0x4f,
    0x54, 0xf5,

    /* U+0407 "Ї" */
    0x66, 0x6, 0x5a, 0x90, 0xa9, 0x0, 0x0, 0x0,
    0x5f, 0x40, 0x5, 0xf4, 0x0, 0x5f, 0x40, 0x5,
    0xf4, 0x0, 0x5f, 0x40, 0x5, 0xf4, 0x0, 0x5f,
    0x40, 0x5, 0xf4, 0x0, 0x5f, 0x40, 0x5, 0xf4,
    0x0, 0x5f, 0x40, 0x5, 0xf4, 0x0,

    /* U+0408 "Ј" */
    0x9, 0xff, 0xff, 0xf0, 0x4, 0x77, 0x7c, 0xf0,
    0x0, 0x0, 0x8, 0xf0, 0x0, 0x0, 0x8, 0xf0,
    0x0, 0x0, 0x8, 0xf0, 0x0, 0x0, 0x8, 0xf0,
    0x0, 0x0, 0x8, 0xf0, 0x0, 0x0, 0x8, 0xf0,
    0x0, 0x0, 0x9, 0xf0, 0x27, 0x0, 0xd, 0xd0,
    0x7f, 0xb8, 0xbf, 0x60, 0x6, 0xdf, 0xd7, 0x0,

    /* U+0409 "Љ" */
    0x0, 0xf, 0xff, 0xff, 0xff, 0xf0, 0x0, 0x0,
    0x0, 0x0, 0x1, 0xfa, 0x77, 0x77, 0xff, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1f, 0x50, 0x0, 0xf,
    0xf0, 0x0, 0x0, 0x0, 0x0, 0x2, 0xf4, 0x0,
    0x0, 0xff, 0x11, 0x10, 0x0, 0x0, 0x0, 0x2f,
    0x30, 0x0, 0xf, 0xff, 0xff, 0xfe, 0x80, 0x0,
    0x3, 0xf3, 0x0, 0x0, 0xff, 0x44, 0x45, 0x9f,
    0xb0, 0x0, 0x4f, 0x20, 0x0, 0xf, 0xf0, 0x0,
    0x0, 0x9f, 0x20, 0x6, 0xf1, 0x0, 0x0, 0xff,
    0x0, 0x0, 0x5, 0xf5, 0x0, 0x9e, 0x0, 0x0,
    0xf, 0xf0, 0x0, 0x0, 0x6f, 0x40, 0xe, 0xb0,
    0x0, 0x0, 0xff, 0x0, 0x0, 0xd, 0xf1, 0x6c,
    0xf5, 0x0, 0x0, 0xf, 0xf9, 0x99, 0xae, 0xf8,
    0xb, 0xf8, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff,
    0xc6, 0x0,

    /* U+040A "Њ" */
    0x4f, 0x50, 0x0, 0x0, 0x7f, 0x20, 0x0, 0x0,
    0x0, 0x4f, 0x50, 0x0, 0x0, 0x7f, 0x20, 0x0,
    0x0, 0x0, 0x4f, 0x50, 0x0, 0x0, 0x7f, 0x20,
    0x0, 0x0, 0x0, 0x4f, 0x50, 0x0, 0x0, 0x7f,
    0x20, 0x0, 0x0, 0x0, 0x4f, 0x62, 0x22, 0x22,
    0x8f, 0x32, 0x21, 0x0, 0x0, 0x4f, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfa, 0x10, 0x4f, 0x85,
    0x55, 0x55, 0xaf, 0x65, 0x56, 0xaf, 0xd0, 0x4f,
    0x50, 0x0, 0x0, 0x7f, 0x20, 0x0, 0x9, 0xf3,
    0x4f, 0x50, 0x0, 0x0, 0x7f, 0x20, 0x0, 0x5,
    0xf4, 0x4f, 0x50, 0x0, 0x0, 0x7f, 0x20, 0x0,
    0x9, 0xf1, 0x4f, 0x50, 0x0, 0x0, 0x7f, 0x65,
    0x56, 0xaf, 0xa0, 0x4f, 0x50, 0x0, 0x0, 0x7f,
    0xff, 0xff, 0xd6, 0x0,

    /* U+040B "Ћ" */
    0xcf, 0xff, 0xff, 0xff, 0xfc, 0x0, 0x5, 0x77,
    0x7f, 0xc7, 0x77, 0x50, 0x0, 0x0, 0x0, 0xf9,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xf, 0x90, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xf9, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xf, 0xc9, 0xdf, 0xea, 0x20, 0x0,
    0x0, 0xff, 0xea, 0x8b, 0xfe, 0x10, 0x0, 0xf,
    0xa0, 0x0, 0x6, 0xf8, 0x0, 0x0, 0xf9, 0x0,
    0x0, 0xf, 0xa0, 0x0, 0xf, 0x90, 0x0, 0x0,
    0xeb, 0x0, 0x0, 0xf9, 0x0, 0x0, 0xe, 0xb0,
    0x0, 0xf, 0x90, 0x0, 0x0, 0xeb,

    /* U+040C "Ќ" */
    0x0, 0x0, 0xdc, 0x0, 0x0, 0x0, 0x0, 0x2f,
    0x40, 0x0, 0x0, 0x0, 0x0, 0x20, 0x0, 0x0,
    0x4, 0xf4, 0x0, 0x0, 0x3f, 0x80, 0x4f, 0x40,
    0x0, 0xd, 0xc0, 0x4, 0xf4, 0x0, 0x9, 0xe1,
    0x0, 0x4f, 0x40, 0x5, 0xf5, 0x0, 0x4, 0xf6,
    0x23, 0xe9, 0x0, 0x0, 0x4f, 0xff, 0xff, 0x10,
    0x0, 0x4, 0xf8, 0x57, 0xf9, 0x0, 0x0, 0x4f,
    0x40, 0xa, 0xf3, 0x0, 0x4, 0xf4, 0x0, 0x1e,
    0xd0, 0x0, 0x4f, 0x40, 0x0, 0x5f, 0x70, 0x4,
    0xf4, 0x0, 0x0, 0xbf, 0x20, 0x4f, 0x40, 0x0,
    0x1, 0xfc, 0x0,

    /* U+040D "Ѝ" */
    0x0, 0x1c, 0xe1, 0x0, 0x0, 0x0, 0x0, 0xb,
    0xd0, 0x0, 0x0, 0x0, 0x0, 0x7, 0x40, 0x0,
    0x4, 0xf5, 0x0, 0x0, 0x6, 0xf6, 0x4f, 0x50,
    0x0, 0x2, 0xff, 0x64, 0xf5, 0x0, 0x0, 0xdf,
    0xf6, 0x4f, 0x50, 0x0, 0x9f, 0x7f, 0x64, 0xf5,
    0x0, 0x4f, 0x92, 0xf6, 0x4f, 0x50, 0x1e, 0xd0,
    0x2f, 0x64, 0xf5, 0xb, 0xf2, 0x2, 0xf6, 0x4f,
    0x56, 0xf7, 0x0, 0x2f, 0x64, 0xf7, 0xfb, 0x0,
    0x2, 0xf6, 0x4f, 0xfe, 0x10, 0x0, 0x2f, 0x64,
    0xff, 0x40, 0x0, 0x2, 0xf6, 0x4f, 0x90, 0x0,
    0x0, 0x2f, 0x60,

    /* U+040E "Ў" */
    0x0, 0x3f, 0x20, 0x3f, 0x10, 0x0, 0x0, 0x6d,
    0xec, 0x50, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x8, 0xf3, 0x0, 0x0, 0x0, 0xea, 0x1f, 0xa0,
    0x0, 0x0, 0x6f, 0x20, 0x8f, 0x20, 0x0, 0xe,
    0x90, 0x1, 0xfa, 0x0, 0x6, 0xf2, 0x0, 0x7,
    0xf2, 0x0, 0xe9, 0x0, 0x0, 0xe, 0x90, 0x6f,
    0x10, 0x0, 0x0, 0x7f, 0x2e, 0x90, 0x0, 0x0,
    0x0, 0xee, 0xf1, 0x0, 0x0, 0x0, 0x7, 0xf8,
    0x0, 0x0, 0x0, 0x0, 0x9f, 0x10, 0x0, 0x0,
    0x48, 0xaf, 0x70, 0x0, 0x0, 0x7, 0xff, 0x70,
    0x0, 0x0, 0x0,

    /* U+040F "Џ" */
    0x4f, 0x50, 0x0, 0x0, 0x7f, 0x24, 0xf5, 0x0,
    0x0, 0x7, 0xf2, 0x4f, 0x50, 0x0, 0x0, 0x7f,
    0x24, 0xf5, 0x0, 0x0, 0x7, 0xf2, 0x4f, 0x50,
    0x0, 0x0, 0x7f, 0x24, 0xf5, 0x0, 0x0, 0x7,
    0xf2, 0x4f, 0x50, 0x0, 0x0, 0x7f, 0x24, 0xf5,
    0x0, 0x0, 0x7, 0xf2, 0x4f, 0x50, 0x0, 0x0,
    0x7f, 0x24, 0xf5, 0x0, 0x0, 0x7, 0xf2, 0x4f,
    0xa7, 0x77, 0x77, 0xbf, 0x24, 0xff, 0xff, 0xff,
    0xff, 0xf2, 0x0, 0x0, 0x4f, 0x30, 0x0, 0x0,
    0x0, 0x4, 0xf3, 0x0, 0x0, 0x0, 0x0, 0x28,
    0x10, 0x0, 0x0,

    /* U+0410 "А" */
    0x0, 0x0, 0xe, 0xf1, 0x0, 0x0, 0x0, 0x0,
    0x6f, 0xf7, 0x0, 0x0, 0x0, 0x0, 0xcc, 0xbe,
    0x0, 0x0, 0x0, 0x3, 0xf5, 0x4f, 0x40, 0x0,
    0x0, 0xa, 0xe0, 0xe, 0xb0, 0x0, 0x0, 0x1f,
    0x90, 0x8, 0xf2, 0x0, 0x0, 0x8f, 0x20, 0x1,
    0xf9, 0x0, 0x0, 0xec, 0x11, 0x11, 0xcf, 0x0,
    0x5, 0xff, 0xff, 0xff, 0xff, 0x60, 0xc, 0xe4,
    0x44, 0x44, 0x4d, 0xd0, 0x3f, 0x80, 0x0, 0x0,
    0x7, 0xf4, 0x9f, 0x10, 0x0, 0x0, 0x0, 0xfb,

    /* U+0411 "Б" */
    0x4f, 0xff, 0xff, 0xff, 0xf3, 0x4f, 0x96, 0x66,
    0x66, 0x61, 0x4f, 0x50, 0x0, 0x0, 0x0, 0x4f,
    0x50, 0x0, 0x0, 0x0, 0x4f, 0x51, 0x10, 0x0,
    0x0, 0x4f, 0xff, 0xff, 0xfc, 0x50, 0x4f, 0x74,
    0x44, 0x6c, 0xf6, 0x4f, 0x50, 0x0, 0x0, 0xec,
    0x4f, 0x50, 0x0, 0x0, 0xcd, 0x4f, 0x50, 0x0,
    0x1, 0xeb, 0x4f, 0x85, 0x55, 0x7d, 0xf4, 0x4f,
    0xff, 0xff, 0xeb, 0x30,

    /* U+0412 "В" */
    0x4f, 0xff, 0xff, 0xea, 0x30, 0x4, 0xf8, 0x55,
    0x57, 0xef, 0x20, 0x4f, 0x50, 0x0, 0x5, 0xf6,
    0x4, 0xf5, 0x0, 0x0, 0x3f, 0x50, 0x4f, 0x50,
    0x1, 0x3c, 0xd0, 0x4, 0xff, 0xff, 0xff, 0xf3,
    0x0, 0x4f, 0x73, 0x33, 0x5a, 0xf5, 0x4, 0xf5,
    0x0, 0x0, 0xc, 0xd0, 0x4f, 0x50, 0x0, 0x0,
    0xaf, 0x4, 0xf5, 0x0, 0x0, 0xd, 0xe0, 0x4f,
    0x85, 0x55, 0x6c, 0xf7, 0x4, 0xff, 0xff, 0xff,
    0xc6, 0x0,

    /* U+0413 "Г" */
    0x4f, 0xff, 0xff, 0xff, 0x14, 0xf9, 0x77, 0x77,
    0x70, 0x4f, 0x50, 0x0, 0x0, 0x4, 0xf5, 0x0,
    0x0, 0x0, 0x4f, 0x50, 0x0, 0x0, 0x4, 0xf5,
    0x0, 0x0, 0x0, 0x4f, 0x50, 0x0, 0x0, 0x4,
    0xf5, 0x0, 0x0, 0x0, 0x4f, 0x50, 0x0, 0x0,
    0x4, 0xf5, 0x0, 0x0, 0x0, 0x4f, 0x50, 0x0,
    0x0, 0x4, 0xf5, 0x0, 0x0, 0x0,

    /* U+0414 "Д" */
    0x0, 0x2f, 0xff, 0xff, 0xff, 0xc0, 0x0, 0x2,
    0xf9, 0x77, 0x77, 0xec, 0x0, 0x0, 0x2f, 0x30,
    0x0, 0xd, 0xc0, 0x0, 0x3, 0xf3, 0x0, 0x0,
    0xdc, 0x0, 0x0, 0x4f, 0x20, 0x0, 0xd, 0xc0,
    0x0, 0x5, 0xf1, 0x0, 0x0, 0xdc, 0x0, 0x0,
    0x6f, 0x0, 0x0, 0xd, 0xc0, 0x0, 0x8, 0xe0,
    0x0, 0x0, 0xdc, 0x0, 0x0, 0xbb, 0x0, 0x0,
    0xd, 0xc0, 0x0, 0x1f, 0x70, 0x0, 0x0, 0xdc,
    0x0, 0x5c, 0xf8, 0x77, 0x77, 0x7e, 0xe7, 0x3c,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0xcb, 0x0,
    0x0, 0x0, 0x0, 0x1f, 0x6c, 0xb0, 0x0, 0x0,
    0x0, 0x1, 0xf6, 0x76, 0x0, 0x0, 0x0, 0x0,
    0x9, 0x30,

    /* U+0415 "Е" */
    0x4f, 0xff, 0xff, 0xff, 0xa4, 0xfa, 0x77, 0x77,
    0x74, 0x4f, 0x50, 0x0, 0x0, 0x4, 0xf5, 0x0,
    0x0, 0x0, 0x4f, 0x61, 0x11, 0x11, 0x4, 0xff,
    0xff, 0xff, 0xf0, 0x4f, 0x84, 0x44, 0x44, 0x4,
    0xf5, 0x0, 0x0, 0x0, 0x4f, 0x50, 0x0, 0x0,
    0x4, 0xf5, 0x0, 0x0, 0x0, 0x4f, 0xa7, 0x77,
    0x77, 0x64, 0xff, 0xff, 0xff, 0xfd,

    /* U+0416 "Ж" */
    0x2f, 0x90, 0x0, 0x8, 0xf0, 0x0, 0x2, 0xf9,
    0x0, 0x8f, 0x30, 0x0, 0x8f, 0x0, 0x0, 0xce,
    0x0, 0x0, 0xec, 0x0, 0x8, 0xf0, 0x0, 0x6f,
    0x40, 0x0, 0x5, 0xf7, 0x0, 0x8f, 0x0, 0x1e,
    0xa0, 0x0, 0x0, 0xb, 0xf3, 0x29, 0xf2, 0x2a,
    0xf1, 0x0, 0x0, 0x0, 0x3f, 0xff, 0xff, 0xff,
    0xf9, 0x0, 0x0, 0x0, 0x7, 0xf6, 0x5b, 0xf5,
    0x5c, 0xf1, 0x0, 0x0, 0x1, 0xfa, 0x0, 0x8f,
    0x0, 0x3f, 0xa0, 0x0, 0x0, 0xaf, 0x20, 0x8,
    0xf0, 0x0, 0xaf, 0x30, 0x0, 0x3f, 0x80, 0x0,
    0x8f, 0x0, 0x2, 0xfc, 0x0, 0xc, 0xe1, 0x0,
    0x8, 0xf0, 0x0, 0x8, 0xf5, 0x6, 0xf7, 0x0,
    0x0, 0x8f, 0x0, 0x0, 0x1e, 0xd0,

    /* U+0417 "З" */
    0x4, 0xad, 0xfe, 0xb3, 0x0, 0xe, 0xda, 0x89,
    0xef, 0x40, 0x2, 0x0, 0x0, 0x1e, 0xc0, 0x0,
    0x0, 0x0, 0xc, 0xc0, 0x0, 0x1, 0x12, 0x7f,
    0x60, 0x0, 0x6f, 0xff, 0xf9, 0x0, 0x0, 0x14,
    0x44, 0x8f, 0x90, 0x0, 0x0, 0x0, 0x7, 0xf2,
    0x0, 0x0, 0x0, 0x5, 0xf4, 0x5, 0x0, 0x0,
    0xb, 0xf2, 0x4f, 0xd7, 0x68, 0xdf, 0x80, 0x4,
    0xbf, 0xfe, 0xb5, 0x0,

    /* U+0418 "И" */
    0x4f, 0x50, 0x0, 0x0, 0x6f, 0x64, 0xf5, 0x0,
    0x0, 0x2f, 0xf6, 0x4f, 0x50, 0x0, 0xc, 0xff,
    0x64, 0xf5, 0x0, 0x8, 0xf7, 0xf6, 0x4f, 0x50,
    0x4, 0xf9, 0x2f, 0x64, 0xf5, 0x1, 0xed, 0x2,
    0xf6, 0x4f, 0x50, 0xbf, 0x30, 0x2f, 0x64, 0xf5,
    0x6f, 0x70, 0x2, 0xf6, 0x4f, 0x7f, 0xb0, 0x0,
    0x2f, 0x64, 0xff, 0xe1, 0x0, 0x2, 0xf6, 0x4f,
    0xf4, 0x0, 0x0, 0x2f, 0x64, 0xf9, 0x0, 0x0,
    0x2, 0xf6,

    /* U+0419 "Й" */
    0x0, 0x1f, 0x30, 0x2f, 0x20, 0x0, 0x0, 0x5d,
    0xed, 0x60, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x4, 0xf5, 0x0, 0x0, 0x6, 0xf6, 0x4f, 0x50,
    0x0, 0x2, 0xff, 0x64, 0xf5, 0x0, 0x0, 0xdf,
    0xf6, 0x4f, 0x50, 0x0, 0x9f, 0x7f, 0x64, 0xf5,
    0x0, 0x4f, 0x92, 0xf6, 0x4f, 0x50, 0x1e, 0xd0,
    0x2f, 0x64, 0xf5, 0xb, 0xf2, 0x2, 0xf6, 0x4f,
    0x56, 0xf7, 0x0, 0x2f, 0x64, 0xf7, 0xfb, 0x0,
    0x2, 0xf6, 0x4f, 0xfe, 0x10, 0x0, 0x2f, 0x64,
    0xff, 0x40, 0x0, 0x2, 0xf6, 0x4f, 0x90, 0x0,
    0x0, 0x2f, 0x60,

    /* U+041A "К" */
    0x4f, 0x50, 0x0, 0x2, 0xf8, 0x4, 0xf5, 0x0,
    0x0, 0xdc, 0x0, 0x4f, 0x50, 0x0, 0x9f, 0x20,
    0x4, 0xf5, 0x0, 0x5f, 0x50, 0x0, 0x4f, 0x62,
    0x3e, 0x90, 0x0, 0x4, 0xff, 0xff, 0xf1, 0x0,
    0x0, 0x4f, 0x85, 0x6f, 0x90, 0x0, 0x4, 0xf5,
    0x0, 0x9f, 0x30, 0x0, 0x4f, 0x50, 0x1, 0xed,
    0x0, 0x4, 0xf5, 0x0, 0x5, 0xf8, 0x0, 0x4f,
    0x50, 0x0, 0xa, 0xf2, 0x4, 0xf5, 0x0, 0x0,
    0x1f, 0xc0,

    /* U+041B "Л" */
    0x0, 0xf, 0xff, 0xff, 0xff, 0xe0, 0x0, 0xfa,
    0x77, 0x77, 0xde, 0x0, 0x1f, 0x50, 0x0, 0xa,
    0xe0, 0x1, 0xf4, 0x0, 0x0, 0xae, 0x0, 0x2f,
    0x40, 0x0, 0xa, 0xe0, 0x3, 0xf3, 0x0, 0x0,
    0xae, 0x0, 0x4f, 0x20, 0x0, 0xa, 0xe0, 0x5,
    0xf1, 0x0, 0x0, 0xae, 0x0, 0x8f, 0x0, 0x0,
    0xa, 0xe0, 0xd, 0xb0, 0x0, 0x0, 0xae, 0x6c,
    0xf5, 0x0, 0x0, 0xa, 0xeb, 0xf9, 0x0, 0x0,
    0x0, 0xae,

    /* U+041C "М" */
    0x4f, 0x50, 0x0, 0x0, 0x0, 0xe, 0xa4, 0xfd,
    0x0, 0x0, 0x0, 0x7, 0xfa, 0x4f, 0xf7, 0x0,
    0x0, 0x1, 0xff, 0xa4, 0xfd, 0xe1, 0x0, 0x0,
    0x9e, 0xea, 0x4f, 0x6f, 0x80, 0x0, 0x2f, 0x6e,
    0xa4, 0xf4, 0x7f, 0x20, 0xa, 0xd0, 0xea, 0x4f,
    0x40, 0xea, 0x3, 0xf4, 0xe, 0xa4, 0xf4, 0x6,
    0xf3, 0xcb, 0x0, 0xea, 0x4f, 0x40, 0xc, 0xef,
    0x30, 0xe, 0xa4, 0xf4, 0x0, 0x4f, 0xa0, 0x0,
    0xea, 0x4f, 0x40, 0x0, 0x71, 0x0, 0xe, 0xa4,
    0xf4, 0x0, 0x0, 0x0, 0x0, 0xea,

    /* U+041D "Н" */
    0x4f, 0x50, 0x0, 0x0, 0x3f, 0x54, 0xf5, 0x0,
    0x0, 0x3, 0xf5, 0x4f, 0x50, 0x0, 0x0, 0x3f,
    0x54, 0xf5, 0x0, 0x0, 0x3, 0xf5, 0x4f, 0x62,
    0x22, 0x22, 0x5f, 0x54, 0xff, 0xff, 0xff, 0xff,
    0xf5, 0x4f, 0x85, 0x55, 0x55, 0x7f, 0x54, 0xf5,
    0x0, 0x0, 0x3, 0xf5, 0x4f, 0x50, 0x0, 0x0,
    0x3f, 0x54, 0xf5, 0x0, 0x0, 0x3, 0xf5, 0x4f,
    0x50, 0x0, 0x0, 0x3f, 0x54, 0xf5, 0x0, 0x0,
    0x3, 0xf5,

    /* U+041E "О" */
    0x0, 0x1, 0x9d, 0xfe, 0xb5, 0x0, 0x0, 0x4,
    0xff, 0xb8, 0x9d, 0xfb, 0x0, 0x2, 0xfd, 0x20,
    0x0, 0x7, 0xfa, 0x0, 0xaf, 0x30, 0x0, 0x0,
    0x9, 0xf3, 0xf, 0xa0, 0x0, 0x0, 0x0, 0x2f,
    0x82, 0xf7, 0x0, 0x0, 0x0, 0x0, 0xea, 0x2f,
    0x70, 0x0, 0x0, 0x0, 0xe, 0xa0, 0xfa, 0x0,
    0x0, 0x0, 0x2, 0xf8, 0xa, 0xf3, 0x0, 0x0,
    0x0, 0x9f, 0x30, 0x2f, 0xd2, 0x0, 0x0, 0x7f,
    0xa0, 0x0, 0x4f, 0xfb, 0x89, 0xdf, 0xb0, 0x0,
    0x0, 0x19, 0xdf, 0xeb, 0x50, 0x0,

    /* U+041F "П" */
    0x4f, 0xff, 0xff, 0xff, 0xff, 0x64, 0xfa, 0x77,
    0x77, 0x78, 0xf6, 0x4f, 0x50, 0x0, 0x0, 0x2f,
    0x64, 0xf5, 0x0, 0x0, 0x2, 0xf6, 0x4f, 0x50,
    0x0, 0x0, 0x2f, 0x64, 0xf5, 0x0, 0x0, 0x2,
    0xf6, 0x4f, 0x50, 0x0, 0x0, 0x2f, 0x64, 0xf5,
    0x0, 0x0, 0x2, 0xf6, 0x4f, 0x50, 0x0, 0x0,
    0x2f, 0x64, 0xf5, 0x0, 0x0, 0x2, 0xf6, 0x4f,
    0x50, 0x0, 0x0, 0x2f, 0x64, 0xf5, 0x0, 0x0,
    0x2, 0xf6,

    /* U+0420 "Р" */
    0x4f, 0xff, 0xff, 0xd8, 0x0, 0x4f, 0xa7, 0x78,
    0xbf, 0xc0, 0x4f, 0x50, 0x0, 0x6, 0xf7, 0x4f,
    0x50, 0x0, 0x0, 0xfb, 0x4f, 0x50, 0x0, 0x0,
    0xeb, 0x4f, 0x50, 0x0, 0x3, 0xf8, 0x4f, 0x62,
    0x23, 0x6e, 0xf2, 0x4f, 0xff, 0xff, 0xfd, 0x30,
    0x4f, 0x85, 0x54, 0x20, 0x0, 0x4f, 0x50, 0x0,
    0x0, 0x0, 0x4f, 0x50, 0x0, 0x0, 0x0, 0x4f,
    0x50, 0x0, 0x0, 0x0,

    /* U+0421 "С" */
    0x0, 0x1, 0x8d, 0xfe, 0xb5, 0x0, 0x0, 0x4f,
    0xfb, 0x89, 0xdf, 0xa0, 0x2, 0xfd, 0x20, 0x0,
    0x7, 0x50, 0xa, 0xf3, 0x0, 0x0, 0x0, 0x0,
    0xf, 0xa0, 0x0, 0x0, 0x0, 0x0, 0x2f, 0x70,
    0x0, 0x0, 0x0, 0x0, 0x2f, 0x70, 0x0, 0x0,
    0x0, 0x0, 0xf, 0xa0, 0x0, 0x0, 0x0, 0x0,
    0xa, 0xf3, 0x0, 0x0, 0x0, 0x0, 0x2, 0xfd,
    0x20, 0x0, 0x7, 0x50, 0x0, 0x4f, 0xfb, 0x89,
    0xdf, 0x90, 0x0, 0x1, 0x9d, 0xfe, 0xb5, 0x0,

    /* U+0422 "Т" */
    0xcf, 0xff, 0xff, 0xff, 0xf7, 0x57, 0x77, 0xfc,
    0x77, 0x73, 0x0, 0x0, 0xf9, 0x0, 0x0, 0x0,
    0x0, 0xf9, 0x0, 0x0, 0x0, 0x0, 0xf9, 0x0,
    0x0, 0x0, 0x0, 0xf9, 0x0, 0x0, 0x0, 0x0,
    0xf9, 0x0, 0x0, 0x0, 0x0, 0xf9, 0x0, 0x0,
    0x0, 0x0, 0xf9, 0x0, 0x0, 0x0, 0x0, 0xf9,
    0x0, 0x0, 0x0, 0x0, 0xf9, 0x0, 0x0, 0x0,
    0x0, 0xf9, 0x0, 0x0,

    /* U+0423 "У" */
    0x8f, 0x30, 0x0, 0x0, 0xe, 0xa0, 0xeb, 0x0,
    0x0, 0x6, 0xf2, 0x7, 0xf2, 0x0, 0x0, 0xea,
    0x0, 0xe, 0xa0, 0x0, 0x6f, 0x20, 0x0, 0x7f,
    0x20, 0xe, 0x90, 0x0, 0x0, 0xea, 0x6, 0xf1,
    0x0, 0x0, 0x7, 0xf2, 0xe9, 0x0, 0x0, 0x0,
    0xe, 0xef, 0x10, 0x0, 0x0, 0x0, 0x7f, 0x90,
    0x0, 0x0, 0x0, 0x9, 0xf1, 0x0, 0x0, 0x4,
    0x8a, 0xf7, 0x0, 0x0, 0x0, 0x7f, 0xf7, 0x0,
    0x0, 0x0,

    /* U+0424 "Ф" */
    0x0, 0x0, 0x0, 0x3a, 0x10, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x5, 0xf2, 0x0, 0x0, 0x0, 0x0,
    0x7, 0xcf, 0xff, 0xff, 0xb6, 0x0, 0x0, 0x1d,
    0xf9, 0x58, 0xf6, 0x6b, 0xfb, 0x0, 0xb, 0xe2,
    0x0, 0x5f, 0x20, 0x4, 0xf8, 0x1, 0xf7, 0x0,
    0x5, 0xf2, 0x0, 0xa, 0xe0, 0x3f, 0x40, 0x0,
    0x5f, 0x20, 0x0, 0x7f, 0x2, 0xf6, 0x0, 0x5,
    0xf2, 0x0, 0x9, 0xf0, 0xd, 0xd1, 0x0, 0x5f,
    0x20, 0x2, 0xfa, 0x0, 0x3f, 0xe6, 0x26, 0xf3,
    0x38, 0xfd, 0x10, 0x0, 0x2a, 0xff, 0xff, 0xff,
    0xe9, 0x10, 0x0, 0x0, 0x0, 0x27, 0xf5, 0x20,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x5f, 0x20, 0x0,
    0x0, 0x0,

    /* U+0425 "Х" */
    0x2f, 0xb0, 0x0, 0x2, 0xfc, 0x0, 0x7f, 0x60,
    0x0, 0xcf, 0x20, 0x0, 0xcf, 0x10, 0x6f, 0x70,
    0x0, 0x2, 0xfb, 0x2f, 0xc0, 0x0, 0x0, 0x8,
    0xfe, 0xf2, 0x0, 0x0, 0x0, 0xd, 0xf8, 0x0,
    0x0, 0x0, 0x2, 0xff, 0xc0, 0x0, 0x0, 0x0,
    0xbf, 0x9f, 0x70, 0x0, 0x0, 0x6f, 0x70, 0xcf,
    0x20, 0x0, 0x2f, 0xc0, 0x2, 0xfc, 0x0, 0xb,
    0xf2, 0x0, 0x7, 0xf6, 0x6, 0xf7, 0x0, 0x0,
    0xc, 0xf2,

    /* U+0426 "Ц" */
    0x4f, 0x50, 0x0, 0x0, 0x7f, 0x20, 0x4f, 0x50,
    0x0, 0x0, 0x7f, 0x20, 0x4f, 0x50, 0x0, 0x0,
    0x7f, 0x20, 0x4f, 0x50, 0x0, 0x0, 0x7f, 0x20,
    0x4f, 0x50, 0x0, 0x0, 0x7f, 0x20, 0x4f, 0x50,
    0x0, 0x0, 0x7f, 0x20, 0x4f, 0x50, 0x0, 0x0,
    0x7f, 0x20, 0x4f, 0x50, 0x0, 0x0, 0x7f, 0x20,
    0x4f, 0x50, 0x0, 0x0, 0x7f, 0x20, 0x4f, 0x50,
    0x0, 0x0, 0x7f, 0x20, 0x4f, 0xa7, 0x77, 0x77,
    0xbf, 0x86, 0x4f, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x9e, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x9e, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x47,

    /* U+0427 "Ч" */
    0x2f, 0x70, 0x0, 0x0, 0x8f, 0x2, 0xf7, 0x0,
    0x0, 0x8, 0xf0, 0x2f, 0x70, 0x0, 0x0, 0x8f,
    0x2, 0xf7, 0x0, 0x0, 0x8, 0xf0, 0x1f, 0x80,
    0x0, 0x0, 0x8f, 0x0, 0xfd, 0x0, 0x0, 0x8,
    0xf0, 0x8, 0xfb, 0x42, 0x48, 0xef, 0x0, 0x9,
    0xff, 0xff, 0xed, 0xf0, 0x0, 0x1, 0x44, 0x20,
    0x8f, 0x0, 0x0, 0x0, 0x0, 0x8, 0xf0, 0x0,
    0x0, 0x0, 0x0, 0x8f, 0x0, 0x0, 0x0, 0x0,
    0x8, 0xf0,

    /* U+0428 "Ш" */
    0x4f, 0x50, 0x0, 0xf, 0x80, 0x0, 0xc, 0xc4,
    0xf5, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xcc, 0x4f,
    0x50, 0x0, 0xf, 0x80, 0x0, 0xc, 0xc4, 0xf5,
    0x0, 0x0, 0xf8, 0x0, 0x0, 0xcc, 0x4f, 0x50,
    0x0, 0xf, 0x80, 0x0, 0xc, 0xc4, 0xf5, 0x0,
    0x0, 0xf8, 0x0, 0x0, 0xcc, 0x4f, 0x50, 0x0,
    0xf, 0x80, 0x0, 0xc, 0xc4, 0xf5, 0x0, 0x0,
    0xf8, 0x0, 0x0, 0xcc, 0x4f, 0x50, 0x0, 0xf,
    0x80, 0x0, 0xc, 0xc4, 0xf5, 0x0, 0x0, 0xf8,
    0x0, 0x0, 0xcc, 0x4f, 0xa7, 0x77, 0x7f, 0xc7,
    0x77, 0x7e, 0xc4, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xfc,

    /* U+0429 "Щ" */
    0x4f, 0x50, 0x0, 0xf, 0x80, 0x0, 0xd, 0xc0,
    0x4, 0xf5, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xdc,
    0x0, 0x4f, 0x50, 0x0, 0xf, 0x80, 0x0, 0xd,
    0xc0, 0x4, 0xf5, 0x0, 0x0, 0xf8, 0x0, 0x0,
    0xdc, 0x0, 0x4f, 0x50, 0x0, 0xf, 0x80, 0x0,
    0xd, 0xc0, 0x4, 0xf5, 0x0, 0x0, 0xf8, 0x0,
    0x0, 0xdc, 0x0, 0x4f, 0x50, 0x0, 0xf, 0x80,
    0x0, 0xd, 0xc0, 0x4, 0xf5, 0x0, 0x0, 0xf8,
    0x0, 0x0, 0xdc, 0x0, 0x4f, 0x50, 0x0, 0xf,
    0x80, 0x0, 0xd, 0xc0, 0x4, 0xf5, 0x0, 0x0,
    0xf8, 0x0, 0x0, 0xdc, 0x0, 0x4f, 0xa7, 0x77,
    0x7f, 0xc7, 0x77, 0x7f, 0xf7, 0x34, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf7, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xf, 0x70, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf7, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8, 0x30,

    /* U+042A "Ъ" */
    0xcf, 0xff, 0xf2, 0x0, 0x0, 0x0, 0x5, 0x77,
    0xaf, 0x20, 0x0, 0x0, 0x0, 0x0, 0x6, 0xf2,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6f, 0x31, 0x10,
    0x0, 0x0, 0x0, 0x6, 0xff, 0xff, 0xfe, 0xa2,
    0x0, 0x0, 0x6f, 0x64, 0x44, 0x8f, 0xe1, 0x0,
    0x6, 0xf2, 0x0, 0x0, 0x5f, 0x60, 0x0, 0x6f,
    0x20, 0x0, 0x0, 0xf9, 0x0, 0x6, 0xf2, 0x0,
    0x0, 0x1f, 0x80, 0x0, 0x6f, 0x20, 0x0, 0x7,
    0xf5, 0x0, 0x6, 0xf7, 0x55, 0x69, 0xfc, 0x0,
    0x0, 0x6f, 0xff, 0xff, 0xd8, 0x0,

    /* U+042B "Ы" */
    0x4f, 0x50, 0x0, 0x0, 0x0, 0x7, 0xf2, 0x4f,
    0x50, 0x0, 0x0, 0x0, 0x7, 0xf2, 0x4f, 0x50,
    0x0, 0x0, 0x0, 0x7, 0xf2, 0x4f, 0x51, 0x10,
    0x0, 0x0, 0x7, 0xf2, 0x4f, 0xff, 0xff, 0xfb,
    0x30, 0x7, 0xf2, 0x4f, 0x74, 0x44, 0x7e, 0xf2,
    0x7, 0xf2, 0x4f, 0x50, 0x0, 0x2, 0xf9, 0x7,
    0xf2, 0x4f, 0x50, 0x0, 0x0, 0xeb, 0x7, 0xf2,
    0x4f, 0x50, 0x0, 0x0, 0xeb, 0x7, 0xf2, 0x4f,
    0x50, 0x0, 0x4, 0xf7, 0x7, 0xf2, 0x4f, 0x85,
    0x55, 0x8f, 0xe1, 0x7, 0xf2, 0x4f, 0xff, 0xff,
    0xe9, 0x10, 0x7, 0xf2,

    /* U+042C "Ь" */
    0x4f, 0x50, 0x0, 0x0, 0x0, 0x4f, 0x50, 0x0,
    0x0, 0x0, 0x4f, 0x50, 0x0, 0x0, 0x0, 0x4f,
    0x51, 0x10, 0x0, 0x0, 0x4f, 0xff, 0xff, 0xfb,
    0x30, 0x4f, 0x74, 0x44, 0x7e, 0xf2, 0x4f, 0x50,
    0x0, 0x2, 0xf9, 0x4f, 0x50, 0x0, 0x0, 0xec,
    0x4f, 0x50, 0x0, 0x0, 0xeb, 0x4f, 0x50, 0x0,
    0x4, 0xf8, 0x4f, 0x85, 0x55, 0x8f, 0xe1, 0x4f,
    0xff, 0xff, 0xe9, 0x10,

    /* U+042D "Э" */
    0x1, 0x8d, 0xfe, 0xb4, 0x0, 0x3, 0xff, 0xa8,
    0x9e, 0xf9, 0x0, 0x9, 0x10, 0x0, 0x9, 0xf7,
    0x0, 0x0, 0x0, 0x0, 0xc, 0xe0, 0x0, 0x0,
    0x11, 0x11, 0x6f, 0x40, 0x0, 0x9f, 0xff, 0xff,
    0xf6, 0x0, 0x2, 0x44, 0x44, 0x7f, 0x60, 0x0,
    0x0, 0x0, 0x7, 0xf4, 0x0, 0x0, 0x0, 0x0,
    0xee, 0x1, 0xc2, 0x0, 0x0, 0xbf, 0x60, 0x3e,
    0xfb, 0x89, 0xef, 0x90, 0x0, 0x18, 0xdf, 0xeb,
    0x50, 0x0,

    /* U+042E "Ю" */
    0x4f, 0x50, 0x0, 0x6, 0xcf, 0xfc, 0x60, 0x0,
    0x4f, 0x50, 0x1, 0xcf, 0xb6, 0x6a, 0xfc, 0x10,
    0x4f, 0x50, 0xa, 0xf5, 0x0, 0x0, 0x4f, 0xb0,
    0x4f, 0x50, 0x3f, 0x90, 0x0, 0x0, 0x8, 0xf3,
    0x4f, 0x50, 0x7f, 0x20, 0x0, 0x0, 0x1, 0xf8,
    0x4f, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0xea,
    0x4f, 0xa8, 0xcf, 0x0, 0x0, 0x0, 0x0, 0xea,
    0x4f, 0x50, 0x6f, 0x30, 0x0, 0x0, 0x2, 0xf8,
    0x4f, 0x50, 0x2f, 0xb0, 0x0, 0x0, 0xa, 0xf3,
    0x4f, 0x50, 0x9, 0xf7, 0x0, 0x0, 0x6f, 0xb0,
    0x4f, 0x50, 0x0, 0xbf, 0xd9, 0x9c, 0xfc, 0x10,
    0x4f, 0x50, 0x0, 0x6, 0xcf, 0xfc, 0x70, 0x0,

    /* U+042F "Я" */
    0x0, 0x2a, 0xef, 0xff, 0xff, 0x3, 0xff, 0x97,
    0x77, 0xcf, 0xb, 0xf2, 0x0, 0x0, 0x9f, 0xf,
    0xa0, 0x0, 0x0, 0x9f, 0xf, 0x90, 0x0, 0x0,
    0x9f, 0xe, 0xd0, 0x0, 0x0, 0x9f, 0x7, 0xfa,
    0x31, 0x11, 0xaf, 0x0, 0x8f, 0xff, 0xff, 0xff,
    0x0, 0xd, 0xb4, 0x44, 0xbf, 0x0, 0x8f, 0x20,
    0x0, 0x9f, 0x2, 0xf8, 0x0, 0x0, 0x9f, 0xc,
    0xe0, 0x0, 0x0, 0x9f,

    /* U+0430 "а" */
    0x0, 0x3b, 0xef, 0xb1, 0xf8, 0x3, 0xfe, 0x87,
    0xce, 0xf8, 0xd, 0xe1, 0x0, 0xa, 0xf8, 0x2f,
    0x70, 0x0, 0x2, 0xf8, 0x3f, 0x50, 0x0, 0x0,
    0xf8, 0x2f, 0x70, 0x0, 0x2, 0xf8, 0xd, 0xe1,
    0x0, 0xa, 0xf8, 0x3, 0xfe, 0x87, 0xce, 0xf8,
    0x0, 0x3b, 0xef, 0xb2, 0xf8,

    /* U+0431 "б" */
    0x0, 0x0, 0x0, 0x2, 0x62, 0x0, 0x0, 0x6b,
    0xff, 0xf5, 0x0, 0x3e, 0xfd, 0x95, 0x20, 0x1,
    0xed, 0x30, 0x0, 0x0, 0x7, 0xf1, 0x1, 0x0,
    0x0, 0xc, 0xa6, 0xef, 0xfc, 0x30, 0xe, 0xde,
    0x75, 0x7e, 0xf2, 0xf, 0xf2, 0x0, 0x2, 0xfa,
    0xf, 0xc0, 0x0, 0x0, 0xcd, 0xc, 0xd0, 0x0,
    0x0, 0xcd, 0x7, 0xf4, 0x0, 0x3, 0xf8, 0x0,
    0xdf, 0x85, 0x8f, 0xd1, 0x0, 0x19, 0xef, 0xe9,
    0x10,

    /* U+0432 "в" */
    0x8f, 0xff, 0xfd, 0x70, 0x8f, 0x33, 0x49, 0xf6,
    0x8f, 0x0, 0x0, 0xf9, 0x8f, 0x0, 0x5, 0xf4,
    0x8f, 0xff, 0xff, 0xb0, 0x8f, 0x22, 0x25, 0xe9,
    0x8f, 0x0, 0x0, 0xad, 0x8f, 0x44, 0x46, 0xfa,
    0x8f, 0xff, 0xfe, 0xa1,

    /* U+0433 "г" */
    0x8f, 0xff, 0xff, 0xb8, 0xf6, 0x66, 0x64, 0x8f,
    0x0, 0x0, 0x8, 0xf0, 0x0, 0x0, 0x8f, 0x0,
    0x0, 0x8, 0xf0, 0x0, 0x0, 0x8f, 0x0, 0x0,
    0x8, 0xf0, 0x0, 0x0, 0x8f, 0x0, 0x0, 0x0,

    /* U+0434 "д" */
    0x0, 0xcf, 0xff, 0xff, 0xd0, 0x0, 0xd, 0xc6,
    0x66, 0xdd, 0x0, 0x0, 0xd8, 0x0, 0xb, 0xd0,
    0x0, 0xe, 0x70, 0x0, 0xbd, 0x0, 0x0, 0xf6,
    0x0, 0xb, 0xd0, 0x0, 0x2f, 0x40, 0x0, 0xbd,
    0x0, 0x6, 0xf1, 0x0, 0xb, 0xd0, 0x5, 0xed,
    0x66, 0x66, 0xde, 0x60, 0xdf, 0xff, 0xff, 0xff,
    0xff, 0x1d, 0x90, 0x0, 0x0, 0x5, 0xf1, 0xd9,
    0x0, 0x0, 0x0, 0x5f, 0x10, 0x0, 0x0, 0x0,
    0x0, 0x10,

    /* U+0435 "е" */
    0x0, 0x3b, 0xfe, 0xa2, 0x0, 0x4, 0xfc, 0x67,
    0xde, 0x20, 0xe, 0xc0, 0x0, 0xd, 0xa0, 0x3f,
    0x50, 0x0, 0x7, 0xf0, 0x4f, 0xff, 0xff, 0xff,
    0xf1, 0x3f, 0x72, 0x22, 0x22, 0x20, 0xd, 0xc0,
    0x0, 0x2, 0x0, 0x4, 0xfe, 0x87, 0xaf, 0x50,
    0x0, 0x2a, 0xef, 0xd7, 0x0,

    /* U+0436 "ж" */
    0x4f, 0x50, 0x0, 0xf8, 0x0, 0xc, 0xd0, 0xa,
    0xe0, 0x0, 0xf8, 0x0, 0x6f, 0x40, 0x1, 0xe8,
    0x0, 0xf8, 0x0, 0xea, 0x0, 0x0, 0x6f, 0x31,
    0xf9, 0x19, 0xf1, 0x0, 0x0, 0x1f, 0xff, 0xff,
    0xff, 0xa0, 0x0, 0x0, 0x9f, 0x64, 0xfa, 0x4b,
    0xf2, 0x0, 0x3, 0xf9, 0x0, 0xf8, 0x1, 0xec,
    0x0, 0xd, 0xe1, 0x0, 0xf8, 0x0, 0x6f, 0x60,
    0x7f, 0x50, 0x0, 0xf8, 0x0, 0xc, 0xf1,

    /* U+0437 "з" */
    0x7, 0xcf, 0xfc, 0x50, 0xe, 0x96, 0x7d, 0xf4,
    0x0, 0x0, 0x0, 0xf9, 0x0, 0x0, 0x6, 0xf4,
    0x0, 0x4f, 0xff, 0x90, 0x0, 0x2, 0x36, 0xf8,
    0x0, 0x0, 0x0, 0xdc, 0x5e, 0x97, 0x7b, 0xf7,
    0x7, 0xdf, 0xfc, 0x60,

    /* U+0438 "и" */
    0x8f, 0x0, 0x0, 0x3f, 0x98, 0xf0, 0x0, 0x1e,
    0xf9, 0x8f, 0x0, 0xb, 0xef, 0x98, 0xf0, 0x8,
    0xf4, 0xe9, 0x8f, 0x5, 0xf7, 0xe, 0x98, 0xf3,
    0xfa, 0x0, 0xe9, 0x8f, 0xed, 0x0, 0xe, 0x98,
    0xfe, 0x20, 0x0, 0xe9, 0x8f, 0x40, 0x0, 0xe,
    0x90,

    /* U+0439 "й" */
    0x0, 0x70, 0x1, 0x70, 0x0, 0xd, 0x50, 0x8c,
    0x0, 0x0, 0x3c, 0xec, 0x20, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x8f, 0x0, 0x0, 0x3f, 0x98, 0xf0,
    0x0, 0x1e, 0xf9, 0x8f, 0x0, 0xc, 0xef, 0x98,
    0xf0, 0x9, 0xf3, 0xf9, 0x8f, 0x5, 0xf6, 0xf,
    0x98, 0xf3, 0xfa, 0x0, 0xf9, 0x8f, 0xec, 0x0,
    0xf, 0x98, 0xfe, 0x20, 0x0, 0xf9, 0x8f, 0x40,
    0x0, 0xf, 0x90,

    /* U+043A "к" */
    0x8f, 0x0, 0x0, 0xcd, 0x8, 0xf0, 0x0, 0x7f,
    0x20, 0x8f, 0x0, 0x3f, 0x60, 0x8, 0xf1, 0x1d,
    0xa0, 0x0, 0x8f, 0xff, 0xf3, 0x0, 0x8, 0xf4,
    0x5e, 0xc0, 0x0, 0x8f, 0x0, 0x4f, 0x90, 0x8,
    0xf0, 0x0, 0x8f, 0x50, 0x8f, 0x0, 0x0, 0xbf,
    0x20,

    /* U+043B "л" */
    0x0, 0xcf, 0xff, 0xff, 0xc0, 0xd, 0xb6, 0x66,
    0xdc, 0x0, 0xd8, 0x0, 0xc, 0xc0, 0xe, 0x70,
    0x0, 0xcc, 0x0, 0xf6, 0x0, 0xc, 0xc0, 0x1f,
    0x40, 0x0, 0xcc, 0x4, 0xf1, 0x0, 0xc, 0xc4,
    0xdd, 0x0, 0x0, 0xcc, 0xde, 0x40, 0x0, 0xc,
    0xc0,

    /* U+043C "м" */
    0x8f, 0x50, 0x0, 0x0, 0x7f, 0x48, 0xfd, 0x0,
    0x0, 0x1f, 0xf4, 0x8f, 0xf7, 0x0, 0x9, 0xef,
    0x48, 0xe7, 0xe1, 0x2, 0xf6, 0xf4, 0x8e, 0xe,
    0x80, 0xbb, 0x2f, 0x48, 0xe0, 0x5f, 0x6f, 0x22,
    0xf4, 0x8e, 0x0, 0xcf, 0x80, 0x2f, 0x48, 0xe0,
    0x3, 0xe0, 0x2, 0xf4, 0x8e, 0x0, 0x0, 0x0,
    0x2f, 0x40,

    /* U+043D "н" */
    0x8f, 0x0, 0x0, 0x2f, 0x68, 0xf0, 0x0, 0x2,
    0xf6, 0x8f, 0x0, 0x0, 0x2f, 0x68, 0xf1, 0x11,
    0x13, 0xf6, 0x8f, 0xff, 0xff, 0xff, 0x68, 0xf4,
    0x44, 0x46, 0xf6, 0x8f, 0x0, 0x0, 0x2f, 0x68,
    0xf0, 0x0, 0x2, 0xf6, 0x8f, 0x0, 0x0, 0x2f,
    0x60,

    /* U+043E "о" */
    0x0, 0x3b, 0xef, 0xc4, 0x0, 0x3, 0xfd, 0x87,
    0xcf, 0x60, 0xd, 0xd0, 0x0, 0xa, 0xf1, 0x3f,
    0x60, 0x0, 0x3, 0xf6, 0x4f, 0x40, 0x0, 0x1,
    0xf7, 0x3f, 0x60, 0x0, 0x3, 0xf6, 0xd, 0xd1,
    0x0, 0xb, 0xf1, 0x3, 0xfd, 0x87, 0xcf, 0x60,
    0x0, 0x3b, 0xef, 0xc4, 0x0,

    /* U+043F "п" */
    0x8f, 0xff, 0xff, 0xff, 0x58, 0xf6, 0x66, 0x68,
    0xf5, 0x8f, 0x0, 0x0, 0x3f, 0x58, 0xf0, 0x0,
    0x3, 0xf5, 0x8f, 0x0, 0x0, 0x3f, 0x58, 0xf0,
    0x0, 0x3, 0xf5, 0x8f, 0x0, 0x0, 0x3f, 0x58,
    0xf0, 0x0, 0x3, 0xf5, 0x8f, 0x0, 0x0, 0x3f,
    0x50,

    /* U+0440 "р" */
    0x8f, 0x2b, 0xfe, 0xb3, 0x0, 0x8f, 0xeb, 0x66,
    0xdf, 0x30, 0x8f, 0x90, 0x0, 0xd, 0xd0, 0x8f,
    0x10, 0x0, 0x7, 0xf2, 0x8f, 0x0, 0x0, 0x5,
    0xf3, 0x8f, 0x20, 0x0, 0x7, 0xf2, 0x8f, 0xa0,
    0x0, 0x1e, 0xd0, 0x8f, 0xec, 0x78, 0xef, 0x30,
    0x8f, 0x2a, 0xff, 0xb3, 0x0, 0x8f, 0x0, 0x0,
    0x0, 0x0, 0x8f, 0x0, 0x0, 0x0, 0x0, 0x8f,
    0x0, 0x0, 0x0, 0x0,

    /* U+0441 "с" */
    0x0, 0x2a, 0xef, 0xc4, 0x0, 0x3f, 0xe8, 0x7c,
    0xf5, 0xd, 0xd1, 0x0, 0x7, 0x13, 0xf6, 0x0,
    0x0, 0x0, 0x4f, 0x40, 0x0, 0x0, 0x3, 0xf6,
    0x0, 0x0, 0x0, 0xd, 0xd1, 0x0, 0x6, 0x10,
    0x3f, 0xe8, 0x7c, 0xf5, 0x0, 0x2a, 0xef, 0xc4,
    0x0,

    /* U+0442 "т" */
    0xff, 0xff, 0xff, 0xfd, 0x66, 0x6e, 0xd6, 0x65,
    0x0, 0xd, 0xb0, 0x0, 0x0, 0xd, 0xb0, 0x0,
    0x0, 0xd, 0xb0, 0x0, 0x0, 0xd, 0xb0, 0x0,
    0x0, 0xd, 0xb0, 0x0, 0x0, 0xd, 0xb0, 0x0,
    0x0, 0xd, 0xb0, 0x0,

    /* U+0443 "у" */
    0xb, 0xd0, 0x0, 0x0, 0xad, 0x0, 0x4f, 0x40,
    0x0, 0x1f, 0x60, 0x0, 0xdb, 0x0, 0x8, 0xe0,
    0x0, 0x7, 0xf2, 0x0, 0xe8, 0x0, 0x0, 0xf,
    0x80, 0x6f, 0x10, 0x0, 0x0, 0x9e, 0xc, 0xa0,
    0x0, 0x0, 0x2, 0xfa, 0xf3, 0x0, 0x0, 0x0,
    0xb, 0xfd, 0x0, 0x0, 0x0, 0x0, 0x5f, 0x60,
    0x0, 0x0, 0x0, 0x9, 0xe0, 0x0, 0x0, 0xb,
    0x78, 0xf7, 0x0, 0x0, 0x0, 0xae, 0xe8, 0x0,
    0x0, 0x0,

    /* U+0444 "ф" */
    0x0, 0x0, 0x5, 0xf3, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x5f, 0x30, 0x0, 0x0, 0x0, 0x0, 0x5,
    0xf3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5f, 0x30,
    0x0, 0x0, 0x0, 0x2a, 0xef, 0xff, 0xd9, 0x20,
    0x0, 0x4f, 0xe8, 0x9f, 0x89, 0xff, 0x20, 0xe,
    0xd1, 0x5, 0xf3, 0x2, 0xec, 0x3, 0xf5, 0x0,
    0x5f, 0x30, 0x7, 0xf1, 0x4f, 0x30, 0x5, 0xf3,
    0x0, 0x5f, 0x23, 0xf6, 0x0, 0x5f, 0x30, 0x8,
    0xf1, 0xe, 0xd1, 0x5, 0xf3, 0x2, 0xec, 0x0,
    0x4f, 0xe8, 0x9f, 0x89, 0xfe, 0x20, 0x0, 0x2a,
    0xef, 0xff, 0xd9, 0x10, 0x0, 0x0, 0x0, 0x5f,
    0x30, 0x0, 0x0, 0x0, 0x0, 0x5, 0xf3, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x5f, 0x30, 0x0, 0x0,

    /* U+0445 "х" */
    0x5f, 0x50, 0x0, 0xbe, 0x10, 0xaf, 0x20, 0x6f,
    0x40, 0x0, 0xdc, 0x3f, 0x80, 0x0, 0x3, 0xff,
    0xc0, 0x0, 0x0, 0xb, 0xf5, 0x0, 0x0, 0x5,
    0xfd, 0xe1, 0x0, 0x1, 0xe9, 0x1e, 0xb0, 0x0,
    0xcd, 0x0, 0x4f, 0x60, 0x8f, 0x30, 0x0, 0x9f,
    0x20,

    /* U+0446 "ц" */
    0x8f, 0x0, 0x0, 0x5f, 0x30, 0x8f, 0x0, 0x0,
    0x5f, 0x30, 0x8f, 0x0, 0x0, 0x5f, 0x30, 0x8f,
    0x0, 0x0, 0x5f, 0x30, 0x8f, 0x0, 0x0, 0x5f,
    0x30, 0x8f, 0x0, 0x0, 0x5f, 0x30, 0x8f, 0x0,
    0x0, 0x5f, 0x30, 0x8f, 0x66, 0x66, 0x9f, 0x83,
    0x8f, 0xff, 0xff, 0xff, 0xf8, 0x0, 0x0, 0x0,
    0x0, 0xe8, 0x0, 0x0, 0x0, 0x0, 0xe8, 0x0,
    0x0, 0x0, 0x0, 0x0,

    /* U+0447 "ч" */
    0x5f, 0x30, 0x0, 0x4f, 0x45, 0xf3, 0x0, 0x4,
    0xf4, 0x5f, 0x30, 0x0, 0x4f, 0x44, 0xf4, 0x0,
    0x4, 0xf4, 0x1f, 0xc3, 0x14, 0xaf, 0x40, 0x5e,
    0xff, 0xfc, 0xf4, 0x0, 0x2, 0x20, 0x4f, 0x40,
    0x0, 0x0, 0x4, 0xf4, 0x0, 0x0, 0x0, 0x4f,
    0x40,

    /* U+0448 "ш" */
    0x8f, 0x0, 0x3, 0xf4, 0x0, 0xf, 0x98, 0xf0,
    0x0, 0x3f, 0x40, 0x0, 0xf9, 0x8f, 0x0, 0x3,
    0xf4, 0x0, 0xf, 0x98, 0xf0, 0x0, 0x3f, 0x40,
    0x0, 0xf9, 0x8f, 0x0, 0x3, 0xf4, 0x0, 0xf,
    0x98, 0xf0, 0x0, 0x3f, 0x40, 0x0, 0xf9, 0x8f,
    0x0, 0x3, 0xf4, 0x0, 0xf, 0x98, 0xf6, 0x66,
    0x8f, 0x96, 0x66, 0xf9, 0x8f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x90,

    /* U+0449 "щ" */
    0x8f, 0x0, 0x4, 0xf4, 0x0, 0xf, 0x80, 0x8f,
    0x0, 0x4, 0xf4, 0x0, 0xf, 0x80, 0x8f, 0x0,
    0x4, 0xf4, 0x0, 0xf, 0x80, 0x8f, 0x0, 0x4,
    0xf4, 0x0, 0xf, 0x80, 0x8f, 0x0, 0x4, 0xf4,
    0x0, 0xf, 0x80, 0x8f, 0x0, 0x4, 0xf4, 0x0,
    0xf, 0x80, 0x8f, 0x0, 0x4, 0xf4, 0x0, 0xf,
    0x80, 0x8f, 0x66, 0x68, 0xf9, 0x66, 0x6f, 0xf5,
    0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xac, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xac,

    /* U+044A "ъ" */
    0xff, 0xff, 0x30, 0x0, 0x0, 0x66, 0x9f, 0x30,
    0x0, 0x0, 0x0, 0x5f, 0x30, 0x0, 0x0, 0x0,
    0x5f, 0xff, 0xfd, 0x70, 0x0, 0x5f, 0x53, 0x39,
    0xf6, 0x0, 0x5f, 0x30, 0x0, 0xea, 0x0, 0x5f,
    0x30, 0x0, 0xea, 0x0, 0x5f, 0x63, 0x4a, 0xf5,
    0x0, 0x5f, 0xff, 0xfd, 0x60,

    /* U+044B "ы" */
    0x8f, 0x0, 0x0, 0x0, 0x2f, 0x68, 0xf0, 0x0,
    0x0, 0x2, 0xf6, 0x8f, 0x0, 0x0, 0x0, 0x2f,
    0x68, 0xff, 0xff, 0xd5, 0x2, 0xf6, 0x8f, 0x33,
    0x4a, 0xf3, 0x2f, 0x68, 0xf0, 0x0, 0xf, 0x82,
    0xf6, 0x8f, 0x0, 0x0, 0xf8, 0x2f, 0x68, 0xf3,
    0x34, 0xbf, 0x32, 0xf6, 0x8f, 0xff, 0xfc, 0x40,
    0x2f, 0x60,

    /* U+044C "ь" */
    0x8f, 0x0, 0x0, 0x0, 0x8f, 0x0, 0x0, 0x0,
    0x8f, 0x0, 0x0, 0x0, 0x8f, 0xff, 0xfd, 0x60,
    0x8f, 0x33, 0x39, 0xf5, 0x8f, 0x0, 0x0, 0xea,
    0x8f, 0x0, 0x0, 0xf9, 0x8f, 0x33, 0x4a, 0xf4,
    0x8f, 0xff, 0xfd, 0x50,

    /* U+044D "э" */
    0x6, 0xcf, 0xeb, 0x40, 0x5, 0xf9, 0x56, 0xcf,
    0x60, 0x2, 0x0, 0x0, 0xaf, 0x10, 0x0, 0x0,
    0x2, 0xf6, 0x0, 0x3f, 0xff, 0xff, 0x70, 0x0,
    0x33, 0x34, 0xf6, 0x1, 0x0, 0x0, 0x9f, 0x15,
    0xf9, 0x66, 0xbf, 0x50, 0x6, 0xcf, 0xfb, 0x40,
    0x0,

    /* U+044E "ю" */
    0x8f, 0x0, 0x4, 0xbf, 0xfb, 0x30, 0x8, 0xf0,
    0x5, 0xfc, 0x66, 0xcf, 0x40, 0x8f, 0x0, 0xec,
    0x0, 0x0, 0xcd, 0x8, 0xf8, 0x9f, 0x50, 0x0,
    0x5, 0xf2, 0x8f, 0xff, 0xf3, 0x0, 0x0, 0x3f,
    0x48, 0xf0, 0x2f, 0x50, 0x0, 0x6, 0xf2, 0x8f,
    0x0, 0xdd, 0x0, 0x0, 0xdd, 0x8, 0xf0, 0x3,
    0xfd, 0x77, 0xdf, 0x40, 0x8f, 0x0, 0x3, 0xbf,
    0xfb, 0x30, 0x0,

    /* U+044F "я" */
    0x0, 0x8d, 0xff, 0xff, 0x40, 0xbf, 0x96, 0x67,
    0xf4, 0x1f, 0x90, 0x0, 0x1f, 0x41, 0xf7, 0x0,
    0x1, 0xf4, 0xd, 0xd2, 0x0, 0x1f, 0x40, 0x2c,
    0xff, 0xff, 0xf4, 0x0, 0x8f, 0x32, 0x3f, 0x40,
    0x3f, 0x60, 0x1, 0xf4, 0xd, 0xb0, 0x0, 0x1f,
    0x40,

    /* U+0450 "ѐ" */
    0x0, 0x57, 0x10, 0x0, 0x0, 0x0, 0x9, 0xe2,
    0x0, 0x0, 0x0, 0x0, 0x56, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3b, 0xfe, 0xa2,
    0x0, 0x4, 0xfc, 0x67, 0xde, 0x20, 0xe, 0xc0,
    0x0, 0xd, 0xa0, 0x3f, 0x50, 0x0, 0x7, 0xf0,
    0x4f, 0xff, 0xff, 0xff, 0xf1, 0x3f, 0x72, 0x22,
    0x22, 0x20, 0xd, 0xc0, 0x0, 0x2, 0x0, 0x4,
    0xfe, 0x87, 0xaf, 0x50, 0x0, 0x2a, 0xef, 0xd7,
    0x0,

    /* U+0451 "ё" */
    0x0, 0x3e, 0x13, 0xe1, 0x0, 0x0, 0x19, 0x2,
    0x90, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x3b, 0xfe, 0xa2, 0x0, 0x4, 0xfc, 0x67, 0xde,
    0x20, 0xe, 0xc0, 0x0, 0xd, 0xa0, 0x3f, 0x50,
    0x0, 0x7, 0xf0, 0x4f, 0xff, 0xff, 0xff, 0xf1,
    0x3f, 0x72, 0x22, 0x22, 0x20, 0xd, 0xc0, 0x0,
    0x2, 0x0, 0x4, 0xfe, 0x87, 0xaf, 0x50, 0x0,
    0x2a, 0xef, 0xd7, 0x0,

    /* U+0452 "ђ" */
    0x0, 0x8f, 0x0, 0x0, 0x0, 0x2, 0xff, 0xff,
    0xff, 0xc0, 0x0, 0x2, 0x9f, 0x22, 0x21, 0x0,
    0x0, 0x8, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x8f,
    0x2b, 0xff, 0xb2, 0x0, 0x8, 0xfe, 0xb7, 0x9f,
    0xe0, 0x0, 0x8f, 0x90, 0x0, 0x5f, 0x60, 0x8,
    0xf2, 0x0, 0x0, 0xf8, 0x0, 0x8f, 0x0, 0x0,
    0xf, 0x80, 0x8, 0xf0, 0x0, 0x0, 0xf8, 0x0,
    0x8f, 0x0, 0x0, 0xf, 0x80, 0x8, 0xf0, 0x0,
    0x0, 0xf8, 0x0, 0x8f, 0x0, 0x0, 0xf, 0x80,
    0x0, 0x0, 0x0, 0x0, 0xf7, 0x0, 0x0, 0x0,
    0x66, 0xaf, 0x30, 0x0, 0x0, 0xa, 0xfe, 0x70,

    /* U+0453 "ѓ" */
    0x0, 0x2, 0x20, 0x0, 0x0, 0xf9, 0x0, 0x0,
    0x4f, 0x10, 0x0, 0x0, 0x0, 0x0, 0x8f, 0xff,
    0xff, 0xb8, 0xf6, 0x66, 0x64, 0x8f, 0x0, 0x0,
    0x8, 0xf0, 0x0, 0x0, 0x8f, 0x0, 0x0, 0x8,
    0xf0, 0x0, 0x0, 0x8f, 0x0, 0x0, 0x8, 0xf0,
    0x0, 0x0, 0x8f, 0x0, 0x0, 0x0,

    /* U+0454 "є" */
    0x0, 0x2a, 0xef, 0xd8, 0x0, 0x3f, 0xd7, 0x58,
    0xe9, 0xd, 0xc0, 0x0, 0x1, 0x2, 0xf5, 0x0,
    0x0, 0x0, 0x4f, 0xff, 0xff, 0x60, 0x2, 0xf7,
    0x33, 0x31, 0x0, 0xd, 0xc0, 0x0, 0x1, 0x0,
    0x3f, 0xd6, 0x58, 0xe9, 0x0, 0x2a, 0xef, 0xd8,
    0x0,

    /* U+0455 "ѕ" */
    0x1, 0x9e, 0xfd, 0xa2, 0xb, 0xf8, 0x68, 0xd3,
    0xf, 0x80, 0x0, 0x0, 0xe, 0xe6, 0x20, 0x0,
    0x2, 0xcf, 0xfe, 0x90, 0x0, 0x1, 0x48, 0xfa,
    0x1, 0x0, 0x0, 0xcc, 0x1f, 0xb8, 0x69, 0xf8,
    0x6, 0xcf, 0xfd, 0x70,

    /* U+0456 "і" */
    0x8e, 0x1a, 0xf2, 0x0, 0x0, 0x0, 0x8f, 0x8,
    0xf0, 0x8f, 0x8, 0xf0, 0x8f, 0x8, 0xf0, 0x8f,
    0x8, 0xf0, 0x8f, 0x0,

    /* U+0457 "ї" */
    0x8a, 0x4d, 0x4, 0x62, 0x80, 0x0, 0x0, 0x0,
    0x9f, 0x0, 0x9, 0xf0, 0x0, 0x9f, 0x0, 0x9,
    0xf0, 0x0, 0x9f, 0x0, 0x9, 0xf0, 0x0, 0x9f,
    0x0, 0x9, 0xf0, 0x0, 0x9f, 0x0,

    /* U+0458 "ј" */
    0x0, 0x0, 0x0, 0x0, 0x9, 0xf2, 0x0, 0x8,
    0xe1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x8, 0xf0, 0x0, 0x8, 0xf0, 0x0, 0x8, 0xf0,
    0x0, 0x8, 0xf0, 0x0, 0x8, 0xf0, 0x0, 0x8,
    0xf0, 0x0, 0x8, 0xf0, 0x0, 0x8, 0xf0, 0x0,
    0x8, 0xf0, 0x0, 0x9, 0xf0, 0x28, 0x6e, 0xb0,
    0x4e, 0xfb, 0x10,

    /* U+0459 "љ" */
    0x0, 0xcf, 0xff, 0xff, 0xf0, 0x0, 0x0, 0x0,
    0xd, 0xb6, 0x66, 0xff, 0x0, 0x0, 0x0, 0x0,
    0xd8, 0x0, 0xf, 0xf0, 0x0, 0x0, 0x0, 0xe,
    0x70, 0x0, 0xff, 0xff, 0xfc, 0x30, 0x0, 0xf6,
    0x0, 0xf, 0xf3, 0x34, 0xcf, 0x10, 0x1f, 0x40,
    0x0, 0xff, 0x0, 0x3, 0xf5, 0x5, 0xf1, 0x0,
    0xf, 0xf0, 0x0, 0x4f, 0x55, 0xdd, 0x0, 0x0,
    0xff, 0x55, 0x6e, 0xe1, 0xde, 0x30, 0x0, 0xf,
    0xff, 0xfe, 0xb3, 0x0,

    /* U+045A "њ" */
    0x8f, 0x0, 0x0, 0x4f, 0x30, 0x0, 0x0, 0x8f,
    0x0, 0x0, 0x4f, 0x30, 0x0, 0x0, 0x8f, 0x0,
    0x0, 0x4f, 0x30, 0x0, 0x0, 0x8f, 0x21, 0x11,
    0x5f, 0x51, 0x10, 0x0, 0x8f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xb1, 0x8f, 0x54, 0x44, 0x8f, 0x74,
    0x58, 0xf9, 0x8f, 0x0, 0x0, 0x4f, 0x30, 0x0,
    0xcc, 0x8f, 0x0, 0x0, 0x4f, 0x63, 0x37, 0xf7,
    0x8f, 0x0, 0x0, 0x4f, 0xff, 0xfd, 0x70,

    /* U+045B "ћ" */
    0x0, 0x37, 0x0, 0x0, 0x0, 0x0, 0x8, 0xf0,
    0x0, 0x0, 0x0, 0x8f, 0xff, 0xff, 0xfd, 0x0,
    0x0, 0x8, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x8f,
    0x3b, 0xff, 0xb2, 0x0, 0x8, 0xfe, 0xb7, 0x9f,
    0xe0, 0x0, 0x8f, 0x90, 0x0, 0x6f, 0x50, 0x8,
    0xf2, 0x0, 0x0, 0xf8, 0x0, 0x8f, 0x0, 0x0,
    0xf, 0x80, 0x8, 0xf0, 0x0, 0x0, 0xf8, 0x0,
    0x8f, 0x0, 0x0, 0xf, 0x80, 0x8, 0xf0, 0x0,
    0x0, 0xf8, 0x0, 0x8f, 0x0, 0x0, 0xf, 0x80,

    /* U+045C "ќ" */
    0x0, 0x1, 0x30, 0x0, 0x0, 0x0, 0xbd, 0x0,
    0x0, 0x0, 0xf, 0x50, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x8f, 0x0, 0x0, 0xcc, 0x8, 0xf0,
    0x0, 0x8f, 0x20, 0x8f, 0x0, 0x3f, 0x60, 0x8,
    0xf1, 0x1d, 0xa0, 0x0, 0x8f, 0xff, 0xf3, 0x0,
    0x8, 0xf4, 0x5e, 0xc0, 0x0, 0x8f, 0x0, 0x4f,
    0x80, 0x8, 0xf0, 0x0, 0x8f, 0x40, 0x8f, 0x0,
    0x0, 0xce, 0x20,

    /* U+045D "ѝ" */
    0x1, 0x75, 0x0, 0x0, 0x0, 0x6, 0xf5, 0x0,
    0x0, 0x0, 0x5, 0xf3, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x8f, 0x0, 0x0, 0x3f, 0x98, 0xf0,
    0x0, 0x1e, 0xf9, 0x8f, 0x0, 0xc, 0xef, 0x98,
    0xf0, 0x9, 0xf3, 0xf9, 0x8f, 0x5, 0xf6, 0xf,
    0x98, 0xf3, 0xfa, 0x0, 0xf9, 0x8f, 0xec, 0x0,
    0xf, 0x98, 0xfe, 0x20, 0x0, 0xf9, 0x8f, 0x40,
    0x0, 0xf, 0x90,

    /* U+045E "ў" */
    0x0, 0x1e, 0x0, 0x4c, 0x0, 0x0, 0x0, 0xd5,
    0xb, 0x80, 0x0, 0x0, 0x3, 0xce, 0xa0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xb, 0xd0,
    0x0, 0x0, 0xad, 0x0, 0x4f, 0x40, 0x0, 0x1f,
    0x60, 0x0, 0xdb, 0x0, 0x8, 0xe0, 0x0, 0x7,
    0xf2, 0x0, 0xe8, 0x0, 0x0, 0xf, 0x80, 0x6f,
    0x10, 0x0, 0x0, 0x9e, 0xc, 0xa0, 0x0, 0x0,
    0x2, 0xfa, 0xf3, 0x0, 0x0, 0x0, 0xb, 0xfd,
    0x0, 0x0, 0x0, 0x0, 0x5f, 0x60, 0x0, 0x0,
    0x0, 0x9, 0xe0, 0x0, 0x0, 0xb, 0x78, 0xf7,
    0x0, 0x0, 0x0, 0xae, 0xe8, 0x0, 0x0, 0x0,

    /* U+045F "џ" */
    0x8f, 0x0, 0x0, 0xbd, 0x8f, 0x0, 0x0, 0xbd,
    0x8f, 0x0, 0x0, 0xbd, 0x8f, 0x0, 0x0, 0xbd,
    0x8f, 0x0, 0x0, 0xbd, 0x8f, 0x0, 0x0, 0xbd,
    0x8f, 0x0, 0x0, 0xbd, 0x8f, 0x66, 0x66, 0xdd,
    0x8f, 0xff, 0xff, 0xfd, 0x0, 0x8, 0xe0, 0x0,
    0x0, 0x8, 0xe0, 0x0,

    /* U+0462 "Ѣ" */
    0x0, 0x5, 0x60, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xbd, 0x0, 0x0, 0x0, 0x0, 0xbf, 0xff, 0xff,
    0xff, 0x40, 0x0, 0x2, 0x33, 0xce, 0x33, 0x30,
    0x0, 0x0, 0x0, 0xb, 0xd1, 0x11, 0x0, 0x0,
    0x0, 0x0, 0xbf, 0xff, 0xff, 0xe8, 0x0, 0x0,
    0xb, 0xe4, 0x44, 0x5a, 0xfb, 0x0, 0x0, 0xbd,
    0x0, 0x0, 0xa, 0xf2, 0x0, 0xb, 0xd0, 0x0,
    0x0, 0x5f, 0x50, 0x0, 0xbd, 0x0, 0x0, 0x5,
    0xf4, 0x0, 0xb, 0xd0, 0x0, 0x0, 0xbf, 0x10,
    0x0, 0xbe, 0x55, 0x56, 0xbf, 0x80, 0x0, 0xb,
    0xff, 0xff, 0xfc, 0x60, 0x0,

    /* U+0463 "ѣ" */
    0x0, 0x75, 0x0, 0x0, 0x0, 0x0, 0xea, 0x0,
    0x0, 0x0, 0x0, 0xea, 0x0, 0x0, 0x0, 0x0,
    0xea, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xc0,
    0x0, 0x22, 0xeb, 0x22, 0x20, 0x0, 0x0, 0xea,
    0x0, 0x0, 0x0, 0x0, 0xef, 0xff, 0xeb, 0x20,
    0x0, 0xeb, 0x33, 0x5d, 0xe0, 0x0, 0xea, 0x0,
    0x5, 0xf4, 0x0, 0xea, 0x0, 0x5, 0xf3, 0x0,
    0xeb, 0x33, 0x5e, 0xd0, 0x0, 0xef, 0xff, 0xea,
    0x20,

    /* U+046A "Ѫ" */
    0x6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x0,
    0x2e, 0xc4, 0x44, 0x44, 0x48, 0xf6, 0x0, 0x0,
    0x4f, 0x60, 0x0, 0x1, 0xea, 0x0, 0x0, 0x0,
    0x7f, 0x30, 0x0, 0xcc, 0x0, 0x0, 0x0, 0x0,
    0xae, 0x10, 0x9e, 0x10, 0x0, 0x0, 0x0, 0x0,
    0xdc, 0x6f, 0x40, 0x0, 0x0, 0x0, 0x6, 0xef,
    0xff, 0xff, 0xa1, 0x0, 0x0, 0x7, 0xfa, 0x4a,
    0xf3, 0x7e, 0xd0, 0x0, 0x2, 0xf9, 0x0, 0x8f,
    0x0, 0x3f, 0x90, 0x0, 0xaf, 0x10, 0x8, 0xf0,
    0x0, 0x9f, 0x10, 0x1f, 0x90, 0x0, 0x8f, 0x0,
    0x2, 0xf7, 0x8, 0xf2, 0x0, 0x8, 0xf0, 0x0,
    0xb, 0xe0,

    /* U+046B "ѫ" */
    0xc, 0xff, 0xff, 0xff, 0xff, 0x0, 0x5, 0xf5,
    0x22, 0x23, 0xe8, 0x0, 0x0, 0x6e, 0x20, 0x1d,
    0x90, 0x0, 0x0, 0x7, 0xe2, 0xca, 0x0, 0x0,
    0x0, 0x5d, 0xff, 0xfe, 0x80, 0x0, 0x4, 0xf8,
    0x3f, 0x65, 0xf8, 0x0, 0xc, 0xb0, 0x1f, 0x40,
    0x7f, 0x10, 0x2f, 0x40, 0x1f, 0x40, 0x1f, 0x60,
    0x8e, 0x0, 0x1f, 0x40, 0xa, 0xd0,

    /* U+0472 "Ѳ" */
    0x0, 0x1, 0x9d, 0xfe, 0xb5, 0x0, 0x0, 0x4,
    0xff, 0xb8, 0x9d, 0xfb, 0x0, 0x2, 0xfc, 0x20,
    0x0, 0x6, 0xfa, 0x0, 0xae, 0x10, 0x0, 0x0,
    0x8, 0xf3, 0xf, 0x91, 0x11, 0x11, 0x11, 0x2f,
    0x82, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x2f,
    0xa4, 0x44, 0x44, 0x44, 0x4f, 0xa0, 0xfc, 0x0,
    0x0, 0x0, 0x3, 0xf8, 0xa, 0xf4, 0x0, 0x0,
    0x0, 0xcf, 0x30, 0x2f, 0xe4, 0x0, 0x0, 0x9f,
    0xa0, 0x0, 0x4f, 0xfb, 0x89, 0xef, 0xb0, 0x0,
    0x0, 0x19, 0xdf, 0xeb, 0x50, 0x0,

    /* U+0473 "ѳ" */
    0x0, 0x2a, 0xef, 0xc6, 0x0, 0x3, 0xfc, 0x65,
    0x9f, 0x90, 0xd, 0xc0, 0x0, 0x7, 0xf3, 0x3f,
    0x50, 0x0, 0x0, 0xf8, 0x4f, 0xff, 0xff, 0xff,
    0xfa, 0x3f, 0x62, 0x22, 0x22, 0xf8, 0xd, 0xc0,
    0x0, 0x6, 0xf3, 0x3, 0xfc, 0x65, 0x9f, 0x90,
    0x0, 0x2a, 0xef, 0xc6, 0x0,

    /* U+0474 "Ѵ" */
    0x9f, 0x20, 0x0, 0x0, 0x9, 0xfe, 0x3f, 0x80,
    0x0, 0x0, 0x7f, 0xc8, 0xd, 0xe0, 0x0, 0x0,
    0xec, 0x0, 0x7, 0xf5, 0x0, 0x4, 0xf4, 0x0,
    0x1, 0xfb, 0x0, 0xa, 0xe0, 0x0, 0x0, 0xaf,
    0x10, 0xf, 0x90, 0x0, 0x0, 0x4f, 0x70, 0x5f,
    0x40, 0x0, 0x0, 0xe, 0xd0, 0xae, 0x0, 0x0,
    0x0, 0x8, 0xf4, 0xf9, 0x0, 0x0, 0x0, 0x2,
    0xfe, 0xf4, 0x0, 0x0, 0x0, 0x0, 0xcf, 0xe0,
    0x0, 0x0, 0x0, 0x0, 0x5f, 0x90, 0x0, 0x0,

    /* U+0475 "ѵ" */
    0xbf, 0x0, 0x0, 0xb, 0xf6, 0x4f, 0x60, 0x0,
    0x7f, 0x93, 0xd, 0xc0, 0x0, 0xdb, 0x0, 0x7,
    0xf3, 0x3, 0xf5, 0x0, 0x1, 0xf9, 0x9, 0xf0,
    0x0, 0x0, 0xaf, 0x1e, 0x90, 0x0, 0x0, 0x3f,
    0xaf, 0x30, 0x0, 0x0, 0xd, 0xfd, 0x0, 0x0,
    0x0, 0x6, 0xf8, 0x0, 0x0,

    /* U+048A "Ҋ" */
    0x0, 0x1f, 0x30, 0x2f, 0x20, 0x0, 0x0, 0x0,
    0x5d, 0xed, 0x60, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x4, 0xf5, 0x0, 0x0, 0x6,
    0xf6, 0x0, 0x4f, 0x50, 0x0, 0x2, 0xff, 0x60,
    0x4, 0xf5, 0x0, 0x0, 0xdf, 0xf6, 0x0, 0x4f,
    0x50, 0x0, 0x9f, 0x7f, 0x60, 0x4, 0xf5, 0x0,
    0x4f, 0x92, 0xf6, 0x0, 0x4f, 0x50, 0x1e, 0xd0,
    0x2f, 0x60, 0x4, 0xf5, 0xb, 0xf2, 0x2, 0xf6,
    0x0, 0x4f, 0x56, 0xf7, 0x0, 0x2f, 0x60, 0x4,
    0xf7, 0xfb, 0x0, 0x2, 0xf6, 0x0, 0x4f, 0xfe,
    0x10, 0x0, 0x2f, 0x60, 0x4, 0xff, 0x40, 0x0,
    0x3, 0xfe, 0x70, 0x4f, 0x90, 0x0, 0x0, 0x5f,
    0xfc, 0x0, 0x0, 0x0, 0x0, 0x0, 0xe, 0x70,
    0x0, 0x0, 0x0, 0x0, 0x2, 0xf2, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x27, 0x0,

    /* U+048B "ҋ" */
    0x0, 0x70, 0x0, 0x70, 0x0, 0x0, 0xe5, 0x7,
    0xc0, 0x0, 0x0, 0x3c, 0xeb, 0x20, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x8f, 0x0, 0x0, 0x3f,
    0x90, 0x8f, 0x0, 0x1, 0xef, 0x90, 0x8f, 0x0,
    0xc, 0xef, 0x90, 0x8f, 0x0, 0x8f, 0x4f, 0x90,
    0x8f, 0x5, 0xf7, 0xf, 0x90, 0x8f, 0x3f, 0xa0,
    0xf, 0x90, 0x8f, 0xdd, 0x0, 0xf, 0x90, 0x8f,
    0xe2, 0x0, 0xf, 0xf5, 0x8f, 0x40, 0x0, 0xf,
    0xfb, 0x0, 0x0, 0x0, 0x0, 0xe6, 0x0, 0x0,
    0x0, 0x1, 0xf2,

    /* U+048C "Ҍ" */
    0x0, 0x65, 0x0, 0x0, 0x0, 0x0, 0x0, 0xdb,
    0x0, 0x0, 0x0, 0x0, 0x8f, 0xff, 0xff, 0xf2,
    0x0, 0x0, 0x13, 0xec, 0x33, 0x30, 0x0, 0x0,
    0x0, 0xdc, 0x11, 0x10, 0x0, 0x0, 0x0, 0xdf,
    0xff, 0xff, 0xd7, 0x0, 0x0, 0xdc, 0x44, 0x45,
    0xbf, 0x90, 0x0, 0xdb, 0x0, 0x0, 0xc, 0xf0,
    0x0, 0xdb, 0x0, 0x0, 0x8, 0xf2, 0x0, 0xdb,
    0x0, 0x0, 0x8, 0xf2, 0x0, 0xdb, 0x0, 0x0,
    0xd, 0xe0, 0x0, 0xdd, 0x55, 0x56, 0xcf, 0x60,
    0x0, 0xdf, 0xff, 0xff, 0xc5, 0x0,

    /* U+048D "ҍ" */
    0x0, 0xf8, 0x0, 0x0, 0x0, 0xaf, 0xff, 0xff,
    0xa0, 0x0, 0x13, 0xf9, 0x33, 0x20, 0x0, 0x0,
    0xff, 0xff, 0xeb, 0x20, 0x0, 0xf9, 0x33, 0x5d,
    0xd0, 0x0, 0xf8, 0x0, 0x6, 0xf2, 0x0, 0xf8,
    0x0, 0x7, 0xf2, 0x0, 0xfa, 0x33, 0x6e, 0xc0,
    0x0, 0xff, 0xff, 0xea, 0x10,

    /* U+048E "Ҏ" */
    0x4f, 0xff, 0xff, 0xd8, 0x0, 0x4f, 0xa7, 0x78,
    0xbf, 0xd0, 0x4f, 0x50, 0x0, 0x5, 0xf7, 0x4f,
    0x50, 0x0, 0x0, 0xeb, 0x4f, 0x50, 0x4d, 0x0,
    0xeb, 0x4f, 0x50, 0xc, 0x92, 0xf9, 0x4f, 0x62,
    0x24, 0xfe, 0xf2, 0x4f, 0xff, 0xff, 0xff, 0x50,
    0x4f, 0x85, 0x54, 0x2a, 0xc0, 0x4f, 0x50, 0x0,
    0x1, 0xe5, 0x4f, 0x50, 0x0, 0x0, 0x20, 0x4f,
    0x50, 0x0, 0x0, 0x0,

    /* U+048F "ҏ" */
    0x8f, 0x19, 0xef, 0xc4, 0x0, 0x8f, 0xcb, 0x66,
    0xdf, 0x40, 0x8f, 0xa0, 0x0, 0xc, 0xe0, 0x8f,
    0x20, 0x0, 0x5, 0xf3, 0x8f, 0x0, 0x0, 0x3,
    0xf4, 0x8f, 0x30, 0x9, 0x45, 0xf3, 0x8f, 0xa0,
    0x5, 0xed, 0xe0, 0x8f, 0xcc, 0x77, 0xff, 0x50,
    0x8f, 0x19, 0xef, 0xcd, 0x90, 0x8f, 0x0, 0x0,
    0x2, 0xa0, 0x8f, 0x0, 0x0, 0x0, 0x0, 0x8f,
    0x0, 0x0, 0x0, 0x0,

    /* U+0490 "Ґ" */
    0x0, 0x0, 0x0, 0x6f, 0x10, 0x0, 0x0, 0x6,
    0xf1, 0x4f, 0xff, 0xff, 0xff, 0x14, 0xfa, 0x77,
    0x77, 0x70, 0x4f, 0x50, 0x0, 0x0, 0x4, 0xf5,
    0x0, 0x0, 0x0, 0x4f, 0x50, 0x0, 0x0, 0x4,
    0xf5, 0x0, 0x0, 0x0, 0x4f, 0x50, 0x0, 0x0,
    0x4, 0xf5, 0x0, 0x0, 0x0, 0x4f, 0x50, 0x0,
    0x0, 0x4, 0xf5, 0x0, 0x0, 0x0, 0x4f, 0x50,
    0x0, 0x0, 0x4, 0xf5, 0x0, 0x0, 0x0,

    /* U+0491 "ґ" */
    0x0, 0x0, 0x8, 0x20, 0x0, 0x1, 0xf5, 0x8f,
    0xff, 0xff, 0x58, 0xf6, 0x66, 0x62, 0x8f, 0x0,
    0x0, 0x8, 0xf0, 0x0, 0x0, 0x8f, 0x0, 0x0,
    0x8, 0xf0, 0x0, 0x0, 0x8f, 0x0, 0x0, 0x8,
    0xf0, 0x0, 0x0, 0x8f, 0x0, 0x0, 0x0,

    /* U+0492 "Ғ" */
    0x0, 0xdf, 0xff, 0xff, 0xf8, 0x0, 0xdd, 0x77,
    0x77, 0x73, 0x0, 0xdb, 0x0, 0x0, 0x0, 0x0,
    0xdb, 0x0, 0x0, 0x0, 0x0, 0xdb, 0x0, 0x0,
    0x0, 0x0, 0xdc, 0x0, 0x0, 0x0, 0x8f, 0xff,
    0xff, 0xff, 0x70, 0x13, 0xdc, 0x33, 0x33, 0x10,
    0x0, 0xdc, 0x0, 0x0, 0x0, 0x0, 0xdc, 0x0,
    0x0, 0x0, 0x0, 0xdc, 0x0, 0x0, 0x0, 0x0,
    0xdc, 0x0, 0x0, 0x0,

    /* U+0493 "ғ" */
    0x4, 0xff, 0xff, 0xff, 0x4, 0xf9, 0x66, 0x66,
    0x4, 0xf4, 0x0, 0x0, 0x4, 0xf4, 0x0, 0x0,
    0x4, 0xf4, 0x0, 0x0, 0x4f, 0xff, 0xff, 0xd0,
    0x5, 0xf6, 0x22, 0x20, 0x4, 0xf4, 0x0, 0x0,
    0x4, 0xf4, 0x0, 0x0,

    /* U+0494 "Ҕ" */
    0x4f, 0xff, 0xff, 0xff, 0x60, 0x4f, 0xa7, 0x77,
    0x77, 0x20, 0x4f, 0x50, 0x0, 0x0, 0x0, 0x4f,
    0x50, 0x0, 0x0, 0x0, 0x4f, 0x50, 0x0, 0x0,
    0x0, 0x4f, 0x9c, 0xff, 0xe7, 0x0, 0x4f, 0xf9,
    0x55, 0xaf, 0x90, 0x4f, 0x50, 0x0, 0xa, 0xf2,
    0x4f, 0x50, 0x0, 0x3, 0xf6, 0x4f, 0x50, 0x0,
    0x1, 0xf7, 0x4f, 0x50, 0x0, 0x3, 0xf6, 0x4f,
    0x50, 0x0, 0xa, 0xf1, 0x0, 0x0, 0x13, 0x9f,
    0x80, 0x0, 0x0, 0xbf, 0xf9, 0x0, 0x0, 0x0,
    0x34, 0x10, 0x0,

    /* U+0495 "ҕ" */
    0x8f, 0xff, 0xff, 0x80, 0x8, 0xf6, 0x66, 0x63,
    0x0, 0x8f, 0x0, 0x0, 0x0, 0x8, 0xf0, 0x1,
    0x0, 0x0, 0x8f, 0xaf, 0xff, 0x90, 0x8, 0xfb,
    0x65, 0x9f, 0x90, 0x8f, 0x0, 0x0, 0xaf, 0x18,
    0xf0, 0x0, 0x5, 0xf3, 0x8f, 0x0, 0x0, 0x6f,
    0x20, 0x0, 0x0, 0xc, 0xe0, 0x0, 0x6, 0x8d,
    0xf5, 0x0, 0x0, 0xef, 0xc5, 0x0,

    /* U+0496 "Җ" */
    0x2f, 0x90, 0x0, 0x9, 0xf0, 0x0, 0x2, 0xf8,
    0x0, 0x8f, 0x30, 0x0, 0x9f, 0x0, 0x0, 0xce,
    0x0, 0x0, 0xec, 0x0, 0x9, 0xf0, 0x0, 0x6f,
    0x40, 0x0, 0x5, 0xf6, 0x0, 0x9f, 0x0, 0x1e,
    0xa0, 0x0, 0x0, 0xc, 0xf3, 0x29, 0xf2, 0x2a,
    0xe1, 0x0, 0x0, 0x0, 0x3f, 0xff, 0xff, 0xff,
    0xf9, 0x0, 0x0, 0x0, 0x7, 0xf6, 0x5b, 0xf5,
    0x5c, 0xf1, 0x0, 0x0, 0x1, 0xfa, 0x0, 0x9f,
    0x0, 0x3f, 0x90, 0x0, 0x0, 0xaf, 0x10, 0x9,
    0xf0, 0x0, 0xaf, 0x30, 0x0, 0x3f, 0x80, 0x0,
    0x9f, 0x0, 0x2, 0xfb, 0x0, 0xd, 0xe0, 0x0,
    0x9, 0xf0, 0x0, 0x9, 0xfc, 0x66, 0xf6, 0x0,
    0x0, 0x9f, 0x0, 0x0, 0x1f, 0xfd, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xa, 0xd0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xad, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5, 0x60,

    /* U+0497 "җ" */
    0x4f, 0x50, 0x0, 0xf8, 0x0, 0xc, 0xd0, 0xa,
    0xe0, 0x0, 0xf8, 0x0, 0x6f, 0x30, 0x1, 0xf8,
    0x0, 0xf8, 0x0, 0xea, 0x0, 0x0, 0x6f, 0x31,
    0xf9, 0x19, 0xf1, 0x0, 0x0, 0x1f, 0xff, 0xff,
    0xff, 0x90, 0x0, 0x0, 0x9f, 0x64, 0xfa, 0x4b,
    0xf2, 0x0, 0x3, 0xf9, 0x0, 0xf8, 0x1, 0xfc,
    0x0, 0xd, 0xe0, 0x0, 0xf8, 0x0, 0x6f, 0xc6,
    0x8f, 0x50, 0x0, 0xf8, 0x0, 0xf, 0xff, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6f, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x6f,

    /* U+0498 "Ҙ" */
    0x4, 0xad, 0xfe, 0xa3, 0x0, 0xf, 0xd9, 0x89,
    0xef, 0x40, 0x2, 0x0, 0x0, 0x1e, 0xc0, 0x0,
    0x0, 0x0, 0xd, 0xc0, 0x0, 0x1, 0x12, 0x7f,
    0x60, 0x0, 0x6f, 0xff, 0xf9, 0x0, 0x0, 0x14,
    0x45, 0x8f, 0x90, 0x0, 0x0, 0x0, 0x7, 0xf2,
    0x0, 0x0, 0x0, 0x5, 0xf4, 0x15, 0x0, 0x0,
    0xb, 0xf2, 0x4f, 0xc7, 0x68, 0xdf, 0x80, 0x4,
    0xbf, 0xff, 0xb5, 0x0, 0x0, 0x0, 0xe9, 0x0,
    0x0, 0x0, 0x0, 0xe9, 0x0, 0x0, 0x0, 0x0,
    0x74, 0x0, 0x0,

    /* U+0499 "ҙ" */
    0x7, 0xcf, 0xfc, 0x50, 0xe, 0x96, 0x7d, 0xf4,
    0x0, 0x0, 0x0, 0xf9, 0x0, 0x0, 0x6, 0xf4,
    0x0, 0x4f, 0xff, 0x90, 0x0, 0x2, 0x36, 0xf7,
    0x0, 0x0, 0x0, 0xcc, 0x4c, 0x63, 0x48, 0xf9,
    0x2a, 0xff, 0xff, 0x90, 0x0, 0xb, 0xc0, 0x0,
    0x0, 0xb, 0xc0, 0x0,

    /* U+049A "Қ" */
    0x4f, 0x40, 0x0, 0x3, 0xf8, 0x4, 0xf4, 0x0,
    0x0, 0xdc, 0x0, 0x4f, 0x40, 0x0, 0x9e, 0x10,
    0x4, 0xf4, 0x0, 0x5f, 0x50, 0x0, 0x4f, 0x62,
    0x3e, 0x90, 0x0, 0x4, 0xff, 0xff, 0xf1, 0x0,
    0x0, 0x4f, 0x85, 0x7f, 0x90, 0x0, 0x4, 0xf4,
    0x0, 0xaf, 0x30, 0x0, 0x4f, 0x40, 0x1, 0xed,
    0x0, 0x4, 0xf4, 0x0, 0x5, 0xf7, 0x0, 0x4f,
    0x40, 0x0, 0xb, 0xfa, 0x64, 0xf4, 0x0, 0x0,
    0x1f, 0xfd, 0x0, 0x0, 0x0, 0x0, 0xa, 0xd0,
    0x0, 0x0, 0x0, 0x0, 0xad, 0x0, 0x0, 0x0,
    0x0, 0x5, 0x60,

    /* U+049B "қ" */
    0x8f, 0x0, 0x0, 0xcc, 0x0, 0x8f, 0x0, 0x8,
    0xf2, 0x0, 0x8f, 0x0, 0x3f, 0x60, 0x0, 0x8f,
    0x11, 0xda, 0x0, 0x0, 0x8f, 0xff, 0xf3, 0x0,
    0x0, 0x8f, 0x45, 0xec, 0x0, 0x0, 0x8f, 0x0,
    0x4f, 0x80, 0x0, 0x8f, 0x0, 0x8, 0xfa, 0x60,
    0x8f, 0x0, 0x0, 0xff, 0xf1, 0x0, 0x0, 0x0,
    0x5, 0xf1, 0x0, 0x0, 0x0, 0x5, 0xf1,

    /* U+049C "Ҝ" */
    0x4f, 0x50, 0x0, 0x0, 0xcd, 0x4, 0xf5, 0x0,
    0x0, 0x6f, 0x40, 0x4f, 0x50, 0x0, 0x1f, 0x90,
    0x4, 0xf5, 0x9a, 0xb, 0xe0, 0x0, 0x4f, 0x69,
    0xa6, 0xf4, 0x0, 0x4, 0xff, 0xff, 0xfd, 0x0,
    0x0, 0x4f, 0x8b, 0xb9, 0xf4, 0x0, 0x4, 0xf5,
    0x9a, 0xe, 0xd0, 0x0, 0x4f, 0x59, 0xa0, 0x5f,
    0x70, 0x4, 0xf5, 0x12, 0x0, 0xcf, 0x10, 0x4f,
    0x50, 0x0, 0x3, 0xfa, 0x4, 0xf5, 0x0, 0x0,
    0x9, 0xf4,

    /* U+049D "ҝ" */
    0x8f, 0x0, 0x0, 0x8f, 0x18, 0xf0, 0x0, 0x2f,
    0x70, 0x8f, 0x2a, 0xb, 0xc0, 0x8, 0xf4, 0xe6,
    0xf3, 0x0, 0x8f, 0xff, 0xfc, 0x0, 0x8, 0xf6,
    0xe8, 0xf4, 0x0, 0x8f, 0x3e, 0xc, 0xe1, 0x8,
    0xf0, 0x0, 0x2f, 0xa0, 0x8f, 0x0, 0x0, 0x7f,
    0x40,

    /* U+049E "Ҟ" */
    0x0, 0xea, 0x0, 0x0, 0xc, 0xd0, 0x0, 0xea,
    0x0, 0x0, 0x8f, 0x30, 0x7f, 0xff, 0xff, 0x64,
    0xf6, 0x0, 0x13, 0xeb, 0x33, 0x2e, 0xb0, 0x0,
    0x0, 0xeb, 0x22, 0xbe, 0x10, 0x0, 0x0, 0xef,
    0xff, 0xf6, 0x0, 0x0, 0x0, 0xec, 0x55, 0xde,
    0x0, 0x0, 0x0, 0xea, 0x0, 0x4f, 0x90, 0x0,
    0x0, 0xea, 0x0, 0x9, 0xf3, 0x0, 0x0, 0xea,
    0x0, 0x1, 0xed, 0x0, 0x0, 0xea, 0x0, 0x0,
    0x5f, 0x70, 0x0, 0xea, 0x0, 0x0, 0xb, 0xf2,

    /* U+049F "ҟ" */
    0x3, 0x70, 0x0, 0x0, 0x0, 0x8, 0xf0, 0x0,
    0x0, 0x0, 0xff, 0xff, 0xf7, 0x0, 0x0, 0x29,
    0xf3, 0x21, 0x0, 0x0, 0x8, 0xf0, 0x0, 0xc,
    0xd0, 0x8, 0xf0, 0x0, 0x8f, 0x20, 0x8, 0xf0,
    0x3, 0xf6, 0x0, 0x8, 0xf2, 0x1d, 0xa0, 0x0,
    0x8, 0xff, 0xff, 0x30, 0x0, 0x8, 0xf5, 0x5e,
    0xc0, 0x0, 0x8, 0xf0, 0x4, 0xf8, 0x0, 0x8,
    0xf0, 0x0, 0x8f, 0x40, 0x8, 0xf0, 0x0, 0xc,
    0xe2,

    /* U+04A0 "Ҡ" */
    0xcf, 0xff, 0xf2, 0x0, 0x0, 0x4f, 0x65, 0x77,
    0xaf, 0x20, 0x0, 0x1e, 0xa0, 0x0, 0x6, 0xf2,
    0x0, 0xb, 0xd0, 0x0, 0x0, 0x6f, 0x20, 0x7,
    0xf3, 0x0, 0x0, 0x6, 0xf4, 0x24, 0xf7, 0x0,
    0x0, 0x0, 0x6f, 0xff, 0xfe, 0x0, 0x0, 0x0,
    0x6, 0xf7, 0x58, 0xf7, 0x0, 0x0, 0x0, 0x6f,
    0x20, 0xb, 0xf1, 0x0, 0x0, 0x6, 0xf2, 0x0,
    0x2f, 0xb0, 0x0, 0x0, 0x6f, 0x20, 0x0, 0x7f,
    0x50, 0x0, 0x6, 0xf2, 0x0, 0x0, 0xce, 0x10,
    0x0, 0x6f, 0x20, 0x0, 0x2, 0xfa,

    /* U+04A1 "ҡ" */
    0xff, 0xff, 0x30, 0x0, 0xae, 0x15, 0x69, 0xf3,
    0x0, 0x5f, 0x40, 0x0, 0x5f, 0x30, 0x1e, 0x90,
    0x0, 0x5, 0xf4, 0x1b, 0xd0, 0x0, 0x0, 0x5f,
    0xff, 0xf5, 0x0, 0x0, 0x5, 0xf6, 0x4d, 0xe1,
    0x0, 0x0, 0x5f, 0x30, 0x2f, 0xb0, 0x0, 0x5,
    0xf3, 0x0, 0x5f, 0x70, 0x0, 0x5f, 0x30, 0x0,
    0x9f, 0x30,

    /* U+04A2 "Ң" */
    0x4f, 0x50, 0x0, 0x0, 0x3f, 0x50, 0x4, 0xf5,
    0x0, 0x0, 0x3, 0xf5, 0x0, 0x4f, 0x50, 0x0,
    0x0, 0x3f, 0x50, 0x4, 0xf5, 0x0, 0x0, 0x3,
    0xf5, 0x0, 0x4f, 0x62, 0x22, 0x22, 0x5f, 0x50,
    0x4, 0xff, 0xff, 0xff, 0xff, 0xf5, 0x0, 0x4f,
    0x85, 0x55, 0x55, 0x7f, 0x50, 0x4, 0xf5, 0x0,
    0x0, 0x3, 0xf5, 0x0, 0x4f, 0x50, 0x0, 0x0,
    0x3f, 0x50, 0x4, 0xf5, 0x0, 0x0, 0x3, 0xf5,
    0x0, 0x4f, 0x50, 0x0, 0x0, 0x5f, 0xd7, 0x4,
    0xf5, 0x0, 0x0, 0x6, 0xff, 0xf1, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x6f, 0x10, 0x0, 0x0, 0x0,
    0x0, 0x6, 0xf1, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x38, 0x0,

    /* U+04A3 "ң" */
    0x8f, 0x0, 0x0, 0x2f, 0x60, 0x8f, 0x0, 0x0,
    0x2f, 0x60, 0x8f, 0x0, 0x0, 0x2f, 0x60, 0x8f,
    0x11, 0x11, 0x3f, 0x60, 0x8f, 0xff, 0xff, 0xff,
    0x60, 0x8f, 0x44, 0x44, 0x6f, 0x60, 0x8f, 0x0,
    0x0, 0x2f, 0x60, 0x8f, 0x0, 0x0, 0x3f, 0xc4,
    0x8f, 0x0, 0x0, 0x5f, 0xfb, 0x0, 0x0, 0x0,
    0x0, 0xbb, 0x0, 0x0, 0x0, 0x0, 0xbb,

    /* U+04A4 "Ҥ" */
    0x4f, 0x50, 0x0, 0x0, 0x6f, 0xff, 0xff, 0xff,
    0x24, 0xf5, 0x0, 0x0, 0x6, 0xff, 0x77, 0x77,
    0x71, 0x4f, 0x50, 0x0, 0x0, 0x6f, 0xc0, 0x0,
    0x0, 0x4, 0xf5, 0x0, 0x0, 0x6, 0xfc, 0x0,
    0x0, 0x0, 0x4f, 0x62, 0x22, 0x22, 0x8f, 0xc0,
    0x0, 0x0, 0x4, 0xff, 0xff, 0xff, 0xff, 0xfc,
    0x0, 0x0, 0x0, 0x4f, 0x85, 0x55, 0x55, 0xaf,
    0xc0, 0x0, 0x0, 0x4, 0xf5, 0x0, 0x0, 0x6,
    0xfc, 0x0, 0x0, 0x0, 0x4f, 0x50, 0x0, 0x0,
    0x6f, 0xc0, 0x0, 0x0, 0x4, 0xf5, 0x0, 0x0,
    0x6, 0xfc, 0x0, 0x0, 0x0, 0x4f, 0x50, 0x0,
    0x0, 0x6f, 0xc0, 0x0, 0x0, 0x4, 0xf5, 0x0,
    0x0, 0x6, 0xfc, 0x0, 0x0, 0x0,

    /* U+04A5 "ҥ" */
    0x8f, 0x0, 0x0, 0x5f, 0xff, 0xff, 0xf1, 0x8f,
    0x0, 0x0, 0x5f, 0xf6, 0x66, 0x60, 0x8f, 0x0,
    0x0, 0x5f, 0xc0, 0x0, 0x0, 0x8f, 0x11, 0x11,
    0x6f, 0xc0, 0x0, 0x0, 0x8f, 0xff, 0xff, 0xff,
    0xc0, 0x0, 0x0, 0x8f, 0x44, 0x44, 0x8f, 0xc0,
    0x0, 0x0, 0x8f, 0x0, 0x0, 0x5f, 0xc0, 0x0,
    0x0, 0x8f, 0x0, 0x0, 0x5f, 0xc0, 0x0, 0x0,
    0x8f, 0x0, 0x0, 0x5f, 0xc0, 0x0, 0x0,

    /* U+04A6 "Ҧ" */
    0x4f, 0xff, 0xff, 0xff, 0xff, 0x60, 0x0, 0x0,
    0x0, 0x4f, 0xa7, 0x77, 0x77, 0x8f, 0x60, 0x0,
    0x0, 0x0, 0x4f, 0x50, 0x0, 0x0, 0x2f, 0x60,
    0x0, 0x0, 0x0, 0x4f, 0x50, 0x0, 0x0, 0x2f,
    0x60, 0x0, 0x0, 0x0, 0x4f, 0x50, 0x0, 0x0,
    0x2f, 0x60, 0x0, 0x0, 0x0, 0x4f, 0x50, 0x0,
    0x0, 0x2f, 0xac, 0xff, 0xe8, 0x0, 0x4f, 0x50,
    0x0, 0x0, 0x2f, 0xf9, 0x55, 0xaf, 0xa0, 0x4f,
    0x50, 0x0, 0x0, 0x2f, 0x60, 0x0, 0xa, 0xf2,
    0x4f, 0x50, 0x0, 0x0, 0x2f, 0x60, 0x0, 0x3,
    0xf6, 0x4f, 0x50, 0x0, 0x0, 0x2f, 0x60, 0x0,
    0x1, 0xf7, 0x4f, 0x50, 0x0, 0x0, 0x2f, 0x60,
    0x0, 0x3, 0xf6, 0x4f, 0x50, 0x0, 0x0, 0x2f,
    0x60, 0x0, 0xa, 0xf1, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x12, 0x8f, 0x90, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xbf, 0xf9, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x24, 0x10, 0x0,

    /* U+04A7 "ҧ" */
    0x8f, 0xff, 0xff, 0xff, 0x20, 0x0, 0x0, 0x8,
    0xf6, 0x66, 0x6a, 0xf2, 0x0, 0x0, 0x0, 0x8f,
    0x0, 0x0, 0x6f, 0x20, 0x0, 0x0, 0x8, 0xf0,
    0x0, 0x6, 0xf2, 0x1, 0x0, 0x0, 0x8f, 0x0,
    0x0, 0x6f, 0xbf, 0xff, 0x90, 0x8, 0xf0, 0x0,
    0x6, 0xfc, 0x64, 0x9f, 0xa0, 0x8f, 0x0, 0x0,
    0x6f, 0x20, 0x0, 0x9f, 0x18, 0xf0, 0x0, 0x6,
    0xf2, 0x0, 0x4, 0xf4, 0x8f, 0x0, 0x0, 0x6f,
    0x20, 0x0, 0x5f, 0x30, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xc, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x5,
    0x8c, 0xf6, 0x0, 0x0, 0x0, 0x0, 0x0, 0xdf,
    0xc5, 0x0,

    /* U+04A8 "Ҩ" */
    0x0, 0xb, 0x70, 0x2, 0xae, 0xfb, 0x30, 0x0,
    0xb, 0xf4, 0x3, 0xfe, 0x99, 0xef, 0x30, 0x5,
    0xf7, 0x0, 0xce, 0x20, 0x1, 0xed, 0x0, 0xbf,
    0x0, 0x2f, 0x80, 0x0, 0x8, 0xf2, 0xf, 0xa0,
    0x5, 0xf4, 0x0, 0x0, 0x5f, 0x41, 0xf8, 0x0,
    0x5f, 0x40, 0x0, 0x5, 0xf4, 0xf, 0x90, 0x4,
    0xf5, 0x0, 0x0, 0x6f, 0x20, 0xdd, 0x0, 0xf,
    0xa0, 0x0, 0xb, 0xd0, 0x7, 0xf4, 0x0, 0x9f,
    0x20, 0x3, 0xf5, 0x0, 0xd, 0xe3, 0x0, 0xdd,
    0x13, 0xe8, 0x0, 0x0, 0x2d, 0xfa, 0x56, 0xff,
    0xfc, 0x46, 0x30, 0x0, 0x7, 0xcf, 0xfd, 0xab,
    0xef, 0xe5,

    /* U+04A9 "ҩ" */
    0x0, 0x9a, 0x0, 0x8e, 0xfc, 0x40, 0x7, 0xf5,
    0xa, 0xf9, 0x6d, 0xf3, 0xe, 0xb0, 0x1f, 0x80,
    0x1, 0xfa, 0x2f, 0x60, 0x4f, 0x30, 0x0, 0xcc,
    0x3f, 0x50, 0x4f, 0x30, 0x0, 0xcb, 0x1f, 0x80,
    0x1f, 0x70, 0x1, 0xf6, 0xa, 0xf2, 0x9, 0xe1,
    0x9, 0xd0, 0x1, 0xdf, 0x85, 0xee, 0xbf, 0x65,
    0x0, 0x8, 0xdf, 0xfc, 0xbe, 0xfb,

    /* U+04AA "Ҫ" */
    0x0, 0x1, 0x8d, 0xfe, 0xb5, 0x0, 0x0, 0x4f,
    0xfb, 0x89, 0xdf, 0xa0, 0x2, 0xfd, 0x20, 0x0,
    0x7, 0x50, 0xa, 0xf3, 0x0, 0x0, 0x0, 0x0,
    0xf, 0xa0, 0x0, 0x0, 0x0, 0x0, 0x2f, 0x70,
    0x0, 0x0, 0x0, 0x0, 0x2f, 0x70, 0x0, 0x0,
    0x0, 0x0, 0xf, 0xa0, 0x0, 0x0, 0x0, 0x0,
    0xa, 0xf3, 0x0, 0x0, 0x0, 0x0, 0x2, 0xfd,
    0x20, 0x0, 0x7, 0x50, 0x0, 0x4f, 0xfb, 0x89,
    0xdf, 0x90, 0x0, 0x1, 0x9f, 0xff, 0xb5, 0x0,
    0x0, 0x0, 0x4, 0xf3, 0x0, 0x0, 0x0, 0x0,
    0x4, 0xf3, 0x0, 0x0, 0x0, 0x0, 0x2, 0x81,
    0x0, 0x0,

    /* U+04AB "ҫ" */
    0x0, 0x2a, 0xef, 0xc4, 0x0, 0x3f, 0xe8, 0x7c,
    0xf5, 0xd, 0xd1, 0x0, 0x7, 0x13, 0xf6, 0x0,
    0x0, 0x0, 0x4f, 0x40, 0x0, 0x0, 0x3, 0xf6,
    0x0, 0x0, 0x0, 0xd, 0xd1, 0x0, 0x6, 0x10,
    0x3f, 0xe8, 0x7c, 0xf5, 0x0, 0x2a, 0xff, 0xc4,
    0x0, 0x0, 0xb, 0xc0, 0x0, 0x0, 0x0, 0xbc,
    0x0, 0x0,

    /* U+04AC "Ҭ" */
    0xdf, 0xff, 0xff, 0xff, 0xf6, 0x57, 0x77, 0xfc,
    0x77, 0x73, 0x0, 0x0, 0xf9, 0x0, 0x0, 0x0,
    0x0, 0xf9, 0x0, 0x0, 0x0, 0x0, 0xf9, 0x0,
    0x0, 0x0, 0x0, 0xf9, 0x0, 0x0, 0x0, 0x0,
    0xf9, 0x0, 0x0, 0x0, 0x0, 0xf9, 0x0, 0x0,
    0x0, 0x0, 0xf9, 0x0, 0x0, 0x0, 0x0, 0xf9,
    0x0, 0x0, 0x0, 0x0, 0xff, 0x72, 0x0, 0x0,
    0x0, 0xff, 0xf4, 0x0, 0x0, 0x0, 0x2, 0xf4,
    0x0, 0x0, 0x0, 0x2, 0xf4, 0x0, 0x0, 0x0,
    0x1, 0x82, 0x0,

    /* U+04AD "ҭ" */
    0xff, 0xff, 0xff, 0xfd, 0x66, 0x6e, 0xd6, 0x65,
    0x0, 0xd, 0xb0, 0x0, 0x0, 0xd, 0xb0, 0x0,
    0x0, 0xd, 0xb0, 0x0, 0x0, 0xd, 0xb0, 0x0,
    0x0, 0xd, 0xb0, 0x0, 0x0, 0xd, 0xc5, 0x0,
    0x0, 0xd, 0xff, 0x0, 0x0, 0x0, 0x6f, 0x0,
    0x0, 0x0, 0x6f, 0x0,

    /* U+04AE "Ү" */
    0x9f, 0x20, 0x0, 0x0, 0x4f, 0x41, 0xfa, 0x0,
    0x0, 0xd, 0xb0, 0x7, 0xf3, 0x0, 0x7, 0xf2,
    0x0, 0xd, 0xc0, 0x1, 0xe9, 0x0, 0x0, 0x5f,
    0x50, 0x9e, 0x10, 0x0, 0x0, 0xce, 0x3f, 0x70,
    0x0, 0x0, 0x3, 0xff, 0xd0, 0x0, 0x0, 0x0,
    0xa, 0xf4, 0x0, 0x0, 0x0, 0x0, 0x7f, 0x20,
    0x0, 0x0, 0x0, 0x7, 0xf2, 0x0, 0x0, 0x0,
    0x0, 0x7f, 0x20, 0x0, 0x0, 0x0, 0x7, 0xf2,
    0x0, 0x0,

    /* U+04AF "ү" */
    0xbe, 0x0, 0x0, 0x9, 0xd0, 0x4f, 0x50, 0x0,
    0x1f, 0x70, 0xd, 0xc0, 0x0, 0x7f, 0x10, 0x7,
    0xf2, 0x0, 0xd9, 0x0, 0x0, 0xf9, 0x4, 0xf3,
    0x0, 0x0, 0x9f, 0xb, 0xc0, 0x0, 0x0, 0x2f,
    0x8f, 0x50, 0x0, 0x0, 0xc, 0xfe, 0x0, 0x0,
    0x0, 0x5, 0xf8, 0x0, 0x0, 0x0, 0x3, 0xf5,
    0x0, 0x0, 0x0, 0x3, 0xf5, 0x0, 0x0, 0x0,
    0x3, 0xf5, 0x0, 0x0,

    /* U+04B0 "Ұ" */
    0x9f, 0x20, 0x0, 0x0, 0x4f, 0x41, 0xfa, 0x0,
    0x0, 0xd, 0xb0, 0x7, 0xf4, 0x0, 0x7, 0xf2,
    0x0, 0xd, 0xd0, 0x1, 0xf8, 0x0, 0x0, 0x4f,
    0x60, 0xae, 0x10, 0x0, 0x0, 0xbe, 0x4f, 0x60,
    0x0, 0x0, 0x2, 0xff, 0xd0, 0x0, 0x0, 0x1f,
    0xff, 0xff, 0xfb, 0x0, 0x0, 0x22, 0x8f, 0x42,
    0x10, 0x0, 0x0, 0x7, 0xf2, 0x0, 0x0, 0x0,
    0x0, 0x7f, 0x20, 0x0, 0x0, 0x0, 0x7, 0xf2,
    0x0, 0x0,

    /* U+04B1 "ұ" */
    0xbe, 0x0, 0x0, 0x9, 0xd0, 0x4f, 0x50, 0x0,
    0x1f, 0x70, 0xd, 0xc0, 0x0, 0x7f, 0x10, 0x6,
    0xf2, 0x0, 0xe9, 0x0, 0x0, 0xf9, 0x5, 0xf2,
    0x0, 0x0, 0x9f, 0x1c, 0xb0, 0x0, 0x0, 0x2f,
    0xaf, 0x40, 0x0, 0x0, 0xb, 0xfd, 0x0, 0x0,
    0xd, 0xff, 0xff, 0xff, 0x0, 0x2, 0x25, 0xf7,
    0x22, 0x0, 0x0, 0x3, 0xf5, 0x0, 0x0, 0x0,
    0x3, 0xf5, 0x0, 0x0,

    /* U+04B2 "Ҳ" */
    0x2f, 0xb0, 0x0, 0x2, 0xfc, 0x0, 0x7, 0xf5,
    0x0, 0xc, 0xf2, 0x0, 0x0, 0xde, 0x10, 0x7f,
    0x70, 0x0, 0x0, 0x3f, 0xb2, 0xfc, 0x0, 0x0,
    0x0, 0x8, 0xfe, 0xf2, 0x0, 0x0, 0x0, 0x0,
    0xdf, 0x80, 0x0, 0x0, 0x0, 0x2, 0xff, 0xc0,
    0x0, 0x0, 0x0, 0xc, 0xfa, 0xf7, 0x0, 0x0,
    0x0, 0x6f, 0x70, 0xdf, 0x20, 0x0, 0x2, 0xfc,
    0x0, 0x3f, 0xc0, 0x0, 0xb, 0xf2, 0x0, 0x7,
    0xfe, 0x70, 0x6f, 0x60, 0x0, 0x0, 0xff, 0xf1,
    0x0, 0x0, 0x0, 0x0, 0x6, 0xf1, 0x0, 0x0,
    0x0, 0x0, 0x6, 0xf1, 0x0, 0x0, 0x0, 0x0,
    0x3, 0x80,

    /* U+04B3 "ҳ" */
    0x5f, 0x50, 0x0, 0xbe, 0x10, 0xa, 0xf2, 0x6,
    0xf4, 0x0, 0x0, 0xdc, 0x3f, 0x80, 0x0, 0x0,
    0x3f, 0xfc, 0x0, 0x0, 0x0, 0xb, 0xf5, 0x0,
    0x0, 0x0, 0x5f, 0xde, 0x10, 0x0, 0x1, 0xea,
    0x1e, 0xa0, 0x0, 0xc, 0xd0, 0x5, 0xfc, 0x61,
    0x8f, 0x30, 0x0, 0xdf, 0xf3, 0x0, 0x0, 0x0,
    0x2, 0xf3, 0x0, 0x0, 0x0, 0x2, 0xf3,

    /* U+04B4 "Ҵ" */
    0xcf, 0xff, 0xff, 0xff, 0xf0, 0x1, 0xf7, 0x0,
    0x57, 0x77, 0xfc, 0x77, 0x70, 0x1, 0xf7, 0x0,
    0x0, 0x0, 0xfa, 0x0, 0x0, 0x1, 0xf7, 0x0,
    0x0, 0x0, 0xfa, 0x0, 0x0, 0x1, 0xf7, 0x0,
    0x0, 0x0, 0xfa, 0x0, 0x0, 0x1, 0xf7, 0x0,
    0x0, 0x0, 0xfa, 0x0, 0x0, 0x1, 0xf7, 0x0,
    0x0, 0x0, 0xfa, 0x0, 0x0, 0x1, 0xf7, 0x0,
    0x0, 0x0, 0xfa, 0x0, 0x0, 0x1, 0xf7, 0x0,
    0x0, 0x0, 0xfa, 0x0, 0x0, 0x1, 0xf7, 0x0,
    0x0, 0x0, 0xfa, 0x0, 0x0, 0x1, 0xf7, 0x0,
    0x0, 0x0, 0xfc, 0x77, 0x77, 0x78, 0xfb, 0x71,
    0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf3,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0xf3,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0xf3,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x81,

    /* U+04B5 "ҵ" */
    0xef, 0xff, 0xff, 0xf3, 0xf, 0x80, 0x56, 0x6e,
    0xd6, 0x61, 0xf, 0x80, 0x0, 0xd, 0xb0, 0x0,
    0xf, 0x80, 0x0, 0xd, 0xb0, 0x0, 0xf, 0x80,
    0x0, 0xd, 0xb0, 0x0, 0xf, 0x80, 0x0, 0xd,
    0xb0, 0x0, 0xf, 0x80, 0x0, 0xd, 0xb0, 0x0,
    0xf, 0x80, 0x0, 0xd, 0xd6, 0x66, 0x6f, 0xb4,
    0x0, 0xd, 0xff, 0xff, 0xff, 0xfc, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xbc, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x9b,

    /* U+04B6 "Ҷ" */
    0x2f, 0x70, 0x0, 0x0, 0x9f, 0x0, 0x2f, 0x70,
    0x0, 0x0, 0x9f, 0x0, 0x2f, 0x70, 0x0, 0x0,
    0x9f, 0x0, 0x2f, 0x70, 0x0, 0x0, 0x9f, 0x0,
    0x2f, 0x80, 0x0, 0x0, 0x9f, 0x0, 0xf, 0xd0,
    0x0, 0x0, 0x9f, 0x0, 0x8, 0xfb, 0x42, 0x49,
    0xef, 0x0, 0x0, 0x9f, 0xff, 0xfe, 0xdf, 0x0,
    0x0, 0x1, 0x44, 0x20, 0x9f, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x9f, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xdf, 0x75, 0x0, 0x0, 0x0, 0x0, 0xff, 0xfb,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xcb, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xcb, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x65,

    /* U+04B7 "ҷ" */
    0x5f, 0x30, 0x0, 0x4f, 0x30, 0x5f, 0x30, 0x0,
    0x4f, 0x30, 0x5f, 0x30, 0x0, 0x4f, 0x30, 0x4f,
    0x40, 0x0, 0x4f, 0x30, 0x1f, 0xc3, 0x14, 0xaf,
    0x30, 0x5, 0xef, 0xff, 0xcf, 0x30, 0x0, 0x2,
    0x20, 0x4f, 0x30, 0x0, 0x0, 0x0, 0x6f, 0xa3,
    0x0, 0x0, 0x0, 0x9f, 0xf9, 0x0, 0x0, 0x0,
    0x0, 0xe9, 0x0, 0x0, 0x0, 0x0, 0xe9,

    /* U+04B8 "Ҹ" */
    0x2f, 0x70, 0x0, 0x0, 0x8f, 0x2, 0xf7, 0x0,
    0x0, 0x8, 0xf0, 0x2f, 0x70, 0x0, 0x0, 0x8f,
    0x2, 0xf7, 0x0, 0x0, 0x8, 0xf0, 0x1f, 0x90,
    0x4e, 0x0, 0x8f, 0x0, 0xdf, 0x24, 0xe0, 0xa,
    0xf0, 0x4, 0xff, 0xcf, 0xbf, 0xff, 0x0, 0x2,
    0x9d, 0xfb, 0x7a, 0xf0, 0x0, 0x0, 0x4e, 0x0,
    0x8f, 0x0, 0x0, 0x4, 0xe0, 0x8, 0xf0, 0x0,
    0x0, 0x3, 0x0, 0x8f, 0x0, 0x0, 0x0, 0x0,
    0x8, 0xf0,

    /* U+04B9 "ҹ" */
    0x5f, 0x30, 0x0, 0x4f, 0x35, 0xf3, 0x0, 0x4,
    0xf3, 0x5f, 0x30, 0x0, 0x4f, 0x33, 0xf5, 0x2f,
    0x4, 0xf3, 0xe, 0xe8, 0xf6, 0xcf, 0x30, 0x4d,
    0xff, 0xeb, 0xf3, 0x0, 0x2, 0xf0, 0x4f, 0x30,
    0x0, 0x1b, 0x4, 0xf3, 0x0, 0x0, 0x0, 0x4f,
    0x30,

    /* U+04BA "Һ" */
    0x4f, 0x50, 0x0, 0x0, 0x0, 0x4f, 0x50, 0x0,
    0x0, 0x0, 0x4f, 0x50, 0x0, 0x0, 0x0, 0x4f,
    0x50, 0x1, 0x0, 0x0, 0x4f, 0xac, 0xff, 0xfc,
    0x40, 0x4f, 0xfa, 0x75, 0x8e, 0xf3, 0x4f, 0x50,
    0x0, 0x2, 0xfa, 0x4f, 0x50, 0x0, 0x0, 0xcd,
    0x4f, 0x50, 0x0, 0x0, 0xae, 0x4f, 0x50, 0x0,
    0x0, 0xae, 0x4f, 0x50, 0x0, 0x0, 0xae, 0x4f,
    0x50, 0x0, 0x0, 0xae,

    /* U+04BB "һ" */
    0x47, 0x0, 0x0, 0x0, 0x8, 0xf0, 0x0, 0x0,
    0x0, 0x8f, 0x0, 0x0, 0x0, 0x8, 0xf0, 0x0,
    0x0, 0x0, 0x8f, 0x2b, 0xff, 0xb2, 0x8, 0xfe,
    0xb7, 0x9f, 0xd0, 0x8f, 0x80, 0x0, 0x6f, 0x58,
    0xf2, 0x0, 0x1, 0xf7, 0x8f, 0x0, 0x0, 0xf,
    0x88, 0xf0, 0x0, 0x0, 0xf8, 0x8f, 0x0, 0x0,
    0xf, 0x88, 0xf0, 0x0, 0x0, 0xf8, 0x8f, 0x0,
    0x0, 0xf, 0x80,

    /* U+04BC "Ҽ" */
    0x0, 0x0, 0x0, 0x3a, 0xef, 0xea, 0x20, 0x0,
    0x0, 0x0, 0x8, 0xfe, 0x98, 0x9e, 0xf6, 0x0,
    0x2b, 0x30, 0x6f, 0xa1, 0x0, 0x0, 0xbf, 0x40,
    0x7f, 0x10, 0xec, 0x0, 0x0, 0x0, 0x1e, 0xc0,
    0x6f, 0x85, 0xf7, 0x11, 0x11, 0x11, 0x1a, 0xf1,
    0xc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf2,
    0x0, 0x36, 0xf9, 0x44, 0x44, 0x44, 0x44, 0x40,
    0x0, 0x0, 0xfa, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xbf, 0x20, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x2f, 0xd2, 0x0, 0x1, 0xb7, 0x0,
    0x0, 0x0, 0x5, 0xff, 0xa8, 0xaf, 0xf9, 0x0,
    0x0, 0x0, 0x0, 0x29, 0xef, 0xea, 0x30, 0x0,

    /* U+04BD "ҽ" */
    0x0, 0x0, 0x19, 0xef, 0xd6, 0x0, 0x11, 0x1,
    0xde, 0x86, 0xaf, 0x90, 0x8c, 0x9, 0xf2, 0x0,
    0x7, 0xf3, 0xad, 0xe, 0xa0, 0x0, 0x0, 0xf8,
    0x3e, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x0, 0x2f,
    0xb2, 0x22, 0x22, 0x21, 0x0, 0xa, 0xf3, 0x0,
    0x0, 0x20, 0x0, 0x1, 0xdf, 0x97, 0x8d, 0xd0,
    0x0, 0x0, 0x18, 0xdf, 0xea, 0x20,

    /* U+04BE "Ҿ" */
    0x0, 0x0, 0x0, 0x4a, 0xef, 0xea, 0x20, 0x0,
    0x0, 0x0, 0x9, 0xfe, 0x98, 0xae, 0xf6, 0x0,
    0x3b, 0x20, 0x7f, 0xa0, 0x0, 0x1, 0xbf, 0x40,
    0x7f, 0x0, 0xfc, 0x0, 0x0, 0x0, 0x1e, 0xc0,
    0x6f, 0x75, 0xf7, 0x11, 0x11, 0x11, 0x1a, 0xf0,
    0xc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf2,
    0x0, 0x37, 0xf9, 0x44, 0x44, 0x44, 0x44, 0x40,
    0x0, 0x0, 0xf9, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xbf, 0x20, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x3f, 0xd2, 0x0, 0x1, 0xb7, 0x0,
    0x0, 0x0, 0x5, 0xff, 0xa8, 0xaf, 0xf9, 0x0,
    0x0, 0x0, 0x0, 0x29, 0xff, 0xfa, 0x30, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x3f, 0x40, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x3f, 0x40, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x18, 0x20, 0x0, 0x0,

    /* U+04BF "ҿ" */
    0x0, 0x0, 0x19, 0xef, 0xd6, 0x0, 0x11, 0x1,
    0xde, 0x86, 0xaf, 0x90, 0x8c, 0x9, 0xf2, 0x0,
    0x7, 0xf3, 0xac, 0xe, 0xa0, 0x0, 0x0, 0xf8,
    0x3e, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x0, 0x2f,
    0xb2, 0x22, 0x22, 0x21, 0x0, 0xa, 0xf3, 0x0,
    0x0, 0x20, 0x0, 0x1, 0xef, 0x97, 0x8d, 0xd0,
    0x0, 0x0, 0x19, 0xff, 0xfa, 0x20, 0x0, 0x0,
    0x0, 0x5f, 0x20, 0x0, 0x0, 0x0, 0x0, 0x5f,
    0x20, 0x0,

    /* U+04C0 "Ӏ" */
    0x4f, 0x54, 0xf5, 0x4f, 0x54, 0xf5, 0x4f, 0x54,
    0xf5, 0x4f, 0x54, 0xf5, 0x4f, 0x54, 0xf5, 0x4f,
    0x54, 0xf5,

    /* U+04C1 "Ӂ" */
    0x0, 0x0, 0x6, 0xd1, 0x6, 0xd0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x8, 0xde, 0xb3, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x2, 0xf9, 0x0, 0x0, 0x9f, 0x0, 0x0,
    0x2f, 0x80, 0x8, 0xf3, 0x0, 0x9, 0xf0, 0x0,
    0xc, 0xe0, 0x0, 0xe, 0xc0, 0x0, 0x9f, 0x0,
    0x6, 0xf4, 0x0, 0x0, 0x5f, 0x60, 0x9, 0xf0,
    0x1, 0xea, 0x0, 0x0, 0x0, 0xcf, 0x32, 0x9f,
    0x22, 0xae, 0x10, 0x0, 0x0, 0x3, 0xff, 0xff,
    0xff, 0xff, 0x90, 0x0, 0x0, 0x0, 0x7f, 0x65,
    0xbf, 0x55, 0xcf, 0x10, 0x0, 0x0, 0x1f, 0xa0,
    0x9, 0xf0, 0x3, 0xf9, 0x0, 0x0, 0xa, 0xf1,
    0x0, 0x9f, 0x0, 0xa, 0xf3, 0x0, 0x3, 0xf8,
    0x0, 0x9, 0xf0, 0x0, 0x2f, 0xb0, 0x0, 0xde,
    0x0, 0x0, 0x9f, 0x0, 0x0, 0x9f, 0x40, 0x6f,
    0x60, 0x0, 0x9, 0xf0, 0x0, 0x1, 0xed, 0x0,

    /* U+04C2 "ӂ" */
    0x0, 0x0, 0x52, 0x0, 0x62, 0x0, 0x0, 0x0,
    0x0, 0x8a, 0x3, 0xf1, 0x0, 0x0, 0x0, 0x0,
    0xa, 0xed, 0x50, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x4f, 0x50, 0x0, 0xf8,
    0x0, 0xc, 0xd0, 0xa, 0xe0, 0x0, 0xf8, 0x0,
    0x6f, 0x30, 0x1, 0xf8, 0x0, 0xf8, 0x0, 0xea,
    0x0, 0x0, 0x6f, 0x31, 0xf9, 0x19, 0xf1, 0x0,
    0x0, 0x1f, 0xff, 0xff, 0xff, 0x90, 0x0, 0x0,
    0x9f, 0x64, 0xfa, 0x4b, 0xf2, 0x0, 0x3, 0xf9,
    0x0, 0xf8, 0x1, 0xfc, 0x0, 0xd, 0xe0, 0x0,
    0xf8, 0x0, 0x6f, 0x60, 0x8f, 0x50, 0x0, 0xf8,
    0x0, 0xc, 0xf1,

    /* U+04C3 "Ӄ" */
    0x4f, 0x50, 0x0, 0x3, 0xf8, 0x4, 0xf5, 0x0,
    0x0, 0xdc, 0x0, 0x4f, 0x50, 0x0, 0x9f, 0x20,
    0x4, 0xf5, 0x0, 0x5f, 0x50, 0x0, 0x4f, 0x62,
    0x3e, 0x90, 0x0, 0x4, 0xff, 0xff, 0xf1, 0x0,
    0x0, 0x4f, 0x85, 0x6f, 0xc0, 0x0, 0x4, 0xf5,
    0x0, 0x4f, 0xb0, 0x0, 0x4f, 0x50, 0x0, 0x7f,
    0x70, 0x4, 0xf5, 0x0, 0x0, 0xbf, 0x20, 0x4f,
    0x50, 0x0, 0x2, 0xfa, 0x4, 0xf5, 0x0, 0x0,
    0xc, 0xf0, 0x0, 0x0, 0x0, 0x0, 0xbf, 0x0,
    0x0, 0x0, 0x28, 0x8f, 0xc0, 0x0, 0x0, 0x3,
    0xdf, 0xb2, 0x0,

    /* U+04C4 "ӄ" */
    0x8f, 0x0, 0x0, 0xcd, 0x8, 0xf0, 0x0, 0x7f,
    0x20, 0x8f, 0x0, 0x3f, 0x60, 0x8, 0xf1, 0x1d,
    0xb0, 0x0, 0x8f, 0xff, 0xf5, 0x0, 0x8, 0xf4,
    0x4b, 0xf4, 0x0, 0x8f, 0x0, 0xb, 0xe1, 0x8,
    0xf0, 0x0, 0x1f, 0x90, 0x8f, 0x0, 0x0, 0x9f,
    0x0, 0x0, 0x0, 0x7, 0xf2, 0x0, 0x0, 0x76,
    0xee, 0x0, 0x0, 0x1c, 0xfd, 0x30,

    /* U+04C6 "ӆ" */
    0x0, 0xcf, 0xff, 0xff, 0xc0, 0x0, 0xd, 0xb6,
    0x66, 0xdc, 0x0, 0x0, 0xd8, 0x0, 0xc, 0xc0,
    0x0, 0xe, 0x70, 0x0, 0xcc, 0x0, 0x0, 0xf6,
    0x0, 0xc, 0xc0, 0x0, 0x1f, 0x40, 0x0, 0xcc,
    0x0, 0x5, 0xf1, 0x0, 0xc, 0xc0, 0x5, 0xdd,
    0x0, 0x0, 0xff, 0x50, 0xde, 0x30, 0x0, 0xf,
    0xfd, 0x0, 0x0, 0x0, 0x0, 0xb, 0x90, 0x0,
    0x0, 0x0, 0x0, 0xf4, 0x0,

    /* U+04C7 "Ӈ" */
    0x4f, 0x50, 0x0, 0x0, 0x4f, 0x44, 0xf5, 0x0,
    0x0, 0x4, 0xf4, 0x4f, 0x50, 0x0, 0x0, 0x4f,
    0x44, 0xf5, 0x0, 0x0, 0x4, 0xf4, 0x4f, 0x62,
    0x22, 0x22, 0x5f, 0x44, 0xff, 0xff, 0xff, 0xff,
    0xf4, 0x4f, 0x85, 0x55, 0x55, 0x8f, 0x44, 0xf5,
    0x0, 0x0, 0x4, 0xf4, 0x4f, 0x50, 0x0, 0x0,
    0x4f, 0x44, 0xf5, 0x0, 0x0, 0x4, 0xf4, 0x4f,
    0x50, 0x0, 0x0, 0x4f, 0x44, 0xf5, 0x0, 0x0,
    0x4, 0xf4, 0x0, 0x0, 0x0, 0x0, 0x5f, 0x40,
    0x0, 0x0, 0x8, 0x7d, 0xf1, 0x0, 0x0, 0x1,
    0xdf, 0xd4, 0x0,

    /* U+04C8 "ӈ" */
    0x8f, 0x0, 0x0, 0xf, 0x78, 0xf0, 0x0, 0x0,
    0xf7, 0x8f, 0x0, 0x0, 0xf, 0x78, 0xf1, 0x11,
    0x12, 0xf7, 0x8f, 0xff, 0xff, 0xff, 0x78, 0xf4,
    0x44, 0x45, 0xf7, 0x8f, 0x0, 0x0, 0xf, 0x78,
    0xf0, 0x0, 0x0, 0xf7, 0x8f, 0x0, 0x0, 0xf,
    0x70, 0x0, 0x0, 0x1, 0xf6, 0x0, 0x0, 0x66,
    0xbf, 0x30, 0x0, 0xa, 0xfe, 0x60,

    /* U+04C9 "Ӊ" */
    0x4f, 0x50, 0x0, 0x0, 0x3f, 0x50, 0x4, 0xf5,
    0x0, 0x0, 0x3, 0xf5, 0x0, 0x4f, 0x50, 0x0,
    0x0, 0x3f, 0x50, 0x4, 0xf5, 0x0, 0x0, 0x3,
    0xf5, 0x0, 0x4f, 0x62, 0x22, 0x22, 0x5f, 0x50,
    0x4, 0xff, 0xff, 0xff, 0xff, 0xf5, 0x0, 0x4f,
    0x85, 0x55, 0x55, 0x7f, 0x50, 0x4, 0xf5, 0x0,
    0x0, 0x3, 0xf5, 0x0, 0x4f, 0x50, 0x0, 0x0,
    0x3f, 0x50, 0x4, 0xf5, 0x0, 0x0, 0x3, 0xf5,
    0x0, 0x4f, 0x50, 0x0, 0x0, 0x5f, 0xd7, 0x4,
    0xf5, 0x0, 0x0, 0x6, 0xff, 0xb0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xe7, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x2f, 0x20, 0x0, 0x0, 0x0, 0x0, 0x2,
    0x70, 0x0,

    /* U+04CA "ӊ" */
    0x8f, 0x0, 0x0, 0x2f, 0x60, 0x8f, 0x0, 0x0,
    0x2f, 0x60, 0x8f, 0x0, 0x0, 0x2f, 0x60, 0x8f,
    0x11, 0x11, 0x3f, 0x60, 0x8f, 0xff, 0xff, 0xff,
    0x60, 0x8f, 0x44, 0x44, 0x6f, 0x60, 0x8f, 0x0,
    0x0, 0x2f, 0x60, 0x8f, 0x0, 0x0, 0x3f, 0xc4,
    0x8f, 0x0, 0x0, 0x4f, 0xf7, 0x0, 0x0, 0x0,
    0x1, 0xf3, 0x0, 0x0, 0x0, 0x5, 0xe0,

    /* U+04CB "Ӌ" */
    0x3f, 0x60, 0x0, 0x0, 0x9f, 0x3f, 0x60, 0x0,
    0x0, 0x9f, 0x3f, 0x60, 0x0, 0x0, 0x9f, 0x2f,
    0x70, 0x0, 0x0, 0x9f, 0x1f, 0xb0, 0x0, 0x0,
    0x9f, 0xb, 0xf9, 0x32, 0x48, 0xef, 0x1, 0xaf,
    0xff, 0xfe, 0xdf, 0x0, 0x1, 0x34, 0x20, 0x9f,
    0x0, 0x0, 0x0, 0x0, 0x9f, 0x0, 0x0, 0x0,
    0x0, 0x9f, 0x0, 0x0, 0x0, 0x47, 0xcf, 0x0,
    0x0, 0x0, 0x8f, 0xff, 0x0, 0x0, 0x0, 0x8f,
    0x0, 0x0, 0x0, 0x0, 0x8f, 0x0, 0x0, 0x0,
    0x0, 0x47, 0x0,

    /* U+04CC "ӌ" */
    0x6f, 0x20, 0x0, 0x5f, 0x36, 0xf2, 0x0, 0x5,
    0xf3, 0x5f, 0x20, 0x0, 0x5f, 0x34, 0xf4, 0x0,
    0x5, 0xf3, 0x1f, 0xc3, 0x14, 0xbf, 0x30, 0x5e,
    0xff, 0xfd, 0xf3, 0x0, 0x2, 0x20, 0x5f, 0x30,
    0x0, 0x0, 0x37, 0xf3, 0x0, 0x0, 0xc, 0xff,
    0x30, 0x0, 0x0, 0xca, 0x0, 0x0, 0x0, 0xc,
    0xa0, 0x0,

    /* U+04CD "Ӎ" */
    0x4f, 0x50, 0x0, 0x0, 0x0, 0xe, 0x90, 0x4,
    0xfd, 0x0, 0x0, 0x0, 0x8, 0xfa, 0x0, 0x4f,
    0xf6, 0x0, 0x0, 0x1, 0xff, 0xa0, 0x4, 0xfd,
    0xe0, 0x0, 0x0, 0x9e, 0xfa, 0x0, 0x4f, 0x6f,
    0x80, 0x0, 0x2f, 0x6e, 0xa0, 0x4, 0xf4, 0x8f,
    0x10, 0xa, 0xd0, 0xea, 0x0, 0x4f, 0x40, 0xea,
    0x3, 0xf4, 0xe, 0xa0, 0x4, 0xf4, 0x6, 0xf3,
    0xcb, 0x0, 0xea, 0x0, 0x4f, 0x40, 0xd, 0xef,
    0x30, 0xe, 0xa0, 0x4, 0xf4, 0x0, 0x4f, 0xa0,
    0x0, 0xea, 0x0, 0x4f, 0x40, 0x0, 0x71, 0x0,
    0xf, 0xf7, 0x24, 0xf4, 0x0, 0x0, 0x0, 0x0,
    0xff, 0xf2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x8d, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xc,
    0x80, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x72,
    0x0,

    /* U+04CE "ӎ" */
    0x8f, 0x50, 0x0, 0x0, 0x7f, 0x40, 0x8f, 0xd0,
    0x0, 0x1, 0xff, 0x40, 0x8f, 0xf6, 0x0, 0x9,
    0xef, 0x40, 0x8e, 0x8e, 0x0, 0x2f, 0x6f, 0x40,
    0x8e, 0xe, 0x80, 0xba, 0x2f, 0x40, 0x8e, 0x6,
    0xf6, 0xf2, 0x2f, 0x40, 0x8e, 0x0, 0xdf, 0x80,
    0x2f, 0x40, 0x8e, 0x0, 0x4e, 0x0, 0x3f, 0xa4,
    0x8e, 0x0, 0x0, 0x0, 0x4f, 0xf7, 0x0, 0x0,
    0x0, 0x0, 0x1, 0xf3, 0x0, 0x0, 0x0, 0x0,
    0x5, 0xe0,

    /* U+04CF "ӏ" */
    0x37, 0x8, 0xf0, 0x8f, 0x8, 0xf0, 0x8f, 0x8,
    0xf0, 0x8f, 0x8, 0xf0, 0x8f, 0x8, 0xf0, 0x8f,
    0x8, 0xf0, 0x8f, 0x0,

    /* U+04D0 "Ӑ" */
    0x0, 0x9, 0xb0, 0x9, 0xa0, 0x0, 0x0, 0x1,
    0xae, 0xeb, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xe, 0xf1, 0x0, 0x0,
    0x0, 0x0, 0x6f, 0xf7, 0x0, 0x0, 0x0, 0x0,
    0xcc, 0xbe, 0x0, 0x0, 0x0, 0x3, 0xf5, 0x4f,
    0x40, 0x0, 0x0, 0xa, 0xe0, 0xe, 0xb0, 0x0,
    0x0, 0x1f, 0x90, 0x8, 0xf2, 0x0, 0x0, 0x8f,
    0x20, 0x1, 0xf9, 0x0, 0x0, 0xec, 0x11, 0x11,
    0xcf, 0x0, 0x5, 0xff, 0xff, 0xff, 0xff, 0x60,
    0xc, 0xe4, 0x44, 0x44, 0x4d, 0xd0, 0x3f, 0x80,
    0x0, 0x0, 0x7, 0xf4, 0x9f, 0x10, 0x0, 0x0,
    0x0, 0xfb,

    /* U+04D1 "ӑ" */
    0x0, 0x61, 0x0, 0x70, 0x0, 0x0, 0xb8, 0x5,
    0xe0, 0x0, 0x0, 0x2b, 0xed, 0x40, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3b, 0xef, 0xb1,
    0xf8, 0x3, 0xfe, 0x87, 0xce, 0xf8, 0xd, 0xe1,
    0x0, 0xa, 0xf8, 0x2f, 0x70, 0x0, 0x2, 0xf8,
    0x3f, 0x50, 0x0, 0x0, 0xf8, 0x2f, 0x70, 0x0,
    0x2, 0xf8, 0xd, 0xe1, 0x0, 0xa, 0xf8, 0x3,
    0xfe, 0x87, 0xce, 0xf8, 0x0, 0x3b, 0xef, 0xb2,
    0xf8,

    /* U+04D2 "Ӓ" */
    0x0, 0x0, 0x91, 0x1a, 0x10, 0x0, 0x0, 0x1,
    0xe3, 0x2e, 0x30, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xe, 0xf1, 0x0, 0x0,
    0x0, 0x0, 0x6f, 0xf7, 0x0, 0x0, 0x0, 0x0,
    0xcc, 0xbe, 0x0, 0x0, 0x0, 0x3, 0xf5, 0x4f,
    0x40, 0x0, 0x0, 0xa, 0xe0, 0xe, 0xb0, 0x0,
    0x0, 0x1f, 0x90, 0x8, 0xf2, 0x0, 0x0, 0x8f,
    0x20, 0x1, 0xf9, 0x0, 0x0, 0xec, 0x11, 0x11,
    0xcf, 0x0, 0x5, 0xff, 0xff, 0xff, 0xff, 0x60,
    0xc, 0xe4, 0x44, 0x44, 0x4d, 0xd0, 0x3f, 0x80,
    0x0, 0x0, 0x7, 0xf4, 0x9f, 0x10, 0x0, 0x0,
    0x0, 0xfb,

    /* U+04D3 "ӓ" */
    0x0, 0x7b, 0x8, 0xb0, 0x0, 0x0, 0x57, 0x5,
    0x70, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x3b, 0xef, 0xb1, 0xf8, 0x3, 0xfe, 0x87, 0xce,
    0xf8, 0xd, 0xe1, 0x0, 0xa, 0xf8, 0x2f, 0x70,
    0x0, 0x2, 0xf8, 0x3f, 0x50, 0x0, 0x0, 0xf8,
    0x2f, 0x70, 0x0, 0x2, 0xf8, 0xd, 0xe1, 0x0,
    0xa, 0xf8, 0x3, 0xfe, 0x87, 0xce, 0xf8, 0x0,
    0x3b, 0xef, 0xb2, 0xf8,

    /* U+04D4 "Ӕ" */
    0x0, 0x0, 0x0, 0x8f, 0xff, 0xff, 0xff, 0xfc,
    0x0, 0x0, 0x1, 0xfb, 0xfa, 0x77, 0x77, 0x75,
    0x0, 0x0, 0xa, 0xe3, 0xf6, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x3f, 0x72, 0xf6, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xbe, 0x2, 0xf7, 0x11, 0x11, 0x10,
    0x0, 0x4, 0xf6, 0x2, 0xff, 0xff, 0xff, 0xf0,
    0x0, 0xd, 0xd0, 0x2, 0xf9, 0x44, 0x44, 0x40,
    0x0, 0x6f, 0x61, 0x13, 0xf6, 0x0, 0x0, 0x0,
    0x0, 0xef, 0xff, 0xff, 0xf6, 0x0, 0x0, 0x0,
    0x8, 0xf6, 0x44, 0x46, 0xf6, 0x0, 0x0, 0x0,
    0x1f, 0xa0, 0x0, 0x2, 0xfb, 0x77, 0x77, 0x77,
    0xaf, 0x10, 0x0, 0x2, 0xff, 0xff, 0xff, 0xff,

    /* U+04D5 "ӕ" */
    0x3, 0xae, 0xfd, 0x80, 0x3b, 0xfe, 0xa2, 0x0,
    0xd, 0xd8, 0x7b, 0xfb, 0xfc, 0x78, 0xee, 0x20,
    0x2, 0x0, 0x0, 0xbf, 0xc0, 0x0, 0x1e, 0xa0,
    0x0, 0x0, 0x0, 0x7f, 0x40, 0x0, 0x8, 0xf0,
    0x3, 0xbe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf1,
    0x1f, 0xb4, 0x22, 0x8f, 0x62, 0x22, 0x22, 0x20,
    0x3f, 0x50, 0x0, 0xaf, 0xb0, 0x0, 0x2, 0x0,
    0xe, 0xe8, 0x7b, 0xf9, 0xfd, 0x87, 0xaf, 0x40,
    0x2, 0xbe, 0xfc, 0x40, 0x4b, 0xff, 0xc6, 0x0,

    /* U+04D6 "Ӗ" */
    0x0, 0xe5, 0x1, 0xd5, 0x0, 0x4, 0xce, 0xd8,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0xff, 0xff,
    0xff, 0xfa, 0x4f, 0xa7, 0x77, 0x77, 0x44, 0xf5,
    0x0, 0x0, 0x0, 0x4f, 0x50, 0x0, 0x0, 0x4,
    0xf6, 0x11, 0x11, 0x10, 0x4f, 0xff, 0xff, 0xff,
    0x4, 0xf8, 0x44, 0x44, 0x40, 0x4f, 0x50, 0x0,
    0x0, 0x4, 0xf5, 0x0, 0x0, 0x0, 0x4f, 0x50,
    0x0, 0x0, 0x4, 0xfa, 0x77, 0x77, 0x76, 0x4f,
    0xff, 0xff, 0xff, 0xd0,

    /* U+04D7 "ӗ" */
    0x0, 0x43, 0x0, 0x53, 0x0, 0x0, 0x5c, 0x12,
    0xe3, 0x0, 0x0, 0x9, 0xee, 0x70, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3b, 0xfe, 0xa2,
    0x0, 0x4, 0xfc, 0x67, 0xde, 0x20, 0xe, 0xc0,
    0x0, 0xd, 0xa0, 0x3f, 0x50, 0x0, 0x7, 0xf0,
    0x4f, 0xff, 0xff, 0xff, 0xf1, 0x3f, 0x72, 0x22,
    0x22, 0x20, 0xd, 0xc0, 0x0, 0x2, 0x0, 0x4,
    0xfe, 0x87, 0xaf, 0x50, 0x0, 0x2a, 0xef, 0xd7,
    0x0,

    /* U+04D8 "Ә" */
    0x0, 0x5, 0xbe, 0xfe, 0x92, 0x0, 0x0, 0xb,
    0xfd, 0x98, 0xaf, 0xf6, 0x0, 0x0, 0x76, 0x0,
    0x0, 0x1b, 0xf4, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xd, 0xd0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7f,
    0x25, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x4f,
    0x73, 0x33, 0x33, 0x33, 0x7f, 0x42, 0xf8, 0x0,
    0x0, 0x0, 0x9, 0xf2, 0xc, 0xf1, 0x0, 0x0,
    0x2, 0xfd, 0x0, 0x4f, 0xc1, 0x0, 0x1, 0xdf,
    0x40, 0x0, 0x6f, 0xe9, 0x8a, 0xff, 0x60, 0x0,
    0x0, 0x2a, 0xef, 0xe9, 0x20, 0x0,

    /* U+04D9 "ә" */
    0x0, 0x6c, 0xfe, 0xa3, 0x0, 0x5, 0xfa, 0x78,
    0xef, 0x40, 0x0, 0x30, 0x0, 0xd, 0xe0, 0x0,
    0x0, 0x0, 0x5, 0xf3, 0x1f, 0xff, 0xff, 0xff,
    0xf5, 0xf, 0x92, 0x22, 0x26, 0xf3, 0xb, 0xd0,
    0x0, 0xb, 0xe0, 0x2, 0xed, 0x76, 0xcf, 0x40,
    0x0, 0x2a, 0xef, 0xb3, 0x0,

    /* U+04DA "Ӛ" */
    0x0, 0x0, 0x8b, 0x8, 0xa0, 0x0, 0x0, 0x0,
    0x5, 0x70, 0x57, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x5b, 0xef, 0xe9,
    0x20, 0x0, 0x0, 0xcf, 0xd9, 0x8a, 0xff, 0x60,
    0x0, 0x7, 0x60, 0x0, 0x1, 0xbf, 0x40, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xdd, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x7, 0xf2, 0x5f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x44, 0xf7, 0x33, 0x33, 0x33, 0x38,
    0xf4, 0x2f, 0x80, 0x0, 0x0, 0x0, 0x9f, 0x10,
    0xdf, 0x10, 0x0, 0x0, 0x2f, 0xc0, 0x4, 0xfb,
    0x10, 0x0, 0x1d, 0xf4, 0x0, 0x6, 0xfe, 0x98,
    0xaf, 0xf6, 0x0, 0x0, 0x3, 0xae, 0xfe, 0x92,
    0x0, 0x0,

    /* U+04DB "ӛ" */
    0x0, 0x1e, 0x31, 0xe3, 0x0, 0x0, 0x9, 0x20,
    0x91, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x6d, 0xfe, 0xa3, 0x0, 0x5, 0xfa, 0x78, 0xef,
    0x40, 0x0, 0x30, 0x0, 0xd, 0xd0, 0x0, 0x0,
    0x0, 0x6, 0xf3, 0x1f, 0xff, 0xff, 0xff, 0xf4,
    0xf, 0x82, 0x22, 0x26, 0xf3, 0xb, 0xd0, 0x0,
    0xb, 0xe0, 0x2, 0xfd, 0x76, 0xcf, 0x40, 0x0,
    0x2a, 0xef, 0xb3, 0x0,

    /* U+04DC "Ӝ" */
    0x0, 0x0, 0x0, 0x93, 0x9, 0x30, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xd, 0x60, 0xd5, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x2, 0xf9, 0x0, 0x0, 0x9f, 0x0, 0x0,
    0x2f, 0x80, 0x8, 0xf3, 0x0, 0x9, 0xf0, 0x0,
    0xc, 0xe0, 0x0, 0xe, 0xc0, 0x0, 0x9f, 0x0,
    0x6, 0xf4, 0x0, 0x0, 0x5f, 0x60, 0x9, 0xf0,
    0x1, 0xea, 0x0, 0x0, 0x0, 0xcf, 0x32, 0x9f,
    0x22, 0xae, 0x10, 0x0, 0x0, 0x3, 0xff, 0xff,
    0xff, 0xff, 0x90, 0x0, 0x0, 0x0, 0x7f, 0x65,
    0xbf, 0x55, 0xcf, 0x10, 0x0, 0x0, 0x1f, 0xa0,
    0x9, 0xf0, 0x3, 0xf9, 0x0, 0x0, 0xa, 0xf1,
    0x0, 0x9f, 0x0, 0xa, 0xf3, 0x0, 0x3, 0xf8,
    0x0, 0x9, 0xf0, 0x0, 0x2f, 0xb0, 0x0, 0xde,
    0x0, 0x0, 0x9f, 0x0, 0x0, 0x9f, 0x40, 0x6f,
    0x60, 0x0, 0x9, 0xf0, 0x0, 0x1, 0xed, 0x0,

    /* U+04DD "ӝ" */
    0x0, 0x0, 0x5d, 0x5, 0xd0, 0x0, 0x0, 0x0,
    0x0, 0x39, 0x3, 0x80, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x4f, 0x50, 0x0,
    0xf8, 0x0, 0xc, 0xd0, 0xa, 0xe0, 0x0, 0xf8,
    0x0, 0x6f, 0x30, 0x1, 0xf8, 0x0, 0xf8, 0x0,
    0xea, 0x0, 0x0, 0x6f, 0x31, 0xf9, 0x19, 0xf1,
    0x0, 0x0, 0x1f, 0xff, 0xff, 0xff, 0x90, 0x0,
    0x0, 0x9f, 0x64, 0xfa, 0x4b, 0xf2, 0x0, 0x3,
    0xf9, 0x0, 0xf8, 0x1, 0xfc, 0x0, 0xd, 0xe0,
    0x0, 0xf8, 0x0, 0x6f, 0x60, 0x8f, 0x50, 0x0,
    0xf8, 0x0, 0xc, 0xf1,

    /* U+04DE "Ӟ" */
    0x0, 0x9, 0x20, 0x91, 0x0, 0x0, 0x1e, 0x31,
    0xe3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4,
    0xad, 0xfe, 0xa3, 0x0, 0xf, 0xd9, 0x89, 0xef,
    0x40, 0x2, 0x0, 0x0, 0x1e, 0xc0, 0x0, 0x0,
    0x0, 0xd, 0xc0, 0x0, 0x1, 0x12, 0x7f, 0x60,
    0x0, 0x6f, 0xff, 0xf9, 0x0, 0x0, 0x14, 0x45,
    0x8f, 0x90, 0x0, 0x0, 0x0, 0x7, 0xf2, 0x0,
    0x0, 0x0, 0x5, 0xf4, 0x15, 0x0, 0x0, 0xb,
    0xf2, 0x4f, 0xc7, 0x68, 0xdf, 0x80, 0x4, 0xbf,
    0xfe, 0xb5, 0x0,

    /* U+04DF "ӟ" */
    0x0, 0xd5, 0xd, 0x40, 0x0, 0x93, 0x9, 0x20,
    0x0, 0x0, 0x0, 0x0, 0x7, 0xcf, 0xfc, 0x40,
    0xe, 0x96, 0x7d, 0xf4, 0x0, 0x0, 0x1, 0xf8,
    0x0, 0x0, 0x6, 0xf4, 0x0, 0x4f, 0xff, 0x80,
    0x0, 0x2, 0x36, 0xf7, 0x0, 0x0, 0x0, 0xdc,
    0x5e, 0x97, 0x7b, 0xf7, 0x17, 0xdf, 0xfc, 0x60,

    /* U+04E0 "Ӡ" */
    0x1f, 0xff, 0xff, 0xff, 0xa0, 0x6, 0x66, 0x66,
    0xbf, 0x50, 0x0, 0x0, 0x3, 0xf8, 0x0, 0x0,
    0x0, 0x1e, 0xa0, 0x0, 0x0, 0x0, 0xcc, 0x0,
    0x0, 0x0, 0x4, 0xff, 0xe8, 0x0, 0x0, 0x1,
    0x35, 0xaf, 0xa0, 0x0, 0x0, 0x0, 0xa, 0xf1,
    0x0, 0x0, 0x0, 0x7, 0xf2, 0x17, 0x0, 0x0,
    0xc, 0xe0, 0x4f, 0xe9, 0x78, 0xdf, 0x60, 0x3,
    0xae, 0xfe, 0xc5, 0x0,

    /* U+04E1 "ӡ" */
    0xe, 0xff, 0xff, 0xff, 0x60, 0x66, 0x66, 0x6c,
    0xf2, 0x0, 0x0, 0x4, 0xf5, 0x0, 0x0, 0x2,
    0xe9, 0x0, 0x0, 0x0, 0xdc, 0x0, 0x0, 0x0,
    0x5f, 0xfd, 0x60, 0x0, 0x1, 0x35, 0xbf, 0x60,
    0x0, 0x0, 0x0, 0xec, 0x0, 0x0, 0x0, 0xb,
    0xd0, 0x70, 0x0, 0x1, 0xfb, 0x2f, 0xea, 0x89,
    0xef, 0x30, 0x29, 0xef, 0xeb, 0x30,

    /* U+04E2 "Ӣ" */
    0x0, 0xe, 0xee, 0xee, 0x20, 0x0, 0x0, 0x11,
    0x11, 0x10, 0x0, 0x4f, 0x50, 0x0, 0x0, 0x6f,
    0x64, 0xf5, 0x0, 0x0, 0x2f, 0xf6, 0x4f, 0x50,
    0x0, 0xd, 0xff, 0x64, 0xf5, 0x0, 0x9, 0xf7,
    0xf6, 0x4f, 0x50, 0x4, 0xf9, 0x2f, 0x64, 0xf5,
    0x1, 0xed, 0x2, 0xf6, 0x4f, 0x50, 0xbf, 0x20,
    0x2f, 0x64, 0xf5, 0x6f, 0x70, 0x2, 0xf6, 0x4f,
    0x7f, 0xb0, 0x0, 0x2f, 0x64, 0xff, 0xe1, 0x0,
    0x2, 0xf6, 0x4f, 0xf4, 0x0, 0x0, 0x2f, 0x64,
    0xf9, 0x0, 0x0, 0x2, 0xf6,

    /* U+04E3 "ӣ" */
    0x2, 0xff, 0xff, 0xf0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x8, 0xf0, 0x0,
    0x3, 0xf9, 0x8f, 0x0, 0x1, 0xef, 0x98, 0xf0,
    0x0, 0xce, 0xf9, 0x8f, 0x0, 0x9f, 0x3f, 0x98,
    0xf0, 0x5f, 0x60, 0xf9, 0x8f, 0x3f, 0xa0, 0xf,
    0x98, 0xfe, 0xc0, 0x0, 0xf9, 0x8f, 0xe2, 0x0,
    0xf, 0x98, 0xf4, 0x0, 0x0, 0xf9,

    /* U+04E4 "Ӥ" */
    0x0, 0x5, 0x60, 0x56, 0x0, 0x0, 0x0, 0x9a,
    0x9, 0xa0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x4, 0xf5, 0x0, 0x0, 0x6, 0xf6, 0x4f, 0x50,
    0x0, 0x2, 0xff, 0x64, 0xf5, 0x0, 0x0, 0xdf,
    0xf6, 0x4f, 0x50, 0x0, 0x9f, 0x7f, 0x64, 0xf5,
    0x0, 0x4f, 0x92, 0xf6, 0x4f, 0x50, 0x1e, 0xd0,
    0x2f, 0x64, 0xf5, 0xb, 0xf2, 0x2, 0xf6, 0x4f,
    0x56, 0xf7, 0x0, 0x2f, 0x64, 0xf7, 0xfb, 0x0,
    0x2, 0xf6, 0x4f, 0xfe, 0x10, 0x0, 0x2f, 0x64,
    0xff, 0x40, 0x0, 0x2, 0xf6, 0x4f, 0x90, 0x0,
    0x0, 0x2f, 0x60,

    /* U+04E5 "ӥ" */
    0x0, 0xa8, 0xa, 0x80, 0x0, 0x6, 0x50, 0x75,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x8, 0xf0, 0x0,
    0x3, 0xf9, 0x8f, 0x0, 0x1, 0xef, 0x98, 0xf0,
    0x0, 0xce, 0xf9, 0x8f, 0x0, 0x9f, 0x3f, 0x98,
    0xf0, 0x5f, 0x60, 0xf9, 0x8f, 0x3f, 0xa0, 0xf,
    0x98, 0xfe, 0xc0, 0x0, 0xf9, 0x8f, 0xe2, 0x0,
    0xf, 0x98, 0xf4, 0x0, 0x0, 0xf9,

    /* U+04E6 "Ӧ" */
    0x0, 0x0, 0x5d, 0x5, 0xd0, 0x0, 0x0, 0x0,
    0x3, 0x90, 0x39, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x19, 0xdf, 0xeb,
    0x50, 0x0, 0x0, 0x4f, 0xfb, 0x89, 0xdf, 0xb0,
    0x0, 0x2f, 0xd2, 0x0, 0x0, 0x7f, 0xa0, 0xa,
    0xf3, 0x0, 0x0, 0x0, 0x9f, 0x30, 0xfa, 0x0,
    0x0, 0x0, 0x2, 0xf8, 0x2f, 0x70, 0x0, 0x0,
    0x0, 0xe, 0xa2, 0xf7, 0x0, 0x0, 0x0, 0x0,
    0xea, 0xf, 0xa0, 0x0, 0x0, 0x0, 0x2f, 0x80,
    0xaf, 0x30, 0x0, 0x0, 0x9, 0xf3, 0x2, 0xfd,
    0x20, 0x0, 0x7, 0xfa, 0x0, 0x4, 0xff, 0xb8,
    0x9d, 0xfb, 0x0, 0x0, 0x1, 0x9d, 0xfe, 0xb5,
    0x0, 0x0,

    /* U+04E7 "ӧ" */
    0x0, 0x1e, 0x31, 0xe3, 0x0, 0x0, 0x9, 0x20,
    0x91, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x3b, 0xef, 0xc4, 0x0, 0x3, 0xfd, 0x87, 0xcf,
    0x60, 0xd, 0xd0, 0x0, 0xa, 0xf1, 0x3f, 0x60,
    0x0, 0x3, 0xf6, 0x4f, 0x40, 0x0, 0x1, 0xf7,
    0x3f, 0x60, 0x0, 0x3, 0xf6, 0xd, 0xd1, 0x0,
    0xb, 0xf1, 0x3, 0xfd, 0x87, 0xcf, 0x60, 0x0,
    0x3b, 0xef, 0xc4, 0x0,

    /* U+04E8 "Ө" */
    0x0, 0x1, 0x8d, 0xfe, 0xb5, 0x0, 0x0, 0x4,
    0xff, 0xb8, 0x9d, 0xfb, 0x0, 0x2, 0xfc, 0x20,
    0x0, 0x6, 0xfa, 0x0, 0xae, 0x10, 0x0, 0x0,
    0x7, 0xf3, 0xf, 0x91, 0x11, 0x11, 0x11, 0x1f,
    0x82, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x2f,
    0xa4, 0x44, 0x44, 0x44, 0x4f, 0xa0, 0xfc, 0x0,
    0x0, 0x0, 0x3, 0xf8, 0xa, 0xf4, 0x0, 0x0,
    0x0, 0xcf, 0x30, 0x2f, 0xe4, 0x0, 0x0, 0x9f,
    0xa0, 0x0, 0x4f, 0xfb, 0x89, 0xef, 0xb0, 0x0,
    0x0, 0x18, 0xdf, 0xfb, 0x50, 0x0,

    /* U+04E9 "ө" */
    0x0, 0x2a, 0xef, 0xc6, 0x0, 0x3, 0xfc, 0x65,
    0x9f, 0x90, 0xd, 0xd0, 0x0, 0x6, 0xf3, 0x2f,
    0x60, 0x0, 0x0, 0xf9, 0x4f, 0xff, 0xff, 0xff,
    0xfa, 0x2f, 0x72, 0x22, 0x22, 0xf9, 0xd, 0xc0,
    0x0, 0x6, 0xf3, 0x3, 0xfc, 0x65, 0x9f, 0x90,
    0x0, 0x2a, 0xef, 0xc6, 0x0,

    /* U+04EA "Ӫ" */
    0x0, 0x0, 0x5d, 0x5, 0xd0, 0x0, 0x0, 0x0,
    0x3, 0x90, 0x39, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x19, 0xdf, 0xeb,
    0x50, 0x0, 0x0, 0x4f, 0xfb, 0x89, 0xdf, 0xb0,
    0x0, 0x2f, 0xc2, 0x0, 0x0, 0x6f, 0xa0, 0xa,
    0xe1, 0x0, 0x0, 0x0, 0x8f, 0x30, 0xf9, 0x11,
    0x11, 0x11, 0x12, 0xf8, 0x2f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xa2, 0xfa, 0x44, 0x44, 0x44, 0x44,
    0xfa, 0xf, 0xc0, 0x0, 0x0, 0x0, 0x3f, 0x80,
    0xaf, 0x40, 0x0, 0x0, 0xc, 0xf3, 0x2, 0xfe,
    0x40, 0x0, 0x9, 0xfa, 0x0, 0x4, 0xff, 0xb8,
    0x9e, 0xfb, 0x0, 0x0, 0x1, 0x9d, 0xfe, 0xb5,
    0x0, 0x0,

    /* U+04EB "ӫ" */
    0x0, 0xd, 0x50, 0xd4, 0x0, 0x0, 0x9, 0x30,
    0x92, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x2a, 0xef, 0xc6, 0x0, 0x3, 0xfc, 0x65, 0x9f,
    0x90, 0xd, 0xc0, 0x0, 0x7, 0xf3, 0x3f, 0x50,
    0x0, 0x0, 0xf8, 0x4f, 0xff, 0xff, 0xff, 0xfa,
    0x3f, 0x62, 0x22, 0x22, 0xf8, 0xd, 0xc0, 0x0,
    0x6, 0xf3, 0x3, 0xfc, 0x65, 0x9f, 0x90, 0x0,
    0x2a, 0xef, 0xc6, 0x0,

    /* U+04EC "Ӭ" */
    0x0, 0x1e, 0x41, 0xe3, 0x0, 0x0, 0x0, 0xa2,
    0xa, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x18, 0xdf, 0xeb, 0x40, 0x0, 0x3f, 0xfa,
    0x89, 0xef, 0x90, 0x1, 0x91, 0x0, 0x0, 0x9f,
    0x60, 0x0, 0x0, 0x0, 0x0, 0xce, 0x0, 0x0,
    0x1, 0x11, 0x16, 0xf4, 0x0, 0xa, 0xff, 0xff,
    0xff, 0x60, 0x0, 0x24, 0x44, 0x47, 0xf6, 0x0,
    0x0, 0x0, 0x0, 0x7f, 0x40, 0x0, 0x0, 0x0,
    0x1e, 0xe0, 0x1c, 0x20, 0x0, 0xb, 0xf6, 0x3,
    0xef, 0xb8, 0x9e, 0xf9, 0x0, 0x1, 0x8d, 0xfe,
    0xb4, 0x0, 0x0,

    /* U+04ED "ӭ" */
    0x0, 0xd5, 0xd, 0x40, 0x0, 0x9, 0x30, 0x92,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6c, 0xfe,
    0xb3, 0x0, 0x6f, 0x95, 0x6c, 0xf5, 0x0, 0x20,
    0x0, 0xa, 0xf1, 0x0, 0x0, 0x0, 0x2f, 0x50,
    0x3, 0xff, 0xff, 0xf7, 0x0, 0x3, 0x33, 0x4f,
    0x50, 0x10, 0x0, 0x9, 0xf1, 0x5f, 0x96, 0x6b,
    0xf5, 0x0, 0x6c, 0xfe, 0xb3, 0x0,

    /* U+04EE "Ӯ" */
    0x0, 0x2e, 0xee, 0xee, 0x0, 0x0, 0x0, 0x11,
    0x11, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x8, 0xf3, 0x0, 0x0, 0x0, 0xea, 0x1f, 0xa0,
    0x0, 0x0, 0x6f, 0x20, 0x8f, 0x20, 0x0, 0xe,
    0x90, 0x1, 0xfa, 0x0, 0x6, 0xf2, 0x0, 0x7,
    0xf2, 0x0, 0xe9, 0x0, 0x0, 0xe, 0x90, 0x6f,
    0x10, 0x0, 0x0, 0x7f, 0x2e, 0x90, 0x0, 0x0,
    0x0, 0xee, 0xf1, 0x0, 0x0, 0x0, 0x7, 0xf8,
    0x0, 0x0, 0x0, 0x0, 0x9f, 0x10, 0x0, 0x0,
    0x48, 0xaf, 0x70, 0x0, 0x0, 0x7, 0xff, 0x70,
    0x0, 0x0, 0x0,

    /* U+04EF "ӯ" */
    0x0, 0x4f, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xbd, 0x0, 0x0, 0xa, 0xd0, 0x4, 0xf4,
    0x0, 0x1, 0xf6, 0x0, 0xd, 0xb0, 0x0, 0x8e,
    0x0, 0x0, 0x7f, 0x20, 0xe, 0x80, 0x0, 0x0,
    0xf8, 0x6, 0xf1, 0x0, 0x0, 0x9, 0xe0, 0xca,
    0x0, 0x0, 0x0, 0x2f, 0xaf, 0x30, 0x0, 0x0,
    0x0, 0xbf, 0xd0, 0x0, 0x0, 0x0, 0x5, 0xf6,
    0x0, 0x0, 0x0, 0x0, 0x9e, 0x0, 0x0, 0x0,
    0xb7, 0x8f, 0x70, 0x0, 0x0, 0xa, 0xee, 0x80,
    0x0, 0x0, 0x0,

    /* U+04F0 "Ӱ" */
    0x0, 0xa, 0x80, 0xb8, 0x0, 0x0, 0x0, 0x75,
    0x7, 0x50, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x8, 0xf3, 0x0, 0x0, 0x0, 0xea, 0x1f, 0xa0,
    0x0, 0x0, 0x6f, 0x20, 0x8f, 0x20, 0x0, 0xe,
    0x90, 0x1, 0xfa, 0x0, 0x6, 0xf2, 0x0, 0x7,
    0xf2, 0x0, 0xe9, 0x0, 0x0, 0xe, 0x90, 0x6f,
    0x10, 0x0, 0x0, 0x7f, 0x2e, 0x90, 0x0, 0x0,
    0x0, 0xee, 0xf1, 0x0, 0x0, 0x0, 0x7, 0xf8,
    0x0, 0x0, 0x0, 0x0, 0x9f, 0x10, 0x0, 0x0,
    0x48, 0xaf, 0x70, 0x0, 0x0, 0x7, 0xff, 0x70,
    0x0, 0x0, 0x0,

    /* U+04F1 "ӱ" */
    0x0, 0xc, 0x70, 0xc6, 0x0, 0x0, 0x0, 0x74,
    0x8, 0x40, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xbd, 0x0, 0x0, 0xa, 0xd0, 0x4, 0xf4,
    0x0, 0x1, 0xf6, 0x0, 0xd, 0xb0, 0x0, 0x8e,
    0x0, 0x0, 0x7f, 0x20, 0xe, 0x80, 0x0, 0x0,
    0xf8, 0x6, 0xf1, 0x0, 0x0, 0x9, 0xe0, 0xca,
    0x0, 0x0, 0x0, 0x2f, 0xaf, 0x30, 0x0, 0x0,
    0x0, 0xbf, 0xd0, 0x0, 0x0, 0x0, 0x5, 0xf6,
    0x0, 0x0, 0x0, 0x0, 0x9e, 0x0, 0x0, 0x0,
    0xb7, 0x8f, 0x70, 0x0, 0x0, 0xa, 0xee, 0x80,
    0x0, 0x0, 0x0,

    /* U+04F2 "Ӳ" */
    0x0, 0x0, 0x3, 0x11, 0x30, 0x0, 0x0, 0xa,
    0xd1, 0xda, 0x0, 0x0, 0x4, 0xe2, 0x8d, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8f, 0x30,
    0x0, 0x0, 0xe, 0xa1, 0xfa, 0x0, 0x0, 0x6,
    0xf2, 0x8, 0xf2, 0x0, 0x0, 0xe9, 0x0, 0x1f,
    0xa0, 0x0, 0x6f, 0x20, 0x0, 0x7f, 0x20, 0xe,
    0x90, 0x0, 0x0, 0xe9, 0x6, 0xf1, 0x0, 0x0,
    0x7, 0xf2, 0xe9, 0x0, 0x0, 0x0, 0xe, 0xef,
    0x10, 0x0, 0x0, 0x0, 0x7f, 0x80, 0x0, 0x0,
    0x0, 0x9, 0xf1, 0x0, 0x0, 0x4, 0x8a, 0xf7,
    0x0, 0x0, 0x0, 0x7f, 0xf7, 0x0, 0x0, 0x0,

    /* U+04F3 "ӳ" */
    0x0, 0x0, 0x9d, 0x1c, 0xb0, 0x0, 0x0, 0x4f,
    0x27, 0xd1, 0x0, 0x0, 0x1, 0x10, 0x21, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xb, 0xd0,
    0x0, 0x0, 0xad, 0x0, 0x4f, 0x40, 0x0, 0x1f,
    0x60, 0x0, 0xdb, 0x0, 0x8, 0xe0, 0x0, 0x7,
    0xf2, 0x0, 0xe8, 0x0, 0x0, 0xf, 0x80, 0x6f,
    0x10, 0x0, 0x0, 0x9e, 0xc, 0xa0, 0x0, 0x0,
    0x2, 0xfa, 0xf3, 0x0, 0x0, 0x0, 0xb, 0xfd,
    0x0, 0x0, 0x0, 0x0, 0x5f, 0x60, 0x0, 0x0,
    0x0, 0x9, 0xe0, 0x0, 0x0, 0xb, 0x78, 0xf7,
    0x0, 0x0, 0x0, 0xae, 0xe8, 0x0, 0x0, 0x0,

    /* U+04F4 "Ӵ" */
    0x0, 0x6, 0x50, 0x75, 0x0, 0x0, 0x0, 0xa8,
    0xb, 0x80, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x2, 0xf7, 0x0, 0x0, 0x9, 0xf0, 0x2f, 0x70,
    0x0, 0x0, 0x9f, 0x2, 0xf7, 0x0, 0x0, 0x9,
    0xf0, 0x2f, 0x70, 0x0, 0x0, 0x9f, 0x2, 0xf8,
    0x0, 0x0, 0x9, 0xf0, 0xf, 0xd0, 0x0, 0x0,
    0x9f, 0x0, 0x8f, 0xb4, 0x24, 0x9e, 0xf0, 0x0,
    0x9f, 0xff, 0xfe, 0xdf, 0x0, 0x0, 0x14, 0x42,
    0x9, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x9f, 0x0,
    0x0, 0x0, 0x0, 0x9, 0xf0, 0x0, 0x0, 0x0,
    0x0, 0x9f, 0x0,

    /* U+04F5 "ӵ" */
    0x0, 0xb8, 0xb, 0x70, 0x0, 0x7, 0x50, 0x74,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x5, 0xf3, 0x0,
    0x4, 0xf3, 0x5f, 0x30, 0x0, 0x4f, 0x35, 0xf3,
    0x0, 0x4, 0xf3, 0x4f, 0x40, 0x0, 0x4f, 0x31,
    0xfc, 0x31, 0x4a, 0xf3, 0x5, 0xef, 0xff, 0xcf,
    0x30, 0x0, 0x22, 0x4, 0xf3, 0x0, 0x0, 0x0,
    0x4f, 0x30, 0x0, 0x0, 0x4, 0xf3,

    /* U+04F6 "Ӷ" */
    0x4f, 0xff, 0xff, 0xff, 0x14, 0xf9, 0x77, 0x77,
    0x70, 0x4f, 0x40, 0x0, 0x0, 0x4, 0xf4, 0x0,
    0x0, 0x0, 0x4f, 0x40, 0x0, 0x0, 0x4, 0xf4,
    0x0, 0x0, 0x0, 0x4f, 0x40, 0x0, 0x0, 0x4,
    0xf4, 0x0, 0x0, 0x0, 0x4f, 0x40, 0x0, 0x0,
    0x4, 0xf4, 0x0, 0x0, 0x0, 0x6f, 0xc7, 0x0,
    0x0, 0x8, 0xff, 0xf0, 0x0, 0x0, 0x0, 0x7f,
    0x0, 0x0, 0x0, 0x7, 0xf0, 0x0, 0x0, 0x0,
    0x38, 0x0, 0x0, 0x0,

    /* U+04F7 "ӷ" */
    0x8f, 0xff, 0xff, 0xb8, 0xf6, 0x66, 0x64, 0x8f,
    0x0, 0x0, 0x8, 0xf0, 0x0, 0x0, 0x8f, 0x0,
    0x0, 0x8, 0xf0, 0x0, 0x0, 0x8f, 0x0, 0x0,
    0xb, 0xf6, 0x20, 0x0, 0xff, 0xf5, 0x0, 0x0,
    0x1f, 0x50, 0x0, 0x1, 0xf5, 0x0, 0x0,

    /* U+04F8 "Ӹ" */
    0x0, 0x0, 0x19, 0x1, 0x90, 0x0, 0x0, 0x0,
    0x0, 0x3e, 0x23, 0xe1, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x4f, 0x50, 0x0,
    0x0, 0x0, 0x7, 0xf2, 0x4f, 0x50, 0x0, 0x0,
    0x0, 0x7, 0xf2, 0x4f, 0x50, 0x0, 0x0, 0x0,
    0x7, 0xf2, 0x4f, 0x51, 0x10, 0x0, 0x0, 0x7,
    0xf2, 0x4f, 0xff, 0xff, 0xfb, 0x30, 0x7, 0xf2,
    0x4f, 0x74, 0x44, 0x7e, 0xf2, 0x7, 0xf2, 0x4f,
    0x50, 0x0, 0x2, 0xf9, 0x7, 0xf2, 0x4f, 0x50,
    0x0, 0x0, 0xeb, 0x7, 0xf2, 0x4f, 0x50, 0x0,
    0x0, 0xeb, 0x7, 0xf2, 0x4f, 0x50, 0x0, 0x4,
    0xf7, 0x7, 0xf2, 0x4f, 0x85, 0x55, 0x8f, 0xe1,
    0x7, 0xf2, 0x4f, 0xff, 0xff, 0xe9, 0x10, 0x7,
    0xf2,

    /* U+04F9 "ӹ" */
    0x0, 0x7, 0xb0, 0x7b, 0x0, 0x0, 0x0, 0x47,
    0x4, 0x70, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x8, 0xf0, 0x0, 0x0, 0x2, 0xf6, 0x8f, 0x0,
    0x0, 0x0, 0x2f, 0x68, 0xf0, 0x0, 0x0, 0x2,
    0xf6, 0x8f, 0xff, 0xfd, 0x50, 0x2f, 0x68, 0xf3,
    0x34, 0xaf, 0x32, 0xf6, 0x8f, 0x0, 0x0, 0xf8,
    0x2f, 0x68, 0xf0, 0x0, 0x1f, 0x72, 0xf6, 0x8f,
    0x33, 0x4b, 0xf3, 0x2f, 0x68, 0xff, 0xff, 0xc4,
    0x2, 0xf6,

    /* U+04FA "Ӻ" */
    0x0, 0xdf, 0xff, 0xff, 0xf8, 0x0, 0xdd, 0x77,
    0x77, 0x73, 0x0, 0xdc, 0x0, 0x0, 0x0, 0x0,
    0xdc, 0x0, 0x0, 0x0, 0x0, 0xdc, 0x0, 0x0,
    0x0, 0x0, 0xdc, 0x0, 0x0, 0x0, 0x8f, 0xff,
    0xff, 0xff, 0x70, 0x13, 0xdc, 0x33, 0x33, 0x10,
    0x0, 0xdc, 0x0, 0x0, 0x0, 0x0, 0xdc, 0x0,
    0x0, 0x0, 0x0, 0xdd, 0x72, 0x0, 0x0, 0x0,
    0xdf, 0xf5, 0x0, 0x0, 0x0, 0x3, 0xf5, 0x0,
    0x0, 0x7, 0x6c, 0xf2, 0x0, 0x0, 0x1b, 0xfe,
    0x50, 0x0, 0x0,

    /* U+04FB "ӻ" */
    0x2, 0xff, 0xff, 0xf7, 0x2, 0xfa, 0x66, 0x63,
    0x2, 0xf6, 0x0, 0x0, 0x2, 0xf6, 0x0, 0x0,
    0x7f, 0xff, 0xff, 0xc0, 0x14, 0xf7, 0x22, 0x10,
    0x2, 0xf6, 0x0, 0x0, 0x2, 0xfa, 0x50, 0x0,
    0x2, 0xff, 0xb0, 0x0, 0x0, 0xd, 0xb0, 0x0,
    0x46, 0x8f, 0x70, 0x0, 0x7e, 0xfa, 0x0, 0x0,

    /* U+04FC "Ӽ" */
    0x3f, 0xa0, 0x0, 0x0, 0xdd, 0x0, 0x8f, 0x40,
    0x0, 0x8f, 0x30, 0x0, 0xde, 0x10, 0x3f, 0x80,
    0x0, 0x2, 0xfa, 0xd, 0xd0, 0x0, 0x0, 0x7,
    0xfc, 0xf3, 0x0, 0x0, 0x0, 0xc, 0xf9, 0x0,
    0x0, 0x0, 0x1, 0xef, 0xd0, 0x0, 0x0, 0x0,
    0xbf, 0x6f, 0xa0, 0x0, 0x0, 0x6f, 0x60, 0x7f,
    0x60, 0x0, 0x2f, 0xb0, 0x0, 0xbf, 0x20, 0xc,
    0xf1, 0x0, 0x2, 0xfb, 0x7, 0xf6, 0x0, 0x0,
    0x9, 0xf2, 0x0, 0x0, 0x0, 0x0, 0x7f, 0x30,
    0x0, 0x0, 0x7, 0x6e, 0xf1, 0x0, 0x0, 0x1,
    0xcf, 0xd4, 0x0,

    /* U+04FD "ӽ" */
    0x4f, 0x60, 0x0, 0xae, 0x10, 0x9f, 0x20, 0x6f,
    0x40, 0x0, 0xdd, 0x3f, 0x90, 0x0, 0x2, 0xff,
    0xd0, 0x0, 0x0, 0xb, 0xf7, 0x0, 0x0, 0x5,
    0xfd, 0xf4, 0x0, 0x1, 0xeb, 0xc, 0xe1, 0x0,
    0xbe, 0x10, 0x1e, 0xb0, 0x7f, 0x40, 0x0, 0x5f,
    0x30, 0x0, 0x0, 0x1, 0xf7, 0x0, 0x0, 0x56,
    0xaf, 0x40, 0x0, 0x9, 0xfe, 0x70,

    /* U+04FE "Ӿ" */
    0x1e, 0xd0, 0x0, 0x1, 0xed, 0x0, 0x4f, 0x90,
    0x0, 0xaf, 0x30, 0x0, 0x9f, 0x40, 0x5f, 0x80,
    0x0, 0x0, 0xde, 0x3f, 0xc0, 0x0, 0x0, 0x4,
    0xff, 0xf3, 0x0, 0x0, 0x8f, 0xff, 0xff, 0xff,
    0x50, 0x1, 0x36, 0xff, 0xf5, 0x31, 0x0, 0x0,
    0xcf, 0x5f, 0xc0, 0x0, 0x0, 0x6f, 0x70, 0x8f,
    0x60, 0x0, 0x1e, 0xd0, 0x0, 0xde, 0x10, 0xa,
    0xf3, 0x0, 0x4, 0xfa, 0x4, 0xf9, 0x0, 0x0,
    0xa, 0xf4,

    /* U+04FF "ӿ" */
    0x2f, 0x90, 0x0, 0x7f, 0x30, 0x7f, 0x40, 0x2f,
    0x80, 0x0, 0xce, 0x1c, 0xc0, 0x0, 0x2, 0xfe,
    0xf2, 0x0, 0x9, 0xff, 0xff, 0xfb, 0x0, 0x14,
    0xfe, 0xf5, 0x10, 0x0, 0xcd, 0x1d, 0xd0, 0x0,
    0x8f, 0x30, 0x2f, 0xa0, 0x4f, 0x60, 0x0, 0x6f,
    0x50,

    /* U+0510 "Ԑ" */
    0x0, 0x19, 0xef, 0xeb, 0x60, 0x1, 0xef, 0xa8,
    0x9c, 0xf3, 0x8, 0xf5, 0x0, 0x0, 0x20, 0x8,
    0xf1, 0x0, 0x0, 0x0, 0x2, 0xfa, 0x21, 0x10,
    0x0, 0x0, 0x5f, 0xff, 0xfa, 0x0, 0x5, 0xfa,
    0x54, 0x42, 0x0, 0xe, 0xb0, 0x0, 0x0, 0x0,
    0xf, 0x90, 0x0, 0x0, 0x0, 0xe, 0xe1, 0x0,
    0x0, 0x33, 0x4, 0xfe, 0x97, 0x7b, 0xf8, 0x0,
    0x3a, 0xef, 0xfc, 0x60,

    /* U+0511 "ԑ" */
    0x0, 0x7d, 0xfe, 0xb5, 0x0, 0x9f, 0xb6, 0x7b,
    0xa0, 0xd, 0xc0, 0x0, 0x0, 0x0, 0x9e, 0x30,
    0x0, 0x0, 0x1, 0xdf, 0xff, 0x0, 0x0, 0xcd,
    0x42, 0x20, 0x0, 0x1f, 0x80, 0x0, 0x0, 0x0,
    0xcf, 0x96, 0x7a, 0xf1, 0x1, 0x8d, 0xff, 0xb5,
    0x0,

    /* U+0512 "Ԓ" */
    0x0, 0xf, 0xff, 0xff, 0xff, 0xe0, 0x0, 0xfa,
    0x77, 0x77, 0xde, 0x0, 0x1f, 0x50, 0x0, 0xa,
    0xe0, 0x1, 0xf4, 0x0, 0x0, 0xae, 0x0, 0x2f,
    0x40, 0x0, 0xa, 0xe0, 0x3, 0xf3, 0x0, 0x0,
    0xae, 0x0, 0x4f, 0x20, 0x0, 0xa, 0xe0, 0x6,
    0xf1, 0x0, 0x0, 0xae, 0x0, 0x8e, 0x0, 0x0,
    0xa, 0xe0, 0xe, 0xb0, 0x0, 0x0, 0xae, 0x6c,
    0xf5, 0x0, 0x0, 0xa, 0xeb, 0xf9, 0x0, 0x0,
    0x0, 0xae, 0x0, 0x0, 0x0, 0x0, 0xc, 0xd0,
    0x0, 0x0, 0x3, 0x78, 0xfa, 0x0, 0x0, 0x0,
    0x5e, 0xfb, 0x10,

    /* U+0513 "ԓ" */
    0x0, 0xcf, 0xff, 0xff, 0xc0, 0xd, 0xb6, 0x66,
    0xdc, 0x0, 0xd8, 0x0, 0xc, 0xc0, 0xe, 0x70,
    0x0, 0xcc, 0x0, 0xf6, 0x0, 0xc, 0xc0, 0x1f,
    0x40, 0x0, 0xcc, 0x5, 0xf1, 0x0, 0xc, 0xc6,
    0xed, 0x0, 0x0, 0xcc, 0xde, 0x40, 0x0, 0xc,
    0xc0, 0x0, 0x0, 0x0, 0xdb, 0x0, 0x0, 0x46,
    0x8f, 0x70, 0x0, 0x7, 0xee, 0x90,

    /* U+051A "Ԛ" */
    0x0, 0x1, 0x9d, 0xfe, 0xb5, 0x0, 0x0, 0x0,
    0x4f, 0xfb, 0x89, 0xdf, 0xb0, 0x0, 0x2, 0xfd,
    0x20, 0x0, 0x7, 0xfa, 0x0, 0xa, 0xf3, 0x0,
    0x0, 0x0, 0x9f, 0x30, 0xf, 0xa0, 0x0, 0x0,
    0x0, 0x2f, 0x80, 0x2f, 0x70, 0x0, 0x0, 0x0,
    0xf, 0xa0, 0x2f, 0x70, 0x0, 0x0, 0x0, 0xe,
    0xa0, 0xf, 0xa0, 0x0, 0x0, 0x0, 0x2f, 0x80,
    0xb, 0xf2, 0x0, 0x0, 0x0, 0x9f, 0x30, 0x2,
    0xfd, 0x10, 0x0, 0x7, 0xfa, 0x0, 0x0, 0x5f,
    0xfa, 0x78, 0xdf, 0xb0, 0x0, 0x0, 0x2, 0xae,
    0xff, 0xd6, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3e,
    0xe4, 0x15, 0xb0, 0x0, 0x0, 0x0, 0x2, 0xbf,
    0xff, 0x90, 0x0, 0x0, 0x0, 0x0, 0x1, 0x31,
    0x0,

    /* U+051B "ԛ" */
    0x0, 0x3b, 0xef, 0xb2, 0xf8, 0x4, 0xfe, 0x87,
    0xce, 0xf8, 0xd, 0xd1, 0x0, 0xa, 0xf8, 0x2f,
    0x60, 0x0, 0x2, 0xf8, 0x4f, 0x40, 0x0, 0x0,
    0xf8, 0x2f, 0x60, 0x0, 0x2, 0xf8, 0xd, 0xd1,
    0x0, 0xa, 0xf8, 0x4, 0xfe, 0x87, 0xce, 0xf8,
    0x0, 0x3b, 0xff, 0xa2, 0xf8, 0x0, 0x0, 0x0,
    0x0, 0xf8, 0x0, 0x0, 0x0, 0x0, 0xf8, 0x0,
    0x0, 0x0, 0x0, 0xf8,

    /* U+051C "Ԝ" */
    0x8f, 0x20, 0x0, 0x2, 0xfa, 0x0, 0x0, 0xa,
    0xe0, 0x3f, 0x70, 0x0, 0x7, 0xfe, 0x0, 0x0,
    0xf, 0x90, 0xe, 0xc0, 0x0, 0xc, 0xef, 0x40,
    0x0, 0x4f, 0x40, 0x9, 0xf1, 0x0, 0x1f, 0x6f,
    0x90, 0x0, 0x9f, 0x0, 0x4, 0xf5, 0x0, 0x6f,
    0x1a, 0xd0, 0x0, 0xea, 0x0, 0x0, 0xfa, 0x0,
    0xbc, 0x5, 0xf2, 0x3, 0xf5, 0x0, 0x0, 0xaf,
    0x1, 0xf7, 0x0, 0xf7, 0x8, 0xf0, 0x0, 0x0,
    0x5f, 0x45, 0xf2, 0x0, 0xbc, 0xd, 0xb0, 0x0,
    0x0, 0xf, 0x9a, 0xd0, 0x0, 0x6f, 0x4f, 0x60,
    0x0, 0x0, 0xb, 0xef, 0x80, 0x0, 0x1f, 0xdf,
    0x10, 0x0, 0x0, 0x6, 0xff, 0x30, 0x0, 0xc,
    0xfc, 0x0, 0x0, 0x0, 0x1, 0xfd, 0x0, 0x0,
    0x7, 0xf7, 0x0, 0x0,

    /* U+051D "ԝ" */
    0xae, 0x0, 0x0, 0x5f, 0x60, 0x0, 0xd, 0xa5,
    0xf4, 0x0, 0xb, 0xfc, 0x0, 0x3, 0xf4, 0xe,
    0xa0, 0x1, 0xfb, 0xf2, 0x0, 0x8e, 0x0, 0x9f,
    0x0, 0x7f, 0x1f, 0x70, 0xe, 0x90, 0x3, 0xf5,
    0xd, 0xa0, 0xad, 0x4, 0xf3, 0x0, 0xd, 0xa3,
    0xf4, 0x4, 0xf3, 0xad, 0x0, 0x0, 0x7f, 0x9e,
    0x0, 0xe, 0x9f, 0x70, 0x0, 0x2, 0xff, 0x90,
    0x0, 0x8f, 0xf1, 0x0, 0x0, 0xc, 0xf3, 0x0,
    0x2, 0xfc, 0x0, 0x0,

    /* U+0524 "Ԥ" */
    0x4f, 0xff, 0xff, 0xff, 0xff, 0x60, 0x4, 0xf9,
    0x77, 0x77, 0x78, 0xf6, 0x0, 0x4f, 0x50, 0x0,
    0x0, 0x3f, 0x60, 0x4, 0xf5, 0x0, 0x0, 0x3,
    0xf6, 0x0, 0x4f, 0x50, 0x0, 0x0, 0x3f, 0x60,
    0x4, 0xf5, 0x0, 0x0, 0x3, 0xf6, 0x0, 0x4f,
    0x50, 0x0, 0x0, 0x3f, 0x60, 0x4, 0xf5, 0x0,
    0x0, 0x3, 0xf6, 0x0, 0x4f, 0x50, 0x0, 0x0,
    0x3f, 0x60, 0x4, 0xf5, 0x0, 0x0, 0x3, 0xf6,
    0x0, 0x4f, 0x50, 0x0, 0x0, 0x4f, 0xd7, 0x4,
    0xf5, 0x0, 0x0, 0x6, 0xff, 0xf1, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x6f, 0x10, 0x0, 0x0, 0x0,
    0x0, 0x6, 0xf1, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x38, 0x0,

    /* U+0525 "ԥ" */
    0x8f, 0xff, 0xff, 0xff, 0x50, 0x8f, 0x66, 0x66,
    0x8f, 0x50, 0x8f, 0x0, 0x0, 0x3f, 0x50, 0x8f,
    0x0, 0x0, 0x3f, 0x50, 0x8f, 0x0, 0x0, 0x3f,
    0x50, 0x8f, 0x0, 0x0, 0x3f, 0x50, 0x8f, 0x0,
    0x0, 0x3f, 0x50, 0x8f, 0x0, 0x0, 0x4f, 0xb4,
    0x8f, 0x0, 0x0, 0x6f, 0xfa, 0x0, 0x0, 0x0,
    0x0, 0xca, 0x0, 0x0, 0x0, 0x0, 0xca,

    /* U+0526 "Ԧ" */
    0x4f, 0x50, 0x0, 0x0, 0x0, 0x0, 0x4f, 0x50,
    0x0, 0x0, 0x0, 0x0, 0x4f, 0x50, 0x0, 0x0,
    0x0, 0x0, 0x4f, 0x50, 0x1, 0x0, 0x0, 0x0,
    0x4f, 0xac, 0xff, 0xfc, 0x40, 0x0, 0x4f, 0xfa,
    0x75, 0x8e, 0xf3, 0x0, 0x4f, 0x50, 0x0, 0x2,
    0xfa, 0x0, 0x4f, 0x50, 0x0, 0x0, 0xcd, 0x0,
    0x4f, 0x50, 0x0, 0x0, 0xae, 0x0, 0x4f, 0x50,
    0x0, 0x0, 0xae, 0x0, 0x4f, 0x50, 0x0, 0x0,
    0xff, 0x74, 0x4f, 0x50, 0x0, 0x0, 0xff, 0xf9,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xd9, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xd9, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x64,

    /* U+0527 "ԧ" */
    0x37, 0x0, 0x0, 0x0, 0x0, 0x8f, 0x0, 0x0,
    0x0, 0x0, 0x8f, 0x0, 0x0, 0x0, 0x0, 0x8f,
    0x0, 0x0, 0x0, 0x0, 0x8f, 0x2a, 0xef, 0xb2,
    0x0, 0x8f, 0xdc, 0x8a, 0xfe, 0x0, 0x8f, 0x90,
    0x0, 0x6f, 0x50, 0x8f, 0x20, 0x0, 0x1f, 0x80,
    0x8f, 0x0, 0x0, 0xf, 0x80, 0x8f, 0x0, 0x0,
    0xf, 0x80, 0x8f, 0x0, 0x0, 0xf, 0x80, 0x8f,
    0x0, 0x0, 0xf, 0xb3, 0x8f, 0x0, 0x0, 0xf,
    0xfc, 0x0, 0x0, 0x0, 0x0, 0xac, 0x0, 0x0,
    0x0, 0x0, 0xac,

    /* U+0528 "Ԩ" */
    0x0, 0x3, 0xf5, 0x0, 0x0, 0x4, 0xf5, 0x0,
    0x3, 0xf5, 0x0, 0x0, 0x4, 0xf5, 0x0, 0x3,
    0xf5, 0x0, 0x0, 0x4, 0xf5, 0x0, 0x3, 0xf5,
    0x0, 0x0, 0x4, 0xf5, 0x0, 0x3, 0xf6, 0x22,
    0x22, 0x25, 0xf5, 0x0, 0x3, 0xff, 0xff, 0xff,
    0xff, 0xf5, 0x0, 0x3, 0xf8, 0x55, 0x55, 0x58,
    0xf5, 0x0, 0x3, 0xf5, 0x0, 0x0, 0x4, 0xf5,
    0x0, 0x3, 0xf5, 0x0, 0x0, 0x4, 0xf5, 0x0,
    0x3, 0xf5, 0x0, 0x0, 0x4, 0xf5, 0x0, 0x3,
    0xf5, 0x0, 0x0, 0x4, 0xf5, 0x0, 0x3, 0xf5,
    0x0, 0x0, 0x4, 0xf5, 0x0, 0x5, 0xf4, 0x0,
    0x0, 0x0, 0x0, 0x8, 0x7d, 0xf1, 0x0, 0x0,
    0x0, 0x0, 0x1c, 0xfd, 0x40, 0x0, 0x0, 0x0,
    0x0,

    /* U+0529 "ԩ" */
    0x0, 0x8, 0xf0, 0x0, 0x2, 0xf6, 0x0, 0x8,
    0xf0, 0x0, 0x2, 0xf6, 0x0, 0x8, 0xf0, 0x0,
    0x2, 0xf6, 0x0, 0x8, 0xf2, 0x11, 0x13, 0xf6,
    0x0, 0x8, 0xff, 0xff, 0xff, 0xf6, 0x0, 0x8,
    0xf5, 0x44, 0x46, 0xf6, 0x0, 0x8, 0xf0, 0x0,
    0x2, 0xf6, 0x0, 0x8, 0xf0, 0x0, 0x2, 0xf6,
    0x0, 0x8, 0xf0, 0x0, 0x2, 0xf6, 0x0, 0x9,
    0xf0, 0x0, 0x0, 0x0, 0x17, 0x6e, 0xc0, 0x0,
    0x0, 0x0, 0x3d, 0xfc, 0x20, 0x0, 0x0, 0x0,

    /* U+052E "Ԯ" */
    0x0, 0xf, 0xff, 0xff, 0xff, 0xe0, 0x0, 0x0,
    0xfa, 0x77, 0x77, 0xde, 0x0, 0x0, 0x1f, 0x50,
    0x0, 0xa, 0xe0, 0x0, 0x1, 0xf4, 0x0, 0x0,
    0xae, 0x0, 0x0, 0x2f, 0x40, 0x0, 0xa, 0xe0,
    0x0, 0x3, 0xf3, 0x0, 0x0, 0xae, 0x0, 0x0,
    0x4f, 0x20, 0x0, 0xa, 0xe0, 0x0, 0x5, 0xf1,
    0x0, 0x0, 0xae, 0x0, 0x0, 0x8f, 0x0, 0x0,
    0xa, 0xe0, 0x0, 0xd, 0xb0, 0x0, 0x0, 0xae,
    0x0, 0x6c, 0xf5, 0x0, 0x0, 0xa, 0xf9, 0x5b,
    0xf9, 0x0, 0x0, 0x0, 0xaf, 0xf9, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xe, 0x90, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xe9, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x7, 0x40,

    /* U+052F "ԯ" */
    0x0, 0xcf, 0xff, 0xff, 0xc0, 0x0, 0xd, 0xb6,
    0x66, 0xdc, 0x0, 0x0, 0xd8, 0x0, 0xc, 0xc0,
    0x0, 0xe, 0x70, 0x0, 0xcc, 0x0, 0x0, 0xf6,
    0x0, 0xc, 0xc0, 0x0, 0x1f, 0x40, 0x0, 0xcc,
    0x0, 0x5, 0xf1, 0x0, 0xc, 0xc0, 0x5, 0xdd,
    0x0, 0x0, 0xff, 0x50, 0xde, 0x30, 0x0, 0xf,
    0xff, 0x10, 0x0, 0x0, 0x0, 0x6, 0xf1, 0x0,
    0x0, 0x0, 0x0, 0x6f, 0x10,

    /* U+2007 " " */

    /* U+2008 " " */

    /* U+2009 " " */

    /* U+200A " " */

    /* U+200B "​" */

    /* U+2010 "‐" */
    0x1, 0x11, 0x10, 0x1f, 0xff, 0xf3, 0x4, 0x44,
    0x40,

    /* U+2012 "‒" */
    0x3f, 0xff, 0xff, 0xff, 0xff, 0x70, 0x22, 0x22,
    0x22, 0x22, 0x21,

    /* U+2013 "–" */
    0xff, 0xff, 0xff, 0xff, 0x22, 0x22, 0x22, 0x22,

    /* U+2014 "—" */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,

    /* U+2015 "―" */
    0xf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf0, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
    0x22,

    /* U+2018 "‘" */
    0x6, 0xa0, 0xb6, 0xf, 0x63, 0xfd, 0x9, 0x50,

    /* U+2019 "’" */
    0x1e, 0x92, 0xfd, 0xa, 0x90, 0xe3, 0xa, 0x0,

    /* U+201A "‚" */
    0x9, 0x53, 0xfd, 0xb, 0xa0, 0xc5, 0xf, 0x0,

    /* U+201C "“" */
    0x6, 0xa0, 0x6a, 0xb, 0x60, 0xb7, 0x1f, 0x50,
    0xf6, 0x4f, 0xc3, 0xfd, 0x9, 0x50, 0x95,

    /* U+201D "”" */
    0x1e, 0x91, 0xea, 0x2f, 0xc2, 0xfd, 0xa, 0x80,
    0xa9, 0xe, 0x30, 0xd3, 0x1a, 0x0, 0xa0,

    /* U+201E "„" */
    0x9, 0x50, 0x85, 0x3f, 0xd2, 0xfd, 0xc, 0xa0,
    0xba, 0xd, 0x50, 0xc5, 0xf, 0x0, 0xf0,

    /* U+2020 "†" */
    0x0, 0x4, 0xf3, 0x0, 0x0, 0x0, 0x4f, 0x30,
    0x0, 0x0, 0x4, 0xf3, 0x0, 0x0, 0x11, 0x5f,
    0x51, 0x10, 0x8f, 0xff, 0xff, 0xff, 0x72, 0x44,
    0x8f, 0x74, 0x42, 0x0, 0x4, 0xf3, 0x0, 0x0,
    0x0, 0x4f, 0x30, 0x0, 0x0, 0x4, 0xf3, 0x0,
    0x0, 0x0, 0x4f, 0x30, 0x0, 0x0, 0x4, 0xf3,
    0x0, 0x0, 0x0, 0x4f, 0x30, 0x0, 0x0, 0x4,
    0xf3, 0x0, 0x0, 0x0, 0x4f, 0x30, 0x0, 0x0,
    0x4, 0xf3, 0x0, 0x0,

    /* U+2021 "‡" */
    0x0, 0x4, 0xf3, 0x0, 0x0, 0x0, 0x4f, 0x30,
    0x0, 0x0, 0x4, 0xf3, 0x0, 0x0, 0x11, 0x5f,
    0x51, 0x10, 0x8f, 0xff, 0xff, 0xff, 0x72, 0x44,
    0x8f, 0x74, 0x42, 0x0, 0x4, 0xf3, 0x0, 0x0,
    0x0, 0x4f, 0x30, 0x0, 0x0, 0x4, 0xf3, 0x0,
    0x0, 0x11, 0x5f, 0x51, 0x10, 0x8f, 0xff, 0xff,
    0xff, 0x72, 0x44, 0x8f, 0x74, 0x42, 0x0, 0x4,
    0xf3, 0x0, 0x0, 0x0, 0x4f, 0x30, 0x0, 0x0,
    0x4, 0xf3, 0x0, 0x0,

    /* U+2022 "•" */
    0x0, 0x8, 0xf8, 0xef, 0xe7, 0xe7,

    /* U+2026 "…" */
    0x3, 0x10, 0x3, 0x0, 0x13, 0x2, 0xfc, 0x7,
    0xf7, 0xc, 0xf2, 0x1e, 0x90, 0x4f, 0x50, 0x9e,
    0x10,

    /* U+2030 "‰" */
    0x3, 0xdf, 0x80, 0x0, 0x5, 0xd0, 0x0, 0x0,
    0x0, 0x0, 0xe4, 0xc, 0x50, 0x1, 0xe3, 0x0,
    0x0, 0x0, 0x0, 0x4c, 0x0, 0x5a, 0x0, 0xa9,
    0x0, 0x0, 0x0, 0x0, 0x6, 0xa0, 0x4, 0xc0,
    0x4e, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4c, 0x0,
    0x5a, 0xd, 0x50, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xe4, 0x1c, 0x58, 0xa0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x3, 0xde, 0x83, 0xe1, 0x3d, 0xea, 0x0,
    0x5d, 0xe8, 0x0, 0x0, 0x0, 0xd6, 0xe, 0x40,
    0xa8, 0x2e, 0x31, 0xc6, 0x0, 0x0, 0x7c, 0x3,
    0xc0, 0x3, 0xd6, 0xa0, 0x5, 0xb0, 0x0, 0x2e,
    0x20, 0x3c, 0x0, 0x3d, 0x6a, 0x0, 0x5b, 0x0,
    0xb, 0x70, 0x0, 0xe3, 0x9, 0x92, 0xe1, 0xb,
    0x70, 0x6, 0xd0, 0x0, 0x4, 0xde, 0xa0, 0x5,
    0xde, 0x90,

    /* U+2032 "′" */
    0xf5, 0xf5, 0xe4, 0xe4, 0x72,

    /* U+2033 "″" */
    0xf5, 0x1f, 0x3f, 0x50, 0xf3, 0xe4, 0xf, 0x3e,
    0x40, 0xf2, 0x72, 0x8, 0x10,

    /* U+2039 "‹" */
    0x0, 0x6, 0x20, 0xa, 0xc0, 0x5, 0xf2, 0x1,
    0xe6, 0x0, 0xb, 0xa0, 0x0, 0x1e, 0x60, 0x0,
    0x5f, 0x20,

    /* U+203A "›" */
    0x26, 0x0, 0x0, 0xc9, 0x0, 0x2, 0xf5, 0x0,
    0x7, 0xe1, 0x0, 0xbb, 0x0, 0x6e, 0x10, 0x2f,
    0x50, 0x0,

    /* U+2044 "⁄" */
    0x0, 0x0, 0x0, 0x0, 0xb8, 0x0, 0x0, 0x0,
    0x5, 0xd0, 0x0, 0x0, 0x0, 0x1e, 0x30, 0x0,
    0x0, 0x0, 0xa9, 0x0, 0x0, 0x0, 0x4, 0xe0,
    0x0, 0x0, 0x0, 0xd, 0x50, 0x0, 0x0, 0x0,
    0x8a, 0x0, 0x0, 0x0, 0x3, 0xe1, 0x0, 0x0,
    0x0, 0xc, 0x60, 0x0, 0x0, 0x0, 0x7c, 0x0,
    0x0, 0x0, 0x2, 0xe2, 0x0, 0x0, 0x0, 0xb,
    0x70, 0x0, 0x0, 0x0,

    /* U+2052 "⁒" */
    0x9d, 0x0, 0x7b, 0x8, 0xd0, 0xc, 0x60, 0x0,
    0x1, 0xf1, 0x0, 0x0, 0x7b, 0x0, 0x0, 0xc,
    0x60, 0x0, 0x1, 0xf1, 0x0, 0x0, 0x7b, 0x0,
    0x0, 0xc, 0x60, 0x0, 0x2, 0xf1, 0x0, 0x0,
    0x7b, 0x0, 0x0, 0xc, 0x50, 0x5e, 0x32, 0xf0,
    0x5, 0xf3,

    /* U+2070 "⁰" */
    0x3, 0xcf, 0xc2, 0x1, 0xe4, 0x6, 0xd0, 0x6b,
    0x0, 0xd, 0x48, 0x90, 0x0, 0xb6, 0x6b, 0x0,
    0xd, 0x41, 0xf4, 0x6, 0xd0, 0x4, 0xcf, 0xc2,
    0x0,

    /* U+2074 "⁴" */
    0x0, 0xc, 0x60, 0x0, 0x9, 0xa0, 0x0, 0x5,
    0xd0, 0x30, 0x2, 0xe2, 0xe, 0x20, 0x9f, 0xff,
    0xff, 0x60, 0x0, 0xf, 0x20, 0x0, 0x0, 0xf2,
    0x0,

    /* U+2075 "⁵" */
    0xa, 0xff, 0xf9, 0x0, 0xb4, 0x0, 0x0, 0xd,
    0x20, 0x0, 0x0, 0xee, 0xec, 0x40, 0x0, 0x0,
    0x5f, 0x3, 0x50, 0x5, 0xf0, 0x3b, 0xef, 0xc4,
    0x0,

    /* U+2076 "⁶" */
    0x1, 0xae, 0xfb, 0x0, 0xca, 0x10, 0x20, 0x4e,
    0x0, 0x0, 0x6, 0xc9, 0xdc, 0x60, 0x4f, 0x30,
    0x2e, 0x30, 0xe3, 0x1, 0xe3, 0x3, 0xcd, 0xd6,
    0x0,

    /* U+2077 "⁷" */
    0x7f, 0xff, 0xff, 0x57, 0x90, 0x4, 0xe0, 0x0,
    0x0, 0xc7, 0x0, 0x0, 0x4f, 0x10, 0x0, 0xb,
    0x80, 0x0, 0x3, 0xf1, 0x0, 0x0, 0xb8, 0x0,
    0x0,

    /* U+2078 "⁸" */
    0x7, 0xdd, 0xd5, 0x3, 0xe1, 0x2, 0xf1, 0x3e,
    0x20, 0x3f, 0x10, 0xaf, 0xef, 0x90, 0x6c, 0x10,
    0x2e, 0x47, 0xc0, 0x1, 0xd5, 0x9, 0xdd, 0xd8,
    0x0,

    /* U+2079 "⁹" */
    0x8, 0xdd, 0xb1, 0x6, 0xc0, 0x5, 0xc0, 0x6c,
    0x10, 0x6f, 0x20, 0x8d, 0xd8, 0xe3, 0x0, 0x0,
    0x1f, 0x10, 0x20, 0x2b, 0xa0, 0xd, 0xfe, 0x80,
    0x0,

    /* U+2080 "₀" */
    0x3, 0xcf, 0xc2, 0x1, 0xf4, 0x6, 0xd0, 0x6b,
    0x0, 0xd, 0x48, 0x90, 0x0, 0xb6, 0x6b, 0x0,
    0xd, 0x41, 0xf4, 0x6, 0xd0, 0x3, 0xcf, 0xc2,
    0x0,

    /* U+2081 "₁" */
    0x8f, 0xf4, 0x0, 0xd, 0x40, 0x0, 0xd4, 0x0,
    0xd, 0x40, 0x0, 0xd4, 0x0, 0xd, 0x40, 0xae,
    0xff, 0xd0,

    /* U+2082 "₂" */
    0x1a, 0xef, 0xb1, 0x2, 0x71, 0xa, 0xa0, 0x0,
    0x0, 0x8a, 0x0, 0x0, 0x4e, 0x20, 0x0, 0x5e,
    0x30, 0x0, 0x7e, 0x20, 0x0, 0x3f, 0xfe, 0xee,
    0x0,

    /* U+2083 "₃" */
    0x5f, 0xff, 0xfb, 0x0, 0x0, 0x3e, 0x20, 0x0,
    0x2e, 0x40, 0x0, 0x5, 0xce, 0x70, 0x0, 0x0,
    0x3f, 0x3, 0x61, 0x6, 0xe0, 0x3b, 0xef, 0xc3,
    0x0,

    /* U+2084 "₄" */
    0x0, 0xc, 0x60, 0x0, 0x9, 0xa0, 0x0, 0x5,
    0xd0, 0x30, 0x2, 0xe2, 0xe, 0x20, 0x9f, 0xee,
    0xfe, 0x60, 0x0, 0xf, 0x20, 0x0, 0x0, 0xf2,
    0x0,

    /* U+2085 "₅" */
    0xa, 0xff, 0xf9, 0x0, 0xb4, 0x0, 0x0, 0xd,
    0x20, 0x0, 0x0, 0xee, 0xec, 0x40, 0x0, 0x0,
    0x5f, 0x3, 0x50, 0x5, 0xf0, 0x3b, 0xef, 0xc4,
    0x0,

    /* U+2086 "₆" */
    0x1, 0x9e, 0xfb, 0x0, 0xca, 0x10, 0x20, 0x4e,
    0x0, 0x0, 0x6, 0xc9, 0xdc, 0x60, 0x4f, 0x30,
    0x2e, 0x30, 0xe3, 0x1, 0xe3, 0x3, 0xcd, 0xd6,
    0x0,

    /* U+2087 "₇" */
    0x7f, 0xff, 0xff, 0x57, 0x90, 0x4, 0xe0, 0x0,
    0x0, 0xc7, 0x0, 0x0, 0x4f, 0x10, 0x0, 0xb,
    0x80, 0x0, 0x3, 0xf1, 0x0, 0x0, 0xb8, 0x0,
    0x0,

    /* U+2088 "₈" */
    0x7, 0xdd, 0xd5, 0x3, 0xe1, 0x2, 0xf1, 0x3e,
    0x20, 0x3f, 0x10, 0xaf, 0xef, 0x90, 0x6c, 0x10,
    0x2e, 0x47, 0xc0, 0x1, 0xd5, 0x9, 0xdd, 0xd8,
    0x0,

    /* U+2089 "₉" */
    0x8, 0xdd, 0xb1, 0x6, 0xc0, 0x6, 0xc0, 0x5c,
    0x10, 0x6f, 0x20, 0x7d, 0xd8, 0xe3, 0x0, 0x0,
    0x1f, 0x10, 0x20, 0x2c, 0xa0, 0xd, 0xfe, 0x80,
    0x0,

    /* U+20A1 "₡" */
    0x0, 0x0, 0x0, 0x87, 0x1d, 0x0, 0x0, 0x0,
    0xc, 0x35, 0xa0, 0x0, 0x3, 0xbf, 0xfe, 0xe8,
    0x0, 0x6, 0xff, 0xcd, 0x9f, 0xf9, 0x3, 0xfc,
    0x17, 0x71, 0xe7, 0x40, 0xcf, 0x20, 0xb4, 0x4a,
    0x0, 0x1f, 0x90, 0xe, 0x8, 0x60, 0x3, 0xf6,
    0x3, 0xc0, 0xc2, 0x0, 0x3f, 0x60, 0x68, 0xe,
    0x0, 0x0, 0xfa, 0xa, 0x44, 0xb0, 0x0, 0xb,
    0xf2, 0xe0, 0x87, 0x0, 0x0, 0x3f, 0xec, 0xc,
    0x30, 0x85, 0x0, 0x5f, 0xfb, 0xf9, 0xdf, 0x80,
    0x0, 0xab, 0xef, 0xeb, 0x40, 0x0, 0xe, 0x17,
    0x70, 0x0, 0x0, 0x1, 0xd0, 0xb4, 0x0, 0x0,

    /* U+20A3 "₣" */
    0x0, 0xef, 0xff, 0xff, 0xff, 0x0, 0xe, 0xd7,
    0x77, 0x77, 0x70, 0x0, 0xeb, 0x0, 0x0, 0x0,
    0x0, 0xe, 0xb0, 0x0, 0x0, 0x0, 0x0, 0xeb,
    0x0, 0x0, 0x0, 0x0, 0xe, 0xc2, 0x22, 0x22,
    0x0, 0x0, 0xef, 0xff, 0xff, 0xf5, 0x0, 0xe,
    0xd5, 0x55, 0x55, 0x10, 0x0, 0xeb, 0x0, 0x0,
    0x0, 0x7, 0xff, 0xff, 0xff, 0x40, 0x0, 0x0,
    0xeb, 0x0, 0x0, 0x0, 0x0, 0xe, 0xb0, 0x0,
    0x0, 0x0,

    /* U+20A4 "₤" */
    0x0, 0x0, 0x8d, 0xfe, 0xc6, 0x0, 0x0, 0xdf,
    0xb8, 0x9b, 0xd0, 0x0, 0x7f, 0x50, 0x0, 0x0,
    0x0, 0xb, 0xe0, 0x0, 0x0, 0x0, 0x7f, 0xff,
    0xff, 0xff, 0x10, 0x0, 0xc, 0xd0, 0x0, 0x0,
    0x0, 0x0, 0xcd, 0x0, 0x0, 0x0, 0x7, 0xff,
    0xff, 0xff, 0xf1, 0x0, 0x0, 0xcd, 0x0, 0x0,
    0x0, 0x0, 0xc, 0xd0, 0x0, 0x0, 0x0, 0x37,
    0xee, 0x77, 0x77, 0x76, 0x8, 0xff, 0xff, 0xff,
    0xff, 0xd0,

    /* U+20A6 "₦" */
    0x0, 0xcd, 0x10, 0x0, 0x0, 0xcd, 0x0, 0x0,
    0xcf, 0xb0, 0x0, 0x0, 0xcd, 0x0, 0x0, 0xcf,
    0xf8, 0x0, 0x0, 0xcd, 0x0, 0x0, 0xcd, 0xaf,
    0x50, 0x0, 0xcd, 0x0, 0x7f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf8, 0x0, 0xcd, 0x3, 0xfc, 0x0,
    0xcd, 0x0, 0x0, 0xcd, 0x0, 0xbf, 0x40, 0xcd,
    0x0, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,
    0x0, 0xcd, 0x0, 0x4, 0xfb, 0xcd, 0x0, 0x0,
    0xcd, 0x0, 0x0, 0x7f, 0xfd, 0x0, 0x0, 0xcd,
    0x0, 0x0, 0xa, 0xfd, 0x0, 0x0, 0xcd, 0x0,
    0x0, 0x0, 0xdd, 0x0,

    /* U+20A7 "₧" */
    0x5f, 0xff, 0xff, 0xd7, 0x0, 0x0, 0x11, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x5, 0xf9, 0x77, 0x8b,
    0xfc, 0x0, 0xb, 0xd0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x5f, 0x40, 0x0, 0x7, 0xf6, 0x0, 0xbd,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x5, 0xf4, 0x0,
    0x0, 0xf, 0xa2, 0xff, 0xff, 0xf4, 0x1, 0x9e,
    0xfe, 0xb3, 0x5f, 0x40, 0x0, 0x0, 0xfa, 0x5,
    0xce, 0x55, 0x10, 0xce, 0x75, 0x7d, 0x25, 0xf4,
    0x0, 0x0, 0x4f, 0x70, 0xb, 0xd0, 0x0, 0x1f,
    0x70, 0x0, 0x0, 0x5f, 0x52, 0x23, 0x6e, 0xe1,
    0x0, 0xbd, 0x0, 0x0, 0xfe, 0x62, 0x0, 0x5,
    0xff, 0xff, 0xff, 0xc2, 0x0, 0xb, 0xd0, 0x0,
    0x4, 0xdf, 0xfe, 0x90, 0x5f, 0x85, 0x54, 0x20,
    0x0, 0x0, 0xbd, 0x0, 0x0, 0x0, 0x25, 0xaf,
    0x95, 0xf4, 0x0, 0x0, 0x0, 0x0, 0xa, 0xd0,
    0x0, 0x1, 0x0, 0x0, 0xcc, 0x5f, 0x40, 0x0,
    0x0, 0x0, 0x0, 0x6f, 0x75, 0x51, 0xfa, 0x54,
    0x8f, 0x75, 0xf4, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x9e, 0xf8, 0x8, 0xcf, 0xfd, 0x60,

    /* U+20A9 "₩" */
    0x1f, 0x80, 0x0, 0x0, 0x5f, 0x80, 0x0, 0x0,
    0x6f, 0x30, 0xce, 0x0, 0x0, 0xb, 0xfd, 0x0,
    0x0, 0xb, 0xd0, 0x6, 0xf4, 0x0, 0x1, 0xfc,
    0xf3, 0x0, 0x1, 0xf7, 0x0, 0x1f, 0x90, 0x0,
    0x7f, 0x2f, 0x90, 0x0, 0x7f, 0x20, 0x7f, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x90,
    0x6, 0xf3, 0x1, 0xf7, 0x5, 0xf3, 0x1, 0xf8,
    0x0, 0x0, 0x3f, 0x60, 0x4f, 0x30, 0x2f, 0x60,
    0x4f, 0x40, 0x7, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf9, 0x0, 0x9, 0xf1, 0xe9,
    0x0, 0x7, 0xf1, 0xeb, 0x0, 0x0, 0x0, 0x3f,
    0xbf, 0x30, 0x0, 0x2f, 0xaf, 0x50, 0x0, 0x0,
    0x0, 0xef, 0xd0, 0x0, 0x0, 0xcf, 0xf0, 0x0,
    0x0, 0x0, 0x8, 0xf8, 0x0, 0x0, 0x6, 0xfa,
    0x0, 0x0,

    /* U+20AB "₫" */
    0x0, 0x0, 0x0, 0x1, 0xf7, 0x0, 0x0, 0x6,
    0xff, 0xff, 0xfd, 0x0, 0x0, 0x0, 0x1, 0xf7,
    0x0, 0x3, 0xbf, 0xea, 0x2f, 0x70, 0x4, 0xfd,
    0x87, 0xce, 0xf7, 0x0, 0xed, 0x0, 0x0, 0xbf,
    0x70, 0x3f, 0x50, 0x0, 0x3, 0xf7, 0x4, 0xf3,
    0x0, 0x0, 0x1f, 0x70, 0x3f, 0x60, 0x0, 0x3,
    0xf7, 0x0, 0xed, 0x0, 0x0, 0xbf, 0x70, 0x4,
    0xfd, 0x87, 0xcd, 0xf7, 0x0, 0x3, 0xbf, 0xea,
    0x1f, 0x70, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xef, 0xff, 0xff, 0xff, 0x70,

    /* U+20AC "€" */
    0x0, 0x0, 0x17, 0xcf, 0xfd, 0x70, 0x0, 0x0,
    0x2e, 0xfc, 0x88, 0xbf, 0xd1, 0x0, 0xe, 0xe4,
    0x0, 0x0, 0x27, 0x0, 0x7, 0xf5, 0x0, 0x0,
    0x0, 0x0, 0x7f, 0xff, 0xff, 0xff, 0xf1, 0x0,
    0x0, 0xe, 0xb0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xeb, 0x0, 0x0, 0x0, 0x0, 0x7, 0xff, 0xff,
    0xff, 0xff, 0x10, 0x0, 0x0, 0x7f, 0x50, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xee, 0x40, 0x0, 0x2,
    0x70, 0x0, 0x2, 0xef, 0xc8, 0x8b, 0xfd, 0x10,
    0x0, 0x1, 0x7c, 0xff, 0xd7, 0x0,

    /* U+20AD "₭" */
    0x0, 0xeb, 0x0, 0x0, 0xbf, 0x30, 0xe, 0xb0,
    0x0, 0x7f, 0x60, 0x0, 0xeb, 0x0, 0x3f, 0xa0,
    0x0, 0xe, 0xb0, 0x1e, 0xe1, 0x0, 0x0, 0xeb,
    0xb, 0xf3, 0x0, 0x0, 0xe, 0xb7, 0xf7, 0x0,
    0x0, 0x7f, 0xff, 0xff, 0xff, 0xf5, 0x1, 0x2e,
    0xb8, 0xf8, 0x22, 0x0, 0x0, 0xeb, 0x9, 0xf4,
    0x0, 0x0, 0xe, 0xb0, 0xa, 0xf4, 0x0, 0x0,
    0xeb, 0x0, 0xb, 0xf3, 0x0, 0xe, 0xb0, 0x0,
    0xc, 0xe2,

    /* U+20AE "₮" */
    0x3f, 0xff, 0xff, 0xff, 0xff, 0x11, 0x77, 0x7a,
    0xf9, 0x77, 0x70, 0x0, 0x0, 0x5f, 0x40, 0x0,
    0x0, 0x0, 0x5, 0xf4, 0x3a, 0x0, 0x0, 0x0,
    0x5f, 0xcd, 0x40, 0x0, 0x0, 0x1a, 0xf7, 0x3,
    0x0, 0x0, 0x8e, 0xbf, 0x7c, 0xa0, 0x0, 0x7,
    0x6, 0xfc, 0x40, 0x0, 0x0, 0x19, 0xff, 0x40,
    0x0, 0x0, 0xd, 0x65, 0xf4, 0x0, 0x0, 0x0,
    0x0, 0x5f, 0x40, 0x0, 0x0, 0x0, 0x5, 0xf4,
    0x0, 0x0,

    /* U+20B1 "₱" */
    0x0, 0xcf, 0xff, 0xfe, 0xa2, 0x0, 0x0, 0x0,
    0xce, 0x77, 0x79, 0xff, 0x20, 0x0, 0x0, 0xcd,
    0x0, 0x0, 0x3f, 0xc0, 0x0, 0x7f, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf0, 0x0, 0xcd, 0x0, 0x0,
    0x5, 0xf3, 0x0, 0x7f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf0, 0x0, 0xcd, 0x22, 0x24, 0x9f, 0xa0,
    0x0, 0x0, 0xcf, 0xff, 0xff, 0xf9, 0x0, 0x0,
    0x0, 0xcd, 0x55, 0x53, 0x0, 0x0, 0x0, 0x0,
    0xcd, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xcd,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xcd, 0x0,
    0x0, 0x0, 0x0, 0x0,

    /* U+20B2 "₲" */
    0x0, 0x0, 0x1, 0xf0, 0x0, 0x0, 0x0, 0x0,
    0x1, 0xf0, 0x0, 0x0, 0x0, 0x2, 0x9d, 0xff,
    0xc6, 0x0, 0x0, 0x5f, 0xfb, 0xf8, 0xcf, 0xb0,
    0x3, 0xfd, 0x21, 0xf0, 0x5, 0x60, 0xb, 0xf1,
    0x1, 0xf0, 0x0, 0x0, 0xf, 0x90, 0x1, 0xf0,
    0x0, 0x0, 0x3f, 0x60, 0x1, 0xf0, 0x0, 0x0,
    0x3f, 0x60, 0x1, 0xf0, 0x9, 0xf0, 0x1f, 0xa0,
    0x1, 0xf0, 0x9, 0xf0, 0xb, 0xf2, 0x1, 0xf0,
    0x9, 0xf0, 0x3, 0xfd, 0x21, 0xf0, 0x9, 0xf0,
    0x0, 0x5f, 0xfb, 0xf8, 0xcf, 0xc0, 0x0, 0x2,
    0x9d, 0xff, 0xc7, 0x0, 0x0, 0x0, 0x1, 0xf0,
    0x0, 0x0, 0x0, 0x0, 0x1, 0xf0, 0x0, 0x0,

    /* U+20B4 "₴" */
    0x0, 0x5b, 0xef, 0xea, 0x20, 0x0, 0xe, 0xb8,
    0x78, 0xef, 0x20, 0x0, 0x0, 0x0, 0x1, 0xf9,
    0x0, 0x0, 0x0, 0x0, 0x1f, 0xa0, 0x9f, 0xff,
    0xff, 0xff, 0xff, 0xa0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9, 0xff,
    0xff, 0xff, 0xff, 0xfa, 0x9, 0xf3, 0x0, 0x0,
    0x0, 0x0, 0x9f, 0x10, 0x0, 0x0, 0x30, 0x2,
    0xfe, 0x97, 0x8b, 0xfb, 0x0, 0x2, 0xae, 0xfe,
    0xb6, 0x0,

    /* U+20B5 "₵" */
    0x0, 0x0, 0x1, 0xf0, 0x0, 0x0, 0x0, 0x0,
    0x1f, 0x0, 0x0, 0x0, 0x2, 0x9e, 0xff, 0xc5,
    0x0, 0x5, 0xff, 0xbf, 0x8d, 0xf9, 0x3, 0xfd,
    0x11, 0xf0, 0x7, 0x40, 0xbf, 0x20, 0x1f, 0x0,
    0x0, 0x1f, 0x90, 0x1, 0xf0, 0x0, 0x3, 0xf6,
    0x0, 0x1f, 0x0, 0x0, 0x3f, 0x60, 0x1, 0xf0,
    0x0, 0x0, 0xfa, 0x0, 0x1f, 0x0, 0x0, 0xb,
    0xf2, 0x1, 0xf0, 0x0, 0x0, 0x3f, 0xd2, 0x1f,
    0x0, 0x75, 0x0, 0x5f, 0xfb, 0xf8, 0xdf, 0x90,
    0x0, 0x29, 0xef, 0xfc, 0x50, 0x0, 0x0, 0x1,
    0xf0, 0x0, 0x0, 0x0, 0x0, 0x1f, 0x0, 0x0,

    /* U+20B8 "₸" */
    0xcf, 0xff, 0xff, 0xff, 0xf7, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xcf, 0xff, 0xff, 0xff, 0xf7, 0x0,
    0x0, 0xfa, 0x0, 0x0, 0x0, 0x0, 0xfa, 0x0,
    0x0, 0x0, 0x0, 0xfa, 0x0, 0x0, 0x0, 0x0,
    0xfa, 0x0, 0x0, 0x0, 0x0, 0xfa, 0x0, 0x0,
    0x0, 0x0, 0xfa, 0x0, 0x0, 0x0, 0x0, 0xfa,
    0x0, 0x0, 0x0, 0x0, 0xfa, 0x0, 0x0, 0x0,
    0x0, 0xfa, 0x0, 0x0,

    /* U+20B9 "₹" */
    0x13, 0x33, 0x33, 0x33, 0x33, 0x26, 0xbb, 0xbb,
    0xef, 0xfb, 0xb8, 0x0, 0x0, 0x0, 0x5f, 0x80,
    0x7, 0xee, 0xee, 0xee, 0xff, 0xea, 0x0, 0x0,
    0x0, 0x8, 0xf1, 0x0, 0x0, 0x0, 0x0, 0xde,
    0x0, 0x1, 0x33, 0x45, 0xcf, 0x60, 0x0, 0x5f,
    0xff, 0xfe, 0x60, 0x0, 0x0, 0x22, 0x2b, 0xe1,
    0x0, 0x0, 0x0, 0x0, 0x1f, 0xa0, 0x0, 0x0,
    0x0, 0x0, 0x6f, 0x50, 0x0, 0x0, 0x0, 0x0,
    0xce, 0x10,

    /* U+20BA "₺" */
    0x0, 0xcd, 0x0, 0x1, 0x0, 0x0, 0xc, 0xd0,
    0x6, 0xd0, 0x0, 0x0, 0xcd, 0x4d, 0x91, 0x0,
    0x0, 0xc, 0xfb, 0x30, 0x81, 0x0, 0x19, 0xfd,
    0x6, 0xd7, 0x0, 0x7, 0x6c, 0xed, 0x91, 0x0,
    0x0, 0x2, 0xee, 0x30, 0x0, 0xe, 0xa5, 0xde,
    0xd0, 0x0, 0x1, 0xf8, 0x20, 0xcd, 0x0, 0x0,
    0x7f, 0x40, 0xc, 0xd0, 0x0, 0x4f, 0xc0, 0x0,
    0xce, 0x78, 0xcf, 0xc1, 0x0, 0xc, 0xff, 0xeb,
    0x60, 0x0,

    /* U+20BC "₼" */
    0x0, 0x0, 0x2, 0xa0, 0x0, 0x0, 0x0, 0x0,
    0x2, 0xd0, 0x0, 0x0, 0x0, 0x5, 0xcf, 0xfe,
    0xa2, 0x0, 0x0, 0x8f, 0xc9, 0xe9, 0xee, 0x30,
    0x4, 0xf8, 0x2, 0xd0, 0x1c, 0xd0, 0xc, 0xc0,
    0x2, 0xd0, 0x2, 0xf6, 0x1f, 0x70, 0x2, 0xd0,
    0x0, 0xcb, 0x3f, 0x40, 0x2, 0xd0, 0x0, 0x9d,
    0x4f, 0x20, 0x2, 0xd0, 0x0, 0x8f, 0x5f, 0x20,
    0x2, 0xd0, 0x0, 0x8f, 0x5f, 0x20, 0x2, 0xd0,
    0x0, 0x8f, 0x5f, 0x20, 0x2, 0xd0, 0x0, 0x8f,
    0x5f, 0x20, 0x0, 0x0, 0x0, 0x8f, 0x5f, 0x20,
    0x0, 0x0, 0x0, 0x8f,

    /* U+20BD "₽" */
    0x0, 0xef, 0xff, 0xfe, 0xb3, 0x0, 0x0, 0xed,
    0x77, 0x79, 0xef, 0x50, 0x0, 0xeb, 0x0, 0x0,
    0x1e, 0xe0, 0x0, 0xeb, 0x0, 0x0, 0x9, 0xf1,
    0x0, 0xeb, 0x0, 0x0, 0x8, 0xf2, 0x0, 0xeb,
    0x0, 0x0, 0xc, 0xf0, 0x0, 0xec, 0x11, 0x13,
    0xaf, 0x80, 0x0, 0xef, 0xff, 0xff, 0xf7, 0x0,
    0x0, 0xec, 0x44, 0x43, 0x0, 0x0, 0x7f, 0xff,
    0xff, 0xf4, 0x0, 0x0, 0x0, 0xeb, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xeb, 0x0, 0x0, 0x0, 0x0,

    /* U+2113 "ℓ" */
    0x0, 0x0, 0x1, 0x0, 0x0, 0x4d, 0xd7, 0x0,
    0xe, 0x30, 0xd0, 0x4, 0xc0, 0x1d, 0x0, 0x79,
    0x7, 0x70, 0xa, 0x62, 0xc0, 0x0, 0xd5, 0xc2,
    0x0, 0xf, 0xd3, 0x0, 0x8, 0xe1, 0x0, 0x4,
    0xac, 0x0, 0x3, 0x2, 0xf2, 0x2a, 0x80, 0xa,
    0xfe, 0x70, 0x0, 0x0, 0x0, 0x0,

    /* U+2116 "№" */
    0x12, 0x0, 0x0, 0x0, 0x13, 0x0, 0x2, 0x41,
    0x0, 0x8f, 0x50, 0x0, 0x0, 0x8f, 0x10, 0x8e,
    0xae, 0x70, 0x8f, 0xf3, 0x0, 0x0, 0x8f, 0x12,
    0xe1, 0x1, 0xf1, 0x8f, 0xfe, 0x10, 0x0, 0x8f,
    0x14, 0xd0, 0x0, 0xe3, 0x8f, 0x5f, 0xb0, 0x0,
    0x8f, 0x10, 0xe6, 0x17, 0xe0, 0x8f, 0x16, 0xf8,
    0x0, 0x8f, 0x10, 0x2b, 0xdb, 0x20, 0x8f, 0x10,
    0xaf, 0x50, 0x8f, 0x10, 0x0, 0x0, 0x0, 0x8f,
    0x10, 0xc, 0xf3, 0x8f, 0x10, 0xdd, 0xdd, 0xc0,
    0x8f, 0x10, 0x1, 0xee, 0x9f, 0x10, 0x22, 0x22,
    0x20, 0x8f, 0x10, 0x0, 0x4f, 0xff, 0x10, 0x0,
    0x0, 0x0, 0x8f, 0x10, 0x0, 0x6, 0xff, 0x10,
    0x0, 0x0, 0x0, 0x8f, 0x10, 0x0, 0x0, 0xaf,
    0x10, 0x0, 0x0, 0x0,

    /* U+2122 "™" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xd,
    0xef, 0xfe, 0xe0, 0xf6, 0x0, 0x0, 0x6e, 0x0,
    0x8a, 0x0, 0xf, 0xe1, 0x0, 0x1e, 0xe0, 0x8,
    0xa0, 0x0, 0xfa, 0xb0, 0xa, 0xae, 0x0, 0x8a,
    0x0, 0xf, 0x3c, 0x55, 0xc3, 0xe0, 0x8, 0xa0,
    0x0, 0xf2, 0x2e, 0xe2, 0x2e, 0x0, 0x8a, 0x0,
    0xf, 0x20, 0x76, 0x2, 0xe0, 0x4, 0x50, 0x0,
    0x91, 0x0, 0x0, 0x18,

    /* U+2126 "Ω" */
    0x0, 0x0, 0x1, 0x44, 0x20, 0x0, 0x0, 0x0,
    0x0, 0x4c, 0xff, 0xff, 0xd5, 0x0, 0x0, 0x0,
    0x5f, 0xd6, 0x22, 0x5c, 0xf7, 0x0, 0x0, 0x2f,
    0xd0, 0x0, 0x0, 0xb, 0xf3, 0x0, 0x8, 0xf3,
    0x0, 0x0, 0x0, 0x1f, 0xa0, 0x0, 0xbe, 0x0,
    0x0, 0x0, 0x0, 0xbe, 0x0, 0xc, 0xd0, 0x0,
    0x0, 0x0, 0xa, 0xe0, 0x0, 0xaf, 0x0, 0x0,
    0x0, 0x0, 0xcd, 0x0, 0x5, 0xf5, 0x0, 0x0,
    0x0, 0x3f, 0x70, 0x0, 0xc, 0xe2, 0x0, 0x0,
    0x1d, 0xe0, 0x0, 0x56, 0x7f, 0xe4, 0x0, 0x3e,
    0xf8, 0x66, 0xe, 0xff, 0xff, 0x90, 0x7, 0xff,
    0xff, 0xf1,

    /* U+212A "K" */
    0x13, 0x0, 0x0, 0x0, 0x32, 0x8, 0xf1, 0x0,
    0x0, 0x8f, 0x50, 0x8f, 0x10, 0x0, 0x7f, 0x60,
    0x8, 0xf1, 0x0, 0x7f, 0x60, 0x0, 0x8f, 0x10,
    0x6f, 0x70, 0x0, 0x8, 0xf1, 0x6f, 0x80, 0x0,
    0x0, 0x8f, 0x7f, 0xfb, 0x0, 0x0, 0x8, 0xff,
    0xa7, 0xf9, 0x0, 0x0, 0x8f, 0xa0, 0x9, 0xf6,
    0x0, 0x8, 0xf1, 0x0, 0xb, 0xf3, 0x0, 0x8f,
    0x10, 0x0, 0xd, 0xe1, 0x8, 0xf1, 0x0, 0x0,
    0x1e, 0xd0,

    /* U+212B "Å" */
    0x0, 0x0, 0x2, 0x98, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xb1, 0x39, 0x0, 0x0, 0x0, 0x0, 0xb,
    0x2, 0x90, 0x0, 0x0, 0x0, 0x0, 0x2a, 0x91,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x32, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x4f, 0xf1, 0x0, 0x0, 0x0,
    0x0, 0xb, 0xef, 0x80, 0x0, 0x0, 0x0, 0x2,
    0xf6, 0xae, 0x0, 0x0, 0x0, 0x0, 0x9e, 0x2,
    0xf6, 0x0, 0x0, 0x0, 0x1f, 0x80, 0xb, 0xd0,
    0x0, 0x0, 0x8, 0xf1, 0x0, 0x4f, 0x50, 0x0,
    0x0, 0xea, 0x11, 0x11, 0xdc, 0x0, 0x0, 0x6f,
    0xff, 0xff, 0xff, 0xf3, 0x0, 0xd, 0xb3, 0x33,
    0x33, 0x3e, 0xb0, 0x5, 0xf4, 0x0, 0x0, 0x0,
    0x8f, 0x20, 0xcd, 0x0, 0x0, 0x0, 0x1, 0xf9,

    /* U+212E "℮" */
    0x0, 0x0, 0x2, 0x44, 0x20, 0x0, 0x0, 0x0,
    0x5, 0x84, 0x0, 0x37, 0x50, 0x0, 0x0, 0x87,
    0x0, 0x0, 0x0, 0x59, 0x0, 0x5, 0xf1, 0x0,
    0x0, 0x0, 0xf, 0x60, 0xd, 0xf1, 0x0, 0x0,
    0x0, 0xf, 0xe0, 0x2f, 0xf1, 0x0, 0x0, 0x0,
    0xf, 0xf3, 0x3f, 0xf5, 0x55, 0x55, 0x55, 0x58,
    0x82, 0x1f, 0xf1, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xb, 0xf1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2,
    0xf1, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x39,
    0x0, 0x0, 0x0, 0x94, 0x0, 0x0, 0x1, 0x65,
    0x55, 0x66, 0x10, 0x0,

    /* U+2153 "⅓" */
    0x9f, 0xf4, 0x0, 0x0, 0x0, 0xd5, 0x0, 0x0,
    0xd, 0x40, 0x0, 0x0, 0x7b, 0x0, 0x0, 0x0,
    0xd4, 0x0, 0x0, 0x2e, 0x20, 0x0, 0x0, 0xd,
    0x40, 0x0, 0xc, 0x70, 0x0, 0x0, 0x0, 0xd4,
    0x0, 0x6, 0xc0, 0x0, 0x0, 0x0, 0xd, 0x40,
    0x1, 0xe3, 0xbf, 0xff, 0xf6, 0xbf, 0xff, 0xe0,
    0xa8, 0x0, 0x0, 0x8b, 0x0, 0x0, 0x0, 0x4d,
    0x0, 0x0, 0x7d, 0x10, 0x0, 0x0, 0xe, 0x40,
    0x0, 0x8, 0xce, 0x30, 0x0, 0x9, 0xa0, 0x0,
    0x0, 0x0, 0x7a, 0x0, 0x3, 0xe1, 0x0, 0x6,
    0x30, 0xa, 0x90, 0x0, 0xd5, 0x0, 0x0, 0x7d,
    0xee, 0xa1,

    /* U+2154 "⅔" */
    0x1a, 0xef, 0xb1, 0x0, 0x0, 0xd, 0x50, 0x0,
    0x38, 0x11, 0xaa, 0x0, 0x0, 0x7b, 0x0, 0x0,
    0x0, 0x0, 0x8a, 0x0, 0x2, 0xe2, 0x0, 0x0,
    0x0, 0x4, 0xe2, 0x0, 0xc, 0x70, 0x0, 0x0,
    0x0, 0x6e, 0x20, 0x0, 0x6c, 0x0, 0x0, 0x0,
    0x7, 0xd2, 0x0, 0x1, 0xe3, 0xbf, 0xff, 0xf6,
    0x3f, 0xff, 0xff, 0xa, 0x80, 0x0, 0x8, 0xb0,
    0x0, 0x0, 0x0, 0x4d, 0x0, 0x0, 0x7d, 0x10,
    0x0, 0x0, 0x0, 0xe4, 0x0, 0x0, 0x8c, 0xe3,
    0x0, 0x0, 0x9, 0xa0, 0x0, 0x0, 0x0, 0x7a,
    0x0, 0x0, 0x3e, 0x10, 0x0, 0x63, 0x0, 0xa9,
    0x0, 0x0, 0xd5, 0x0, 0x0, 0x7d, 0xee, 0xa1,

    /* U+215B "⅛" */
    0x9f, 0xf4, 0x0, 0x0, 0x0, 0xd5, 0x0, 0x0,
    0x0, 0xd4, 0x0, 0x0, 0x7, 0xb0, 0x0, 0x0,
    0x0, 0xd4, 0x0, 0x0, 0x2e, 0x20, 0x0, 0x0,
    0x0, 0xd4, 0x0, 0x0, 0xc7, 0x0, 0x0, 0x0,
    0x0, 0xd4, 0x0, 0x6, 0xc0, 0x0, 0x0, 0x0,
    0x0, 0xd4, 0x0, 0x1e, 0x30, 0x9d, 0xda, 0x10,
    0xbf, 0xff, 0xe0, 0xa8, 0x8, 0xa0, 0x8, 0xb0,
    0x0, 0x0, 0x4, 0xd0, 0x8, 0xa0, 0x8, 0xb0,
    0x0, 0x0, 0xe, 0x40, 0x2, 0xff, 0xff, 0x30,
    0x0, 0x0, 0x9a, 0x0, 0xc, 0x80, 0x6, 0xe0,
    0x0, 0x3, 0xe1, 0x0, 0xc, 0x60, 0x4, 0xf0,
    0x0, 0xd, 0x50, 0x0, 0x2, 0xbd, 0xdc, 0x40,

    /* U+215C "⅜" */
    0x5f, 0xff, 0xfb, 0x0, 0x0, 0xd, 0x50, 0x0,
    0x0, 0x0, 0x2e, 0x30, 0x0, 0x7, 0xb0, 0x0,
    0x0, 0x0, 0x1d, 0x50, 0x0, 0x2, 0xe2, 0x0,
    0x0, 0x0, 0x7, 0xfc, 0x40, 0x0, 0xc7, 0x0,
    0x0, 0x0, 0x0, 0x1, 0x6f, 0x0, 0x6c, 0x0,
    0x0, 0x0, 0x1, 0x20, 0x4, 0xf0, 0x1e, 0x30,
    0x9d, 0xda, 0x10, 0x3c, 0xfe, 0xe4, 0xa, 0x80,
    0x8a, 0x0, 0x8b, 0x0, 0x0, 0x10, 0x4, 0xd0,
    0x8, 0xa0, 0x8, 0xb0, 0x0, 0x0, 0x0, 0xe4,
    0x0, 0x2f, 0xff, 0xf3, 0x0, 0x0, 0x0, 0x9a,
    0x0, 0xc, 0x80, 0x6, 0xe0, 0x0, 0x0, 0x3e,
    0x10, 0x0, 0xc6, 0x0, 0x4f, 0x0, 0x0, 0xd,
    0x50, 0x0, 0x2, 0xbd, 0xdc, 0x40,

    /* U+215D "⅝" */
    0xa, 0xff, 0xf9, 0x0, 0x0, 0xd, 0x50, 0x0,
    0x0, 0xb4, 0x0, 0x0, 0x0, 0x7, 0xb0, 0x0,
    0x0, 0xd, 0x20, 0x0, 0x0, 0x2, 0xe2, 0x0,
    0x0, 0x0, 0xef, 0xfd, 0x50, 0x0, 0xc7, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x5f, 0x0, 0x6c, 0x0,
    0x0, 0x0, 0x1, 0x20, 0x4, 0xf0, 0x1e, 0x30,
    0x9d, 0xda, 0x10, 0x3c, 0xff, 0xe5, 0xa, 0x80,
    0x8a, 0x0, 0x8b, 0x0, 0x0, 0x10, 0x4, 0xd0,
    0x8, 0xa0, 0x8, 0xb0, 0x0, 0x0, 0x0, 0xe4,
    0x0, 0x2f, 0xff, 0xf3, 0x0, 0x0, 0x0, 0x9a,
    0x0, 0xc, 0x80, 0x6, 0xe0, 0x0, 0x0, 0x3e,
    0x10, 0x0, 0xc6, 0x0, 0x4f, 0x0, 0x0, 0xd,
    0x50, 0x0, 0x2, 0xbd, 0xdc, 0x40,

    /* U+215E "⅞" */
    0x7f, 0xff, 0xff, 0x50, 0x0, 0xd, 0x50, 0x0,
    0x7, 0x90, 0x3, 0xf1, 0x0, 0x7, 0xb0, 0x0,
    0x0, 0x11, 0x0, 0xb8, 0x0, 0x2, 0xe2, 0x0,
    0x0, 0x0, 0x0, 0x2f, 0x10, 0x0, 0xc7, 0x0,
    0x0, 0x0, 0x0, 0xa, 0x90, 0x0, 0x6c, 0x0,
    0x0, 0x0, 0x0, 0x2, 0xf2, 0x0, 0x1e, 0x30,
    0x9d, 0xda, 0x10, 0x0, 0x9a, 0x0, 0xa, 0x80,
    0x8a, 0x0, 0x8b, 0x0, 0x4, 0x10, 0x4, 0xd0,
    0x8, 0xa0, 0x8, 0xb0, 0x0, 0x0, 0x0, 0xe4,
    0x0, 0x2f, 0xff, 0xf3, 0x0, 0x0, 0x0, 0x9a,
    0x0, 0xc, 0x80, 0x6, 0xe0, 0x0, 0x0, 0x3e,
    0x10, 0x0, 0xc6, 0x0, 0x4f, 0x0, 0x0, 0xd,
    0x50, 0x0, 0x2, 0xbd, 0xdc, 0x40,

    /* U+2190 "←" */
    0x0, 0x5a, 0x0, 0x0, 0x1, 0xe6, 0x0, 0x0,
    0xb, 0xc0, 0x0, 0x0, 0x4f, 0xff, 0xff, 0xf8,
    0xd, 0xb3, 0x33, 0x31, 0x3, 0xf4, 0x0, 0x0,
    0x0, 0x7c, 0x0, 0x0,

    /* U+2191 "↑" */
    0x0, 0x2c, 0x60, 0x0, 0x7f, 0xff, 0xb1, 0x8d,
    0x4e, 0x6a, 0xe3, 0x0, 0xe5, 0x4, 0x0, 0xe,
    0x50, 0x0, 0x0, 0xe5, 0x0, 0x0, 0xe, 0x50,
    0x0, 0x0, 0x10, 0x0,

    /* U+2192 "→" */
    0x0, 0x3, 0xa0, 0x0, 0x0, 0x0, 0xca, 0x0,
    0x0, 0x0, 0x3f, 0x40, 0xef, 0xff, 0xff, 0xe0,
    0x23, 0x33, 0x4f, 0x70, 0x0, 0x0, 0xac, 0x0,
    0x0, 0x3, 0xe2, 0x0,

    /* U+2193 "↓" */
    0x0, 0xc, 0x50, 0x0, 0x0, 0xd5, 0x0, 0x0,
    0xd, 0x50, 0x1, 0x0, 0xd5, 0x1, 0x8b, 0x1d,
    0x56, 0xf1, 0xaf, 0xfe, 0xe4, 0x0, 0x5e, 0xb1,
    0x0, 0x0, 0x0, 0x0,

    /* U+2194 "↔" */
    0x0, 0x2a, 0x20, 0x5, 0x90, 0x0, 0xc, 0xa0,
    0x0, 0x1e, 0x70, 0x7, 0xe1, 0x0, 0x0, 0x5f,
    0x20, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x9, 0xe3,
    0x33, 0x33, 0x6f, 0x40, 0xe, 0x80, 0x0, 0xd,
    0x90, 0x0, 0x4e, 0x20, 0x6, 0xd0, 0x0,

    /* U+2195 "↕" */
    0x0, 0x3, 0x0, 0x0, 0x9, 0xfd, 0x20, 0x3d,
    0xcf, 0xcf, 0x78, 0x70, 0xe5, 0x3c, 0x0, 0xe,
    0x50, 0x0, 0x0, 0xe5, 0x0, 0x0, 0xe, 0x50,
    0x8, 0x70, 0xe5, 0x4c, 0x2d, 0xdf, 0xcf, 0x60,
    0x8, 0xfc, 0x20, 0x0, 0x2, 0x0, 0x0,

    /* U+2196 "↖" */
    0x0, 0x26, 0x98, 0x0, 0x9f, 0xd9, 0x50, 0xc,
    0xfc, 0x10, 0x0, 0xf4, 0xdc, 0x10, 0x2e, 0x1,
    0xdc, 0x10, 0x60, 0x1, 0xda, 0x0, 0x0, 0x1,
    0x10,

    /* U+2197 "↗" */
    0x0, 0x87, 0x41, 0x0, 0x1, 0x7b, 0xef, 0x50,
    0x0, 0x1, 0xdf, 0x90, 0x0, 0x1d, 0xc6, 0xc0,
    0x1, 0xdc, 0x12, 0xf0, 0xd, 0xc1, 0x0, 0x80,
    0x4, 0x10, 0x0, 0x0,

    /* U+2198 "↘" */
    0x3, 0x0, 0x0, 0x0, 0xd, 0xc0, 0x0, 0x60,
    0x2, 0xec, 0x1, 0xf0, 0x0, 0x2e, 0xc6, 0xc0,
    0x0, 0x2, 0xef, 0x90, 0x1, 0x6a, 0xef, 0x60,
    0x0, 0x98, 0x52, 0x0,

    /* U+2199 "↙" */
    0x0, 0x0, 0x2, 0x30, 0x80, 0x2, 0xea, 0x2f,
    0x2, 0xeb, 0x0, 0xe5, 0xeb, 0x0, 0xb, 0xfb,
    0x0, 0x0, 0x8f, 0xea, 0x70, 0x0, 0x14, 0x76,
    0x0,

    /* U+2202 "∂" */
    0x3, 0x67, 0x52, 0x0, 0x0, 0xf, 0xee, 0xff,
    0xb1, 0x0, 0x1, 0x0, 0x5, 0xed, 0x0, 0x0,
    0x0, 0x0, 0x3f, 0x70, 0x0, 0x0, 0x0, 0xc,
    0xc0, 0x2, 0xbf, 0xfd, 0x59, 0xf0, 0x3f, 0xd6,
    0x47, 0xfd, 0xf0, 0xae, 0x10, 0x0, 0x4f, 0xf0,
    0xcb, 0x0, 0x0, 0xf, 0xc0, 0xbe, 0x0, 0x0,
    0x3f, 0x60, 0x3f, 0xc4, 0x36, 0xec, 0x0, 0x4,
    0xcf, 0xff, 0x90, 0x0, 0x0, 0x0, 0x10, 0x0,
    0x0,

    /* U+2205 "∅" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x9d, 0xb5,
    0x86, 0x1, 0xe9, 0x35, 0xfa, 0x0, 0x99, 0x0,
    0x99, 0xe0, 0xc, 0x50, 0xa5, 0xf, 0x10, 0xa8,
    0xa5, 0x1, 0xf0, 0x4, 0xf8, 0x1, 0xc9, 0x1,
    0xb8, 0xef, 0xf9, 0x0, 0x13, 0x0, 0x10, 0x0,
    0x0,

    /* U+2206 "∆" */
    0x0, 0x0, 0x0, 0x32, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x4f, 0xe0, 0x0, 0x0, 0x0, 0x0, 0xc,
    0xdf, 0x50, 0x0, 0x0, 0x0, 0x3, 0xf5, 0xbd,
    0x0, 0x0, 0x0, 0x0, 0xad, 0x4, 0xf4, 0x0,
    0x0, 0x0, 0x2f, 0x60, 0xd, 0xb0, 0x0, 0x0,
    0x9, 0xf0, 0x0, 0x6f, 0x30, 0x0, 0x1, 0xf8,
    0x0, 0x0, 0xea, 0x0, 0x0, 0x7f, 0x10, 0x0,
    0x8, 0xf1, 0x0, 0xe, 0xa0, 0x0, 0x0, 0x1f,
    0x80, 0x6, 0xf9, 0x66, 0x66, 0x66, 0xdf, 0x0,
    0xdf, 0xff, 0xff, 0xff, 0xff, 0xf7,

    /* U+220F "∏" */
    0x13, 0x33, 0x33, 0x33, 0x33, 0x8, 0xff, 0xff,
    0xff, 0xff, 0xf1, 0x8f, 0x44, 0x44, 0x44, 0xaf,
    0x18, 0xf1, 0x0, 0x0, 0x8, 0xf1, 0x8f, 0x10,
    0x0, 0x0, 0x8f, 0x18, 0xf1, 0x0, 0x0, 0x8,
    0xf1, 0x8f, 0x10, 0x0, 0x0, 0x8f, 0x18, 0xf1,
    0x0, 0x0, 0x8, 0xf1, 0x8f, 0x10, 0x0, 0x0,
    0x8f, 0x18, 0xf1, 0x0, 0x0, 0x8, 0xf1, 0x8f,
    0x10, 0x0, 0x0, 0x8f, 0x18, 0xf1, 0x0, 0x0,
    0x8, 0xf1, 0x8f, 0x10, 0x0, 0x0, 0x8f, 0x18,
    0xf1, 0x0, 0x0, 0x8, 0xf1, 0x8f, 0x10, 0x0,
    0x0, 0x8f, 0x10, 0x10, 0x0, 0x0, 0x0, 0x10,

    /* U+2211 "∑" */
    0x3, 0x33, 0x33, 0x33, 0x33, 0x1, 0xff, 0xff,
    0xff, 0xff, 0xf0, 0x9, 0xf8, 0x33, 0x33, 0x32,
    0x0, 0xb, 0xf3, 0x0, 0x0, 0x0, 0x0, 0x1d,
    0xe1, 0x0, 0x0, 0x0, 0x0, 0x2e, 0xc0, 0x0,
    0x0, 0x0, 0x0, 0x4f, 0xb0, 0x0, 0x0, 0x0,
    0x0, 0x6f, 0x60, 0x0, 0x0, 0x0, 0x8, 0xf5,
    0x0, 0x0, 0x0, 0x6, 0xf8, 0x0, 0x0, 0x0,
    0x4, 0xfa, 0x0, 0x0, 0x0, 0x3, 0xfc, 0x0,
    0x0, 0x0, 0x1, 0xed, 0x10, 0x0, 0x0, 0x0,
    0xdf, 0x64, 0x44, 0x44, 0x40, 0x5f, 0xff, 0xff,
    0xff, 0xff, 0x0, 0x11, 0x11, 0x11, 0x11, 0x10,

    /* U+2212 "−" */
    0x33, 0x33, 0x33, 0x30, 0xef, 0xff, 0xff, 0xf3,
    0x0, 0x0, 0x0, 0x0,

    /* U+2215 "∕" */
    0x0, 0x0, 0x2, 0x70, 0x0, 0x0, 0x8, 0xd0,
    0x0, 0x0, 0xd, 0x80, 0x0, 0x0, 0x3f, 0x20,
    0x0, 0x0, 0x9c, 0x0, 0x0, 0x0, 0xe7, 0x0,
    0x0, 0x4, 0xf1, 0x0, 0x0, 0xa, 0xc0, 0x0,
    0x0, 0xf, 0x60, 0x0, 0x0, 0x5f, 0x10, 0x0,
    0x0, 0xab, 0x0, 0x0, 0x1, 0xf5, 0x0, 0x0,
    0x6, 0xf0, 0x0, 0x0, 0xb, 0xa0, 0x0, 0x0,
    0x1f, 0x40, 0x0, 0x0, 0x39, 0x0, 0x0, 0x0,

    /* U+2219 "∙" */
    0x6c, 0x1b, 0xf4, 0x14, 0x0,

    /* U+221A "√" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0xa9, 0x0, 0x0,
    0x0, 0x0, 0x1, 0xf6, 0x0, 0x0, 0x0, 0x0,
    0x6, 0xf1, 0x0, 0x0, 0x0, 0x0, 0xc, 0xb0,
    0x0, 0x0, 0x0, 0x0, 0x1f, 0x50, 0x33, 0x31,
    0x0, 0x0, 0x7f, 0x0, 0xef, 0xf8, 0x0, 0x0,
    0xca, 0x0, 0x0, 0xae, 0x0, 0x2, 0xf5, 0x0,
    0x0, 0x4f, 0x40, 0x7, 0xf0, 0x0, 0x0, 0xe,
    0xa0, 0xd, 0xa0, 0x0, 0x0, 0x8, 0xf0, 0x2f,
    0x40, 0x0, 0x0, 0x3, 0xf5, 0x8f, 0x0, 0x0,
    0x0, 0x0, 0xdb, 0xda, 0x0, 0x0, 0x0, 0x0,
    0x7f, 0xf4, 0x0, 0x0, 0x0, 0x0, 0x1f, 0xe0,
    0x0, 0x0, 0x0, 0x0, 0x1, 0x10, 0x0, 0x0,

    /* U+221E "∞" */
    0x0, 0x8d, 0xc7, 0x0, 0x19, 0xdc, 0x60, 0x0,
    0xcd, 0x76, 0xdc, 0x2e, 0xb6, 0x8f, 0x80, 0x3f,
    0x20, 0x0, 0xcf, 0x90, 0x0, 0x5f, 0x4, 0xf0,
    0x0, 0x7, 0xf4, 0x0, 0x3, 0xf0, 0x1f, 0x80,
    0x6, 0xf9, 0xe3, 0x0, 0xbc, 0x0, 0x5f, 0xfe,
    0xe5, 0x7, 0xfe, 0xfe, 0x20, 0x0, 0x14, 0x40,
    0x0, 0x1, 0x44, 0x0, 0x0,

    /* U+222B "∫" */
    0x0, 0x0, 0x8e, 0xf9, 0x0, 0x4, 0xf9, 0x55,
    0x0, 0x8, 0xf0, 0x0, 0x0, 0x9, 0xf0, 0x0,
    0x0, 0x9, 0xf0, 0x0, 0x0, 0x9, 0xf0, 0x0,
    0x0, 0x9, 0xf0, 0x0, 0x0, 0x9, 0xf0, 0x0,
    0x0, 0x9, 0xf0, 0x0, 0x0, 0x9, 0xf0, 0x0,
    0x0, 0x9, 0xf0, 0x0, 0x0, 0x9, 0xf0, 0x0,
    0x0, 0x9, 0xe0, 0x0, 0x13, 0x3e, 0xc0, 0x0,
    0x5f, 0xfe, 0x30, 0x0, 0x1, 0x20, 0x0, 0x0,

    /* U+2248 "≈" */
    0x2, 0xbb, 0x40, 0x9, 0x20, 0xd9, 0x8f, 0x86,
    0xf1, 0xc, 0x0, 0x3b, 0xd5, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x4, 0xee, 0x50, 0xb, 0x20, 0xd8,
    0x7f, 0x97, 0xe0, 0xb, 0x0, 0x2b, 0xc4, 0x0,

    /* U+2260 "≠" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xd, 0x60,
    0x12, 0x22, 0x7e, 0x20, 0xef, 0xff, 0xff, 0xf3,
    0x22, 0x29, 0xc2, 0x20, 0x0, 0x1f, 0x40, 0x0,
    0x45, 0xad, 0x55, 0x51, 0xef, 0xff, 0xff, 0xf3,
    0xa, 0xa0, 0x0, 0x0, 0x2d, 0x20, 0x0, 0x0,

    /* U+2264 "≤" */
    0x0, 0x0, 0x0, 0x52, 0x0, 0x3, 0x9f, 0xe2,
    0x17, 0xdf, 0xb5, 0x0, 0xef, 0x71, 0x0, 0x0,
    0x8e, 0xe9, 0x30, 0x0, 0x0, 0x5b, 0xfd, 0x70,
    0x0, 0x0, 0x17, 0xd3, 0x0, 0x0, 0x0, 0x0,
    0x34, 0x44, 0x44, 0x40, 0xef, 0xff, 0xff, 0xf3,

    /* U+2265 "≥" */
    0x61, 0x0, 0x0, 0x0, 0xcf, 0xb5, 0x0, 0x0,
    0x3, 0x9e, 0xe9, 0x30, 0x0, 0x0, 0x5d, 0xf3,
    0x0, 0x17, 0xdf, 0xb1, 0x5b, 0xfd, 0x71, 0x0,
    0xd9, 0x30, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x34, 0x44, 0x44, 0x40, 0xef, 0xff, 0xff, 0xf3,

    /* U+25A0 "■" */
    0x14, 0x44, 0x44, 0x34, 0xff, 0xff, 0xfe, 0x4f,
    0xff, 0xff, 0xe4, 0xff, 0xff, 0xfe, 0x4f, 0xff,
    0xff, 0xe4, 0xff, 0xff, 0xfe, 0x4f, 0xff, 0xff,
    0xe0,

    /* U+25A1 "□" */
    0x2, 0x22, 0x22, 0x21, 0xfc, 0xcc, 0xcf, 0x1c,
    0x0, 0x0, 0xd1, 0xc0, 0x0, 0xd, 0x1c, 0x0,
    0x0, 0xd1, 0xc0, 0x0, 0xd, 0x1e, 0xee, 0xee,
    0xe0,

    /* U+25B2 "▲" */
    0x0, 0x3, 0x0, 0x0, 0x0, 0xc, 0x50, 0x0,
    0x0, 0x4f, 0xd0, 0x0, 0x0, 0xcf, 0xf5, 0x0,
    0x4, 0xff, 0xfd, 0x0, 0xc, 0xff, 0xff, 0x50,
    0x4f, 0xff, 0xff, 0xd0, 0x12, 0x22, 0x22, 0x20,

    /* U+25B3 "△" */
    0x0, 0x4, 0x0, 0x0, 0x0, 0xd, 0x70, 0x0,
    0x0, 0x58, 0xc0, 0x0, 0x0, 0xc0, 0x57, 0x0,
    0x5, 0x70, 0xc, 0x0, 0xb, 0x0, 0x5, 0x70,
    0x5e, 0xcc, 0xcc, 0xe0,

    /* U+25B6 "▶" */
    0x15, 0x0, 0x0, 0x0, 0x2f, 0xd5, 0x0, 0x0,
    0x2f, 0xff, 0xd5, 0x0, 0x2f, 0xff, 0xff, 0xd3,
    0x2f, 0xff, 0xfd, 0x50, 0x2f, 0xfd, 0x50, 0x0,
    0x2d, 0x50, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+25B7 "▷" */
    0x60, 0x0, 0x0, 0xe, 0xc6, 0x0, 0x0, 0xb0,
    0x6c, 0x60, 0xb, 0x0, 0x6, 0xd4, 0xb0, 0x6,
    0xc6, 0xc, 0x7c, 0x60, 0x0, 0xe6, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,

    /* U+25BC "▼" */
    0x4a, 0xaa, 0xaa, 0xa0, 0x1f, 0xff, 0xff, 0xa0,
    0x8, 0xff, 0xff, 0x20, 0x1, 0xff, 0xfa, 0x0,
    0x0, 0x8f, 0xf2, 0x0, 0x0, 0x1f, 0xa0, 0x0,
    0x0, 0x8, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+25BD "▽" */
    0x5c, 0xcc, 0xcc, 0xb0, 0xb, 0x0, 0x3, 0x90,
    0x7, 0x50, 0xb, 0x10, 0x0, 0xc0, 0x49, 0x0,
    0x0, 0x75, 0xb1, 0x0, 0x0, 0xd, 0x90, 0x0,
    0x0, 0x7, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+25C0 "◀" */
    0x0, 0x0, 0x0, 0x15, 0x0, 0x0, 0x18, 0xfc,
    0x0, 0x18, 0xff, 0xfc, 0x7, 0xff, 0xff, 0xfc,
    0x1, 0x8f, 0xff, 0xfc, 0x0, 0x1, 0x8f, 0xfc,
    0x0, 0x0, 0x1, 0x8b, 0x0, 0x0, 0x0, 0x0,

    /* U+25C1 "◁" */
    0x0, 0x0, 0x0, 0x15, 0x0, 0x0, 0x18, 0xcb,
    0x0, 0x18, 0xc5, 0xb, 0x7, 0xd4, 0x0, 0xb,
    0x1, 0x8b, 0x40, 0xb, 0x0, 0x1, 0x8c, 0x5b,
    0x0, 0x0, 0x1, 0x8b, 0x0, 0x0, 0x0, 0x0,

    /* U+25C6 "◆" */
    0x0, 0x0, 0x51, 0x0, 0x0, 0x0, 0x5, 0xfd,
    0x10, 0x0, 0x0, 0x5f, 0xff, 0xd1, 0x0, 0x5,
    0xff, 0xff, 0xfd, 0x10, 0x4f, 0xff, 0xff, 0xff,
    0xd0, 0x1c, 0xff, 0xff, 0xff, 0x70, 0x1, 0xcf,
    0xff, 0xf7, 0x0, 0x0, 0xc, 0xff, 0x70, 0x0,
    0x0, 0x0, 0xc7, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0,

    /* U+25C7 "◇" */
    0x0, 0x0, 0x51, 0x0, 0x0, 0x0, 0x5, 0xed,
    0x10, 0x0, 0x0, 0x5d, 0x15, 0xd1, 0x0, 0x5,
    0xc1, 0x0, 0x5d, 0x10, 0x4d, 0x10, 0x0, 0x5,
    0xd0, 0x1c, 0x60, 0x0, 0xb, 0x70, 0x1, 0xc6,
    0x0, 0xc7, 0x0, 0x0, 0xc, 0x7c, 0x70, 0x0,
    0x0, 0x0, 0xc7, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0,

    /* U+25CA "◊" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x8, 0x70, 0x0,
    0x0, 0x3e, 0xe2, 0x0, 0x0, 0xd4, 0x4c, 0x0,
    0x8, 0x90, 0x9, 0x70, 0x2e, 0x0, 0x0, 0xe2,
    0xc, 0x40, 0x4, 0xc0, 0x2, 0xe1, 0x1e, 0x20,
    0x0, 0x7a, 0xa7, 0x0, 0x0, 0xd, 0xc0, 0x0,
    0x0, 0x3, 0x20, 0x0,

    /* U+27E8 "⟨" */
    0x0, 0xe, 0x60, 0x5, 0xf1, 0x0, 0xac, 0x0,
    0xf, 0x60, 0x5, 0xf1, 0x0, 0xbc, 0x0, 0x1f,
    0x60, 0x5, 0xf2, 0x0, 0x1f, 0x60, 0x0, 0xbb,
    0x0, 0x6, 0xf1, 0x0, 0x1f, 0x60, 0x0, 0xbb,
    0x0, 0x5, 0xf1, 0x0, 0xf, 0x60, 0x0, 0x0,

    /* U+27E9 "⟩" */
    0x2f, 0x30, 0x0, 0xd9, 0x0, 0x8, 0xe0, 0x0,
    0x2f, 0x40, 0x0, 0xd9, 0x0, 0x8, 0xf0, 0x0,
    0x2f, 0x50, 0x0, 0xe9, 0x0, 0x2f, 0x50, 0x7,
    0xf0, 0x0, 0xca, 0x0, 0x2f, 0x50, 0x7, 0xe0,
    0x0, 0xc9, 0x0, 0x2f, 0x40, 0x0, 0x0, 0x0,

    /* U+A78B "Ꞌ" */
    0xbd, 0xbc, 0xbc, 0xbb, 0xbb, 0xbb, 0x88,

    /* U+A78C "ꞌ" */
    0x11, 0xbc, 0xbc, 0xbb, 0xbb, 0xba, 0xba,

    /* U+FB01 "ﬁ" */
    0x0, 0x5d, 0xfc, 0x2e, 0xa0, 0x2f, 0xb5, 0x81,
    0xd9, 0x5, 0xf3, 0x0, 0x0, 0xc, 0xff, 0xff,
    0xa0, 0xea, 0x48, 0xf7, 0x53, 0xe, 0xa0, 0x5f,
    0x30, 0x0, 0xea, 0x5, 0xf3, 0x0, 0xe, 0xa0,
    0x5f, 0x30, 0x0, 0xea, 0x5, 0xf3, 0x0, 0xe,
    0xa0, 0x5f, 0x30, 0x0, 0xea, 0x5, 0xf3, 0x0,
    0xe, 0xa0, 0x5f, 0x30, 0x0, 0xea,

    /* U+FB02 "ﬂ" */
    0x0, 0x5d, 0xfc, 0xe, 0xa0, 0x2f, 0xb5, 0x70,
    0xea, 0x5, 0xf3, 0x0, 0xe, 0xac, 0xff, 0xff,
    0xa0, 0xea, 0x48, 0xf7, 0x53, 0xe, 0xa0, 0x5f,
    0x30, 0x0, 0xea, 0x5, 0xf3, 0x0, 0xe, 0xa0,
    0x5f, 0x30, 0x0, 0xea, 0x5, 0xf3, 0x0, 0xe,
    0xa0, 0x5f, 0x30, 0x0, 0xea, 0x5, 0xf3, 0x0,
    0xe, 0xa0, 0x5f, 0x30, 0x0, 0xea
};


/*---------------------
 *  GLYPH DESCRIPTION
 *--------------------*/

static const lv_font_fmt_txt_glyph_dsc_t glyph_dsc[] = {
    {.bitmap_index = 0, .adv_w = 0, .box_w = 0, .box_h = 0, .ofs_x = 0, .ofs_y = 0} /* id = 0 reserved */,
    {.bitmap_index = 0, .adv_w = 69, .box_w = 0, .box_h = 0, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 0, .adv_w = 69, .box_w = 3, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 18, .adv_w = 100, .box_w = 6, .box_h = 5, .ofs_x = 0, .ofs_y = 7},
    {.bitmap_index = 33, .adv_w = 180, .box_w = 11, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 99, .adv_w = 159, .box_w = 10, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 179, .adv_w = 216, .box_w = 13, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 257, .adv_w = 176, .box_w = 11, .box_h = 13, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 329, .adv_w = 54, .box_w = 2, .box_h = 5, .ofs_x = 1, .ofs_y = 7},
    {.bitmap_index = 334, .adv_w = 86, .box_w = 4, .box_h = 15, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 364, .adv_w = 87, .box_w = 4, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 394, .adv_w = 102, .box_w = 7, .box_h = 7, .ofs_x = 0, .ofs_y = 5},
    {.bitmap_index = 419, .adv_w = 149, .box_w = 8, .box_h = 8, .ofs_x = 1, .ofs_y = 2},
    {.bitmap_index = 451, .adv_w = 58, .box_w = 3, .box_h = 5, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 459, .adv_w = 98, .box_w = 6, .box_h = 3, .ofs_x = 0, .ofs_y = 3},
    {.bitmap_index = 468, .adv_w = 58, .box_w = 3, .box_h = 3, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 473, .adv_w = 90, .box_w = 8, .box_h = 16, .ofs_x = -1, .ofs_y = -2},
    {.bitmap_index = 537, .adv_w = 171, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 597, .adv_w = 95, .box_w = 5, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 627, .adv_w = 147, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 681, .adv_w = 146, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 735, .adv_w = 171, .box_w = 11, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 801, .adv_w = 147, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 855, .adv_w = 158, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 915, .adv_w = 153, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 969, .adv_w = 165, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1029, .adv_w = 158, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1089, .adv_w = 58, .box_w = 3, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1103, .adv_w = 58, .box_w = 3, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 1121, .adv_w = 149, .box_w = 8, .box_h = 8, .ofs_x = 1, .ofs_y = 2},
    {.bitmap_index = 1153, .adv_w = 149, .box_w = 8, .box_h = 6, .ofs_x = 1, .ofs_y = 3},
    {.bitmap_index = 1177, .adv_w = 149, .box_w = 8, .box_h = 8, .ofs_x = 1, .ofs_y = 2},
    {.bitmap_index = 1209, .adv_w = 147, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1263, .adv_w = 265, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 1383, .adv_w = 187, .box_w = 13, .box_h = 12, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 1461, .adv_w = 194, .box_w = 11, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1527, .adv_w = 185, .box_w = 11, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1593, .adv_w = 211, .box_w = 12, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1665, .adv_w = 172, .box_w = 9, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1719, .adv_w = 163, .box_w = 9, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1773, .adv_w = 198, .box_w = 12, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1845, .adv_w = 208, .box_w = 11, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1911, .adv_w = 79, .box_w = 3, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1929, .adv_w = 131, .box_w = 8, .box_h = 12, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 1977, .adv_w = 184, .box_w = 11, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2043, .adv_w = 152, .box_w = 9, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2097, .adv_w = 244, .box_w = 13, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2175, .adv_w = 208, .box_w = 11, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2241, .adv_w = 215, .box_w = 13, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2319, .adv_w = 185, .box_w = 10, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2379, .adv_w = 215, .box_w = 14, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 2484, .adv_w = 186, .box_w = 10, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2544, .adv_w = 159, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2604, .adv_w = 150, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2664, .adv_w = 202, .box_w = 11, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2730, .adv_w = 182, .box_w = 13, .box_h = 12, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 2808, .adv_w = 288, .box_w = 18, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2916, .adv_w = 172, .box_w = 11, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2982, .adv_w = 166, .box_w = 12, .box_h = 12, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 3054, .adv_w = 168, .box_w = 11, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3120, .adv_w = 85, .box_w = 5, .box_h = 15, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 3158, .adv_w = 90, .box_w = 8, .box_h = 16, .ofs_x = -1, .ofs_y = -2},
    {.bitmap_index = 3222, .adv_w = 85, .box_w = 4, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 3252, .adv_w = 149, .box_w = 8, .box_h = 7, .ofs_x = 1, .ofs_y = 2},
    {.bitmap_index = 3280, .adv_w = 128, .box_w = 8, .box_h = 2, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 3288, .adv_w = 154, .box_w = 5, .box_h = 2, .ofs_x = 1, .ofs_y = 10},
    {.bitmap_index = 3293, .adv_w = 175, .box_w = 10, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3338, .adv_w = 175, .box_w = 10, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3398, .adv_w = 146, .box_w = 9, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3439, .adv_w = 175, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3499, .adv_w = 157, .box_w = 10, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3544, .adv_w = 90, .box_w = 7, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3586, .adv_w = 177, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 3646, .adv_w = 174, .box_w = 9, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3700, .adv_w = 71, .box_w = 3, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3718, .adv_w = 73, .box_w = 6, .box_h = 15, .ofs_x = -2, .ofs_y = -3},
    {.bitmap_index = 3763, .adv_w = 158, .box_w = 9, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3817, .adv_w = 71, .box_w = 2, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3829, .adv_w = 271, .box_w = 15, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3897, .adv_w = 174, .box_w = 9, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3938, .adv_w = 163, .box_w = 10, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3983, .adv_w = 175, .box_w = 10, .box_h = 12, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 4043, .adv_w = 175, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 4103, .adv_w = 105, .box_w = 6, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 4130, .adv_w = 128, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4166, .adv_w = 106, .box_w = 7, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4205, .adv_w = 173, .box_w = 9, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 4246, .adv_w = 143, .box_w = 10, .box_h = 9, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 4291, .adv_w = 230, .box_w = 15, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4359, .adv_w = 141, .box_w = 9, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4400, .adv_w = 143, .box_w = 10, .box_h = 12, .ofs_x = -1, .ofs_y = -3},
    {.bitmap_index = 4460, .adv_w = 133, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4496, .adv_w = 90, .box_w = 6, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 4541, .adv_w = 77, .box_w = 3, .box_h = 15, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 4564, .adv_w = 90, .box_w = 5, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 4602, .adv_w = 149, .box_w = 9, .box_h = 5, .ofs_x = 0, .ofs_y = 4},
    {.bitmap_index = 4625, .adv_w = 69, .box_w = 0, .box_h = 0, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4625, .adv_w = 69, .box_w = 3, .box_h = 12, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 4643, .adv_w = 146, .box_w = 9, .box_h = 13, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 4702, .adv_w = 165, .box_w = 11, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4768, .adv_w = 179, .box_w = 11, .box_h = 12, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 4834, .adv_w = 181, .box_w = 13, .box_h = 12, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 4912, .adv_w = 77, .box_w = 3, .box_h = 15, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 4935, .adv_w = 128, .box_w = 8, .box_h = 14, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 4991, .adv_w = 154, .box_w = 6, .box_h = 2, .ofs_x = 2, .ofs_y = 11},
    {.bitmap_index = 4997, .adv_w = 205, .box_w = 13, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5075, .adv_w = 103, .box_w = 6, .box_h = 5, .ofs_x = 0, .ofs_y = 7},
    {.bitmap_index = 5090, .adv_w = 129, .box_w = 8, .box_h = 7, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 5118, .adv_w = 149, .box_w = 8, .box_h = 6, .ofs_x = 1, .ofs_y = 1},
    {.bitmap_index = 5142, .adv_w = 98, .box_w = 6, .box_h = 3, .ofs_x = 0, .ofs_y = 3},
    {.bitmap_index = 5151, .adv_w = 205, .box_w = 13, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5229, .adv_w = 154, .box_w = 6, .box_h = 2, .ofs_x = 2, .ofs_y = 10},
    {.bitmap_index = 5235, .adv_w = 107, .box_w = 6, .box_h = 6, .ofs_x = 0, .ofs_y = 6},
    {.bitmap_index = 5253, .adv_w = 149, .box_w = 8, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 5297, .adv_w = 110, .box_w = 7, .box_h = 7, .ofs_x = 0, .ofs_y = 5},
    {.bitmap_index = 5322, .adv_w = 110, .box_w = 7, .box_h = 7, .ofs_x = 0, .ofs_y = 5},
    {.bitmap_index = 5347, .adv_w = 154, .box_w = 4, .box_h = 3, .ofs_x = 3, .ofs_y = 10},
    {.bitmap_index = 5353, .adv_w = 175, .box_w = 9, .box_h = 12, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 5407, .adv_w = 166, .box_w = 9, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 5475, .adv_w = 68, .box_w = 3, .box_h = 3, .ofs_x = 1, .ofs_y = 3},
    {.bitmap_index = 5480, .adv_w = 154, .box_w = 5, .box_h = 4, .ofs_x = 2, .ofs_y = -4},
    {.bitmap_index = 5490, .adv_w = 110, .box_w = 5, .box_h = 7, .ofs_x = 1, .ofs_y = 5},
    {.bitmap_index = 5508, .adv_w = 107, .box_w = 7, .box_h = 5, .ofs_x = 0, .ofs_y = 7},
    {.bitmap_index = 5526, .adv_w = 129, .box_w = 8, .box_h = 7, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 5554, .adv_w = 265, .box_w = 16, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 5650, .adv_w = 265, .box_w = 15, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 5740, .adv_w = 265, .box_w = 17, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5842, .adv_w = 147, .box_w = 9, .box_h = 12, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 5896, .adv_w = 187, .box_w = 13, .box_h = 15, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 5994, .adv_w = 187, .box_w = 13, .box_h = 15, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 6092, .adv_w = 187, .box_w = 13, .box_h = 15, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 6190, .adv_w = 187, .box_w = 13, .box_h = 15, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 6288, .adv_w = 187, .box_w = 13, .box_h = 15, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 6386, .adv_w = 187, .box_w = 13, .box_h = 17, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 6497, .adv_w = 268, .box_w = 17, .box_h = 12, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 6599, .adv_w = 185, .box_w = 11, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 6682, .adv_w = 172, .box_w = 9, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 6750, .adv_w = 172, .box_w = 9, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 6818, .adv_w = 172, .box_w = 9, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 6886, .adv_w = 172, .box_w = 9, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 6954, .adv_w = 79, .box_w = 5, .box_h = 15, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 6992, .adv_w = 79, .box_w = 3, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 7015, .adv_w = 79, .box_w = 7, .box_h = 15, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 7068, .adv_w = 79, .box_w = 5, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7106, .adv_w = 214, .box_w = 13, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7184, .adv_w = 208, .box_w = 11, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 7267, .adv_w = 215, .box_w = 13, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7365, .adv_w = 215, .box_w = 13, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7463, .adv_w = 215, .box_w = 13, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7561, .adv_w = 215, .box_w = 13, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7659, .adv_w = 215, .box_w = 13, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7757, .adv_w = 149, .box_w = 7, .box_h = 8, .ofs_x = 1, .ofs_y = 2},
    {.bitmap_index = 7785, .adv_w = 215, .box_w = 13, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 7876, .adv_w = 202, .box_w = 11, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 7959, .adv_w = 202, .box_w = 11, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 8042, .adv_w = 202, .box_w = 11, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 8125, .adv_w = 202, .box_w = 11, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 8208, .adv_w = 166, .box_w = 12, .box_h = 15, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 8298, .adv_w = 185, .box_w = 10, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 8358, .adv_w = 173, .box_w = 10, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 8418, .adv_w = 153, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8478, .adv_w = 153, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8538, .adv_w = 153, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8598, .adv_w = 153, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8658, .adv_w = 153, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8718, .adv_w = 153, .box_w = 10, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8788, .adv_w = 253, .box_w = 16, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8860, .adv_w = 146, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 8914, .adv_w = 157, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8974, .adv_w = 157, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9034, .adv_w = 157, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9094, .adv_w = 157, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9154, .adv_w = 71, .box_w = 5, .box_h = 12, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 9184, .adv_w = 71, .box_w = 3, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 9202, .adv_w = 71, .box_w = 6, .box_h = 12, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 9238, .adv_w = 71, .box_w = 5, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9268, .adv_w = 164, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9328, .adv_w = 174, .box_w = 9, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 9382, .adv_w = 163, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9442, .adv_w = 163, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9502, .adv_w = 163, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9562, .adv_w = 163, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9622, .adv_w = 163, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9682, .adv_w = 149, .box_w = 8, .box_h = 9, .ofs_x = 1, .ofs_y = 2},
    {.bitmap_index = 9718, .adv_w = 163, .box_w = 10, .box_h = 11, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 9773, .adv_w = 173, .box_w = 9, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 9827, .adv_w = 173, .box_w = 9, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 9881, .adv_w = 173, .box_w = 9, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 9935, .adv_w = 173, .box_w = 9, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 9989, .adv_w = 143, .box_w = 10, .box_h = 15, .ofs_x = -1, .ofs_y = -3},
    {.bitmap_index = 10064, .adv_w = 175, .box_w = 10, .box_h = 15, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 10139, .adv_w = 143, .box_w = 10, .box_h = 15, .ofs_x = -1, .ofs_y = -3},
    {.bitmap_index = 10214, .adv_w = 187, .box_w = 13, .box_h = 14, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 10305, .adv_w = 153, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10365, .adv_w = 187, .box_w = 13, .box_h = 15, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 10463, .adv_w = 153, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10523, .adv_w = 187, .box_w = 14, .box_h = 15, .ofs_x = -1, .ofs_y = -3},
    {.bitmap_index = 10628, .adv_w = 153, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 10688, .adv_w = 185, .box_w = 11, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10771, .adv_w = 146, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10825, .adv_w = 185, .box_w = 11, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10908, .adv_w = 146, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10962, .adv_w = 185, .box_w = 11, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 11045, .adv_w = 146, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 11099, .adv_w = 185, .box_w = 11, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 11182, .adv_w = 146, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 11236, .adv_w = 211, .box_w = 12, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 11326, .adv_w = 175, .box_w = 13, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 11411, .adv_w = 214, .box_w = 13, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 11489, .adv_w = 175, .box_w = 11, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 11555, .adv_w = 172, .box_w = 9, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 11618, .adv_w = 157, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 11678, .adv_w = 172, .box_w = 9, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 11746, .adv_w = 157, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 11806, .adv_w = 172, .box_w = 9, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 11874, .adv_w = 157, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 11934, .adv_w = 172, .box_w = 10, .box_h = 15, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 12009, .adv_w = 157, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 12069, .adv_w = 172, .box_w = 9, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 12137, .adv_w = 157, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 12197, .adv_w = 198, .box_w = 12, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 12287, .adv_w = 177, .box_w = 10, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 12362, .adv_w = 198, .box_w = 12, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 12452, .adv_w = 177, .box_w = 10, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 12527, .adv_w = 198, .box_w = 12, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 12617, .adv_w = 177, .box_w = 10, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 12692, .adv_w = 198, .box_w = 12, .box_h = 16, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 12788, .adv_w = 177, .box_w = 10, .box_h = 17, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 12873, .adv_w = 208, .box_w = 11, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 12956, .adv_w = 174, .box_w = 11, .box_h = 16, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 13044, .adv_w = 212, .box_w = 14, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 13128, .adv_w = 174, .box_w = 11, .box_h = 12, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 13194, .adv_w = 79, .box_w = 7, .box_h = 15, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 13247, .adv_w = 71, .box_w = 6, .box_h = 12, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 13283, .adv_w = 79, .box_w = 5, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 13318, .adv_w = 71, .box_w = 5, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 13348, .adv_w = 79, .box_w = 7, .box_h = 15, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 13401, .adv_w = 71, .box_w = 5, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 13431, .adv_w = 79, .box_w = 3, .box_h = 15, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 13454, .adv_w = 71, .box_w = 4, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 13484, .adv_w = 79, .box_w = 3, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 13507, .adv_w = 71, .box_w = 2, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 13516, .adv_w = 184, .box_w = 9, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 13570, .adv_w = 144, .box_w = 7, .box_h = 15, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 13623, .adv_w = 131, .box_w = 8, .box_h = 15, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 13683, .adv_w = 73, .box_w = 7, .box_h = 15, .ofs_x = -2, .ofs_y = -3},
    {.bitmap_index = 13736, .adv_w = 184, .box_w = 11, .box_h = 17, .ofs_x = 1, .ofs_y = -5},
    {.bitmap_index = 13830, .adv_w = 158, .box_w = 9, .box_h = 17, .ofs_x = 1, .ofs_y = -5},
    {.bitmap_index = 13907, .adv_w = 155, .box_w = 9, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 13948, .adv_w = 152, .box_w = 9, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 14016, .adv_w = 71, .box_w = 3, .box_h = 16, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 14040, .adv_w = 152, .box_w = 9, .box_h = 17, .ofs_x = 1, .ofs_y = -5},
    {.bitmap_index = 14117, .adv_w = 71, .box_w = 3, .box_h = 17, .ofs_x = 1, .ofs_y = -5},
    {.bitmap_index = 14143, .adv_w = 152, .box_w = 9, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 14197, .adv_w = 71, .box_w = 5, .box_h = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 14230, .adv_w = 152, .box_w = 9, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 14284, .adv_w = 88, .box_w = 5, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 14314, .adv_w = 154, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 14374, .adv_w = 75, .box_w = 6, .box_h = 12, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 14410, .adv_w = 208, .box_w = 11, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 14493, .adv_w = 174, .box_w = 9, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 14547, .adv_w = 208, .box_w = 11, .box_h = 17, .ofs_x = 1, .ofs_y = -5},
    {.bitmap_index = 14641, .adv_w = 174, .box_w = 9, .box_h = 14, .ofs_x = 1, .ofs_y = -5},
    {.bitmap_index = 14704, .adv_w = 208, .box_w = 11, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 14787, .adv_w = 174, .box_w = 9, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 14841, .adv_w = 186, .box_w = 11, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 14907, .adv_w = 208, .box_w = 11, .box_h = 15, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 14990, .adv_w = 174, .box_w = 9, .box_h = 12, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 15044, .adv_w = 215, .box_w = 13, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 15142, .adv_w = 163, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 15202, .adv_w = 215, .box_w = 13, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 15300, .adv_w = 163, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 15360, .adv_w = 215, .box_w = 13, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 15458, .adv_w = 163, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 15518, .adv_w = 288, .box_w = 18, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 15626, .adv_w = 273, .box_w = 17, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 15703, .adv_w = 186, .box_w = 10, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 15778, .adv_w = 105, .box_w = 5, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 15808, .adv_w = 186, .box_w = 10, .box_h = 17, .ofs_x = 1, .ofs_y = -5},
    {.bitmap_index = 15893, .adv_w = 105, .box_w = 5, .box_h = 14, .ofs_x = 1, .ofs_y = -5},
    {.bitmap_index = 15928, .adv_w = 186, .box_w = 10, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 16003, .adv_w = 105, .box_w = 7, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 16045, .adv_w = 159, .box_w = 10, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 16120, .adv_w = 128, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 16168, .adv_w = 159, .box_w = 10, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 16243, .adv_w = 128, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 16291, .adv_w = 159, .box_w = 10, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 16366, .adv_w = 128, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 16414, .adv_w = 159, .box_w = 10, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 16489, .adv_w = 128, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 16537, .adv_w = 150, .box_w = 10, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 16612, .adv_w = 106, .box_w = 7, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 16665, .adv_w = 150, .box_w = 10, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 16740, .adv_w = 106, .box_w = 7, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 16782, .adv_w = 150, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 16842, .adv_w = 109, .box_w = 7, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 16881, .adv_w = 202, .box_w = 11, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 16964, .adv_w = 173, .box_w = 9, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 17018, .adv_w = 202, .box_w = 11, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 17101, .adv_w = 173, .box_w = 9, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 17155, .adv_w = 202, .box_w = 11, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 17238, .adv_w = 173, .box_w = 9, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 17292, .adv_w = 202, .box_w = 11, .box_h = 17, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 17386, .adv_w = 173, .box_w = 9, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 17449, .adv_w = 202, .box_w = 11, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 17532, .adv_w = 173, .box_w = 9, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 17586, .adv_w = 202, .box_w = 11, .box_h = 15, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 17669, .adv_w = 173, .box_w = 9, .box_h = 12, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 17723, .adv_w = 288, .box_w = 18, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 17858, .adv_w = 230, .box_w = 15, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 17948, .adv_w = 166, .box_w = 12, .box_h = 15, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 18038, .adv_w = 143, .box_w = 10, .box_h = 15, .ofs_x = -1, .ofs_y = -3},
    {.bitmap_index = 18113, .adv_w = 166, .box_w = 12, .box_h = 15, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 18203, .adv_w = 168, .box_w = 11, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 18286, .adv_w = 133, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 18334, .adv_w = 168, .box_w = 11, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 18417, .adv_w = 133, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 18465, .adv_w = 168, .box_w = 11, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 18548, .adv_w = 133, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 18596, .adv_w = 78, .box_w = 7, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 18638, .adv_w = 42, .box_w = 3, .box_h = 3, .ofs_x = 0, .ofs_y = 10},
    {.bitmap_index = 18643, .adv_w = 187, .box_w = 13, .box_h = 13, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 18728, .adv_w = 203, .box_w = 12, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 18806, .adv_w = 237, .box_w = 14, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 18897, .adv_w = 109, .box_w = 6, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 18936, .adv_w = 215, .box_w = 13, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 19021, .adv_w = 223, .box_w = 14, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 19112, .adv_w = 230, .box_w = 15, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 19210, .adv_w = 74, .box_w = 5, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 19248, .adv_w = 187, .box_w = 13, .box_h = 12, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 19326, .adv_w = 194, .box_w = 11, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 19392, .adv_w = 148, .box_w = 9, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 19446, .adv_w = 187, .box_w = 13, .box_h = 12, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 19524, .adv_w = 172, .box_w = 9, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 19578, .adv_w = 168, .box_w = 11, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 19644, .adv_w = 208, .box_w = 11, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 19710, .adv_w = 215, .box_w = 13, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 19788, .adv_w = 79, .box_w = 3, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 19806, .adv_w = 184, .box_w = 11, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 19872, .adv_w = 187, .box_w = 13, .box_h = 12, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 19950, .adv_w = 244, .box_w = 13, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 20028, .adv_w = 208, .box_w = 11, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 20094, .adv_w = 209, .box_w = 11, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 20160, .adv_w = 215, .box_w = 13, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 20238, .adv_w = 210, .box_w = 11, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 20304, .adv_w = 185, .box_w = 10, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 20364, .adv_w = 163, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 20424, .adv_w = 150, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 20484, .adv_w = 166, .box_w = 12, .box_h = 12, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 20556, .adv_w = 219, .box_w = 14, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 20647, .adv_w = 172, .box_w = 11, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 20713, .adv_w = 218, .box_w = 14, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 20804, .adv_w = 230, .box_w = 15, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 20894, .adv_w = 114, .box_w = 5, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 20932, .adv_w = 166, .box_w = 12, .box_h = 14, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 21016, .adv_w = 175, .box_w = 10, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 21081, .adv_w = 143, .box_w = 9, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 21140, .adv_w = 174, .box_w = 9, .box_h = 16, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 21212, .adv_w = 72, .box_w = 4, .box_h = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 21238, .adv_w = 173, .box_w = 9, .box_h = 16, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 21310, .adv_w = 175, .box_w = 10, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 21355, .adv_w = 177, .box_w = 10, .box_h = 15, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 21430, .adv_w = 138, .box_w = 10, .box_h = 12, .ofs_x = -1, .ofs_y = -3},
    {.bitmap_index = 21490, .adv_w = 172, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 21550, .adv_w = 145, .box_w = 9, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 21591, .adv_w = 136, .box_w = 7, .box_h = 15, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 21644, .adv_w = 174, .box_w = 9, .box_h = 12, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 21698, .adv_w = 187, .box_w = 11, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 21764, .adv_w = 71, .box_w = 3, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 21778, .adv_w = 158, .box_w = 9, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 21819, .adv_w = 143, .box_w = 10, .box_h = 12, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 21879, .adv_w = 172, .box_w = 9, .box_h = 12, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 21933, .adv_w = 159, .box_w = 10, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 21978, .adv_w = 126, .box_w = 8, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 22038, .adv_w = 163, .box_w = 10, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 22083, .adv_w = 170, .box_w = 9, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 22124, .adv_w = 162, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 22184, .adv_w = 128, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 22220, .adv_w = 173, .box_w = 11, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 22270, .adv_w = 138, .box_w = 9, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 22311, .adv_w = 173, .box_w = 9, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 22352, .adv_w = 203, .box_w = 13, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 22450, .adv_w = 141, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 22504, .adv_w = 196, .box_w = 12, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 22594, .adv_w = 218, .box_w = 13, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 22653, .adv_w = 74, .box_w = 5, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 22683, .adv_w = 173, .box_w = 9, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 22737, .adv_w = 163, .box_w = 10, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 22802, .adv_w = 172, .box_w = 9, .box_h = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 22861, .adv_w = 218, .box_w = 13, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 22946, .adv_w = 170, .box_w = 9, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 23014, .adv_w = 170, .box_w = 9, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 23082, .adv_w = 213, .box_w = 13, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 23160, .adv_w = 148, .box_w = 9, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 23228, .adv_w = 181, .box_w = 11, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 23294, .adv_w = 163, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 23354, .adv_w = 81, .box_w = 3, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 23372, .adv_w = 79, .box_w = 5, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 23410, .adv_w = 138, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 23458, .adv_w = 304, .box_w = 19, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 23572, .adv_w = 302, .box_w = 18, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 23680, .adv_w = 216, .box_w = 13, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 23758, .adv_w = 182, .box_w = 11, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 23841, .adv_w = 211, .box_w = 11, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 23924, .adv_w = 177, .box_w = 11, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 24007, .adv_w = 207, .box_w = 11, .box_h = 15, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 24090, .adv_w = 194, .box_w = 12, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 24162, .adv_w = 187, .box_w = 10, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 24222, .adv_w = 191, .box_w = 11, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 24288, .adv_w = 148, .box_w = 9, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 24342, .adv_w = 206, .box_w = 13, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 24440, .adv_w = 170, .box_w = 9, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 24494, .adv_w = 263, .box_w = 17, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 24596, .adv_w = 164, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 24656, .adv_w = 211, .box_w = 11, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 24722, .adv_w = 211, .box_w = 11, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 24805, .adv_w = 182, .box_w = 11, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 24871, .adv_w = 202, .box_w = 11, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 24937, .adv_w = 247, .box_w = 13, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 25015, .adv_w = 210, .box_w = 11, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 25081, .adv_w = 217, .box_w = 13, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 25159, .adv_w = 210, .box_w = 11, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 25225, .adv_w = 183, .box_w = 10, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 25285, .adv_w = 184, .box_w = 12, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 25357, .adv_w = 154, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 25417, .adv_w = 177, .box_w = 11, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 25483, .adv_w = 237, .box_w = 15, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 25581, .adv_w = 171, .box_w = 11, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 25647, .adv_w = 212, .box_w = 12, .box_h = 15, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 25737, .adv_w = 188, .box_w = 11, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 25803, .adv_w = 280, .box_w = 15, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 25893, .adv_w = 287, .box_w = 17, .box_h = 15, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 26021, .adv_w = 212, .box_w = 13, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 26099, .adv_w = 254, .box_w = 14, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 26183, .adv_w = 183, .box_w = 10, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 26243, .adv_w = 181, .box_w = 11, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 26309, .adv_w = 281, .box_w = 16, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 26405, .adv_w = 187, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 26465, .adv_w = 151, .box_w = 10, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 26510, .adv_w = 169, .box_w = 10, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 26575, .adv_w = 157, .box_w = 8, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 26611, .adv_w = 125, .box_w = 7, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 26643, .adv_w = 170, .box_w = 11, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 26709, .adv_w = 161, .box_w = 10, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 26754, .adv_w = 217, .box_w = 14, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 26817, .adv_w = 139, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 26853, .adv_w = 178, .box_w = 9, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 26894, .adv_w = 178, .box_w = 9, .box_h = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 26953, .adv_w = 153, .box_w = 9, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 26994, .adv_w = 164, .box_w = 9, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 27035, .adv_w = 204, .box_w = 11, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 27085, .adv_w = 174, .box_w = 9, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 27126, .adv_w = 164, .box_w = 10, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 27171, .adv_w = 173, .box_w = 9, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 27212, .adv_w = 176, .box_w = 10, .box_h = 12, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 27272, .adv_w = 146, .box_w = 9, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 27313, .adv_w = 126, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 27349, .adv_w = 146, .box_w = 11, .box_h = 12, .ofs_x = -1, .ofs_y = -3},
    {.bitmap_index = 27415, .adv_w = 206, .box_w = 13, .box_h = 16, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 27519, .adv_w = 138, .box_w = 9, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 27560, .adv_w = 177, .box_w = 10, .box_h = 12, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 27620, .adv_w = 156, .box_w = 9, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 27661, .adv_w = 241, .box_w = 13, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 27720, .adv_w = 241, .box_w = 14, .box_h = 11, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 27797, .adv_w = 164, .box_w = 10, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 27842, .adv_w = 207, .box_w = 11, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 27892, .adv_w = 147, .box_w = 8, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 27928, .adv_w = 147, .box_w = 9, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 27969, .adv_w = 224, .box_w = 13, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 28028, .adv_w = 157, .box_w = 9, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 28069, .adv_w = 162, .box_w = 10, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 28134, .adv_w = 161, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 28194, .adv_w = 173, .box_w = 11, .box_h = 16, .ofs_x = -1, .ofs_y = -3},
    {.bitmap_index = 28282, .adv_w = 125, .box_w = 7, .box_h = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 28328, .adv_w = 148, .box_w = 9, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 28369, .adv_w = 137, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 28405, .adv_w = 72, .box_w = 3, .box_h = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 28425, .adv_w = 71, .box_w = 5, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 28455, .adv_w = 73, .box_w = 6, .box_h = 17, .ofs_x = -2, .ofs_y = -3},
    {.bitmap_index = 28506, .adv_w = 239, .box_w = 15, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 28574, .adv_w = 244, .box_w = 14, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 28637, .adv_w = 173, .box_w = 11, .box_h = 13, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 28709, .adv_w = 153, .box_w = 9, .box_h = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 28768, .adv_w = 178, .box_w = 9, .box_h = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 28827, .adv_w = 146, .box_w = 11, .box_h = 16, .ofs_x = -1, .ofs_y = -3},
    {.bitmap_index = 28915, .adv_w = 165, .box_w = 8, .box_h = 11, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 28959, .adv_w = 208, .box_w = 13, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 29044, .adv_w = 157, .box_w = 10, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 29109, .adv_w = 230, .box_w = 15, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 29199, .adv_w = 180, .box_w = 12, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 29253, .adv_w = 217, .box_w = 13, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 29331, .adv_w = 166, .box_w = 10, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 29376, .adv_w = 195, .box_w = 12, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 29448, .adv_w = 153, .box_w = 10, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 29493, .adv_w = 218, .box_w = 13, .box_h = 18, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 29610, .adv_w = 183, .box_w = 10, .box_h = 15, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 29685, .adv_w = 189, .box_w = 12, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 29763, .adv_w = 155, .box_w = 10, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 29808, .adv_w = 188, .box_w = 10, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 29868, .adv_w = 179, .box_w = 10, .box_h = 12, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 29928, .adv_w = 149, .box_w = 9, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 29991, .adv_w = 119, .box_w = 7, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 30030, .adv_w = 158, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 30090, .adv_w = 132, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 30126, .adv_w = 180, .box_w = 10, .box_h = 15, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 30201, .adv_w = 154, .box_w = 9, .box_h = 12, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 30255, .adv_w = 273, .box_w = 17, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 30383, .adv_w = 226, .box_w = 14, .box_h = 11, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 30460, .adv_w = 164, .box_w = 10, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 30535, .adv_w = 139, .box_w = 8, .box_h = 11, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 30579, .adv_w = 193, .box_w = 11, .box_h = 15, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 30662, .adv_w = 153, .box_w = 10, .box_h = 11, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 30717, .adv_w = 189, .box_w = 11, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 30783, .adv_w = 157, .box_w = 9, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 30824, .adv_w = 188, .box_w = 12, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 30896, .adv_w = 153, .box_w = 10, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 30961, .adv_w = 212, .box_w = 13, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 31039, .adv_w = 172, .box_w = 11, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 31089, .adv_w = 217, .box_w = 13, .box_h = 15, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 31187, .adv_w = 179, .box_w = 10, .box_h = 11, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 31242, .adv_w = 278, .box_w = 17, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 31344, .adv_w = 227, .box_w = 14, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 31407, .adv_w = 306, .box_w = 18, .box_h = 15, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 31542, .adv_w = 250, .box_w = 15, .box_h = 12, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 31632, .adv_w = 249, .box_w = 15, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 31722, .adv_w = 206, .box_w = 12, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 31776, .adv_w = 184, .box_w = 12, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 31866, .adv_w = 146, .box_w = 9, .box_h = 11, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 31916, .adv_w = 154, .box_w = 10, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 31991, .adv_w = 126, .box_w = 8, .box_h = 11, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 32035, .adv_w = 171, .box_w = 11, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 32101, .adv_w = 147, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 32161, .adv_w = 171, .box_w = 11, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 32227, .adv_w = 147, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 32287, .adv_w = 180, .box_w = 12, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 32377, .adv_w = 138, .box_w = 10, .box_h = 11, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 32432, .adv_w = 249, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 32552, .adv_w = 197, .box_w = 12, .box_h = 11, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 32618, .adv_w = 195, .box_w = 12, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 32708, .adv_w = 162, .box_w = 10, .box_h = 11, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 32763, .adv_w = 188, .box_w = 11, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 32829, .adv_w = 156, .box_w = 9, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 32870, .adv_w = 188, .box_w = 10, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 32930, .adv_w = 173, .box_w = 9, .box_h = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 32989, .adv_w = 253, .box_w = 16, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 33085, .adv_w = 197, .box_w = 12, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 33139, .adv_w = 253, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 33259, .adv_w = 197, .box_w = 12, .box_h = 11, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 33325, .adv_w = 81, .box_w = 3, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 33343, .adv_w = 263, .box_w = 17, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 33471, .adv_w = 217, .box_w = 14, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 33562, .adv_w = 183, .box_w = 11, .box_h = 15, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 33645, .adv_w = 153, .box_w = 9, .box_h = 12, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 33699, .adv_w = 170, .box_w = 11, .box_h = 11, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 33760, .adv_w = 209, .box_w = 11, .box_h = 15, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 33843, .adv_w = 176, .box_w = 9, .box_h = 12, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 33897, .adv_w = 217, .box_w = 13, .box_h = 15, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 33995, .adv_w = 180, .box_w = 10, .box_h = 11, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 34050, .adv_w = 187, .box_w = 10, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 34125, .adv_w = 155, .box_w = 9, .box_h = 11, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 34175, .adv_w = 256, .box_w = 15, .box_h = 15, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 34288, .adv_w = 212, .box_w = 12, .box_h = 11, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 34354, .adv_w = 72, .box_w = 3, .box_h = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 34374, .adv_w = 194, .box_w = 12, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 34464, .adv_w = 151, .box_w = 10, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 34529, .adv_w = 194, .box_w = 12, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 34619, .adv_w = 151, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 34679, .adv_w = 268, .box_w = 16, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 34775, .adv_w = 255, .box_w = 16, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 34847, .adv_w = 170, .box_w = 9, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 34915, .adv_w = 162, .box_w = 10, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 34980, .adv_w = 211, .box_w = 13, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 35058, .adv_w = 161, .box_w = 10, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 35103, .adv_w = 211, .box_w = 13, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 35201, .adv_w = 161, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 35261, .adv_w = 263, .box_w = 17, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 35389, .adv_w = 217, .box_w = 14, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 35473, .adv_w = 164, .box_w = 10, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 35548, .adv_w = 139, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 35596, .adv_w = 159, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 35656, .adv_w = 135, .box_w = 9, .box_h = 12, .ofs_x = -1, .ofs_y = -3},
    {.bitmap_index = 35710, .adv_w = 211, .box_w = 11, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 35787, .adv_w = 178, .box_w = 9, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 35841, .adv_w = 211, .box_w = 11, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 35924, .adv_w = 178, .box_w = 9, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 35978, .adv_w = 217, .box_w = 13, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 36076, .adv_w = 164, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 36136, .adv_w = 217, .box_w = 13, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 36214, .adv_w = 166, .box_w = 10, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 36259, .adv_w = 217, .box_w = 13, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 36357, .adv_w = 166, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 36417, .adv_w = 181, .box_w = 11, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 36500, .adv_w = 147, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 36554, .adv_w = 177, .box_w = 11, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 36637, .adv_w = 146, .box_w = 11, .box_h = 15, .ofs_x = -1, .ofs_y = -3},
    {.bitmap_index = 36720, .adv_w = 177, .box_w = 11, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 36803, .adv_w = 146, .box_w = 11, .box_h = 15, .ofs_x = -1, .ofs_y = -3},
    {.bitmap_index = 36886, .adv_w = 177, .box_w = 11, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 36974, .adv_w = 146, .box_w = 11, .box_h = 16, .ofs_x = -1, .ofs_y = -3},
    {.bitmap_index = 37062, .adv_w = 188, .box_w = 11, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 37145, .adv_w = 156, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 37199, .adv_w = 148, .box_w = 9, .box_h = 15, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 37267, .adv_w = 125, .box_w = 7, .box_h = 11, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 37306, .adv_w = 254, .box_w = 14, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 37411, .adv_w = 207, .box_w = 11, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 37477, .adv_w = 158, .box_w = 10, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 37552, .adv_w = 126, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 37600, .adv_w = 172, .box_w = 11, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 37683, .adv_w = 138, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 37737, .adv_w = 175, .box_w = 11, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 37803, .adv_w = 146, .box_w = 9, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 37844, .adv_w = 164, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 37904, .adv_w = 139, .box_w = 9, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 37945, .adv_w = 202, .box_w = 11, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 38028, .adv_w = 164, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 38082, .adv_w = 219, .box_w = 14, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 38187, .adv_w = 176, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 38247, .adv_w = 278, .box_w = 18, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 38355, .adv_w = 240, .box_w = 15, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 38423, .adv_w = 217, .box_w = 13, .box_h = 15, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 38521, .adv_w = 173, .box_w = 10, .box_h = 11, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 38576, .adv_w = 206, .box_w = 12, .box_h = 15, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 38666, .adv_w = 179, .box_w = 10, .box_h = 15, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 38741, .adv_w = 209, .box_w = 14, .box_h = 15, .ofs_x = -2, .ofs_y = -3},
    {.bitmap_index = 38846, .adv_w = 174, .box_w = 12, .box_h = 12, .ofs_x = -2, .ofs_y = -3},
    {.bitmap_index = 38918, .adv_w = 209, .box_w = 13, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 39016, .adv_w = 169, .box_w = 11, .box_h = 11, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 39077, .adv_w = 179, .box_w = 0, .box_h = 0, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 39077, .adv_w = 58, .box_w = 0, .box_h = 0, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 39077, .adv_w = 34, .box_w = 0, .box_h = 0, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 39077, .adv_w = 26, .box_w = 0, .box_h = 0, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 39077, .adv_w = 0, .box_w = 0, .box_h = 0, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 39077, .adv_w = 98, .box_w = 6, .box_h = 3, .ofs_x = 0, .ofs_y = 3},
    {.bitmap_index = 39086, .adv_w = 179, .box_w = 11, .box_h = 2, .ofs_x = 0, .ofs_y = 5},
    {.bitmap_index = 39097, .adv_w = 128, .box_w = 8, .box_h = 2, .ofs_x = 0, .ofs_y = 3},
    {.bitmap_index = 39105, .adv_w = 256, .box_w = 16, .box_h = 2, .ofs_x = 0, .ofs_y = 3},
    {.bitmap_index = 39121, .adv_w = 256, .box_w = 17, .box_h = 2, .ofs_x = -1, .ofs_y = 3},
    {.bitmap_index = 39138, .adv_w = 58, .box_w = 3, .box_h = 5, .ofs_x = 0, .ofs_y = 7},
    {.bitmap_index = 39146, .adv_w = 58, .box_w = 3, .box_h = 5, .ofs_x = 0, .ofs_y = 7},
    {.bitmap_index = 39154, .adv_w = 58, .box_w = 3, .box_h = 5, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 39162, .adv_w = 106, .box_w = 6, .box_h = 5, .ofs_x = 0, .ofs_y = 7},
    {.bitmap_index = 39177, .adv_w = 106, .box_w = 6, .box_h = 5, .ofs_x = 0, .ofs_y = 7},
    {.bitmap_index = 39192, .adv_w = 106, .box_w = 6, .box_h = 5, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 39207, .adv_w = 143, .box_w = 9, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 39275, .adv_w = 143, .box_w = 9, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 39343, .adv_w = 80, .box_w = 3, .box_h = 4, .ofs_x = 1, .ofs_y = 3},
    {.bitmap_index = 39349, .adv_w = 177, .box_w = 11, .box_h = 3, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 39366, .adv_w = 310, .box_w = 19, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 39480, .adv_w = 54, .box_w = 2, .box_h = 5, .ofs_x = 1, .ofs_y = 7},
    {.bitmap_index = 39485, .adv_w = 100, .box_w = 5, .box_h = 5, .ofs_x = 1, .ofs_y = 7},
    {.bitmap_index = 39498, .adv_w = 80, .box_w = 5, .box_h = 7, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 39516, .adv_w = 80, .box_w = 5, .box_h = 7, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 39534, .adv_w = 45, .box_w = 10, .box_h = 12, .ofs_x = -4, .ofs_y = 0},
    {.bitmap_index = 39594, .adv_w = 138, .box_w = 7, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 39636, .adv_w = 110, .box_w = 7, .box_h = 7, .ofs_x = 0, .ofs_y = 5},
    {.bitmap_index = 39661, .adv_w = 110, .box_w = 7, .box_h = 7, .ofs_x = 0, .ofs_y = 5},
    {.bitmap_index = 39686, .adv_w = 110, .box_w = 7, .box_h = 7, .ofs_x = 0, .ofs_y = 5},
    {.bitmap_index = 39711, .adv_w = 110, .box_w = 7, .box_h = 7, .ofs_x = 0, .ofs_y = 5},
    {.bitmap_index = 39736, .adv_w = 110, .box_w = 7, .box_h = 7, .ofs_x = 0, .ofs_y = 5},
    {.bitmap_index = 39761, .adv_w = 110, .box_w = 7, .box_h = 7, .ofs_x = 0, .ofs_y = 5},
    {.bitmap_index = 39786, .adv_w = 110, .box_w = 7, .box_h = 7, .ofs_x = 0, .ofs_y = 5},
    {.bitmap_index = 39811, .adv_w = 110, .box_w = 7, .box_h = 7, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 39836, .adv_w = 110, .box_w = 5, .box_h = 7, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 39854, .adv_w = 110, .box_w = 7, .box_h = 7, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 39879, .adv_w = 110, .box_w = 7, .box_h = 7, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 39904, .adv_w = 110, .box_w = 7, .box_h = 7, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 39929, .adv_w = 110, .box_w = 7, .box_h = 7, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 39954, .adv_w = 110, .box_w = 7, .box_h = 7, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 39979, .adv_w = 110, .box_w = 7, .box_h = 7, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 40004, .adv_w = 110, .box_w = 7, .box_h = 7, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 40029, .adv_w = 110, .box_w = 7, .box_h = 7, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 40054, .adv_w = 185, .box_w = 11, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 40142, .adv_w = 170, .box_w = 11, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 40208, .adv_w = 165, .box_w = 11, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 40274, .adv_w = 225, .box_w = 14, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 40358, .adv_w = 420, .box_w = 25, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 40508, .adv_w = 306, .box_w = 19, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 40622, .adv_w = 175, .box_w = 11, .box_h = 14, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 40699, .adv_w = 207, .box_w = 13, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 40777, .adv_w = 169, .box_w = 11, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 40843, .adv_w = 175, .box_w = 11, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 40909, .adv_w = 216, .box_w = 14, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 40993, .adv_w = 198, .box_w = 12, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 41089, .adv_w = 211, .box_w = 11, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 41155, .adv_w = 185, .box_w = 11, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 41243, .adv_w = 185, .box_w = 10, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 41303, .adv_w = 184, .box_w = 11, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 41369, .adv_w = 182, .box_w = 11, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 41435, .adv_w = 234, .box_w = 12, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 41519, .adv_w = 192, .box_w = 12, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 41591, .adv_w = 120, .box_w = 7, .box_h = 13, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 41637, .adv_w = 308, .box_w = 18, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 41745, .adv_w = 263, .box_w = 15, .box_h = 8, .ofs_x = 0, .ofs_y = 4},
    {.bitmap_index = 41805, .adv_w = 230, .box_w = 15, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 41895, .adv_w = 184, .box_w = 11, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 41961, .adv_w = 187, .box_w = 13, .box_h = 16, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 42065, .adv_w = 225, .box_w = 14, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 42149, .adv_w = 265, .box_w = 15, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 42239, .adv_w = 265, .box_w = 16, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 42335, .adv_w = 265, .box_w = 16, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 42431, .adv_w = 265, .box_w = 17, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 42533, .adv_w = 265, .box_w = 17, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 42635, .adv_w = 265, .box_w = 17, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 42737, .adv_w = 154, .box_w = 8, .box_h = 7, .ofs_x = 1, .ofs_y = 1},
    {.bitmap_index = 42765, .adv_w = 154, .box_w = 7, .box_h = 8, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 42793, .adv_w = 154, .box_w = 8, .box_h = 7, .ofs_x = 1, .ofs_y = 1},
    {.bitmap_index = 42821, .adv_w = 154, .box_w = 7, .box_h = 8, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 42849, .adv_w = 187, .box_w = 11, .box_h = 7, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 42888, .adv_w = 154, .box_w = 7, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 42927, .adv_w = 154, .box_w = 7, .box_h = 7, .ofs_x = 1, .ofs_y = 1},
    {.bitmap_index = 42952, .adv_w = 154, .box_w = 8, .box_h = 7, .ofs_x = 1, .ofs_y = 1},
    {.bitmap_index = 42980, .adv_w = 154, .box_w = 8, .box_h = 7, .ofs_x = 1, .ofs_y = 1},
    {.bitmap_index = 43008, .adv_w = 154, .box_w = 7, .box_h = 7, .ofs_x = 1, .ofs_y = 1},
    {.bitmap_index = 43033, .adv_w = 179, .box_w = 10, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 43098, .adv_w = 149, .box_w = 9, .box_h = 9, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 43139, .adv_w = 187, .box_w = 13, .box_h = 12, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 43217, .adv_w = 208, .box_w = 11, .box_h = 16, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 43305, .adv_w = 168, .box_w = 11, .box_h = 16, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 43393, .adv_w = 149, .box_w = 8, .box_h = 3, .ofs_x = 1, .ofs_y = 4},
    {.bitmap_index = 43405, .adv_w = 90, .box_w = 8, .box_h = 16, .ofs_x = -1, .ofs_y = -2},
    {.bitmap_index = 43469, .adv_w = 73, .box_w = 3, .box_h = 3, .ofs_x = 1, .ofs_y = 4},
    {.bitmap_index = 43474, .adv_w = 206, .box_w = 12, .box_h = 16, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 43570, .adv_w = 236, .box_w = 15, .box_h = 7, .ofs_x = 0, .ofs_y = 2},
    {.bitmap_index = 43623, .adv_w = 102, .box_w = 8, .box_h = 16, .ofs_x = -1, .ofs_y = -4},
    {.bitmap_index = 43687, .adv_w = 149, .box_w = 9, .box_h = 7, .ofs_x = 0, .ofs_y = 2},
    {.bitmap_index = 43719, .adv_w = 149, .box_w = 8, .box_h = 10, .ofs_x = 1, .ofs_y = 1},
    {.bitmap_index = 43759, .adv_w = 149, .box_w = 8, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 43799, .adv_w = 149, .box_w = 8, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 43839, .adv_w = 154, .box_w = 7, .box_h = 7, .ofs_x = 1, .ofs_y = 1},
    {.bitmap_index = 43864, .adv_w = 154, .box_w = 7, .box_h = 7, .ofs_x = 1, .ofs_y = 1},
    {.bitmap_index = 43889, .adv_w = 154, .box_w = 8, .box_h = 8, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 43921, .adv_w = 154, .box_w = 8, .box_h = 7, .ofs_x = 1, .ofs_y = 1},
    {.bitmap_index = 43949, .adv_w = 154, .box_w = 8, .box_h = 8, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 43981, .adv_w = 154, .box_w = 7, .box_h = 8, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 44009, .adv_w = 154, .box_w = 8, .box_h = 8, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 44041, .adv_w = 154, .box_w = 8, .box_h = 8, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 44073, .adv_w = 154, .box_w = 8, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 44105, .adv_w = 154, .box_w = 8, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 44137, .adv_w = 154, .box_w = 10, .box_h = 10, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 44187, .adv_w = 154, .box_w = 10, .box_h = 10, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 44237, .adv_w = 128, .box_w = 8, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 44281, .adv_w = 84, .box_w = 5, .box_h = 16, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 44321, .adv_w = 84, .box_w = 5, .box_h = 16, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 44361, .adv_w = 66, .box_w = 2, .box_h = 7, .ofs_x = 1, .ofs_y = 5},
    {.bitmap_index = 44368, .adv_w = 65, .box_w = 2, .box_h = 7, .ofs_x = 1, .ofs_y = 5},
    {.bitmap_index = 44375, .adv_w = 162, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 44429, .adv_w = 162, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0}
};

/*---------------------
 *  CHARACTER MAPPING
 *--------------------*/

static const uint8_t glyph_id_ofs_list_2[] = {
    0, 0, 1, 0, 2, 3, 4, 0,
    5
};

static const uint16_t unicode_list_6[] = {
    0x0, 0x1, 0x8, 0x9, 0x10, 0x11, 0x12, 0x13
};

static const uint16_t unicode_list_9[] = {
    0x0, 0x1, 0x2, 0x3, 0xa, 0xb, 0xc, 0xd,
    0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1e, 0x1f,
    0x1af7, 0x1af8, 0x1af9, 0x1afa, 0x1afb, 0x1b00, 0x1b02, 0x1b03,
    0x1b04, 0x1b05, 0x1b08, 0x1b09, 0x1b0a, 0x1b0c, 0x1b0d, 0x1b0e,
    0x1b10, 0x1b11, 0x1b12, 0x1b16, 0x1b20, 0x1b22, 0x1b23, 0x1b29,
    0x1b2a, 0x1b34, 0x1b42, 0x1b60, 0x1b64, 0x1b65, 0x1b66, 0x1b67,
    0x1b68, 0x1b69, 0x1b70, 0x1b71, 0x1b72, 0x1b73, 0x1b74, 0x1b75,
    0x1b76, 0x1b77, 0x1b78, 0x1b79, 0x1b91, 0x1b93, 0x1b94, 0x1b96,
    0x1b97, 0x1b99, 0x1b9b, 0x1b9c, 0x1b9d, 0x1b9e, 0x1ba1, 0x1ba2,
    0x1ba4, 0x1ba5, 0x1ba8, 0x1ba9, 0x1baa, 0x1bac, 0x1bad, 0x1c03,
    0x1c06, 0x1c12, 0x1c16, 0x1c1a, 0x1c1b, 0x1c1e, 0x1c43, 0x1c44,
    0x1c4b, 0x1c4c, 0x1c4d, 0x1c4e, 0x1c80, 0x1c81, 0x1c82, 0x1c83,
    0x1c84, 0x1c85, 0x1c86, 0x1c87, 0x1c88, 0x1c89, 0x1cf2, 0x1cf5,
    0x1cf6, 0x1cff, 0x1d01, 0x1d02, 0x1d05, 0x1d09, 0x1d0a, 0x1d0e,
    0x1d1b, 0x1d38, 0x1d50, 0x1d54, 0x1d55, 0x2090, 0x2091, 0x20a2,
    0x20a3, 0x20a6, 0x20a7, 0x20ac, 0x20ad, 0x20b0, 0x20b1, 0x20b6,
    0x20b7, 0x20ba, 0x22d8, 0x22d9, 0xa27b, 0xa27c, 0xf5f1, 0xf5f2
};

/*Collect the unicode lists and glyph_id offsets*/
static const lv_font_fmt_txt_cmap_t cmaps[] =
{
    {
        .range_start = 32, .range_length = 95, .glyph_id_start = 1,
        .unicode_list = NULL, .glyph_id_ofs_list = NULL, .list_length = 0, .type = LV_FONT_FMT_TXT_CMAP_FORMAT0_TINY
    },
    {
        .range_start = 160, .range_length = 224, .glyph_id_start = 96,
        .unicode_list = NULL, .glyph_id_ofs_list = NULL, .list_length = 0, .type = LV_FONT_FMT_TXT_CMAP_FORMAT0_TINY
    },
    {
        .range_start = 900, .range_length = 9, .glyph_id_start = 320,
        .unicode_list = NULL, .glyph_id_ofs_list = glyph_id_ofs_list_2, .list_length = 9, .type = LV_FONT_FMT_TXT_CMAP_FORMAT0_FULL
    },
    {
        .range_start = 910, .range_length = 20, .glyph_id_start = 326,
        .unicode_list = NULL, .glyph_id_ofs_list = NULL, .list_length = 0, .type = LV_FONT_FMT_TXT_CMAP_FORMAT0_TINY
    },
    {
        .range_start = 931, .range_length = 44, .glyph_id_start = 346,
        .unicode_list = NULL, .glyph_id_ofs_list = NULL, .list_length = 0, .type = LV_FONT_FMT_TXT_CMAP_FORMAT0_TINY
    },
    {
        .range_start = 1024, .range_length = 96, .glyph_id_start = 390,
        .unicode_list = NULL, .glyph_id_ofs_list = NULL, .list_length = 0, .type = LV_FONT_FMT_TXT_CMAP_FORMAT0_TINY
    },
    {
        .range_start = 1122, .range_length = 20, .glyph_id_start = 486,
        .unicode_list = unicode_list_6, .glyph_id_ofs_list = NULL, .list_length = 8, .type = LV_FONT_FMT_TXT_CMAP_SPARSE_TINY
    },
    {
        .range_start = 1162, .range_length = 59, .glyph_id_start = 494,
        .unicode_list = NULL, .glyph_id_ofs_list = NULL, .list_length = 0, .type = LV_FONT_FMT_TXT_CMAP_FORMAT0_TINY
    },
    {
        .range_start = 1222, .range_length = 58, .glyph_id_start = 553,
        .unicode_list = NULL, .glyph_id_ofs_list = NULL, .list_length = 0, .type = LV_FONT_FMT_TXT_CMAP_FORMAT0_TINY
    },
    {
        .range_start = 1296, .range_length = 62963, .glyph_id_start = 611,
        .unicode_list = unicode_list_9, .glyph_id_ofs_list = NULL, .list_length = 136, .type = LV_FONT_FMT_TXT_CMAP_SPARSE_TINY
    }
};



/*--------------------
 *  ALL CUSTOM DATA
 *--------------------*/

#if LVGL_VERSION_MAJOR == 8
/*Store all the custom data of the font*/
static  lv_font_fmt_txt_glyph_cache_t cache;
#endif

#if LVGL_VERSION_MAJOR >= 8
static const lv_font_fmt_txt_dsc_t font_dsc = {
#else
static lv_font_fmt_txt_dsc_t font_dsc = {
#endif
    .glyph_bitmap = glyph_bitmap,
    .glyph_dsc = glyph_dsc,
    .cmaps = cmaps,
    .kern_dsc = NULL,
    .kern_scale = 0,
    .cmap_num = 10,
    .bpp = 4,
    .kern_classes = 0,
    .bitmap_format = 0,
#if LVGL_VERSION_MAJOR == 8
    .cache = &cache
#endif
};



/*-----------------
 *  PUBLIC FONT
 *----------------*/

/*Initialize a public general font descriptor*/
#if LVGL_VERSION_MAJOR >= 8
const lv_font_t ui_font_montserrat_16 = {
#else
lv_font_t ui_font_montserrat_16 = {
#endif
    .get_glyph_dsc = lv_font_get_glyph_dsc_fmt_txt,    /*Function pointer to get glyph's data*/
    .get_glyph_bitmap = lv_font_get_bitmap_fmt_txt,    /*Function pointer to get glyph's bitmap*/
    .line_height = 22,          /*The maximum line height required by the font*/
    .base_line = 5,             /*Baseline measured from the bottom of the line*/
#if !(LVGL_VERSION_MAJOR == 6 && LVGL_VERSION_MINOR == 0)
    .subpx = LV_FONT_SUBPX_NONE,
#endif
#if LV_VERSION_CHECK(7, 4, 0) || LVGL_VERSION_MAJOR >= 8
    .underline_position = -2,
    .underline_thickness = 1,
#endif
    .dsc = &font_dsc,          /*The custom font data. Will be accessed by `get_glyph_bitmap/dsc` */
#if LV_VERSION_CHECK(8, 2, 0) || LVGL_VERSION_MAJOR >= 9
    .fallback = NULL,
#endif
    .user_data = NULL,
};



#endif /*#if UI_FONT_MONTSERRAT_16*/

