#if HAS_TFT && defined(VIEW_480x222)

#include "graphics/view/TFT/TFTView_480x222.h"
#include "graphics/common/ViewController.h"
#include "graphics/driver/DisplayDriverFactory.h"
#include "ui.h" // this is the ui generated by eez-studio / lvgl
#include "util/ILog.h"
#include <cstdio>
#include <ctime>
#include <functional>

TFTView_480x222 *TFTView_480x222::gui = nullptr;

TFTView_480x222 *TFTView_480x222::instance(void)
{
    if (!gui)
        gui = new TFTView_480x222(nullptr, DisplayDriverFactory::create(480, 320));
    return gui;
}

TFTView_480x222 *TFTView_480x222::instance(const DisplayDriverConfig &cfg)
{
    if (!gui)
        gui = new TFTView_480x222(&cfg, DisplayDriverFactory::create(cfg));
    return gui;
}

TFTView_480x222::TFTView_480x222(const DisplayDriverConfig *cfg, DisplayDriver *driver)
    : MeshtasticView(cfg, driver, new ViewController)
{
}

void TFTView_480x222::init(IClientBase *client)
{
    ILOG_DEBUG("TFTView_480x222 init...");
    MeshtasticView::init(client);
    ui_init();
}

void TFTView_480x222::task_handler(void)
{
    MeshtasticView::task_handler();
}

#endif