
# Renesas RA: development platform for [PlatformIO](https://platformio.org)

Renesas Advanced (RA) 32-bit microcontrollers with the Arm Cortex-M33, -M23 and -M4 processor cores deliver key advantages compared to competitive Arm Cortex-M MCUs by providing stronger embedded security, superior CoreMark performance and ultra-low power operation.

* [Home](https://platformio.org/platforms/renesas-ra) (home page in PlatformIO Registry)
* [Documentation](https://docs.platformio.org/page/platforms/renesas-ra.html) (advanced usage, packages, boards, frameworks, etc.)

# Examples

* [arduino-blink](https://github.com/platformio/platform-renesas-ra/tree/master/examples/arduino-blink)
* [arduino-internal-libs](https://github.com/platformio/platform-renesas-ra/tree/master/examples/arduino-internal-libs)
* [arduino-uno-r4-led-animation](https://github.com/platformio/platform-renesas-ra/tree/master/examples/arduino-uno-r4-led-animation)
* [arduino-wifiscan](https://github.com/platformio/platform-renesas-ra/tree/master/examples/arduino-wifiscan)
* [cmsis-blink](https://github.com/platformio/platform-renesas-ra/tree/master/examples/cmsis-blink)
* [fsp-blink](https://github.com/platformio/platform-renesas-ra/tree/master/examples/fsp-blink)
* [fsp-button-isr](https://github.com/platformio/platform-renesas-ra/tree/master/examples/fsp-button-isr)
