
# RISC-V GAP: development platform for [PlatformIO](https://platformio.org)

GreenWaves GAP8 IoT application processor enables the cost-effective development, deployment and autonomous operation of intelligent sensing devices that capture, analyze, classify and act on the fusion of rich data sources such as images, sounds or vibrations.

* [Home](https://platformio.org/platforms/riscv_gap) (home page in PlatformIO Registry)
* [Documentation](https://docs.platformio.org/page/platforms/riscv_gap.html) (advanced usage, packages, boards, frameworks, etc.)

# Examples

* [gapuino-mbed-autotiler-cifar10](https://github.com/platformio/platform-riscv_gap/tree/master/examples/gapuino-mbed-autotiler-cifar10)
* [gapuino-mbed-driver-cpp-raw-serial](https://github.com/platformio/platform-riscv_gap/tree/master/examples/gapuino-mbed-driver-cpp-raw-serial)
* [gapuino-mbed-driver-hyper-flash](https://github.com/platformio/platform-riscv_gap/tree/master/examples/gapuino-mbed-driver-hyper-flash)
* [gapuino-mbed-driver-hyper-rtc-alarm](https://github.com/platformio/platform-riscv_gap/tree/master/examples/gapuino-mbed-driver-hyper-rtc-alarm)
* [gapuino-mbed-events-queue](https://github.com/platformio/platform-riscv_gap/tree/master/examples/gapuino-mbed-events-queue)
* [gapuino-mbed-features-cluster-dma](https://github.com/platformio/platform-riscv_gap/tree/master/examples/gapuino-mbed-features-cluster-dma)
* [gapuino-mbed-features-filesystem](https://github.com/platformio/platform-riscv_gap/tree/master/examples/gapuino-mbed-features-filesystem)
* [gapuino-mbed-fft2d](https://github.com/platformio/platform-riscv_gap/tree/master/examples/gapuino-mbed-fft2d)
* [gapuino-mbed-matadd](https://github.com/platformio/platform-riscv_gap/tree/master/examples/gapuino-mbed-matadd)
* [gapuino-mbed-os-irq](https://github.com/platformio/platform-riscv_gap/tree/master/examples/gapuino-mbed-os-irq)
* [gapuino-mbed-os-memory-pool](https://github.com/platformio/platform-riscv_gap/tree/master/examples/gapuino-mbed-os-memory-pool)
* [gapuino-pulp-os-autotiler-bilinear-resize](https://github.com/platformio/platform-riscv_gap/tree/master/examples/gapuino-pulp-os-autotiler-bilinear-resize)
* [gapuino-pulp-os-autotiler-cifar10](https://github.com/platformio/platform-riscv_gap/tree/master/examples/gapuino-pulp-os-autotiler-cifar10)
* [gapuino-pulp-os-filesystem](https://github.com/platformio/platform-riscv_gap/tree/master/examples/gapuino-pulp-os-filesystem)
* [gapuino-pulp-os-hello-world](https://github.com/platformio/platform-riscv_gap/tree/master/examples/gapuino-pulp-os-hello-world)
* [gapuino-pulp-os-i2c-eeprom](https://github.com/platformio/platform-riscv_gap/tree/master/examples/gapuino-pulp-os-i2c-eeprom)
* [gapuino-pulp-os-kernel-dma](https://github.com/platformio/platform-riscv_gap/tree/master/examples/gapuino-pulp-os-kernel-dma)
