/*****************************************************************************
 *
 * Copyright (C) 2009  Florian Pose <fp@igh-essen.com>
 *
 * This file is part of the QtPdWidgets library.
 *
 * The QtPdWidgets library is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the License,
 * or (at your option) any later version.
 *
 * The QtPdWidgets library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
 * General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with the QtPdWidgets Library. If not, see
 * <http://www.gnu.org/licenses/>.
 *
 ****************************************************************************/

#include "Translator.h"

#include <QTranslator>
#include <QCoreApplication>

static void loadRcc() {
    Q_INIT_RESOURCE(QtPdWidgets_ts);
}

namespace Pd {


/****************************************************************************/

/** Load a translation.
 */
bool loadTranslation(QTranslator& translator, const QLocale &locale)
{
    loadRcc();
    const bool ans = translator.load(locale, "QtPdWidgets", "_", ":/QtPdWidgets");
    // all widgets are in english per default, so no need to have a ts file
    if (locale.language() == QLocale::English)
        return true;
    return ans;
}

/****************************************************************************/

} // namespace Pd
