; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=x86_64-linux-gnu -global-isel -verify-machineinstrs < %s -o - | FileCheck %s --check-prefix=X64
; RUN: llc -mtriple=i686-linux-gnu -global-isel -verify-machineinstrs < %s -o - | FileCheck %s --check-prefix=X86

define i8 @test_mul_i8(i8 %arg1, i8 %arg2) nounwind {
; X64-LABEL: test_mul_i8:
; X64:       # %bb.0:
; X64-NEXT:    movsbl %dil, %eax
; X64-NEXT:    imulb %sil
; X64-NEXT:    retq
;
; X86-LABEL: test_mul_i8:
; X86:       # %bb.0:
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    cbtw
; X86-NEXT:    imulb %cl
; X86-NEXT:    retl
  %ret = mul i8 %arg1, %arg2
  ret i8 %ret
}

define i16 @test_mul_i16(i16 %arg1, i16 %arg2) nounwind {
; X64-LABEL: test_mul_i16:
; X64:       # %bb.0:
; X64-NEXT:    movl %esi, %eax
; X64-NEXT:    imulw %di, %ax
; X64-NEXT:    # kill: def $ax killed $ax killed $eax
; X64-NEXT:    retq
;
; X86-LABEL: test_mul_i16:
; X86:       # %bb.0:
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    imulw %cx, %ax
; X86-NEXT:    # kill: def $ax killed $ax killed $eax
; X86-NEXT:    retl
  %ret = mul i16 %arg1, %arg2
  ret i16 %ret
}

define i32 @test_mul_i32(i32 %arg1, i32 %arg2) nounwind {
; X64-LABEL: test_mul_i32:
; X64:       # %bb.0:
; X64-NEXT:    movl %esi, %eax
; X64-NEXT:    imull %edi, %eax
; X64-NEXT:    retq
;
; X86-LABEL: test_mul_i32:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    imull {{[0-9]+}}(%esp), %eax
; X86-NEXT:    retl
  %ret = mul i32 %arg1, %arg2
  ret i32 %ret
}

define i64 @test_mul_i64(i64 %arg1, i64 %arg2) nounwind {
; X64-LABEL: test_mul_i64:
; X64:       # %bb.0:
; X64-NEXT:    movq %rsi, %rax
; X64-NEXT:    imulq %rdi, %rax
; X64-NEXT:    retq
;
; X86-LABEL: test_mul_i64:
; X86:       # %bb.0:
; X86-NEXT:    pushl %edi
; X86-NEXT:    pushl %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    imull %edx, %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-NEXT:    imull %edx, %edi
; X86-NEXT:    imull {{[0-9]+}}(%esp), %esi
; X86-NEXT:    addl %edi, %esi
; X86-NEXT:    mull %edx
; X86-NEXT:    addl %esi, %edx
; X86-NEXT:    movl %ecx, %eax
; X86-NEXT:    popl %esi
; X86-NEXT:    popl %edi
; X86-NEXT:    retl
  %ret = mul i64 %arg1, %arg2
  ret i64 %ret
}

;TODO: instruction selection not supported yet
;define i128 @test_mul_i128(i128 %arg1, i128 %arg2) nounwind {
;  %ret = mul i128 %arg1, %arg2
;  ret i128 %ret
;}
