; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-apple-darwin -mcpu=knl -mattr=+avx512vl | FileCheck %s --check-prefix=CHECK --check-prefix=KNL
; RUN: llc < %s -mtriple=x86_64-apple-darwin -mcpu=skx -mattr=+avx512vl | FileCheck %s --check-prefix=CHECK --check-prefix=SKX

; 256-bit

define <8 x i32> @vpandd256(<8 x i32> %a, <8 x i32> %b) nounwind uwtable readnone ssp {
; CHECK-LABEL: vpandd256:
; CHECK:       ## %bb.0: ## %entry
; CHECK-NEXT:    vpaddd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to8}, %ymm0, %ymm0
; CHECK-NEXT:    vpand %ymm1, %ymm0, %ymm0
; CHECK-NEXT:    retq
entry:
  ; Force the execution domain with an add.
  %a2 = add <8 x i32> %a, <i32 2, i32 2, i32 2, i32 2, i32 2, i32 2, i32 2, i32 2>
  %x = and <8 x i32> %a2, %b
  ret <8 x i32> %x
}

define <8 x i32> @vpandnd256(<8 x i32> %a, <8 x i32> %b) nounwind uwtable readnone ssp {
; CHECK-LABEL: vpandnd256:
; CHECK:       ## %bb.0: ## %entry
; CHECK-NEXT:    vpaddd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to8}, %ymm0, %ymm1
; CHECK-NEXT:    vpandn %ymm1, %ymm0, %ymm0
; CHECK-NEXT:    retq
entry:
  ; Force the execution domain with an add.
  %a2 = add <8 x i32> %a, <i32 3, i32 3, i32 3, i32 3, i32 3, i32 3, i32 3, i32 3>
  %b2 = xor <8 x i32> %a, <i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1>
  %x = and <8 x i32> %a2, %b2
  ret <8 x i32> %x
}

define <8 x i32> @vpord256(<8 x i32> %a, <8 x i32> %b) nounwind uwtable readnone ssp {
; CHECK-LABEL: vpord256:
; CHECK:       ## %bb.0: ## %entry
; CHECK-NEXT:    vpaddd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to8}, %ymm0, %ymm0
; CHECK-NEXT:    vpor %ymm1, %ymm0, %ymm0
; CHECK-NEXT:    retq
entry:
  ; Force the execution domain with an add.
  %a2 = add <8 x i32> %a, <i32 4, i32 4, i32 4, i32 4, i32 4, i32 4, i32 4, i32 4>
  %x = or <8 x i32> %a2, %b
  ret <8 x i32> %x
}

define <8 x i32> @vpxord256(<8 x i32> %a, <8 x i32> %b) nounwind uwtable readnone ssp {
; CHECK-LABEL: vpxord256:
; CHECK:       ## %bb.0: ## %entry
; CHECK-NEXT:    vpaddd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to8}, %ymm0, %ymm0
; CHECK-NEXT:    vpxor %ymm1, %ymm0, %ymm0
; CHECK-NEXT:    retq
entry:
  ; Force the execution domain with an add.
  %a2 = add <8 x i32> %a, <i32 5, i32 5, i32 5, i32 5, i32 5, i32 5, i32 5, i32 5>
  %x = xor <8 x i32> %a2, %b
  ret <8 x i32> %x
}

define <4 x i64> @vpandq256(<4 x i64> %a, <4 x i64> %b) nounwind uwtable readnone ssp {
; CHECK-LABEL: vpandq256:
; CHECK:       ## %bb.0: ## %entry
; CHECK-NEXT:    vpaddq {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %ymm0, %ymm0
; CHECK-NEXT:    vpand %ymm1, %ymm0, %ymm0
; CHECK-NEXT:    retq
entry:
  ; Force the execution domain with an add.
  %a2 = add <4 x i64> %a, <i64 6, i64 6, i64 6, i64 6>
  %x = and <4 x i64> %a2, %b
  ret <4 x i64> %x
}

define <4 x i64> @vpandnq256(<4 x i64> %a, <4 x i64> %b) nounwind uwtable readnone ssp {
; CHECK-LABEL: vpandnq256:
; CHECK:       ## %bb.0: ## %entry
; CHECK-NEXT:    vpaddq {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %ymm0, %ymm0
; CHECK-NEXT:    vpandn %ymm0, %ymm1, %ymm0
; CHECK-NEXT:    retq
entry:
  ; Force the execution domain with an add.
  %a2 = add <4 x i64> %a, <i64 7, i64 7, i64 7, i64 7>
  %b2 = xor <4 x i64> %b, <i64 -1, i64 -1, i64 -1, i64 -1>
  %x = and <4 x i64> %a2, %b2
  ret <4 x i64> %x
}

define <4 x i64> @vporq256(<4 x i64> %a, <4 x i64> %b) nounwind uwtable readnone ssp {
; CHECK-LABEL: vporq256:
; CHECK:       ## %bb.0: ## %entry
; CHECK-NEXT:    vpaddq {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %ymm0, %ymm0
; CHECK-NEXT:    vpor %ymm1, %ymm0, %ymm0
; CHECK-NEXT:    retq
entry:
  ; Force the execution domain with an add.
  %a2 = add <4 x i64> %a, <i64 21, i64 21, i64 21, i64 21>
  %x = or <4 x i64> %a2, %b
  ret <4 x i64> %x
}

define <4 x i64> @vpxorq256(<4 x i64> %a, <4 x i64> %b) nounwind uwtable readnone ssp {
; CHECK-LABEL: vpxorq256:
; CHECK:       ## %bb.0: ## %entry
; CHECK-NEXT:    vpaddq {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %ymm0, %ymm0
; CHECK-NEXT:    vpxor %ymm1, %ymm0, %ymm0
; CHECK-NEXT:    retq
entry:
  ; Force the execution domain with an add.
  %a2 = add <4 x i64> %a, <i64 22, i64 22, i64 22, i64 22>
  %x = xor <4 x i64> %a2, %b
  ret <4 x i64> %x
}

; 128-bit

define <4 x i32> @vpandd128(<4 x i32> %a, <4 x i32> %b) nounwind uwtable readnone ssp {
; CHECK-LABEL: vpandd128:
; CHECK:       ## %bb.0: ## %entry
; CHECK-NEXT:    vpaddd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %xmm0, %xmm0
; CHECK-NEXT:    vpand %xmm1, %xmm0, %xmm0
; CHECK-NEXT:    retq
entry:
  ; Force the execution domain with an add.
  %a2 = add <4 x i32> %a, <i32 8, i32 8, i32 8, i32 8>
  %x = and <4 x i32> %a2, %b
  ret <4 x i32> %x
}

define <4 x i32> @vpandnd128(<4 x i32> %a, <4 x i32> %b) nounwind uwtable readnone ssp {
; CHECK-LABEL: vpandnd128:
; CHECK:       ## %bb.0: ## %entry
; CHECK-NEXT:    vpaddd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %xmm0, %xmm0
; CHECK-NEXT:    vpandn %xmm0, %xmm1, %xmm0
; CHECK-NEXT:    retq
entry:
  ; Force the execution domain with an add.
  %a2 = add <4 x i32> %a, <i32 9, i32 9, i32 9, i32 9>
  %b2 = xor <4 x i32> %b, <i32 -1, i32 -1, i32 -1, i32 -1>
  %x = and <4 x i32> %a2, %b2
  ret <4 x i32> %x
}

define <4 x i32> @vpord128(<4 x i32> %a, <4 x i32> %b) nounwind uwtable readnone ssp {
; CHECK-LABEL: vpord128:
; CHECK:       ## %bb.0: ## %entry
; CHECK-NEXT:    vpaddd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %xmm0, %xmm0
; CHECK-NEXT:    vpor %xmm1, %xmm0, %xmm0
; CHECK-NEXT:    retq
entry:
  ; Force the execution domain with an add.
  %a2 = add <4 x i32> %a, <i32 10, i32 10, i32 10, i32 10>
  %x = or <4 x i32> %a2, %b
  ret <4 x i32> %x
}

define <4 x i32> @vpxord128(<4 x i32> %a, <4 x i32> %b) nounwind uwtable readnone ssp {
; CHECK-LABEL: vpxord128:
; CHECK:       ## %bb.0: ## %entry
; CHECK-NEXT:    vpaddd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %xmm0, %xmm0
; CHECK-NEXT:    vpxor %xmm1, %xmm0, %xmm0
; CHECK-NEXT:    retq
entry:
  ; Force the execution domain with an add.
  %a2 = add <4 x i32> %a, <i32 11, i32 11, i32 11, i32 11>
  %x = xor <4 x i32> %a2, %b
  ret <4 x i32> %x
}

define <2 x i64> @vpandq128(<2 x i64> %a, <2 x i64> %b) nounwind uwtable readnone ssp {
; CHECK-LABEL: vpandq128:
; CHECK:       ## %bb.0: ## %entry
; CHECK-NEXT:    vpaddq {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to2}, %xmm0, %xmm0
; CHECK-NEXT:    vpand %xmm1, %xmm0, %xmm0
; CHECK-NEXT:    retq
entry:
  ; Force the execution domain with an add.
  %a2 = add <2 x i64> %a, <i64 12, i64 12>
  %x = and <2 x i64> %a2, %b
  ret <2 x i64> %x
}

define <2 x i64> @vpandnq128(<2 x i64> %a, <2 x i64> %b) nounwind uwtable readnone ssp {
; CHECK-LABEL: vpandnq128:
; CHECK:       ## %bb.0: ## %entry
; CHECK-NEXT:    vpaddq {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to2}, %xmm0, %xmm0
; CHECK-NEXT:    vpandn %xmm0, %xmm1, %xmm0
; CHECK-NEXT:    retq
entry:
  ; Force the execution domain with an add.
  %a2 = add <2 x i64> %a, <i64 13, i64 13>
  %b2 = xor <2 x i64> %b, <i64 -1, i64 -1>
  %x = and <2 x i64> %a2, %b2
  ret <2 x i64> %x
}

define <2 x i64> @vporq128(<2 x i64> %a, <2 x i64> %b) nounwind uwtable readnone ssp {
; CHECK-LABEL: vporq128:
; CHECK:       ## %bb.0: ## %entry
; CHECK-NEXT:    vpaddq {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to2}, %xmm0, %xmm0
; CHECK-NEXT:    vpor %xmm1, %xmm0, %xmm0
; CHECK-NEXT:    retq
entry:
  ; Force the execution domain with an add.
  %a2 = add <2 x i64> %a, <i64 14, i64 14>
  %x = or <2 x i64> %a2, %b
  ret <2 x i64> %x
}

define <2 x i64> @vpxorq128(<2 x i64> %a, <2 x i64> %b) nounwind uwtable readnone ssp {
; CHECK-LABEL: vpxorq128:
; CHECK:       ## %bb.0: ## %entry
; CHECK-NEXT:    vpaddq {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to2}, %xmm0, %xmm0
; CHECK-NEXT:    vpxor %xmm1, %xmm0, %xmm0
; CHECK-NEXT:    retq
entry:
  ; Force the execution domain with an add.
  %a2 = add <2 x i64> %a, <i64 15, i64 15>
  %x = xor <2 x i64> %a2, %b
  ret <2 x i64> %x
}


define <4 x double> @test_mm256_mask_andnot_pd(<4 x double> %__W, i8 zeroext %__U, <4 x double> %__A, <4 x double> %__B) {
; KNL-LABEL: test_mm256_mask_andnot_pd:
; KNL:       ## %bb.0: ## %entry
; KNL-NEXT:    kmovw %edi, %k1
; KNL-NEXT:    vpandnq %ymm2, %ymm1, %ymm0 {%k1}
; KNL-NEXT:    retq
;
; SKX-LABEL: test_mm256_mask_andnot_pd:
; SKX:       ## %bb.0: ## %entry
; SKX-NEXT:    kmovd %edi, %k1
; SKX-NEXT:    vandnpd %ymm2, %ymm1, %ymm0 {%k1}
; SKX-NEXT:    retq
entry:
  %0 = bitcast <4 x double> %__A to <4 x i64>
  %neg.i.i = xor <4 x i64> %0, <i64 -1, i64 -1, i64 -1, i64 -1>
  %1 = bitcast <4 x double> %__B to <4 x i64>
  %and.i.i = and <4 x i64> %1, %neg.i.i
  %2 = bitcast <4 x i64> %and.i.i to <4 x double>
  %3 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = select <4 x i1> %extract.i, <4 x double> %2, <4 x double> %__W
  ret <4 x double> %4
}

define <4 x double> @test_mm256_maskz_andnot_pd(i8 zeroext %__U, <4 x double> %__A, <4 x double> %__B) {
; KNL-LABEL: test_mm256_maskz_andnot_pd:
; KNL:       ## %bb.0: ## %entry
; KNL-NEXT:    kmovw %edi, %k1
; KNL-NEXT:    vpandnq %ymm1, %ymm0, %ymm0 {%k1} {z}
; KNL-NEXT:    retq
;
; SKX-LABEL: test_mm256_maskz_andnot_pd:
; SKX:       ## %bb.0: ## %entry
; SKX-NEXT:    kmovd %edi, %k1
; SKX-NEXT:    vandnpd %ymm1, %ymm0, %ymm0 {%k1} {z}
; SKX-NEXT:    retq
entry:
  %0 = bitcast <4 x double> %__A to <4 x i64>
  %neg.i.i = xor <4 x i64> %0, <i64 -1, i64 -1, i64 -1, i64 -1>
  %1 = bitcast <4 x double> %__B to <4 x i64>
  %and.i.i = and <4 x i64> %1, %neg.i.i
  %2 = bitcast <4 x i64> %and.i.i to <4 x double>
  %3 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = select <4 x i1> %extract.i, <4 x double> %2, <4 x double> zeroinitializer
  ret <4 x double> %4
}

define <2 x double> @test_mm_mask_andnot_pd(<2 x double> %__W, i8 zeroext %__U, <2 x double> %__A, <2 x double> %__B) {
; KNL-LABEL: test_mm_mask_andnot_pd:
; KNL:       ## %bb.0: ## %entry
; KNL-NEXT:    kmovw %edi, %k1
; KNL-NEXT:    vpandnq %xmm2, %xmm1, %xmm0 {%k1}
; KNL-NEXT:    retq
;
; SKX-LABEL: test_mm_mask_andnot_pd:
; SKX:       ## %bb.0: ## %entry
; SKX-NEXT:    kmovd %edi, %k1
; SKX-NEXT:    vandnpd %xmm2, %xmm1, %xmm0 {%k1}
; SKX-NEXT:    retq
entry:
  %0 = bitcast <2 x double> %__A to <2 x i64>
  %neg.i.i = xor <2 x i64> %0, <i64 -1, i64 -1>
  %1 = bitcast <2 x double> %__B to <2 x i64>
  %and.i.i = and <2 x i64> %1, %neg.i.i
  %2 = bitcast <2 x i64> %and.i.i to <2 x double>
  %3 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %4 = select <2 x i1> %extract.i, <2 x double> %2, <2 x double> %__W
  ret <2 x double> %4
}

define <2 x double> @test_mm_maskz_andnot_pd(i8 zeroext %__U, <2 x double> %__A, <2 x double> %__B) {
; KNL-LABEL: test_mm_maskz_andnot_pd:
; KNL:       ## %bb.0: ## %entry
; KNL-NEXT:    kmovw %edi, %k1
; KNL-NEXT:    vpandnq %xmm1, %xmm0, %xmm0 {%k1} {z}
; KNL-NEXT:    retq
;
; SKX-LABEL: test_mm_maskz_andnot_pd:
; SKX:       ## %bb.0: ## %entry
; SKX-NEXT:    kmovd %edi, %k1
; SKX-NEXT:    vandnpd %xmm1, %xmm0, %xmm0 {%k1} {z}
; SKX-NEXT:    retq
entry:
  %0 = bitcast <2 x double> %__A to <2 x i64>
  %neg.i.i = xor <2 x i64> %0, <i64 -1, i64 -1>
  %1 = bitcast <2 x double> %__B to <2 x i64>
  %and.i.i = and <2 x i64> %1, %neg.i.i
  %2 = bitcast <2 x i64> %and.i.i to <2 x double>
  %3 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %4 = select <2 x i1> %extract.i, <2 x double> %2, <2 x double> zeroinitializer
  ret <2 x double> %4
}

define <8 x float> @test_mm256_mask_andnot_ps(<8 x float> %__W, i8 zeroext %__U, <8 x float> %__A, <8 x float> %__B) {
; KNL-LABEL: test_mm256_mask_andnot_ps:
; KNL:       ## %bb.0: ## %entry
; KNL-NEXT:    kmovw %edi, %k1
; KNL-NEXT:    vpandnd %ymm2, %ymm1, %ymm0 {%k1}
; KNL-NEXT:    retq
;
; SKX-LABEL: test_mm256_mask_andnot_ps:
; SKX:       ## %bb.0: ## %entry
; SKX-NEXT:    kmovd %edi, %k1
; SKX-NEXT:    vandnps %ymm2, %ymm1, %ymm0 {%k1}
; SKX-NEXT:    retq
entry:
  %0 = bitcast <8 x float> %__A to <8 x i32>
  %neg.i.i = xor <8 x i32> %0, <i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1>
  %1 = bitcast <8 x float> %__B to <8 x i32>
  %and.i.i = and <8 x i32> %1, %neg.i.i
  %2 = bitcast <8 x i32> %and.i.i to <8 x float>
  %3 = bitcast i8 %__U to <8 x i1>
  %4 = select <8 x i1> %3, <8 x float> %2, <8 x float> %__W
  ret <8 x float> %4
}

define <8 x float> @test_mm256_maskz_andnot_ps(i8 zeroext %__U, <8 x float> %__A, <8 x float> %__B) {
; KNL-LABEL: test_mm256_maskz_andnot_ps:
; KNL:       ## %bb.0: ## %entry
; KNL-NEXT:    kmovw %edi, %k1
; KNL-NEXT:    vpandnd %ymm1, %ymm0, %ymm0 {%k1} {z}
; KNL-NEXT:    retq
;
; SKX-LABEL: test_mm256_maskz_andnot_ps:
; SKX:       ## %bb.0: ## %entry
; SKX-NEXT:    kmovd %edi, %k1
; SKX-NEXT:    vandnps %ymm1, %ymm0, %ymm0 {%k1} {z}
; SKX-NEXT:    retq
entry:
  %0 = bitcast <8 x float> %__A to <8 x i32>
  %neg.i.i = xor <8 x i32> %0, <i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1>
  %1 = bitcast <8 x float> %__B to <8 x i32>
  %and.i.i = and <8 x i32> %1, %neg.i.i
  %2 = bitcast <8 x i32> %and.i.i to <8 x float>
  %3 = bitcast i8 %__U to <8 x i1>
  %4 = select <8 x i1> %3, <8 x float> %2, <8 x float> zeroinitializer
  ret <8 x float> %4
}

define <4 x float> @test_mm_mask_andnot_ps(<4 x float> %__W, i8 zeroext %__U, <4 x float> %__A, <4 x float> %__B) {
; KNL-LABEL: test_mm_mask_andnot_ps:
; KNL:       ## %bb.0: ## %entry
; KNL-NEXT:    kmovw %edi, %k1
; KNL-NEXT:    vpandnd %xmm2, %xmm1, %xmm0 {%k1}
; KNL-NEXT:    retq
;
; SKX-LABEL: test_mm_mask_andnot_ps:
; SKX:       ## %bb.0: ## %entry
; SKX-NEXT:    kmovd %edi, %k1
; SKX-NEXT:    vandnps %xmm2, %xmm1, %xmm0 {%k1}
; SKX-NEXT:    retq
entry:
  %0 = bitcast <4 x float> %__A to <4 x i32>
  %neg.i.i = xor <4 x i32> %0, <i32 -1, i32 -1, i32 -1, i32 -1>
  %1 = bitcast <4 x float> %__B to <4 x i32>
  %and.i.i = and <4 x i32> %1, %neg.i.i
  %2 = bitcast <4 x i32> %and.i.i to <4 x float>
  %3 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = select <4 x i1> %extract.i, <4 x float> %2, <4 x float> %__W
  ret <4 x float> %4
}

define <4 x float> @test_mm_maskz_andnot_ps(i8 zeroext %__U, <4 x float> %__A, <4 x float> %__B) {
; KNL-LABEL: test_mm_maskz_andnot_ps:
; KNL:       ## %bb.0: ## %entry
; KNL-NEXT:    kmovw %edi, %k1
; KNL-NEXT:    vpandnd %xmm1, %xmm0, %xmm0 {%k1} {z}
; KNL-NEXT:    retq
;
; SKX-LABEL: test_mm_maskz_andnot_ps:
; SKX:       ## %bb.0: ## %entry
; SKX-NEXT:    kmovd %edi, %k1
; SKX-NEXT:    vandnps %xmm1, %xmm0, %xmm0 {%k1} {z}
; SKX-NEXT:    retq
entry:
  %0 = bitcast <4 x float> %__A to <4 x i32>
  %neg.i.i = xor <4 x i32> %0, <i32 -1, i32 -1, i32 -1, i32 -1>
  %1 = bitcast <4 x float> %__B to <4 x i32>
  %and.i.i = and <4 x i32> %1, %neg.i.i
  %2 = bitcast <4 x i32> %and.i.i to <4 x float>
  %3 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = select <4 x i1> %extract.i, <4 x float> %2, <4 x float> zeroinitializer
  ret <4 x float> %4
}

define <4 x double> @test_mm256_mask_and_pd(<4 x double> %__W, i8 zeroext %__U, <4 x double> %__A, <4 x double> %__B) {
; KNL-LABEL: test_mm256_mask_and_pd:
; KNL:       ## %bb.0: ## %entry
; KNL-NEXT:    kmovw %edi, %k1
; KNL-NEXT:    vpandq %ymm1, %ymm2, %ymm0 {%k1}
; KNL-NEXT:    retq
;
; SKX-LABEL: test_mm256_mask_and_pd:
; SKX:       ## %bb.0: ## %entry
; SKX-NEXT:    kmovd %edi, %k1
; SKX-NEXT:    vandpd %ymm1, %ymm2, %ymm0 {%k1}
; SKX-NEXT:    retq
entry:
  %0 = bitcast <4 x double> %__A to <4 x i64>
  %1 = bitcast <4 x double> %__B to <4 x i64>
  %and.i.i = and <4 x i64> %1, %0
  %2 = bitcast <4 x i64> %and.i.i to <4 x double>
  %3 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = select <4 x i1> %extract.i, <4 x double> %2, <4 x double> %__W
  ret <4 x double> %4
}

define <4 x double> @test_mm256_maskz_and_pd(i8 zeroext %__U, <4 x double> %__A, <4 x double> %__B) {
; KNL-LABEL: test_mm256_maskz_and_pd:
; KNL:       ## %bb.0: ## %entry
; KNL-NEXT:    kmovw %edi, %k1
; KNL-NEXT:    vpandq %ymm0, %ymm1, %ymm0 {%k1} {z}
; KNL-NEXT:    retq
;
; SKX-LABEL: test_mm256_maskz_and_pd:
; SKX:       ## %bb.0: ## %entry
; SKX-NEXT:    kmovd %edi, %k1
; SKX-NEXT:    vandpd %ymm0, %ymm1, %ymm0 {%k1} {z}
; SKX-NEXT:    retq
entry:
  %0 = bitcast <4 x double> %__A to <4 x i64>
  %1 = bitcast <4 x double> %__B to <4 x i64>
  %and.i.i = and <4 x i64> %1, %0
  %2 = bitcast <4 x i64> %and.i.i to <4 x double>
  %3 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = select <4 x i1> %extract.i, <4 x double> %2, <4 x double> zeroinitializer
  ret <4 x double> %4
}

define <2 x double> @test_mm_mask_and_pd(<2 x double> %__W, i8 zeroext %__U, <2 x double> %__A, <2 x double> %__B) {
; KNL-LABEL: test_mm_mask_and_pd:
; KNL:       ## %bb.0: ## %entry
; KNL-NEXT:    kmovw %edi, %k1
; KNL-NEXT:    vpandq %xmm1, %xmm2, %xmm0 {%k1}
; KNL-NEXT:    retq
;
; SKX-LABEL: test_mm_mask_and_pd:
; SKX:       ## %bb.0: ## %entry
; SKX-NEXT:    kmovd %edi, %k1
; SKX-NEXT:    vandpd %xmm1, %xmm2, %xmm0 {%k1}
; SKX-NEXT:    retq
entry:
  %0 = bitcast <2 x double> %__A to <2 x i64>
  %1 = bitcast <2 x double> %__B to <2 x i64>
  %and.i.i = and <2 x i64> %1, %0
  %2 = bitcast <2 x i64> %and.i.i to <2 x double>
  %3 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %4 = select <2 x i1> %extract.i, <2 x double> %2, <2 x double> %__W
  ret <2 x double> %4
}

define <2 x double> @test_mm_maskz_and_pd(i8 zeroext %__U, <2 x double> %__A, <2 x double> %__B) {
; KNL-LABEL: test_mm_maskz_and_pd:
; KNL:       ## %bb.0: ## %entry
; KNL-NEXT:    kmovw %edi, %k1
; KNL-NEXT:    vpandq %xmm0, %xmm1, %xmm0 {%k1} {z}
; KNL-NEXT:    retq
;
; SKX-LABEL: test_mm_maskz_and_pd:
; SKX:       ## %bb.0: ## %entry
; SKX-NEXT:    kmovd %edi, %k1
; SKX-NEXT:    vandpd %xmm0, %xmm1, %xmm0 {%k1} {z}
; SKX-NEXT:    retq
entry:
  %0 = bitcast <2 x double> %__A to <2 x i64>
  %1 = bitcast <2 x double> %__B to <2 x i64>
  %and.i.i = and <2 x i64> %1, %0
  %2 = bitcast <2 x i64> %and.i.i to <2 x double>
  %3 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %4 = select <2 x i1> %extract.i, <2 x double> %2, <2 x double> zeroinitializer
  ret <2 x double> %4
}

define <8 x float> @test_mm256_mask_and_ps(<8 x float> %__W, i8 zeroext %__U, <8 x float> %__A, <8 x float> %__B) {
; KNL-LABEL: test_mm256_mask_and_ps:
; KNL:       ## %bb.0: ## %entry
; KNL-NEXT:    kmovw %edi, %k1
; KNL-NEXT:    vpandd %ymm1, %ymm2, %ymm0 {%k1}
; KNL-NEXT:    retq
;
; SKX-LABEL: test_mm256_mask_and_ps:
; SKX:       ## %bb.0: ## %entry
; SKX-NEXT:    kmovd %edi, %k1
; SKX-NEXT:    vandps %ymm1, %ymm2, %ymm0 {%k1}
; SKX-NEXT:    retq
entry:
  %0 = bitcast <8 x float> %__A to <8 x i32>
  %1 = bitcast <8 x float> %__B to <8 x i32>
  %and.i.i = and <8 x i32> %1, %0
  %2 = bitcast <8 x i32> %and.i.i to <8 x float>
  %3 = bitcast i8 %__U to <8 x i1>
  %4 = select <8 x i1> %3, <8 x float> %2, <8 x float> %__W
  ret <8 x float> %4
}

define <8 x float> @test_mm256_maskz_and_ps(i8 zeroext %__U, <8 x float> %__A, <8 x float> %__B) {
; KNL-LABEL: test_mm256_maskz_and_ps:
; KNL:       ## %bb.0: ## %entry
; KNL-NEXT:    kmovw %edi, %k1
; KNL-NEXT:    vpandd %ymm0, %ymm1, %ymm0 {%k1} {z}
; KNL-NEXT:    retq
;
; SKX-LABEL: test_mm256_maskz_and_ps:
; SKX:       ## %bb.0: ## %entry
; SKX-NEXT:    kmovd %edi, %k1
; SKX-NEXT:    vandps %ymm0, %ymm1, %ymm0 {%k1} {z}
; SKX-NEXT:    retq
entry:
  %0 = bitcast <8 x float> %__A to <8 x i32>
  %1 = bitcast <8 x float> %__B to <8 x i32>
  %and.i.i = and <8 x i32> %1, %0
  %2 = bitcast <8 x i32> %and.i.i to <8 x float>
  %3 = bitcast i8 %__U to <8 x i1>
  %4 = select <8 x i1> %3, <8 x float> %2, <8 x float> zeroinitializer
  ret <8 x float> %4
}

define <4 x float> @test_mm_mask_and_ps(<4 x float> %__W, i8 zeroext %__U, <4 x float> %__A, <4 x float> %__B) {
; KNL-LABEL: test_mm_mask_and_ps:
; KNL:       ## %bb.0: ## %entry
; KNL-NEXT:    kmovw %edi, %k1
; KNL-NEXT:    vpandd %xmm1, %xmm2, %xmm0 {%k1}
; KNL-NEXT:    retq
;
; SKX-LABEL: test_mm_mask_and_ps:
; SKX:       ## %bb.0: ## %entry
; SKX-NEXT:    kmovd %edi, %k1
; SKX-NEXT:    vandps %xmm1, %xmm2, %xmm0 {%k1}
; SKX-NEXT:    retq
entry:
  %0 = bitcast <4 x float> %__A to <4 x i32>
  %1 = bitcast <4 x float> %__B to <4 x i32>
  %and.i.i = and <4 x i32> %1, %0
  %2 = bitcast <4 x i32> %and.i.i to <4 x float>
  %3 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = select <4 x i1> %extract.i, <4 x float> %2, <4 x float> %__W
  ret <4 x float> %4
}

define <4 x float> @test_mm_maskz_and_ps(i8 zeroext %__U, <4 x float> %__A, <4 x float> %__B) {
; KNL-LABEL: test_mm_maskz_and_ps:
; KNL:       ## %bb.0: ## %entry
; KNL-NEXT:    kmovw %edi, %k1
; KNL-NEXT:    vpandd %xmm0, %xmm1, %xmm0 {%k1} {z}
; KNL-NEXT:    retq
;
; SKX-LABEL: test_mm_maskz_and_ps:
; SKX:       ## %bb.0: ## %entry
; SKX-NEXT:    kmovd %edi, %k1
; SKX-NEXT:    vandps %xmm0, %xmm1, %xmm0 {%k1} {z}
; SKX-NEXT:    retq
entry:
  %0 = bitcast <4 x float> %__A to <4 x i32>
  %1 = bitcast <4 x float> %__B to <4 x i32>
  %and.i.i = and <4 x i32> %1, %0
  %2 = bitcast <4 x i32> %and.i.i to <4 x float>
  %3 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = select <4 x i1> %extract.i, <4 x float> %2, <4 x float> zeroinitializer
  ret <4 x float> %4
}

define <4 x double> @test_mm256_mask_xor_pd(<4 x double> %__W, i8 zeroext %__U, <4 x double> %__A, <4 x double> %__B) {
; KNL-LABEL: test_mm256_mask_xor_pd:
; KNL:       ## %bb.0: ## %entry
; KNL-NEXT:    kmovw %edi, %k1
; KNL-NEXT:    vpxorq %ymm2, %ymm1, %ymm0 {%k1}
; KNL-NEXT:    retq
;
; SKX-LABEL: test_mm256_mask_xor_pd:
; SKX:       ## %bb.0: ## %entry
; SKX-NEXT:    kmovd %edi, %k1
; SKX-NEXT:    vxorpd %ymm2, %ymm1, %ymm0 {%k1}
; SKX-NEXT:    retq
entry:
  %0 = bitcast <4 x double> %__A to <4 x i64>
  %1 = bitcast <4 x double> %__B to <4 x i64>
  %xor.i.i = xor <4 x i64> %0, %1
  %2 = bitcast <4 x i64> %xor.i.i to <4 x double>
  %3 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = select <4 x i1> %extract.i, <4 x double> %2, <4 x double> %__W
  ret <4 x double> %4
}

define <4 x double> @test_mm256_maskz_xor_pd(i8 zeroext %__U, <4 x double> %__A, <4 x double> %__B) {
; KNL-LABEL: test_mm256_maskz_xor_pd:
; KNL:       ## %bb.0: ## %entry
; KNL-NEXT:    kmovw %edi, %k1
; KNL-NEXT:    vpxorq %ymm1, %ymm0, %ymm0 {%k1} {z}
; KNL-NEXT:    retq
;
; SKX-LABEL: test_mm256_maskz_xor_pd:
; SKX:       ## %bb.0: ## %entry
; SKX-NEXT:    kmovd %edi, %k1
; SKX-NEXT:    vxorpd %ymm1, %ymm0, %ymm0 {%k1} {z}
; SKX-NEXT:    retq
entry:
  %0 = bitcast <4 x double> %__A to <4 x i64>
  %1 = bitcast <4 x double> %__B to <4 x i64>
  %xor.i.i = xor <4 x i64> %0, %1
  %2 = bitcast <4 x i64> %xor.i.i to <4 x double>
  %3 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = select <4 x i1> %extract.i, <4 x double> %2, <4 x double> zeroinitializer
  ret <4 x double> %4
}

define <2 x double> @test_mm_mask_xor_pd(<2 x double> %__W, i8 zeroext %__U, <2 x double> %__A, <2 x double> %__B) {
; KNL-LABEL: test_mm_mask_xor_pd:
; KNL:       ## %bb.0: ## %entry
; KNL-NEXT:    kmovw %edi, %k1
; KNL-NEXT:    vpxorq %xmm2, %xmm1, %xmm0 {%k1}
; KNL-NEXT:    retq
;
; SKX-LABEL: test_mm_mask_xor_pd:
; SKX:       ## %bb.0: ## %entry
; SKX-NEXT:    kmovd %edi, %k1
; SKX-NEXT:    vxorpd %xmm2, %xmm1, %xmm0 {%k1}
; SKX-NEXT:    retq
entry:
  %0 = bitcast <2 x double> %__A to <2 x i64>
  %1 = bitcast <2 x double> %__B to <2 x i64>
  %xor.i.i = xor <2 x i64> %0, %1
  %2 = bitcast <2 x i64> %xor.i.i to <2 x double>
  %3 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %4 = select <2 x i1> %extract.i, <2 x double> %2, <2 x double> %__W
  ret <2 x double> %4
}

define <2 x double> @test_mm_maskz_xor_pd(i8 zeroext %__U, <2 x double> %__A, <2 x double> %__B) {
; KNL-LABEL: test_mm_maskz_xor_pd:
; KNL:       ## %bb.0: ## %entry
; KNL-NEXT:    kmovw %edi, %k1
; KNL-NEXT:    vpxorq %xmm1, %xmm0, %xmm0 {%k1} {z}
; KNL-NEXT:    retq
;
; SKX-LABEL: test_mm_maskz_xor_pd:
; SKX:       ## %bb.0: ## %entry
; SKX-NEXT:    kmovd %edi, %k1
; SKX-NEXT:    vxorpd %xmm1, %xmm0, %xmm0 {%k1} {z}
; SKX-NEXT:    retq
entry:
  %0 = bitcast <2 x double> %__A to <2 x i64>
  %1 = bitcast <2 x double> %__B to <2 x i64>
  %xor.i.i = xor <2 x i64> %0, %1
  %2 = bitcast <2 x i64> %xor.i.i to <2 x double>
  %3 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %4 = select <2 x i1> %extract.i, <2 x double> %2, <2 x double> zeroinitializer
  ret <2 x double> %4
}

define <8 x float> @test_mm256_mask_xor_ps(<8 x float> %__W, i8 zeroext %__U, <8 x float> %__A, <8 x float> %__B) {
; KNL-LABEL: test_mm256_mask_xor_ps:
; KNL:       ## %bb.0: ## %entry
; KNL-NEXT:    kmovw %edi, %k1
; KNL-NEXT:    vpxord %ymm2, %ymm1, %ymm0 {%k1}
; KNL-NEXT:    retq
;
; SKX-LABEL: test_mm256_mask_xor_ps:
; SKX:       ## %bb.0: ## %entry
; SKX-NEXT:    kmovd %edi, %k1
; SKX-NEXT:    vxorps %ymm2, %ymm1, %ymm0 {%k1}
; SKX-NEXT:    retq
entry:
  %0 = bitcast <8 x float> %__A to <8 x i32>
  %1 = bitcast <8 x float> %__B to <8 x i32>
  %xor.i.i = xor <8 x i32> %0, %1
  %2 = bitcast <8 x i32> %xor.i.i to <8 x float>
  %3 = bitcast i8 %__U to <8 x i1>
  %4 = select <8 x i1> %3, <8 x float> %2, <8 x float> %__W
  ret <8 x float> %4
}

define <8 x float> @test_mm256_maskz_xor_ps(i8 zeroext %__U, <8 x float> %__A, <8 x float> %__B) {
; KNL-LABEL: test_mm256_maskz_xor_ps:
; KNL:       ## %bb.0: ## %entry
; KNL-NEXT:    kmovw %edi, %k1
; KNL-NEXT:    vpxord %ymm1, %ymm0, %ymm0 {%k1} {z}
; KNL-NEXT:    retq
;
; SKX-LABEL: test_mm256_maskz_xor_ps:
; SKX:       ## %bb.0: ## %entry
; SKX-NEXT:    kmovd %edi, %k1
; SKX-NEXT:    vxorps %ymm1, %ymm0, %ymm0 {%k1} {z}
; SKX-NEXT:    retq
entry:
  %0 = bitcast <8 x float> %__A to <8 x i32>
  %1 = bitcast <8 x float> %__B to <8 x i32>
  %xor.i.i = xor <8 x i32> %0, %1
  %2 = bitcast <8 x i32> %xor.i.i to <8 x float>
  %3 = bitcast i8 %__U to <8 x i1>
  %4 = select <8 x i1> %3, <8 x float> %2, <8 x float> zeroinitializer
  ret <8 x float> %4
}

define <4 x float> @test_mm_mask_xor_ps(<4 x float> %__W, i8 zeroext %__U, <4 x float> %__A, <4 x float> %__B) {
; KNL-LABEL: test_mm_mask_xor_ps:
; KNL:       ## %bb.0: ## %entry
; KNL-NEXT:    kmovw %edi, %k1
; KNL-NEXT:    vpxord %xmm2, %xmm1, %xmm0 {%k1}
; KNL-NEXT:    retq
;
; SKX-LABEL: test_mm_mask_xor_ps:
; SKX:       ## %bb.0: ## %entry
; SKX-NEXT:    kmovd %edi, %k1
; SKX-NEXT:    vxorps %xmm2, %xmm1, %xmm0 {%k1}
; SKX-NEXT:    retq
entry:
  %0 = bitcast <4 x float> %__A to <4 x i32>
  %1 = bitcast <4 x float> %__B to <4 x i32>
  %xor.i.i = xor <4 x i32> %0, %1
  %2 = bitcast <4 x i32> %xor.i.i to <4 x float>
  %3 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = select <4 x i1> %extract.i, <4 x float> %2, <4 x float> %__W
  ret <4 x float> %4
}

define <4 x float> @test_mm_maskz_xor_ps(i8 zeroext %__U, <4 x float> %__A, <4 x float> %__B) {
; KNL-LABEL: test_mm_maskz_xor_ps:
; KNL:       ## %bb.0: ## %entry
; KNL-NEXT:    kmovw %edi, %k1
; KNL-NEXT:    vpxord %xmm1, %xmm0, %xmm0 {%k1} {z}
; KNL-NEXT:    retq
;
; SKX-LABEL: test_mm_maskz_xor_ps:
; SKX:       ## %bb.0: ## %entry
; SKX-NEXT:    kmovd %edi, %k1
; SKX-NEXT:    vxorps %xmm1, %xmm0, %xmm0 {%k1} {z}
; SKX-NEXT:    retq
entry:
  %0 = bitcast <4 x float> %__A to <4 x i32>
  %1 = bitcast <4 x float> %__B to <4 x i32>
  %xor.i.i = xor <4 x i32> %0, %1
  %2 = bitcast <4 x i32> %xor.i.i to <4 x float>
  %3 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = select <4 x i1> %extract.i, <4 x float> %2, <4 x float> zeroinitializer
  ret <4 x float> %4
}

define <4 x double> @test_mm256_mask_or_pd(<4 x double> %__W, i8 zeroext %__U, <4 x double> %__A, <4 x double> %__B) {
; KNL-LABEL: test_mm256_mask_or_pd:
; KNL:       ## %bb.0: ## %entry
; KNL-NEXT:    kmovw %edi, %k1
; KNL-NEXT:    vporq %ymm1, %ymm2, %ymm0 {%k1}
; KNL-NEXT:    retq
;
; SKX-LABEL: test_mm256_mask_or_pd:
; SKX:       ## %bb.0: ## %entry
; SKX-NEXT:    kmovd %edi, %k1
; SKX-NEXT:    vorpd %ymm1, %ymm2, %ymm0 {%k1}
; SKX-NEXT:    retq
entry:
  %0 = bitcast <4 x double> %__A to <4 x i64>
  %1 = bitcast <4 x double> %__B to <4 x i64>
  %or.i.i = or <4 x i64> %1, %0
  %2 = bitcast <4 x i64> %or.i.i to <4 x double>
  %3 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = select <4 x i1> %extract.i, <4 x double> %2, <4 x double> %__W
  ret <4 x double> %4
}

define <4 x double> @test_mm256_maskz_or_pd(i8 zeroext %__U, <4 x double> %__A, <4 x double> %__B) {
; KNL-LABEL: test_mm256_maskz_or_pd:
; KNL:       ## %bb.0: ## %entry
; KNL-NEXT:    kmovw %edi, %k1
; KNL-NEXT:    vporq %ymm0, %ymm1, %ymm0 {%k1} {z}
; KNL-NEXT:    retq
;
; SKX-LABEL: test_mm256_maskz_or_pd:
; SKX:       ## %bb.0: ## %entry
; SKX-NEXT:    kmovd %edi, %k1
; SKX-NEXT:    vorpd %ymm0, %ymm1, %ymm0 {%k1} {z}
; SKX-NEXT:    retq
entry:
  %0 = bitcast <4 x double> %__A to <4 x i64>
  %1 = bitcast <4 x double> %__B to <4 x i64>
  %or.i.i = or <4 x i64> %1, %0
  %2 = bitcast <4 x i64> %or.i.i to <4 x double>
  %3 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = select <4 x i1> %extract.i, <4 x double> %2, <4 x double> zeroinitializer
  ret <4 x double> %4
}

define <2 x double> @test_mm_mask_or_pd(<2 x double> %__W, i8 zeroext %__U, <2 x double> %__A, <2 x double> %__B) {
; KNL-LABEL: test_mm_mask_or_pd:
; KNL:       ## %bb.0: ## %entry
; KNL-NEXT:    kmovw %edi, %k1
; KNL-NEXT:    vporq %xmm1, %xmm2, %xmm0 {%k1}
; KNL-NEXT:    retq
;
; SKX-LABEL: test_mm_mask_or_pd:
; SKX:       ## %bb.0: ## %entry
; SKX-NEXT:    kmovd %edi, %k1
; SKX-NEXT:    vorpd %xmm1, %xmm2, %xmm0 {%k1}
; SKX-NEXT:    retq
entry:
  %0 = bitcast <2 x double> %__A to <2 x i64>
  %1 = bitcast <2 x double> %__B to <2 x i64>
  %or.i.i = or <2 x i64> %1, %0
  %2 = bitcast <2 x i64> %or.i.i to <2 x double>
  %3 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %4 = select <2 x i1> %extract.i, <2 x double> %2, <2 x double> %__W
  ret <2 x double> %4
}

define <2 x double> @test_mm_maskz_or_pd(i8 zeroext %__U, <2 x double> %__A, <2 x double> %__B) {
; KNL-LABEL: test_mm_maskz_or_pd:
; KNL:       ## %bb.0: ## %entry
; KNL-NEXT:    kmovw %edi, %k1
; KNL-NEXT:    vporq %xmm0, %xmm1, %xmm0 {%k1} {z}
; KNL-NEXT:    retq
;
; SKX-LABEL: test_mm_maskz_or_pd:
; SKX:       ## %bb.0: ## %entry
; SKX-NEXT:    kmovd %edi, %k1
; SKX-NEXT:    vorpd %xmm0, %xmm1, %xmm0 {%k1} {z}
; SKX-NEXT:    retq
entry:
  %0 = bitcast <2 x double> %__A to <2 x i64>
  %1 = bitcast <2 x double> %__B to <2 x i64>
  %or.i.i = or <2 x i64> %1, %0
  %2 = bitcast <2 x i64> %or.i.i to <2 x double>
  %3 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %4 = select <2 x i1> %extract.i, <2 x double> %2, <2 x double> zeroinitializer
  ret <2 x double> %4
}

define <8 x float> @test_mm256_mask_or_ps(<8 x float> %__W, i8 zeroext %__U, <8 x float> %__A, <8 x float> %__B) {
; KNL-LABEL: test_mm256_mask_or_ps:
; KNL:       ## %bb.0: ## %entry
; KNL-NEXT:    kmovw %edi, %k1
; KNL-NEXT:    vpord %ymm1, %ymm2, %ymm0 {%k1}
; KNL-NEXT:    retq
;
; SKX-LABEL: test_mm256_mask_or_ps:
; SKX:       ## %bb.0: ## %entry
; SKX-NEXT:    kmovd %edi, %k1
; SKX-NEXT:    vorps %ymm1, %ymm2, %ymm0 {%k1}
; SKX-NEXT:    retq
entry:
  %0 = bitcast <8 x float> %__A to <8 x i32>
  %1 = bitcast <8 x float> %__B to <8 x i32>
  %or.i.i = or <8 x i32> %1, %0
  %2 = bitcast <8 x i32> %or.i.i to <8 x float>
  %3 = bitcast i8 %__U to <8 x i1>
  %4 = select <8 x i1> %3, <8 x float> %2, <8 x float> %__W
  ret <8 x float> %4
}

define <8 x float> @test_mm256_maskz_or_ps(i8 zeroext %__U, <8 x float> %__A, <8 x float> %__B) {
; KNL-LABEL: test_mm256_maskz_or_ps:
; KNL:       ## %bb.0: ## %entry
; KNL-NEXT:    kmovw %edi, %k1
; KNL-NEXT:    vpord %ymm0, %ymm1, %ymm0 {%k1} {z}
; KNL-NEXT:    retq
;
; SKX-LABEL: test_mm256_maskz_or_ps:
; SKX:       ## %bb.0: ## %entry
; SKX-NEXT:    kmovd %edi, %k1
; SKX-NEXT:    vorps %ymm0, %ymm1, %ymm0 {%k1} {z}
; SKX-NEXT:    retq
entry:
  %0 = bitcast <8 x float> %__A to <8 x i32>
  %1 = bitcast <8 x float> %__B to <8 x i32>
  %or.i.i = or <8 x i32> %1, %0
  %2 = bitcast <8 x i32> %or.i.i to <8 x float>
  %3 = bitcast i8 %__U to <8 x i1>
  %4 = select <8 x i1> %3, <8 x float> %2, <8 x float> zeroinitializer
  ret <8 x float> %4
}

define <4 x float> @test_mm_mask_or_ps(<4 x float> %__W, i8 zeroext %__U, <4 x float> %__A, <4 x float> %__B) {
; KNL-LABEL: test_mm_mask_or_ps:
; KNL:       ## %bb.0: ## %entry
; KNL-NEXT:    kmovw %edi, %k1
; KNL-NEXT:    vpord %xmm1, %xmm2, %xmm0 {%k1}
; KNL-NEXT:    retq
;
; SKX-LABEL: test_mm_mask_or_ps:
; SKX:       ## %bb.0: ## %entry
; SKX-NEXT:    kmovd %edi, %k1
; SKX-NEXT:    vorps %xmm1, %xmm2, %xmm0 {%k1}
; SKX-NEXT:    retq
entry:
  %0 = bitcast <4 x float> %__A to <4 x i32>
  %1 = bitcast <4 x float> %__B to <4 x i32>
  %or.i.i = or <4 x i32> %1, %0
  %2 = bitcast <4 x i32> %or.i.i to <4 x float>
  %3 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = select <4 x i1> %extract.i, <4 x float> %2, <4 x float> %__W
  ret <4 x float> %4
}

define <4 x float> @test_mm_maskz_or_ps(i8 zeroext %__U, <4 x float> %__A, <4 x float> %__B) {
; KNL-LABEL: test_mm_maskz_or_ps:
; KNL:       ## %bb.0: ## %entry
; KNL-NEXT:    kmovw %edi, %k1
; KNL-NEXT:    vpord %xmm0, %xmm1, %xmm0 {%k1} {z}
; KNL-NEXT:    retq
;
; SKX-LABEL: test_mm_maskz_or_ps:
; SKX:       ## %bb.0: ## %entry
; SKX-NEXT:    kmovd %edi, %k1
; SKX-NEXT:    vorps %xmm0, %xmm1, %xmm0 {%k1} {z}
; SKX-NEXT:    retq
entry:
  %0 = bitcast <4 x float> %__A to <4 x i32>
  %1 = bitcast <4 x float> %__B to <4 x i32>
  %or.i.i = or <4 x i32> %1, %0
  %2 = bitcast <4 x i32> %or.i.i to <4 x float>
  %3 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = select <4 x i1> %extract.i, <4 x float> %2, <4 x float> zeroinitializer
  ret <4 x float> %4
}

define <4 x i32> @ternlog_and_andn(<4 x i32> %x, <4 x i32> %y, <4 x i32> %z) {
; CHECK-LABEL: ternlog_and_andn:
; CHECK:       ## %bb.0:
; CHECK-NEXT:    vpternlogd {{.*#+}} xmm0 = xmm2 & xmm1 & ~xmm0
; CHECK-NEXT:    retq
  %a = xor <4 x i32> %x, <i32 -1, i32 -1, i32 -1, i32 -1>
  %b = and <4 x i32> %y, %a
  %c = and <4 x i32> %b, %z
  ret <4 x i32> %c
}

define <4 x i32> @ternlog_or_andn(<4 x i32> %x, <4 x i32> %y, <4 x i32> %z) {
; CHECK-LABEL: ternlog_or_andn:
; CHECK:       ## %bb.0:
; CHECK-NEXT:    vpternlogd {{.*#+}} xmm0 = (xmm1 & ~xmm0) | xmm2
; CHECK-NEXT:    retq
  %a = xor <4 x i32> %x, <i32 -1, i32 -1, i32 -1, i32 -1>
  %b = and <4 x i32> %y, %a
  %c = or <4 x i32> %b, %z
  ret <4 x i32> %c
}

define <4 x i32> @ternlog_and_orn(<4 x i32> %x, <4 x i32> %y, <4 x i32> %z) {
; CHECK-LABEL: ternlog_and_orn:
; CHECK:       ## %bb.0:
; CHECK-NEXT:    vpternlogd {{.*#+}} xmm0 = xmm0 & (xmm1 | ~xmm2)
; CHECK-NEXT:    retq
  %a = xor <4 x i32> %z, <i32 -1, i32 -1, i32 -1, i32 -1>
  %b = or <4 x i32> %a, %y
  %c = and <4 x i32> %b, %x
  ret <4 x i32> %c
}

define <4 x i32> @ternlog_and_orn_2(<4 x i32> %x, <4 x i32> %y, <4 x i32> %z) {
; CHECK-LABEL: ternlog_and_orn_2:
; CHECK:       ## %bb.0:
; CHECK-NEXT:    vpternlogd {{.*#+}} xmm0 = xmm0 & (xmm1 | ~xmm2)
; CHECK-NEXT:    retq
  %a = xor <4 x i32> %z, <i32 -1, i32 -1, i32 -1, i32 -1>
  %b = or <4 x i32> %y, %a
  %c = and <4 x i32> %b, %x
  ret <4 x i32> %c
}

; FIXME: This should be a single vpternlog, but we accidentally match the xor -1
; as the second binary op instead of the and.
define <4 x i32> @ternlog_orn_and(<4 x i32> %x, <4 x i32> %y, <4 x i32> %z) {
; CHECK-LABEL: ternlog_orn_and:
; CHECK:       ## %bb.0:
; CHECK-NEXT:    vpcmpeqd %xmm3, %xmm3, %xmm3
; CHECK-NEXT:    vpand %xmm2, %xmm1, %xmm1
; CHECK-NEXT:    vpternlogd {{.*#+}} xmm0 = xmm1 | (xmm0 ^ xmm3)
; CHECK-NEXT:    retq
  %a = xor <4 x i32> %x, <i32 -1, i32 -1, i32 -1, i32 -1>
  %b = and <4 x i32> %y, %z
  %c = or <4 x i32> %b, %a
  ret <4 x i32> %c
}

define <4 x i32> @ternlog_orn_and_2(<4 x i32> %x, <4 x i32> %y, <4 x i32> %z) {
; CHECK-LABEL: ternlog_orn_and_2:
; CHECK:       ## %bb.0:
; CHECK-NEXT:    vpternlogd {{.*#+}} xmm0 = (xmm1 & xmm2) | ~xmm0
; CHECK-NEXT:    retq
  %a = xor <4 x i32> %x, <i32 -1, i32 -1, i32 -1, i32 -1>
  %b = and <4 x i32> %y, %z
  %c = or <4 x i32> %a, %b
  ret <4 x i32> %c
}

define <4 x i32> @ternlog_xor_andn(<4 x i32> %x, <4 x i32> %y, <4 x i32> %z) {
; CHECK-LABEL: ternlog_xor_andn:
; CHECK:       ## %bb.0:
; CHECK-NEXT:    vpternlogd {{.*#+}} xmm0 = xmm2 ^ (xmm1 & ~xmm0)
; CHECK-NEXT:    retq
  %a = xor <4 x i32> %x, <i32 -1, i32 -1, i32 -1, i32 -1>
  %b = and <4 x i32> %y, %a
  %c = xor <4 x i32> %b, %z
  ret <4 x i32> %c
}

define <4 x i32> @ternlog_or_and_mask(<4 x i32> %x, <4 x i32> %y) {
; CHECK-LABEL: ternlog_or_and_mask:
; CHECK:       ## %bb.0:
; CHECK-NEXT:    vpternlogd {{.*#+}} xmm0 = (xmm0 & m32bcst) | xmm1
; CHECK-NEXT:    retq
  %a = and <4 x i32> %x, <i32 255, i32 255, i32 255, i32 255>
  %b = or <4 x i32> %a, %y
  ret <4 x i32> %b
}

define <8 x i32> @ternlog_or_and_mask_ymm(<8 x i32> %x, <8 x i32> %y) {
; CHECK-LABEL: ternlog_or_and_mask_ymm:
; CHECK:       ## %bb.0:
; CHECK-NEXT:    vpternlogd {{.*#+}} ymm0 = (ymm0 & m32bcst) | ymm1
; CHECK-NEXT:    retq
  %a = and <8 x i32> %x, <i32 -16777216, i32 -16777216, i32 -16777216, i32 -16777216, i32 -16777216, i32 -16777216, i32 -16777216, i32 -16777216>
  %b = or <8 x i32> %a, %y
  ret <8 x i32> %b
}

define <2 x i64> @ternlog_xor_and_mask(<2 x i64> %x, <2 x i64> %y) {
; CHECK-LABEL: ternlog_xor_and_mask:
; CHECK:       ## %bb.0:
; CHECK-NEXT:    vpternlogq {{.*#+}} xmm0 = xmm1 ^ (xmm0 & m64bcst)
; CHECK-NEXT:    retq
  %a = and <2 x i64> %x, <i64 1099511627775, i64 1099511627775>
  %b = xor <2 x i64> %a, %y
  ret <2 x i64> %b
}

define <4 x i64> @ternlog_xor_and_mask_ymm(<4 x i64> %x, <4 x i64> %y) {
; CHECK-LABEL: ternlog_xor_and_mask_ymm:
; CHECK:       ## %bb.0:
; CHECK-NEXT:    vpternlogq {{.*#+}} ymm0 = ymm1 ^ (ymm0 & m64bcst)
; CHECK-NEXT:    retq
  %a = and <4 x i64> %x, <i64 72057594037927935, i64 72057594037927935, i64 72057594037927935, i64 72057594037927935>
  %b = xor <4 x i64> %a, %y
  ret <4 x i64> %b
}

define <4 x i32> @ternlog_maskz_or_and_mask(<4 x i32> %x, <4 x i32> %y, <4 x i32> %z, <4 x i32> %mask) {
; CHECK-LABEL: ternlog_maskz_or_and_mask:
; CHECK:       ## %bb.0:
; CHECK-NEXT:    vpandd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %xmm0, %xmm2
; CHECK-NEXT:    vpsrad $31, %xmm3, %xmm0
; CHECK-NEXT:    vpternlogd {{.*#+}} xmm0 = xmm0 & (xmm2 | xmm1)
; CHECK-NEXT:    retq
  %m = icmp slt <4 x i32> %mask, zeroinitializer
  %a = and <4 x i32> %x, <i32 255, i32 255, i32 255, i32 255>
  %b = or <4 x i32> %a, %y
  %c = select <4 x i1> %m, <4 x i32> %b, <4 x i32> zeroinitializer
  ret <4 x i32> %c
}

define <8 x i32> @ternlog_maskz_or_and_mask_ymm(<8 x i32> %x, <8 x i32> %y, <8 x i32> %mask) {
; CHECK-LABEL: ternlog_maskz_or_and_mask_ymm:
; CHECK:       ## %bb.0:
; CHECK-NEXT:    vpandd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to8}, %ymm0, %ymm3
; CHECK-NEXT:    vpsrad $31, %ymm2, %ymm0
; CHECK-NEXT:    vpternlogd {{.*#+}} ymm0 = ymm0 & (ymm3 | ymm1)
; CHECK-NEXT:    retq
  %m = icmp slt <8 x i32> %mask, zeroinitializer
  %a = and <8 x i32> %x, <i32 -16777216, i32 -16777216, i32 -16777216, i32 -16777216, i32 -16777216, i32 -16777216, i32 -16777216, i32 -16777216>
  %b = or <8 x i32> %a, %y
  %c = select <8 x i1> %m, <8 x i32> %b, <8 x i32> zeroinitializer
  ret <8 x i32> %c
}

define <2 x i64> @ternlog_maskz_xor_and_mask(<2 x i64> %x, <2 x i64> %y, <2 x i64> %mask) {
; CHECK-LABEL: ternlog_maskz_xor_and_mask:
; CHECK:       ## %bb.0:
; CHECK-NEXT:    vpandq {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to2}, %xmm0, %xmm3
; CHECK-NEXT:    vpsraq $63, %xmm2, %xmm0
; CHECK-NEXT:    vpternlogq {{.*#+}} xmm0 = xmm0 & (xmm3 ^ xmm1)
; CHECK-NEXT:    retq
  %m = icmp slt <2 x i64> %mask, zeroinitializer
  %a = and <2 x i64> %x, <i64 1099511627775, i64 1099511627775>
  %b = xor <2 x i64> %a, %y
  %c = select <2 x i1> %m, <2 x i64> %b, <2 x i64> zeroinitializer
  ret <2 x i64> %c
}

define <4 x i64> @ternlog_maskz_xor_and_mask_ymm(<4 x i64> %x, <4 x i64> %y, <4 x i64> %mask) {
; CHECK-LABEL: ternlog_maskz_xor_and_mask_ymm:
; CHECK:       ## %bb.0:
; CHECK-NEXT:    vpandq {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %ymm0, %ymm3
; CHECK-NEXT:    vpsraq $63, %ymm2, %ymm0
; CHECK-NEXT:    vpternlogq {{.*#+}} ymm0 = ymm0 & (ymm3 ^ ymm1)
; CHECK-NEXT:    retq
  %m = icmp slt <4 x i64> %mask, zeroinitializer
  %a = and <4 x i64> %x, <i64 72057594037927935, i64 72057594037927935, i64 72057594037927935, i64 72057594037927935>
  %b = xor <4 x i64> %a, %y
  %c = select <4 x i1> %m, <4 x i64> %b, <4 x i64> zeroinitializer
  ret <4 x i64> %c
}

define <4 x i32> @ternlog_maskx_or_and_mask(<4 x i32> %x, <4 x i32> %y, <4 x i32> %z, <4 x i32> %mask) {
; KNL-LABEL: ternlog_maskx_or_and_mask:
; KNL:       ## %bb.0:
; KNL-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; KNL-NEXT:    vpcmpgtd %xmm3, %xmm2, %k1
; KNL-NEXT:    vpandd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %xmm0, %xmm2
; KNL-NEXT:    vpord %xmm1, %xmm2, %xmm0 {%k1}
; KNL-NEXT:    retq
;
; SKX-LABEL: ternlog_maskx_or_and_mask:
; SKX:       ## %bb.0:
; SKX-NEXT:    vpmovd2m %xmm3, %k1
; SKX-NEXT:    vandps {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %xmm0, %xmm2
; SKX-NEXT:    vorps %xmm1, %xmm2, %xmm0 {%k1}
; SKX-NEXT:    retq
  %m = icmp slt <4 x i32> %mask, zeroinitializer
  %a = and <4 x i32> %x, <i32 255, i32 255, i32 255, i32 255>
  %b = or <4 x i32> %a, %y
  %c = select <4 x i1> %m, <4 x i32> %b, <4 x i32> %x
  ret <4 x i32> %c
}

define <8 x i32> @ternlog_maskx_or_and_mask_ymm(<8 x i32> %x, <8 x i32> %y, <8 x i32> %mask) {
; KNL-LABEL: ternlog_maskx_or_and_mask_ymm:
; KNL:       ## %bb.0:
; KNL-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; KNL-NEXT:    vpcmpgtd %ymm2, %ymm3, %k1
; KNL-NEXT:    vpandd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to8}, %ymm0, %ymm2
; KNL-NEXT:    vpord %ymm1, %ymm2, %ymm0 {%k1}
; KNL-NEXT:    retq
;
; SKX-LABEL: ternlog_maskx_or_and_mask_ymm:
; SKX:       ## %bb.0:
; SKX-NEXT:    vpmovd2m %ymm2, %k1
; SKX-NEXT:    vandps {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to8}, %ymm0, %ymm2
; SKX-NEXT:    vorps %ymm1, %ymm2, %ymm0 {%k1}
; SKX-NEXT:    retq
  %m = icmp slt <8 x i32> %mask, zeroinitializer
  %a = and <8 x i32> %x, <i32 -16777216, i32 -16777216, i32 -16777216, i32 -16777216, i32 -16777216, i32 -16777216, i32 -16777216, i32 -16777216>
  %b = or <8 x i32> %a, %y
  %c = select <8 x i1> %m, <8 x i32> %b, <8 x i32> %x
  ret <8 x i32> %c
}

define <2 x i64> @ternlog_maskx_xor_and_mask(<2 x i64> %x, <2 x i64> %y, <2 x i64> %mask) {
; KNL-LABEL: ternlog_maskx_xor_and_mask:
; KNL:       ## %bb.0:
; KNL-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; KNL-NEXT:    vpcmpgtq %xmm2, %xmm3, %k1
; KNL-NEXT:    vpandq {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to2}, %xmm0, %xmm2
; KNL-NEXT:    vpxorq %xmm1, %xmm2, %xmm0 {%k1}
; KNL-NEXT:    retq
;
; SKX-LABEL: ternlog_maskx_xor_and_mask:
; SKX:       ## %bb.0:
; SKX-NEXT:    vpmovq2m %xmm2, %k1
; SKX-NEXT:    vandpd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to2}, %xmm0, %xmm2
; SKX-NEXT:    vxorpd %xmm1, %xmm2, %xmm0 {%k1}
; SKX-NEXT:    retq
  %m = icmp slt <2 x i64> %mask, zeroinitializer
  %a = and <2 x i64> %x, <i64 1099511627775, i64 1099511627775>
  %b = xor <2 x i64> %a, %y
  %c = select <2 x i1> %m, <2 x i64> %b, <2 x i64> %x
  ret <2 x i64> %c
}

define <4 x i64> @ternlog_maskx_xor_and_mask_ymm(<4 x i64> %x, <4 x i64> %y, <4 x i64> %mask) {
; KNL-LABEL: ternlog_maskx_xor_and_mask_ymm:
; KNL:       ## %bb.0:
; KNL-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; KNL-NEXT:    vpcmpgtq %ymm2, %ymm3, %k1
; KNL-NEXT:    vpandq {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %ymm0, %ymm2
; KNL-NEXT:    vpxorq %ymm1, %ymm2, %ymm0 {%k1}
; KNL-NEXT:    retq
;
; SKX-LABEL: ternlog_maskx_xor_and_mask_ymm:
; SKX:       ## %bb.0:
; SKX-NEXT:    vpmovq2m %ymm2, %k1
; SKX-NEXT:    vandpd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %ymm0, %ymm2
; SKX-NEXT:    vxorpd %ymm1, %ymm2, %ymm0 {%k1}
; SKX-NEXT:    retq
  %m = icmp slt <4 x i64> %mask, zeroinitializer
  %a = and <4 x i64> %x, <i64 72057594037927935, i64 72057594037927935, i64 72057594037927935, i64 72057594037927935>
  %b = xor <4 x i64> %a, %y
  %c = select <4 x i1> %m, <4 x i64> %b, <4 x i64> %x
  ret <4 x i64> %c
}

define <4 x i32> @ternlog_masky_or_and_mask(<4 x i32> %x, <4 x i32> %y, <4 x i32> %z, <4 x i32> %mask) {
; KNL-LABEL: ternlog_masky_or_and_mask:
; KNL:       ## %bb.0:
; KNL-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; KNL-NEXT:    vpcmpgtd %xmm3, %xmm2, %k1
; KNL-NEXT:    vpandd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %xmm0, %xmm0
; KNL-NEXT:    vpord %xmm1, %xmm0, %xmm1 {%k1}
; KNL-NEXT:    vmovdqa %xmm1, %xmm0
; KNL-NEXT:    retq
;
; SKX-LABEL: ternlog_masky_or_and_mask:
; SKX:       ## %bb.0:
; SKX-NEXT:    vpmovd2m %xmm3, %k1
; SKX-NEXT:    vandps {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %xmm0, %xmm0
; SKX-NEXT:    vorps %xmm1, %xmm0, %xmm1 {%k1}
; SKX-NEXT:    vmovaps %xmm1, %xmm0
; SKX-NEXT:    retq
  %m = icmp slt <4 x i32> %mask, zeroinitializer
  %a = and <4 x i32> %x, <i32 255, i32 255, i32 255, i32 255>
  %b = or <4 x i32> %a, %y
  %c = select <4 x i1> %m, <4 x i32> %b, <4 x i32> %y
  ret <4 x i32> %c
}

define <8 x i32> @ternlog_masky_or_and_mask_ymm(<8 x i32> %x, <8 x i32> %y, <8 x i32> %mask) {
; KNL-LABEL: ternlog_masky_or_and_mask_ymm:
; KNL:       ## %bb.0:
; KNL-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; KNL-NEXT:    vpcmpgtd %ymm2, %ymm3, %k1
; KNL-NEXT:    vpandd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to8}, %ymm0, %ymm2
; KNL-NEXT:    vpord %ymm1, %ymm2, %ymm0 {%k1}
; KNL-NEXT:    retq
;
; SKX-LABEL: ternlog_masky_or_and_mask_ymm:
; SKX:       ## %bb.0:
; SKX-NEXT:    vpmovd2m %ymm2, %k1
; SKX-NEXT:    vandps {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to8}, %ymm0, %ymm2
; SKX-NEXT:    vorps %ymm1, %ymm2, %ymm0 {%k1}
; SKX-NEXT:    retq
  %m = icmp slt <8 x i32> %mask, zeroinitializer
  %a = and <8 x i32> %x, <i32 -16777216, i32 -16777216, i32 -16777216, i32 -16777216, i32 -16777216, i32 -16777216, i32 -16777216, i32 -16777216>
  %b = or <8 x i32> %a, %y
  %c = select <8 x i1> %m, <8 x i32> %b, <8 x i32> %x
  ret <8 x i32> %c
}

define <2 x i64> @ternlog_masky_xor_and_mask(<2 x i64> %x, <2 x i64> %y, <2 x i64> %mask) {
; KNL-LABEL: ternlog_masky_xor_and_mask:
; KNL:       ## %bb.0:
; KNL-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; KNL-NEXT:    vpcmpgtq %xmm2, %xmm3, %k1
; KNL-NEXT:    vpandq {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to2}, %xmm0, %xmm0
; KNL-NEXT:    vpxorq %xmm1, %xmm0, %xmm1 {%k1}
; KNL-NEXT:    vmovdqa %xmm1, %xmm0
; KNL-NEXT:    retq
;
; SKX-LABEL: ternlog_masky_xor_and_mask:
; SKX:       ## %bb.0:
; SKX-NEXT:    vpmovq2m %xmm2, %k1
; SKX-NEXT:    vandpd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to2}, %xmm0, %xmm0
; SKX-NEXT:    vxorpd %xmm1, %xmm0, %xmm1 {%k1}
; SKX-NEXT:    vmovapd %xmm1, %xmm0
; SKX-NEXT:    retq
  %m = icmp slt <2 x i64> %mask, zeroinitializer
  %a = and <2 x i64> %x, <i64 1099511627775, i64 1099511627775>
  %b = xor <2 x i64> %a, %y
  %c = select <2 x i1> %m, <2 x i64> %b, <2 x i64> %y
  ret <2 x i64> %c
}

define <4 x i64> @ternlog_masky_xor_and_mask_ymm(<4 x i64> %x, <4 x i64> %y, <4 x i64> %mask) {
; KNL-LABEL: ternlog_masky_xor_and_mask_ymm:
; KNL:       ## %bb.0:
; KNL-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; KNL-NEXT:    vpcmpgtq %ymm2, %ymm3, %k1
; KNL-NEXT:    vpandq {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %ymm0, %ymm0
; KNL-NEXT:    vpxorq %ymm1, %ymm0, %ymm1 {%k1}
; KNL-NEXT:    vmovdqa %ymm1, %ymm0
; KNL-NEXT:    retq
;
; SKX-LABEL: ternlog_masky_xor_and_mask_ymm:
; SKX:       ## %bb.0:
; SKX-NEXT:    vpmovq2m %ymm2, %k1
; SKX-NEXT:    vandpd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %ymm0, %ymm0
; SKX-NEXT:    vxorpd %ymm1, %ymm0, %ymm1 {%k1}
; SKX-NEXT:    vmovapd %ymm1, %ymm0
; SKX-NEXT:    retq
  %m = icmp slt <4 x i64> %mask, zeroinitializer
  %a = and <4 x i64> %x, <i64 72057594037927935, i64 72057594037927935, i64 72057594037927935, i64 72057594037927935>
  %b = xor <4 x i64> %a, %y
  %c = select <4 x i1> %m, <4 x i64> %b, <4 x i64> %y
  ret <4 x i64> %c
}

define <4 x i32> @ternlog_andn_or(<4 x i32> %x, <4 x i32> %y, <4 x i32> %z) {
; CHECK-LABEL: ternlog_andn_or:
; CHECK:       ## %bb.0:
; CHECK-NEXT:    vpternlogd {{.*#+}} xmm0 = ~xmm0 & (xmm1 | xmm2)
; CHECK-NEXT:    retq
  %a = xor <4 x i32> %x, <i32 -1, i32 -1, i32 -1, i32 -1>
  %b = or <4 x i32> %y, %z
  %c = and <4 x i32> %a, %b
  ret <4 x i32> %c
}

define <4 x i32> @ternlog_andn_or_2(<4 x i32> %x, <4 x i32> %y, <4 x i32> %z) {
; CHECK-LABEL: ternlog_andn_or_2:
; CHECK:       ## %bb.0:
; CHECK-NEXT:    vpternlogd {{.*#+}} xmm0 = xmm0 & ~(xmm1 | xmm2)
; CHECK-NEXT:    retq
  %a = or <4 x i32> %y, %z
  %b = xor <4 x i32> %a, <i32 -1, i32 -1, i32 -1, i32 -1>
  %c = and <4 x i32> %x, %b
  ret <4 x i32> %c
}
