; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 2
; RUN: llc < %s -mtriple=x86_64-unknown-unknown | FileCheck %s
; RUN: llc < %s -mtriple=i386-pc-win32 | FileCheck %s -check-prefix=CHECK-WIN

define float @call_exp10f(float %a) nounwind {
; CHECK-LABEL: call_exp10f:
; CHECK:       # %bb.0:
; CHECK-NEXT:    pushq %rax
; CHECK-NEXT:    callq exp10f@PLT
; CHECK-NEXT:    popq %rax
; CHECK-NEXT:    retq
;
; CHECK-WIN-LABEL: call_exp10f:
; CHECK-WIN:       # %bb.0:
; CHECK-WIN-NEXT:    pushl %eax
; CHECK-WIN-NEXT:    flds {{[0-9]+}}(%esp)
; CHECK-WIN-NEXT:    fstps (%esp)
; CHECK-WIN-NEXT:    calll _exp10f
; CHECK-WIN-NEXT:    popl %eax
; CHECK-WIN-NEXT:    retl
  %result = call float @exp10f(float %a)
  ret float %result
}

define double @call_exp10(double %a) nounwind {
; CHECK-LABEL: call_exp10:
; CHECK:       # %bb.0:
; CHECK-NEXT:    pushq %rax
; CHECK-NEXT:    callq exp10@PLT
; CHECK-NEXT:    popq %rax
; CHECK-NEXT:    retq
;
; CHECK-WIN-LABEL: call_exp10:
; CHECK-WIN:       # %bb.0:
; CHECK-WIN-NEXT:    subl $8, %esp
; CHECK-WIN-NEXT:    fldl {{[0-9]+}}(%esp)
; CHECK-WIN-NEXT:    fstpl (%esp)
; CHECK-WIN-NEXT:    calll _exp10
; CHECK-WIN-NEXT:    addl $8, %esp
; CHECK-WIN-NEXT:    retl
  %result = call double @exp10(double %a)
  ret double %result
}

define x86_fp80 @call_exp10l(x86_fp80 %a) nounwind {
; CHECK-LABEL: call_exp10l:
; CHECK:       # %bb.0:
; CHECK-NEXT:    subq $24, %rsp
; CHECK-NEXT:    fldt {{[0-9]+}}(%rsp)
; CHECK-NEXT:    fstpt (%rsp)
; CHECK-NEXT:    callq exp10l@PLT
; CHECK-NEXT:    addq $24, %rsp
; CHECK-NEXT:    retq
;
; CHECK-WIN-LABEL: call_exp10l:
; CHECK-WIN:       # %bb.0:
; CHECK-WIN-NEXT:    pushl %ebp
; CHECK-WIN-NEXT:    movl %esp, %ebp
; CHECK-WIN-NEXT:    andl $-16, %esp
; CHECK-WIN-NEXT:    subl $32, %esp
; CHECK-WIN-NEXT:    fldt 8(%ebp)
; CHECK-WIN-NEXT:    fstpt (%esp)
; CHECK-WIN-NEXT:    calll _exp10l
; CHECK-WIN-NEXT:    movl %ebp, %esp
; CHECK-WIN-NEXT:    popl %ebp
; CHECK-WIN-NEXT:    retl
  %result = call x86_fp80 @exp10l(x86_fp80 %a)
  ret x86_fp80 %result
}

declare float @exp10f(float %a) #0
declare double @exp10(double %a) #0
declare x86_fp80 @exp10l(x86_fp80 %a) #0

attributes #0 = { nounwind readonly }
