; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc < %s -mtriple=i686-unknown -mattr=+sse2 | FileCheck %s --check-prefixes=X86
; RUN: llc < %s -mtriple=x86_64-unknown | FileCheck %s --check-prefixes=X64
; RUN: llc < %s -mtriple=x86_64-unknown -mattr=+avx | FileCheck %s --check-prefixes=AVX

define i32 @combine_f32(float %x) nounwind {
; X86-LABEL: combine_f32:
; X86:       # %bb.0: # %entry
; X86-NEXT:    cvtss2si {{[0-9]+}}(%esp), %eax
; X86-NEXT:    retl
;
; X64-LABEL: combine_f32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    cvtss2si %xmm0, %eax
; X64-NEXT:    retq
;
; AVX-LABEL: combine_f32:
; AVX:       # %bb.0: # %entry
; AVX-NEXT:    vcvtss2si %xmm0, %eax
; AVX-NEXT:    retq
entry:
  %0 = tail call float @llvm.rint.f32(float %x)
  %1 = fptosi float %0 to i32
  ret i32 %1
}

define i32 @combine_f64(double %x) nounwind {
; X86-LABEL: combine_f64:
; X86:       # %bb.0: # %entry
; X86-NEXT:    cvtsd2si {{[0-9]+}}(%esp), %eax
; X86-NEXT:    retl
;
; X64-LABEL: combine_f64:
; X64:       # %bb.0: # %entry
; X64-NEXT:    cvtsd2si %xmm0, %eax
; X64-NEXT:    retq
;
; AVX-LABEL: combine_f64:
; AVX:       # %bb.0: # %entry
; AVX-NEXT:    vcvtsd2si %xmm0, %eax
; AVX-NEXT:    retq
entry:
  %0 = tail call double @llvm.rint.f32(double %x)
  %1 = fptosi double %0 to i32
  ret i32 %1
}

define <4 x i32> @combine_v4f32(<4 x float> %x) nounwind {
; X86-LABEL: combine_v4f32:
; X86:       # %bb.0: # %entry
; X86-NEXT:    cvtps2dq %xmm0, %xmm0
; X86-NEXT:    retl
;
; X64-LABEL: combine_v4f32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    cvtps2dq %xmm0, %xmm0
; X64-NEXT:    retq
;
; AVX-LABEL: combine_v4f32:
; AVX:       # %bb.0: # %entry
; AVX-NEXT:    vcvtps2dq %xmm0, %xmm0
; AVX-NEXT:    retq
entry:
  %0 = tail call <4 x float> @llvm.rint.v4f32(<4 x float> %x)
  %1 = fptosi <4 x float> %0 to <4 x i32>
  ret <4 x i32> %1
}

define <2 x i32> @combine_v2f64(<2 x double> %x) nounwind {
; X86-LABEL: combine_v2f64:
; X86:       # %bb.0: # %entry
; X86-NEXT:    cvtpd2dq %xmm0, %xmm0
; X86-NEXT:    retl
;
; X64-LABEL: combine_v2f64:
; X64:       # %bb.0: # %entry
; X64-NEXT:    cvtpd2dq %xmm0, %xmm0
; X64-NEXT:    retq
;
; AVX-LABEL: combine_v2f64:
; AVX:       # %bb.0: # %entry
; AVX-NEXT:    vcvtpd2dq %xmm0, %xmm0
; AVX-NEXT:    retq
entry:
  %0 = tail call <2 x double> @llvm.rint.v2f64(<2 x double> %x)
  %1 = fptosi <2 x double> %0 to <2 x i32>
  ret <2 x i32> %1
}

define <4 x i32> @combine_v4f64(<4 x double> %x) nounwind {
; X86-LABEL: combine_v4f64:
; X86:       # %bb.0: # %entry
; X86-NEXT:    cvtpd2dq %xmm1, %xmm1
; X86-NEXT:    cvtpd2dq %xmm0, %xmm0
; X86-NEXT:    movlhps {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; X86-NEXT:    retl
;
; X64-LABEL: combine_v4f64:
; X64:       # %bb.0: # %entry
; X64-NEXT:    cvtpd2dq %xmm1, %xmm1
; X64-NEXT:    cvtpd2dq %xmm0, %xmm0
; X64-NEXT:    movlhps {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; X64-NEXT:    retq
;
; AVX-LABEL: combine_v4f64:
; AVX:       # %bb.0: # %entry
; AVX-NEXT:    vcvtpd2dq %ymm0, %xmm0
; AVX-NEXT:    vzeroupper
; AVX-NEXT:    retq
entry:
  %0 = tail call <4 x double> @llvm.rint.v4f64(<4 x double> %x)
  %1 = fptosi <4 x double> %0 to <4 x i32>
  ret <4 x i32> %1
}
