; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -verify-machineinstrs < %s | FileCheck %s

; Check that we can handle gc.relocate in a separate block in spill mode.

target triple = "x86_64-pc-linux-gnu"

declare void @"some_call"(ptr addrspace(1))
declare i32 @"personality_function"()

define ptr addrspace(1) @test_invoke(ptr addrspace(1) %a, ptr addrspace(1) %b, ptr addrspace(1) %c, ptr addrspace(1) %d, ptr addrspace(1) %e, ptr addrspace(1) %f, ptr addrspace(1) %g, ptr addrspace(1) %h, ptr addrspace(1) %j, ptr addrspace(1) %k, ptr addrspace(1) %l, ptr addrspace(1) %m, ptr addrspace(1) %n, ptr addrspace(1) %o, ptr addrspace(1) %p, ptr addrspace(1) %q, ptr addrspace(1) %r, ptr addrspace(1) %s, ptr addrspace(1) %t)
; CHECK-LABEL: test_invoke:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    pushq %rax
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    movq {{[0-9]+}}(%rsp), %rdi
; CHECK-NEXT:    movq %rdi, (%rsp)
; CHECK-NEXT:  .Ltmp0:
; CHECK-NEXT:    callq some_call@PLT
; CHECK-NEXT:  .Ltmp3:
; CHECK-NEXT:  .Ltmp1:
; CHECK-NEXT:  # %bb.1: # %invoke_safepoint_normal_dest
; CHECK-NEXT:    movq (%rsp), %rax
; CHECK-NEXT:    popq %rcx
; CHECK-NEXT:    .cfi_def_cfa_offset 8
; CHECK-NEXT:    retq
; CHECK-NEXT:  .LBB0_2: # %exceptional_return
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:  .Ltmp2:
; CHECK-NEXT:    xorl %eax, %eax
; CHECK-NEXT:    popq %rcx
; CHECK-NEXT:    .cfi_def_cfa_offset 8
; CHECK-NEXT:    retq
gc "statepoint-example" personality ptr @"personality_function" {
entry:
  %0 = invoke token (i64, i32, ptr, i32, i32, ...) @llvm.experimental.gc.statepoint.p0(i64 0, i32 0, ptr elementtype(void (ptr addrspace(1))) @some_call, i32 1, i32 0, ptr addrspace(1) %t, i32 0, i32 0) ["gc-live" (ptr addrspace(1) %t)]
          to label %invoke_safepoint_normal_dest unwind label %exceptional_return

invoke_safepoint_normal_dest:
  %t.relocated = call coldcc ptr addrspace(1) @llvm.experimental.gc.relocate.p1(token %0, i32 0, i32 0)
  ret ptr addrspace(1) %t.relocated

exceptional_return:
  %landing_pad = landingpad token
          cleanup
  ret ptr addrspace(1) null
}

define ptr addrspace(1) @test_call(ptr addrspace(1) %a, ptr addrspace(1) %b, ptr addrspace(1) %c, ptr addrspace(1) %d, ptr addrspace(1) %e, ptr addrspace(1) %f, ptr addrspace(1) %g, ptr addrspace(1) %h, ptr addrspace(1) %j, ptr addrspace(1) %k, ptr addrspace(1) %l, ptr addrspace(1) %m, ptr addrspace(1) %n, ptr addrspace(1) %o, ptr addrspace(1) %p, ptr addrspace(1) %q, ptr addrspace(1) %r, ptr addrspace(1) %s, ptr addrspace(1) %t)
; CHECK-LABEL: test_call:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    pushq %rax
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    movq {{[0-9]+}}(%rsp), %rdi
; CHECK-NEXT:    movq %rdi, (%rsp)
; CHECK-NEXT:    callq some_call@PLT
; CHECK-NEXT:  .Ltmp4:
; CHECK-NEXT:    movq (%rsp), %rax
; CHECK-NEXT:    popq %rcx
; CHECK-NEXT:    .cfi_def_cfa_offset 8
; CHECK-NEXT:    retq
gc "statepoint-example" personality ptr @"personality_function" {
entry:
  %0 = call token (i64, i32, ptr, i32, i32, ...) @llvm.experimental.gc.statepoint.p0(i64 0, i32 0, ptr elementtype(void (ptr addrspace(1))) @some_call, i32 1, i32 0, ptr addrspace(1) %t, i32 0, i32 0) ["gc-live" (ptr addrspace(1) %t)]
  br label %other_block

other_block:
  %t.relocated = call coldcc ptr addrspace(1) @llvm.experimental.gc.relocate.p1(token %0, i32 0, i32 0)
  ret ptr addrspace(1) %t.relocated
}
declare token @llvm.experimental.gc.statepoint.p0(i64, i32, ptr, i32, i32, ...)
declare ptr addrspace(1) @llvm.experimental.gc.relocate.p1(token, i32, i32)
