; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-linux -mattr=+ssse3 | FileCheck %s --check-prefixes=CHECK,CHECK-LIN
; RUN: llc < %s -mtriple=x86_64-win32 -mattr=+ssse3 | FileCheck %s --check-prefixes=CHECK,CHECK-WIN

define <8 x i32> @a(<8 x i16> %a) nounwind {
; CHECK-LIN-LABEL: a:
; CHECK-LIN:       # %bb.0:
; CHECK-LIN-NEXT:    punpcklwd {{.*#+}} xmm2 = xmm2[0],xmm0[0],xmm2[1],xmm0[1],xmm2[2],xmm0[2],xmm2[3],xmm0[3]
; CHECK-LIN-NEXT:    psrad $16, %xmm2
; CHECK-LIN-NEXT:    punpckhwd {{.*#+}} xmm1 = xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; CHECK-LIN-NEXT:    psrad $16, %xmm1
; CHECK-LIN-NEXT:    movdqa %xmm2, %xmm0
; CHECK-LIN-NEXT:    retq
;
; CHECK-WIN-LABEL: a:
; CHECK-WIN:       # %bb.0:
; CHECK-WIN-NEXT:    movdqa (%rcx), %xmm1
; CHECK-WIN-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; CHECK-WIN-NEXT:    psrad $16, %xmm0
; CHECK-WIN-NEXT:    punpckhwd {{.*#+}} xmm1 = xmm1[4,4,5,5,6,6,7,7]
; CHECK-WIN-NEXT:    psrad $16, %xmm1
; CHECK-WIN-NEXT:    retq
  %c = sext <8 x i16> %a to <8 x i32>
  ret <8 x i32> %c
}

define <3 x i32> @b(<3 x i16> %a) nounwind {
; CHECK-LIN-LABEL: b:
; CHECK-LIN:       # %bb.0:
; CHECK-LIN-NEXT:    pxor %xmm0, %xmm0
; CHECK-LIN-NEXT:    pinsrw $1, %edi, %xmm0
; CHECK-LIN-NEXT:    pinsrw $3, %esi, %xmm0
; CHECK-LIN-NEXT:    pinsrw $5, %edx, %xmm0
; CHECK-LIN-NEXT:    psrad $16, %xmm0
; CHECK-LIN-NEXT:    retq
;
; CHECK-WIN-LABEL: b:
; CHECK-WIN:       # %bb.0:
; CHECK-WIN-NEXT:    # kill: def $r8w killed $r8w def $r8d
; CHECK-WIN-NEXT:    # kill: def $dx killed $dx def $edx
; CHECK-WIN-NEXT:    # kill: def $cx killed $cx def $ecx
; CHECK-WIN-NEXT:    pxor %xmm0, %xmm0
; CHECK-WIN-NEXT:    pinsrw $1, %ecx, %xmm0
; CHECK-WIN-NEXT:    pinsrw $3, %edx, %xmm0
; CHECK-WIN-NEXT:    pinsrw $5, %r8d, %xmm0
; CHECK-WIN-NEXT:    psrad $16, %xmm0
; CHECK-WIN-NEXT:    retq
  %c = sext <3 x i16> %a to <3 x i32>
  ret <3 x i32> %c
}

define <1 x i32> @c(<1 x i16> %a) nounwind {
; CHECK-LIN-LABEL: c:
; CHECK-LIN:       # %bb.0:
; CHECK-LIN-NEXT:    movswl %di, %eax
; CHECK-LIN-NEXT:    retq
;
; CHECK-WIN-LABEL: c:
; CHECK-WIN:       # %bb.0:
; CHECK-WIN-NEXT:    movswl %cx, %eax
; CHECK-WIN-NEXT:    retq
  %c = sext <1 x i16> %a to <1 x i32>
  ret <1 x i32> %c
}

define <8 x i32> @d(<8 x i16> %a) nounwind {
; CHECK-LIN-LABEL: d:
; CHECK-LIN:       # %bb.0:
; CHECK-LIN-NEXT:    movdqa %xmm0, %xmm1
; CHECK-LIN-NEXT:    pxor %xmm2, %xmm2
; CHECK-LIN-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0],xmm2[0],xmm0[1],xmm2[1],xmm0[2],xmm2[2],xmm0[3],xmm2[3]
; CHECK-LIN-NEXT:    punpckhwd {{.*#+}} xmm1 = xmm1[4],xmm2[4],xmm1[5],xmm2[5],xmm1[6],xmm2[6],xmm1[7],xmm2[7]
; CHECK-LIN-NEXT:    retq
;
; CHECK-WIN-LABEL: d:
; CHECK-WIN:       # %bb.0:
; CHECK-WIN-NEXT:    movdqa (%rcx), %xmm1
; CHECK-WIN-NEXT:    pxor %xmm2, %xmm2
; CHECK-WIN-NEXT:    movdqa %xmm1, %xmm0
; CHECK-WIN-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0],xmm2[0],xmm0[1],xmm2[1],xmm0[2],xmm2[2],xmm0[3],xmm2[3]
; CHECK-WIN-NEXT:    punpckhwd {{.*#+}} xmm1 = xmm1[4],xmm2[4],xmm1[5],xmm2[5],xmm1[6],xmm2[6],xmm1[7],xmm2[7]
; CHECK-WIN-NEXT:    retq
  %c = zext <8 x i16> %a to <8 x i32>
  ret <8 x i32> %c
}

define <3 x i32> @e(<3 x i16> %a) nounwind {
; CHECK-LIN-LABEL: e:
; CHECK-LIN:       # %bb.0:
; CHECK-LIN-NEXT:    movzwl %di, %eax
; CHECK-LIN-NEXT:    movd %eax, %xmm0
; CHECK-LIN-NEXT:    pinsrw $2, %esi, %xmm0
; CHECK-LIN-NEXT:    pinsrw $4, %edx, %xmm0
; CHECK-LIN-NEXT:    retq
;
; CHECK-WIN-LABEL: e:
; CHECK-WIN:       # %bb.0:
; CHECK-WIN-NEXT:    # kill: def $r8w killed $r8w def $r8d
; CHECK-WIN-NEXT:    # kill: def $dx killed $dx def $edx
; CHECK-WIN-NEXT:    movzwl %cx, %eax
; CHECK-WIN-NEXT:    movd %eax, %xmm0
; CHECK-WIN-NEXT:    pinsrw $2, %edx, %xmm0
; CHECK-WIN-NEXT:    pinsrw $4, %r8d, %xmm0
; CHECK-WIN-NEXT:    retq
  %c = zext <3 x i16> %a to <3 x i32>
  ret <3 x i32> %c
}

define <1 x i32> @f(<1 x i16> %a) nounwind {
; CHECK-LIN-LABEL: f:
; CHECK-LIN:       # %bb.0:
; CHECK-LIN-NEXT:    movzwl %di, %eax
; CHECK-LIN-NEXT:    retq
;
; CHECK-WIN-LABEL: f:
; CHECK-WIN:       # %bb.0:
; CHECK-WIN-NEXT:    movzwl %cx, %eax
; CHECK-WIN-NEXT:    retq
  %c = zext <1 x i16> %a to <1 x i32>
  ret <1 x i32> %c
}

define <8 x i16> @g(<8 x i32> %a) nounwind {
; CHECK-LIN-LABEL: g:
; CHECK-LIN:       # %bb.0:
; CHECK-LIN-NEXT:    movdqa {{.*#+}} xmm2 = [0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15]
; CHECK-LIN-NEXT:    pshufb %xmm2, %xmm1
; CHECK-LIN-NEXT:    pshufb %xmm2, %xmm0
; CHECK-LIN-NEXT:    punpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; CHECK-LIN-NEXT:    retq
;
; CHECK-WIN-LABEL: g:
; CHECK-WIN:       # %bb.0:
; CHECK-WIN-NEXT:    movdqa (%rcx), %xmm0
; CHECK-WIN-NEXT:    movdqa (%rdx), %xmm1
; CHECK-WIN-NEXT:    movdqa {{.*#+}} xmm2 = [0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15]
; CHECK-WIN-NEXT:    pshufb %xmm2, %xmm1
; CHECK-WIN-NEXT:    pshufb %xmm2, %xmm0
; CHECK-WIN-NEXT:    punpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; CHECK-WIN-NEXT:    retq
  %c = trunc <8 x i32> %a to <8 x i16>
  ret <8 x i16> %c
}

define <3 x i16> @h(<3 x i32> %a) nounwind {
; CHECK-LIN-LABEL: h:
; CHECK-LIN:       # %bb.0:
; CHECK-LIN-NEXT:    movd %xmm0, %eax
; CHECK-LIN-NEXT:    pextrw $2, %xmm0, %edx
; CHECK-LIN-NEXT:    pextrw $4, %xmm0, %ecx
; CHECK-LIN-NEXT:    # kill: def $ax killed $ax killed $eax
; CHECK-LIN-NEXT:    # kill: def $dx killed $dx killed $edx
; CHECK-LIN-NEXT:    # kill: def $cx killed $cx killed $ecx
; CHECK-LIN-NEXT:    retq
;
; CHECK-WIN-LABEL: h:
; CHECK-WIN:       # %bb.0:
; CHECK-WIN-NEXT:    movdqa (%rcx), %xmm0
; CHECK-WIN-NEXT:    movl (%rcx), %eax
; CHECK-WIN-NEXT:    pextrw $2, %xmm0, %edx
; CHECK-WIN-NEXT:    pextrw $4, %xmm0, %ecx
; CHECK-WIN-NEXT:    # kill: def $ax killed $ax killed $eax
; CHECK-WIN-NEXT:    # kill: def $dx killed $dx killed $edx
; CHECK-WIN-NEXT:    # kill: def $cx killed $cx killed $ecx
; CHECK-WIN-NEXT:    retq
  %c = trunc <3 x i32> %a to <3 x i16>
  ret <3 x i16> %c
}

define <1 x i16> @i(<1 x i32> %a) nounwind {
; CHECK-LIN-LABEL: i:
; CHECK-LIN:       # %bb.0:
; CHECK-LIN-NEXT:    movl %edi, %eax
; CHECK-LIN-NEXT:    # kill: def $ax killed $ax killed $eax
; CHECK-LIN-NEXT:    retq
;
; CHECK-WIN-LABEL: i:
; CHECK-WIN:       # %bb.0:
; CHECK-WIN-NEXT:    movl %ecx, %eax
; CHECK-WIN-NEXT:    # kill: def $ax killed $ax killed $eax
; CHECK-WIN-NEXT:    retq
  %c = trunc <1 x i32> %a to <1 x i16>
  ret <1 x i16> %c
}

; PR6438
define void @__OpenCL_math_kernel4_kernel() nounwind {
; CHECK-LABEL: __OpenCL_math_kernel4_kernel:
; CHECK:       # %bb.0:
; CHECK-NEXT:    retq
  %tmp12.i = and <4 x i32> zeroinitializer, <i32 2139095040, i32 2139095040, i32 2139095040, i32 2139095040> ; <<4 x i32>> [#uses=1]
  %cmp13.i = icmp eq <4 x i32> %tmp12.i, <i32 2139095040, i32 2139095040, i32 2139095040, i32 2139095040> ; <<4 x i1>> [#uses=2]
  %cmp.ext14.i = sext <4 x i1> %cmp13.i to <4 x i32> ; <<4 x i32>> [#uses=0]
  %tmp2110.i = and <4 x i1> %cmp13.i, zeroinitializer ; <<4 x i1>> [#uses=0]
  ret void
}
