#![doc = " fiat-crypto output postprocessed by fiat-constify: https://github.com/rustcrypto/utils"]
#![doc = " Autogenerated: 'src/ExtractionOCaml/word_by_word_montgomery' --lang Rust --inline p384_scalar 32 '2^384 - 1388124618062372383947042015309946732620727252194336364173' mul square add sub opp from_montgomery to_montgomery nonzero selectznz to_bytes from_bytes one msat divstep divstep_precomp"]
#![doc = " curve description: p384_scalar"]
#![doc = " machine_wordsize = 32 (from \"32\")"]
#![doc = " requested operations: mul, square, add, sub, opp, from_montgomery, to_montgomery, nonzero, selectznz, to_bytes, from_bytes, one, msat, divstep, divstep_precomp"]
#![doc = " m = 0xffffffffffffffffffffffffffffffffffffffffffffffffc7634d81f4372ddf581a0db248b0a77aecec196accc52973 (from \"2^384 - 1388124618062372383947042015309946732620727252194336364173\")"]
#![doc = ""]
#![doc = " NOTE: In addition to the bounds specified above each function, all"]
#![doc = "   functions synthesized for this Montgomery arithmetic require the"]
#![doc = "   input to be strictly less than the prime modulus (m), and also"]
#![doc = "   require the input to be in the unique saturated representation."]
#![doc = "   All functions also ensure that these two properties are true of"]
#![doc = "   return values."]
#![doc = ""]
#![doc = " Computed values:"]
#![doc = "   eval z = z[0] + (z[1] << 32) + (z[2] << 64) + (z[3] << 96) + (z[4] << 128) + (z[5] << 160) + (z[6] << 192) + (z[7] << 224) + (z[8] << 256) + (z[9] << 0x120) + (z[10] << 0x140) + (z[11] << 0x160)"]
#![doc = "   bytes_eval z = z[0] + (z[1] << 8) + (z[2] << 16) + (z[3] << 24) + (z[4] << 32) + (z[5] << 40) + (z[6] << 48) + (z[7] << 56) + (z[8] << 64) + (z[9] << 72) + (z[10] << 80) + (z[11] << 88) + (z[12] << 96) + (z[13] << 104) + (z[14] << 112) + (z[15] << 120) + (z[16] << 128) + (z[17] << 136) + (z[18] << 144) + (z[19] << 152) + (z[20] << 160) + (z[21] << 168) + (z[22] << 176) + (z[23] << 184) + (z[24] << 192) + (z[25] << 200) + (z[26] << 208) + (z[27] << 216) + (z[28] << 224) + (z[29] << 232) + (z[30] << 240) + (z[31] << 248) + (z[32] << 256) + (z[33] << 0x108) + (z[34] << 0x110) + (z[35] << 0x118) + (z[36] << 0x120) + (z[37] << 0x128) + (z[38] << 0x130) + (z[39] << 0x138) + (z[40] << 0x140) + (z[41] << 0x148) + (z[42] << 0x150) + (z[43] << 0x158) + (z[44] << 0x160) + (z[45] << 0x168) + (z[46] << 0x170) + (z[47] << 0x178)"]
#![doc = "   twos_complement_eval z = let x1 := z[0] + (z[1] << 32) + (z[2] << 64) + (z[3] << 96) + (z[4] << 128) + (z[5] << 160) + (z[6] << 192) + (z[7] << 224) + (z[8] << 256) + (z[9] << 0x120) + (z[10] << 0x140) + (z[11] << 0x160) in"]
#![doc = "                            if x1 & (2^384-1) < 2^383 then x1 & (2^384-1) else (x1 & (2^384-1)) - 2^384"]
#![allow(unused_parens)]
#![allow(non_camel_case_types)]
#![allow(
    dead_code,
    rustdoc::bare_urls,
    rustdoc::broken_intra_doc_links,
    unused_assignments,
    unused_mut,
    unused_variables
)]
pub type fiat_p384_scalar_u1 = u8;
pub type fiat_p384_scalar_i1 = i8;
pub type fiat_p384_scalar_u2 = u8;
pub type fiat_p384_scalar_i2 = i8;
pub type fiat_p384_scalar_montgomery_domain_field_element = [u32; 12];
pub type fiat_p384_scalar_non_montgomery_domain_field_element = [u32; 12];
#[doc = " The function fiat_p384_scalar_addcarryx_u32 is an addition with carry."]
#[doc = ""]
#[doc = " Postconditions:"]
#[doc = "   out1 = (arg1 + arg2 + arg3) mod 2^32"]
#[doc = "   out2 = ⌊(arg1 + arg2 + arg3) / 2^32⌋"]
#[doc = ""]
#[doc = " Input Bounds:"]
#[doc = "   arg1: [0x0 ~> 0x1]"]
#[doc = "   arg2: [0x0 ~> 0xffffffff]"]
#[doc = "   arg3: [0x0 ~> 0xffffffff]"]
#[doc = " Output Bounds:"]
#[doc = "   out1: [0x0 ~> 0xffffffff]"]
#[doc = "   out2: [0x0 ~> 0x1]"]
#[inline]
pub const fn fiat_p384_scalar_addcarryx_u32(
    arg1: fiat_p384_scalar_u1,
    arg2: u32,
    arg3: u32,
) -> (u32, fiat_p384_scalar_u1) {
    let mut out1: u32 = 0;
    let mut out2: fiat_p384_scalar_u1 = 0;
    let x1: u64 = (((arg1 as u64) + (arg2 as u64)) + (arg3 as u64));
    let x2: u32 = ((x1 & (0xffffffff as u64)) as u32);
    let x3: fiat_p384_scalar_u1 = ((x1 >> 32) as fiat_p384_scalar_u1);
    out1 = x2;
    out2 = x3;
    (out1, out2)
}
#[doc = " The function fiat_p384_scalar_subborrowx_u32 is a subtraction with borrow."]
#[doc = ""]
#[doc = " Postconditions:"]
#[doc = "   out1 = (-arg1 + arg2 + -arg3) mod 2^32"]
#[doc = "   out2 = -⌊(-arg1 + arg2 + -arg3) / 2^32⌋"]
#[doc = ""]
#[doc = " Input Bounds:"]
#[doc = "   arg1: [0x0 ~> 0x1]"]
#[doc = "   arg2: [0x0 ~> 0xffffffff]"]
#[doc = "   arg3: [0x0 ~> 0xffffffff]"]
#[doc = " Output Bounds:"]
#[doc = "   out1: [0x0 ~> 0xffffffff]"]
#[doc = "   out2: [0x0 ~> 0x1]"]
#[inline]
pub const fn fiat_p384_scalar_subborrowx_u32(
    arg1: fiat_p384_scalar_u1,
    arg2: u32,
    arg3: u32,
) -> (u32, fiat_p384_scalar_u1) {
    let mut out1: u32 = 0;
    let mut out2: fiat_p384_scalar_u1 = 0;
    let x1: i64 = (((arg2 as i64) - (arg1 as i64)) - (arg3 as i64));
    let x2: fiat_p384_scalar_i1 = ((x1 >> 32) as fiat_p384_scalar_i1);
    let x3: u32 = ((x1 & (0xffffffff as i64)) as u32);
    out1 = x3;
    out2 = (((0x0 as fiat_p384_scalar_i2) - (x2 as fiat_p384_scalar_i2)) as fiat_p384_scalar_u1);
    (out1, out2)
}
#[doc = " The function fiat_p384_scalar_mulx_u32 is a multiplication, returning the full double-width result."]
#[doc = ""]
#[doc = " Postconditions:"]
#[doc = "   out1 = (arg1 * arg2) mod 2^32"]
#[doc = "   out2 = ⌊arg1 * arg2 / 2^32⌋"]
#[doc = ""]
#[doc = " Input Bounds:"]
#[doc = "   arg1: [0x0 ~> 0xffffffff]"]
#[doc = "   arg2: [0x0 ~> 0xffffffff]"]
#[doc = " Output Bounds:"]
#[doc = "   out1: [0x0 ~> 0xffffffff]"]
#[doc = "   out2: [0x0 ~> 0xffffffff]"]
#[inline]
pub const fn fiat_p384_scalar_mulx_u32(arg1: u32, arg2: u32) -> (u32, u32) {
    let mut out1: u32 = 0;
    let mut out2: u32 = 0;
    let x1: u64 = ((arg1 as u64) * (arg2 as u64));
    let x2: u32 = ((x1 & (0xffffffff as u64)) as u32);
    let x3: u32 = ((x1 >> 32) as u32);
    out1 = x2;
    out2 = x3;
    (out1, out2)
}
#[doc = " The function fiat_p384_scalar_cmovznz_u32 is a single-word conditional move."]
#[doc = ""]
#[doc = " Postconditions:"]
#[doc = "   out1 = (if arg1 = 0 then arg2 else arg3)"]
#[doc = ""]
#[doc = " Input Bounds:"]
#[doc = "   arg1: [0x0 ~> 0x1]"]
#[doc = "   arg2: [0x0 ~> 0xffffffff]"]
#[doc = "   arg3: [0x0 ~> 0xffffffff]"]
#[doc = " Output Bounds:"]
#[doc = "   out1: [0x0 ~> 0xffffffff]"]
#[inline]
pub const fn fiat_p384_scalar_cmovznz_u32(arg1: fiat_p384_scalar_u1, arg2: u32, arg3: u32) -> u32 {
    let mut out1: u32 = 0;
    let x1: fiat_p384_scalar_u1 = (!(!arg1));
    let x2: u32 = ((((((0x0 as fiat_p384_scalar_i2) - (x1 as fiat_p384_scalar_i2))
        as fiat_p384_scalar_i1) as i64)
        & (0xffffffff as i64)) as u32);
    let x3: u32 = ((x2 & arg3) | ((!x2) & arg2));
    out1 = x3;
    out1
}
#[doc = " The function fiat_p384_scalar_mul multiplies two field elements in the Montgomery domain."]
#[doc = ""]
#[doc = " Preconditions:"]
#[doc = "   0 ≤ eval arg1 < m"]
#[doc = "   0 ≤ eval arg2 < m"]
#[doc = " Postconditions:"]
#[doc = "   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) * eval (from_montgomery arg2)) mod m"]
#[doc = "   0 ≤ eval out1 < m"]
#[doc = ""]
#[inline]
pub const fn fiat_p384_scalar_mul(
    arg1: &fiat_p384_scalar_montgomery_domain_field_element,
    arg2: &fiat_p384_scalar_montgomery_domain_field_element,
) -> fiat_p384_scalar_montgomery_domain_field_element {
    let mut out1: fiat_p384_scalar_montgomery_domain_field_element = [0; 12];
    let x1: u32 = (arg1[1]);
    let x2: u32 = (arg1[2]);
    let x3: u32 = (arg1[3]);
    let x4: u32 = (arg1[4]);
    let x5: u32 = (arg1[5]);
    let x6: u32 = (arg1[6]);
    let x7: u32 = (arg1[7]);
    let x8: u32 = (arg1[8]);
    let x9: u32 = (arg1[9]);
    let x10: u32 = (arg1[10]);
    let x11: u32 = (arg1[11]);
    let x12: u32 = (arg1[0]);
    let (x13, x14) = fiat_p384_scalar_mulx_u32(x12, (arg2[11]));
    let (x15, x16) = fiat_p384_scalar_mulx_u32(x12, (arg2[10]));
    let (x17, x18) = fiat_p384_scalar_mulx_u32(x12, (arg2[9]));
    let (x19, x20) = fiat_p384_scalar_mulx_u32(x12, (arg2[8]));
    let (x21, x22) = fiat_p384_scalar_mulx_u32(x12, (arg2[7]));
    let (x23, x24) = fiat_p384_scalar_mulx_u32(x12, (arg2[6]));
    let (x25, x26) = fiat_p384_scalar_mulx_u32(x12, (arg2[5]));
    let (x27, x28) = fiat_p384_scalar_mulx_u32(x12, (arg2[4]));
    let (x29, x30) = fiat_p384_scalar_mulx_u32(x12, (arg2[3]));
    let (x31, x32) = fiat_p384_scalar_mulx_u32(x12, (arg2[2]));
    let (x33, x34) = fiat_p384_scalar_mulx_u32(x12, (arg2[1]));
    let (x35, x36) = fiat_p384_scalar_mulx_u32(x12, (arg2[0]));
    let (x37, x38) = fiat_p384_scalar_addcarryx_u32(0x0, x36, x33);
    let (x39, x40) = fiat_p384_scalar_addcarryx_u32(x38, x34, x31);
    let (x41, x42) = fiat_p384_scalar_addcarryx_u32(x40, x32, x29);
    let (x43, x44) = fiat_p384_scalar_addcarryx_u32(x42, x30, x27);
    let (x45, x46) = fiat_p384_scalar_addcarryx_u32(x44, x28, x25);
    let (x47, x48) = fiat_p384_scalar_addcarryx_u32(x46, x26, x23);
    let (x49, x50) = fiat_p384_scalar_addcarryx_u32(x48, x24, x21);
    let (x51, x52) = fiat_p384_scalar_addcarryx_u32(x50, x22, x19);
    let (x53, x54) = fiat_p384_scalar_addcarryx_u32(x52, x20, x17);
    let (x55, x56) = fiat_p384_scalar_addcarryx_u32(x54, x18, x15);
    let (x57, x58) = fiat_p384_scalar_addcarryx_u32(x56, x16, x13);
    let x59: u32 = ((x58 as u32) + x14);
    let (x60, x61) = fiat_p384_scalar_mulx_u32(x35, 0xe88fdc45);
    let (x62, x63) = fiat_p384_scalar_mulx_u32(x60, 0xffffffff);
    let (x64, x65) = fiat_p384_scalar_mulx_u32(x60, 0xffffffff);
    let (x66, x67) = fiat_p384_scalar_mulx_u32(x60, 0xffffffff);
    let (x68, x69) = fiat_p384_scalar_mulx_u32(x60, 0xffffffff);
    let (x70, x71) = fiat_p384_scalar_mulx_u32(x60, 0xffffffff);
    let (x72, x73) = fiat_p384_scalar_mulx_u32(x60, 0xffffffff);
    let (x74, x75) = fiat_p384_scalar_mulx_u32(x60, 0xc7634d81);
    let (x76, x77) = fiat_p384_scalar_mulx_u32(x60, 0xf4372ddf);
    let (x78, x79) = fiat_p384_scalar_mulx_u32(x60, 0x581a0db2);
    let (x80, x81) = fiat_p384_scalar_mulx_u32(x60, 0x48b0a77a);
    let (x82, x83) = fiat_p384_scalar_mulx_u32(x60, 0xecec196a);
    let (x84, x85) = fiat_p384_scalar_mulx_u32(x60, 0xccc52973);
    let (x86, x87) = fiat_p384_scalar_addcarryx_u32(0x0, x85, x82);
    let (x88, x89) = fiat_p384_scalar_addcarryx_u32(x87, x83, x80);
    let (x90, x91) = fiat_p384_scalar_addcarryx_u32(x89, x81, x78);
    let (x92, x93) = fiat_p384_scalar_addcarryx_u32(x91, x79, x76);
    let (x94, x95) = fiat_p384_scalar_addcarryx_u32(x93, x77, x74);
    let (x96, x97) = fiat_p384_scalar_addcarryx_u32(x95, x75, x72);
    let (x98, x99) = fiat_p384_scalar_addcarryx_u32(x97, x73, x70);
    let (x100, x101) = fiat_p384_scalar_addcarryx_u32(x99, x71, x68);
    let (x102, x103) = fiat_p384_scalar_addcarryx_u32(x101, x69, x66);
    let (x104, x105) = fiat_p384_scalar_addcarryx_u32(x103, x67, x64);
    let (x106, x107) = fiat_p384_scalar_addcarryx_u32(x105, x65, x62);
    let x108: u32 = ((x107 as u32) + x63);
    let (x109, x110) = fiat_p384_scalar_addcarryx_u32(0x0, x35, x84);
    let (x111, x112) = fiat_p384_scalar_addcarryx_u32(x110, x37, x86);
    let (x113, x114) = fiat_p384_scalar_addcarryx_u32(x112, x39, x88);
    let (x115, x116) = fiat_p384_scalar_addcarryx_u32(x114, x41, x90);
    let (x117, x118) = fiat_p384_scalar_addcarryx_u32(x116, x43, x92);
    let (x119, x120) = fiat_p384_scalar_addcarryx_u32(x118, x45, x94);
    let (x121, x122) = fiat_p384_scalar_addcarryx_u32(x120, x47, x96);
    let (x123, x124) = fiat_p384_scalar_addcarryx_u32(x122, x49, x98);
    let (x125, x126) = fiat_p384_scalar_addcarryx_u32(x124, x51, x100);
    let (x127, x128) = fiat_p384_scalar_addcarryx_u32(x126, x53, x102);
    let (x129, x130) = fiat_p384_scalar_addcarryx_u32(x128, x55, x104);
    let (x131, x132) = fiat_p384_scalar_addcarryx_u32(x130, x57, x106);
    let (x133, x134) = fiat_p384_scalar_addcarryx_u32(x132, x59, x108);
    let (x135, x136) = fiat_p384_scalar_mulx_u32(x1, (arg2[11]));
    let (x137, x138) = fiat_p384_scalar_mulx_u32(x1, (arg2[10]));
    let (x139, x140) = fiat_p384_scalar_mulx_u32(x1, (arg2[9]));
    let (x141, x142) = fiat_p384_scalar_mulx_u32(x1, (arg2[8]));
    let (x143, x144) = fiat_p384_scalar_mulx_u32(x1, (arg2[7]));
    let (x145, x146) = fiat_p384_scalar_mulx_u32(x1, (arg2[6]));
    let (x147, x148) = fiat_p384_scalar_mulx_u32(x1, (arg2[5]));
    let (x149, x150) = fiat_p384_scalar_mulx_u32(x1, (arg2[4]));
    let (x151, x152) = fiat_p384_scalar_mulx_u32(x1, (arg2[3]));
    let (x153, x154) = fiat_p384_scalar_mulx_u32(x1, (arg2[2]));
    let (x155, x156) = fiat_p384_scalar_mulx_u32(x1, (arg2[1]));
    let (x157, x158) = fiat_p384_scalar_mulx_u32(x1, (arg2[0]));
    let (x159, x160) = fiat_p384_scalar_addcarryx_u32(0x0, x158, x155);
    let (x161, x162) = fiat_p384_scalar_addcarryx_u32(x160, x156, x153);
    let (x163, x164) = fiat_p384_scalar_addcarryx_u32(x162, x154, x151);
    let (x165, x166) = fiat_p384_scalar_addcarryx_u32(x164, x152, x149);
    let (x167, x168) = fiat_p384_scalar_addcarryx_u32(x166, x150, x147);
    let (x169, x170) = fiat_p384_scalar_addcarryx_u32(x168, x148, x145);
    let (x171, x172) = fiat_p384_scalar_addcarryx_u32(x170, x146, x143);
    let (x173, x174) = fiat_p384_scalar_addcarryx_u32(x172, x144, x141);
    let (x175, x176) = fiat_p384_scalar_addcarryx_u32(x174, x142, x139);
    let (x177, x178) = fiat_p384_scalar_addcarryx_u32(x176, x140, x137);
    let (x179, x180) = fiat_p384_scalar_addcarryx_u32(x178, x138, x135);
    let x181: u32 = ((x180 as u32) + x136);
    let (x182, x183) = fiat_p384_scalar_addcarryx_u32(0x0, x111, x157);
    let (x184, x185) = fiat_p384_scalar_addcarryx_u32(x183, x113, x159);
    let (x186, x187) = fiat_p384_scalar_addcarryx_u32(x185, x115, x161);
    let (x188, x189) = fiat_p384_scalar_addcarryx_u32(x187, x117, x163);
    let (x190, x191) = fiat_p384_scalar_addcarryx_u32(x189, x119, x165);
    let (x192, x193) = fiat_p384_scalar_addcarryx_u32(x191, x121, x167);
    let (x194, x195) = fiat_p384_scalar_addcarryx_u32(x193, x123, x169);
    let (x196, x197) = fiat_p384_scalar_addcarryx_u32(x195, x125, x171);
    let (x198, x199) = fiat_p384_scalar_addcarryx_u32(x197, x127, x173);
    let (x200, x201) = fiat_p384_scalar_addcarryx_u32(x199, x129, x175);
    let (x202, x203) = fiat_p384_scalar_addcarryx_u32(x201, x131, x177);
    let (x204, x205) = fiat_p384_scalar_addcarryx_u32(x203, x133, x179);
    let (x206, x207) = fiat_p384_scalar_addcarryx_u32(x205, (x134 as u32), x181);
    let (x208, x209) = fiat_p384_scalar_mulx_u32(x182, 0xe88fdc45);
    let (x210, x211) = fiat_p384_scalar_mulx_u32(x208, 0xffffffff);
    let (x212, x213) = fiat_p384_scalar_mulx_u32(x208, 0xffffffff);
    let (x214, x215) = fiat_p384_scalar_mulx_u32(x208, 0xffffffff);
    let (x216, x217) = fiat_p384_scalar_mulx_u32(x208, 0xffffffff);
    let (x218, x219) = fiat_p384_scalar_mulx_u32(x208, 0xffffffff);
    let (x220, x221) = fiat_p384_scalar_mulx_u32(x208, 0xffffffff);
    let (x222, x223) = fiat_p384_scalar_mulx_u32(x208, 0xc7634d81);
    let (x224, x225) = fiat_p384_scalar_mulx_u32(x208, 0xf4372ddf);
    let (x226, x227) = fiat_p384_scalar_mulx_u32(x208, 0x581a0db2);
    let (x228, x229) = fiat_p384_scalar_mulx_u32(x208, 0x48b0a77a);
    let (x230, x231) = fiat_p384_scalar_mulx_u32(x208, 0xecec196a);
    let (x232, x233) = fiat_p384_scalar_mulx_u32(x208, 0xccc52973);
    let (x234, x235) = fiat_p384_scalar_addcarryx_u32(0x0, x233, x230);
    let (x236, x237) = fiat_p384_scalar_addcarryx_u32(x235, x231, x228);
    let (x238, x239) = fiat_p384_scalar_addcarryx_u32(x237, x229, x226);
    let (x240, x241) = fiat_p384_scalar_addcarryx_u32(x239, x227, x224);
    let (x242, x243) = fiat_p384_scalar_addcarryx_u32(x241, x225, x222);
    let (x244, x245) = fiat_p384_scalar_addcarryx_u32(x243, x223, x220);
    let (x246, x247) = fiat_p384_scalar_addcarryx_u32(x245, x221, x218);
    let (x248, x249) = fiat_p384_scalar_addcarryx_u32(x247, x219, x216);
    let (x250, x251) = fiat_p384_scalar_addcarryx_u32(x249, x217, x214);
    let (x252, x253) = fiat_p384_scalar_addcarryx_u32(x251, x215, x212);
    let (x254, x255) = fiat_p384_scalar_addcarryx_u32(x253, x213, x210);
    let x256: u32 = ((x255 as u32) + x211);
    let (x257, x258) = fiat_p384_scalar_addcarryx_u32(0x0, x182, x232);
    let (x259, x260) = fiat_p384_scalar_addcarryx_u32(x258, x184, x234);
    let (x261, x262) = fiat_p384_scalar_addcarryx_u32(x260, x186, x236);
    let (x263, x264) = fiat_p384_scalar_addcarryx_u32(x262, x188, x238);
    let (x265, x266) = fiat_p384_scalar_addcarryx_u32(x264, x190, x240);
    let (x267, x268) = fiat_p384_scalar_addcarryx_u32(x266, x192, x242);
    let (x269, x270) = fiat_p384_scalar_addcarryx_u32(x268, x194, x244);
    let (x271, x272) = fiat_p384_scalar_addcarryx_u32(x270, x196, x246);
    let (x273, x274) = fiat_p384_scalar_addcarryx_u32(x272, x198, x248);
    let (x275, x276) = fiat_p384_scalar_addcarryx_u32(x274, x200, x250);
    let (x277, x278) = fiat_p384_scalar_addcarryx_u32(x276, x202, x252);
    let (x279, x280) = fiat_p384_scalar_addcarryx_u32(x278, x204, x254);
    let (x281, x282) = fiat_p384_scalar_addcarryx_u32(x280, x206, x256);
    let x283: u32 = ((x282 as u32) + (x207 as u32));
    let (x284, x285) = fiat_p384_scalar_mulx_u32(x2, (arg2[11]));
    let (x286, x287) = fiat_p384_scalar_mulx_u32(x2, (arg2[10]));
    let (x288, x289) = fiat_p384_scalar_mulx_u32(x2, (arg2[9]));
    let (x290, x291) = fiat_p384_scalar_mulx_u32(x2, (arg2[8]));
    let (x292, x293) = fiat_p384_scalar_mulx_u32(x2, (arg2[7]));
    let (x294, x295) = fiat_p384_scalar_mulx_u32(x2, (arg2[6]));
    let (x296, x297) = fiat_p384_scalar_mulx_u32(x2, (arg2[5]));
    let (x298, x299) = fiat_p384_scalar_mulx_u32(x2, (arg2[4]));
    let (x300, x301) = fiat_p384_scalar_mulx_u32(x2, (arg2[3]));
    let (x302, x303) = fiat_p384_scalar_mulx_u32(x2, (arg2[2]));
    let (x304, x305) = fiat_p384_scalar_mulx_u32(x2, (arg2[1]));
    let (x306, x307) = fiat_p384_scalar_mulx_u32(x2, (arg2[0]));
    let (x308, x309) = fiat_p384_scalar_addcarryx_u32(0x0, x307, x304);
    let (x310, x311) = fiat_p384_scalar_addcarryx_u32(x309, x305, x302);
    let (x312, x313) = fiat_p384_scalar_addcarryx_u32(x311, x303, x300);
    let (x314, x315) = fiat_p384_scalar_addcarryx_u32(x313, x301, x298);
    let (x316, x317) = fiat_p384_scalar_addcarryx_u32(x315, x299, x296);
    let (x318, x319) = fiat_p384_scalar_addcarryx_u32(x317, x297, x294);
    let (x320, x321) = fiat_p384_scalar_addcarryx_u32(x319, x295, x292);
    let (x322, x323) = fiat_p384_scalar_addcarryx_u32(x321, x293, x290);
    let (x324, x325) = fiat_p384_scalar_addcarryx_u32(x323, x291, x288);
    let (x326, x327) = fiat_p384_scalar_addcarryx_u32(x325, x289, x286);
    let (x328, x329) = fiat_p384_scalar_addcarryx_u32(x327, x287, x284);
    let x330: u32 = ((x329 as u32) + x285);
    let (x331, x332) = fiat_p384_scalar_addcarryx_u32(0x0, x259, x306);
    let (x333, x334) = fiat_p384_scalar_addcarryx_u32(x332, x261, x308);
    let (x335, x336) = fiat_p384_scalar_addcarryx_u32(x334, x263, x310);
    let (x337, x338) = fiat_p384_scalar_addcarryx_u32(x336, x265, x312);
    let (x339, x340) = fiat_p384_scalar_addcarryx_u32(x338, x267, x314);
    let (x341, x342) = fiat_p384_scalar_addcarryx_u32(x340, x269, x316);
    let (x343, x344) = fiat_p384_scalar_addcarryx_u32(x342, x271, x318);
    let (x345, x346) = fiat_p384_scalar_addcarryx_u32(x344, x273, x320);
    let (x347, x348) = fiat_p384_scalar_addcarryx_u32(x346, x275, x322);
    let (x349, x350) = fiat_p384_scalar_addcarryx_u32(x348, x277, x324);
    let (x351, x352) = fiat_p384_scalar_addcarryx_u32(x350, x279, x326);
    let (x353, x354) = fiat_p384_scalar_addcarryx_u32(x352, x281, x328);
    let (x355, x356) = fiat_p384_scalar_addcarryx_u32(x354, x283, x330);
    let (x357, x358) = fiat_p384_scalar_mulx_u32(x331, 0xe88fdc45);
    let (x359, x360) = fiat_p384_scalar_mulx_u32(x357, 0xffffffff);
    let (x361, x362) = fiat_p384_scalar_mulx_u32(x357, 0xffffffff);
    let (x363, x364) = fiat_p384_scalar_mulx_u32(x357, 0xffffffff);
    let (x365, x366) = fiat_p384_scalar_mulx_u32(x357, 0xffffffff);
    let (x367, x368) = fiat_p384_scalar_mulx_u32(x357, 0xffffffff);
    let (x369, x370) = fiat_p384_scalar_mulx_u32(x357, 0xffffffff);
    let (x371, x372) = fiat_p384_scalar_mulx_u32(x357, 0xc7634d81);
    let (x373, x374) = fiat_p384_scalar_mulx_u32(x357, 0xf4372ddf);
    let (x375, x376) = fiat_p384_scalar_mulx_u32(x357, 0x581a0db2);
    let (x377, x378) = fiat_p384_scalar_mulx_u32(x357, 0x48b0a77a);
    let (x379, x380) = fiat_p384_scalar_mulx_u32(x357, 0xecec196a);
    let (x381, x382) = fiat_p384_scalar_mulx_u32(x357, 0xccc52973);
    let (x383, x384) = fiat_p384_scalar_addcarryx_u32(0x0, x382, x379);
    let (x385, x386) = fiat_p384_scalar_addcarryx_u32(x384, x380, x377);
    let (x387, x388) = fiat_p384_scalar_addcarryx_u32(x386, x378, x375);
    let (x389, x390) = fiat_p384_scalar_addcarryx_u32(x388, x376, x373);
    let (x391, x392) = fiat_p384_scalar_addcarryx_u32(x390, x374, x371);
    let (x393, x394) = fiat_p384_scalar_addcarryx_u32(x392, x372, x369);
    let (x395, x396) = fiat_p384_scalar_addcarryx_u32(x394, x370, x367);
    let (x397, x398) = fiat_p384_scalar_addcarryx_u32(x396, x368, x365);
    let (x399, x400) = fiat_p384_scalar_addcarryx_u32(x398, x366, x363);
    let (x401, x402) = fiat_p384_scalar_addcarryx_u32(x400, x364, x361);
    let (x403, x404) = fiat_p384_scalar_addcarryx_u32(x402, x362, x359);
    let x405: u32 = ((x404 as u32) + x360);
    let (x406, x407) = fiat_p384_scalar_addcarryx_u32(0x0, x331, x381);
    let (x408, x409) = fiat_p384_scalar_addcarryx_u32(x407, x333, x383);
    let (x410, x411) = fiat_p384_scalar_addcarryx_u32(x409, x335, x385);
    let (x412, x413) = fiat_p384_scalar_addcarryx_u32(x411, x337, x387);
    let (x414, x415) = fiat_p384_scalar_addcarryx_u32(x413, x339, x389);
    let (x416, x417) = fiat_p384_scalar_addcarryx_u32(x415, x341, x391);
    let (x418, x419) = fiat_p384_scalar_addcarryx_u32(x417, x343, x393);
    let (x420, x421) = fiat_p384_scalar_addcarryx_u32(x419, x345, x395);
    let (x422, x423) = fiat_p384_scalar_addcarryx_u32(x421, x347, x397);
    let (x424, x425) = fiat_p384_scalar_addcarryx_u32(x423, x349, x399);
    let (x426, x427) = fiat_p384_scalar_addcarryx_u32(x425, x351, x401);
    let (x428, x429) = fiat_p384_scalar_addcarryx_u32(x427, x353, x403);
    let (x430, x431) = fiat_p384_scalar_addcarryx_u32(x429, x355, x405);
    let x432: u32 = ((x431 as u32) + (x356 as u32));
    let (x433, x434) = fiat_p384_scalar_mulx_u32(x3, (arg2[11]));
    let (x435, x436) = fiat_p384_scalar_mulx_u32(x3, (arg2[10]));
    let (x437, x438) = fiat_p384_scalar_mulx_u32(x3, (arg2[9]));
    let (x439, x440) = fiat_p384_scalar_mulx_u32(x3, (arg2[8]));
    let (x441, x442) = fiat_p384_scalar_mulx_u32(x3, (arg2[7]));
    let (x443, x444) = fiat_p384_scalar_mulx_u32(x3, (arg2[6]));
    let (x445, x446) = fiat_p384_scalar_mulx_u32(x3, (arg2[5]));
    let (x447, x448) = fiat_p384_scalar_mulx_u32(x3, (arg2[4]));
    let (x449, x450) = fiat_p384_scalar_mulx_u32(x3, (arg2[3]));
    let (x451, x452) = fiat_p384_scalar_mulx_u32(x3, (arg2[2]));
    let (x453, x454) = fiat_p384_scalar_mulx_u32(x3, (arg2[1]));
    let (x455, x456) = fiat_p384_scalar_mulx_u32(x3, (arg2[0]));
    let (x457, x458) = fiat_p384_scalar_addcarryx_u32(0x0, x456, x453);
    let (x459, x460) = fiat_p384_scalar_addcarryx_u32(x458, x454, x451);
    let (x461, x462) = fiat_p384_scalar_addcarryx_u32(x460, x452, x449);
    let (x463, x464) = fiat_p384_scalar_addcarryx_u32(x462, x450, x447);
    let (x465, x466) = fiat_p384_scalar_addcarryx_u32(x464, x448, x445);
    let (x467, x468) = fiat_p384_scalar_addcarryx_u32(x466, x446, x443);
    let (x469, x470) = fiat_p384_scalar_addcarryx_u32(x468, x444, x441);
    let (x471, x472) = fiat_p384_scalar_addcarryx_u32(x470, x442, x439);
    let (x473, x474) = fiat_p384_scalar_addcarryx_u32(x472, x440, x437);
    let (x475, x476) = fiat_p384_scalar_addcarryx_u32(x474, x438, x435);
    let (x477, x478) = fiat_p384_scalar_addcarryx_u32(x476, x436, x433);
    let x479: u32 = ((x478 as u32) + x434);
    let (x480, x481) = fiat_p384_scalar_addcarryx_u32(0x0, x408, x455);
    let (x482, x483) = fiat_p384_scalar_addcarryx_u32(x481, x410, x457);
    let (x484, x485) = fiat_p384_scalar_addcarryx_u32(x483, x412, x459);
    let (x486, x487) = fiat_p384_scalar_addcarryx_u32(x485, x414, x461);
    let (x488, x489) = fiat_p384_scalar_addcarryx_u32(x487, x416, x463);
    let (x490, x491) = fiat_p384_scalar_addcarryx_u32(x489, x418, x465);
    let (x492, x493) = fiat_p384_scalar_addcarryx_u32(x491, x420, x467);
    let (x494, x495) = fiat_p384_scalar_addcarryx_u32(x493, x422, x469);
    let (x496, x497) = fiat_p384_scalar_addcarryx_u32(x495, x424, x471);
    let (x498, x499) = fiat_p384_scalar_addcarryx_u32(x497, x426, x473);
    let (x500, x501) = fiat_p384_scalar_addcarryx_u32(x499, x428, x475);
    let (x502, x503) = fiat_p384_scalar_addcarryx_u32(x501, x430, x477);
    let (x504, x505) = fiat_p384_scalar_addcarryx_u32(x503, x432, x479);
    let (x506, x507) = fiat_p384_scalar_mulx_u32(x480, 0xe88fdc45);
    let (x508, x509) = fiat_p384_scalar_mulx_u32(x506, 0xffffffff);
    let (x510, x511) = fiat_p384_scalar_mulx_u32(x506, 0xffffffff);
    let (x512, x513) = fiat_p384_scalar_mulx_u32(x506, 0xffffffff);
    let (x514, x515) = fiat_p384_scalar_mulx_u32(x506, 0xffffffff);
    let (x516, x517) = fiat_p384_scalar_mulx_u32(x506, 0xffffffff);
    let (x518, x519) = fiat_p384_scalar_mulx_u32(x506, 0xffffffff);
    let (x520, x521) = fiat_p384_scalar_mulx_u32(x506, 0xc7634d81);
    let (x522, x523) = fiat_p384_scalar_mulx_u32(x506, 0xf4372ddf);
    let (x524, x525) = fiat_p384_scalar_mulx_u32(x506, 0x581a0db2);
    let (x526, x527) = fiat_p384_scalar_mulx_u32(x506, 0x48b0a77a);
    let (x528, x529) = fiat_p384_scalar_mulx_u32(x506, 0xecec196a);
    let (x530, x531) = fiat_p384_scalar_mulx_u32(x506, 0xccc52973);
    let (x532, x533) = fiat_p384_scalar_addcarryx_u32(0x0, x531, x528);
    let (x534, x535) = fiat_p384_scalar_addcarryx_u32(x533, x529, x526);
    let (x536, x537) = fiat_p384_scalar_addcarryx_u32(x535, x527, x524);
    let (x538, x539) = fiat_p384_scalar_addcarryx_u32(x537, x525, x522);
    let (x540, x541) = fiat_p384_scalar_addcarryx_u32(x539, x523, x520);
    let (x542, x543) = fiat_p384_scalar_addcarryx_u32(x541, x521, x518);
    let (x544, x545) = fiat_p384_scalar_addcarryx_u32(x543, x519, x516);
    let (x546, x547) = fiat_p384_scalar_addcarryx_u32(x545, x517, x514);
    let (x548, x549) = fiat_p384_scalar_addcarryx_u32(x547, x515, x512);
    let (x550, x551) = fiat_p384_scalar_addcarryx_u32(x549, x513, x510);
    let (x552, x553) = fiat_p384_scalar_addcarryx_u32(x551, x511, x508);
    let x554: u32 = ((x553 as u32) + x509);
    let (x555, x556) = fiat_p384_scalar_addcarryx_u32(0x0, x480, x530);
    let (x557, x558) = fiat_p384_scalar_addcarryx_u32(x556, x482, x532);
    let (x559, x560) = fiat_p384_scalar_addcarryx_u32(x558, x484, x534);
    let (x561, x562) = fiat_p384_scalar_addcarryx_u32(x560, x486, x536);
    let (x563, x564) = fiat_p384_scalar_addcarryx_u32(x562, x488, x538);
    let (x565, x566) = fiat_p384_scalar_addcarryx_u32(x564, x490, x540);
    let (x567, x568) = fiat_p384_scalar_addcarryx_u32(x566, x492, x542);
    let (x569, x570) = fiat_p384_scalar_addcarryx_u32(x568, x494, x544);
    let (x571, x572) = fiat_p384_scalar_addcarryx_u32(x570, x496, x546);
    let (x573, x574) = fiat_p384_scalar_addcarryx_u32(x572, x498, x548);
    let (x575, x576) = fiat_p384_scalar_addcarryx_u32(x574, x500, x550);
    let (x577, x578) = fiat_p384_scalar_addcarryx_u32(x576, x502, x552);
    let (x579, x580) = fiat_p384_scalar_addcarryx_u32(x578, x504, x554);
    let x581: u32 = ((x580 as u32) + (x505 as u32));
    let (x582, x583) = fiat_p384_scalar_mulx_u32(x4, (arg2[11]));
    let (x584, x585) = fiat_p384_scalar_mulx_u32(x4, (arg2[10]));
    let (x586, x587) = fiat_p384_scalar_mulx_u32(x4, (arg2[9]));
    let (x588, x589) = fiat_p384_scalar_mulx_u32(x4, (arg2[8]));
    let (x590, x591) = fiat_p384_scalar_mulx_u32(x4, (arg2[7]));
    let (x592, x593) = fiat_p384_scalar_mulx_u32(x4, (arg2[6]));
    let (x594, x595) = fiat_p384_scalar_mulx_u32(x4, (arg2[5]));
    let (x596, x597) = fiat_p384_scalar_mulx_u32(x4, (arg2[4]));
    let (x598, x599) = fiat_p384_scalar_mulx_u32(x4, (arg2[3]));
    let (x600, x601) = fiat_p384_scalar_mulx_u32(x4, (arg2[2]));
    let (x602, x603) = fiat_p384_scalar_mulx_u32(x4, (arg2[1]));
    let (x604, x605) = fiat_p384_scalar_mulx_u32(x4, (arg2[0]));
    let (x606, x607) = fiat_p384_scalar_addcarryx_u32(0x0, x605, x602);
    let (x608, x609) = fiat_p384_scalar_addcarryx_u32(x607, x603, x600);
    let (x610, x611) = fiat_p384_scalar_addcarryx_u32(x609, x601, x598);
    let (x612, x613) = fiat_p384_scalar_addcarryx_u32(x611, x599, x596);
    let (x614, x615) = fiat_p384_scalar_addcarryx_u32(x613, x597, x594);
    let (x616, x617) = fiat_p384_scalar_addcarryx_u32(x615, x595, x592);
    let (x618, x619) = fiat_p384_scalar_addcarryx_u32(x617, x593, x590);
    let (x620, x621) = fiat_p384_scalar_addcarryx_u32(x619, x591, x588);
    let (x622, x623) = fiat_p384_scalar_addcarryx_u32(x621, x589, x586);
    let (x624, x625) = fiat_p384_scalar_addcarryx_u32(x623, x587, x584);
    let (x626, x627) = fiat_p384_scalar_addcarryx_u32(x625, x585, x582);
    let x628: u32 = ((x627 as u32) + x583);
    let (x629, x630) = fiat_p384_scalar_addcarryx_u32(0x0, x557, x604);
    let (x631, x632) = fiat_p384_scalar_addcarryx_u32(x630, x559, x606);
    let (x633, x634) = fiat_p384_scalar_addcarryx_u32(x632, x561, x608);
    let (x635, x636) = fiat_p384_scalar_addcarryx_u32(x634, x563, x610);
    let (x637, x638) = fiat_p384_scalar_addcarryx_u32(x636, x565, x612);
    let (x639, x640) = fiat_p384_scalar_addcarryx_u32(x638, x567, x614);
    let (x641, x642) = fiat_p384_scalar_addcarryx_u32(x640, x569, x616);
    let (x643, x644) = fiat_p384_scalar_addcarryx_u32(x642, x571, x618);
    let (x645, x646) = fiat_p384_scalar_addcarryx_u32(x644, x573, x620);
    let (x647, x648) = fiat_p384_scalar_addcarryx_u32(x646, x575, x622);
    let (x649, x650) = fiat_p384_scalar_addcarryx_u32(x648, x577, x624);
    let (x651, x652) = fiat_p384_scalar_addcarryx_u32(x650, x579, x626);
    let (x653, x654) = fiat_p384_scalar_addcarryx_u32(x652, x581, x628);
    let (x655, x656) = fiat_p384_scalar_mulx_u32(x629, 0xe88fdc45);
    let (x657, x658) = fiat_p384_scalar_mulx_u32(x655, 0xffffffff);
    let (x659, x660) = fiat_p384_scalar_mulx_u32(x655, 0xffffffff);
    let (x661, x662) = fiat_p384_scalar_mulx_u32(x655, 0xffffffff);
    let (x663, x664) = fiat_p384_scalar_mulx_u32(x655, 0xffffffff);
    let (x665, x666) = fiat_p384_scalar_mulx_u32(x655, 0xffffffff);
    let (x667, x668) = fiat_p384_scalar_mulx_u32(x655, 0xffffffff);
    let (x669, x670) = fiat_p384_scalar_mulx_u32(x655, 0xc7634d81);
    let (x671, x672) = fiat_p384_scalar_mulx_u32(x655, 0xf4372ddf);
    let (x673, x674) = fiat_p384_scalar_mulx_u32(x655, 0x581a0db2);
    let (x675, x676) = fiat_p384_scalar_mulx_u32(x655, 0x48b0a77a);
    let (x677, x678) = fiat_p384_scalar_mulx_u32(x655, 0xecec196a);
    let (x679, x680) = fiat_p384_scalar_mulx_u32(x655, 0xccc52973);
    let (x681, x682) = fiat_p384_scalar_addcarryx_u32(0x0, x680, x677);
    let (x683, x684) = fiat_p384_scalar_addcarryx_u32(x682, x678, x675);
    let (x685, x686) = fiat_p384_scalar_addcarryx_u32(x684, x676, x673);
    let (x687, x688) = fiat_p384_scalar_addcarryx_u32(x686, x674, x671);
    let (x689, x690) = fiat_p384_scalar_addcarryx_u32(x688, x672, x669);
    let (x691, x692) = fiat_p384_scalar_addcarryx_u32(x690, x670, x667);
    let (x693, x694) = fiat_p384_scalar_addcarryx_u32(x692, x668, x665);
    let (x695, x696) = fiat_p384_scalar_addcarryx_u32(x694, x666, x663);
    let (x697, x698) = fiat_p384_scalar_addcarryx_u32(x696, x664, x661);
    let (x699, x700) = fiat_p384_scalar_addcarryx_u32(x698, x662, x659);
    let (x701, x702) = fiat_p384_scalar_addcarryx_u32(x700, x660, x657);
    let x703: u32 = ((x702 as u32) + x658);
    let (x704, x705) = fiat_p384_scalar_addcarryx_u32(0x0, x629, x679);
    let (x706, x707) = fiat_p384_scalar_addcarryx_u32(x705, x631, x681);
    let (x708, x709) = fiat_p384_scalar_addcarryx_u32(x707, x633, x683);
    let (x710, x711) = fiat_p384_scalar_addcarryx_u32(x709, x635, x685);
    let (x712, x713) = fiat_p384_scalar_addcarryx_u32(x711, x637, x687);
    let (x714, x715) = fiat_p384_scalar_addcarryx_u32(x713, x639, x689);
    let (x716, x717) = fiat_p384_scalar_addcarryx_u32(x715, x641, x691);
    let (x718, x719) = fiat_p384_scalar_addcarryx_u32(x717, x643, x693);
    let (x720, x721) = fiat_p384_scalar_addcarryx_u32(x719, x645, x695);
    let (x722, x723) = fiat_p384_scalar_addcarryx_u32(x721, x647, x697);
    let (x724, x725) = fiat_p384_scalar_addcarryx_u32(x723, x649, x699);
    let (x726, x727) = fiat_p384_scalar_addcarryx_u32(x725, x651, x701);
    let (x728, x729) = fiat_p384_scalar_addcarryx_u32(x727, x653, x703);
    let x730: u32 = ((x729 as u32) + (x654 as u32));
    let (x731, x732) = fiat_p384_scalar_mulx_u32(x5, (arg2[11]));
    let (x733, x734) = fiat_p384_scalar_mulx_u32(x5, (arg2[10]));
    let (x735, x736) = fiat_p384_scalar_mulx_u32(x5, (arg2[9]));
    let (x737, x738) = fiat_p384_scalar_mulx_u32(x5, (arg2[8]));
    let (x739, x740) = fiat_p384_scalar_mulx_u32(x5, (arg2[7]));
    let (x741, x742) = fiat_p384_scalar_mulx_u32(x5, (arg2[6]));
    let (x743, x744) = fiat_p384_scalar_mulx_u32(x5, (arg2[5]));
    let (x745, x746) = fiat_p384_scalar_mulx_u32(x5, (arg2[4]));
    let (x747, x748) = fiat_p384_scalar_mulx_u32(x5, (arg2[3]));
    let (x749, x750) = fiat_p384_scalar_mulx_u32(x5, (arg2[2]));
    let (x751, x752) = fiat_p384_scalar_mulx_u32(x5, (arg2[1]));
    let (x753, x754) = fiat_p384_scalar_mulx_u32(x5, (arg2[0]));
    let (x755, x756) = fiat_p384_scalar_addcarryx_u32(0x0, x754, x751);
    let (x757, x758) = fiat_p384_scalar_addcarryx_u32(x756, x752, x749);
    let (x759, x760) = fiat_p384_scalar_addcarryx_u32(x758, x750, x747);
    let (x761, x762) = fiat_p384_scalar_addcarryx_u32(x760, x748, x745);
    let (x763, x764) = fiat_p384_scalar_addcarryx_u32(x762, x746, x743);
    let (x765, x766) = fiat_p384_scalar_addcarryx_u32(x764, x744, x741);
    let (x767, x768) = fiat_p384_scalar_addcarryx_u32(x766, x742, x739);
    let (x769, x770) = fiat_p384_scalar_addcarryx_u32(x768, x740, x737);
    let (x771, x772) = fiat_p384_scalar_addcarryx_u32(x770, x738, x735);
    let (x773, x774) = fiat_p384_scalar_addcarryx_u32(x772, x736, x733);
    let (x775, x776) = fiat_p384_scalar_addcarryx_u32(x774, x734, x731);
    let x777: u32 = ((x776 as u32) + x732);
    let (x778, x779) = fiat_p384_scalar_addcarryx_u32(0x0, x706, x753);
    let (x780, x781) = fiat_p384_scalar_addcarryx_u32(x779, x708, x755);
    let (x782, x783) = fiat_p384_scalar_addcarryx_u32(x781, x710, x757);
    let (x784, x785) = fiat_p384_scalar_addcarryx_u32(x783, x712, x759);
    let (x786, x787) = fiat_p384_scalar_addcarryx_u32(x785, x714, x761);
    let (x788, x789) = fiat_p384_scalar_addcarryx_u32(x787, x716, x763);
    let (x790, x791) = fiat_p384_scalar_addcarryx_u32(x789, x718, x765);
    let (x792, x793) = fiat_p384_scalar_addcarryx_u32(x791, x720, x767);
    let (x794, x795) = fiat_p384_scalar_addcarryx_u32(x793, x722, x769);
    let (x796, x797) = fiat_p384_scalar_addcarryx_u32(x795, x724, x771);
    let (x798, x799) = fiat_p384_scalar_addcarryx_u32(x797, x726, x773);
    let (x800, x801) = fiat_p384_scalar_addcarryx_u32(x799, x728, x775);
    let (x802, x803) = fiat_p384_scalar_addcarryx_u32(x801, x730, x777);
    let (x804, x805) = fiat_p384_scalar_mulx_u32(x778, 0xe88fdc45);
    let (x806, x807) = fiat_p384_scalar_mulx_u32(x804, 0xffffffff);
    let (x808, x809) = fiat_p384_scalar_mulx_u32(x804, 0xffffffff);
    let (x810, x811) = fiat_p384_scalar_mulx_u32(x804, 0xffffffff);
    let (x812, x813) = fiat_p384_scalar_mulx_u32(x804, 0xffffffff);
    let (x814, x815) = fiat_p384_scalar_mulx_u32(x804, 0xffffffff);
    let (x816, x817) = fiat_p384_scalar_mulx_u32(x804, 0xffffffff);
    let (x818, x819) = fiat_p384_scalar_mulx_u32(x804, 0xc7634d81);
    let (x820, x821) = fiat_p384_scalar_mulx_u32(x804, 0xf4372ddf);
    let (x822, x823) = fiat_p384_scalar_mulx_u32(x804, 0x581a0db2);
    let (x824, x825) = fiat_p384_scalar_mulx_u32(x804, 0x48b0a77a);
    let (x826, x827) = fiat_p384_scalar_mulx_u32(x804, 0xecec196a);
    let (x828, x829) = fiat_p384_scalar_mulx_u32(x804, 0xccc52973);
    let (x830, x831) = fiat_p384_scalar_addcarryx_u32(0x0, x829, x826);
    let (x832, x833) = fiat_p384_scalar_addcarryx_u32(x831, x827, x824);
    let (x834, x835) = fiat_p384_scalar_addcarryx_u32(x833, x825, x822);
    let (x836, x837) = fiat_p384_scalar_addcarryx_u32(x835, x823, x820);
    let (x838, x839) = fiat_p384_scalar_addcarryx_u32(x837, x821, x818);
    let (x840, x841) = fiat_p384_scalar_addcarryx_u32(x839, x819, x816);
    let (x842, x843) = fiat_p384_scalar_addcarryx_u32(x841, x817, x814);
    let (x844, x845) = fiat_p384_scalar_addcarryx_u32(x843, x815, x812);
    let (x846, x847) = fiat_p384_scalar_addcarryx_u32(x845, x813, x810);
    let (x848, x849) = fiat_p384_scalar_addcarryx_u32(x847, x811, x808);
    let (x850, x851) = fiat_p384_scalar_addcarryx_u32(x849, x809, x806);
    let x852: u32 = ((x851 as u32) + x807);
    let (x853, x854) = fiat_p384_scalar_addcarryx_u32(0x0, x778, x828);
    let (x855, x856) = fiat_p384_scalar_addcarryx_u32(x854, x780, x830);
    let (x857, x858) = fiat_p384_scalar_addcarryx_u32(x856, x782, x832);
    let (x859, x860) = fiat_p384_scalar_addcarryx_u32(x858, x784, x834);
    let (x861, x862) = fiat_p384_scalar_addcarryx_u32(x860, x786, x836);
    let (x863, x864) = fiat_p384_scalar_addcarryx_u32(x862, x788, x838);
    let (x865, x866) = fiat_p384_scalar_addcarryx_u32(x864, x790, x840);
    let (x867, x868) = fiat_p384_scalar_addcarryx_u32(x866, x792, x842);
    let (x869, x870) = fiat_p384_scalar_addcarryx_u32(x868, x794, x844);
    let (x871, x872) = fiat_p384_scalar_addcarryx_u32(x870, x796, x846);
    let (x873, x874) = fiat_p384_scalar_addcarryx_u32(x872, x798, x848);
    let (x875, x876) = fiat_p384_scalar_addcarryx_u32(x874, x800, x850);
    let (x877, x878) = fiat_p384_scalar_addcarryx_u32(x876, x802, x852);
    let x879: u32 = ((x878 as u32) + (x803 as u32));
    let (x880, x881) = fiat_p384_scalar_mulx_u32(x6, (arg2[11]));
    let (x882, x883) = fiat_p384_scalar_mulx_u32(x6, (arg2[10]));
    let (x884, x885) = fiat_p384_scalar_mulx_u32(x6, (arg2[9]));
    let (x886, x887) = fiat_p384_scalar_mulx_u32(x6, (arg2[8]));
    let (x888, x889) = fiat_p384_scalar_mulx_u32(x6, (arg2[7]));
    let (x890, x891) = fiat_p384_scalar_mulx_u32(x6, (arg2[6]));
    let (x892, x893) = fiat_p384_scalar_mulx_u32(x6, (arg2[5]));
    let (x894, x895) = fiat_p384_scalar_mulx_u32(x6, (arg2[4]));
    let (x896, x897) = fiat_p384_scalar_mulx_u32(x6, (arg2[3]));
    let (x898, x899) = fiat_p384_scalar_mulx_u32(x6, (arg2[2]));
    let (x900, x901) = fiat_p384_scalar_mulx_u32(x6, (arg2[1]));
    let (x902, x903) = fiat_p384_scalar_mulx_u32(x6, (arg2[0]));
    let (x904, x905) = fiat_p384_scalar_addcarryx_u32(0x0, x903, x900);
    let (x906, x907) = fiat_p384_scalar_addcarryx_u32(x905, x901, x898);
    let (x908, x909) = fiat_p384_scalar_addcarryx_u32(x907, x899, x896);
    let (x910, x911) = fiat_p384_scalar_addcarryx_u32(x909, x897, x894);
    let (x912, x913) = fiat_p384_scalar_addcarryx_u32(x911, x895, x892);
    let (x914, x915) = fiat_p384_scalar_addcarryx_u32(x913, x893, x890);
    let (x916, x917) = fiat_p384_scalar_addcarryx_u32(x915, x891, x888);
    let (x918, x919) = fiat_p384_scalar_addcarryx_u32(x917, x889, x886);
    let (x920, x921) = fiat_p384_scalar_addcarryx_u32(x919, x887, x884);
    let (x922, x923) = fiat_p384_scalar_addcarryx_u32(x921, x885, x882);
    let (x924, x925) = fiat_p384_scalar_addcarryx_u32(x923, x883, x880);
    let x926: u32 = ((x925 as u32) + x881);
    let (x927, x928) = fiat_p384_scalar_addcarryx_u32(0x0, x855, x902);
    let (x929, x930) = fiat_p384_scalar_addcarryx_u32(x928, x857, x904);
    let (x931, x932) = fiat_p384_scalar_addcarryx_u32(x930, x859, x906);
    let (x933, x934) = fiat_p384_scalar_addcarryx_u32(x932, x861, x908);
    let (x935, x936) = fiat_p384_scalar_addcarryx_u32(x934, x863, x910);
    let (x937, x938) = fiat_p384_scalar_addcarryx_u32(x936, x865, x912);
    let (x939, x940) = fiat_p384_scalar_addcarryx_u32(x938, x867, x914);
    let (x941, x942) = fiat_p384_scalar_addcarryx_u32(x940, x869, x916);
    let (x943, x944) = fiat_p384_scalar_addcarryx_u32(x942, x871, x918);
    let (x945, x946) = fiat_p384_scalar_addcarryx_u32(x944, x873, x920);
    let (x947, x948) = fiat_p384_scalar_addcarryx_u32(x946, x875, x922);
    let (x949, x950) = fiat_p384_scalar_addcarryx_u32(x948, x877, x924);
    let (x951, x952) = fiat_p384_scalar_addcarryx_u32(x950, x879, x926);
    let (x953, x954) = fiat_p384_scalar_mulx_u32(x927, 0xe88fdc45);
    let (x955, x956) = fiat_p384_scalar_mulx_u32(x953, 0xffffffff);
    let (x957, x958) = fiat_p384_scalar_mulx_u32(x953, 0xffffffff);
    let (x959, x960) = fiat_p384_scalar_mulx_u32(x953, 0xffffffff);
    let (x961, x962) = fiat_p384_scalar_mulx_u32(x953, 0xffffffff);
    let (x963, x964) = fiat_p384_scalar_mulx_u32(x953, 0xffffffff);
    let (x965, x966) = fiat_p384_scalar_mulx_u32(x953, 0xffffffff);
    let (x967, x968) = fiat_p384_scalar_mulx_u32(x953, 0xc7634d81);
    let (x969, x970) = fiat_p384_scalar_mulx_u32(x953, 0xf4372ddf);
    let (x971, x972) = fiat_p384_scalar_mulx_u32(x953, 0x581a0db2);
    let (x973, x974) = fiat_p384_scalar_mulx_u32(x953, 0x48b0a77a);
    let (x975, x976) = fiat_p384_scalar_mulx_u32(x953, 0xecec196a);
    let (x977, x978) = fiat_p384_scalar_mulx_u32(x953, 0xccc52973);
    let (x979, x980) = fiat_p384_scalar_addcarryx_u32(0x0, x978, x975);
    let (x981, x982) = fiat_p384_scalar_addcarryx_u32(x980, x976, x973);
    let (x983, x984) = fiat_p384_scalar_addcarryx_u32(x982, x974, x971);
    let (x985, x986) = fiat_p384_scalar_addcarryx_u32(x984, x972, x969);
    let (x987, x988) = fiat_p384_scalar_addcarryx_u32(x986, x970, x967);
    let (x989, x990) = fiat_p384_scalar_addcarryx_u32(x988, x968, x965);
    let (x991, x992) = fiat_p384_scalar_addcarryx_u32(x990, x966, x963);
    let (x993, x994) = fiat_p384_scalar_addcarryx_u32(x992, x964, x961);
    let (x995, x996) = fiat_p384_scalar_addcarryx_u32(x994, x962, x959);
    let (x997, x998) = fiat_p384_scalar_addcarryx_u32(x996, x960, x957);
    let (x999, x1000) = fiat_p384_scalar_addcarryx_u32(x998, x958, x955);
    let x1001: u32 = ((x1000 as u32) + x956);
    let (x1002, x1003) = fiat_p384_scalar_addcarryx_u32(0x0, x927, x977);
    let (x1004, x1005) = fiat_p384_scalar_addcarryx_u32(x1003, x929, x979);
    let (x1006, x1007) = fiat_p384_scalar_addcarryx_u32(x1005, x931, x981);
    let (x1008, x1009) = fiat_p384_scalar_addcarryx_u32(x1007, x933, x983);
    let (x1010, x1011) = fiat_p384_scalar_addcarryx_u32(x1009, x935, x985);
    let (x1012, x1013) = fiat_p384_scalar_addcarryx_u32(x1011, x937, x987);
    let (x1014, x1015) = fiat_p384_scalar_addcarryx_u32(x1013, x939, x989);
    let (x1016, x1017) = fiat_p384_scalar_addcarryx_u32(x1015, x941, x991);
    let (x1018, x1019) = fiat_p384_scalar_addcarryx_u32(x1017, x943, x993);
    let (x1020, x1021) = fiat_p384_scalar_addcarryx_u32(x1019, x945, x995);
    let (x1022, x1023) = fiat_p384_scalar_addcarryx_u32(x1021, x947, x997);
    let (x1024, x1025) = fiat_p384_scalar_addcarryx_u32(x1023, x949, x999);
    let (x1026, x1027) = fiat_p384_scalar_addcarryx_u32(x1025, x951, x1001);
    let x1028: u32 = ((x1027 as u32) + (x952 as u32));
    let (x1029, x1030) = fiat_p384_scalar_mulx_u32(x7, (arg2[11]));
    let (x1031, x1032) = fiat_p384_scalar_mulx_u32(x7, (arg2[10]));
    let (x1033, x1034) = fiat_p384_scalar_mulx_u32(x7, (arg2[9]));
    let (x1035, x1036) = fiat_p384_scalar_mulx_u32(x7, (arg2[8]));
    let (x1037, x1038) = fiat_p384_scalar_mulx_u32(x7, (arg2[7]));
    let (x1039, x1040) = fiat_p384_scalar_mulx_u32(x7, (arg2[6]));
    let (x1041, x1042) = fiat_p384_scalar_mulx_u32(x7, (arg2[5]));
    let (x1043, x1044) = fiat_p384_scalar_mulx_u32(x7, (arg2[4]));
    let (x1045, x1046) = fiat_p384_scalar_mulx_u32(x7, (arg2[3]));
    let (x1047, x1048) = fiat_p384_scalar_mulx_u32(x7, (arg2[2]));
    let (x1049, x1050) = fiat_p384_scalar_mulx_u32(x7, (arg2[1]));
    let (x1051, x1052) = fiat_p384_scalar_mulx_u32(x7, (arg2[0]));
    let (x1053, x1054) = fiat_p384_scalar_addcarryx_u32(0x0, x1052, x1049);
    let (x1055, x1056) = fiat_p384_scalar_addcarryx_u32(x1054, x1050, x1047);
    let (x1057, x1058) = fiat_p384_scalar_addcarryx_u32(x1056, x1048, x1045);
    let (x1059, x1060) = fiat_p384_scalar_addcarryx_u32(x1058, x1046, x1043);
    let (x1061, x1062) = fiat_p384_scalar_addcarryx_u32(x1060, x1044, x1041);
    let (x1063, x1064) = fiat_p384_scalar_addcarryx_u32(x1062, x1042, x1039);
    let (x1065, x1066) = fiat_p384_scalar_addcarryx_u32(x1064, x1040, x1037);
    let (x1067, x1068) = fiat_p384_scalar_addcarryx_u32(x1066, x1038, x1035);
    let (x1069, x1070) = fiat_p384_scalar_addcarryx_u32(x1068, x1036, x1033);
    let (x1071, x1072) = fiat_p384_scalar_addcarryx_u32(x1070, x1034, x1031);
    let (x1073, x1074) = fiat_p384_scalar_addcarryx_u32(x1072, x1032, x1029);
    let x1075: u32 = ((x1074 as u32) + x1030);
    let (x1076, x1077) = fiat_p384_scalar_addcarryx_u32(0x0, x1004, x1051);
    let (x1078, x1079) = fiat_p384_scalar_addcarryx_u32(x1077, x1006, x1053);
    let (x1080, x1081) = fiat_p384_scalar_addcarryx_u32(x1079, x1008, x1055);
    let (x1082, x1083) = fiat_p384_scalar_addcarryx_u32(x1081, x1010, x1057);
    let (x1084, x1085) = fiat_p384_scalar_addcarryx_u32(x1083, x1012, x1059);
    let (x1086, x1087) = fiat_p384_scalar_addcarryx_u32(x1085, x1014, x1061);
    let (x1088, x1089) = fiat_p384_scalar_addcarryx_u32(x1087, x1016, x1063);
    let (x1090, x1091) = fiat_p384_scalar_addcarryx_u32(x1089, x1018, x1065);
    let (x1092, x1093) = fiat_p384_scalar_addcarryx_u32(x1091, x1020, x1067);
    let (x1094, x1095) = fiat_p384_scalar_addcarryx_u32(x1093, x1022, x1069);
    let (x1096, x1097) = fiat_p384_scalar_addcarryx_u32(x1095, x1024, x1071);
    let (x1098, x1099) = fiat_p384_scalar_addcarryx_u32(x1097, x1026, x1073);
    let (x1100, x1101) = fiat_p384_scalar_addcarryx_u32(x1099, x1028, x1075);
    let (x1102, x1103) = fiat_p384_scalar_mulx_u32(x1076, 0xe88fdc45);
    let (x1104, x1105) = fiat_p384_scalar_mulx_u32(x1102, 0xffffffff);
    let (x1106, x1107) = fiat_p384_scalar_mulx_u32(x1102, 0xffffffff);
    let (x1108, x1109) = fiat_p384_scalar_mulx_u32(x1102, 0xffffffff);
    let (x1110, x1111) = fiat_p384_scalar_mulx_u32(x1102, 0xffffffff);
    let (x1112, x1113) = fiat_p384_scalar_mulx_u32(x1102, 0xffffffff);
    let (x1114, x1115) = fiat_p384_scalar_mulx_u32(x1102, 0xffffffff);
    let (x1116, x1117) = fiat_p384_scalar_mulx_u32(x1102, 0xc7634d81);
    let (x1118, x1119) = fiat_p384_scalar_mulx_u32(x1102, 0xf4372ddf);
    let (x1120, x1121) = fiat_p384_scalar_mulx_u32(x1102, 0x581a0db2);
    let (x1122, x1123) = fiat_p384_scalar_mulx_u32(x1102, 0x48b0a77a);
    let (x1124, x1125) = fiat_p384_scalar_mulx_u32(x1102, 0xecec196a);
    let (x1126, x1127) = fiat_p384_scalar_mulx_u32(x1102, 0xccc52973);
    let (x1128, x1129) = fiat_p384_scalar_addcarryx_u32(0x0, x1127, x1124);
    let (x1130, x1131) = fiat_p384_scalar_addcarryx_u32(x1129, x1125, x1122);
    let (x1132, x1133) = fiat_p384_scalar_addcarryx_u32(x1131, x1123, x1120);
    let (x1134, x1135) = fiat_p384_scalar_addcarryx_u32(x1133, x1121, x1118);
    let (x1136, x1137) = fiat_p384_scalar_addcarryx_u32(x1135, x1119, x1116);
    let (x1138, x1139) = fiat_p384_scalar_addcarryx_u32(x1137, x1117, x1114);
    let (x1140, x1141) = fiat_p384_scalar_addcarryx_u32(x1139, x1115, x1112);
    let (x1142, x1143) = fiat_p384_scalar_addcarryx_u32(x1141, x1113, x1110);
    let (x1144, x1145) = fiat_p384_scalar_addcarryx_u32(x1143, x1111, x1108);
    let (x1146, x1147) = fiat_p384_scalar_addcarryx_u32(x1145, x1109, x1106);
    let (x1148, x1149) = fiat_p384_scalar_addcarryx_u32(x1147, x1107, x1104);
    let x1150: u32 = ((x1149 as u32) + x1105);
    let (x1151, x1152) = fiat_p384_scalar_addcarryx_u32(0x0, x1076, x1126);
    let (x1153, x1154) = fiat_p384_scalar_addcarryx_u32(x1152, x1078, x1128);
    let (x1155, x1156) = fiat_p384_scalar_addcarryx_u32(x1154, x1080, x1130);
    let (x1157, x1158) = fiat_p384_scalar_addcarryx_u32(x1156, x1082, x1132);
    let (x1159, x1160) = fiat_p384_scalar_addcarryx_u32(x1158, x1084, x1134);
    let (x1161, x1162) = fiat_p384_scalar_addcarryx_u32(x1160, x1086, x1136);
    let (x1163, x1164) = fiat_p384_scalar_addcarryx_u32(x1162, x1088, x1138);
    let (x1165, x1166) = fiat_p384_scalar_addcarryx_u32(x1164, x1090, x1140);
    let (x1167, x1168) = fiat_p384_scalar_addcarryx_u32(x1166, x1092, x1142);
    let (x1169, x1170) = fiat_p384_scalar_addcarryx_u32(x1168, x1094, x1144);
    let (x1171, x1172) = fiat_p384_scalar_addcarryx_u32(x1170, x1096, x1146);
    let (x1173, x1174) = fiat_p384_scalar_addcarryx_u32(x1172, x1098, x1148);
    let (x1175, x1176) = fiat_p384_scalar_addcarryx_u32(x1174, x1100, x1150);
    let x1177: u32 = ((x1176 as u32) + (x1101 as u32));
    let (x1178, x1179) = fiat_p384_scalar_mulx_u32(x8, (arg2[11]));
    let (x1180, x1181) = fiat_p384_scalar_mulx_u32(x8, (arg2[10]));
    let (x1182, x1183) = fiat_p384_scalar_mulx_u32(x8, (arg2[9]));
    let (x1184, x1185) = fiat_p384_scalar_mulx_u32(x8, (arg2[8]));
    let (x1186, x1187) = fiat_p384_scalar_mulx_u32(x8, (arg2[7]));
    let (x1188, x1189) = fiat_p384_scalar_mulx_u32(x8, (arg2[6]));
    let (x1190, x1191) = fiat_p384_scalar_mulx_u32(x8, (arg2[5]));
    let (x1192, x1193) = fiat_p384_scalar_mulx_u32(x8, (arg2[4]));
    let (x1194, x1195) = fiat_p384_scalar_mulx_u32(x8, (arg2[3]));
    let (x1196, x1197) = fiat_p384_scalar_mulx_u32(x8, (arg2[2]));
    let (x1198, x1199) = fiat_p384_scalar_mulx_u32(x8, (arg2[1]));
    let (x1200, x1201) = fiat_p384_scalar_mulx_u32(x8, (arg2[0]));
    let (x1202, x1203) = fiat_p384_scalar_addcarryx_u32(0x0, x1201, x1198);
    let (x1204, x1205) = fiat_p384_scalar_addcarryx_u32(x1203, x1199, x1196);
    let (x1206, x1207) = fiat_p384_scalar_addcarryx_u32(x1205, x1197, x1194);
    let (x1208, x1209) = fiat_p384_scalar_addcarryx_u32(x1207, x1195, x1192);
    let (x1210, x1211) = fiat_p384_scalar_addcarryx_u32(x1209, x1193, x1190);
    let (x1212, x1213) = fiat_p384_scalar_addcarryx_u32(x1211, x1191, x1188);
    let (x1214, x1215) = fiat_p384_scalar_addcarryx_u32(x1213, x1189, x1186);
    let (x1216, x1217) = fiat_p384_scalar_addcarryx_u32(x1215, x1187, x1184);
    let (x1218, x1219) = fiat_p384_scalar_addcarryx_u32(x1217, x1185, x1182);
    let (x1220, x1221) = fiat_p384_scalar_addcarryx_u32(x1219, x1183, x1180);
    let (x1222, x1223) = fiat_p384_scalar_addcarryx_u32(x1221, x1181, x1178);
    let x1224: u32 = ((x1223 as u32) + x1179);
    let (x1225, x1226) = fiat_p384_scalar_addcarryx_u32(0x0, x1153, x1200);
    let (x1227, x1228) = fiat_p384_scalar_addcarryx_u32(x1226, x1155, x1202);
    let (x1229, x1230) = fiat_p384_scalar_addcarryx_u32(x1228, x1157, x1204);
    let (x1231, x1232) = fiat_p384_scalar_addcarryx_u32(x1230, x1159, x1206);
    let (x1233, x1234) = fiat_p384_scalar_addcarryx_u32(x1232, x1161, x1208);
    let (x1235, x1236) = fiat_p384_scalar_addcarryx_u32(x1234, x1163, x1210);
    let (x1237, x1238) = fiat_p384_scalar_addcarryx_u32(x1236, x1165, x1212);
    let (x1239, x1240) = fiat_p384_scalar_addcarryx_u32(x1238, x1167, x1214);
    let (x1241, x1242) = fiat_p384_scalar_addcarryx_u32(x1240, x1169, x1216);
    let (x1243, x1244) = fiat_p384_scalar_addcarryx_u32(x1242, x1171, x1218);
    let (x1245, x1246) = fiat_p384_scalar_addcarryx_u32(x1244, x1173, x1220);
    let (x1247, x1248) = fiat_p384_scalar_addcarryx_u32(x1246, x1175, x1222);
    let (x1249, x1250) = fiat_p384_scalar_addcarryx_u32(x1248, x1177, x1224);
    let (x1251, x1252) = fiat_p384_scalar_mulx_u32(x1225, 0xe88fdc45);
    let (x1253, x1254) = fiat_p384_scalar_mulx_u32(x1251, 0xffffffff);
    let (x1255, x1256) = fiat_p384_scalar_mulx_u32(x1251, 0xffffffff);
    let (x1257, x1258) = fiat_p384_scalar_mulx_u32(x1251, 0xffffffff);
    let (x1259, x1260) = fiat_p384_scalar_mulx_u32(x1251, 0xffffffff);
    let (x1261, x1262) = fiat_p384_scalar_mulx_u32(x1251, 0xffffffff);
    let (x1263, x1264) = fiat_p384_scalar_mulx_u32(x1251, 0xffffffff);
    let (x1265, x1266) = fiat_p384_scalar_mulx_u32(x1251, 0xc7634d81);
    let (x1267, x1268) = fiat_p384_scalar_mulx_u32(x1251, 0xf4372ddf);
    let (x1269, x1270) = fiat_p384_scalar_mulx_u32(x1251, 0x581a0db2);
    let (x1271, x1272) = fiat_p384_scalar_mulx_u32(x1251, 0x48b0a77a);
    let (x1273, x1274) = fiat_p384_scalar_mulx_u32(x1251, 0xecec196a);
    let (x1275, x1276) = fiat_p384_scalar_mulx_u32(x1251, 0xccc52973);
    let (x1277, x1278) = fiat_p384_scalar_addcarryx_u32(0x0, x1276, x1273);
    let (x1279, x1280) = fiat_p384_scalar_addcarryx_u32(x1278, x1274, x1271);
    let (x1281, x1282) = fiat_p384_scalar_addcarryx_u32(x1280, x1272, x1269);
    let (x1283, x1284) = fiat_p384_scalar_addcarryx_u32(x1282, x1270, x1267);
    let (x1285, x1286) = fiat_p384_scalar_addcarryx_u32(x1284, x1268, x1265);
    let (x1287, x1288) = fiat_p384_scalar_addcarryx_u32(x1286, x1266, x1263);
    let (x1289, x1290) = fiat_p384_scalar_addcarryx_u32(x1288, x1264, x1261);
    let (x1291, x1292) = fiat_p384_scalar_addcarryx_u32(x1290, x1262, x1259);
    let (x1293, x1294) = fiat_p384_scalar_addcarryx_u32(x1292, x1260, x1257);
    let (x1295, x1296) = fiat_p384_scalar_addcarryx_u32(x1294, x1258, x1255);
    let (x1297, x1298) = fiat_p384_scalar_addcarryx_u32(x1296, x1256, x1253);
    let x1299: u32 = ((x1298 as u32) + x1254);
    let (x1300, x1301) = fiat_p384_scalar_addcarryx_u32(0x0, x1225, x1275);
    let (x1302, x1303) = fiat_p384_scalar_addcarryx_u32(x1301, x1227, x1277);
    let (x1304, x1305) = fiat_p384_scalar_addcarryx_u32(x1303, x1229, x1279);
    let (x1306, x1307) = fiat_p384_scalar_addcarryx_u32(x1305, x1231, x1281);
    let (x1308, x1309) = fiat_p384_scalar_addcarryx_u32(x1307, x1233, x1283);
    let (x1310, x1311) = fiat_p384_scalar_addcarryx_u32(x1309, x1235, x1285);
    let (x1312, x1313) = fiat_p384_scalar_addcarryx_u32(x1311, x1237, x1287);
    let (x1314, x1315) = fiat_p384_scalar_addcarryx_u32(x1313, x1239, x1289);
    let (x1316, x1317) = fiat_p384_scalar_addcarryx_u32(x1315, x1241, x1291);
    let (x1318, x1319) = fiat_p384_scalar_addcarryx_u32(x1317, x1243, x1293);
    let (x1320, x1321) = fiat_p384_scalar_addcarryx_u32(x1319, x1245, x1295);
    let (x1322, x1323) = fiat_p384_scalar_addcarryx_u32(x1321, x1247, x1297);
    let (x1324, x1325) = fiat_p384_scalar_addcarryx_u32(x1323, x1249, x1299);
    let x1326: u32 = ((x1325 as u32) + (x1250 as u32));
    let (x1327, x1328) = fiat_p384_scalar_mulx_u32(x9, (arg2[11]));
    let (x1329, x1330) = fiat_p384_scalar_mulx_u32(x9, (arg2[10]));
    let (x1331, x1332) = fiat_p384_scalar_mulx_u32(x9, (arg2[9]));
    let (x1333, x1334) = fiat_p384_scalar_mulx_u32(x9, (arg2[8]));
    let (x1335, x1336) = fiat_p384_scalar_mulx_u32(x9, (arg2[7]));
    let (x1337, x1338) = fiat_p384_scalar_mulx_u32(x9, (arg2[6]));
    let (x1339, x1340) = fiat_p384_scalar_mulx_u32(x9, (arg2[5]));
    let (x1341, x1342) = fiat_p384_scalar_mulx_u32(x9, (arg2[4]));
    let (x1343, x1344) = fiat_p384_scalar_mulx_u32(x9, (arg2[3]));
    let (x1345, x1346) = fiat_p384_scalar_mulx_u32(x9, (arg2[2]));
    let (x1347, x1348) = fiat_p384_scalar_mulx_u32(x9, (arg2[1]));
    let (x1349, x1350) = fiat_p384_scalar_mulx_u32(x9, (arg2[0]));
    let (x1351, x1352) = fiat_p384_scalar_addcarryx_u32(0x0, x1350, x1347);
    let (x1353, x1354) = fiat_p384_scalar_addcarryx_u32(x1352, x1348, x1345);
    let (x1355, x1356) = fiat_p384_scalar_addcarryx_u32(x1354, x1346, x1343);
    let (x1357, x1358) = fiat_p384_scalar_addcarryx_u32(x1356, x1344, x1341);
    let (x1359, x1360) = fiat_p384_scalar_addcarryx_u32(x1358, x1342, x1339);
    let (x1361, x1362) = fiat_p384_scalar_addcarryx_u32(x1360, x1340, x1337);
    let (x1363, x1364) = fiat_p384_scalar_addcarryx_u32(x1362, x1338, x1335);
    let (x1365, x1366) = fiat_p384_scalar_addcarryx_u32(x1364, x1336, x1333);
    let (x1367, x1368) = fiat_p384_scalar_addcarryx_u32(x1366, x1334, x1331);
    let (x1369, x1370) = fiat_p384_scalar_addcarryx_u32(x1368, x1332, x1329);
    let (x1371, x1372) = fiat_p384_scalar_addcarryx_u32(x1370, x1330, x1327);
    let x1373: u32 = ((x1372 as u32) + x1328);
    let (x1374, x1375) = fiat_p384_scalar_addcarryx_u32(0x0, x1302, x1349);
    let (x1376, x1377) = fiat_p384_scalar_addcarryx_u32(x1375, x1304, x1351);
    let (x1378, x1379) = fiat_p384_scalar_addcarryx_u32(x1377, x1306, x1353);
    let (x1380, x1381) = fiat_p384_scalar_addcarryx_u32(x1379, x1308, x1355);
    let (x1382, x1383) = fiat_p384_scalar_addcarryx_u32(x1381, x1310, x1357);
    let (x1384, x1385) = fiat_p384_scalar_addcarryx_u32(x1383, x1312, x1359);
    let (x1386, x1387) = fiat_p384_scalar_addcarryx_u32(x1385, x1314, x1361);
    let (x1388, x1389) = fiat_p384_scalar_addcarryx_u32(x1387, x1316, x1363);
    let (x1390, x1391) = fiat_p384_scalar_addcarryx_u32(x1389, x1318, x1365);
    let (x1392, x1393) = fiat_p384_scalar_addcarryx_u32(x1391, x1320, x1367);
    let (x1394, x1395) = fiat_p384_scalar_addcarryx_u32(x1393, x1322, x1369);
    let (x1396, x1397) = fiat_p384_scalar_addcarryx_u32(x1395, x1324, x1371);
    let (x1398, x1399) = fiat_p384_scalar_addcarryx_u32(x1397, x1326, x1373);
    let (x1400, x1401) = fiat_p384_scalar_mulx_u32(x1374, 0xe88fdc45);
    let (x1402, x1403) = fiat_p384_scalar_mulx_u32(x1400, 0xffffffff);
    let (x1404, x1405) = fiat_p384_scalar_mulx_u32(x1400, 0xffffffff);
    let (x1406, x1407) = fiat_p384_scalar_mulx_u32(x1400, 0xffffffff);
    let (x1408, x1409) = fiat_p384_scalar_mulx_u32(x1400, 0xffffffff);
    let (x1410, x1411) = fiat_p384_scalar_mulx_u32(x1400, 0xffffffff);
    let (x1412, x1413) = fiat_p384_scalar_mulx_u32(x1400, 0xffffffff);
    let (x1414, x1415) = fiat_p384_scalar_mulx_u32(x1400, 0xc7634d81);
    let (x1416, x1417) = fiat_p384_scalar_mulx_u32(x1400, 0xf4372ddf);
    let (x1418, x1419) = fiat_p384_scalar_mulx_u32(x1400, 0x581a0db2);
    let (x1420, x1421) = fiat_p384_scalar_mulx_u32(x1400, 0x48b0a77a);
    let (x1422, x1423) = fiat_p384_scalar_mulx_u32(x1400, 0xecec196a);
    let (x1424, x1425) = fiat_p384_scalar_mulx_u32(x1400, 0xccc52973);
    let (x1426, x1427) = fiat_p384_scalar_addcarryx_u32(0x0, x1425, x1422);
    let (x1428, x1429) = fiat_p384_scalar_addcarryx_u32(x1427, x1423, x1420);
    let (x1430, x1431) = fiat_p384_scalar_addcarryx_u32(x1429, x1421, x1418);
    let (x1432, x1433) = fiat_p384_scalar_addcarryx_u32(x1431, x1419, x1416);
    let (x1434, x1435) = fiat_p384_scalar_addcarryx_u32(x1433, x1417, x1414);
    let (x1436, x1437) = fiat_p384_scalar_addcarryx_u32(x1435, x1415, x1412);
    let (x1438, x1439) = fiat_p384_scalar_addcarryx_u32(x1437, x1413, x1410);
    let (x1440, x1441) = fiat_p384_scalar_addcarryx_u32(x1439, x1411, x1408);
    let (x1442, x1443) = fiat_p384_scalar_addcarryx_u32(x1441, x1409, x1406);
    let (x1444, x1445) = fiat_p384_scalar_addcarryx_u32(x1443, x1407, x1404);
    let (x1446, x1447) = fiat_p384_scalar_addcarryx_u32(x1445, x1405, x1402);
    let x1448: u32 = ((x1447 as u32) + x1403);
    let (x1449, x1450) = fiat_p384_scalar_addcarryx_u32(0x0, x1374, x1424);
    let (x1451, x1452) = fiat_p384_scalar_addcarryx_u32(x1450, x1376, x1426);
    let (x1453, x1454) = fiat_p384_scalar_addcarryx_u32(x1452, x1378, x1428);
    let (x1455, x1456) = fiat_p384_scalar_addcarryx_u32(x1454, x1380, x1430);
    let (x1457, x1458) = fiat_p384_scalar_addcarryx_u32(x1456, x1382, x1432);
    let (x1459, x1460) = fiat_p384_scalar_addcarryx_u32(x1458, x1384, x1434);
    let (x1461, x1462) = fiat_p384_scalar_addcarryx_u32(x1460, x1386, x1436);
    let (x1463, x1464) = fiat_p384_scalar_addcarryx_u32(x1462, x1388, x1438);
    let (x1465, x1466) = fiat_p384_scalar_addcarryx_u32(x1464, x1390, x1440);
    let (x1467, x1468) = fiat_p384_scalar_addcarryx_u32(x1466, x1392, x1442);
    let (x1469, x1470) = fiat_p384_scalar_addcarryx_u32(x1468, x1394, x1444);
    let (x1471, x1472) = fiat_p384_scalar_addcarryx_u32(x1470, x1396, x1446);
    let (x1473, x1474) = fiat_p384_scalar_addcarryx_u32(x1472, x1398, x1448);
    let x1475: u32 = ((x1474 as u32) + (x1399 as u32));
    let (x1476, x1477) = fiat_p384_scalar_mulx_u32(x10, (arg2[11]));
    let (x1478, x1479) = fiat_p384_scalar_mulx_u32(x10, (arg2[10]));
    let (x1480, x1481) = fiat_p384_scalar_mulx_u32(x10, (arg2[9]));
    let (x1482, x1483) = fiat_p384_scalar_mulx_u32(x10, (arg2[8]));
    let (x1484, x1485) = fiat_p384_scalar_mulx_u32(x10, (arg2[7]));
    let (x1486, x1487) = fiat_p384_scalar_mulx_u32(x10, (arg2[6]));
    let (x1488, x1489) = fiat_p384_scalar_mulx_u32(x10, (arg2[5]));
    let (x1490, x1491) = fiat_p384_scalar_mulx_u32(x10, (arg2[4]));
    let (x1492, x1493) = fiat_p384_scalar_mulx_u32(x10, (arg2[3]));
    let (x1494, x1495) = fiat_p384_scalar_mulx_u32(x10, (arg2[2]));
    let (x1496, x1497) = fiat_p384_scalar_mulx_u32(x10, (arg2[1]));
    let (x1498, x1499) = fiat_p384_scalar_mulx_u32(x10, (arg2[0]));
    let (x1500, x1501) = fiat_p384_scalar_addcarryx_u32(0x0, x1499, x1496);
    let (x1502, x1503) = fiat_p384_scalar_addcarryx_u32(x1501, x1497, x1494);
    let (x1504, x1505) = fiat_p384_scalar_addcarryx_u32(x1503, x1495, x1492);
    let (x1506, x1507) = fiat_p384_scalar_addcarryx_u32(x1505, x1493, x1490);
    let (x1508, x1509) = fiat_p384_scalar_addcarryx_u32(x1507, x1491, x1488);
    let (x1510, x1511) = fiat_p384_scalar_addcarryx_u32(x1509, x1489, x1486);
    let (x1512, x1513) = fiat_p384_scalar_addcarryx_u32(x1511, x1487, x1484);
    let (x1514, x1515) = fiat_p384_scalar_addcarryx_u32(x1513, x1485, x1482);
    let (x1516, x1517) = fiat_p384_scalar_addcarryx_u32(x1515, x1483, x1480);
    let (x1518, x1519) = fiat_p384_scalar_addcarryx_u32(x1517, x1481, x1478);
    let (x1520, x1521) = fiat_p384_scalar_addcarryx_u32(x1519, x1479, x1476);
    let x1522: u32 = ((x1521 as u32) + x1477);
    let (x1523, x1524) = fiat_p384_scalar_addcarryx_u32(0x0, x1451, x1498);
    let (x1525, x1526) = fiat_p384_scalar_addcarryx_u32(x1524, x1453, x1500);
    let (x1527, x1528) = fiat_p384_scalar_addcarryx_u32(x1526, x1455, x1502);
    let (x1529, x1530) = fiat_p384_scalar_addcarryx_u32(x1528, x1457, x1504);
    let (x1531, x1532) = fiat_p384_scalar_addcarryx_u32(x1530, x1459, x1506);
    let (x1533, x1534) = fiat_p384_scalar_addcarryx_u32(x1532, x1461, x1508);
    let (x1535, x1536) = fiat_p384_scalar_addcarryx_u32(x1534, x1463, x1510);
    let (x1537, x1538) = fiat_p384_scalar_addcarryx_u32(x1536, x1465, x1512);
    let (x1539, x1540) = fiat_p384_scalar_addcarryx_u32(x1538, x1467, x1514);
    let (x1541, x1542) = fiat_p384_scalar_addcarryx_u32(x1540, x1469, x1516);
    let (x1543, x1544) = fiat_p384_scalar_addcarryx_u32(x1542, x1471, x1518);
    let (x1545, x1546) = fiat_p384_scalar_addcarryx_u32(x1544, x1473, x1520);
    let (x1547, x1548) = fiat_p384_scalar_addcarryx_u32(x1546, x1475, x1522);
    let (x1549, x1550) = fiat_p384_scalar_mulx_u32(x1523, 0xe88fdc45);
    let (x1551, x1552) = fiat_p384_scalar_mulx_u32(x1549, 0xffffffff);
    let (x1553, x1554) = fiat_p384_scalar_mulx_u32(x1549, 0xffffffff);
    let (x1555, x1556) = fiat_p384_scalar_mulx_u32(x1549, 0xffffffff);
    let (x1557, x1558) = fiat_p384_scalar_mulx_u32(x1549, 0xffffffff);
    let (x1559, x1560) = fiat_p384_scalar_mulx_u32(x1549, 0xffffffff);
    let (x1561, x1562) = fiat_p384_scalar_mulx_u32(x1549, 0xffffffff);
    let (x1563, x1564) = fiat_p384_scalar_mulx_u32(x1549, 0xc7634d81);
    let (x1565, x1566) = fiat_p384_scalar_mulx_u32(x1549, 0xf4372ddf);
    let (x1567, x1568) = fiat_p384_scalar_mulx_u32(x1549, 0x581a0db2);
    let (x1569, x1570) = fiat_p384_scalar_mulx_u32(x1549, 0x48b0a77a);
    let (x1571, x1572) = fiat_p384_scalar_mulx_u32(x1549, 0xecec196a);
    let (x1573, x1574) = fiat_p384_scalar_mulx_u32(x1549, 0xccc52973);
    let (x1575, x1576) = fiat_p384_scalar_addcarryx_u32(0x0, x1574, x1571);
    let (x1577, x1578) = fiat_p384_scalar_addcarryx_u32(x1576, x1572, x1569);
    let (x1579, x1580) = fiat_p384_scalar_addcarryx_u32(x1578, x1570, x1567);
    let (x1581, x1582) = fiat_p384_scalar_addcarryx_u32(x1580, x1568, x1565);
    let (x1583, x1584) = fiat_p384_scalar_addcarryx_u32(x1582, x1566, x1563);
    let (x1585, x1586) = fiat_p384_scalar_addcarryx_u32(x1584, x1564, x1561);
    let (x1587, x1588) = fiat_p384_scalar_addcarryx_u32(x1586, x1562, x1559);
    let (x1589, x1590) = fiat_p384_scalar_addcarryx_u32(x1588, x1560, x1557);
    let (x1591, x1592) = fiat_p384_scalar_addcarryx_u32(x1590, x1558, x1555);
    let (x1593, x1594) = fiat_p384_scalar_addcarryx_u32(x1592, x1556, x1553);
    let (x1595, x1596) = fiat_p384_scalar_addcarryx_u32(x1594, x1554, x1551);
    let x1597: u32 = ((x1596 as u32) + x1552);
    let (x1598, x1599) = fiat_p384_scalar_addcarryx_u32(0x0, x1523, x1573);
    let (x1600, x1601) = fiat_p384_scalar_addcarryx_u32(x1599, x1525, x1575);
    let (x1602, x1603) = fiat_p384_scalar_addcarryx_u32(x1601, x1527, x1577);
    let (x1604, x1605) = fiat_p384_scalar_addcarryx_u32(x1603, x1529, x1579);
    let (x1606, x1607) = fiat_p384_scalar_addcarryx_u32(x1605, x1531, x1581);
    let (x1608, x1609) = fiat_p384_scalar_addcarryx_u32(x1607, x1533, x1583);
    let (x1610, x1611) = fiat_p384_scalar_addcarryx_u32(x1609, x1535, x1585);
    let (x1612, x1613) = fiat_p384_scalar_addcarryx_u32(x1611, x1537, x1587);
    let (x1614, x1615) = fiat_p384_scalar_addcarryx_u32(x1613, x1539, x1589);
    let (x1616, x1617) = fiat_p384_scalar_addcarryx_u32(x1615, x1541, x1591);
    let (x1618, x1619) = fiat_p384_scalar_addcarryx_u32(x1617, x1543, x1593);
    let (x1620, x1621) = fiat_p384_scalar_addcarryx_u32(x1619, x1545, x1595);
    let (x1622, x1623) = fiat_p384_scalar_addcarryx_u32(x1621, x1547, x1597);
    let x1624: u32 = ((x1623 as u32) + (x1548 as u32));
    let (x1625, x1626) = fiat_p384_scalar_mulx_u32(x11, (arg2[11]));
    let (x1627, x1628) = fiat_p384_scalar_mulx_u32(x11, (arg2[10]));
    let (x1629, x1630) = fiat_p384_scalar_mulx_u32(x11, (arg2[9]));
    let (x1631, x1632) = fiat_p384_scalar_mulx_u32(x11, (arg2[8]));
    let (x1633, x1634) = fiat_p384_scalar_mulx_u32(x11, (arg2[7]));
    let (x1635, x1636) = fiat_p384_scalar_mulx_u32(x11, (arg2[6]));
    let (x1637, x1638) = fiat_p384_scalar_mulx_u32(x11, (arg2[5]));
    let (x1639, x1640) = fiat_p384_scalar_mulx_u32(x11, (arg2[4]));
    let (x1641, x1642) = fiat_p384_scalar_mulx_u32(x11, (arg2[3]));
    let (x1643, x1644) = fiat_p384_scalar_mulx_u32(x11, (arg2[2]));
    let (x1645, x1646) = fiat_p384_scalar_mulx_u32(x11, (arg2[1]));
    let (x1647, x1648) = fiat_p384_scalar_mulx_u32(x11, (arg2[0]));
    let (x1649, x1650) = fiat_p384_scalar_addcarryx_u32(0x0, x1648, x1645);
    let (x1651, x1652) = fiat_p384_scalar_addcarryx_u32(x1650, x1646, x1643);
    let (x1653, x1654) = fiat_p384_scalar_addcarryx_u32(x1652, x1644, x1641);
    let (x1655, x1656) = fiat_p384_scalar_addcarryx_u32(x1654, x1642, x1639);
    let (x1657, x1658) = fiat_p384_scalar_addcarryx_u32(x1656, x1640, x1637);
    let (x1659, x1660) = fiat_p384_scalar_addcarryx_u32(x1658, x1638, x1635);
    let (x1661, x1662) = fiat_p384_scalar_addcarryx_u32(x1660, x1636, x1633);
    let (x1663, x1664) = fiat_p384_scalar_addcarryx_u32(x1662, x1634, x1631);
    let (x1665, x1666) = fiat_p384_scalar_addcarryx_u32(x1664, x1632, x1629);
    let (x1667, x1668) = fiat_p384_scalar_addcarryx_u32(x1666, x1630, x1627);
    let (x1669, x1670) = fiat_p384_scalar_addcarryx_u32(x1668, x1628, x1625);
    let x1671: u32 = ((x1670 as u32) + x1626);
    let (x1672, x1673) = fiat_p384_scalar_addcarryx_u32(0x0, x1600, x1647);
    let (x1674, x1675) = fiat_p384_scalar_addcarryx_u32(x1673, x1602, x1649);
    let (x1676, x1677) = fiat_p384_scalar_addcarryx_u32(x1675, x1604, x1651);
    let (x1678, x1679) = fiat_p384_scalar_addcarryx_u32(x1677, x1606, x1653);
    let (x1680, x1681) = fiat_p384_scalar_addcarryx_u32(x1679, x1608, x1655);
    let (x1682, x1683) = fiat_p384_scalar_addcarryx_u32(x1681, x1610, x1657);
    let (x1684, x1685) = fiat_p384_scalar_addcarryx_u32(x1683, x1612, x1659);
    let (x1686, x1687) = fiat_p384_scalar_addcarryx_u32(x1685, x1614, x1661);
    let (x1688, x1689) = fiat_p384_scalar_addcarryx_u32(x1687, x1616, x1663);
    let (x1690, x1691) = fiat_p384_scalar_addcarryx_u32(x1689, x1618, x1665);
    let (x1692, x1693) = fiat_p384_scalar_addcarryx_u32(x1691, x1620, x1667);
    let (x1694, x1695) = fiat_p384_scalar_addcarryx_u32(x1693, x1622, x1669);
    let (x1696, x1697) = fiat_p384_scalar_addcarryx_u32(x1695, x1624, x1671);
    let (x1698, x1699) = fiat_p384_scalar_mulx_u32(x1672, 0xe88fdc45);
    let (x1700, x1701) = fiat_p384_scalar_mulx_u32(x1698, 0xffffffff);
    let (x1702, x1703) = fiat_p384_scalar_mulx_u32(x1698, 0xffffffff);
    let (x1704, x1705) = fiat_p384_scalar_mulx_u32(x1698, 0xffffffff);
    let (x1706, x1707) = fiat_p384_scalar_mulx_u32(x1698, 0xffffffff);
    let (x1708, x1709) = fiat_p384_scalar_mulx_u32(x1698, 0xffffffff);
    let (x1710, x1711) = fiat_p384_scalar_mulx_u32(x1698, 0xffffffff);
    let (x1712, x1713) = fiat_p384_scalar_mulx_u32(x1698, 0xc7634d81);
    let (x1714, x1715) = fiat_p384_scalar_mulx_u32(x1698, 0xf4372ddf);
    let (x1716, x1717) = fiat_p384_scalar_mulx_u32(x1698, 0x581a0db2);
    let (x1718, x1719) = fiat_p384_scalar_mulx_u32(x1698, 0x48b0a77a);
    let (x1720, x1721) = fiat_p384_scalar_mulx_u32(x1698, 0xecec196a);
    let (x1722, x1723) = fiat_p384_scalar_mulx_u32(x1698, 0xccc52973);
    let (x1724, x1725) = fiat_p384_scalar_addcarryx_u32(0x0, x1723, x1720);
    let (x1726, x1727) = fiat_p384_scalar_addcarryx_u32(x1725, x1721, x1718);
    let (x1728, x1729) = fiat_p384_scalar_addcarryx_u32(x1727, x1719, x1716);
    let (x1730, x1731) = fiat_p384_scalar_addcarryx_u32(x1729, x1717, x1714);
    let (x1732, x1733) = fiat_p384_scalar_addcarryx_u32(x1731, x1715, x1712);
    let (x1734, x1735) = fiat_p384_scalar_addcarryx_u32(x1733, x1713, x1710);
    let (x1736, x1737) = fiat_p384_scalar_addcarryx_u32(x1735, x1711, x1708);
    let (x1738, x1739) = fiat_p384_scalar_addcarryx_u32(x1737, x1709, x1706);
    let (x1740, x1741) = fiat_p384_scalar_addcarryx_u32(x1739, x1707, x1704);
    let (x1742, x1743) = fiat_p384_scalar_addcarryx_u32(x1741, x1705, x1702);
    let (x1744, x1745) = fiat_p384_scalar_addcarryx_u32(x1743, x1703, x1700);
    let x1746: u32 = ((x1745 as u32) + x1701);
    let (x1747, x1748) = fiat_p384_scalar_addcarryx_u32(0x0, x1672, x1722);
    let (x1749, x1750) = fiat_p384_scalar_addcarryx_u32(x1748, x1674, x1724);
    let (x1751, x1752) = fiat_p384_scalar_addcarryx_u32(x1750, x1676, x1726);
    let (x1753, x1754) = fiat_p384_scalar_addcarryx_u32(x1752, x1678, x1728);
    let (x1755, x1756) = fiat_p384_scalar_addcarryx_u32(x1754, x1680, x1730);
    let (x1757, x1758) = fiat_p384_scalar_addcarryx_u32(x1756, x1682, x1732);
    let (x1759, x1760) = fiat_p384_scalar_addcarryx_u32(x1758, x1684, x1734);
    let (x1761, x1762) = fiat_p384_scalar_addcarryx_u32(x1760, x1686, x1736);
    let (x1763, x1764) = fiat_p384_scalar_addcarryx_u32(x1762, x1688, x1738);
    let (x1765, x1766) = fiat_p384_scalar_addcarryx_u32(x1764, x1690, x1740);
    let (x1767, x1768) = fiat_p384_scalar_addcarryx_u32(x1766, x1692, x1742);
    let (x1769, x1770) = fiat_p384_scalar_addcarryx_u32(x1768, x1694, x1744);
    let (x1771, x1772) = fiat_p384_scalar_addcarryx_u32(x1770, x1696, x1746);
    let x1773: u32 = ((x1772 as u32) + (x1697 as u32));
    let (x1774, x1775) = fiat_p384_scalar_subborrowx_u32(0x0, x1749, 0xccc52973);
    let (x1776, x1777) = fiat_p384_scalar_subborrowx_u32(x1775, x1751, 0xecec196a);
    let (x1778, x1779) = fiat_p384_scalar_subborrowx_u32(x1777, x1753, 0x48b0a77a);
    let (x1780, x1781) = fiat_p384_scalar_subborrowx_u32(x1779, x1755, 0x581a0db2);
    let (x1782, x1783) = fiat_p384_scalar_subborrowx_u32(x1781, x1757, 0xf4372ddf);
    let (x1784, x1785) = fiat_p384_scalar_subborrowx_u32(x1783, x1759, 0xc7634d81);
    let (x1786, x1787) = fiat_p384_scalar_subborrowx_u32(x1785, x1761, 0xffffffff);
    let (x1788, x1789) = fiat_p384_scalar_subborrowx_u32(x1787, x1763, 0xffffffff);
    let (x1790, x1791) = fiat_p384_scalar_subborrowx_u32(x1789, x1765, 0xffffffff);
    let (x1792, x1793) = fiat_p384_scalar_subborrowx_u32(x1791, x1767, 0xffffffff);
    let (x1794, x1795) = fiat_p384_scalar_subborrowx_u32(x1793, x1769, 0xffffffff);
    let (x1796, x1797) = fiat_p384_scalar_subborrowx_u32(x1795, x1771, 0xffffffff);
    let (x1798, x1799) = fiat_p384_scalar_subborrowx_u32(x1797, x1773, (0x0 as u32));
    let (x1800) = fiat_p384_scalar_cmovznz_u32(x1799, x1774, x1749);
    let (x1801) = fiat_p384_scalar_cmovznz_u32(x1799, x1776, x1751);
    let (x1802) = fiat_p384_scalar_cmovznz_u32(x1799, x1778, x1753);
    let (x1803) = fiat_p384_scalar_cmovznz_u32(x1799, x1780, x1755);
    let (x1804) = fiat_p384_scalar_cmovznz_u32(x1799, x1782, x1757);
    let (x1805) = fiat_p384_scalar_cmovznz_u32(x1799, x1784, x1759);
    let (x1806) = fiat_p384_scalar_cmovznz_u32(x1799, x1786, x1761);
    let (x1807) = fiat_p384_scalar_cmovznz_u32(x1799, x1788, x1763);
    let (x1808) = fiat_p384_scalar_cmovznz_u32(x1799, x1790, x1765);
    let (x1809) = fiat_p384_scalar_cmovznz_u32(x1799, x1792, x1767);
    let (x1810) = fiat_p384_scalar_cmovznz_u32(x1799, x1794, x1769);
    let (x1811) = fiat_p384_scalar_cmovznz_u32(x1799, x1796, x1771);
    out1[0] = x1800;
    out1[1] = x1801;
    out1[2] = x1802;
    out1[3] = x1803;
    out1[4] = x1804;
    out1[5] = x1805;
    out1[6] = x1806;
    out1[7] = x1807;
    out1[8] = x1808;
    out1[9] = x1809;
    out1[10] = x1810;
    out1[11] = x1811;
    out1
}
#[doc = " The function fiat_p384_scalar_square squares a field element in the Montgomery domain."]
#[doc = ""]
#[doc = " Preconditions:"]
#[doc = "   0 ≤ eval arg1 < m"]
#[doc = " Postconditions:"]
#[doc = "   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) * eval (from_montgomery arg1)) mod m"]
#[doc = "   0 ≤ eval out1 < m"]
#[doc = ""]
#[inline]
pub const fn fiat_p384_scalar_square(
    arg1: &fiat_p384_scalar_montgomery_domain_field_element,
) -> fiat_p384_scalar_montgomery_domain_field_element {
    let mut out1: fiat_p384_scalar_montgomery_domain_field_element = [0; 12];
    let x1: u32 = (arg1[1]);
    let x2: u32 = (arg1[2]);
    let x3: u32 = (arg1[3]);
    let x4: u32 = (arg1[4]);
    let x5: u32 = (arg1[5]);
    let x6: u32 = (arg1[6]);
    let x7: u32 = (arg1[7]);
    let x8: u32 = (arg1[8]);
    let x9: u32 = (arg1[9]);
    let x10: u32 = (arg1[10]);
    let x11: u32 = (arg1[11]);
    let x12: u32 = (arg1[0]);
    let (x13, x14) = fiat_p384_scalar_mulx_u32(x12, (arg1[11]));
    let (x15, x16) = fiat_p384_scalar_mulx_u32(x12, (arg1[10]));
    let (x17, x18) = fiat_p384_scalar_mulx_u32(x12, (arg1[9]));
    let (x19, x20) = fiat_p384_scalar_mulx_u32(x12, (arg1[8]));
    let (x21, x22) = fiat_p384_scalar_mulx_u32(x12, (arg1[7]));
    let (x23, x24) = fiat_p384_scalar_mulx_u32(x12, (arg1[6]));
    let (x25, x26) = fiat_p384_scalar_mulx_u32(x12, (arg1[5]));
    let (x27, x28) = fiat_p384_scalar_mulx_u32(x12, (arg1[4]));
    let (x29, x30) = fiat_p384_scalar_mulx_u32(x12, (arg1[3]));
    let (x31, x32) = fiat_p384_scalar_mulx_u32(x12, (arg1[2]));
    let (x33, x34) = fiat_p384_scalar_mulx_u32(x12, (arg1[1]));
    let (x35, x36) = fiat_p384_scalar_mulx_u32(x12, (arg1[0]));
    let (x37, x38) = fiat_p384_scalar_addcarryx_u32(0x0, x36, x33);
    let (x39, x40) = fiat_p384_scalar_addcarryx_u32(x38, x34, x31);
    let (x41, x42) = fiat_p384_scalar_addcarryx_u32(x40, x32, x29);
    let (x43, x44) = fiat_p384_scalar_addcarryx_u32(x42, x30, x27);
    let (x45, x46) = fiat_p384_scalar_addcarryx_u32(x44, x28, x25);
    let (x47, x48) = fiat_p384_scalar_addcarryx_u32(x46, x26, x23);
    let (x49, x50) = fiat_p384_scalar_addcarryx_u32(x48, x24, x21);
    let (x51, x52) = fiat_p384_scalar_addcarryx_u32(x50, x22, x19);
    let (x53, x54) = fiat_p384_scalar_addcarryx_u32(x52, x20, x17);
    let (x55, x56) = fiat_p384_scalar_addcarryx_u32(x54, x18, x15);
    let (x57, x58) = fiat_p384_scalar_addcarryx_u32(x56, x16, x13);
    let x59: u32 = ((x58 as u32) + x14);
    let (x60, x61) = fiat_p384_scalar_mulx_u32(x35, 0xe88fdc45);
    let (x62, x63) = fiat_p384_scalar_mulx_u32(x60, 0xffffffff);
    let (x64, x65) = fiat_p384_scalar_mulx_u32(x60, 0xffffffff);
    let (x66, x67) = fiat_p384_scalar_mulx_u32(x60, 0xffffffff);
    let (x68, x69) = fiat_p384_scalar_mulx_u32(x60, 0xffffffff);
    let (x70, x71) = fiat_p384_scalar_mulx_u32(x60, 0xffffffff);
    let (x72, x73) = fiat_p384_scalar_mulx_u32(x60, 0xffffffff);
    let (x74, x75) = fiat_p384_scalar_mulx_u32(x60, 0xc7634d81);
    let (x76, x77) = fiat_p384_scalar_mulx_u32(x60, 0xf4372ddf);
    let (x78, x79) = fiat_p384_scalar_mulx_u32(x60, 0x581a0db2);
    let (x80, x81) = fiat_p384_scalar_mulx_u32(x60, 0x48b0a77a);
    let (x82, x83) = fiat_p384_scalar_mulx_u32(x60, 0xecec196a);
    let (x84, x85) = fiat_p384_scalar_mulx_u32(x60, 0xccc52973);
    let (x86, x87) = fiat_p384_scalar_addcarryx_u32(0x0, x85, x82);
    let (x88, x89) = fiat_p384_scalar_addcarryx_u32(x87, x83, x80);
    let (x90, x91) = fiat_p384_scalar_addcarryx_u32(x89, x81, x78);
    let (x92, x93) = fiat_p384_scalar_addcarryx_u32(x91, x79, x76);
    let (x94, x95) = fiat_p384_scalar_addcarryx_u32(x93, x77, x74);
    let (x96, x97) = fiat_p384_scalar_addcarryx_u32(x95, x75, x72);
    let (x98, x99) = fiat_p384_scalar_addcarryx_u32(x97, x73, x70);
    let (x100, x101) = fiat_p384_scalar_addcarryx_u32(x99, x71, x68);
    let (x102, x103) = fiat_p384_scalar_addcarryx_u32(x101, x69, x66);
    let (x104, x105) = fiat_p384_scalar_addcarryx_u32(x103, x67, x64);
    let (x106, x107) = fiat_p384_scalar_addcarryx_u32(x105, x65, x62);
    let x108: u32 = ((x107 as u32) + x63);
    let (x109, x110) = fiat_p384_scalar_addcarryx_u32(0x0, x35, x84);
    let (x111, x112) = fiat_p384_scalar_addcarryx_u32(x110, x37, x86);
    let (x113, x114) = fiat_p384_scalar_addcarryx_u32(x112, x39, x88);
    let (x115, x116) = fiat_p384_scalar_addcarryx_u32(x114, x41, x90);
    let (x117, x118) = fiat_p384_scalar_addcarryx_u32(x116, x43, x92);
    let (x119, x120) = fiat_p384_scalar_addcarryx_u32(x118, x45, x94);
    let (x121, x122) = fiat_p384_scalar_addcarryx_u32(x120, x47, x96);
    let (x123, x124) = fiat_p384_scalar_addcarryx_u32(x122, x49, x98);
    let (x125, x126) = fiat_p384_scalar_addcarryx_u32(x124, x51, x100);
    let (x127, x128) = fiat_p384_scalar_addcarryx_u32(x126, x53, x102);
    let (x129, x130) = fiat_p384_scalar_addcarryx_u32(x128, x55, x104);
    let (x131, x132) = fiat_p384_scalar_addcarryx_u32(x130, x57, x106);
    let (x133, x134) = fiat_p384_scalar_addcarryx_u32(x132, x59, x108);
    let (x135, x136) = fiat_p384_scalar_mulx_u32(x1, (arg1[11]));
    let (x137, x138) = fiat_p384_scalar_mulx_u32(x1, (arg1[10]));
    let (x139, x140) = fiat_p384_scalar_mulx_u32(x1, (arg1[9]));
    let (x141, x142) = fiat_p384_scalar_mulx_u32(x1, (arg1[8]));
    let (x143, x144) = fiat_p384_scalar_mulx_u32(x1, (arg1[7]));
    let (x145, x146) = fiat_p384_scalar_mulx_u32(x1, (arg1[6]));
    let (x147, x148) = fiat_p384_scalar_mulx_u32(x1, (arg1[5]));
    let (x149, x150) = fiat_p384_scalar_mulx_u32(x1, (arg1[4]));
    let (x151, x152) = fiat_p384_scalar_mulx_u32(x1, (arg1[3]));
    let (x153, x154) = fiat_p384_scalar_mulx_u32(x1, (arg1[2]));
    let (x155, x156) = fiat_p384_scalar_mulx_u32(x1, (arg1[1]));
    let (x157, x158) = fiat_p384_scalar_mulx_u32(x1, (arg1[0]));
    let (x159, x160) = fiat_p384_scalar_addcarryx_u32(0x0, x158, x155);
    let (x161, x162) = fiat_p384_scalar_addcarryx_u32(x160, x156, x153);
    let (x163, x164) = fiat_p384_scalar_addcarryx_u32(x162, x154, x151);
    let (x165, x166) = fiat_p384_scalar_addcarryx_u32(x164, x152, x149);
    let (x167, x168) = fiat_p384_scalar_addcarryx_u32(x166, x150, x147);
    let (x169, x170) = fiat_p384_scalar_addcarryx_u32(x168, x148, x145);
    let (x171, x172) = fiat_p384_scalar_addcarryx_u32(x170, x146, x143);
    let (x173, x174) = fiat_p384_scalar_addcarryx_u32(x172, x144, x141);
    let (x175, x176) = fiat_p384_scalar_addcarryx_u32(x174, x142, x139);
    let (x177, x178) = fiat_p384_scalar_addcarryx_u32(x176, x140, x137);
    let (x179, x180) = fiat_p384_scalar_addcarryx_u32(x178, x138, x135);
    let x181: u32 = ((x180 as u32) + x136);
    let (x182, x183) = fiat_p384_scalar_addcarryx_u32(0x0, x111, x157);
    let (x184, x185) = fiat_p384_scalar_addcarryx_u32(x183, x113, x159);
    let (x186, x187) = fiat_p384_scalar_addcarryx_u32(x185, x115, x161);
    let (x188, x189) = fiat_p384_scalar_addcarryx_u32(x187, x117, x163);
    let (x190, x191) = fiat_p384_scalar_addcarryx_u32(x189, x119, x165);
    let (x192, x193) = fiat_p384_scalar_addcarryx_u32(x191, x121, x167);
    let (x194, x195) = fiat_p384_scalar_addcarryx_u32(x193, x123, x169);
    let (x196, x197) = fiat_p384_scalar_addcarryx_u32(x195, x125, x171);
    let (x198, x199) = fiat_p384_scalar_addcarryx_u32(x197, x127, x173);
    let (x200, x201) = fiat_p384_scalar_addcarryx_u32(x199, x129, x175);
    let (x202, x203) = fiat_p384_scalar_addcarryx_u32(x201, x131, x177);
    let (x204, x205) = fiat_p384_scalar_addcarryx_u32(x203, x133, x179);
    let (x206, x207) = fiat_p384_scalar_addcarryx_u32(x205, (x134 as u32), x181);
    let (x208, x209) = fiat_p384_scalar_mulx_u32(x182, 0xe88fdc45);
    let (x210, x211) = fiat_p384_scalar_mulx_u32(x208, 0xffffffff);
    let (x212, x213) = fiat_p384_scalar_mulx_u32(x208, 0xffffffff);
    let (x214, x215) = fiat_p384_scalar_mulx_u32(x208, 0xffffffff);
    let (x216, x217) = fiat_p384_scalar_mulx_u32(x208, 0xffffffff);
    let (x218, x219) = fiat_p384_scalar_mulx_u32(x208, 0xffffffff);
    let (x220, x221) = fiat_p384_scalar_mulx_u32(x208, 0xffffffff);
    let (x222, x223) = fiat_p384_scalar_mulx_u32(x208, 0xc7634d81);
    let (x224, x225) = fiat_p384_scalar_mulx_u32(x208, 0xf4372ddf);
    let (x226, x227) = fiat_p384_scalar_mulx_u32(x208, 0x581a0db2);
    let (x228, x229) = fiat_p384_scalar_mulx_u32(x208, 0x48b0a77a);
    let (x230, x231) = fiat_p384_scalar_mulx_u32(x208, 0xecec196a);
    let (x232, x233) = fiat_p384_scalar_mulx_u32(x208, 0xccc52973);
    let (x234, x235) = fiat_p384_scalar_addcarryx_u32(0x0, x233, x230);
    let (x236, x237) = fiat_p384_scalar_addcarryx_u32(x235, x231, x228);
    let (x238, x239) = fiat_p384_scalar_addcarryx_u32(x237, x229, x226);
    let (x240, x241) = fiat_p384_scalar_addcarryx_u32(x239, x227, x224);
    let (x242, x243) = fiat_p384_scalar_addcarryx_u32(x241, x225, x222);
    let (x244, x245) = fiat_p384_scalar_addcarryx_u32(x243, x223, x220);
    let (x246, x247) = fiat_p384_scalar_addcarryx_u32(x245, x221, x218);
    let (x248, x249) = fiat_p384_scalar_addcarryx_u32(x247, x219, x216);
    let (x250, x251) = fiat_p384_scalar_addcarryx_u32(x249, x217, x214);
    let (x252, x253) = fiat_p384_scalar_addcarryx_u32(x251, x215, x212);
    let (x254, x255) = fiat_p384_scalar_addcarryx_u32(x253, x213, x210);
    let x256: u32 = ((x255 as u32) + x211);
    let (x257, x258) = fiat_p384_scalar_addcarryx_u32(0x0, x182, x232);
    let (x259, x260) = fiat_p384_scalar_addcarryx_u32(x258, x184, x234);
    let (x261, x262) = fiat_p384_scalar_addcarryx_u32(x260, x186, x236);
    let (x263, x264) = fiat_p384_scalar_addcarryx_u32(x262, x188, x238);
    let (x265, x266) = fiat_p384_scalar_addcarryx_u32(x264, x190, x240);
    let (x267, x268) = fiat_p384_scalar_addcarryx_u32(x266, x192, x242);
    let (x269, x270) = fiat_p384_scalar_addcarryx_u32(x268, x194, x244);
    let (x271, x272) = fiat_p384_scalar_addcarryx_u32(x270, x196, x246);
    let (x273, x274) = fiat_p384_scalar_addcarryx_u32(x272, x198, x248);
    let (x275, x276) = fiat_p384_scalar_addcarryx_u32(x274, x200, x250);
    let (x277, x278) = fiat_p384_scalar_addcarryx_u32(x276, x202, x252);
    let (x279, x280) = fiat_p384_scalar_addcarryx_u32(x278, x204, x254);
    let (x281, x282) = fiat_p384_scalar_addcarryx_u32(x280, x206, x256);
    let x283: u32 = ((x282 as u32) + (x207 as u32));
    let (x284, x285) = fiat_p384_scalar_mulx_u32(x2, (arg1[11]));
    let (x286, x287) = fiat_p384_scalar_mulx_u32(x2, (arg1[10]));
    let (x288, x289) = fiat_p384_scalar_mulx_u32(x2, (arg1[9]));
    let (x290, x291) = fiat_p384_scalar_mulx_u32(x2, (arg1[8]));
    let (x292, x293) = fiat_p384_scalar_mulx_u32(x2, (arg1[7]));
    let (x294, x295) = fiat_p384_scalar_mulx_u32(x2, (arg1[6]));
    let (x296, x297) = fiat_p384_scalar_mulx_u32(x2, (arg1[5]));
    let (x298, x299) = fiat_p384_scalar_mulx_u32(x2, (arg1[4]));
    let (x300, x301) = fiat_p384_scalar_mulx_u32(x2, (arg1[3]));
    let (x302, x303) = fiat_p384_scalar_mulx_u32(x2, (arg1[2]));
    let (x304, x305) = fiat_p384_scalar_mulx_u32(x2, (arg1[1]));
    let (x306, x307) = fiat_p384_scalar_mulx_u32(x2, (arg1[0]));
    let (x308, x309) = fiat_p384_scalar_addcarryx_u32(0x0, x307, x304);
    let (x310, x311) = fiat_p384_scalar_addcarryx_u32(x309, x305, x302);
    let (x312, x313) = fiat_p384_scalar_addcarryx_u32(x311, x303, x300);
    let (x314, x315) = fiat_p384_scalar_addcarryx_u32(x313, x301, x298);
    let (x316, x317) = fiat_p384_scalar_addcarryx_u32(x315, x299, x296);
    let (x318, x319) = fiat_p384_scalar_addcarryx_u32(x317, x297, x294);
    let (x320, x321) = fiat_p384_scalar_addcarryx_u32(x319, x295, x292);
    let (x322, x323) = fiat_p384_scalar_addcarryx_u32(x321, x293, x290);
    let (x324, x325) = fiat_p384_scalar_addcarryx_u32(x323, x291, x288);
    let (x326, x327) = fiat_p384_scalar_addcarryx_u32(x325, x289, x286);
    let (x328, x329) = fiat_p384_scalar_addcarryx_u32(x327, x287, x284);
    let x330: u32 = ((x329 as u32) + x285);
    let (x331, x332) = fiat_p384_scalar_addcarryx_u32(0x0, x259, x306);
    let (x333, x334) = fiat_p384_scalar_addcarryx_u32(x332, x261, x308);
    let (x335, x336) = fiat_p384_scalar_addcarryx_u32(x334, x263, x310);
    let (x337, x338) = fiat_p384_scalar_addcarryx_u32(x336, x265, x312);
    let (x339, x340) = fiat_p384_scalar_addcarryx_u32(x338, x267, x314);
    let (x341, x342) = fiat_p384_scalar_addcarryx_u32(x340, x269, x316);
    let (x343, x344) = fiat_p384_scalar_addcarryx_u32(x342, x271, x318);
    let (x345, x346) = fiat_p384_scalar_addcarryx_u32(x344, x273, x320);
    let (x347, x348) = fiat_p384_scalar_addcarryx_u32(x346, x275, x322);
    let (x349, x350) = fiat_p384_scalar_addcarryx_u32(x348, x277, x324);
    let (x351, x352) = fiat_p384_scalar_addcarryx_u32(x350, x279, x326);
    let (x353, x354) = fiat_p384_scalar_addcarryx_u32(x352, x281, x328);
    let (x355, x356) = fiat_p384_scalar_addcarryx_u32(x354, x283, x330);
    let (x357, x358) = fiat_p384_scalar_mulx_u32(x331, 0xe88fdc45);
    let (x359, x360) = fiat_p384_scalar_mulx_u32(x357, 0xffffffff);
    let (x361, x362) = fiat_p384_scalar_mulx_u32(x357, 0xffffffff);
    let (x363, x364) = fiat_p384_scalar_mulx_u32(x357, 0xffffffff);
    let (x365, x366) = fiat_p384_scalar_mulx_u32(x357, 0xffffffff);
    let (x367, x368) = fiat_p384_scalar_mulx_u32(x357, 0xffffffff);
    let (x369, x370) = fiat_p384_scalar_mulx_u32(x357, 0xffffffff);
    let (x371, x372) = fiat_p384_scalar_mulx_u32(x357, 0xc7634d81);
    let (x373, x374) = fiat_p384_scalar_mulx_u32(x357, 0xf4372ddf);
    let (x375, x376) = fiat_p384_scalar_mulx_u32(x357, 0x581a0db2);
    let (x377, x378) = fiat_p384_scalar_mulx_u32(x357, 0x48b0a77a);
    let (x379, x380) = fiat_p384_scalar_mulx_u32(x357, 0xecec196a);
    let (x381, x382) = fiat_p384_scalar_mulx_u32(x357, 0xccc52973);
    let (x383, x384) = fiat_p384_scalar_addcarryx_u32(0x0, x382, x379);
    let (x385, x386) = fiat_p384_scalar_addcarryx_u32(x384, x380, x377);
    let (x387, x388) = fiat_p384_scalar_addcarryx_u32(x386, x378, x375);
    let (x389, x390) = fiat_p384_scalar_addcarryx_u32(x388, x376, x373);
    let (x391, x392) = fiat_p384_scalar_addcarryx_u32(x390, x374, x371);
    let (x393, x394) = fiat_p384_scalar_addcarryx_u32(x392, x372, x369);
    let (x395, x396) = fiat_p384_scalar_addcarryx_u32(x394, x370, x367);
    let (x397, x398) = fiat_p384_scalar_addcarryx_u32(x396, x368, x365);
    let (x399, x400) = fiat_p384_scalar_addcarryx_u32(x398, x366, x363);
    let (x401, x402) = fiat_p384_scalar_addcarryx_u32(x400, x364, x361);
    let (x403, x404) = fiat_p384_scalar_addcarryx_u32(x402, x362, x359);
    let x405: u32 = ((x404 as u32) + x360);
    let (x406, x407) = fiat_p384_scalar_addcarryx_u32(0x0, x331, x381);
    let (x408, x409) = fiat_p384_scalar_addcarryx_u32(x407, x333, x383);
    let (x410, x411) = fiat_p384_scalar_addcarryx_u32(x409, x335, x385);
    let (x412, x413) = fiat_p384_scalar_addcarryx_u32(x411, x337, x387);
    let (x414, x415) = fiat_p384_scalar_addcarryx_u32(x413, x339, x389);
    let (x416, x417) = fiat_p384_scalar_addcarryx_u32(x415, x341, x391);
    let (x418, x419) = fiat_p384_scalar_addcarryx_u32(x417, x343, x393);
    let (x420, x421) = fiat_p384_scalar_addcarryx_u32(x419, x345, x395);
    let (x422, x423) = fiat_p384_scalar_addcarryx_u32(x421, x347, x397);
    let (x424, x425) = fiat_p384_scalar_addcarryx_u32(x423, x349, x399);
    let (x426, x427) = fiat_p384_scalar_addcarryx_u32(x425, x351, x401);
    let (x428, x429) = fiat_p384_scalar_addcarryx_u32(x427, x353, x403);
    let (x430, x431) = fiat_p384_scalar_addcarryx_u32(x429, x355, x405);
    let x432: u32 = ((x431 as u32) + (x356 as u32));
    let (x433, x434) = fiat_p384_scalar_mulx_u32(x3, (arg1[11]));
    let (x435, x436) = fiat_p384_scalar_mulx_u32(x3, (arg1[10]));
    let (x437, x438) = fiat_p384_scalar_mulx_u32(x3, (arg1[9]));
    let (x439, x440) = fiat_p384_scalar_mulx_u32(x3, (arg1[8]));
    let (x441, x442) = fiat_p384_scalar_mulx_u32(x3, (arg1[7]));
    let (x443, x444) = fiat_p384_scalar_mulx_u32(x3, (arg1[6]));
    let (x445, x446) = fiat_p384_scalar_mulx_u32(x3, (arg1[5]));
    let (x447, x448) = fiat_p384_scalar_mulx_u32(x3, (arg1[4]));
    let (x449, x450) = fiat_p384_scalar_mulx_u32(x3, (arg1[3]));
    let (x451, x452) = fiat_p384_scalar_mulx_u32(x3, (arg1[2]));
    let (x453, x454) = fiat_p384_scalar_mulx_u32(x3, (arg1[1]));
    let (x455, x456) = fiat_p384_scalar_mulx_u32(x3, (arg1[0]));
    let (x457, x458) = fiat_p384_scalar_addcarryx_u32(0x0, x456, x453);
    let (x459, x460) = fiat_p384_scalar_addcarryx_u32(x458, x454, x451);
    let (x461, x462) = fiat_p384_scalar_addcarryx_u32(x460, x452, x449);
    let (x463, x464) = fiat_p384_scalar_addcarryx_u32(x462, x450, x447);
    let (x465, x466) = fiat_p384_scalar_addcarryx_u32(x464, x448, x445);
    let (x467, x468) = fiat_p384_scalar_addcarryx_u32(x466, x446, x443);
    let (x469, x470) = fiat_p384_scalar_addcarryx_u32(x468, x444, x441);
    let (x471, x472) = fiat_p384_scalar_addcarryx_u32(x470, x442, x439);
    let (x473, x474) = fiat_p384_scalar_addcarryx_u32(x472, x440, x437);
    let (x475, x476) = fiat_p384_scalar_addcarryx_u32(x474, x438, x435);
    let (x477, x478) = fiat_p384_scalar_addcarryx_u32(x476, x436, x433);
    let x479: u32 = ((x478 as u32) + x434);
    let (x480, x481) = fiat_p384_scalar_addcarryx_u32(0x0, x408, x455);
    let (x482, x483) = fiat_p384_scalar_addcarryx_u32(x481, x410, x457);
    let (x484, x485) = fiat_p384_scalar_addcarryx_u32(x483, x412, x459);
    let (x486, x487) = fiat_p384_scalar_addcarryx_u32(x485, x414, x461);
    let (x488, x489) = fiat_p384_scalar_addcarryx_u32(x487, x416, x463);
    let (x490, x491) = fiat_p384_scalar_addcarryx_u32(x489, x418, x465);
    let (x492, x493) = fiat_p384_scalar_addcarryx_u32(x491, x420, x467);
    let (x494, x495) = fiat_p384_scalar_addcarryx_u32(x493, x422, x469);
    let (x496, x497) = fiat_p384_scalar_addcarryx_u32(x495, x424, x471);
    let (x498, x499) = fiat_p384_scalar_addcarryx_u32(x497, x426, x473);
    let (x500, x501) = fiat_p384_scalar_addcarryx_u32(x499, x428, x475);
    let (x502, x503) = fiat_p384_scalar_addcarryx_u32(x501, x430, x477);
    let (x504, x505) = fiat_p384_scalar_addcarryx_u32(x503, x432, x479);
    let (x506, x507) = fiat_p384_scalar_mulx_u32(x480, 0xe88fdc45);
    let (x508, x509) = fiat_p384_scalar_mulx_u32(x506, 0xffffffff);
    let (x510, x511) = fiat_p384_scalar_mulx_u32(x506, 0xffffffff);
    let (x512, x513) = fiat_p384_scalar_mulx_u32(x506, 0xffffffff);
    let (x514, x515) = fiat_p384_scalar_mulx_u32(x506, 0xffffffff);
    let (x516, x517) = fiat_p384_scalar_mulx_u32(x506, 0xffffffff);
    let (x518, x519) = fiat_p384_scalar_mulx_u32(x506, 0xffffffff);
    let (x520, x521) = fiat_p384_scalar_mulx_u32(x506, 0xc7634d81);
    let (x522, x523) = fiat_p384_scalar_mulx_u32(x506, 0xf4372ddf);
    let (x524, x525) = fiat_p384_scalar_mulx_u32(x506, 0x581a0db2);
    let (x526, x527) = fiat_p384_scalar_mulx_u32(x506, 0x48b0a77a);
    let (x528, x529) = fiat_p384_scalar_mulx_u32(x506, 0xecec196a);
    let (x530, x531) = fiat_p384_scalar_mulx_u32(x506, 0xccc52973);
    let (x532, x533) = fiat_p384_scalar_addcarryx_u32(0x0, x531, x528);
    let (x534, x535) = fiat_p384_scalar_addcarryx_u32(x533, x529, x526);
    let (x536, x537) = fiat_p384_scalar_addcarryx_u32(x535, x527, x524);
    let (x538, x539) = fiat_p384_scalar_addcarryx_u32(x537, x525, x522);
    let (x540, x541) = fiat_p384_scalar_addcarryx_u32(x539, x523, x520);
    let (x542, x543) = fiat_p384_scalar_addcarryx_u32(x541, x521, x518);
    let (x544, x545) = fiat_p384_scalar_addcarryx_u32(x543, x519, x516);
    let (x546, x547) = fiat_p384_scalar_addcarryx_u32(x545, x517, x514);
    let (x548, x549) = fiat_p384_scalar_addcarryx_u32(x547, x515, x512);
    let (x550, x551) = fiat_p384_scalar_addcarryx_u32(x549, x513, x510);
    let (x552, x553) = fiat_p384_scalar_addcarryx_u32(x551, x511, x508);
    let x554: u32 = ((x553 as u32) + x509);
    let (x555, x556) = fiat_p384_scalar_addcarryx_u32(0x0, x480, x530);
    let (x557, x558) = fiat_p384_scalar_addcarryx_u32(x556, x482, x532);
    let (x559, x560) = fiat_p384_scalar_addcarryx_u32(x558, x484, x534);
    let (x561, x562) = fiat_p384_scalar_addcarryx_u32(x560, x486, x536);
    let (x563, x564) = fiat_p384_scalar_addcarryx_u32(x562, x488, x538);
    let (x565, x566) = fiat_p384_scalar_addcarryx_u32(x564, x490, x540);
    let (x567, x568) = fiat_p384_scalar_addcarryx_u32(x566, x492, x542);
    let (x569, x570) = fiat_p384_scalar_addcarryx_u32(x568, x494, x544);
    let (x571, x572) = fiat_p384_scalar_addcarryx_u32(x570, x496, x546);
    let (x573, x574) = fiat_p384_scalar_addcarryx_u32(x572, x498, x548);
    let (x575, x576) = fiat_p384_scalar_addcarryx_u32(x574, x500, x550);
    let (x577, x578) = fiat_p384_scalar_addcarryx_u32(x576, x502, x552);
    let (x579, x580) = fiat_p384_scalar_addcarryx_u32(x578, x504, x554);
    let x581: u32 = ((x580 as u32) + (x505 as u32));
    let (x582, x583) = fiat_p384_scalar_mulx_u32(x4, (arg1[11]));
    let (x584, x585) = fiat_p384_scalar_mulx_u32(x4, (arg1[10]));
    let (x586, x587) = fiat_p384_scalar_mulx_u32(x4, (arg1[9]));
    let (x588, x589) = fiat_p384_scalar_mulx_u32(x4, (arg1[8]));
    let (x590, x591) = fiat_p384_scalar_mulx_u32(x4, (arg1[7]));
    let (x592, x593) = fiat_p384_scalar_mulx_u32(x4, (arg1[6]));
    let (x594, x595) = fiat_p384_scalar_mulx_u32(x4, (arg1[5]));
    let (x596, x597) = fiat_p384_scalar_mulx_u32(x4, (arg1[4]));
    let (x598, x599) = fiat_p384_scalar_mulx_u32(x4, (arg1[3]));
    let (x600, x601) = fiat_p384_scalar_mulx_u32(x4, (arg1[2]));
    let (x602, x603) = fiat_p384_scalar_mulx_u32(x4, (arg1[1]));
    let (x604, x605) = fiat_p384_scalar_mulx_u32(x4, (arg1[0]));
    let (x606, x607) = fiat_p384_scalar_addcarryx_u32(0x0, x605, x602);
    let (x608, x609) = fiat_p384_scalar_addcarryx_u32(x607, x603, x600);
    let (x610, x611) = fiat_p384_scalar_addcarryx_u32(x609, x601, x598);
    let (x612, x613) = fiat_p384_scalar_addcarryx_u32(x611, x599, x596);
    let (x614, x615) = fiat_p384_scalar_addcarryx_u32(x613, x597, x594);
    let (x616, x617) = fiat_p384_scalar_addcarryx_u32(x615, x595, x592);
    let (x618, x619) = fiat_p384_scalar_addcarryx_u32(x617, x593, x590);
    let (x620, x621) = fiat_p384_scalar_addcarryx_u32(x619, x591, x588);
    let (x622, x623) = fiat_p384_scalar_addcarryx_u32(x621, x589, x586);
    let (x624, x625) = fiat_p384_scalar_addcarryx_u32(x623, x587, x584);
    let (x626, x627) = fiat_p384_scalar_addcarryx_u32(x625, x585, x582);
    let x628: u32 = ((x627 as u32) + x583);
    let (x629, x630) = fiat_p384_scalar_addcarryx_u32(0x0, x557, x604);
    let (x631, x632) = fiat_p384_scalar_addcarryx_u32(x630, x559, x606);
    let (x633, x634) = fiat_p384_scalar_addcarryx_u32(x632, x561, x608);
    let (x635, x636) = fiat_p384_scalar_addcarryx_u32(x634, x563, x610);
    let (x637, x638) = fiat_p384_scalar_addcarryx_u32(x636, x565, x612);
    let (x639, x640) = fiat_p384_scalar_addcarryx_u32(x638, x567, x614);
    let (x641, x642) = fiat_p384_scalar_addcarryx_u32(x640, x569, x616);
    let (x643, x644) = fiat_p384_scalar_addcarryx_u32(x642, x571, x618);
    let (x645, x646) = fiat_p384_scalar_addcarryx_u32(x644, x573, x620);
    let (x647, x648) = fiat_p384_scalar_addcarryx_u32(x646, x575, x622);
    let (x649, x650) = fiat_p384_scalar_addcarryx_u32(x648, x577, x624);
    let (x651, x652) = fiat_p384_scalar_addcarryx_u32(x650, x579, x626);
    let (x653, x654) = fiat_p384_scalar_addcarryx_u32(x652, x581, x628);
    let (x655, x656) = fiat_p384_scalar_mulx_u32(x629, 0xe88fdc45);
    let (x657, x658) = fiat_p384_scalar_mulx_u32(x655, 0xffffffff);
    let (x659, x660) = fiat_p384_scalar_mulx_u32(x655, 0xffffffff);
    let (x661, x662) = fiat_p384_scalar_mulx_u32(x655, 0xffffffff);
    let (x663, x664) = fiat_p384_scalar_mulx_u32(x655, 0xffffffff);
    let (x665, x666) = fiat_p384_scalar_mulx_u32(x655, 0xffffffff);
    let (x667, x668) = fiat_p384_scalar_mulx_u32(x655, 0xffffffff);
    let (x669, x670) = fiat_p384_scalar_mulx_u32(x655, 0xc7634d81);
    let (x671, x672) = fiat_p384_scalar_mulx_u32(x655, 0xf4372ddf);
    let (x673, x674) = fiat_p384_scalar_mulx_u32(x655, 0x581a0db2);
    let (x675, x676) = fiat_p384_scalar_mulx_u32(x655, 0x48b0a77a);
    let (x677, x678) = fiat_p384_scalar_mulx_u32(x655, 0xecec196a);
    let (x679, x680) = fiat_p384_scalar_mulx_u32(x655, 0xccc52973);
    let (x681, x682) = fiat_p384_scalar_addcarryx_u32(0x0, x680, x677);
    let (x683, x684) = fiat_p384_scalar_addcarryx_u32(x682, x678, x675);
    let (x685, x686) = fiat_p384_scalar_addcarryx_u32(x684, x676, x673);
    let (x687, x688) = fiat_p384_scalar_addcarryx_u32(x686, x674, x671);
    let (x689, x690) = fiat_p384_scalar_addcarryx_u32(x688, x672, x669);
    let (x691, x692) = fiat_p384_scalar_addcarryx_u32(x690, x670, x667);
    let (x693, x694) = fiat_p384_scalar_addcarryx_u32(x692, x668, x665);
    let (x695, x696) = fiat_p384_scalar_addcarryx_u32(x694, x666, x663);
    let (x697, x698) = fiat_p384_scalar_addcarryx_u32(x696, x664, x661);
    let (x699, x700) = fiat_p384_scalar_addcarryx_u32(x698, x662, x659);
    let (x701, x702) = fiat_p384_scalar_addcarryx_u32(x700, x660, x657);
    let x703: u32 = ((x702 as u32) + x658);
    let (x704, x705) = fiat_p384_scalar_addcarryx_u32(0x0, x629, x679);
    let (x706, x707) = fiat_p384_scalar_addcarryx_u32(x705, x631, x681);
    let (x708, x709) = fiat_p384_scalar_addcarryx_u32(x707, x633, x683);
    let (x710, x711) = fiat_p384_scalar_addcarryx_u32(x709, x635, x685);
    let (x712, x713) = fiat_p384_scalar_addcarryx_u32(x711, x637, x687);
    let (x714, x715) = fiat_p384_scalar_addcarryx_u32(x713, x639, x689);
    let (x716, x717) = fiat_p384_scalar_addcarryx_u32(x715, x641, x691);
    let (x718, x719) = fiat_p384_scalar_addcarryx_u32(x717, x643, x693);
    let (x720, x721) = fiat_p384_scalar_addcarryx_u32(x719, x645, x695);
    let (x722, x723) = fiat_p384_scalar_addcarryx_u32(x721, x647, x697);
    let (x724, x725) = fiat_p384_scalar_addcarryx_u32(x723, x649, x699);
    let (x726, x727) = fiat_p384_scalar_addcarryx_u32(x725, x651, x701);
    let (x728, x729) = fiat_p384_scalar_addcarryx_u32(x727, x653, x703);
    let x730: u32 = ((x729 as u32) + (x654 as u32));
    let (x731, x732) = fiat_p384_scalar_mulx_u32(x5, (arg1[11]));
    let (x733, x734) = fiat_p384_scalar_mulx_u32(x5, (arg1[10]));
    let (x735, x736) = fiat_p384_scalar_mulx_u32(x5, (arg1[9]));
    let (x737, x738) = fiat_p384_scalar_mulx_u32(x5, (arg1[8]));
    let (x739, x740) = fiat_p384_scalar_mulx_u32(x5, (arg1[7]));
    let (x741, x742) = fiat_p384_scalar_mulx_u32(x5, (arg1[6]));
    let (x743, x744) = fiat_p384_scalar_mulx_u32(x5, (arg1[5]));
    let (x745, x746) = fiat_p384_scalar_mulx_u32(x5, (arg1[4]));
    let (x747, x748) = fiat_p384_scalar_mulx_u32(x5, (arg1[3]));
    let (x749, x750) = fiat_p384_scalar_mulx_u32(x5, (arg1[2]));
    let (x751, x752) = fiat_p384_scalar_mulx_u32(x5, (arg1[1]));
    let (x753, x754) = fiat_p384_scalar_mulx_u32(x5, (arg1[0]));
    let (x755, x756) = fiat_p384_scalar_addcarryx_u32(0x0, x754, x751);
    let (x757, x758) = fiat_p384_scalar_addcarryx_u32(x756, x752, x749);
    let (x759, x760) = fiat_p384_scalar_addcarryx_u32(x758, x750, x747);
    let (x761, x762) = fiat_p384_scalar_addcarryx_u32(x760, x748, x745);
    let (x763, x764) = fiat_p384_scalar_addcarryx_u32(x762, x746, x743);
    let (x765, x766) = fiat_p384_scalar_addcarryx_u32(x764, x744, x741);
    let (x767, x768) = fiat_p384_scalar_addcarryx_u32(x766, x742, x739);
    let (x769, x770) = fiat_p384_scalar_addcarryx_u32(x768, x740, x737);
    let (x771, x772) = fiat_p384_scalar_addcarryx_u32(x770, x738, x735);
    let (x773, x774) = fiat_p384_scalar_addcarryx_u32(x772, x736, x733);
    let (x775, x776) = fiat_p384_scalar_addcarryx_u32(x774, x734, x731);
    let x777: u32 = ((x776 as u32) + x732);
    let (x778, x779) = fiat_p384_scalar_addcarryx_u32(0x0, x706, x753);
    let (x780, x781) = fiat_p384_scalar_addcarryx_u32(x779, x708, x755);
    let (x782, x783) = fiat_p384_scalar_addcarryx_u32(x781, x710, x757);
    let (x784, x785) = fiat_p384_scalar_addcarryx_u32(x783, x712, x759);
    let (x786, x787) = fiat_p384_scalar_addcarryx_u32(x785, x714, x761);
    let (x788, x789) = fiat_p384_scalar_addcarryx_u32(x787, x716, x763);
    let (x790, x791) = fiat_p384_scalar_addcarryx_u32(x789, x718, x765);
    let (x792, x793) = fiat_p384_scalar_addcarryx_u32(x791, x720, x767);
    let (x794, x795) = fiat_p384_scalar_addcarryx_u32(x793, x722, x769);
    let (x796, x797) = fiat_p384_scalar_addcarryx_u32(x795, x724, x771);
    let (x798, x799) = fiat_p384_scalar_addcarryx_u32(x797, x726, x773);
    let (x800, x801) = fiat_p384_scalar_addcarryx_u32(x799, x728, x775);
    let (x802, x803) = fiat_p384_scalar_addcarryx_u32(x801, x730, x777);
    let (x804, x805) = fiat_p384_scalar_mulx_u32(x778, 0xe88fdc45);
    let (x806, x807) = fiat_p384_scalar_mulx_u32(x804, 0xffffffff);
    let (x808, x809) = fiat_p384_scalar_mulx_u32(x804, 0xffffffff);
    let (x810, x811) = fiat_p384_scalar_mulx_u32(x804, 0xffffffff);
    let (x812, x813) = fiat_p384_scalar_mulx_u32(x804, 0xffffffff);
    let (x814, x815) = fiat_p384_scalar_mulx_u32(x804, 0xffffffff);
    let (x816, x817) = fiat_p384_scalar_mulx_u32(x804, 0xffffffff);
    let (x818, x819) = fiat_p384_scalar_mulx_u32(x804, 0xc7634d81);
    let (x820, x821) = fiat_p384_scalar_mulx_u32(x804, 0xf4372ddf);
    let (x822, x823) = fiat_p384_scalar_mulx_u32(x804, 0x581a0db2);
    let (x824, x825) = fiat_p384_scalar_mulx_u32(x804, 0x48b0a77a);
    let (x826, x827) = fiat_p384_scalar_mulx_u32(x804, 0xecec196a);
    let (x828, x829) = fiat_p384_scalar_mulx_u32(x804, 0xccc52973);
    let (x830, x831) = fiat_p384_scalar_addcarryx_u32(0x0, x829, x826);
    let (x832, x833) = fiat_p384_scalar_addcarryx_u32(x831, x827, x824);
    let (x834, x835) = fiat_p384_scalar_addcarryx_u32(x833, x825, x822);
    let (x836, x837) = fiat_p384_scalar_addcarryx_u32(x835, x823, x820);
    let (x838, x839) = fiat_p384_scalar_addcarryx_u32(x837, x821, x818);
    let (x840, x841) = fiat_p384_scalar_addcarryx_u32(x839, x819, x816);
    let (x842, x843) = fiat_p384_scalar_addcarryx_u32(x841, x817, x814);
    let (x844, x845) = fiat_p384_scalar_addcarryx_u32(x843, x815, x812);
    let (x846, x847) = fiat_p384_scalar_addcarryx_u32(x845, x813, x810);
    let (x848, x849) = fiat_p384_scalar_addcarryx_u32(x847, x811, x808);
    let (x850, x851) = fiat_p384_scalar_addcarryx_u32(x849, x809, x806);
    let x852: u32 = ((x851 as u32) + x807);
    let (x853, x854) = fiat_p384_scalar_addcarryx_u32(0x0, x778, x828);
    let (x855, x856) = fiat_p384_scalar_addcarryx_u32(x854, x780, x830);
    let (x857, x858) = fiat_p384_scalar_addcarryx_u32(x856, x782, x832);
    let (x859, x860) = fiat_p384_scalar_addcarryx_u32(x858, x784, x834);
    let (x861, x862) = fiat_p384_scalar_addcarryx_u32(x860, x786, x836);
    let (x863, x864) = fiat_p384_scalar_addcarryx_u32(x862, x788, x838);
    let (x865, x866) = fiat_p384_scalar_addcarryx_u32(x864, x790, x840);
    let (x867, x868) = fiat_p384_scalar_addcarryx_u32(x866, x792, x842);
    let (x869, x870) = fiat_p384_scalar_addcarryx_u32(x868, x794, x844);
    let (x871, x872) = fiat_p384_scalar_addcarryx_u32(x870, x796, x846);
    let (x873, x874) = fiat_p384_scalar_addcarryx_u32(x872, x798, x848);
    let (x875, x876) = fiat_p384_scalar_addcarryx_u32(x874, x800, x850);
    let (x877, x878) = fiat_p384_scalar_addcarryx_u32(x876, x802, x852);
    let x879: u32 = ((x878 as u32) + (x803 as u32));
    let (x880, x881) = fiat_p384_scalar_mulx_u32(x6, (arg1[11]));
    let (x882, x883) = fiat_p384_scalar_mulx_u32(x6, (arg1[10]));
    let (x884, x885) = fiat_p384_scalar_mulx_u32(x6, (arg1[9]));
    let (x886, x887) = fiat_p384_scalar_mulx_u32(x6, (arg1[8]));
    let (x888, x889) = fiat_p384_scalar_mulx_u32(x6, (arg1[7]));
    let (x890, x891) = fiat_p384_scalar_mulx_u32(x6, (arg1[6]));
    let (x892, x893) = fiat_p384_scalar_mulx_u32(x6, (arg1[5]));
    let (x894, x895) = fiat_p384_scalar_mulx_u32(x6, (arg1[4]));
    let (x896, x897) = fiat_p384_scalar_mulx_u32(x6, (arg1[3]));
    let (x898, x899) = fiat_p384_scalar_mulx_u32(x6, (arg1[2]));
    let (x900, x901) = fiat_p384_scalar_mulx_u32(x6, (arg1[1]));
    let (x902, x903) = fiat_p384_scalar_mulx_u32(x6, (arg1[0]));
    let (x904, x905) = fiat_p384_scalar_addcarryx_u32(0x0, x903, x900);
    let (x906, x907) = fiat_p384_scalar_addcarryx_u32(x905, x901, x898);
    let (x908, x909) = fiat_p384_scalar_addcarryx_u32(x907, x899, x896);
    let (x910, x911) = fiat_p384_scalar_addcarryx_u32(x909, x897, x894);
    let (x912, x913) = fiat_p384_scalar_addcarryx_u32(x911, x895, x892);
    let (x914, x915) = fiat_p384_scalar_addcarryx_u32(x913, x893, x890);
    let (x916, x917) = fiat_p384_scalar_addcarryx_u32(x915, x891, x888);
    let (x918, x919) = fiat_p384_scalar_addcarryx_u32(x917, x889, x886);
    let (x920, x921) = fiat_p384_scalar_addcarryx_u32(x919, x887, x884);
    let (x922, x923) = fiat_p384_scalar_addcarryx_u32(x921, x885, x882);
    let (x924, x925) = fiat_p384_scalar_addcarryx_u32(x923, x883, x880);
    let x926: u32 = ((x925 as u32) + x881);
    let (x927, x928) = fiat_p384_scalar_addcarryx_u32(0x0, x855, x902);
    let (x929, x930) = fiat_p384_scalar_addcarryx_u32(x928, x857, x904);
    let (x931, x932) = fiat_p384_scalar_addcarryx_u32(x930, x859, x906);
    let (x933, x934) = fiat_p384_scalar_addcarryx_u32(x932, x861, x908);
    let (x935, x936) = fiat_p384_scalar_addcarryx_u32(x934, x863, x910);
    let (x937, x938) = fiat_p384_scalar_addcarryx_u32(x936, x865, x912);
    let (x939, x940) = fiat_p384_scalar_addcarryx_u32(x938, x867, x914);
    let (x941, x942) = fiat_p384_scalar_addcarryx_u32(x940, x869, x916);
    let (x943, x944) = fiat_p384_scalar_addcarryx_u32(x942, x871, x918);
    let (x945, x946) = fiat_p384_scalar_addcarryx_u32(x944, x873, x920);
    let (x947, x948) = fiat_p384_scalar_addcarryx_u32(x946, x875, x922);
    let (x949, x950) = fiat_p384_scalar_addcarryx_u32(x948, x877, x924);
    let (x951, x952) = fiat_p384_scalar_addcarryx_u32(x950, x879, x926);
    let (x953, x954) = fiat_p384_scalar_mulx_u32(x927, 0xe88fdc45);
    let (x955, x956) = fiat_p384_scalar_mulx_u32(x953, 0xffffffff);
    let (x957, x958) = fiat_p384_scalar_mulx_u32(x953, 0xffffffff);
    let (x959, x960) = fiat_p384_scalar_mulx_u32(x953, 0xffffffff);
    let (x961, x962) = fiat_p384_scalar_mulx_u32(x953, 0xffffffff);
    let (x963, x964) = fiat_p384_scalar_mulx_u32(x953, 0xffffffff);
    let (x965, x966) = fiat_p384_scalar_mulx_u32(x953, 0xffffffff);
    let (x967, x968) = fiat_p384_scalar_mulx_u32(x953, 0xc7634d81);
    let (x969, x970) = fiat_p384_scalar_mulx_u32(x953, 0xf4372ddf);
    let (x971, x972) = fiat_p384_scalar_mulx_u32(x953, 0x581a0db2);
    let (x973, x974) = fiat_p384_scalar_mulx_u32(x953, 0x48b0a77a);
    let (x975, x976) = fiat_p384_scalar_mulx_u32(x953, 0xecec196a);
    let (x977, x978) = fiat_p384_scalar_mulx_u32(x953, 0xccc52973);
    let (x979, x980) = fiat_p384_scalar_addcarryx_u32(0x0, x978, x975);
    let (x981, x982) = fiat_p384_scalar_addcarryx_u32(x980, x976, x973);
    let (x983, x984) = fiat_p384_scalar_addcarryx_u32(x982, x974, x971);
    let (x985, x986) = fiat_p384_scalar_addcarryx_u32(x984, x972, x969);
    let (x987, x988) = fiat_p384_scalar_addcarryx_u32(x986, x970, x967);
    let (x989, x990) = fiat_p384_scalar_addcarryx_u32(x988, x968, x965);
    let (x991, x992) = fiat_p384_scalar_addcarryx_u32(x990, x966, x963);
    let (x993, x994) = fiat_p384_scalar_addcarryx_u32(x992, x964, x961);
    let (x995, x996) = fiat_p384_scalar_addcarryx_u32(x994, x962, x959);
    let (x997, x998) = fiat_p384_scalar_addcarryx_u32(x996, x960, x957);
    let (x999, x1000) = fiat_p384_scalar_addcarryx_u32(x998, x958, x955);
    let x1001: u32 = ((x1000 as u32) + x956);
    let (x1002, x1003) = fiat_p384_scalar_addcarryx_u32(0x0, x927, x977);
    let (x1004, x1005) = fiat_p384_scalar_addcarryx_u32(x1003, x929, x979);
    let (x1006, x1007) = fiat_p384_scalar_addcarryx_u32(x1005, x931, x981);
    let (x1008, x1009) = fiat_p384_scalar_addcarryx_u32(x1007, x933, x983);
    let (x1010, x1011) = fiat_p384_scalar_addcarryx_u32(x1009, x935, x985);
    let (x1012, x1013) = fiat_p384_scalar_addcarryx_u32(x1011, x937, x987);
    let (x1014, x1015) = fiat_p384_scalar_addcarryx_u32(x1013, x939, x989);
    let (x1016, x1017) = fiat_p384_scalar_addcarryx_u32(x1015, x941, x991);
    let (x1018, x1019) = fiat_p384_scalar_addcarryx_u32(x1017, x943, x993);
    let (x1020, x1021) = fiat_p384_scalar_addcarryx_u32(x1019, x945, x995);
    let (x1022, x1023) = fiat_p384_scalar_addcarryx_u32(x1021, x947, x997);
    let (x1024, x1025) = fiat_p384_scalar_addcarryx_u32(x1023, x949, x999);
    let (x1026, x1027) = fiat_p384_scalar_addcarryx_u32(x1025, x951, x1001);
    let x1028: u32 = ((x1027 as u32) + (x952 as u32));
    let (x1029, x1030) = fiat_p384_scalar_mulx_u32(x7, (arg1[11]));
    let (x1031, x1032) = fiat_p384_scalar_mulx_u32(x7, (arg1[10]));
    let (x1033, x1034) = fiat_p384_scalar_mulx_u32(x7, (arg1[9]));
    let (x1035, x1036) = fiat_p384_scalar_mulx_u32(x7, (arg1[8]));
    let (x1037, x1038) = fiat_p384_scalar_mulx_u32(x7, (arg1[7]));
    let (x1039, x1040) = fiat_p384_scalar_mulx_u32(x7, (arg1[6]));
    let (x1041, x1042) = fiat_p384_scalar_mulx_u32(x7, (arg1[5]));
    let (x1043, x1044) = fiat_p384_scalar_mulx_u32(x7, (arg1[4]));
    let (x1045, x1046) = fiat_p384_scalar_mulx_u32(x7, (arg1[3]));
    let (x1047, x1048) = fiat_p384_scalar_mulx_u32(x7, (arg1[2]));
    let (x1049, x1050) = fiat_p384_scalar_mulx_u32(x7, (arg1[1]));
    let (x1051, x1052) = fiat_p384_scalar_mulx_u32(x7, (arg1[0]));
    let (x1053, x1054) = fiat_p384_scalar_addcarryx_u32(0x0, x1052, x1049);
    let (x1055, x1056) = fiat_p384_scalar_addcarryx_u32(x1054, x1050, x1047);
    let (x1057, x1058) = fiat_p384_scalar_addcarryx_u32(x1056, x1048, x1045);
    let (x1059, x1060) = fiat_p384_scalar_addcarryx_u32(x1058, x1046, x1043);
    let (x1061, x1062) = fiat_p384_scalar_addcarryx_u32(x1060, x1044, x1041);
    let (x1063, x1064) = fiat_p384_scalar_addcarryx_u32(x1062, x1042, x1039);
    let (x1065, x1066) = fiat_p384_scalar_addcarryx_u32(x1064, x1040, x1037);
    let (x1067, x1068) = fiat_p384_scalar_addcarryx_u32(x1066, x1038, x1035);
    let (x1069, x1070) = fiat_p384_scalar_addcarryx_u32(x1068, x1036, x1033);
    let (x1071, x1072) = fiat_p384_scalar_addcarryx_u32(x1070, x1034, x1031);
    let (x1073, x1074) = fiat_p384_scalar_addcarryx_u32(x1072, x1032, x1029);
    let x1075: u32 = ((x1074 as u32) + x1030);
    let (x1076, x1077) = fiat_p384_scalar_addcarryx_u32(0x0, x1004, x1051);
    let (x1078, x1079) = fiat_p384_scalar_addcarryx_u32(x1077, x1006, x1053);
    let (x1080, x1081) = fiat_p384_scalar_addcarryx_u32(x1079, x1008, x1055);
    let (x1082, x1083) = fiat_p384_scalar_addcarryx_u32(x1081, x1010, x1057);
    let (x1084, x1085) = fiat_p384_scalar_addcarryx_u32(x1083, x1012, x1059);
    let (x1086, x1087) = fiat_p384_scalar_addcarryx_u32(x1085, x1014, x1061);
    let (x1088, x1089) = fiat_p384_scalar_addcarryx_u32(x1087, x1016, x1063);
    let (x1090, x1091) = fiat_p384_scalar_addcarryx_u32(x1089, x1018, x1065);
    let (x1092, x1093) = fiat_p384_scalar_addcarryx_u32(x1091, x1020, x1067);
    let (x1094, x1095) = fiat_p384_scalar_addcarryx_u32(x1093, x1022, x1069);
    let (x1096, x1097) = fiat_p384_scalar_addcarryx_u32(x1095, x1024, x1071);
    let (x1098, x1099) = fiat_p384_scalar_addcarryx_u32(x1097, x1026, x1073);
    let (x1100, x1101) = fiat_p384_scalar_addcarryx_u32(x1099, x1028, x1075);
    let (x1102, x1103) = fiat_p384_scalar_mulx_u32(x1076, 0xe88fdc45);
    let (x1104, x1105) = fiat_p384_scalar_mulx_u32(x1102, 0xffffffff);
    let (x1106, x1107) = fiat_p384_scalar_mulx_u32(x1102, 0xffffffff);
    let (x1108, x1109) = fiat_p384_scalar_mulx_u32(x1102, 0xffffffff);
    let (x1110, x1111) = fiat_p384_scalar_mulx_u32(x1102, 0xffffffff);
    let (x1112, x1113) = fiat_p384_scalar_mulx_u32(x1102, 0xffffffff);
    let (x1114, x1115) = fiat_p384_scalar_mulx_u32(x1102, 0xffffffff);
    let (x1116, x1117) = fiat_p384_scalar_mulx_u32(x1102, 0xc7634d81);
    let (x1118, x1119) = fiat_p384_scalar_mulx_u32(x1102, 0xf4372ddf);
    let (x1120, x1121) = fiat_p384_scalar_mulx_u32(x1102, 0x581a0db2);
    let (x1122, x1123) = fiat_p384_scalar_mulx_u32(x1102, 0x48b0a77a);
    let (x1124, x1125) = fiat_p384_scalar_mulx_u32(x1102, 0xecec196a);
    let (x1126, x1127) = fiat_p384_scalar_mulx_u32(x1102, 0xccc52973);
    let (x1128, x1129) = fiat_p384_scalar_addcarryx_u32(0x0, x1127, x1124);
    let (x1130, x1131) = fiat_p384_scalar_addcarryx_u32(x1129, x1125, x1122);
    let (x1132, x1133) = fiat_p384_scalar_addcarryx_u32(x1131, x1123, x1120);
    let (x1134, x1135) = fiat_p384_scalar_addcarryx_u32(x1133, x1121, x1118);
    let (x1136, x1137) = fiat_p384_scalar_addcarryx_u32(x1135, x1119, x1116);
    let (x1138, x1139) = fiat_p384_scalar_addcarryx_u32(x1137, x1117, x1114);
    let (x1140, x1141) = fiat_p384_scalar_addcarryx_u32(x1139, x1115, x1112);
    let (x1142, x1143) = fiat_p384_scalar_addcarryx_u32(x1141, x1113, x1110);
    let (x1144, x1145) = fiat_p384_scalar_addcarryx_u32(x1143, x1111, x1108);
    let (x1146, x1147) = fiat_p384_scalar_addcarryx_u32(x1145, x1109, x1106);
    let (x1148, x1149) = fiat_p384_scalar_addcarryx_u32(x1147, x1107, x1104);
    let x1150: u32 = ((x1149 as u32) + x1105);
    let (x1151, x1152) = fiat_p384_scalar_addcarryx_u32(0x0, x1076, x1126);
    let (x1153, x1154) = fiat_p384_scalar_addcarryx_u32(x1152, x1078, x1128);
    let (x1155, x1156) = fiat_p384_scalar_addcarryx_u32(x1154, x1080, x1130);
    let (x1157, x1158) = fiat_p384_scalar_addcarryx_u32(x1156, x1082, x1132);
    let (x1159, x1160) = fiat_p384_scalar_addcarryx_u32(x1158, x1084, x1134);
    let (x1161, x1162) = fiat_p384_scalar_addcarryx_u32(x1160, x1086, x1136);
    let (x1163, x1164) = fiat_p384_scalar_addcarryx_u32(x1162, x1088, x1138);
    let (x1165, x1166) = fiat_p384_scalar_addcarryx_u32(x1164, x1090, x1140);
    let (x1167, x1168) = fiat_p384_scalar_addcarryx_u32(x1166, x1092, x1142);
    let (x1169, x1170) = fiat_p384_scalar_addcarryx_u32(x1168, x1094, x1144);
    let (x1171, x1172) = fiat_p384_scalar_addcarryx_u32(x1170, x1096, x1146);
    let (x1173, x1174) = fiat_p384_scalar_addcarryx_u32(x1172, x1098, x1148);
    let (x1175, x1176) = fiat_p384_scalar_addcarryx_u32(x1174, x1100, x1150);
    let x1177: u32 = ((x1176 as u32) + (x1101 as u32));
    let (x1178, x1179) = fiat_p384_scalar_mulx_u32(x8, (arg1[11]));
    let (x1180, x1181) = fiat_p384_scalar_mulx_u32(x8, (arg1[10]));
    let (x1182, x1183) = fiat_p384_scalar_mulx_u32(x8, (arg1[9]));
    let (x1184, x1185) = fiat_p384_scalar_mulx_u32(x8, (arg1[8]));
    let (x1186, x1187) = fiat_p384_scalar_mulx_u32(x8, (arg1[7]));
    let (x1188, x1189) = fiat_p384_scalar_mulx_u32(x8, (arg1[6]));
    let (x1190, x1191) = fiat_p384_scalar_mulx_u32(x8, (arg1[5]));
    let (x1192, x1193) = fiat_p384_scalar_mulx_u32(x8, (arg1[4]));
    let (x1194, x1195) = fiat_p384_scalar_mulx_u32(x8, (arg1[3]));
    let (x1196, x1197) = fiat_p384_scalar_mulx_u32(x8, (arg1[2]));
    let (x1198, x1199) = fiat_p384_scalar_mulx_u32(x8, (arg1[1]));
    let (x1200, x1201) = fiat_p384_scalar_mulx_u32(x8, (arg1[0]));
    let (x1202, x1203) = fiat_p384_scalar_addcarryx_u32(0x0, x1201, x1198);
    let (x1204, x1205) = fiat_p384_scalar_addcarryx_u32(x1203, x1199, x1196);
    let (x1206, x1207) = fiat_p384_scalar_addcarryx_u32(x1205, x1197, x1194);
    let (x1208, x1209) = fiat_p384_scalar_addcarryx_u32(x1207, x1195, x1192);
    let (x1210, x1211) = fiat_p384_scalar_addcarryx_u32(x1209, x1193, x1190);
    let (x1212, x1213) = fiat_p384_scalar_addcarryx_u32(x1211, x1191, x1188);
    let (x1214, x1215) = fiat_p384_scalar_addcarryx_u32(x1213, x1189, x1186);
    let (x1216, x1217) = fiat_p384_scalar_addcarryx_u32(x1215, x1187, x1184);
    let (x1218, x1219) = fiat_p384_scalar_addcarryx_u32(x1217, x1185, x1182);
    let (x1220, x1221) = fiat_p384_scalar_addcarryx_u32(x1219, x1183, x1180);
    let (x1222, x1223) = fiat_p384_scalar_addcarryx_u32(x1221, x1181, x1178);
    let x1224: u32 = ((x1223 as u32) + x1179);
    let (x1225, x1226) = fiat_p384_scalar_addcarryx_u32(0x0, x1153, x1200);
    let (x1227, x1228) = fiat_p384_scalar_addcarryx_u32(x1226, x1155, x1202);
    let (x1229, x1230) = fiat_p384_scalar_addcarryx_u32(x1228, x1157, x1204);
    let (x1231, x1232) = fiat_p384_scalar_addcarryx_u32(x1230, x1159, x1206);
    let (x1233, x1234) = fiat_p384_scalar_addcarryx_u32(x1232, x1161, x1208);
    let (x1235, x1236) = fiat_p384_scalar_addcarryx_u32(x1234, x1163, x1210);
    let (x1237, x1238) = fiat_p384_scalar_addcarryx_u32(x1236, x1165, x1212);
    let (x1239, x1240) = fiat_p384_scalar_addcarryx_u32(x1238, x1167, x1214);
    let (x1241, x1242) = fiat_p384_scalar_addcarryx_u32(x1240, x1169, x1216);
    let (x1243, x1244) = fiat_p384_scalar_addcarryx_u32(x1242, x1171, x1218);
    let (x1245, x1246) = fiat_p384_scalar_addcarryx_u32(x1244, x1173, x1220);
    let (x1247, x1248) = fiat_p384_scalar_addcarryx_u32(x1246, x1175, x1222);
    let (x1249, x1250) = fiat_p384_scalar_addcarryx_u32(x1248, x1177, x1224);
    let (x1251, x1252) = fiat_p384_scalar_mulx_u32(x1225, 0xe88fdc45);
    let (x1253, x1254) = fiat_p384_scalar_mulx_u32(x1251, 0xffffffff);
    let (x1255, x1256) = fiat_p384_scalar_mulx_u32(x1251, 0xffffffff);
    let (x1257, x1258) = fiat_p384_scalar_mulx_u32(x1251, 0xffffffff);
    let (x1259, x1260) = fiat_p384_scalar_mulx_u32(x1251, 0xffffffff);
    let (x1261, x1262) = fiat_p384_scalar_mulx_u32(x1251, 0xffffffff);
    let (x1263, x1264) = fiat_p384_scalar_mulx_u32(x1251, 0xffffffff);
    let (x1265, x1266) = fiat_p384_scalar_mulx_u32(x1251, 0xc7634d81);
    let (x1267, x1268) = fiat_p384_scalar_mulx_u32(x1251, 0xf4372ddf);
    let (x1269, x1270) = fiat_p384_scalar_mulx_u32(x1251, 0x581a0db2);
    let (x1271, x1272) = fiat_p384_scalar_mulx_u32(x1251, 0x48b0a77a);
    let (x1273, x1274) = fiat_p384_scalar_mulx_u32(x1251, 0xecec196a);
    let (x1275, x1276) = fiat_p384_scalar_mulx_u32(x1251, 0xccc52973);
    let (x1277, x1278) = fiat_p384_scalar_addcarryx_u32(0x0, x1276, x1273);
    let (x1279, x1280) = fiat_p384_scalar_addcarryx_u32(x1278, x1274, x1271);
    let (x1281, x1282) = fiat_p384_scalar_addcarryx_u32(x1280, x1272, x1269);
    let (x1283, x1284) = fiat_p384_scalar_addcarryx_u32(x1282, x1270, x1267);
    let (x1285, x1286) = fiat_p384_scalar_addcarryx_u32(x1284, x1268, x1265);
    let (x1287, x1288) = fiat_p384_scalar_addcarryx_u32(x1286, x1266, x1263);
    let (x1289, x1290) = fiat_p384_scalar_addcarryx_u32(x1288, x1264, x1261);
    let (x1291, x1292) = fiat_p384_scalar_addcarryx_u32(x1290, x1262, x1259);
    let (x1293, x1294) = fiat_p384_scalar_addcarryx_u32(x1292, x1260, x1257);
    let (x1295, x1296) = fiat_p384_scalar_addcarryx_u32(x1294, x1258, x1255);
    let (x1297, x1298) = fiat_p384_scalar_addcarryx_u32(x1296, x1256, x1253);
    let x1299: u32 = ((x1298 as u32) + x1254);
    let (x1300, x1301) = fiat_p384_scalar_addcarryx_u32(0x0, x1225, x1275);
    let (x1302, x1303) = fiat_p384_scalar_addcarryx_u32(x1301, x1227, x1277);
    let (x1304, x1305) = fiat_p384_scalar_addcarryx_u32(x1303, x1229, x1279);
    let (x1306, x1307) = fiat_p384_scalar_addcarryx_u32(x1305, x1231, x1281);
    let (x1308, x1309) = fiat_p384_scalar_addcarryx_u32(x1307, x1233, x1283);
    let (x1310, x1311) = fiat_p384_scalar_addcarryx_u32(x1309, x1235, x1285);
    let (x1312, x1313) = fiat_p384_scalar_addcarryx_u32(x1311, x1237, x1287);
    let (x1314, x1315) = fiat_p384_scalar_addcarryx_u32(x1313, x1239, x1289);
    let (x1316, x1317) = fiat_p384_scalar_addcarryx_u32(x1315, x1241, x1291);
    let (x1318, x1319) = fiat_p384_scalar_addcarryx_u32(x1317, x1243, x1293);
    let (x1320, x1321) = fiat_p384_scalar_addcarryx_u32(x1319, x1245, x1295);
    let (x1322, x1323) = fiat_p384_scalar_addcarryx_u32(x1321, x1247, x1297);
    let (x1324, x1325) = fiat_p384_scalar_addcarryx_u32(x1323, x1249, x1299);
    let x1326: u32 = ((x1325 as u32) + (x1250 as u32));
    let (x1327, x1328) = fiat_p384_scalar_mulx_u32(x9, (arg1[11]));
    let (x1329, x1330) = fiat_p384_scalar_mulx_u32(x9, (arg1[10]));
    let (x1331, x1332) = fiat_p384_scalar_mulx_u32(x9, (arg1[9]));
    let (x1333, x1334) = fiat_p384_scalar_mulx_u32(x9, (arg1[8]));
    let (x1335, x1336) = fiat_p384_scalar_mulx_u32(x9, (arg1[7]));
    let (x1337, x1338) = fiat_p384_scalar_mulx_u32(x9, (arg1[6]));
    let (x1339, x1340) = fiat_p384_scalar_mulx_u32(x9, (arg1[5]));
    let (x1341, x1342) = fiat_p384_scalar_mulx_u32(x9, (arg1[4]));
    let (x1343, x1344) = fiat_p384_scalar_mulx_u32(x9, (arg1[3]));
    let (x1345, x1346) = fiat_p384_scalar_mulx_u32(x9, (arg1[2]));
    let (x1347, x1348) = fiat_p384_scalar_mulx_u32(x9, (arg1[1]));
    let (x1349, x1350) = fiat_p384_scalar_mulx_u32(x9, (arg1[0]));
    let (x1351, x1352) = fiat_p384_scalar_addcarryx_u32(0x0, x1350, x1347);
    let (x1353, x1354) = fiat_p384_scalar_addcarryx_u32(x1352, x1348, x1345);
    let (x1355, x1356) = fiat_p384_scalar_addcarryx_u32(x1354, x1346, x1343);
    let (x1357, x1358) = fiat_p384_scalar_addcarryx_u32(x1356, x1344, x1341);
    let (x1359, x1360) = fiat_p384_scalar_addcarryx_u32(x1358, x1342, x1339);
    let (x1361, x1362) = fiat_p384_scalar_addcarryx_u32(x1360, x1340, x1337);
    let (x1363, x1364) = fiat_p384_scalar_addcarryx_u32(x1362, x1338, x1335);
    let (x1365, x1366) = fiat_p384_scalar_addcarryx_u32(x1364, x1336, x1333);
    let (x1367, x1368) = fiat_p384_scalar_addcarryx_u32(x1366, x1334, x1331);
    let (x1369, x1370) = fiat_p384_scalar_addcarryx_u32(x1368, x1332, x1329);
    let (x1371, x1372) = fiat_p384_scalar_addcarryx_u32(x1370, x1330, x1327);
    let x1373: u32 = ((x1372 as u32) + x1328);
    let (x1374, x1375) = fiat_p384_scalar_addcarryx_u32(0x0, x1302, x1349);
    let (x1376, x1377) = fiat_p384_scalar_addcarryx_u32(x1375, x1304, x1351);
    let (x1378, x1379) = fiat_p384_scalar_addcarryx_u32(x1377, x1306, x1353);
    let (x1380, x1381) = fiat_p384_scalar_addcarryx_u32(x1379, x1308, x1355);
    let (x1382, x1383) = fiat_p384_scalar_addcarryx_u32(x1381, x1310, x1357);
    let (x1384, x1385) = fiat_p384_scalar_addcarryx_u32(x1383, x1312, x1359);
    let (x1386, x1387) = fiat_p384_scalar_addcarryx_u32(x1385, x1314, x1361);
    let (x1388, x1389) = fiat_p384_scalar_addcarryx_u32(x1387, x1316, x1363);
    let (x1390, x1391) = fiat_p384_scalar_addcarryx_u32(x1389, x1318, x1365);
    let (x1392, x1393) = fiat_p384_scalar_addcarryx_u32(x1391, x1320, x1367);
    let (x1394, x1395) = fiat_p384_scalar_addcarryx_u32(x1393, x1322, x1369);
    let (x1396, x1397) = fiat_p384_scalar_addcarryx_u32(x1395, x1324, x1371);
    let (x1398, x1399) = fiat_p384_scalar_addcarryx_u32(x1397, x1326, x1373);
    let (x1400, x1401) = fiat_p384_scalar_mulx_u32(x1374, 0xe88fdc45);
    let (x1402, x1403) = fiat_p384_scalar_mulx_u32(x1400, 0xffffffff);
    let (x1404, x1405) = fiat_p384_scalar_mulx_u32(x1400, 0xffffffff);
    let (x1406, x1407) = fiat_p384_scalar_mulx_u32(x1400, 0xffffffff);
    let (x1408, x1409) = fiat_p384_scalar_mulx_u32(x1400, 0xffffffff);
    let (x1410, x1411) = fiat_p384_scalar_mulx_u32(x1400, 0xffffffff);
    let (x1412, x1413) = fiat_p384_scalar_mulx_u32(x1400, 0xffffffff);
    let (x1414, x1415) = fiat_p384_scalar_mulx_u32(x1400, 0xc7634d81);
    let (x1416, x1417) = fiat_p384_scalar_mulx_u32(x1400, 0xf4372ddf);
    let (x1418, x1419) = fiat_p384_scalar_mulx_u32(x1400, 0x581a0db2);
    let (x1420, x1421) = fiat_p384_scalar_mulx_u32(x1400, 0x48b0a77a);
    let (x1422, x1423) = fiat_p384_scalar_mulx_u32(x1400, 0xecec196a);
    let (x1424, x1425) = fiat_p384_scalar_mulx_u32(x1400, 0xccc52973);
    let (x1426, x1427) = fiat_p384_scalar_addcarryx_u32(0x0, x1425, x1422);
    let (x1428, x1429) = fiat_p384_scalar_addcarryx_u32(x1427, x1423, x1420);
    let (x1430, x1431) = fiat_p384_scalar_addcarryx_u32(x1429, x1421, x1418);
    let (x1432, x1433) = fiat_p384_scalar_addcarryx_u32(x1431, x1419, x1416);
    let (x1434, x1435) = fiat_p384_scalar_addcarryx_u32(x1433, x1417, x1414);
    let (x1436, x1437) = fiat_p384_scalar_addcarryx_u32(x1435, x1415, x1412);
    let (x1438, x1439) = fiat_p384_scalar_addcarryx_u32(x1437, x1413, x1410);
    let (x1440, x1441) = fiat_p384_scalar_addcarryx_u32(x1439, x1411, x1408);
    let (x1442, x1443) = fiat_p384_scalar_addcarryx_u32(x1441, x1409, x1406);
    let (x1444, x1445) = fiat_p384_scalar_addcarryx_u32(x1443, x1407, x1404);
    let (x1446, x1447) = fiat_p384_scalar_addcarryx_u32(x1445, x1405, x1402);
    let x1448: u32 = ((x1447 as u32) + x1403);
    let (x1449, x1450) = fiat_p384_scalar_addcarryx_u32(0x0, x1374, x1424);
    let (x1451, x1452) = fiat_p384_scalar_addcarryx_u32(x1450, x1376, x1426);
    let (x1453, x1454) = fiat_p384_scalar_addcarryx_u32(x1452, x1378, x1428);
    let (x1455, x1456) = fiat_p384_scalar_addcarryx_u32(x1454, x1380, x1430);
    let (x1457, x1458) = fiat_p384_scalar_addcarryx_u32(x1456, x1382, x1432);
    let (x1459, x1460) = fiat_p384_scalar_addcarryx_u32(x1458, x1384, x1434);
    let (x1461, x1462) = fiat_p384_scalar_addcarryx_u32(x1460, x1386, x1436);
    let (x1463, x1464) = fiat_p384_scalar_addcarryx_u32(x1462, x1388, x1438);
    let (x1465, x1466) = fiat_p384_scalar_addcarryx_u32(x1464, x1390, x1440);
    let (x1467, x1468) = fiat_p384_scalar_addcarryx_u32(x1466, x1392, x1442);
    let (x1469, x1470) = fiat_p384_scalar_addcarryx_u32(x1468, x1394, x1444);
    let (x1471, x1472) = fiat_p384_scalar_addcarryx_u32(x1470, x1396, x1446);
    let (x1473, x1474) = fiat_p384_scalar_addcarryx_u32(x1472, x1398, x1448);
    let x1475: u32 = ((x1474 as u32) + (x1399 as u32));
    let (x1476, x1477) = fiat_p384_scalar_mulx_u32(x10, (arg1[11]));
    let (x1478, x1479) = fiat_p384_scalar_mulx_u32(x10, (arg1[10]));
    let (x1480, x1481) = fiat_p384_scalar_mulx_u32(x10, (arg1[9]));
    let (x1482, x1483) = fiat_p384_scalar_mulx_u32(x10, (arg1[8]));
    let (x1484, x1485) = fiat_p384_scalar_mulx_u32(x10, (arg1[7]));
    let (x1486, x1487) = fiat_p384_scalar_mulx_u32(x10, (arg1[6]));
    let (x1488, x1489) = fiat_p384_scalar_mulx_u32(x10, (arg1[5]));
    let (x1490, x1491) = fiat_p384_scalar_mulx_u32(x10, (arg1[4]));
    let (x1492, x1493) = fiat_p384_scalar_mulx_u32(x10, (arg1[3]));
    let (x1494, x1495) = fiat_p384_scalar_mulx_u32(x10, (arg1[2]));
    let (x1496, x1497) = fiat_p384_scalar_mulx_u32(x10, (arg1[1]));
    let (x1498, x1499) = fiat_p384_scalar_mulx_u32(x10, (arg1[0]));
    let (x1500, x1501) = fiat_p384_scalar_addcarryx_u32(0x0, x1499, x1496);
    let (x1502, x1503) = fiat_p384_scalar_addcarryx_u32(x1501, x1497, x1494);
    let (x1504, x1505) = fiat_p384_scalar_addcarryx_u32(x1503, x1495, x1492);
    let (x1506, x1507) = fiat_p384_scalar_addcarryx_u32(x1505, x1493, x1490);
    let (x1508, x1509) = fiat_p384_scalar_addcarryx_u32(x1507, x1491, x1488);
    let (x1510, x1511) = fiat_p384_scalar_addcarryx_u32(x1509, x1489, x1486);
    let (x1512, x1513) = fiat_p384_scalar_addcarryx_u32(x1511, x1487, x1484);
    let (x1514, x1515) = fiat_p384_scalar_addcarryx_u32(x1513, x1485, x1482);
    let (x1516, x1517) = fiat_p384_scalar_addcarryx_u32(x1515, x1483, x1480);
    let (x1518, x1519) = fiat_p384_scalar_addcarryx_u32(x1517, x1481, x1478);
    let (x1520, x1521) = fiat_p384_scalar_addcarryx_u32(x1519, x1479, x1476);
    let x1522: u32 = ((x1521 as u32) + x1477);
    let (x1523, x1524) = fiat_p384_scalar_addcarryx_u32(0x0, x1451, x1498);
    let (x1525, x1526) = fiat_p384_scalar_addcarryx_u32(x1524, x1453, x1500);
    let (x1527, x1528) = fiat_p384_scalar_addcarryx_u32(x1526, x1455, x1502);
    let (x1529, x1530) = fiat_p384_scalar_addcarryx_u32(x1528, x1457, x1504);
    let (x1531, x1532) = fiat_p384_scalar_addcarryx_u32(x1530, x1459, x1506);
    let (x1533, x1534) = fiat_p384_scalar_addcarryx_u32(x1532, x1461, x1508);
    let (x1535, x1536) = fiat_p384_scalar_addcarryx_u32(x1534, x1463, x1510);
    let (x1537, x1538) = fiat_p384_scalar_addcarryx_u32(x1536, x1465, x1512);
    let (x1539, x1540) = fiat_p384_scalar_addcarryx_u32(x1538, x1467, x1514);
    let (x1541, x1542) = fiat_p384_scalar_addcarryx_u32(x1540, x1469, x1516);
    let (x1543, x1544) = fiat_p384_scalar_addcarryx_u32(x1542, x1471, x1518);
    let (x1545, x1546) = fiat_p384_scalar_addcarryx_u32(x1544, x1473, x1520);
    let (x1547, x1548) = fiat_p384_scalar_addcarryx_u32(x1546, x1475, x1522);
    let (x1549, x1550) = fiat_p384_scalar_mulx_u32(x1523, 0xe88fdc45);
    let (x1551, x1552) = fiat_p384_scalar_mulx_u32(x1549, 0xffffffff);
    let (x1553, x1554) = fiat_p384_scalar_mulx_u32(x1549, 0xffffffff);
    let (x1555, x1556) = fiat_p384_scalar_mulx_u32(x1549, 0xffffffff);
    let (x1557, x1558) = fiat_p384_scalar_mulx_u32(x1549, 0xffffffff);
    let (x1559, x1560) = fiat_p384_scalar_mulx_u32(x1549, 0xffffffff);
    let (x1561, x1562) = fiat_p384_scalar_mulx_u32(x1549, 0xffffffff);
    let (x1563, x1564) = fiat_p384_scalar_mulx_u32(x1549, 0xc7634d81);
    let (x1565, x1566) = fiat_p384_scalar_mulx_u32(x1549, 0xf4372ddf);
    let (x1567, x1568) = fiat_p384_scalar_mulx_u32(x1549, 0x581a0db2);
    let (x1569, x1570) = fiat_p384_scalar_mulx_u32(x1549, 0x48b0a77a);
    let (x1571, x1572) = fiat_p384_scalar_mulx_u32(x1549, 0xecec196a);
    let (x1573, x1574) = fiat_p384_scalar_mulx_u32(x1549, 0xccc52973);
    let (x1575, x1576) = fiat_p384_scalar_addcarryx_u32(0x0, x1574, x1571);
    let (x1577, x1578) = fiat_p384_scalar_addcarryx_u32(x1576, x1572, x1569);
    let (x1579, x1580) = fiat_p384_scalar_addcarryx_u32(x1578, x1570, x1567);
    let (x1581, x1582) = fiat_p384_scalar_addcarryx_u32(x1580, x1568, x1565);
    let (x1583, x1584) = fiat_p384_scalar_addcarryx_u32(x1582, x1566, x1563);
    let (x1585, x1586) = fiat_p384_scalar_addcarryx_u32(x1584, x1564, x1561);
    let (x1587, x1588) = fiat_p384_scalar_addcarryx_u32(x1586, x1562, x1559);
    let (x1589, x1590) = fiat_p384_scalar_addcarryx_u32(x1588, x1560, x1557);
    let (x1591, x1592) = fiat_p384_scalar_addcarryx_u32(x1590, x1558, x1555);
    let (x1593, x1594) = fiat_p384_scalar_addcarryx_u32(x1592, x1556, x1553);
    let (x1595, x1596) = fiat_p384_scalar_addcarryx_u32(x1594, x1554, x1551);
    let x1597: u32 = ((x1596 as u32) + x1552);
    let (x1598, x1599) = fiat_p384_scalar_addcarryx_u32(0x0, x1523, x1573);
    let (x1600, x1601) = fiat_p384_scalar_addcarryx_u32(x1599, x1525, x1575);
    let (x1602, x1603) = fiat_p384_scalar_addcarryx_u32(x1601, x1527, x1577);
    let (x1604, x1605) = fiat_p384_scalar_addcarryx_u32(x1603, x1529, x1579);
    let (x1606, x1607) = fiat_p384_scalar_addcarryx_u32(x1605, x1531, x1581);
    let (x1608, x1609) = fiat_p384_scalar_addcarryx_u32(x1607, x1533, x1583);
    let (x1610, x1611) = fiat_p384_scalar_addcarryx_u32(x1609, x1535, x1585);
    let (x1612, x1613) = fiat_p384_scalar_addcarryx_u32(x1611, x1537, x1587);
    let (x1614, x1615) = fiat_p384_scalar_addcarryx_u32(x1613, x1539, x1589);
    let (x1616, x1617) = fiat_p384_scalar_addcarryx_u32(x1615, x1541, x1591);
    let (x1618, x1619) = fiat_p384_scalar_addcarryx_u32(x1617, x1543, x1593);
    let (x1620, x1621) = fiat_p384_scalar_addcarryx_u32(x1619, x1545, x1595);
    let (x1622, x1623) = fiat_p384_scalar_addcarryx_u32(x1621, x1547, x1597);
    let x1624: u32 = ((x1623 as u32) + (x1548 as u32));
    let (x1625, x1626) = fiat_p384_scalar_mulx_u32(x11, (arg1[11]));
    let (x1627, x1628) = fiat_p384_scalar_mulx_u32(x11, (arg1[10]));
    let (x1629, x1630) = fiat_p384_scalar_mulx_u32(x11, (arg1[9]));
    let (x1631, x1632) = fiat_p384_scalar_mulx_u32(x11, (arg1[8]));
    let (x1633, x1634) = fiat_p384_scalar_mulx_u32(x11, (arg1[7]));
    let (x1635, x1636) = fiat_p384_scalar_mulx_u32(x11, (arg1[6]));
    let (x1637, x1638) = fiat_p384_scalar_mulx_u32(x11, (arg1[5]));
    let (x1639, x1640) = fiat_p384_scalar_mulx_u32(x11, (arg1[4]));
    let (x1641, x1642) = fiat_p384_scalar_mulx_u32(x11, (arg1[3]));
    let (x1643, x1644) = fiat_p384_scalar_mulx_u32(x11, (arg1[2]));
    let (x1645, x1646) = fiat_p384_scalar_mulx_u32(x11, (arg1[1]));
    let (x1647, x1648) = fiat_p384_scalar_mulx_u32(x11, (arg1[0]));
    let (x1649, x1650) = fiat_p384_scalar_addcarryx_u32(0x0, x1648, x1645);
    let (x1651, x1652) = fiat_p384_scalar_addcarryx_u32(x1650, x1646, x1643);
    let (x1653, x1654) = fiat_p384_scalar_addcarryx_u32(x1652, x1644, x1641);
    let (x1655, x1656) = fiat_p384_scalar_addcarryx_u32(x1654, x1642, x1639);
    let (x1657, x1658) = fiat_p384_scalar_addcarryx_u32(x1656, x1640, x1637);
    let (x1659, x1660) = fiat_p384_scalar_addcarryx_u32(x1658, x1638, x1635);
    let (x1661, x1662) = fiat_p384_scalar_addcarryx_u32(x1660, x1636, x1633);
    let (x1663, x1664) = fiat_p384_scalar_addcarryx_u32(x1662, x1634, x1631);
    let (x1665, x1666) = fiat_p384_scalar_addcarryx_u32(x1664, x1632, x1629);
    let (x1667, x1668) = fiat_p384_scalar_addcarryx_u32(x1666, x1630, x1627);
    let (x1669, x1670) = fiat_p384_scalar_addcarryx_u32(x1668, x1628, x1625);
    let x1671: u32 = ((x1670 as u32) + x1626);
    let (x1672, x1673) = fiat_p384_scalar_addcarryx_u32(0x0, x1600, x1647);
    let (x1674, x1675) = fiat_p384_scalar_addcarryx_u32(x1673, x1602, x1649);
    let (x1676, x1677) = fiat_p384_scalar_addcarryx_u32(x1675, x1604, x1651);
    let (x1678, x1679) = fiat_p384_scalar_addcarryx_u32(x1677, x1606, x1653);
    let (x1680, x1681) = fiat_p384_scalar_addcarryx_u32(x1679, x1608, x1655);
    let (x1682, x1683) = fiat_p384_scalar_addcarryx_u32(x1681, x1610, x1657);
    let (x1684, x1685) = fiat_p384_scalar_addcarryx_u32(x1683, x1612, x1659);
    let (x1686, x1687) = fiat_p384_scalar_addcarryx_u32(x1685, x1614, x1661);
    let (x1688, x1689) = fiat_p384_scalar_addcarryx_u32(x1687, x1616, x1663);
    let (x1690, x1691) = fiat_p384_scalar_addcarryx_u32(x1689, x1618, x1665);
    let (x1692, x1693) = fiat_p384_scalar_addcarryx_u32(x1691, x1620, x1667);
    let (x1694, x1695) = fiat_p384_scalar_addcarryx_u32(x1693, x1622, x1669);
    let (x1696, x1697) = fiat_p384_scalar_addcarryx_u32(x1695, x1624, x1671);
    let (x1698, x1699) = fiat_p384_scalar_mulx_u32(x1672, 0xe88fdc45);
    let (x1700, x1701) = fiat_p384_scalar_mulx_u32(x1698, 0xffffffff);
    let (x1702, x1703) = fiat_p384_scalar_mulx_u32(x1698, 0xffffffff);
    let (x1704, x1705) = fiat_p384_scalar_mulx_u32(x1698, 0xffffffff);
    let (x1706, x1707) = fiat_p384_scalar_mulx_u32(x1698, 0xffffffff);
    let (x1708, x1709) = fiat_p384_scalar_mulx_u32(x1698, 0xffffffff);
    let (x1710, x1711) = fiat_p384_scalar_mulx_u32(x1698, 0xffffffff);
    let (x1712, x1713) = fiat_p384_scalar_mulx_u32(x1698, 0xc7634d81);
    let (x1714, x1715) = fiat_p384_scalar_mulx_u32(x1698, 0xf4372ddf);
    let (x1716, x1717) = fiat_p384_scalar_mulx_u32(x1698, 0x581a0db2);
    let (x1718, x1719) = fiat_p384_scalar_mulx_u32(x1698, 0x48b0a77a);
    let (x1720, x1721) = fiat_p384_scalar_mulx_u32(x1698, 0xecec196a);
    let (x1722, x1723) = fiat_p384_scalar_mulx_u32(x1698, 0xccc52973);
    let (x1724, x1725) = fiat_p384_scalar_addcarryx_u32(0x0, x1723, x1720);
    let (x1726, x1727) = fiat_p384_scalar_addcarryx_u32(x1725, x1721, x1718);
    let (x1728, x1729) = fiat_p384_scalar_addcarryx_u32(x1727, x1719, x1716);
    let (x1730, x1731) = fiat_p384_scalar_addcarryx_u32(x1729, x1717, x1714);
    let (x1732, x1733) = fiat_p384_scalar_addcarryx_u32(x1731, x1715, x1712);
    let (x1734, x1735) = fiat_p384_scalar_addcarryx_u32(x1733, x1713, x1710);
    let (x1736, x1737) = fiat_p384_scalar_addcarryx_u32(x1735, x1711, x1708);
    let (x1738, x1739) = fiat_p384_scalar_addcarryx_u32(x1737, x1709, x1706);
    let (x1740, x1741) = fiat_p384_scalar_addcarryx_u32(x1739, x1707, x1704);
    let (x1742, x1743) = fiat_p384_scalar_addcarryx_u32(x1741, x1705, x1702);
    let (x1744, x1745) = fiat_p384_scalar_addcarryx_u32(x1743, x1703, x1700);
    let x1746: u32 = ((x1745 as u32) + x1701);
    let (x1747, x1748) = fiat_p384_scalar_addcarryx_u32(0x0, x1672, x1722);
    let (x1749, x1750) = fiat_p384_scalar_addcarryx_u32(x1748, x1674, x1724);
    let (x1751, x1752) = fiat_p384_scalar_addcarryx_u32(x1750, x1676, x1726);
    let (x1753, x1754) = fiat_p384_scalar_addcarryx_u32(x1752, x1678, x1728);
    let (x1755, x1756) = fiat_p384_scalar_addcarryx_u32(x1754, x1680, x1730);
    let (x1757, x1758) = fiat_p384_scalar_addcarryx_u32(x1756, x1682, x1732);
    let (x1759, x1760) = fiat_p384_scalar_addcarryx_u32(x1758, x1684, x1734);
    let (x1761, x1762) = fiat_p384_scalar_addcarryx_u32(x1760, x1686, x1736);
    let (x1763, x1764) = fiat_p384_scalar_addcarryx_u32(x1762, x1688, x1738);
    let (x1765, x1766) = fiat_p384_scalar_addcarryx_u32(x1764, x1690, x1740);
    let (x1767, x1768) = fiat_p384_scalar_addcarryx_u32(x1766, x1692, x1742);
    let (x1769, x1770) = fiat_p384_scalar_addcarryx_u32(x1768, x1694, x1744);
    let (x1771, x1772) = fiat_p384_scalar_addcarryx_u32(x1770, x1696, x1746);
    let x1773: u32 = ((x1772 as u32) + (x1697 as u32));
    let (x1774, x1775) = fiat_p384_scalar_subborrowx_u32(0x0, x1749, 0xccc52973);
    let (x1776, x1777) = fiat_p384_scalar_subborrowx_u32(x1775, x1751, 0xecec196a);
    let (x1778, x1779) = fiat_p384_scalar_subborrowx_u32(x1777, x1753, 0x48b0a77a);
    let (x1780, x1781) = fiat_p384_scalar_subborrowx_u32(x1779, x1755, 0x581a0db2);
    let (x1782, x1783) = fiat_p384_scalar_subborrowx_u32(x1781, x1757, 0xf4372ddf);
    let (x1784, x1785) = fiat_p384_scalar_subborrowx_u32(x1783, x1759, 0xc7634d81);
    let (x1786, x1787) = fiat_p384_scalar_subborrowx_u32(x1785, x1761, 0xffffffff);
    let (x1788, x1789) = fiat_p384_scalar_subborrowx_u32(x1787, x1763, 0xffffffff);
    let (x1790, x1791) = fiat_p384_scalar_subborrowx_u32(x1789, x1765, 0xffffffff);
    let (x1792, x1793) = fiat_p384_scalar_subborrowx_u32(x1791, x1767, 0xffffffff);
    let (x1794, x1795) = fiat_p384_scalar_subborrowx_u32(x1793, x1769, 0xffffffff);
    let (x1796, x1797) = fiat_p384_scalar_subborrowx_u32(x1795, x1771, 0xffffffff);
    let (x1798, x1799) = fiat_p384_scalar_subborrowx_u32(x1797, x1773, (0x0 as u32));
    let (x1800) = fiat_p384_scalar_cmovznz_u32(x1799, x1774, x1749);
    let (x1801) = fiat_p384_scalar_cmovznz_u32(x1799, x1776, x1751);
    let (x1802) = fiat_p384_scalar_cmovznz_u32(x1799, x1778, x1753);
    let (x1803) = fiat_p384_scalar_cmovznz_u32(x1799, x1780, x1755);
    let (x1804) = fiat_p384_scalar_cmovznz_u32(x1799, x1782, x1757);
    let (x1805) = fiat_p384_scalar_cmovznz_u32(x1799, x1784, x1759);
    let (x1806) = fiat_p384_scalar_cmovznz_u32(x1799, x1786, x1761);
    let (x1807) = fiat_p384_scalar_cmovznz_u32(x1799, x1788, x1763);
    let (x1808) = fiat_p384_scalar_cmovznz_u32(x1799, x1790, x1765);
    let (x1809) = fiat_p384_scalar_cmovznz_u32(x1799, x1792, x1767);
    let (x1810) = fiat_p384_scalar_cmovznz_u32(x1799, x1794, x1769);
    let (x1811) = fiat_p384_scalar_cmovznz_u32(x1799, x1796, x1771);
    out1[0] = x1800;
    out1[1] = x1801;
    out1[2] = x1802;
    out1[3] = x1803;
    out1[4] = x1804;
    out1[5] = x1805;
    out1[6] = x1806;
    out1[7] = x1807;
    out1[8] = x1808;
    out1[9] = x1809;
    out1[10] = x1810;
    out1[11] = x1811;
    out1
}
#[doc = " The function fiat_p384_scalar_add adds two field elements in the Montgomery domain."]
#[doc = ""]
#[doc = " Preconditions:"]
#[doc = "   0 ≤ eval arg1 < m"]
#[doc = "   0 ≤ eval arg2 < m"]
#[doc = " Postconditions:"]
#[doc = "   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) + eval (from_montgomery arg2)) mod m"]
#[doc = "   0 ≤ eval out1 < m"]
#[doc = ""]
#[inline]
pub const fn fiat_p384_scalar_add(
    arg1: &fiat_p384_scalar_montgomery_domain_field_element,
    arg2: &fiat_p384_scalar_montgomery_domain_field_element,
) -> fiat_p384_scalar_montgomery_domain_field_element {
    let mut out1: fiat_p384_scalar_montgomery_domain_field_element = [0; 12];
    let (x1, x2) = fiat_p384_scalar_addcarryx_u32(0x0, (arg1[0]), (arg2[0]));
    let (x3, x4) = fiat_p384_scalar_addcarryx_u32(x2, (arg1[1]), (arg2[1]));
    let (x5, x6) = fiat_p384_scalar_addcarryx_u32(x4, (arg1[2]), (arg2[2]));
    let (x7, x8) = fiat_p384_scalar_addcarryx_u32(x6, (arg1[3]), (arg2[3]));
    let (x9, x10) = fiat_p384_scalar_addcarryx_u32(x8, (arg1[4]), (arg2[4]));
    let (x11, x12) = fiat_p384_scalar_addcarryx_u32(x10, (arg1[5]), (arg2[5]));
    let (x13, x14) = fiat_p384_scalar_addcarryx_u32(x12, (arg1[6]), (arg2[6]));
    let (x15, x16) = fiat_p384_scalar_addcarryx_u32(x14, (arg1[7]), (arg2[7]));
    let (x17, x18) = fiat_p384_scalar_addcarryx_u32(x16, (arg1[8]), (arg2[8]));
    let (x19, x20) = fiat_p384_scalar_addcarryx_u32(x18, (arg1[9]), (arg2[9]));
    let (x21, x22) = fiat_p384_scalar_addcarryx_u32(x20, (arg1[10]), (arg2[10]));
    let (x23, x24) = fiat_p384_scalar_addcarryx_u32(x22, (arg1[11]), (arg2[11]));
    let (x25, x26) = fiat_p384_scalar_subborrowx_u32(0x0, x1, 0xccc52973);
    let (x27, x28) = fiat_p384_scalar_subborrowx_u32(x26, x3, 0xecec196a);
    let (x29, x30) = fiat_p384_scalar_subborrowx_u32(x28, x5, 0x48b0a77a);
    let (x31, x32) = fiat_p384_scalar_subborrowx_u32(x30, x7, 0x581a0db2);
    let (x33, x34) = fiat_p384_scalar_subborrowx_u32(x32, x9, 0xf4372ddf);
    let (x35, x36) = fiat_p384_scalar_subborrowx_u32(x34, x11, 0xc7634d81);
    let (x37, x38) = fiat_p384_scalar_subborrowx_u32(x36, x13, 0xffffffff);
    let (x39, x40) = fiat_p384_scalar_subborrowx_u32(x38, x15, 0xffffffff);
    let (x41, x42) = fiat_p384_scalar_subborrowx_u32(x40, x17, 0xffffffff);
    let (x43, x44) = fiat_p384_scalar_subborrowx_u32(x42, x19, 0xffffffff);
    let (x45, x46) = fiat_p384_scalar_subborrowx_u32(x44, x21, 0xffffffff);
    let (x47, x48) = fiat_p384_scalar_subborrowx_u32(x46, x23, 0xffffffff);
    let (x49, x50) = fiat_p384_scalar_subborrowx_u32(x48, (x24 as u32), (0x0 as u32));
    let (x51) = fiat_p384_scalar_cmovznz_u32(x50, x25, x1);
    let (x52) = fiat_p384_scalar_cmovznz_u32(x50, x27, x3);
    let (x53) = fiat_p384_scalar_cmovznz_u32(x50, x29, x5);
    let (x54) = fiat_p384_scalar_cmovznz_u32(x50, x31, x7);
    let (x55) = fiat_p384_scalar_cmovznz_u32(x50, x33, x9);
    let (x56) = fiat_p384_scalar_cmovznz_u32(x50, x35, x11);
    let (x57) = fiat_p384_scalar_cmovznz_u32(x50, x37, x13);
    let (x58) = fiat_p384_scalar_cmovznz_u32(x50, x39, x15);
    let (x59) = fiat_p384_scalar_cmovznz_u32(x50, x41, x17);
    let (x60) = fiat_p384_scalar_cmovznz_u32(x50, x43, x19);
    let (x61) = fiat_p384_scalar_cmovznz_u32(x50, x45, x21);
    let (x62) = fiat_p384_scalar_cmovznz_u32(x50, x47, x23);
    out1[0] = x51;
    out1[1] = x52;
    out1[2] = x53;
    out1[3] = x54;
    out1[4] = x55;
    out1[5] = x56;
    out1[6] = x57;
    out1[7] = x58;
    out1[8] = x59;
    out1[9] = x60;
    out1[10] = x61;
    out1[11] = x62;
    out1
}
#[doc = " The function fiat_p384_scalar_sub subtracts two field elements in the Montgomery domain."]
#[doc = ""]
#[doc = " Preconditions:"]
#[doc = "   0 ≤ eval arg1 < m"]
#[doc = "   0 ≤ eval arg2 < m"]
#[doc = " Postconditions:"]
#[doc = "   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) - eval (from_montgomery arg2)) mod m"]
#[doc = "   0 ≤ eval out1 < m"]
#[doc = ""]
#[inline]
pub const fn fiat_p384_scalar_sub(
    arg1: &fiat_p384_scalar_montgomery_domain_field_element,
    arg2: &fiat_p384_scalar_montgomery_domain_field_element,
) -> fiat_p384_scalar_montgomery_domain_field_element {
    let mut out1: fiat_p384_scalar_montgomery_domain_field_element = [0; 12];
    let (x1, x2) = fiat_p384_scalar_subborrowx_u32(0x0, (arg1[0]), (arg2[0]));
    let (x3, x4) = fiat_p384_scalar_subborrowx_u32(x2, (arg1[1]), (arg2[1]));
    let (x5, x6) = fiat_p384_scalar_subborrowx_u32(x4, (arg1[2]), (arg2[2]));
    let (x7, x8) = fiat_p384_scalar_subborrowx_u32(x6, (arg1[3]), (arg2[3]));
    let (x9, x10) = fiat_p384_scalar_subborrowx_u32(x8, (arg1[4]), (arg2[4]));
    let (x11, x12) = fiat_p384_scalar_subborrowx_u32(x10, (arg1[5]), (arg2[5]));
    let (x13, x14) = fiat_p384_scalar_subborrowx_u32(x12, (arg1[6]), (arg2[6]));
    let (x15, x16) = fiat_p384_scalar_subborrowx_u32(x14, (arg1[7]), (arg2[7]));
    let (x17, x18) = fiat_p384_scalar_subborrowx_u32(x16, (arg1[8]), (arg2[8]));
    let (x19, x20) = fiat_p384_scalar_subborrowx_u32(x18, (arg1[9]), (arg2[9]));
    let (x21, x22) = fiat_p384_scalar_subborrowx_u32(x20, (arg1[10]), (arg2[10]));
    let (x23, x24) = fiat_p384_scalar_subborrowx_u32(x22, (arg1[11]), (arg2[11]));
    let (x25) = fiat_p384_scalar_cmovznz_u32(x24, (0x0 as u32), 0xffffffff);
    let (x26, x27) = fiat_p384_scalar_addcarryx_u32(0x0, x1, (x25 & 0xccc52973));
    let (x28, x29) = fiat_p384_scalar_addcarryx_u32(x27, x3, (x25 & 0xecec196a));
    let (x30, x31) = fiat_p384_scalar_addcarryx_u32(x29, x5, (x25 & 0x48b0a77a));
    let (x32, x33) = fiat_p384_scalar_addcarryx_u32(x31, x7, (x25 & 0x581a0db2));
    let (x34, x35) = fiat_p384_scalar_addcarryx_u32(x33, x9, (x25 & 0xf4372ddf));
    let (x36, x37) = fiat_p384_scalar_addcarryx_u32(x35, x11, (x25 & 0xc7634d81));
    let (x38, x39) = fiat_p384_scalar_addcarryx_u32(x37, x13, x25);
    let (x40, x41) = fiat_p384_scalar_addcarryx_u32(x39, x15, x25);
    let (x42, x43) = fiat_p384_scalar_addcarryx_u32(x41, x17, x25);
    let (x44, x45) = fiat_p384_scalar_addcarryx_u32(x43, x19, x25);
    let (x46, x47) = fiat_p384_scalar_addcarryx_u32(x45, x21, x25);
    let (x48, x49) = fiat_p384_scalar_addcarryx_u32(x47, x23, x25);
    out1[0] = x26;
    out1[1] = x28;
    out1[2] = x30;
    out1[3] = x32;
    out1[4] = x34;
    out1[5] = x36;
    out1[6] = x38;
    out1[7] = x40;
    out1[8] = x42;
    out1[9] = x44;
    out1[10] = x46;
    out1[11] = x48;
    out1
}
#[doc = " The function fiat_p384_scalar_opp negates a field element in the Montgomery domain."]
#[doc = ""]
#[doc = " Preconditions:"]
#[doc = "   0 ≤ eval arg1 < m"]
#[doc = " Postconditions:"]
#[doc = "   eval (from_montgomery out1) mod m = -eval (from_montgomery arg1) mod m"]
#[doc = "   0 ≤ eval out1 < m"]
#[doc = ""]
#[inline]
pub const fn fiat_p384_scalar_opp(
    arg1: &fiat_p384_scalar_montgomery_domain_field_element,
) -> fiat_p384_scalar_montgomery_domain_field_element {
    let mut out1: fiat_p384_scalar_montgomery_domain_field_element = [0; 12];
    let (x1, x2) = fiat_p384_scalar_subborrowx_u32(0x0, (0x0 as u32), (arg1[0]));
    let (x3, x4) = fiat_p384_scalar_subborrowx_u32(x2, (0x0 as u32), (arg1[1]));
    let (x5, x6) = fiat_p384_scalar_subborrowx_u32(x4, (0x0 as u32), (arg1[2]));
    let (x7, x8) = fiat_p384_scalar_subborrowx_u32(x6, (0x0 as u32), (arg1[3]));
    let (x9, x10) = fiat_p384_scalar_subborrowx_u32(x8, (0x0 as u32), (arg1[4]));
    let (x11, x12) = fiat_p384_scalar_subborrowx_u32(x10, (0x0 as u32), (arg1[5]));
    let (x13, x14) = fiat_p384_scalar_subborrowx_u32(x12, (0x0 as u32), (arg1[6]));
    let (x15, x16) = fiat_p384_scalar_subborrowx_u32(x14, (0x0 as u32), (arg1[7]));
    let (x17, x18) = fiat_p384_scalar_subborrowx_u32(x16, (0x0 as u32), (arg1[8]));
    let (x19, x20) = fiat_p384_scalar_subborrowx_u32(x18, (0x0 as u32), (arg1[9]));
    let (x21, x22) = fiat_p384_scalar_subborrowx_u32(x20, (0x0 as u32), (arg1[10]));
    let (x23, x24) = fiat_p384_scalar_subborrowx_u32(x22, (0x0 as u32), (arg1[11]));
    let (x25) = fiat_p384_scalar_cmovznz_u32(x24, (0x0 as u32), 0xffffffff);
    let (x26, x27) = fiat_p384_scalar_addcarryx_u32(0x0, x1, (x25 & 0xccc52973));
    let (x28, x29) = fiat_p384_scalar_addcarryx_u32(x27, x3, (x25 & 0xecec196a));
    let (x30, x31) = fiat_p384_scalar_addcarryx_u32(x29, x5, (x25 & 0x48b0a77a));
    let (x32, x33) = fiat_p384_scalar_addcarryx_u32(x31, x7, (x25 & 0x581a0db2));
    let (x34, x35) = fiat_p384_scalar_addcarryx_u32(x33, x9, (x25 & 0xf4372ddf));
    let (x36, x37) = fiat_p384_scalar_addcarryx_u32(x35, x11, (x25 & 0xc7634d81));
    let (x38, x39) = fiat_p384_scalar_addcarryx_u32(x37, x13, x25);
    let (x40, x41) = fiat_p384_scalar_addcarryx_u32(x39, x15, x25);
    let (x42, x43) = fiat_p384_scalar_addcarryx_u32(x41, x17, x25);
    let (x44, x45) = fiat_p384_scalar_addcarryx_u32(x43, x19, x25);
    let (x46, x47) = fiat_p384_scalar_addcarryx_u32(x45, x21, x25);
    let (x48, x49) = fiat_p384_scalar_addcarryx_u32(x47, x23, x25);
    out1[0] = x26;
    out1[1] = x28;
    out1[2] = x30;
    out1[3] = x32;
    out1[4] = x34;
    out1[5] = x36;
    out1[6] = x38;
    out1[7] = x40;
    out1[8] = x42;
    out1[9] = x44;
    out1[10] = x46;
    out1[11] = x48;
    out1
}
#[doc = " The function fiat_p384_scalar_from_montgomery translates a field element out of the Montgomery domain."]
#[doc = ""]
#[doc = " Preconditions:"]
#[doc = "   0 ≤ eval arg1 < m"]
#[doc = " Postconditions:"]
#[doc = "   eval out1 mod m = (eval arg1 * ((2^32)⁻¹ mod m)^12) mod m"]
#[doc = "   0 ≤ eval out1 < m"]
#[doc = ""]
#[inline]
pub const fn fiat_p384_scalar_from_montgomery(
    arg1: &fiat_p384_scalar_montgomery_domain_field_element,
) -> fiat_p384_scalar_non_montgomery_domain_field_element {
    let mut out1: fiat_p384_scalar_non_montgomery_domain_field_element = [0; 12];
    let x1: u32 = (arg1[0]);
    let (x2, x3) = fiat_p384_scalar_mulx_u32(x1, 0xe88fdc45);
    let (x4, x5) = fiat_p384_scalar_mulx_u32(x2, 0xffffffff);
    let (x6, x7) = fiat_p384_scalar_mulx_u32(x2, 0xffffffff);
    let (x8, x9) = fiat_p384_scalar_mulx_u32(x2, 0xffffffff);
    let (x10, x11) = fiat_p384_scalar_mulx_u32(x2, 0xffffffff);
    let (x12, x13) = fiat_p384_scalar_mulx_u32(x2, 0xffffffff);
    let (x14, x15) = fiat_p384_scalar_mulx_u32(x2, 0xffffffff);
    let (x16, x17) = fiat_p384_scalar_mulx_u32(x2, 0xc7634d81);
    let (x18, x19) = fiat_p384_scalar_mulx_u32(x2, 0xf4372ddf);
    let (x20, x21) = fiat_p384_scalar_mulx_u32(x2, 0x581a0db2);
    let (x22, x23) = fiat_p384_scalar_mulx_u32(x2, 0x48b0a77a);
    let (x24, x25) = fiat_p384_scalar_mulx_u32(x2, 0xecec196a);
    let (x26, x27) = fiat_p384_scalar_mulx_u32(x2, 0xccc52973);
    let (x28, x29) = fiat_p384_scalar_addcarryx_u32(0x0, x27, x24);
    let (x30, x31) = fiat_p384_scalar_addcarryx_u32(x29, x25, x22);
    let (x32, x33) = fiat_p384_scalar_addcarryx_u32(x31, x23, x20);
    let (x34, x35) = fiat_p384_scalar_addcarryx_u32(x33, x21, x18);
    let (x36, x37) = fiat_p384_scalar_addcarryx_u32(x35, x19, x16);
    let (x38, x39) = fiat_p384_scalar_addcarryx_u32(x37, x17, x14);
    let (x40, x41) = fiat_p384_scalar_addcarryx_u32(x39, x15, x12);
    let (x42, x43) = fiat_p384_scalar_addcarryx_u32(x41, x13, x10);
    let (x44, x45) = fiat_p384_scalar_addcarryx_u32(x43, x11, x8);
    let (x46, x47) = fiat_p384_scalar_addcarryx_u32(x45, x9, x6);
    let (x48, x49) = fiat_p384_scalar_addcarryx_u32(x47, x7, x4);
    let (x50, x51) = fiat_p384_scalar_addcarryx_u32(0x0, x1, x26);
    let (x52, x53) = fiat_p384_scalar_addcarryx_u32(x51, (0x0 as u32), x28);
    let (x54, x55) = fiat_p384_scalar_addcarryx_u32(x53, (0x0 as u32), x30);
    let (x56, x57) = fiat_p384_scalar_addcarryx_u32(x55, (0x0 as u32), x32);
    let (x58, x59) = fiat_p384_scalar_addcarryx_u32(x57, (0x0 as u32), x34);
    let (x60, x61) = fiat_p384_scalar_addcarryx_u32(x59, (0x0 as u32), x36);
    let (x62, x63) = fiat_p384_scalar_addcarryx_u32(x61, (0x0 as u32), x38);
    let (x64, x65) = fiat_p384_scalar_addcarryx_u32(x63, (0x0 as u32), x40);
    let (x66, x67) = fiat_p384_scalar_addcarryx_u32(x65, (0x0 as u32), x42);
    let (x68, x69) = fiat_p384_scalar_addcarryx_u32(x67, (0x0 as u32), x44);
    let (x70, x71) = fiat_p384_scalar_addcarryx_u32(x69, (0x0 as u32), x46);
    let (x72, x73) = fiat_p384_scalar_addcarryx_u32(x71, (0x0 as u32), x48);
    let (x74, x75) = fiat_p384_scalar_addcarryx_u32(x73, (0x0 as u32), ((x49 as u32) + x5));
    let (x76, x77) = fiat_p384_scalar_addcarryx_u32(0x0, x52, (arg1[1]));
    let (x78, x79) = fiat_p384_scalar_addcarryx_u32(x77, x54, (0x0 as u32));
    let (x80, x81) = fiat_p384_scalar_addcarryx_u32(x79, x56, (0x0 as u32));
    let (x82, x83) = fiat_p384_scalar_addcarryx_u32(x81, x58, (0x0 as u32));
    let (x84, x85) = fiat_p384_scalar_addcarryx_u32(x83, x60, (0x0 as u32));
    let (x86, x87) = fiat_p384_scalar_addcarryx_u32(x85, x62, (0x0 as u32));
    let (x88, x89) = fiat_p384_scalar_addcarryx_u32(x87, x64, (0x0 as u32));
    let (x90, x91) = fiat_p384_scalar_addcarryx_u32(x89, x66, (0x0 as u32));
    let (x92, x93) = fiat_p384_scalar_addcarryx_u32(x91, x68, (0x0 as u32));
    let (x94, x95) = fiat_p384_scalar_addcarryx_u32(x93, x70, (0x0 as u32));
    let (x96, x97) = fiat_p384_scalar_addcarryx_u32(x95, x72, (0x0 as u32));
    let (x98, x99) = fiat_p384_scalar_addcarryx_u32(x97, x74, (0x0 as u32));
    let (x100, x101) = fiat_p384_scalar_mulx_u32(x76, 0xe88fdc45);
    let (x102, x103) = fiat_p384_scalar_mulx_u32(x100, 0xffffffff);
    let (x104, x105) = fiat_p384_scalar_mulx_u32(x100, 0xffffffff);
    let (x106, x107) = fiat_p384_scalar_mulx_u32(x100, 0xffffffff);
    let (x108, x109) = fiat_p384_scalar_mulx_u32(x100, 0xffffffff);
    let (x110, x111) = fiat_p384_scalar_mulx_u32(x100, 0xffffffff);
    let (x112, x113) = fiat_p384_scalar_mulx_u32(x100, 0xffffffff);
    let (x114, x115) = fiat_p384_scalar_mulx_u32(x100, 0xc7634d81);
    let (x116, x117) = fiat_p384_scalar_mulx_u32(x100, 0xf4372ddf);
    let (x118, x119) = fiat_p384_scalar_mulx_u32(x100, 0x581a0db2);
    let (x120, x121) = fiat_p384_scalar_mulx_u32(x100, 0x48b0a77a);
    let (x122, x123) = fiat_p384_scalar_mulx_u32(x100, 0xecec196a);
    let (x124, x125) = fiat_p384_scalar_mulx_u32(x100, 0xccc52973);
    let (x126, x127) = fiat_p384_scalar_addcarryx_u32(0x0, x125, x122);
    let (x128, x129) = fiat_p384_scalar_addcarryx_u32(x127, x123, x120);
    let (x130, x131) = fiat_p384_scalar_addcarryx_u32(x129, x121, x118);
    let (x132, x133) = fiat_p384_scalar_addcarryx_u32(x131, x119, x116);
    let (x134, x135) = fiat_p384_scalar_addcarryx_u32(x133, x117, x114);
    let (x136, x137) = fiat_p384_scalar_addcarryx_u32(x135, x115, x112);
    let (x138, x139) = fiat_p384_scalar_addcarryx_u32(x137, x113, x110);
    let (x140, x141) = fiat_p384_scalar_addcarryx_u32(x139, x111, x108);
    let (x142, x143) = fiat_p384_scalar_addcarryx_u32(x141, x109, x106);
    let (x144, x145) = fiat_p384_scalar_addcarryx_u32(x143, x107, x104);
    let (x146, x147) = fiat_p384_scalar_addcarryx_u32(x145, x105, x102);
    let (x148, x149) = fiat_p384_scalar_addcarryx_u32(0x0, x76, x124);
    let (x150, x151) = fiat_p384_scalar_addcarryx_u32(x149, x78, x126);
    let (x152, x153) = fiat_p384_scalar_addcarryx_u32(x151, x80, x128);
    let (x154, x155) = fiat_p384_scalar_addcarryx_u32(x153, x82, x130);
    let (x156, x157) = fiat_p384_scalar_addcarryx_u32(x155, x84, x132);
    let (x158, x159) = fiat_p384_scalar_addcarryx_u32(x157, x86, x134);
    let (x160, x161) = fiat_p384_scalar_addcarryx_u32(x159, x88, x136);
    let (x162, x163) = fiat_p384_scalar_addcarryx_u32(x161, x90, x138);
    let (x164, x165) = fiat_p384_scalar_addcarryx_u32(x163, x92, x140);
    let (x166, x167) = fiat_p384_scalar_addcarryx_u32(x165, x94, x142);
    let (x168, x169) = fiat_p384_scalar_addcarryx_u32(x167, x96, x144);
    let (x170, x171) = fiat_p384_scalar_addcarryx_u32(x169, x98, x146);
    let (x172, x173) =
        fiat_p384_scalar_addcarryx_u32(x171, ((x99 as u32) + (x75 as u32)), ((x147 as u32) + x103));
    let (x174, x175) = fiat_p384_scalar_addcarryx_u32(0x0, x150, (arg1[2]));
    let (x176, x177) = fiat_p384_scalar_addcarryx_u32(x175, x152, (0x0 as u32));
    let (x178, x179) = fiat_p384_scalar_addcarryx_u32(x177, x154, (0x0 as u32));
    let (x180, x181) = fiat_p384_scalar_addcarryx_u32(x179, x156, (0x0 as u32));
    let (x182, x183) = fiat_p384_scalar_addcarryx_u32(x181, x158, (0x0 as u32));
    let (x184, x185) = fiat_p384_scalar_addcarryx_u32(x183, x160, (0x0 as u32));
    let (x186, x187) = fiat_p384_scalar_addcarryx_u32(x185, x162, (0x0 as u32));
    let (x188, x189) = fiat_p384_scalar_addcarryx_u32(x187, x164, (0x0 as u32));
    let (x190, x191) = fiat_p384_scalar_addcarryx_u32(x189, x166, (0x0 as u32));
    let (x192, x193) = fiat_p384_scalar_addcarryx_u32(x191, x168, (0x0 as u32));
    let (x194, x195) = fiat_p384_scalar_addcarryx_u32(x193, x170, (0x0 as u32));
    let (x196, x197) = fiat_p384_scalar_addcarryx_u32(x195, x172, (0x0 as u32));
    let (x198, x199) = fiat_p384_scalar_mulx_u32(x174, 0xe88fdc45);
    let (x200, x201) = fiat_p384_scalar_mulx_u32(x198, 0xffffffff);
    let (x202, x203) = fiat_p384_scalar_mulx_u32(x198, 0xffffffff);
    let (x204, x205) = fiat_p384_scalar_mulx_u32(x198, 0xffffffff);
    let (x206, x207) = fiat_p384_scalar_mulx_u32(x198, 0xffffffff);
    let (x208, x209) = fiat_p384_scalar_mulx_u32(x198, 0xffffffff);
    let (x210, x211) = fiat_p384_scalar_mulx_u32(x198, 0xffffffff);
    let (x212, x213) = fiat_p384_scalar_mulx_u32(x198, 0xc7634d81);
    let (x214, x215) = fiat_p384_scalar_mulx_u32(x198, 0xf4372ddf);
    let (x216, x217) = fiat_p384_scalar_mulx_u32(x198, 0x581a0db2);
    let (x218, x219) = fiat_p384_scalar_mulx_u32(x198, 0x48b0a77a);
    let (x220, x221) = fiat_p384_scalar_mulx_u32(x198, 0xecec196a);
    let (x222, x223) = fiat_p384_scalar_mulx_u32(x198, 0xccc52973);
    let (x224, x225) = fiat_p384_scalar_addcarryx_u32(0x0, x223, x220);
    let (x226, x227) = fiat_p384_scalar_addcarryx_u32(x225, x221, x218);
    let (x228, x229) = fiat_p384_scalar_addcarryx_u32(x227, x219, x216);
    let (x230, x231) = fiat_p384_scalar_addcarryx_u32(x229, x217, x214);
    let (x232, x233) = fiat_p384_scalar_addcarryx_u32(x231, x215, x212);
    let (x234, x235) = fiat_p384_scalar_addcarryx_u32(x233, x213, x210);
    let (x236, x237) = fiat_p384_scalar_addcarryx_u32(x235, x211, x208);
    let (x238, x239) = fiat_p384_scalar_addcarryx_u32(x237, x209, x206);
    let (x240, x241) = fiat_p384_scalar_addcarryx_u32(x239, x207, x204);
    let (x242, x243) = fiat_p384_scalar_addcarryx_u32(x241, x205, x202);
    let (x244, x245) = fiat_p384_scalar_addcarryx_u32(x243, x203, x200);
    let (x246, x247) = fiat_p384_scalar_addcarryx_u32(0x0, x174, x222);
    let (x248, x249) = fiat_p384_scalar_addcarryx_u32(x247, x176, x224);
    let (x250, x251) = fiat_p384_scalar_addcarryx_u32(x249, x178, x226);
    let (x252, x253) = fiat_p384_scalar_addcarryx_u32(x251, x180, x228);
    let (x254, x255) = fiat_p384_scalar_addcarryx_u32(x253, x182, x230);
    let (x256, x257) = fiat_p384_scalar_addcarryx_u32(x255, x184, x232);
    let (x258, x259) = fiat_p384_scalar_addcarryx_u32(x257, x186, x234);
    let (x260, x261) = fiat_p384_scalar_addcarryx_u32(x259, x188, x236);
    let (x262, x263) = fiat_p384_scalar_addcarryx_u32(x261, x190, x238);
    let (x264, x265) = fiat_p384_scalar_addcarryx_u32(x263, x192, x240);
    let (x266, x267) = fiat_p384_scalar_addcarryx_u32(x265, x194, x242);
    let (x268, x269) = fiat_p384_scalar_addcarryx_u32(x267, x196, x244);
    let (x270, x271) = fiat_p384_scalar_addcarryx_u32(
        x269,
        ((x197 as u32) + (x173 as u32)),
        ((x245 as u32) + x201),
    );
    let (x272, x273) = fiat_p384_scalar_addcarryx_u32(0x0, x248, (arg1[3]));
    let (x274, x275) = fiat_p384_scalar_addcarryx_u32(x273, x250, (0x0 as u32));
    let (x276, x277) = fiat_p384_scalar_addcarryx_u32(x275, x252, (0x0 as u32));
    let (x278, x279) = fiat_p384_scalar_addcarryx_u32(x277, x254, (0x0 as u32));
    let (x280, x281) = fiat_p384_scalar_addcarryx_u32(x279, x256, (0x0 as u32));
    let (x282, x283) = fiat_p384_scalar_addcarryx_u32(x281, x258, (0x0 as u32));
    let (x284, x285) = fiat_p384_scalar_addcarryx_u32(x283, x260, (0x0 as u32));
    let (x286, x287) = fiat_p384_scalar_addcarryx_u32(x285, x262, (0x0 as u32));
    let (x288, x289) = fiat_p384_scalar_addcarryx_u32(x287, x264, (0x0 as u32));
    let (x290, x291) = fiat_p384_scalar_addcarryx_u32(x289, x266, (0x0 as u32));
    let (x292, x293) = fiat_p384_scalar_addcarryx_u32(x291, x268, (0x0 as u32));
    let (x294, x295) = fiat_p384_scalar_addcarryx_u32(x293, x270, (0x0 as u32));
    let (x296, x297) = fiat_p384_scalar_mulx_u32(x272, 0xe88fdc45);
    let (x298, x299) = fiat_p384_scalar_mulx_u32(x296, 0xffffffff);
    let (x300, x301) = fiat_p384_scalar_mulx_u32(x296, 0xffffffff);
    let (x302, x303) = fiat_p384_scalar_mulx_u32(x296, 0xffffffff);
    let (x304, x305) = fiat_p384_scalar_mulx_u32(x296, 0xffffffff);
    let (x306, x307) = fiat_p384_scalar_mulx_u32(x296, 0xffffffff);
    let (x308, x309) = fiat_p384_scalar_mulx_u32(x296, 0xffffffff);
    let (x310, x311) = fiat_p384_scalar_mulx_u32(x296, 0xc7634d81);
    let (x312, x313) = fiat_p384_scalar_mulx_u32(x296, 0xf4372ddf);
    let (x314, x315) = fiat_p384_scalar_mulx_u32(x296, 0x581a0db2);
    let (x316, x317) = fiat_p384_scalar_mulx_u32(x296, 0x48b0a77a);
    let (x318, x319) = fiat_p384_scalar_mulx_u32(x296, 0xecec196a);
    let (x320, x321) = fiat_p384_scalar_mulx_u32(x296, 0xccc52973);
    let (x322, x323) = fiat_p384_scalar_addcarryx_u32(0x0, x321, x318);
    let (x324, x325) = fiat_p384_scalar_addcarryx_u32(x323, x319, x316);
    let (x326, x327) = fiat_p384_scalar_addcarryx_u32(x325, x317, x314);
    let (x328, x329) = fiat_p384_scalar_addcarryx_u32(x327, x315, x312);
    let (x330, x331) = fiat_p384_scalar_addcarryx_u32(x329, x313, x310);
    let (x332, x333) = fiat_p384_scalar_addcarryx_u32(x331, x311, x308);
    let (x334, x335) = fiat_p384_scalar_addcarryx_u32(x333, x309, x306);
    let (x336, x337) = fiat_p384_scalar_addcarryx_u32(x335, x307, x304);
    let (x338, x339) = fiat_p384_scalar_addcarryx_u32(x337, x305, x302);
    let (x340, x341) = fiat_p384_scalar_addcarryx_u32(x339, x303, x300);
    let (x342, x343) = fiat_p384_scalar_addcarryx_u32(x341, x301, x298);
    let (x344, x345) = fiat_p384_scalar_addcarryx_u32(0x0, x272, x320);
    let (x346, x347) = fiat_p384_scalar_addcarryx_u32(x345, x274, x322);
    let (x348, x349) = fiat_p384_scalar_addcarryx_u32(x347, x276, x324);
    let (x350, x351) = fiat_p384_scalar_addcarryx_u32(x349, x278, x326);
    let (x352, x353) = fiat_p384_scalar_addcarryx_u32(x351, x280, x328);
    let (x354, x355) = fiat_p384_scalar_addcarryx_u32(x353, x282, x330);
    let (x356, x357) = fiat_p384_scalar_addcarryx_u32(x355, x284, x332);
    let (x358, x359) = fiat_p384_scalar_addcarryx_u32(x357, x286, x334);
    let (x360, x361) = fiat_p384_scalar_addcarryx_u32(x359, x288, x336);
    let (x362, x363) = fiat_p384_scalar_addcarryx_u32(x361, x290, x338);
    let (x364, x365) = fiat_p384_scalar_addcarryx_u32(x363, x292, x340);
    let (x366, x367) = fiat_p384_scalar_addcarryx_u32(x365, x294, x342);
    let (x368, x369) = fiat_p384_scalar_addcarryx_u32(
        x367,
        ((x295 as u32) + (x271 as u32)),
        ((x343 as u32) + x299),
    );
    let (x370, x371) = fiat_p384_scalar_addcarryx_u32(0x0, x346, (arg1[4]));
    let (x372, x373) = fiat_p384_scalar_addcarryx_u32(x371, x348, (0x0 as u32));
    let (x374, x375) = fiat_p384_scalar_addcarryx_u32(x373, x350, (0x0 as u32));
    let (x376, x377) = fiat_p384_scalar_addcarryx_u32(x375, x352, (0x0 as u32));
    let (x378, x379) = fiat_p384_scalar_addcarryx_u32(x377, x354, (0x0 as u32));
    let (x380, x381) = fiat_p384_scalar_addcarryx_u32(x379, x356, (0x0 as u32));
    let (x382, x383) = fiat_p384_scalar_addcarryx_u32(x381, x358, (0x0 as u32));
    let (x384, x385) = fiat_p384_scalar_addcarryx_u32(x383, x360, (0x0 as u32));
    let (x386, x387) = fiat_p384_scalar_addcarryx_u32(x385, x362, (0x0 as u32));
    let (x388, x389) = fiat_p384_scalar_addcarryx_u32(x387, x364, (0x0 as u32));
    let (x390, x391) = fiat_p384_scalar_addcarryx_u32(x389, x366, (0x0 as u32));
    let (x392, x393) = fiat_p384_scalar_addcarryx_u32(x391, x368, (0x0 as u32));
    let (x394, x395) = fiat_p384_scalar_mulx_u32(x370, 0xe88fdc45);
    let (x396, x397) = fiat_p384_scalar_mulx_u32(x394, 0xffffffff);
    let (x398, x399) = fiat_p384_scalar_mulx_u32(x394, 0xffffffff);
    let (x400, x401) = fiat_p384_scalar_mulx_u32(x394, 0xffffffff);
    let (x402, x403) = fiat_p384_scalar_mulx_u32(x394, 0xffffffff);
    let (x404, x405) = fiat_p384_scalar_mulx_u32(x394, 0xffffffff);
    let (x406, x407) = fiat_p384_scalar_mulx_u32(x394, 0xffffffff);
    let (x408, x409) = fiat_p384_scalar_mulx_u32(x394, 0xc7634d81);
    let (x410, x411) = fiat_p384_scalar_mulx_u32(x394, 0xf4372ddf);
    let (x412, x413) = fiat_p384_scalar_mulx_u32(x394, 0x581a0db2);
    let (x414, x415) = fiat_p384_scalar_mulx_u32(x394, 0x48b0a77a);
    let (x416, x417) = fiat_p384_scalar_mulx_u32(x394, 0xecec196a);
    let (x418, x419) = fiat_p384_scalar_mulx_u32(x394, 0xccc52973);
    let (x420, x421) = fiat_p384_scalar_addcarryx_u32(0x0, x419, x416);
    let (x422, x423) = fiat_p384_scalar_addcarryx_u32(x421, x417, x414);
    let (x424, x425) = fiat_p384_scalar_addcarryx_u32(x423, x415, x412);
    let (x426, x427) = fiat_p384_scalar_addcarryx_u32(x425, x413, x410);
    let (x428, x429) = fiat_p384_scalar_addcarryx_u32(x427, x411, x408);
    let (x430, x431) = fiat_p384_scalar_addcarryx_u32(x429, x409, x406);
    let (x432, x433) = fiat_p384_scalar_addcarryx_u32(x431, x407, x404);
    let (x434, x435) = fiat_p384_scalar_addcarryx_u32(x433, x405, x402);
    let (x436, x437) = fiat_p384_scalar_addcarryx_u32(x435, x403, x400);
    let (x438, x439) = fiat_p384_scalar_addcarryx_u32(x437, x401, x398);
    let (x440, x441) = fiat_p384_scalar_addcarryx_u32(x439, x399, x396);
    let (x442, x443) = fiat_p384_scalar_addcarryx_u32(0x0, x370, x418);
    let (x444, x445) = fiat_p384_scalar_addcarryx_u32(x443, x372, x420);
    let (x446, x447) = fiat_p384_scalar_addcarryx_u32(x445, x374, x422);
    let (x448, x449) = fiat_p384_scalar_addcarryx_u32(x447, x376, x424);
    let (x450, x451) = fiat_p384_scalar_addcarryx_u32(x449, x378, x426);
    let (x452, x453) = fiat_p384_scalar_addcarryx_u32(x451, x380, x428);
    let (x454, x455) = fiat_p384_scalar_addcarryx_u32(x453, x382, x430);
    let (x456, x457) = fiat_p384_scalar_addcarryx_u32(x455, x384, x432);
    let (x458, x459) = fiat_p384_scalar_addcarryx_u32(x457, x386, x434);
    let (x460, x461) = fiat_p384_scalar_addcarryx_u32(x459, x388, x436);
    let (x462, x463) = fiat_p384_scalar_addcarryx_u32(x461, x390, x438);
    let (x464, x465) = fiat_p384_scalar_addcarryx_u32(x463, x392, x440);
    let (x466, x467) = fiat_p384_scalar_addcarryx_u32(
        x465,
        ((x393 as u32) + (x369 as u32)),
        ((x441 as u32) + x397),
    );
    let (x468, x469) = fiat_p384_scalar_addcarryx_u32(0x0, x444, (arg1[5]));
    let (x470, x471) = fiat_p384_scalar_addcarryx_u32(x469, x446, (0x0 as u32));
    let (x472, x473) = fiat_p384_scalar_addcarryx_u32(x471, x448, (0x0 as u32));
    let (x474, x475) = fiat_p384_scalar_addcarryx_u32(x473, x450, (0x0 as u32));
    let (x476, x477) = fiat_p384_scalar_addcarryx_u32(x475, x452, (0x0 as u32));
    let (x478, x479) = fiat_p384_scalar_addcarryx_u32(x477, x454, (0x0 as u32));
    let (x480, x481) = fiat_p384_scalar_addcarryx_u32(x479, x456, (0x0 as u32));
    let (x482, x483) = fiat_p384_scalar_addcarryx_u32(x481, x458, (0x0 as u32));
    let (x484, x485) = fiat_p384_scalar_addcarryx_u32(x483, x460, (0x0 as u32));
    let (x486, x487) = fiat_p384_scalar_addcarryx_u32(x485, x462, (0x0 as u32));
    let (x488, x489) = fiat_p384_scalar_addcarryx_u32(x487, x464, (0x0 as u32));
    let (x490, x491) = fiat_p384_scalar_addcarryx_u32(x489, x466, (0x0 as u32));
    let (x492, x493) = fiat_p384_scalar_mulx_u32(x468, 0xe88fdc45);
    let (x494, x495) = fiat_p384_scalar_mulx_u32(x492, 0xffffffff);
    let (x496, x497) = fiat_p384_scalar_mulx_u32(x492, 0xffffffff);
    let (x498, x499) = fiat_p384_scalar_mulx_u32(x492, 0xffffffff);
    let (x500, x501) = fiat_p384_scalar_mulx_u32(x492, 0xffffffff);
    let (x502, x503) = fiat_p384_scalar_mulx_u32(x492, 0xffffffff);
    let (x504, x505) = fiat_p384_scalar_mulx_u32(x492, 0xffffffff);
    let (x506, x507) = fiat_p384_scalar_mulx_u32(x492, 0xc7634d81);
    let (x508, x509) = fiat_p384_scalar_mulx_u32(x492, 0xf4372ddf);
    let (x510, x511) = fiat_p384_scalar_mulx_u32(x492, 0x581a0db2);
    let (x512, x513) = fiat_p384_scalar_mulx_u32(x492, 0x48b0a77a);
    let (x514, x515) = fiat_p384_scalar_mulx_u32(x492, 0xecec196a);
    let (x516, x517) = fiat_p384_scalar_mulx_u32(x492, 0xccc52973);
    let (x518, x519) = fiat_p384_scalar_addcarryx_u32(0x0, x517, x514);
    let (x520, x521) = fiat_p384_scalar_addcarryx_u32(x519, x515, x512);
    let (x522, x523) = fiat_p384_scalar_addcarryx_u32(x521, x513, x510);
    let (x524, x525) = fiat_p384_scalar_addcarryx_u32(x523, x511, x508);
    let (x526, x527) = fiat_p384_scalar_addcarryx_u32(x525, x509, x506);
    let (x528, x529) = fiat_p384_scalar_addcarryx_u32(x527, x507, x504);
    let (x530, x531) = fiat_p384_scalar_addcarryx_u32(x529, x505, x502);
    let (x532, x533) = fiat_p384_scalar_addcarryx_u32(x531, x503, x500);
    let (x534, x535) = fiat_p384_scalar_addcarryx_u32(x533, x501, x498);
    let (x536, x537) = fiat_p384_scalar_addcarryx_u32(x535, x499, x496);
    let (x538, x539) = fiat_p384_scalar_addcarryx_u32(x537, x497, x494);
    let (x540, x541) = fiat_p384_scalar_addcarryx_u32(0x0, x468, x516);
    let (x542, x543) = fiat_p384_scalar_addcarryx_u32(x541, x470, x518);
    let (x544, x545) = fiat_p384_scalar_addcarryx_u32(x543, x472, x520);
    let (x546, x547) = fiat_p384_scalar_addcarryx_u32(x545, x474, x522);
    let (x548, x549) = fiat_p384_scalar_addcarryx_u32(x547, x476, x524);
    let (x550, x551) = fiat_p384_scalar_addcarryx_u32(x549, x478, x526);
    let (x552, x553) = fiat_p384_scalar_addcarryx_u32(x551, x480, x528);
    let (x554, x555) = fiat_p384_scalar_addcarryx_u32(x553, x482, x530);
    let (x556, x557) = fiat_p384_scalar_addcarryx_u32(x555, x484, x532);
    let (x558, x559) = fiat_p384_scalar_addcarryx_u32(x557, x486, x534);
    let (x560, x561) = fiat_p384_scalar_addcarryx_u32(x559, x488, x536);
    let (x562, x563) = fiat_p384_scalar_addcarryx_u32(x561, x490, x538);
    let (x564, x565) = fiat_p384_scalar_addcarryx_u32(
        x563,
        ((x491 as u32) + (x467 as u32)),
        ((x539 as u32) + x495),
    );
    let (x566, x567) = fiat_p384_scalar_addcarryx_u32(0x0, x542, (arg1[6]));
    let (x568, x569) = fiat_p384_scalar_addcarryx_u32(x567, x544, (0x0 as u32));
    let (x570, x571) = fiat_p384_scalar_addcarryx_u32(x569, x546, (0x0 as u32));
    let (x572, x573) = fiat_p384_scalar_addcarryx_u32(x571, x548, (0x0 as u32));
    let (x574, x575) = fiat_p384_scalar_addcarryx_u32(x573, x550, (0x0 as u32));
    let (x576, x577) = fiat_p384_scalar_addcarryx_u32(x575, x552, (0x0 as u32));
    let (x578, x579) = fiat_p384_scalar_addcarryx_u32(x577, x554, (0x0 as u32));
    let (x580, x581) = fiat_p384_scalar_addcarryx_u32(x579, x556, (0x0 as u32));
    let (x582, x583) = fiat_p384_scalar_addcarryx_u32(x581, x558, (0x0 as u32));
    let (x584, x585) = fiat_p384_scalar_addcarryx_u32(x583, x560, (0x0 as u32));
    let (x586, x587) = fiat_p384_scalar_addcarryx_u32(x585, x562, (0x0 as u32));
    let (x588, x589) = fiat_p384_scalar_addcarryx_u32(x587, x564, (0x0 as u32));
    let (x590, x591) = fiat_p384_scalar_mulx_u32(x566, 0xe88fdc45);
    let (x592, x593) = fiat_p384_scalar_mulx_u32(x590, 0xffffffff);
    let (x594, x595) = fiat_p384_scalar_mulx_u32(x590, 0xffffffff);
    let (x596, x597) = fiat_p384_scalar_mulx_u32(x590, 0xffffffff);
    let (x598, x599) = fiat_p384_scalar_mulx_u32(x590, 0xffffffff);
    let (x600, x601) = fiat_p384_scalar_mulx_u32(x590, 0xffffffff);
    let (x602, x603) = fiat_p384_scalar_mulx_u32(x590, 0xffffffff);
    let (x604, x605) = fiat_p384_scalar_mulx_u32(x590, 0xc7634d81);
    let (x606, x607) = fiat_p384_scalar_mulx_u32(x590, 0xf4372ddf);
    let (x608, x609) = fiat_p384_scalar_mulx_u32(x590, 0x581a0db2);
    let (x610, x611) = fiat_p384_scalar_mulx_u32(x590, 0x48b0a77a);
    let (x612, x613) = fiat_p384_scalar_mulx_u32(x590, 0xecec196a);
    let (x614, x615) = fiat_p384_scalar_mulx_u32(x590, 0xccc52973);
    let (x616, x617) = fiat_p384_scalar_addcarryx_u32(0x0, x615, x612);
    let (x618, x619) = fiat_p384_scalar_addcarryx_u32(x617, x613, x610);
    let (x620, x621) = fiat_p384_scalar_addcarryx_u32(x619, x611, x608);
    let (x622, x623) = fiat_p384_scalar_addcarryx_u32(x621, x609, x606);
    let (x624, x625) = fiat_p384_scalar_addcarryx_u32(x623, x607, x604);
    let (x626, x627) = fiat_p384_scalar_addcarryx_u32(x625, x605, x602);
    let (x628, x629) = fiat_p384_scalar_addcarryx_u32(x627, x603, x600);
    let (x630, x631) = fiat_p384_scalar_addcarryx_u32(x629, x601, x598);
    let (x632, x633) = fiat_p384_scalar_addcarryx_u32(x631, x599, x596);
    let (x634, x635) = fiat_p384_scalar_addcarryx_u32(x633, x597, x594);
    let (x636, x637) = fiat_p384_scalar_addcarryx_u32(x635, x595, x592);
    let (x638, x639) = fiat_p384_scalar_addcarryx_u32(0x0, x566, x614);
    let (x640, x641) = fiat_p384_scalar_addcarryx_u32(x639, x568, x616);
    let (x642, x643) = fiat_p384_scalar_addcarryx_u32(x641, x570, x618);
    let (x644, x645) = fiat_p384_scalar_addcarryx_u32(x643, x572, x620);
    let (x646, x647) = fiat_p384_scalar_addcarryx_u32(x645, x574, x622);
    let (x648, x649) = fiat_p384_scalar_addcarryx_u32(x647, x576, x624);
    let (x650, x651) = fiat_p384_scalar_addcarryx_u32(x649, x578, x626);
    let (x652, x653) = fiat_p384_scalar_addcarryx_u32(x651, x580, x628);
    let (x654, x655) = fiat_p384_scalar_addcarryx_u32(x653, x582, x630);
    let (x656, x657) = fiat_p384_scalar_addcarryx_u32(x655, x584, x632);
    let (x658, x659) = fiat_p384_scalar_addcarryx_u32(x657, x586, x634);
    let (x660, x661) = fiat_p384_scalar_addcarryx_u32(x659, x588, x636);
    let (x662, x663) = fiat_p384_scalar_addcarryx_u32(
        x661,
        ((x589 as u32) + (x565 as u32)),
        ((x637 as u32) + x593),
    );
    let (x664, x665) = fiat_p384_scalar_addcarryx_u32(0x0, x640, (arg1[7]));
    let (x666, x667) = fiat_p384_scalar_addcarryx_u32(x665, x642, (0x0 as u32));
    let (x668, x669) = fiat_p384_scalar_addcarryx_u32(x667, x644, (0x0 as u32));
    let (x670, x671) = fiat_p384_scalar_addcarryx_u32(x669, x646, (0x0 as u32));
    let (x672, x673) = fiat_p384_scalar_addcarryx_u32(x671, x648, (0x0 as u32));
    let (x674, x675) = fiat_p384_scalar_addcarryx_u32(x673, x650, (0x0 as u32));
    let (x676, x677) = fiat_p384_scalar_addcarryx_u32(x675, x652, (0x0 as u32));
    let (x678, x679) = fiat_p384_scalar_addcarryx_u32(x677, x654, (0x0 as u32));
    let (x680, x681) = fiat_p384_scalar_addcarryx_u32(x679, x656, (0x0 as u32));
    let (x682, x683) = fiat_p384_scalar_addcarryx_u32(x681, x658, (0x0 as u32));
    let (x684, x685) = fiat_p384_scalar_addcarryx_u32(x683, x660, (0x0 as u32));
    let (x686, x687) = fiat_p384_scalar_addcarryx_u32(x685, x662, (0x0 as u32));
    let (x688, x689) = fiat_p384_scalar_mulx_u32(x664, 0xe88fdc45);
    let (x690, x691) = fiat_p384_scalar_mulx_u32(x688, 0xffffffff);
    let (x692, x693) = fiat_p384_scalar_mulx_u32(x688, 0xffffffff);
    let (x694, x695) = fiat_p384_scalar_mulx_u32(x688, 0xffffffff);
    let (x696, x697) = fiat_p384_scalar_mulx_u32(x688, 0xffffffff);
    let (x698, x699) = fiat_p384_scalar_mulx_u32(x688, 0xffffffff);
    let (x700, x701) = fiat_p384_scalar_mulx_u32(x688, 0xffffffff);
    let (x702, x703) = fiat_p384_scalar_mulx_u32(x688, 0xc7634d81);
    let (x704, x705) = fiat_p384_scalar_mulx_u32(x688, 0xf4372ddf);
    let (x706, x707) = fiat_p384_scalar_mulx_u32(x688, 0x581a0db2);
    let (x708, x709) = fiat_p384_scalar_mulx_u32(x688, 0x48b0a77a);
    let (x710, x711) = fiat_p384_scalar_mulx_u32(x688, 0xecec196a);
    let (x712, x713) = fiat_p384_scalar_mulx_u32(x688, 0xccc52973);
    let (x714, x715) = fiat_p384_scalar_addcarryx_u32(0x0, x713, x710);
    let (x716, x717) = fiat_p384_scalar_addcarryx_u32(x715, x711, x708);
    let (x718, x719) = fiat_p384_scalar_addcarryx_u32(x717, x709, x706);
    let (x720, x721) = fiat_p384_scalar_addcarryx_u32(x719, x707, x704);
    let (x722, x723) = fiat_p384_scalar_addcarryx_u32(x721, x705, x702);
    let (x724, x725) = fiat_p384_scalar_addcarryx_u32(x723, x703, x700);
    let (x726, x727) = fiat_p384_scalar_addcarryx_u32(x725, x701, x698);
    let (x728, x729) = fiat_p384_scalar_addcarryx_u32(x727, x699, x696);
    let (x730, x731) = fiat_p384_scalar_addcarryx_u32(x729, x697, x694);
    let (x732, x733) = fiat_p384_scalar_addcarryx_u32(x731, x695, x692);
    let (x734, x735) = fiat_p384_scalar_addcarryx_u32(x733, x693, x690);
    let (x736, x737) = fiat_p384_scalar_addcarryx_u32(0x0, x664, x712);
    let (x738, x739) = fiat_p384_scalar_addcarryx_u32(x737, x666, x714);
    let (x740, x741) = fiat_p384_scalar_addcarryx_u32(x739, x668, x716);
    let (x742, x743) = fiat_p384_scalar_addcarryx_u32(x741, x670, x718);
    let (x744, x745) = fiat_p384_scalar_addcarryx_u32(x743, x672, x720);
    let (x746, x747) = fiat_p384_scalar_addcarryx_u32(x745, x674, x722);
    let (x748, x749) = fiat_p384_scalar_addcarryx_u32(x747, x676, x724);
    let (x750, x751) = fiat_p384_scalar_addcarryx_u32(x749, x678, x726);
    let (x752, x753) = fiat_p384_scalar_addcarryx_u32(x751, x680, x728);
    let (x754, x755) = fiat_p384_scalar_addcarryx_u32(x753, x682, x730);
    let (x756, x757) = fiat_p384_scalar_addcarryx_u32(x755, x684, x732);
    let (x758, x759) = fiat_p384_scalar_addcarryx_u32(x757, x686, x734);
    let (x760, x761) = fiat_p384_scalar_addcarryx_u32(
        x759,
        ((x687 as u32) + (x663 as u32)),
        ((x735 as u32) + x691),
    );
    let (x762, x763) = fiat_p384_scalar_addcarryx_u32(0x0, x738, (arg1[8]));
    let (x764, x765) = fiat_p384_scalar_addcarryx_u32(x763, x740, (0x0 as u32));
    let (x766, x767) = fiat_p384_scalar_addcarryx_u32(x765, x742, (0x0 as u32));
    let (x768, x769) = fiat_p384_scalar_addcarryx_u32(x767, x744, (0x0 as u32));
    let (x770, x771) = fiat_p384_scalar_addcarryx_u32(x769, x746, (0x0 as u32));
    let (x772, x773) = fiat_p384_scalar_addcarryx_u32(x771, x748, (0x0 as u32));
    let (x774, x775) = fiat_p384_scalar_addcarryx_u32(x773, x750, (0x0 as u32));
    let (x776, x777) = fiat_p384_scalar_addcarryx_u32(x775, x752, (0x0 as u32));
    let (x778, x779) = fiat_p384_scalar_addcarryx_u32(x777, x754, (0x0 as u32));
    let (x780, x781) = fiat_p384_scalar_addcarryx_u32(x779, x756, (0x0 as u32));
    let (x782, x783) = fiat_p384_scalar_addcarryx_u32(x781, x758, (0x0 as u32));
    let (x784, x785) = fiat_p384_scalar_addcarryx_u32(x783, x760, (0x0 as u32));
    let (x786, x787) = fiat_p384_scalar_mulx_u32(x762, 0xe88fdc45);
    let (x788, x789) = fiat_p384_scalar_mulx_u32(x786, 0xffffffff);
    let (x790, x791) = fiat_p384_scalar_mulx_u32(x786, 0xffffffff);
    let (x792, x793) = fiat_p384_scalar_mulx_u32(x786, 0xffffffff);
    let (x794, x795) = fiat_p384_scalar_mulx_u32(x786, 0xffffffff);
    let (x796, x797) = fiat_p384_scalar_mulx_u32(x786, 0xffffffff);
    let (x798, x799) = fiat_p384_scalar_mulx_u32(x786, 0xffffffff);
    let (x800, x801) = fiat_p384_scalar_mulx_u32(x786, 0xc7634d81);
    let (x802, x803) = fiat_p384_scalar_mulx_u32(x786, 0xf4372ddf);
    let (x804, x805) = fiat_p384_scalar_mulx_u32(x786, 0x581a0db2);
    let (x806, x807) = fiat_p384_scalar_mulx_u32(x786, 0x48b0a77a);
    let (x808, x809) = fiat_p384_scalar_mulx_u32(x786, 0xecec196a);
    let (x810, x811) = fiat_p384_scalar_mulx_u32(x786, 0xccc52973);
    let (x812, x813) = fiat_p384_scalar_addcarryx_u32(0x0, x811, x808);
    let (x814, x815) = fiat_p384_scalar_addcarryx_u32(x813, x809, x806);
    let (x816, x817) = fiat_p384_scalar_addcarryx_u32(x815, x807, x804);
    let (x818, x819) = fiat_p384_scalar_addcarryx_u32(x817, x805, x802);
    let (x820, x821) = fiat_p384_scalar_addcarryx_u32(x819, x803, x800);
    let (x822, x823) = fiat_p384_scalar_addcarryx_u32(x821, x801, x798);
    let (x824, x825) = fiat_p384_scalar_addcarryx_u32(x823, x799, x796);
    let (x826, x827) = fiat_p384_scalar_addcarryx_u32(x825, x797, x794);
    let (x828, x829) = fiat_p384_scalar_addcarryx_u32(x827, x795, x792);
    let (x830, x831) = fiat_p384_scalar_addcarryx_u32(x829, x793, x790);
    let (x832, x833) = fiat_p384_scalar_addcarryx_u32(x831, x791, x788);
    let (x834, x835) = fiat_p384_scalar_addcarryx_u32(0x0, x762, x810);
    let (x836, x837) = fiat_p384_scalar_addcarryx_u32(x835, x764, x812);
    let (x838, x839) = fiat_p384_scalar_addcarryx_u32(x837, x766, x814);
    let (x840, x841) = fiat_p384_scalar_addcarryx_u32(x839, x768, x816);
    let (x842, x843) = fiat_p384_scalar_addcarryx_u32(x841, x770, x818);
    let (x844, x845) = fiat_p384_scalar_addcarryx_u32(x843, x772, x820);
    let (x846, x847) = fiat_p384_scalar_addcarryx_u32(x845, x774, x822);
    let (x848, x849) = fiat_p384_scalar_addcarryx_u32(x847, x776, x824);
    let (x850, x851) = fiat_p384_scalar_addcarryx_u32(x849, x778, x826);
    let (x852, x853) = fiat_p384_scalar_addcarryx_u32(x851, x780, x828);
    let (x854, x855) = fiat_p384_scalar_addcarryx_u32(x853, x782, x830);
    let (x856, x857) = fiat_p384_scalar_addcarryx_u32(x855, x784, x832);
    let (x858, x859) = fiat_p384_scalar_addcarryx_u32(
        x857,
        ((x785 as u32) + (x761 as u32)),
        ((x833 as u32) + x789),
    );
    let (x860, x861) = fiat_p384_scalar_addcarryx_u32(0x0, x836, (arg1[9]));
    let (x862, x863) = fiat_p384_scalar_addcarryx_u32(x861, x838, (0x0 as u32));
    let (x864, x865) = fiat_p384_scalar_addcarryx_u32(x863, x840, (0x0 as u32));
    let (x866, x867) = fiat_p384_scalar_addcarryx_u32(x865, x842, (0x0 as u32));
    let (x868, x869) = fiat_p384_scalar_addcarryx_u32(x867, x844, (0x0 as u32));
    let (x870, x871) = fiat_p384_scalar_addcarryx_u32(x869, x846, (0x0 as u32));
    let (x872, x873) = fiat_p384_scalar_addcarryx_u32(x871, x848, (0x0 as u32));
    let (x874, x875) = fiat_p384_scalar_addcarryx_u32(x873, x850, (0x0 as u32));
    let (x876, x877) = fiat_p384_scalar_addcarryx_u32(x875, x852, (0x0 as u32));
    let (x878, x879) = fiat_p384_scalar_addcarryx_u32(x877, x854, (0x0 as u32));
    let (x880, x881) = fiat_p384_scalar_addcarryx_u32(x879, x856, (0x0 as u32));
    let (x882, x883) = fiat_p384_scalar_addcarryx_u32(x881, x858, (0x0 as u32));
    let (x884, x885) = fiat_p384_scalar_mulx_u32(x860, 0xe88fdc45);
    let (x886, x887) = fiat_p384_scalar_mulx_u32(x884, 0xffffffff);
    let (x888, x889) = fiat_p384_scalar_mulx_u32(x884, 0xffffffff);
    let (x890, x891) = fiat_p384_scalar_mulx_u32(x884, 0xffffffff);
    let (x892, x893) = fiat_p384_scalar_mulx_u32(x884, 0xffffffff);
    let (x894, x895) = fiat_p384_scalar_mulx_u32(x884, 0xffffffff);
    let (x896, x897) = fiat_p384_scalar_mulx_u32(x884, 0xffffffff);
    let (x898, x899) = fiat_p384_scalar_mulx_u32(x884, 0xc7634d81);
    let (x900, x901) = fiat_p384_scalar_mulx_u32(x884, 0xf4372ddf);
    let (x902, x903) = fiat_p384_scalar_mulx_u32(x884, 0x581a0db2);
    let (x904, x905) = fiat_p384_scalar_mulx_u32(x884, 0x48b0a77a);
    let (x906, x907) = fiat_p384_scalar_mulx_u32(x884, 0xecec196a);
    let (x908, x909) = fiat_p384_scalar_mulx_u32(x884, 0xccc52973);
    let (x910, x911) = fiat_p384_scalar_addcarryx_u32(0x0, x909, x906);
    let (x912, x913) = fiat_p384_scalar_addcarryx_u32(x911, x907, x904);
    let (x914, x915) = fiat_p384_scalar_addcarryx_u32(x913, x905, x902);
    let (x916, x917) = fiat_p384_scalar_addcarryx_u32(x915, x903, x900);
    let (x918, x919) = fiat_p384_scalar_addcarryx_u32(x917, x901, x898);
    let (x920, x921) = fiat_p384_scalar_addcarryx_u32(x919, x899, x896);
    let (x922, x923) = fiat_p384_scalar_addcarryx_u32(x921, x897, x894);
    let (x924, x925) = fiat_p384_scalar_addcarryx_u32(x923, x895, x892);
    let (x926, x927) = fiat_p384_scalar_addcarryx_u32(x925, x893, x890);
    let (x928, x929) = fiat_p384_scalar_addcarryx_u32(x927, x891, x888);
    let (x930, x931) = fiat_p384_scalar_addcarryx_u32(x929, x889, x886);
    let (x932, x933) = fiat_p384_scalar_addcarryx_u32(0x0, x860, x908);
    let (x934, x935) = fiat_p384_scalar_addcarryx_u32(x933, x862, x910);
    let (x936, x937) = fiat_p384_scalar_addcarryx_u32(x935, x864, x912);
    let (x938, x939) = fiat_p384_scalar_addcarryx_u32(x937, x866, x914);
    let (x940, x941) = fiat_p384_scalar_addcarryx_u32(x939, x868, x916);
    let (x942, x943) = fiat_p384_scalar_addcarryx_u32(x941, x870, x918);
    let (x944, x945) = fiat_p384_scalar_addcarryx_u32(x943, x872, x920);
    let (x946, x947) = fiat_p384_scalar_addcarryx_u32(x945, x874, x922);
    let (x948, x949) = fiat_p384_scalar_addcarryx_u32(x947, x876, x924);
    let (x950, x951) = fiat_p384_scalar_addcarryx_u32(x949, x878, x926);
    let (x952, x953) = fiat_p384_scalar_addcarryx_u32(x951, x880, x928);
    let (x954, x955) = fiat_p384_scalar_addcarryx_u32(x953, x882, x930);
    let (x956, x957) = fiat_p384_scalar_addcarryx_u32(
        x955,
        ((x883 as u32) + (x859 as u32)),
        ((x931 as u32) + x887),
    );
    let (x958, x959) = fiat_p384_scalar_addcarryx_u32(0x0, x934, (arg1[10]));
    let (x960, x961) = fiat_p384_scalar_addcarryx_u32(x959, x936, (0x0 as u32));
    let (x962, x963) = fiat_p384_scalar_addcarryx_u32(x961, x938, (0x0 as u32));
    let (x964, x965) = fiat_p384_scalar_addcarryx_u32(x963, x940, (0x0 as u32));
    let (x966, x967) = fiat_p384_scalar_addcarryx_u32(x965, x942, (0x0 as u32));
    let (x968, x969) = fiat_p384_scalar_addcarryx_u32(x967, x944, (0x0 as u32));
    let (x970, x971) = fiat_p384_scalar_addcarryx_u32(x969, x946, (0x0 as u32));
    let (x972, x973) = fiat_p384_scalar_addcarryx_u32(x971, x948, (0x0 as u32));
    let (x974, x975) = fiat_p384_scalar_addcarryx_u32(x973, x950, (0x0 as u32));
    let (x976, x977) = fiat_p384_scalar_addcarryx_u32(x975, x952, (0x0 as u32));
    let (x978, x979) = fiat_p384_scalar_addcarryx_u32(x977, x954, (0x0 as u32));
    let (x980, x981) = fiat_p384_scalar_addcarryx_u32(x979, x956, (0x0 as u32));
    let (x982, x983) = fiat_p384_scalar_mulx_u32(x958, 0xe88fdc45);
    let (x984, x985) = fiat_p384_scalar_mulx_u32(x982, 0xffffffff);
    let (x986, x987) = fiat_p384_scalar_mulx_u32(x982, 0xffffffff);
    let (x988, x989) = fiat_p384_scalar_mulx_u32(x982, 0xffffffff);
    let (x990, x991) = fiat_p384_scalar_mulx_u32(x982, 0xffffffff);
    let (x992, x993) = fiat_p384_scalar_mulx_u32(x982, 0xffffffff);
    let (x994, x995) = fiat_p384_scalar_mulx_u32(x982, 0xffffffff);
    let (x996, x997) = fiat_p384_scalar_mulx_u32(x982, 0xc7634d81);
    let (x998, x999) = fiat_p384_scalar_mulx_u32(x982, 0xf4372ddf);
    let (x1000, x1001) = fiat_p384_scalar_mulx_u32(x982, 0x581a0db2);
    let (x1002, x1003) = fiat_p384_scalar_mulx_u32(x982, 0x48b0a77a);
    let (x1004, x1005) = fiat_p384_scalar_mulx_u32(x982, 0xecec196a);
    let (x1006, x1007) = fiat_p384_scalar_mulx_u32(x982, 0xccc52973);
    let (x1008, x1009) = fiat_p384_scalar_addcarryx_u32(0x0, x1007, x1004);
    let (x1010, x1011) = fiat_p384_scalar_addcarryx_u32(x1009, x1005, x1002);
    let (x1012, x1013) = fiat_p384_scalar_addcarryx_u32(x1011, x1003, x1000);
    let (x1014, x1015) = fiat_p384_scalar_addcarryx_u32(x1013, x1001, x998);
    let (x1016, x1017) = fiat_p384_scalar_addcarryx_u32(x1015, x999, x996);
    let (x1018, x1019) = fiat_p384_scalar_addcarryx_u32(x1017, x997, x994);
    let (x1020, x1021) = fiat_p384_scalar_addcarryx_u32(x1019, x995, x992);
    let (x1022, x1023) = fiat_p384_scalar_addcarryx_u32(x1021, x993, x990);
    let (x1024, x1025) = fiat_p384_scalar_addcarryx_u32(x1023, x991, x988);
    let (x1026, x1027) = fiat_p384_scalar_addcarryx_u32(x1025, x989, x986);
    let (x1028, x1029) = fiat_p384_scalar_addcarryx_u32(x1027, x987, x984);
    let (x1030, x1031) = fiat_p384_scalar_addcarryx_u32(0x0, x958, x1006);
    let (x1032, x1033) = fiat_p384_scalar_addcarryx_u32(x1031, x960, x1008);
    let (x1034, x1035) = fiat_p384_scalar_addcarryx_u32(x1033, x962, x1010);
    let (x1036, x1037) = fiat_p384_scalar_addcarryx_u32(x1035, x964, x1012);
    let (x1038, x1039) = fiat_p384_scalar_addcarryx_u32(x1037, x966, x1014);
    let (x1040, x1041) = fiat_p384_scalar_addcarryx_u32(x1039, x968, x1016);
    let (x1042, x1043) = fiat_p384_scalar_addcarryx_u32(x1041, x970, x1018);
    let (x1044, x1045) = fiat_p384_scalar_addcarryx_u32(x1043, x972, x1020);
    let (x1046, x1047) = fiat_p384_scalar_addcarryx_u32(x1045, x974, x1022);
    let (x1048, x1049) = fiat_p384_scalar_addcarryx_u32(x1047, x976, x1024);
    let (x1050, x1051) = fiat_p384_scalar_addcarryx_u32(x1049, x978, x1026);
    let (x1052, x1053) = fiat_p384_scalar_addcarryx_u32(x1051, x980, x1028);
    let (x1054, x1055) = fiat_p384_scalar_addcarryx_u32(
        x1053,
        ((x981 as u32) + (x957 as u32)),
        ((x1029 as u32) + x985),
    );
    let (x1056, x1057) = fiat_p384_scalar_addcarryx_u32(0x0, x1032, (arg1[11]));
    let (x1058, x1059) = fiat_p384_scalar_addcarryx_u32(x1057, x1034, (0x0 as u32));
    let (x1060, x1061) = fiat_p384_scalar_addcarryx_u32(x1059, x1036, (0x0 as u32));
    let (x1062, x1063) = fiat_p384_scalar_addcarryx_u32(x1061, x1038, (0x0 as u32));
    let (x1064, x1065) = fiat_p384_scalar_addcarryx_u32(x1063, x1040, (0x0 as u32));
    let (x1066, x1067) = fiat_p384_scalar_addcarryx_u32(x1065, x1042, (0x0 as u32));
    let (x1068, x1069) = fiat_p384_scalar_addcarryx_u32(x1067, x1044, (0x0 as u32));
    let (x1070, x1071) = fiat_p384_scalar_addcarryx_u32(x1069, x1046, (0x0 as u32));
    let (x1072, x1073) = fiat_p384_scalar_addcarryx_u32(x1071, x1048, (0x0 as u32));
    let (x1074, x1075) = fiat_p384_scalar_addcarryx_u32(x1073, x1050, (0x0 as u32));
    let (x1076, x1077) = fiat_p384_scalar_addcarryx_u32(x1075, x1052, (0x0 as u32));
    let (x1078, x1079) = fiat_p384_scalar_addcarryx_u32(x1077, x1054, (0x0 as u32));
    let (x1080, x1081) = fiat_p384_scalar_mulx_u32(x1056, 0xe88fdc45);
    let (x1082, x1083) = fiat_p384_scalar_mulx_u32(x1080, 0xffffffff);
    let (x1084, x1085) = fiat_p384_scalar_mulx_u32(x1080, 0xffffffff);
    let (x1086, x1087) = fiat_p384_scalar_mulx_u32(x1080, 0xffffffff);
    let (x1088, x1089) = fiat_p384_scalar_mulx_u32(x1080, 0xffffffff);
    let (x1090, x1091) = fiat_p384_scalar_mulx_u32(x1080, 0xffffffff);
    let (x1092, x1093) = fiat_p384_scalar_mulx_u32(x1080, 0xffffffff);
    let (x1094, x1095) = fiat_p384_scalar_mulx_u32(x1080, 0xc7634d81);
    let (x1096, x1097) = fiat_p384_scalar_mulx_u32(x1080, 0xf4372ddf);
    let (x1098, x1099) = fiat_p384_scalar_mulx_u32(x1080, 0x581a0db2);
    let (x1100, x1101) = fiat_p384_scalar_mulx_u32(x1080, 0x48b0a77a);
    let (x1102, x1103) = fiat_p384_scalar_mulx_u32(x1080, 0xecec196a);
    let (x1104, x1105) = fiat_p384_scalar_mulx_u32(x1080, 0xccc52973);
    let (x1106, x1107) = fiat_p384_scalar_addcarryx_u32(0x0, x1105, x1102);
    let (x1108, x1109) = fiat_p384_scalar_addcarryx_u32(x1107, x1103, x1100);
    let (x1110, x1111) = fiat_p384_scalar_addcarryx_u32(x1109, x1101, x1098);
    let (x1112, x1113) = fiat_p384_scalar_addcarryx_u32(x1111, x1099, x1096);
    let (x1114, x1115) = fiat_p384_scalar_addcarryx_u32(x1113, x1097, x1094);
    let (x1116, x1117) = fiat_p384_scalar_addcarryx_u32(x1115, x1095, x1092);
    let (x1118, x1119) = fiat_p384_scalar_addcarryx_u32(x1117, x1093, x1090);
    let (x1120, x1121) = fiat_p384_scalar_addcarryx_u32(x1119, x1091, x1088);
    let (x1122, x1123) = fiat_p384_scalar_addcarryx_u32(x1121, x1089, x1086);
    let (x1124, x1125) = fiat_p384_scalar_addcarryx_u32(x1123, x1087, x1084);
    let (x1126, x1127) = fiat_p384_scalar_addcarryx_u32(x1125, x1085, x1082);
    let (x1128, x1129) = fiat_p384_scalar_addcarryx_u32(0x0, x1056, x1104);
    let (x1130, x1131) = fiat_p384_scalar_addcarryx_u32(x1129, x1058, x1106);
    let (x1132, x1133) = fiat_p384_scalar_addcarryx_u32(x1131, x1060, x1108);
    let (x1134, x1135) = fiat_p384_scalar_addcarryx_u32(x1133, x1062, x1110);
    let (x1136, x1137) = fiat_p384_scalar_addcarryx_u32(x1135, x1064, x1112);
    let (x1138, x1139) = fiat_p384_scalar_addcarryx_u32(x1137, x1066, x1114);
    let (x1140, x1141) = fiat_p384_scalar_addcarryx_u32(x1139, x1068, x1116);
    let (x1142, x1143) = fiat_p384_scalar_addcarryx_u32(x1141, x1070, x1118);
    let (x1144, x1145) = fiat_p384_scalar_addcarryx_u32(x1143, x1072, x1120);
    let (x1146, x1147) = fiat_p384_scalar_addcarryx_u32(x1145, x1074, x1122);
    let (x1148, x1149) = fiat_p384_scalar_addcarryx_u32(x1147, x1076, x1124);
    let (x1150, x1151) = fiat_p384_scalar_addcarryx_u32(x1149, x1078, x1126);
    let (x1152, x1153) = fiat_p384_scalar_addcarryx_u32(
        x1151,
        ((x1079 as u32) + (x1055 as u32)),
        ((x1127 as u32) + x1083),
    );
    let (x1154, x1155) = fiat_p384_scalar_subborrowx_u32(0x0, x1130, 0xccc52973);
    let (x1156, x1157) = fiat_p384_scalar_subborrowx_u32(x1155, x1132, 0xecec196a);
    let (x1158, x1159) = fiat_p384_scalar_subborrowx_u32(x1157, x1134, 0x48b0a77a);
    let (x1160, x1161) = fiat_p384_scalar_subborrowx_u32(x1159, x1136, 0x581a0db2);
    let (x1162, x1163) = fiat_p384_scalar_subborrowx_u32(x1161, x1138, 0xf4372ddf);
    let (x1164, x1165) = fiat_p384_scalar_subborrowx_u32(x1163, x1140, 0xc7634d81);
    let (x1166, x1167) = fiat_p384_scalar_subborrowx_u32(x1165, x1142, 0xffffffff);
    let (x1168, x1169) = fiat_p384_scalar_subborrowx_u32(x1167, x1144, 0xffffffff);
    let (x1170, x1171) = fiat_p384_scalar_subborrowx_u32(x1169, x1146, 0xffffffff);
    let (x1172, x1173) = fiat_p384_scalar_subborrowx_u32(x1171, x1148, 0xffffffff);
    let (x1174, x1175) = fiat_p384_scalar_subborrowx_u32(x1173, x1150, 0xffffffff);
    let (x1176, x1177) = fiat_p384_scalar_subborrowx_u32(x1175, x1152, 0xffffffff);
    let (x1178, x1179) = fiat_p384_scalar_subborrowx_u32(x1177, (x1153 as u32), (0x0 as u32));
    let (x1180) = fiat_p384_scalar_cmovznz_u32(x1179, x1154, x1130);
    let (x1181) = fiat_p384_scalar_cmovznz_u32(x1179, x1156, x1132);
    let (x1182) = fiat_p384_scalar_cmovznz_u32(x1179, x1158, x1134);
    let (x1183) = fiat_p384_scalar_cmovznz_u32(x1179, x1160, x1136);
    let (x1184) = fiat_p384_scalar_cmovznz_u32(x1179, x1162, x1138);
    let (x1185) = fiat_p384_scalar_cmovznz_u32(x1179, x1164, x1140);
    let (x1186) = fiat_p384_scalar_cmovznz_u32(x1179, x1166, x1142);
    let (x1187) = fiat_p384_scalar_cmovznz_u32(x1179, x1168, x1144);
    let (x1188) = fiat_p384_scalar_cmovznz_u32(x1179, x1170, x1146);
    let (x1189) = fiat_p384_scalar_cmovznz_u32(x1179, x1172, x1148);
    let (x1190) = fiat_p384_scalar_cmovznz_u32(x1179, x1174, x1150);
    let (x1191) = fiat_p384_scalar_cmovznz_u32(x1179, x1176, x1152);
    out1[0] = x1180;
    out1[1] = x1181;
    out1[2] = x1182;
    out1[3] = x1183;
    out1[4] = x1184;
    out1[5] = x1185;
    out1[6] = x1186;
    out1[7] = x1187;
    out1[8] = x1188;
    out1[9] = x1189;
    out1[10] = x1190;
    out1[11] = x1191;
    out1
}
#[doc = " The function fiat_p384_scalar_to_montgomery translates a field element into the Montgomery domain."]
#[doc = ""]
#[doc = " Preconditions:"]
#[doc = "   0 ≤ eval arg1 < m"]
#[doc = " Postconditions:"]
#[doc = "   eval (from_montgomery out1) mod m = eval arg1 mod m"]
#[doc = "   0 ≤ eval out1 < m"]
#[doc = ""]
#[inline]
pub const fn fiat_p384_scalar_to_montgomery(
    arg1: &fiat_p384_scalar_non_montgomery_domain_field_element,
) -> fiat_p384_scalar_montgomery_domain_field_element {
    let mut out1: fiat_p384_scalar_montgomery_domain_field_element = [0; 12];
    let x1: u32 = (arg1[1]);
    let x2: u32 = (arg1[2]);
    let x3: u32 = (arg1[3]);
    let x4: u32 = (arg1[4]);
    let x5: u32 = (arg1[5]);
    let x6: u32 = (arg1[6]);
    let x7: u32 = (arg1[7]);
    let x8: u32 = (arg1[8]);
    let x9: u32 = (arg1[9]);
    let x10: u32 = (arg1[10]);
    let x11: u32 = (arg1[11]);
    let x12: u32 = (arg1[0]);
    let (x13, x14) = fiat_p384_scalar_mulx_u32(x12, 0xc84ee01);
    let (x15, x16) = fiat_p384_scalar_mulx_u32(x12, 0x2b39bf21);
    let (x17, x18) = fiat_p384_scalar_mulx_u32(x12, 0x3fb05b7a);
    let (x19, x20) = fiat_p384_scalar_mulx_u32(x12, 0x28266895);
    let (x21, x22) = fiat_p384_scalar_mulx_u32(x12, 0xd40d4917);
    let (x23, x24) = fiat_p384_scalar_mulx_u32(x12, 0x4aab1cc5);
    let (x25, x26) = fiat_p384_scalar_mulx_u32(x12, 0xbc3e483a);
    let (x27, x28) = fiat_p384_scalar_mulx_u32(x12, 0xfcb82947);
    let (x29, x30) = fiat_p384_scalar_mulx_u32(x12, 0xff3d81e5);
    let (x31, x32) = fiat_p384_scalar_mulx_u32(x12, 0xdf1aa419);
    let (x33, x34) = fiat_p384_scalar_mulx_u32(x12, 0x2d319b24);
    let (x35, x36) = fiat_p384_scalar_mulx_u32(x12, 0x19b409a9);
    let (x37, x38) = fiat_p384_scalar_addcarryx_u32(0x0, x36, x33);
    let (x39, x40) = fiat_p384_scalar_addcarryx_u32(x38, x34, x31);
    let (x41, x42) = fiat_p384_scalar_addcarryx_u32(x40, x32, x29);
    let (x43, x44) = fiat_p384_scalar_addcarryx_u32(x42, x30, x27);
    let (x45, x46) = fiat_p384_scalar_addcarryx_u32(x44, x28, x25);
    let (x47, x48) = fiat_p384_scalar_addcarryx_u32(x46, x26, x23);
    let (x49, x50) = fiat_p384_scalar_addcarryx_u32(x48, x24, x21);
    let (x51, x52) = fiat_p384_scalar_addcarryx_u32(x50, x22, x19);
    let (x53, x54) = fiat_p384_scalar_addcarryx_u32(x52, x20, x17);
    let (x55, x56) = fiat_p384_scalar_addcarryx_u32(x54, x18, x15);
    let (x57, x58) = fiat_p384_scalar_addcarryx_u32(x56, x16, x13);
    let (x59, x60) = fiat_p384_scalar_mulx_u32(x35, 0xe88fdc45);
    let (x61, x62) = fiat_p384_scalar_mulx_u32(x59, 0xffffffff);
    let (x63, x64) = fiat_p384_scalar_mulx_u32(x59, 0xffffffff);
    let (x65, x66) = fiat_p384_scalar_mulx_u32(x59, 0xffffffff);
    let (x67, x68) = fiat_p384_scalar_mulx_u32(x59, 0xffffffff);
    let (x69, x70) = fiat_p384_scalar_mulx_u32(x59, 0xffffffff);
    let (x71, x72) = fiat_p384_scalar_mulx_u32(x59, 0xffffffff);
    let (x73, x74) = fiat_p384_scalar_mulx_u32(x59, 0xc7634d81);
    let (x75, x76) = fiat_p384_scalar_mulx_u32(x59, 0xf4372ddf);
    let (x77, x78) = fiat_p384_scalar_mulx_u32(x59, 0x581a0db2);
    let (x79, x80) = fiat_p384_scalar_mulx_u32(x59, 0x48b0a77a);
    let (x81, x82) = fiat_p384_scalar_mulx_u32(x59, 0xecec196a);
    let (x83, x84) = fiat_p384_scalar_mulx_u32(x59, 0xccc52973);
    let (x85, x86) = fiat_p384_scalar_addcarryx_u32(0x0, x84, x81);
    let (x87, x88) = fiat_p384_scalar_addcarryx_u32(x86, x82, x79);
    let (x89, x90) = fiat_p384_scalar_addcarryx_u32(x88, x80, x77);
    let (x91, x92) = fiat_p384_scalar_addcarryx_u32(x90, x78, x75);
    let (x93, x94) = fiat_p384_scalar_addcarryx_u32(x92, x76, x73);
    let (x95, x96) = fiat_p384_scalar_addcarryx_u32(x94, x74, x71);
    let (x97, x98) = fiat_p384_scalar_addcarryx_u32(x96, x72, x69);
    let (x99, x100) = fiat_p384_scalar_addcarryx_u32(x98, x70, x67);
    let (x101, x102) = fiat_p384_scalar_addcarryx_u32(x100, x68, x65);
    let (x103, x104) = fiat_p384_scalar_addcarryx_u32(x102, x66, x63);
    let (x105, x106) = fiat_p384_scalar_addcarryx_u32(x104, x64, x61);
    let (x107, x108) = fiat_p384_scalar_addcarryx_u32(0x0, x35, x83);
    let (x109, x110) = fiat_p384_scalar_addcarryx_u32(x108, x37, x85);
    let (x111, x112) = fiat_p384_scalar_addcarryx_u32(x110, x39, x87);
    let (x113, x114) = fiat_p384_scalar_addcarryx_u32(x112, x41, x89);
    let (x115, x116) = fiat_p384_scalar_addcarryx_u32(x114, x43, x91);
    let (x117, x118) = fiat_p384_scalar_addcarryx_u32(x116, x45, x93);
    let (x119, x120) = fiat_p384_scalar_addcarryx_u32(x118, x47, x95);
    let (x121, x122) = fiat_p384_scalar_addcarryx_u32(x120, x49, x97);
    let (x123, x124) = fiat_p384_scalar_addcarryx_u32(x122, x51, x99);
    let (x125, x126) = fiat_p384_scalar_addcarryx_u32(x124, x53, x101);
    let (x127, x128) = fiat_p384_scalar_addcarryx_u32(x126, x55, x103);
    let (x129, x130) = fiat_p384_scalar_addcarryx_u32(x128, x57, x105);
    let (x131, x132) =
        fiat_p384_scalar_addcarryx_u32(x130, ((x58 as u32) + x14), ((x106 as u32) + x62));
    let (x133, x134) = fiat_p384_scalar_mulx_u32(x1, 0xc84ee01);
    let (x135, x136) = fiat_p384_scalar_mulx_u32(x1, 0x2b39bf21);
    let (x137, x138) = fiat_p384_scalar_mulx_u32(x1, 0x3fb05b7a);
    let (x139, x140) = fiat_p384_scalar_mulx_u32(x1, 0x28266895);
    let (x141, x142) = fiat_p384_scalar_mulx_u32(x1, 0xd40d4917);
    let (x143, x144) = fiat_p384_scalar_mulx_u32(x1, 0x4aab1cc5);
    let (x145, x146) = fiat_p384_scalar_mulx_u32(x1, 0xbc3e483a);
    let (x147, x148) = fiat_p384_scalar_mulx_u32(x1, 0xfcb82947);
    let (x149, x150) = fiat_p384_scalar_mulx_u32(x1, 0xff3d81e5);
    let (x151, x152) = fiat_p384_scalar_mulx_u32(x1, 0xdf1aa419);
    let (x153, x154) = fiat_p384_scalar_mulx_u32(x1, 0x2d319b24);
    let (x155, x156) = fiat_p384_scalar_mulx_u32(x1, 0x19b409a9);
    let (x157, x158) = fiat_p384_scalar_addcarryx_u32(0x0, x156, x153);
    let (x159, x160) = fiat_p384_scalar_addcarryx_u32(x158, x154, x151);
    let (x161, x162) = fiat_p384_scalar_addcarryx_u32(x160, x152, x149);
    let (x163, x164) = fiat_p384_scalar_addcarryx_u32(x162, x150, x147);
    let (x165, x166) = fiat_p384_scalar_addcarryx_u32(x164, x148, x145);
    let (x167, x168) = fiat_p384_scalar_addcarryx_u32(x166, x146, x143);
    let (x169, x170) = fiat_p384_scalar_addcarryx_u32(x168, x144, x141);
    let (x171, x172) = fiat_p384_scalar_addcarryx_u32(x170, x142, x139);
    let (x173, x174) = fiat_p384_scalar_addcarryx_u32(x172, x140, x137);
    let (x175, x176) = fiat_p384_scalar_addcarryx_u32(x174, x138, x135);
    let (x177, x178) = fiat_p384_scalar_addcarryx_u32(x176, x136, x133);
    let (x179, x180) = fiat_p384_scalar_addcarryx_u32(0x0, x109, x155);
    let (x181, x182) = fiat_p384_scalar_addcarryx_u32(x180, x111, x157);
    let (x183, x184) = fiat_p384_scalar_addcarryx_u32(x182, x113, x159);
    let (x185, x186) = fiat_p384_scalar_addcarryx_u32(x184, x115, x161);
    let (x187, x188) = fiat_p384_scalar_addcarryx_u32(x186, x117, x163);
    let (x189, x190) = fiat_p384_scalar_addcarryx_u32(x188, x119, x165);
    let (x191, x192) = fiat_p384_scalar_addcarryx_u32(x190, x121, x167);
    let (x193, x194) = fiat_p384_scalar_addcarryx_u32(x192, x123, x169);
    let (x195, x196) = fiat_p384_scalar_addcarryx_u32(x194, x125, x171);
    let (x197, x198) = fiat_p384_scalar_addcarryx_u32(x196, x127, x173);
    let (x199, x200) = fiat_p384_scalar_addcarryx_u32(x198, x129, x175);
    let (x201, x202) = fiat_p384_scalar_addcarryx_u32(x200, x131, x177);
    let (x203, x204) = fiat_p384_scalar_mulx_u32(x179, 0xe88fdc45);
    let (x205, x206) = fiat_p384_scalar_mulx_u32(x203, 0xffffffff);
    let (x207, x208) = fiat_p384_scalar_mulx_u32(x203, 0xffffffff);
    let (x209, x210) = fiat_p384_scalar_mulx_u32(x203, 0xffffffff);
    let (x211, x212) = fiat_p384_scalar_mulx_u32(x203, 0xffffffff);
    let (x213, x214) = fiat_p384_scalar_mulx_u32(x203, 0xffffffff);
    let (x215, x216) = fiat_p384_scalar_mulx_u32(x203, 0xffffffff);
    let (x217, x218) = fiat_p384_scalar_mulx_u32(x203, 0xc7634d81);
    let (x219, x220) = fiat_p384_scalar_mulx_u32(x203, 0xf4372ddf);
    let (x221, x222) = fiat_p384_scalar_mulx_u32(x203, 0x581a0db2);
    let (x223, x224) = fiat_p384_scalar_mulx_u32(x203, 0x48b0a77a);
    let (x225, x226) = fiat_p384_scalar_mulx_u32(x203, 0xecec196a);
    let (x227, x228) = fiat_p384_scalar_mulx_u32(x203, 0xccc52973);
    let (x229, x230) = fiat_p384_scalar_addcarryx_u32(0x0, x228, x225);
    let (x231, x232) = fiat_p384_scalar_addcarryx_u32(x230, x226, x223);
    let (x233, x234) = fiat_p384_scalar_addcarryx_u32(x232, x224, x221);
    let (x235, x236) = fiat_p384_scalar_addcarryx_u32(x234, x222, x219);
    let (x237, x238) = fiat_p384_scalar_addcarryx_u32(x236, x220, x217);
    let (x239, x240) = fiat_p384_scalar_addcarryx_u32(x238, x218, x215);
    let (x241, x242) = fiat_p384_scalar_addcarryx_u32(x240, x216, x213);
    let (x243, x244) = fiat_p384_scalar_addcarryx_u32(x242, x214, x211);
    let (x245, x246) = fiat_p384_scalar_addcarryx_u32(x244, x212, x209);
    let (x247, x248) = fiat_p384_scalar_addcarryx_u32(x246, x210, x207);
    let (x249, x250) = fiat_p384_scalar_addcarryx_u32(x248, x208, x205);
    let (x251, x252) = fiat_p384_scalar_addcarryx_u32(0x0, x179, x227);
    let (x253, x254) = fiat_p384_scalar_addcarryx_u32(x252, x181, x229);
    let (x255, x256) = fiat_p384_scalar_addcarryx_u32(x254, x183, x231);
    let (x257, x258) = fiat_p384_scalar_addcarryx_u32(x256, x185, x233);
    let (x259, x260) = fiat_p384_scalar_addcarryx_u32(x258, x187, x235);
    let (x261, x262) = fiat_p384_scalar_addcarryx_u32(x260, x189, x237);
    let (x263, x264) = fiat_p384_scalar_addcarryx_u32(x262, x191, x239);
    let (x265, x266) = fiat_p384_scalar_addcarryx_u32(x264, x193, x241);
    let (x267, x268) = fiat_p384_scalar_addcarryx_u32(x266, x195, x243);
    let (x269, x270) = fiat_p384_scalar_addcarryx_u32(x268, x197, x245);
    let (x271, x272) = fiat_p384_scalar_addcarryx_u32(x270, x199, x247);
    let (x273, x274) = fiat_p384_scalar_addcarryx_u32(x272, x201, x249);
    let (x275, x276) = fiat_p384_scalar_addcarryx_u32(
        x274,
        (((x202 as u32) + (x132 as u32)) + ((x178 as u32) + x134)),
        ((x250 as u32) + x206),
    );
    let (x277, x278) = fiat_p384_scalar_mulx_u32(x2, 0xc84ee01);
    let (x279, x280) = fiat_p384_scalar_mulx_u32(x2, 0x2b39bf21);
    let (x281, x282) = fiat_p384_scalar_mulx_u32(x2, 0x3fb05b7a);
    let (x283, x284) = fiat_p384_scalar_mulx_u32(x2, 0x28266895);
    let (x285, x286) = fiat_p384_scalar_mulx_u32(x2, 0xd40d4917);
    let (x287, x288) = fiat_p384_scalar_mulx_u32(x2, 0x4aab1cc5);
    let (x289, x290) = fiat_p384_scalar_mulx_u32(x2, 0xbc3e483a);
    let (x291, x292) = fiat_p384_scalar_mulx_u32(x2, 0xfcb82947);
    let (x293, x294) = fiat_p384_scalar_mulx_u32(x2, 0xff3d81e5);
    let (x295, x296) = fiat_p384_scalar_mulx_u32(x2, 0xdf1aa419);
    let (x297, x298) = fiat_p384_scalar_mulx_u32(x2, 0x2d319b24);
    let (x299, x300) = fiat_p384_scalar_mulx_u32(x2, 0x19b409a9);
    let (x301, x302) = fiat_p384_scalar_addcarryx_u32(0x0, x300, x297);
    let (x303, x304) = fiat_p384_scalar_addcarryx_u32(x302, x298, x295);
    let (x305, x306) = fiat_p384_scalar_addcarryx_u32(x304, x296, x293);
    let (x307, x308) = fiat_p384_scalar_addcarryx_u32(x306, x294, x291);
    let (x309, x310) = fiat_p384_scalar_addcarryx_u32(x308, x292, x289);
    let (x311, x312) = fiat_p384_scalar_addcarryx_u32(x310, x290, x287);
    let (x313, x314) = fiat_p384_scalar_addcarryx_u32(x312, x288, x285);
    let (x315, x316) = fiat_p384_scalar_addcarryx_u32(x314, x286, x283);
    let (x317, x318) = fiat_p384_scalar_addcarryx_u32(x316, x284, x281);
    let (x319, x320) = fiat_p384_scalar_addcarryx_u32(x318, x282, x279);
    let (x321, x322) = fiat_p384_scalar_addcarryx_u32(x320, x280, x277);
    let (x323, x324) = fiat_p384_scalar_addcarryx_u32(0x0, x253, x299);
    let (x325, x326) = fiat_p384_scalar_addcarryx_u32(x324, x255, x301);
    let (x327, x328) = fiat_p384_scalar_addcarryx_u32(x326, x257, x303);
    let (x329, x330) = fiat_p384_scalar_addcarryx_u32(x328, x259, x305);
    let (x331, x332) = fiat_p384_scalar_addcarryx_u32(x330, x261, x307);
    let (x333, x334) = fiat_p384_scalar_addcarryx_u32(x332, x263, x309);
    let (x335, x336) = fiat_p384_scalar_addcarryx_u32(x334, x265, x311);
    let (x337, x338) = fiat_p384_scalar_addcarryx_u32(x336, x267, x313);
    let (x339, x340) = fiat_p384_scalar_addcarryx_u32(x338, x269, x315);
    let (x341, x342) = fiat_p384_scalar_addcarryx_u32(x340, x271, x317);
    let (x343, x344) = fiat_p384_scalar_addcarryx_u32(x342, x273, x319);
    let (x345, x346) = fiat_p384_scalar_addcarryx_u32(x344, x275, x321);
    let (x347, x348) = fiat_p384_scalar_mulx_u32(x323, 0xe88fdc45);
    let (x349, x350) = fiat_p384_scalar_mulx_u32(x347, 0xffffffff);
    let (x351, x352) = fiat_p384_scalar_mulx_u32(x347, 0xffffffff);
    let (x353, x354) = fiat_p384_scalar_mulx_u32(x347, 0xffffffff);
    let (x355, x356) = fiat_p384_scalar_mulx_u32(x347, 0xffffffff);
    let (x357, x358) = fiat_p384_scalar_mulx_u32(x347, 0xffffffff);
    let (x359, x360) = fiat_p384_scalar_mulx_u32(x347, 0xffffffff);
    let (x361, x362) = fiat_p384_scalar_mulx_u32(x347, 0xc7634d81);
    let (x363, x364) = fiat_p384_scalar_mulx_u32(x347, 0xf4372ddf);
    let (x365, x366) = fiat_p384_scalar_mulx_u32(x347, 0x581a0db2);
    let (x367, x368) = fiat_p384_scalar_mulx_u32(x347, 0x48b0a77a);
    let (x369, x370) = fiat_p384_scalar_mulx_u32(x347, 0xecec196a);
    let (x371, x372) = fiat_p384_scalar_mulx_u32(x347, 0xccc52973);
    let (x373, x374) = fiat_p384_scalar_addcarryx_u32(0x0, x372, x369);
    let (x375, x376) = fiat_p384_scalar_addcarryx_u32(x374, x370, x367);
    let (x377, x378) = fiat_p384_scalar_addcarryx_u32(x376, x368, x365);
    let (x379, x380) = fiat_p384_scalar_addcarryx_u32(x378, x366, x363);
    let (x381, x382) = fiat_p384_scalar_addcarryx_u32(x380, x364, x361);
    let (x383, x384) = fiat_p384_scalar_addcarryx_u32(x382, x362, x359);
    let (x385, x386) = fiat_p384_scalar_addcarryx_u32(x384, x360, x357);
    let (x387, x388) = fiat_p384_scalar_addcarryx_u32(x386, x358, x355);
    let (x389, x390) = fiat_p384_scalar_addcarryx_u32(x388, x356, x353);
    let (x391, x392) = fiat_p384_scalar_addcarryx_u32(x390, x354, x351);
    let (x393, x394) = fiat_p384_scalar_addcarryx_u32(x392, x352, x349);
    let (x395, x396) = fiat_p384_scalar_addcarryx_u32(0x0, x323, x371);
    let (x397, x398) = fiat_p384_scalar_addcarryx_u32(x396, x325, x373);
    let (x399, x400) = fiat_p384_scalar_addcarryx_u32(x398, x327, x375);
    let (x401, x402) = fiat_p384_scalar_addcarryx_u32(x400, x329, x377);
    let (x403, x404) = fiat_p384_scalar_addcarryx_u32(x402, x331, x379);
    let (x405, x406) = fiat_p384_scalar_addcarryx_u32(x404, x333, x381);
    let (x407, x408) = fiat_p384_scalar_addcarryx_u32(x406, x335, x383);
    let (x409, x410) = fiat_p384_scalar_addcarryx_u32(x408, x337, x385);
    let (x411, x412) = fiat_p384_scalar_addcarryx_u32(x410, x339, x387);
    let (x413, x414) = fiat_p384_scalar_addcarryx_u32(x412, x341, x389);
    let (x415, x416) = fiat_p384_scalar_addcarryx_u32(x414, x343, x391);
    let (x417, x418) = fiat_p384_scalar_addcarryx_u32(x416, x345, x393);
    let (x419, x420) = fiat_p384_scalar_addcarryx_u32(
        x418,
        (((x346 as u32) + (x276 as u32)) + ((x322 as u32) + x278)),
        ((x394 as u32) + x350),
    );
    let (x421, x422) = fiat_p384_scalar_mulx_u32(x3, 0xc84ee01);
    let (x423, x424) = fiat_p384_scalar_mulx_u32(x3, 0x2b39bf21);
    let (x425, x426) = fiat_p384_scalar_mulx_u32(x3, 0x3fb05b7a);
    let (x427, x428) = fiat_p384_scalar_mulx_u32(x3, 0x28266895);
    let (x429, x430) = fiat_p384_scalar_mulx_u32(x3, 0xd40d4917);
    let (x431, x432) = fiat_p384_scalar_mulx_u32(x3, 0x4aab1cc5);
    let (x433, x434) = fiat_p384_scalar_mulx_u32(x3, 0xbc3e483a);
    let (x435, x436) = fiat_p384_scalar_mulx_u32(x3, 0xfcb82947);
    let (x437, x438) = fiat_p384_scalar_mulx_u32(x3, 0xff3d81e5);
    let (x439, x440) = fiat_p384_scalar_mulx_u32(x3, 0xdf1aa419);
    let (x441, x442) = fiat_p384_scalar_mulx_u32(x3, 0x2d319b24);
    let (x443, x444) = fiat_p384_scalar_mulx_u32(x3, 0x19b409a9);
    let (x445, x446) = fiat_p384_scalar_addcarryx_u32(0x0, x444, x441);
    let (x447, x448) = fiat_p384_scalar_addcarryx_u32(x446, x442, x439);
    let (x449, x450) = fiat_p384_scalar_addcarryx_u32(x448, x440, x437);
    let (x451, x452) = fiat_p384_scalar_addcarryx_u32(x450, x438, x435);
    let (x453, x454) = fiat_p384_scalar_addcarryx_u32(x452, x436, x433);
    let (x455, x456) = fiat_p384_scalar_addcarryx_u32(x454, x434, x431);
    let (x457, x458) = fiat_p384_scalar_addcarryx_u32(x456, x432, x429);
    let (x459, x460) = fiat_p384_scalar_addcarryx_u32(x458, x430, x427);
    let (x461, x462) = fiat_p384_scalar_addcarryx_u32(x460, x428, x425);
    let (x463, x464) = fiat_p384_scalar_addcarryx_u32(x462, x426, x423);
    let (x465, x466) = fiat_p384_scalar_addcarryx_u32(x464, x424, x421);
    let (x467, x468) = fiat_p384_scalar_addcarryx_u32(0x0, x397, x443);
    let (x469, x470) = fiat_p384_scalar_addcarryx_u32(x468, x399, x445);
    let (x471, x472) = fiat_p384_scalar_addcarryx_u32(x470, x401, x447);
    let (x473, x474) = fiat_p384_scalar_addcarryx_u32(x472, x403, x449);
    let (x475, x476) = fiat_p384_scalar_addcarryx_u32(x474, x405, x451);
    let (x477, x478) = fiat_p384_scalar_addcarryx_u32(x476, x407, x453);
    let (x479, x480) = fiat_p384_scalar_addcarryx_u32(x478, x409, x455);
    let (x481, x482) = fiat_p384_scalar_addcarryx_u32(x480, x411, x457);
    let (x483, x484) = fiat_p384_scalar_addcarryx_u32(x482, x413, x459);
    let (x485, x486) = fiat_p384_scalar_addcarryx_u32(x484, x415, x461);
    let (x487, x488) = fiat_p384_scalar_addcarryx_u32(x486, x417, x463);
    let (x489, x490) = fiat_p384_scalar_addcarryx_u32(x488, x419, x465);
    let (x491, x492) = fiat_p384_scalar_mulx_u32(x467, 0xe88fdc45);
    let (x493, x494) = fiat_p384_scalar_mulx_u32(x491, 0xffffffff);
    let (x495, x496) = fiat_p384_scalar_mulx_u32(x491, 0xffffffff);
    let (x497, x498) = fiat_p384_scalar_mulx_u32(x491, 0xffffffff);
    let (x499, x500) = fiat_p384_scalar_mulx_u32(x491, 0xffffffff);
    let (x501, x502) = fiat_p384_scalar_mulx_u32(x491, 0xffffffff);
    let (x503, x504) = fiat_p384_scalar_mulx_u32(x491, 0xffffffff);
    let (x505, x506) = fiat_p384_scalar_mulx_u32(x491, 0xc7634d81);
    let (x507, x508) = fiat_p384_scalar_mulx_u32(x491, 0xf4372ddf);
    let (x509, x510) = fiat_p384_scalar_mulx_u32(x491, 0x581a0db2);
    let (x511, x512) = fiat_p384_scalar_mulx_u32(x491, 0x48b0a77a);
    let (x513, x514) = fiat_p384_scalar_mulx_u32(x491, 0xecec196a);
    let (x515, x516) = fiat_p384_scalar_mulx_u32(x491, 0xccc52973);
    let (x517, x518) = fiat_p384_scalar_addcarryx_u32(0x0, x516, x513);
    let (x519, x520) = fiat_p384_scalar_addcarryx_u32(x518, x514, x511);
    let (x521, x522) = fiat_p384_scalar_addcarryx_u32(x520, x512, x509);
    let (x523, x524) = fiat_p384_scalar_addcarryx_u32(x522, x510, x507);
    let (x525, x526) = fiat_p384_scalar_addcarryx_u32(x524, x508, x505);
    let (x527, x528) = fiat_p384_scalar_addcarryx_u32(x526, x506, x503);
    let (x529, x530) = fiat_p384_scalar_addcarryx_u32(x528, x504, x501);
    let (x531, x532) = fiat_p384_scalar_addcarryx_u32(x530, x502, x499);
    let (x533, x534) = fiat_p384_scalar_addcarryx_u32(x532, x500, x497);
    let (x535, x536) = fiat_p384_scalar_addcarryx_u32(x534, x498, x495);
    let (x537, x538) = fiat_p384_scalar_addcarryx_u32(x536, x496, x493);
    let (x539, x540) = fiat_p384_scalar_addcarryx_u32(0x0, x467, x515);
    let (x541, x542) = fiat_p384_scalar_addcarryx_u32(x540, x469, x517);
    let (x543, x544) = fiat_p384_scalar_addcarryx_u32(x542, x471, x519);
    let (x545, x546) = fiat_p384_scalar_addcarryx_u32(x544, x473, x521);
    let (x547, x548) = fiat_p384_scalar_addcarryx_u32(x546, x475, x523);
    let (x549, x550) = fiat_p384_scalar_addcarryx_u32(x548, x477, x525);
    let (x551, x552) = fiat_p384_scalar_addcarryx_u32(x550, x479, x527);
    let (x553, x554) = fiat_p384_scalar_addcarryx_u32(x552, x481, x529);
    let (x555, x556) = fiat_p384_scalar_addcarryx_u32(x554, x483, x531);
    let (x557, x558) = fiat_p384_scalar_addcarryx_u32(x556, x485, x533);
    let (x559, x560) = fiat_p384_scalar_addcarryx_u32(x558, x487, x535);
    let (x561, x562) = fiat_p384_scalar_addcarryx_u32(x560, x489, x537);
    let (x563, x564) = fiat_p384_scalar_addcarryx_u32(
        x562,
        (((x490 as u32) + (x420 as u32)) + ((x466 as u32) + x422)),
        ((x538 as u32) + x494),
    );
    let (x565, x566) = fiat_p384_scalar_mulx_u32(x4, 0xc84ee01);
    let (x567, x568) = fiat_p384_scalar_mulx_u32(x4, 0x2b39bf21);
    let (x569, x570) = fiat_p384_scalar_mulx_u32(x4, 0x3fb05b7a);
    let (x571, x572) = fiat_p384_scalar_mulx_u32(x4, 0x28266895);
    let (x573, x574) = fiat_p384_scalar_mulx_u32(x4, 0xd40d4917);
    let (x575, x576) = fiat_p384_scalar_mulx_u32(x4, 0x4aab1cc5);
    let (x577, x578) = fiat_p384_scalar_mulx_u32(x4, 0xbc3e483a);
    let (x579, x580) = fiat_p384_scalar_mulx_u32(x4, 0xfcb82947);
    let (x581, x582) = fiat_p384_scalar_mulx_u32(x4, 0xff3d81e5);
    let (x583, x584) = fiat_p384_scalar_mulx_u32(x4, 0xdf1aa419);
    let (x585, x586) = fiat_p384_scalar_mulx_u32(x4, 0x2d319b24);
    let (x587, x588) = fiat_p384_scalar_mulx_u32(x4, 0x19b409a9);
    let (x589, x590) = fiat_p384_scalar_addcarryx_u32(0x0, x588, x585);
    let (x591, x592) = fiat_p384_scalar_addcarryx_u32(x590, x586, x583);
    let (x593, x594) = fiat_p384_scalar_addcarryx_u32(x592, x584, x581);
    let (x595, x596) = fiat_p384_scalar_addcarryx_u32(x594, x582, x579);
    let (x597, x598) = fiat_p384_scalar_addcarryx_u32(x596, x580, x577);
    let (x599, x600) = fiat_p384_scalar_addcarryx_u32(x598, x578, x575);
    let (x601, x602) = fiat_p384_scalar_addcarryx_u32(x600, x576, x573);
    let (x603, x604) = fiat_p384_scalar_addcarryx_u32(x602, x574, x571);
    let (x605, x606) = fiat_p384_scalar_addcarryx_u32(x604, x572, x569);
    let (x607, x608) = fiat_p384_scalar_addcarryx_u32(x606, x570, x567);
    let (x609, x610) = fiat_p384_scalar_addcarryx_u32(x608, x568, x565);
    let (x611, x612) = fiat_p384_scalar_addcarryx_u32(0x0, x541, x587);
    let (x613, x614) = fiat_p384_scalar_addcarryx_u32(x612, x543, x589);
    let (x615, x616) = fiat_p384_scalar_addcarryx_u32(x614, x545, x591);
    let (x617, x618) = fiat_p384_scalar_addcarryx_u32(x616, x547, x593);
    let (x619, x620) = fiat_p384_scalar_addcarryx_u32(x618, x549, x595);
    let (x621, x622) = fiat_p384_scalar_addcarryx_u32(x620, x551, x597);
    let (x623, x624) = fiat_p384_scalar_addcarryx_u32(x622, x553, x599);
    let (x625, x626) = fiat_p384_scalar_addcarryx_u32(x624, x555, x601);
    let (x627, x628) = fiat_p384_scalar_addcarryx_u32(x626, x557, x603);
    let (x629, x630) = fiat_p384_scalar_addcarryx_u32(x628, x559, x605);
    let (x631, x632) = fiat_p384_scalar_addcarryx_u32(x630, x561, x607);
    let (x633, x634) = fiat_p384_scalar_addcarryx_u32(x632, x563, x609);
    let (x635, x636) = fiat_p384_scalar_mulx_u32(x611, 0xe88fdc45);
    let (x637, x638) = fiat_p384_scalar_mulx_u32(x635, 0xffffffff);
    let (x639, x640) = fiat_p384_scalar_mulx_u32(x635, 0xffffffff);
    let (x641, x642) = fiat_p384_scalar_mulx_u32(x635, 0xffffffff);
    let (x643, x644) = fiat_p384_scalar_mulx_u32(x635, 0xffffffff);
    let (x645, x646) = fiat_p384_scalar_mulx_u32(x635, 0xffffffff);
    let (x647, x648) = fiat_p384_scalar_mulx_u32(x635, 0xffffffff);
    let (x649, x650) = fiat_p384_scalar_mulx_u32(x635, 0xc7634d81);
    let (x651, x652) = fiat_p384_scalar_mulx_u32(x635, 0xf4372ddf);
    let (x653, x654) = fiat_p384_scalar_mulx_u32(x635, 0x581a0db2);
    let (x655, x656) = fiat_p384_scalar_mulx_u32(x635, 0x48b0a77a);
    let (x657, x658) = fiat_p384_scalar_mulx_u32(x635, 0xecec196a);
    let (x659, x660) = fiat_p384_scalar_mulx_u32(x635, 0xccc52973);
    let (x661, x662) = fiat_p384_scalar_addcarryx_u32(0x0, x660, x657);
    let (x663, x664) = fiat_p384_scalar_addcarryx_u32(x662, x658, x655);
    let (x665, x666) = fiat_p384_scalar_addcarryx_u32(x664, x656, x653);
    let (x667, x668) = fiat_p384_scalar_addcarryx_u32(x666, x654, x651);
    let (x669, x670) = fiat_p384_scalar_addcarryx_u32(x668, x652, x649);
    let (x671, x672) = fiat_p384_scalar_addcarryx_u32(x670, x650, x647);
    let (x673, x674) = fiat_p384_scalar_addcarryx_u32(x672, x648, x645);
    let (x675, x676) = fiat_p384_scalar_addcarryx_u32(x674, x646, x643);
    let (x677, x678) = fiat_p384_scalar_addcarryx_u32(x676, x644, x641);
    let (x679, x680) = fiat_p384_scalar_addcarryx_u32(x678, x642, x639);
    let (x681, x682) = fiat_p384_scalar_addcarryx_u32(x680, x640, x637);
    let (x683, x684) = fiat_p384_scalar_addcarryx_u32(0x0, x611, x659);
    let (x685, x686) = fiat_p384_scalar_addcarryx_u32(x684, x613, x661);
    let (x687, x688) = fiat_p384_scalar_addcarryx_u32(x686, x615, x663);
    let (x689, x690) = fiat_p384_scalar_addcarryx_u32(x688, x617, x665);
    let (x691, x692) = fiat_p384_scalar_addcarryx_u32(x690, x619, x667);
    let (x693, x694) = fiat_p384_scalar_addcarryx_u32(x692, x621, x669);
    let (x695, x696) = fiat_p384_scalar_addcarryx_u32(x694, x623, x671);
    let (x697, x698) = fiat_p384_scalar_addcarryx_u32(x696, x625, x673);
    let (x699, x700) = fiat_p384_scalar_addcarryx_u32(x698, x627, x675);
    let (x701, x702) = fiat_p384_scalar_addcarryx_u32(x700, x629, x677);
    let (x703, x704) = fiat_p384_scalar_addcarryx_u32(x702, x631, x679);
    let (x705, x706) = fiat_p384_scalar_addcarryx_u32(x704, x633, x681);
    let (x707, x708) = fiat_p384_scalar_addcarryx_u32(
        x706,
        (((x634 as u32) + (x564 as u32)) + ((x610 as u32) + x566)),
        ((x682 as u32) + x638),
    );
    let (x709, x710) = fiat_p384_scalar_mulx_u32(x5, 0xc84ee01);
    let (x711, x712) = fiat_p384_scalar_mulx_u32(x5, 0x2b39bf21);
    let (x713, x714) = fiat_p384_scalar_mulx_u32(x5, 0x3fb05b7a);
    let (x715, x716) = fiat_p384_scalar_mulx_u32(x5, 0x28266895);
    let (x717, x718) = fiat_p384_scalar_mulx_u32(x5, 0xd40d4917);
    let (x719, x720) = fiat_p384_scalar_mulx_u32(x5, 0x4aab1cc5);
    let (x721, x722) = fiat_p384_scalar_mulx_u32(x5, 0xbc3e483a);
    let (x723, x724) = fiat_p384_scalar_mulx_u32(x5, 0xfcb82947);
    let (x725, x726) = fiat_p384_scalar_mulx_u32(x5, 0xff3d81e5);
    let (x727, x728) = fiat_p384_scalar_mulx_u32(x5, 0xdf1aa419);
    let (x729, x730) = fiat_p384_scalar_mulx_u32(x5, 0x2d319b24);
    let (x731, x732) = fiat_p384_scalar_mulx_u32(x5, 0x19b409a9);
    let (x733, x734) = fiat_p384_scalar_addcarryx_u32(0x0, x732, x729);
    let (x735, x736) = fiat_p384_scalar_addcarryx_u32(x734, x730, x727);
    let (x737, x738) = fiat_p384_scalar_addcarryx_u32(x736, x728, x725);
    let (x739, x740) = fiat_p384_scalar_addcarryx_u32(x738, x726, x723);
    let (x741, x742) = fiat_p384_scalar_addcarryx_u32(x740, x724, x721);
    let (x743, x744) = fiat_p384_scalar_addcarryx_u32(x742, x722, x719);
    let (x745, x746) = fiat_p384_scalar_addcarryx_u32(x744, x720, x717);
    let (x747, x748) = fiat_p384_scalar_addcarryx_u32(x746, x718, x715);
    let (x749, x750) = fiat_p384_scalar_addcarryx_u32(x748, x716, x713);
    let (x751, x752) = fiat_p384_scalar_addcarryx_u32(x750, x714, x711);
    let (x753, x754) = fiat_p384_scalar_addcarryx_u32(x752, x712, x709);
    let (x755, x756) = fiat_p384_scalar_addcarryx_u32(0x0, x685, x731);
    let (x757, x758) = fiat_p384_scalar_addcarryx_u32(x756, x687, x733);
    let (x759, x760) = fiat_p384_scalar_addcarryx_u32(x758, x689, x735);
    let (x761, x762) = fiat_p384_scalar_addcarryx_u32(x760, x691, x737);
    let (x763, x764) = fiat_p384_scalar_addcarryx_u32(x762, x693, x739);
    let (x765, x766) = fiat_p384_scalar_addcarryx_u32(x764, x695, x741);
    let (x767, x768) = fiat_p384_scalar_addcarryx_u32(x766, x697, x743);
    let (x769, x770) = fiat_p384_scalar_addcarryx_u32(x768, x699, x745);
    let (x771, x772) = fiat_p384_scalar_addcarryx_u32(x770, x701, x747);
    let (x773, x774) = fiat_p384_scalar_addcarryx_u32(x772, x703, x749);
    let (x775, x776) = fiat_p384_scalar_addcarryx_u32(x774, x705, x751);
    let (x777, x778) = fiat_p384_scalar_addcarryx_u32(x776, x707, x753);
    let (x779, x780) = fiat_p384_scalar_mulx_u32(x755, 0xe88fdc45);
    let (x781, x782) = fiat_p384_scalar_mulx_u32(x779, 0xffffffff);
    let (x783, x784) = fiat_p384_scalar_mulx_u32(x779, 0xffffffff);
    let (x785, x786) = fiat_p384_scalar_mulx_u32(x779, 0xffffffff);
    let (x787, x788) = fiat_p384_scalar_mulx_u32(x779, 0xffffffff);
    let (x789, x790) = fiat_p384_scalar_mulx_u32(x779, 0xffffffff);
    let (x791, x792) = fiat_p384_scalar_mulx_u32(x779, 0xffffffff);
    let (x793, x794) = fiat_p384_scalar_mulx_u32(x779, 0xc7634d81);
    let (x795, x796) = fiat_p384_scalar_mulx_u32(x779, 0xf4372ddf);
    let (x797, x798) = fiat_p384_scalar_mulx_u32(x779, 0x581a0db2);
    let (x799, x800) = fiat_p384_scalar_mulx_u32(x779, 0x48b0a77a);
    let (x801, x802) = fiat_p384_scalar_mulx_u32(x779, 0xecec196a);
    let (x803, x804) = fiat_p384_scalar_mulx_u32(x779, 0xccc52973);
    let (x805, x806) = fiat_p384_scalar_addcarryx_u32(0x0, x804, x801);
    let (x807, x808) = fiat_p384_scalar_addcarryx_u32(x806, x802, x799);
    let (x809, x810) = fiat_p384_scalar_addcarryx_u32(x808, x800, x797);
    let (x811, x812) = fiat_p384_scalar_addcarryx_u32(x810, x798, x795);
    let (x813, x814) = fiat_p384_scalar_addcarryx_u32(x812, x796, x793);
    let (x815, x816) = fiat_p384_scalar_addcarryx_u32(x814, x794, x791);
    let (x817, x818) = fiat_p384_scalar_addcarryx_u32(x816, x792, x789);
    let (x819, x820) = fiat_p384_scalar_addcarryx_u32(x818, x790, x787);
    let (x821, x822) = fiat_p384_scalar_addcarryx_u32(x820, x788, x785);
    let (x823, x824) = fiat_p384_scalar_addcarryx_u32(x822, x786, x783);
    let (x825, x826) = fiat_p384_scalar_addcarryx_u32(x824, x784, x781);
    let (x827, x828) = fiat_p384_scalar_addcarryx_u32(0x0, x755, x803);
    let (x829, x830) = fiat_p384_scalar_addcarryx_u32(x828, x757, x805);
    let (x831, x832) = fiat_p384_scalar_addcarryx_u32(x830, x759, x807);
    let (x833, x834) = fiat_p384_scalar_addcarryx_u32(x832, x761, x809);
    let (x835, x836) = fiat_p384_scalar_addcarryx_u32(x834, x763, x811);
    let (x837, x838) = fiat_p384_scalar_addcarryx_u32(x836, x765, x813);
    let (x839, x840) = fiat_p384_scalar_addcarryx_u32(x838, x767, x815);
    let (x841, x842) = fiat_p384_scalar_addcarryx_u32(x840, x769, x817);
    let (x843, x844) = fiat_p384_scalar_addcarryx_u32(x842, x771, x819);
    let (x845, x846) = fiat_p384_scalar_addcarryx_u32(x844, x773, x821);
    let (x847, x848) = fiat_p384_scalar_addcarryx_u32(x846, x775, x823);
    let (x849, x850) = fiat_p384_scalar_addcarryx_u32(x848, x777, x825);
    let (x851, x852) = fiat_p384_scalar_addcarryx_u32(
        x850,
        (((x778 as u32) + (x708 as u32)) + ((x754 as u32) + x710)),
        ((x826 as u32) + x782),
    );
    let (x853, x854) = fiat_p384_scalar_mulx_u32(x6, 0xc84ee01);
    let (x855, x856) = fiat_p384_scalar_mulx_u32(x6, 0x2b39bf21);
    let (x857, x858) = fiat_p384_scalar_mulx_u32(x6, 0x3fb05b7a);
    let (x859, x860) = fiat_p384_scalar_mulx_u32(x6, 0x28266895);
    let (x861, x862) = fiat_p384_scalar_mulx_u32(x6, 0xd40d4917);
    let (x863, x864) = fiat_p384_scalar_mulx_u32(x6, 0x4aab1cc5);
    let (x865, x866) = fiat_p384_scalar_mulx_u32(x6, 0xbc3e483a);
    let (x867, x868) = fiat_p384_scalar_mulx_u32(x6, 0xfcb82947);
    let (x869, x870) = fiat_p384_scalar_mulx_u32(x6, 0xff3d81e5);
    let (x871, x872) = fiat_p384_scalar_mulx_u32(x6, 0xdf1aa419);
    let (x873, x874) = fiat_p384_scalar_mulx_u32(x6, 0x2d319b24);
    let (x875, x876) = fiat_p384_scalar_mulx_u32(x6, 0x19b409a9);
    let (x877, x878) = fiat_p384_scalar_addcarryx_u32(0x0, x876, x873);
    let (x879, x880) = fiat_p384_scalar_addcarryx_u32(x878, x874, x871);
    let (x881, x882) = fiat_p384_scalar_addcarryx_u32(x880, x872, x869);
    let (x883, x884) = fiat_p384_scalar_addcarryx_u32(x882, x870, x867);
    let (x885, x886) = fiat_p384_scalar_addcarryx_u32(x884, x868, x865);
    let (x887, x888) = fiat_p384_scalar_addcarryx_u32(x886, x866, x863);
    let (x889, x890) = fiat_p384_scalar_addcarryx_u32(x888, x864, x861);
    let (x891, x892) = fiat_p384_scalar_addcarryx_u32(x890, x862, x859);
    let (x893, x894) = fiat_p384_scalar_addcarryx_u32(x892, x860, x857);
    let (x895, x896) = fiat_p384_scalar_addcarryx_u32(x894, x858, x855);
    let (x897, x898) = fiat_p384_scalar_addcarryx_u32(x896, x856, x853);
    let (x899, x900) = fiat_p384_scalar_addcarryx_u32(0x0, x829, x875);
    let (x901, x902) = fiat_p384_scalar_addcarryx_u32(x900, x831, x877);
    let (x903, x904) = fiat_p384_scalar_addcarryx_u32(x902, x833, x879);
    let (x905, x906) = fiat_p384_scalar_addcarryx_u32(x904, x835, x881);
    let (x907, x908) = fiat_p384_scalar_addcarryx_u32(x906, x837, x883);
    let (x909, x910) = fiat_p384_scalar_addcarryx_u32(x908, x839, x885);
    let (x911, x912) = fiat_p384_scalar_addcarryx_u32(x910, x841, x887);
    let (x913, x914) = fiat_p384_scalar_addcarryx_u32(x912, x843, x889);
    let (x915, x916) = fiat_p384_scalar_addcarryx_u32(x914, x845, x891);
    let (x917, x918) = fiat_p384_scalar_addcarryx_u32(x916, x847, x893);
    let (x919, x920) = fiat_p384_scalar_addcarryx_u32(x918, x849, x895);
    let (x921, x922) = fiat_p384_scalar_addcarryx_u32(x920, x851, x897);
    let (x923, x924) = fiat_p384_scalar_mulx_u32(x899, 0xe88fdc45);
    let (x925, x926) = fiat_p384_scalar_mulx_u32(x923, 0xffffffff);
    let (x927, x928) = fiat_p384_scalar_mulx_u32(x923, 0xffffffff);
    let (x929, x930) = fiat_p384_scalar_mulx_u32(x923, 0xffffffff);
    let (x931, x932) = fiat_p384_scalar_mulx_u32(x923, 0xffffffff);
    let (x933, x934) = fiat_p384_scalar_mulx_u32(x923, 0xffffffff);
    let (x935, x936) = fiat_p384_scalar_mulx_u32(x923, 0xffffffff);
    let (x937, x938) = fiat_p384_scalar_mulx_u32(x923, 0xc7634d81);
    let (x939, x940) = fiat_p384_scalar_mulx_u32(x923, 0xf4372ddf);
    let (x941, x942) = fiat_p384_scalar_mulx_u32(x923, 0x581a0db2);
    let (x943, x944) = fiat_p384_scalar_mulx_u32(x923, 0x48b0a77a);
    let (x945, x946) = fiat_p384_scalar_mulx_u32(x923, 0xecec196a);
    let (x947, x948) = fiat_p384_scalar_mulx_u32(x923, 0xccc52973);
    let (x949, x950) = fiat_p384_scalar_addcarryx_u32(0x0, x948, x945);
    let (x951, x952) = fiat_p384_scalar_addcarryx_u32(x950, x946, x943);
    let (x953, x954) = fiat_p384_scalar_addcarryx_u32(x952, x944, x941);
    let (x955, x956) = fiat_p384_scalar_addcarryx_u32(x954, x942, x939);
    let (x957, x958) = fiat_p384_scalar_addcarryx_u32(x956, x940, x937);
    let (x959, x960) = fiat_p384_scalar_addcarryx_u32(x958, x938, x935);
    let (x961, x962) = fiat_p384_scalar_addcarryx_u32(x960, x936, x933);
    let (x963, x964) = fiat_p384_scalar_addcarryx_u32(x962, x934, x931);
    let (x965, x966) = fiat_p384_scalar_addcarryx_u32(x964, x932, x929);
    let (x967, x968) = fiat_p384_scalar_addcarryx_u32(x966, x930, x927);
    let (x969, x970) = fiat_p384_scalar_addcarryx_u32(x968, x928, x925);
    let (x971, x972) = fiat_p384_scalar_addcarryx_u32(0x0, x899, x947);
    let (x973, x974) = fiat_p384_scalar_addcarryx_u32(x972, x901, x949);
    let (x975, x976) = fiat_p384_scalar_addcarryx_u32(x974, x903, x951);
    let (x977, x978) = fiat_p384_scalar_addcarryx_u32(x976, x905, x953);
    let (x979, x980) = fiat_p384_scalar_addcarryx_u32(x978, x907, x955);
    let (x981, x982) = fiat_p384_scalar_addcarryx_u32(x980, x909, x957);
    let (x983, x984) = fiat_p384_scalar_addcarryx_u32(x982, x911, x959);
    let (x985, x986) = fiat_p384_scalar_addcarryx_u32(x984, x913, x961);
    let (x987, x988) = fiat_p384_scalar_addcarryx_u32(x986, x915, x963);
    let (x989, x990) = fiat_p384_scalar_addcarryx_u32(x988, x917, x965);
    let (x991, x992) = fiat_p384_scalar_addcarryx_u32(x990, x919, x967);
    let (x993, x994) = fiat_p384_scalar_addcarryx_u32(x992, x921, x969);
    let (x995, x996) = fiat_p384_scalar_addcarryx_u32(
        x994,
        (((x922 as u32) + (x852 as u32)) + ((x898 as u32) + x854)),
        ((x970 as u32) + x926),
    );
    let (x997, x998) = fiat_p384_scalar_mulx_u32(x7, 0xc84ee01);
    let (x999, x1000) = fiat_p384_scalar_mulx_u32(x7, 0x2b39bf21);
    let (x1001, x1002) = fiat_p384_scalar_mulx_u32(x7, 0x3fb05b7a);
    let (x1003, x1004) = fiat_p384_scalar_mulx_u32(x7, 0x28266895);
    let (x1005, x1006) = fiat_p384_scalar_mulx_u32(x7, 0xd40d4917);
    let (x1007, x1008) = fiat_p384_scalar_mulx_u32(x7, 0x4aab1cc5);
    let (x1009, x1010) = fiat_p384_scalar_mulx_u32(x7, 0xbc3e483a);
    let (x1011, x1012) = fiat_p384_scalar_mulx_u32(x7, 0xfcb82947);
    let (x1013, x1014) = fiat_p384_scalar_mulx_u32(x7, 0xff3d81e5);
    let (x1015, x1016) = fiat_p384_scalar_mulx_u32(x7, 0xdf1aa419);
    let (x1017, x1018) = fiat_p384_scalar_mulx_u32(x7, 0x2d319b24);
    let (x1019, x1020) = fiat_p384_scalar_mulx_u32(x7, 0x19b409a9);
    let (x1021, x1022) = fiat_p384_scalar_addcarryx_u32(0x0, x1020, x1017);
    let (x1023, x1024) = fiat_p384_scalar_addcarryx_u32(x1022, x1018, x1015);
    let (x1025, x1026) = fiat_p384_scalar_addcarryx_u32(x1024, x1016, x1013);
    let (x1027, x1028) = fiat_p384_scalar_addcarryx_u32(x1026, x1014, x1011);
    let (x1029, x1030) = fiat_p384_scalar_addcarryx_u32(x1028, x1012, x1009);
    let (x1031, x1032) = fiat_p384_scalar_addcarryx_u32(x1030, x1010, x1007);
    let (x1033, x1034) = fiat_p384_scalar_addcarryx_u32(x1032, x1008, x1005);
    let (x1035, x1036) = fiat_p384_scalar_addcarryx_u32(x1034, x1006, x1003);
    let (x1037, x1038) = fiat_p384_scalar_addcarryx_u32(x1036, x1004, x1001);
    let (x1039, x1040) = fiat_p384_scalar_addcarryx_u32(x1038, x1002, x999);
    let (x1041, x1042) = fiat_p384_scalar_addcarryx_u32(x1040, x1000, x997);
    let (x1043, x1044) = fiat_p384_scalar_addcarryx_u32(0x0, x973, x1019);
    let (x1045, x1046) = fiat_p384_scalar_addcarryx_u32(x1044, x975, x1021);
    let (x1047, x1048) = fiat_p384_scalar_addcarryx_u32(x1046, x977, x1023);
    let (x1049, x1050) = fiat_p384_scalar_addcarryx_u32(x1048, x979, x1025);
    let (x1051, x1052) = fiat_p384_scalar_addcarryx_u32(x1050, x981, x1027);
    let (x1053, x1054) = fiat_p384_scalar_addcarryx_u32(x1052, x983, x1029);
    let (x1055, x1056) = fiat_p384_scalar_addcarryx_u32(x1054, x985, x1031);
    let (x1057, x1058) = fiat_p384_scalar_addcarryx_u32(x1056, x987, x1033);
    let (x1059, x1060) = fiat_p384_scalar_addcarryx_u32(x1058, x989, x1035);
    let (x1061, x1062) = fiat_p384_scalar_addcarryx_u32(x1060, x991, x1037);
    let (x1063, x1064) = fiat_p384_scalar_addcarryx_u32(x1062, x993, x1039);
    let (x1065, x1066) = fiat_p384_scalar_addcarryx_u32(x1064, x995, x1041);
    let (x1067, x1068) = fiat_p384_scalar_mulx_u32(x1043, 0xe88fdc45);
    let (x1069, x1070) = fiat_p384_scalar_mulx_u32(x1067, 0xffffffff);
    let (x1071, x1072) = fiat_p384_scalar_mulx_u32(x1067, 0xffffffff);
    let (x1073, x1074) = fiat_p384_scalar_mulx_u32(x1067, 0xffffffff);
    let (x1075, x1076) = fiat_p384_scalar_mulx_u32(x1067, 0xffffffff);
    let (x1077, x1078) = fiat_p384_scalar_mulx_u32(x1067, 0xffffffff);
    let (x1079, x1080) = fiat_p384_scalar_mulx_u32(x1067, 0xffffffff);
    let (x1081, x1082) = fiat_p384_scalar_mulx_u32(x1067, 0xc7634d81);
    let (x1083, x1084) = fiat_p384_scalar_mulx_u32(x1067, 0xf4372ddf);
    let (x1085, x1086) = fiat_p384_scalar_mulx_u32(x1067, 0x581a0db2);
    let (x1087, x1088) = fiat_p384_scalar_mulx_u32(x1067, 0x48b0a77a);
    let (x1089, x1090) = fiat_p384_scalar_mulx_u32(x1067, 0xecec196a);
    let (x1091, x1092) = fiat_p384_scalar_mulx_u32(x1067, 0xccc52973);
    let (x1093, x1094) = fiat_p384_scalar_addcarryx_u32(0x0, x1092, x1089);
    let (x1095, x1096) = fiat_p384_scalar_addcarryx_u32(x1094, x1090, x1087);
    let (x1097, x1098) = fiat_p384_scalar_addcarryx_u32(x1096, x1088, x1085);
    let (x1099, x1100) = fiat_p384_scalar_addcarryx_u32(x1098, x1086, x1083);
    let (x1101, x1102) = fiat_p384_scalar_addcarryx_u32(x1100, x1084, x1081);
    let (x1103, x1104) = fiat_p384_scalar_addcarryx_u32(x1102, x1082, x1079);
    let (x1105, x1106) = fiat_p384_scalar_addcarryx_u32(x1104, x1080, x1077);
    let (x1107, x1108) = fiat_p384_scalar_addcarryx_u32(x1106, x1078, x1075);
    let (x1109, x1110) = fiat_p384_scalar_addcarryx_u32(x1108, x1076, x1073);
    let (x1111, x1112) = fiat_p384_scalar_addcarryx_u32(x1110, x1074, x1071);
    let (x1113, x1114) = fiat_p384_scalar_addcarryx_u32(x1112, x1072, x1069);
    let (x1115, x1116) = fiat_p384_scalar_addcarryx_u32(0x0, x1043, x1091);
    let (x1117, x1118) = fiat_p384_scalar_addcarryx_u32(x1116, x1045, x1093);
    let (x1119, x1120) = fiat_p384_scalar_addcarryx_u32(x1118, x1047, x1095);
    let (x1121, x1122) = fiat_p384_scalar_addcarryx_u32(x1120, x1049, x1097);
    let (x1123, x1124) = fiat_p384_scalar_addcarryx_u32(x1122, x1051, x1099);
    let (x1125, x1126) = fiat_p384_scalar_addcarryx_u32(x1124, x1053, x1101);
    let (x1127, x1128) = fiat_p384_scalar_addcarryx_u32(x1126, x1055, x1103);
    let (x1129, x1130) = fiat_p384_scalar_addcarryx_u32(x1128, x1057, x1105);
    let (x1131, x1132) = fiat_p384_scalar_addcarryx_u32(x1130, x1059, x1107);
    let (x1133, x1134) = fiat_p384_scalar_addcarryx_u32(x1132, x1061, x1109);
    let (x1135, x1136) = fiat_p384_scalar_addcarryx_u32(x1134, x1063, x1111);
    let (x1137, x1138) = fiat_p384_scalar_addcarryx_u32(x1136, x1065, x1113);
    let (x1139, x1140) = fiat_p384_scalar_addcarryx_u32(
        x1138,
        (((x1066 as u32) + (x996 as u32)) + ((x1042 as u32) + x998)),
        ((x1114 as u32) + x1070),
    );
    let (x1141, x1142) = fiat_p384_scalar_mulx_u32(x8, 0xc84ee01);
    let (x1143, x1144) = fiat_p384_scalar_mulx_u32(x8, 0x2b39bf21);
    let (x1145, x1146) = fiat_p384_scalar_mulx_u32(x8, 0x3fb05b7a);
    let (x1147, x1148) = fiat_p384_scalar_mulx_u32(x8, 0x28266895);
    let (x1149, x1150) = fiat_p384_scalar_mulx_u32(x8, 0xd40d4917);
    let (x1151, x1152) = fiat_p384_scalar_mulx_u32(x8, 0x4aab1cc5);
    let (x1153, x1154) = fiat_p384_scalar_mulx_u32(x8, 0xbc3e483a);
    let (x1155, x1156) = fiat_p384_scalar_mulx_u32(x8, 0xfcb82947);
    let (x1157, x1158) = fiat_p384_scalar_mulx_u32(x8, 0xff3d81e5);
    let (x1159, x1160) = fiat_p384_scalar_mulx_u32(x8, 0xdf1aa419);
    let (x1161, x1162) = fiat_p384_scalar_mulx_u32(x8, 0x2d319b24);
    let (x1163, x1164) = fiat_p384_scalar_mulx_u32(x8, 0x19b409a9);
    let (x1165, x1166) = fiat_p384_scalar_addcarryx_u32(0x0, x1164, x1161);
    let (x1167, x1168) = fiat_p384_scalar_addcarryx_u32(x1166, x1162, x1159);
    let (x1169, x1170) = fiat_p384_scalar_addcarryx_u32(x1168, x1160, x1157);
    let (x1171, x1172) = fiat_p384_scalar_addcarryx_u32(x1170, x1158, x1155);
    let (x1173, x1174) = fiat_p384_scalar_addcarryx_u32(x1172, x1156, x1153);
    let (x1175, x1176) = fiat_p384_scalar_addcarryx_u32(x1174, x1154, x1151);
    let (x1177, x1178) = fiat_p384_scalar_addcarryx_u32(x1176, x1152, x1149);
    let (x1179, x1180) = fiat_p384_scalar_addcarryx_u32(x1178, x1150, x1147);
    let (x1181, x1182) = fiat_p384_scalar_addcarryx_u32(x1180, x1148, x1145);
    let (x1183, x1184) = fiat_p384_scalar_addcarryx_u32(x1182, x1146, x1143);
    let (x1185, x1186) = fiat_p384_scalar_addcarryx_u32(x1184, x1144, x1141);
    let (x1187, x1188) = fiat_p384_scalar_addcarryx_u32(0x0, x1117, x1163);
    let (x1189, x1190) = fiat_p384_scalar_addcarryx_u32(x1188, x1119, x1165);
    let (x1191, x1192) = fiat_p384_scalar_addcarryx_u32(x1190, x1121, x1167);
    let (x1193, x1194) = fiat_p384_scalar_addcarryx_u32(x1192, x1123, x1169);
    let (x1195, x1196) = fiat_p384_scalar_addcarryx_u32(x1194, x1125, x1171);
    let (x1197, x1198) = fiat_p384_scalar_addcarryx_u32(x1196, x1127, x1173);
    let (x1199, x1200) = fiat_p384_scalar_addcarryx_u32(x1198, x1129, x1175);
    let (x1201, x1202) = fiat_p384_scalar_addcarryx_u32(x1200, x1131, x1177);
    let (x1203, x1204) = fiat_p384_scalar_addcarryx_u32(x1202, x1133, x1179);
    let (x1205, x1206) = fiat_p384_scalar_addcarryx_u32(x1204, x1135, x1181);
    let (x1207, x1208) = fiat_p384_scalar_addcarryx_u32(x1206, x1137, x1183);
    let (x1209, x1210) = fiat_p384_scalar_addcarryx_u32(x1208, x1139, x1185);
    let (x1211, x1212) = fiat_p384_scalar_mulx_u32(x1187, 0xe88fdc45);
    let (x1213, x1214) = fiat_p384_scalar_mulx_u32(x1211, 0xffffffff);
    let (x1215, x1216) = fiat_p384_scalar_mulx_u32(x1211, 0xffffffff);
    let (x1217, x1218) = fiat_p384_scalar_mulx_u32(x1211, 0xffffffff);
    let (x1219, x1220) = fiat_p384_scalar_mulx_u32(x1211, 0xffffffff);
    let (x1221, x1222) = fiat_p384_scalar_mulx_u32(x1211, 0xffffffff);
    let (x1223, x1224) = fiat_p384_scalar_mulx_u32(x1211, 0xffffffff);
    let (x1225, x1226) = fiat_p384_scalar_mulx_u32(x1211, 0xc7634d81);
    let (x1227, x1228) = fiat_p384_scalar_mulx_u32(x1211, 0xf4372ddf);
    let (x1229, x1230) = fiat_p384_scalar_mulx_u32(x1211, 0x581a0db2);
    let (x1231, x1232) = fiat_p384_scalar_mulx_u32(x1211, 0x48b0a77a);
    let (x1233, x1234) = fiat_p384_scalar_mulx_u32(x1211, 0xecec196a);
    let (x1235, x1236) = fiat_p384_scalar_mulx_u32(x1211, 0xccc52973);
    let (x1237, x1238) = fiat_p384_scalar_addcarryx_u32(0x0, x1236, x1233);
    let (x1239, x1240) = fiat_p384_scalar_addcarryx_u32(x1238, x1234, x1231);
    let (x1241, x1242) = fiat_p384_scalar_addcarryx_u32(x1240, x1232, x1229);
    let (x1243, x1244) = fiat_p384_scalar_addcarryx_u32(x1242, x1230, x1227);
    let (x1245, x1246) = fiat_p384_scalar_addcarryx_u32(x1244, x1228, x1225);
    let (x1247, x1248) = fiat_p384_scalar_addcarryx_u32(x1246, x1226, x1223);
    let (x1249, x1250) = fiat_p384_scalar_addcarryx_u32(x1248, x1224, x1221);
    let (x1251, x1252) = fiat_p384_scalar_addcarryx_u32(x1250, x1222, x1219);
    let (x1253, x1254) = fiat_p384_scalar_addcarryx_u32(x1252, x1220, x1217);
    let (x1255, x1256) = fiat_p384_scalar_addcarryx_u32(x1254, x1218, x1215);
    let (x1257, x1258) = fiat_p384_scalar_addcarryx_u32(x1256, x1216, x1213);
    let (x1259, x1260) = fiat_p384_scalar_addcarryx_u32(0x0, x1187, x1235);
    let (x1261, x1262) = fiat_p384_scalar_addcarryx_u32(x1260, x1189, x1237);
    let (x1263, x1264) = fiat_p384_scalar_addcarryx_u32(x1262, x1191, x1239);
    let (x1265, x1266) = fiat_p384_scalar_addcarryx_u32(x1264, x1193, x1241);
    let (x1267, x1268) = fiat_p384_scalar_addcarryx_u32(x1266, x1195, x1243);
    let (x1269, x1270) = fiat_p384_scalar_addcarryx_u32(x1268, x1197, x1245);
    let (x1271, x1272) = fiat_p384_scalar_addcarryx_u32(x1270, x1199, x1247);
    let (x1273, x1274) = fiat_p384_scalar_addcarryx_u32(x1272, x1201, x1249);
    let (x1275, x1276) = fiat_p384_scalar_addcarryx_u32(x1274, x1203, x1251);
    let (x1277, x1278) = fiat_p384_scalar_addcarryx_u32(x1276, x1205, x1253);
    let (x1279, x1280) = fiat_p384_scalar_addcarryx_u32(x1278, x1207, x1255);
    let (x1281, x1282) = fiat_p384_scalar_addcarryx_u32(x1280, x1209, x1257);
    let (x1283, x1284) = fiat_p384_scalar_addcarryx_u32(
        x1282,
        (((x1210 as u32) + (x1140 as u32)) + ((x1186 as u32) + x1142)),
        ((x1258 as u32) + x1214),
    );
    let (x1285, x1286) = fiat_p384_scalar_mulx_u32(x9, 0xc84ee01);
    let (x1287, x1288) = fiat_p384_scalar_mulx_u32(x9, 0x2b39bf21);
    let (x1289, x1290) = fiat_p384_scalar_mulx_u32(x9, 0x3fb05b7a);
    let (x1291, x1292) = fiat_p384_scalar_mulx_u32(x9, 0x28266895);
    let (x1293, x1294) = fiat_p384_scalar_mulx_u32(x9, 0xd40d4917);
    let (x1295, x1296) = fiat_p384_scalar_mulx_u32(x9, 0x4aab1cc5);
    let (x1297, x1298) = fiat_p384_scalar_mulx_u32(x9, 0xbc3e483a);
    let (x1299, x1300) = fiat_p384_scalar_mulx_u32(x9, 0xfcb82947);
    let (x1301, x1302) = fiat_p384_scalar_mulx_u32(x9, 0xff3d81e5);
    let (x1303, x1304) = fiat_p384_scalar_mulx_u32(x9, 0xdf1aa419);
    let (x1305, x1306) = fiat_p384_scalar_mulx_u32(x9, 0x2d319b24);
    let (x1307, x1308) = fiat_p384_scalar_mulx_u32(x9, 0x19b409a9);
    let (x1309, x1310) = fiat_p384_scalar_addcarryx_u32(0x0, x1308, x1305);
    let (x1311, x1312) = fiat_p384_scalar_addcarryx_u32(x1310, x1306, x1303);
    let (x1313, x1314) = fiat_p384_scalar_addcarryx_u32(x1312, x1304, x1301);
    let (x1315, x1316) = fiat_p384_scalar_addcarryx_u32(x1314, x1302, x1299);
    let (x1317, x1318) = fiat_p384_scalar_addcarryx_u32(x1316, x1300, x1297);
    let (x1319, x1320) = fiat_p384_scalar_addcarryx_u32(x1318, x1298, x1295);
    let (x1321, x1322) = fiat_p384_scalar_addcarryx_u32(x1320, x1296, x1293);
    let (x1323, x1324) = fiat_p384_scalar_addcarryx_u32(x1322, x1294, x1291);
    let (x1325, x1326) = fiat_p384_scalar_addcarryx_u32(x1324, x1292, x1289);
    let (x1327, x1328) = fiat_p384_scalar_addcarryx_u32(x1326, x1290, x1287);
    let (x1329, x1330) = fiat_p384_scalar_addcarryx_u32(x1328, x1288, x1285);
    let (x1331, x1332) = fiat_p384_scalar_addcarryx_u32(0x0, x1261, x1307);
    let (x1333, x1334) = fiat_p384_scalar_addcarryx_u32(x1332, x1263, x1309);
    let (x1335, x1336) = fiat_p384_scalar_addcarryx_u32(x1334, x1265, x1311);
    let (x1337, x1338) = fiat_p384_scalar_addcarryx_u32(x1336, x1267, x1313);
    let (x1339, x1340) = fiat_p384_scalar_addcarryx_u32(x1338, x1269, x1315);
    let (x1341, x1342) = fiat_p384_scalar_addcarryx_u32(x1340, x1271, x1317);
    let (x1343, x1344) = fiat_p384_scalar_addcarryx_u32(x1342, x1273, x1319);
    let (x1345, x1346) = fiat_p384_scalar_addcarryx_u32(x1344, x1275, x1321);
    let (x1347, x1348) = fiat_p384_scalar_addcarryx_u32(x1346, x1277, x1323);
    let (x1349, x1350) = fiat_p384_scalar_addcarryx_u32(x1348, x1279, x1325);
    let (x1351, x1352) = fiat_p384_scalar_addcarryx_u32(x1350, x1281, x1327);
    let (x1353, x1354) = fiat_p384_scalar_addcarryx_u32(x1352, x1283, x1329);
    let (x1355, x1356) = fiat_p384_scalar_mulx_u32(x1331, 0xe88fdc45);
    let (x1357, x1358) = fiat_p384_scalar_mulx_u32(x1355, 0xffffffff);
    let (x1359, x1360) = fiat_p384_scalar_mulx_u32(x1355, 0xffffffff);
    let (x1361, x1362) = fiat_p384_scalar_mulx_u32(x1355, 0xffffffff);
    let (x1363, x1364) = fiat_p384_scalar_mulx_u32(x1355, 0xffffffff);
    let (x1365, x1366) = fiat_p384_scalar_mulx_u32(x1355, 0xffffffff);
    let (x1367, x1368) = fiat_p384_scalar_mulx_u32(x1355, 0xffffffff);
    let (x1369, x1370) = fiat_p384_scalar_mulx_u32(x1355, 0xc7634d81);
    let (x1371, x1372) = fiat_p384_scalar_mulx_u32(x1355, 0xf4372ddf);
    let (x1373, x1374) = fiat_p384_scalar_mulx_u32(x1355, 0x581a0db2);
    let (x1375, x1376) = fiat_p384_scalar_mulx_u32(x1355, 0x48b0a77a);
    let (x1377, x1378) = fiat_p384_scalar_mulx_u32(x1355, 0xecec196a);
    let (x1379, x1380) = fiat_p384_scalar_mulx_u32(x1355, 0xccc52973);
    let (x1381, x1382) = fiat_p384_scalar_addcarryx_u32(0x0, x1380, x1377);
    let (x1383, x1384) = fiat_p384_scalar_addcarryx_u32(x1382, x1378, x1375);
    let (x1385, x1386) = fiat_p384_scalar_addcarryx_u32(x1384, x1376, x1373);
    let (x1387, x1388) = fiat_p384_scalar_addcarryx_u32(x1386, x1374, x1371);
    let (x1389, x1390) = fiat_p384_scalar_addcarryx_u32(x1388, x1372, x1369);
    let (x1391, x1392) = fiat_p384_scalar_addcarryx_u32(x1390, x1370, x1367);
    let (x1393, x1394) = fiat_p384_scalar_addcarryx_u32(x1392, x1368, x1365);
    let (x1395, x1396) = fiat_p384_scalar_addcarryx_u32(x1394, x1366, x1363);
    let (x1397, x1398) = fiat_p384_scalar_addcarryx_u32(x1396, x1364, x1361);
    let (x1399, x1400) = fiat_p384_scalar_addcarryx_u32(x1398, x1362, x1359);
    let (x1401, x1402) = fiat_p384_scalar_addcarryx_u32(x1400, x1360, x1357);
    let (x1403, x1404) = fiat_p384_scalar_addcarryx_u32(0x0, x1331, x1379);
    let (x1405, x1406) = fiat_p384_scalar_addcarryx_u32(x1404, x1333, x1381);
    let (x1407, x1408) = fiat_p384_scalar_addcarryx_u32(x1406, x1335, x1383);
    let (x1409, x1410) = fiat_p384_scalar_addcarryx_u32(x1408, x1337, x1385);
    let (x1411, x1412) = fiat_p384_scalar_addcarryx_u32(x1410, x1339, x1387);
    let (x1413, x1414) = fiat_p384_scalar_addcarryx_u32(x1412, x1341, x1389);
    let (x1415, x1416) = fiat_p384_scalar_addcarryx_u32(x1414, x1343, x1391);
    let (x1417, x1418) = fiat_p384_scalar_addcarryx_u32(x1416, x1345, x1393);
    let (x1419, x1420) = fiat_p384_scalar_addcarryx_u32(x1418, x1347, x1395);
    let (x1421, x1422) = fiat_p384_scalar_addcarryx_u32(x1420, x1349, x1397);
    let (x1423, x1424) = fiat_p384_scalar_addcarryx_u32(x1422, x1351, x1399);
    let (x1425, x1426) = fiat_p384_scalar_addcarryx_u32(x1424, x1353, x1401);
    let (x1427, x1428) = fiat_p384_scalar_addcarryx_u32(
        x1426,
        (((x1354 as u32) + (x1284 as u32)) + ((x1330 as u32) + x1286)),
        ((x1402 as u32) + x1358),
    );
    let (x1429, x1430) = fiat_p384_scalar_mulx_u32(x10, 0xc84ee01);
    let (x1431, x1432) = fiat_p384_scalar_mulx_u32(x10, 0x2b39bf21);
    let (x1433, x1434) = fiat_p384_scalar_mulx_u32(x10, 0x3fb05b7a);
    let (x1435, x1436) = fiat_p384_scalar_mulx_u32(x10, 0x28266895);
    let (x1437, x1438) = fiat_p384_scalar_mulx_u32(x10, 0xd40d4917);
    let (x1439, x1440) = fiat_p384_scalar_mulx_u32(x10, 0x4aab1cc5);
    let (x1441, x1442) = fiat_p384_scalar_mulx_u32(x10, 0xbc3e483a);
    let (x1443, x1444) = fiat_p384_scalar_mulx_u32(x10, 0xfcb82947);
    let (x1445, x1446) = fiat_p384_scalar_mulx_u32(x10, 0xff3d81e5);
    let (x1447, x1448) = fiat_p384_scalar_mulx_u32(x10, 0xdf1aa419);
    let (x1449, x1450) = fiat_p384_scalar_mulx_u32(x10, 0x2d319b24);
    let (x1451, x1452) = fiat_p384_scalar_mulx_u32(x10, 0x19b409a9);
    let (x1453, x1454) = fiat_p384_scalar_addcarryx_u32(0x0, x1452, x1449);
    let (x1455, x1456) = fiat_p384_scalar_addcarryx_u32(x1454, x1450, x1447);
    let (x1457, x1458) = fiat_p384_scalar_addcarryx_u32(x1456, x1448, x1445);
    let (x1459, x1460) = fiat_p384_scalar_addcarryx_u32(x1458, x1446, x1443);
    let (x1461, x1462) = fiat_p384_scalar_addcarryx_u32(x1460, x1444, x1441);
    let (x1463, x1464) = fiat_p384_scalar_addcarryx_u32(x1462, x1442, x1439);
    let (x1465, x1466) = fiat_p384_scalar_addcarryx_u32(x1464, x1440, x1437);
    let (x1467, x1468) = fiat_p384_scalar_addcarryx_u32(x1466, x1438, x1435);
    let (x1469, x1470) = fiat_p384_scalar_addcarryx_u32(x1468, x1436, x1433);
    let (x1471, x1472) = fiat_p384_scalar_addcarryx_u32(x1470, x1434, x1431);
    let (x1473, x1474) = fiat_p384_scalar_addcarryx_u32(x1472, x1432, x1429);
    let (x1475, x1476) = fiat_p384_scalar_addcarryx_u32(0x0, x1405, x1451);
    let (x1477, x1478) = fiat_p384_scalar_addcarryx_u32(x1476, x1407, x1453);
    let (x1479, x1480) = fiat_p384_scalar_addcarryx_u32(x1478, x1409, x1455);
    let (x1481, x1482) = fiat_p384_scalar_addcarryx_u32(x1480, x1411, x1457);
    let (x1483, x1484) = fiat_p384_scalar_addcarryx_u32(x1482, x1413, x1459);
    let (x1485, x1486) = fiat_p384_scalar_addcarryx_u32(x1484, x1415, x1461);
    let (x1487, x1488) = fiat_p384_scalar_addcarryx_u32(x1486, x1417, x1463);
    let (x1489, x1490) = fiat_p384_scalar_addcarryx_u32(x1488, x1419, x1465);
    let (x1491, x1492) = fiat_p384_scalar_addcarryx_u32(x1490, x1421, x1467);
    let (x1493, x1494) = fiat_p384_scalar_addcarryx_u32(x1492, x1423, x1469);
    let (x1495, x1496) = fiat_p384_scalar_addcarryx_u32(x1494, x1425, x1471);
    let (x1497, x1498) = fiat_p384_scalar_addcarryx_u32(x1496, x1427, x1473);
    let (x1499, x1500) = fiat_p384_scalar_mulx_u32(x1475, 0xe88fdc45);
    let (x1501, x1502) = fiat_p384_scalar_mulx_u32(x1499, 0xffffffff);
    let (x1503, x1504) = fiat_p384_scalar_mulx_u32(x1499, 0xffffffff);
    let (x1505, x1506) = fiat_p384_scalar_mulx_u32(x1499, 0xffffffff);
    let (x1507, x1508) = fiat_p384_scalar_mulx_u32(x1499, 0xffffffff);
    let (x1509, x1510) = fiat_p384_scalar_mulx_u32(x1499, 0xffffffff);
    let (x1511, x1512) = fiat_p384_scalar_mulx_u32(x1499, 0xffffffff);
    let (x1513, x1514) = fiat_p384_scalar_mulx_u32(x1499, 0xc7634d81);
    let (x1515, x1516) = fiat_p384_scalar_mulx_u32(x1499, 0xf4372ddf);
    let (x1517, x1518) = fiat_p384_scalar_mulx_u32(x1499, 0x581a0db2);
    let (x1519, x1520) = fiat_p384_scalar_mulx_u32(x1499, 0x48b0a77a);
    let (x1521, x1522) = fiat_p384_scalar_mulx_u32(x1499, 0xecec196a);
    let (x1523, x1524) = fiat_p384_scalar_mulx_u32(x1499, 0xccc52973);
    let (x1525, x1526) = fiat_p384_scalar_addcarryx_u32(0x0, x1524, x1521);
    let (x1527, x1528) = fiat_p384_scalar_addcarryx_u32(x1526, x1522, x1519);
    let (x1529, x1530) = fiat_p384_scalar_addcarryx_u32(x1528, x1520, x1517);
    let (x1531, x1532) = fiat_p384_scalar_addcarryx_u32(x1530, x1518, x1515);
    let (x1533, x1534) = fiat_p384_scalar_addcarryx_u32(x1532, x1516, x1513);
    let (x1535, x1536) = fiat_p384_scalar_addcarryx_u32(x1534, x1514, x1511);
    let (x1537, x1538) = fiat_p384_scalar_addcarryx_u32(x1536, x1512, x1509);
    let (x1539, x1540) = fiat_p384_scalar_addcarryx_u32(x1538, x1510, x1507);
    let (x1541, x1542) = fiat_p384_scalar_addcarryx_u32(x1540, x1508, x1505);
    let (x1543, x1544) = fiat_p384_scalar_addcarryx_u32(x1542, x1506, x1503);
    let (x1545, x1546) = fiat_p384_scalar_addcarryx_u32(x1544, x1504, x1501);
    let (x1547, x1548) = fiat_p384_scalar_addcarryx_u32(0x0, x1475, x1523);
    let (x1549, x1550) = fiat_p384_scalar_addcarryx_u32(x1548, x1477, x1525);
    let (x1551, x1552) = fiat_p384_scalar_addcarryx_u32(x1550, x1479, x1527);
    let (x1553, x1554) = fiat_p384_scalar_addcarryx_u32(x1552, x1481, x1529);
    let (x1555, x1556) = fiat_p384_scalar_addcarryx_u32(x1554, x1483, x1531);
    let (x1557, x1558) = fiat_p384_scalar_addcarryx_u32(x1556, x1485, x1533);
    let (x1559, x1560) = fiat_p384_scalar_addcarryx_u32(x1558, x1487, x1535);
    let (x1561, x1562) = fiat_p384_scalar_addcarryx_u32(x1560, x1489, x1537);
    let (x1563, x1564) = fiat_p384_scalar_addcarryx_u32(x1562, x1491, x1539);
    let (x1565, x1566) = fiat_p384_scalar_addcarryx_u32(x1564, x1493, x1541);
    let (x1567, x1568) = fiat_p384_scalar_addcarryx_u32(x1566, x1495, x1543);
    let (x1569, x1570) = fiat_p384_scalar_addcarryx_u32(x1568, x1497, x1545);
    let (x1571, x1572) = fiat_p384_scalar_addcarryx_u32(
        x1570,
        (((x1498 as u32) + (x1428 as u32)) + ((x1474 as u32) + x1430)),
        ((x1546 as u32) + x1502),
    );
    let (x1573, x1574) = fiat_p384_scalar_mulx_u32(x11, 0xc84ee01);
    let (x1575, x1576) = fiat_p384_scalar_mulx_u32(x11, 0x2b39bf21);
    let (x1577, x1578) = fiat_p384_scalar_mulx_u32(x11, 0x3fb05b7a);
    let (x1579, x1580) = fiat_p384_scalar_mulx_u32(x11, 0x28266895);
    let (x1581, x1582) = fiat_p384_scalar_mulx_u32(x11, 0xd40d4917);
    let (x1583, x1584) = fiat_p384_scalar_mulx_u32(x11, 0x4aab1cc5);
    let (x1585, x1586) = fiat_p384_scalar_mulx_u32(x11, 0xbc3e483a);
    let (x1587, x1588) = fiat_p384_scalar_mulx_u32(x11, 0xfcb82947);
    let (x1589, x1590) = fiat_p384_scalar_mulx_u32(x11, 0xff3d81e5);
    let (x1591, x1592) = fiat_p384_scalar_mulx_u32(x11, 0xdf1aa419);
    let (x1593, x1594) = fiat_p384_scalar_mulx_u32(x11, 0x2d319b24);
    let (x1595, x1596) = fiat_p384_scalar_mulx_u32(x11, 0x19b409a9);
    let (x1597, x1598) = fiat_p384_scalar_addcarryx_u32(0x0, x1596, x1593);
    let (x1599, x1600) = fiat_p384_scalar_addcarryx_u32(x1598, x1594, x1591);
    let (x1601, x1602) = fiat_p384_scalar_addcarryx_u32(x1600, x1592, x1589);
    let (x1603, x1604) = fiat_p384_scalar_addcarryx_u32(x1602, x1590, x1587);
    let (x1605, x1606) = fiat_p384_scalar_addcarryx_u32(x1604, x1588, x1585);
    let (x1607, x1608) = fiat_p384_scalar_addcarryx_u32(x1606, x1586, x1583);
    let (x1609, x1610) = fiat_p384_scalar_addcarryx_u32(x1608, x1584, x1581);
    let (x1611, x1612) = fiat_p384_scalar_addcarryx_u32(x1610, x1582, x1579);
    let (x1613, x1614) = fiat_p384_scalar_addcarryx_u32(x1612, x1580, x1577);
    let (x1615, x1616) = fiat_p384_scalar_addcarryx_u32(x1614, x1578, x1575);
    let (x1617, x1618) = fiat_p384_scalar_addcarryx_u32(x1616, x1576, x1573);
    let (x1619, x1620) = fiat_p384_scalar_addcarryx_u32(0x0, x1549, x1595);
    let (x1621, x1622) = fiat_p384_scalar_addcarryx_u32(x1620, x1551, x1597);
    let (x1623, x1624) = fiat_p384_scalar_addcarryx_u32(x1622, x1553, x1599);
    let (x1625, x1626) = fiat_p384_scalar_addcarryx_u32(x1624, x1555, x1601);
    let (x1627, x1628) = fiat_p384_scalar_addcarryx_u32(x1626, x1557, x1603);
    let (x1629, x1630) = fiat_p384_scalar_addcarryx_u32(x1628, x1559, x1605);
    let (x1631, x1632) = fiat_p384_scalar_addcarryx_u32(x1630, x1561, x1607);
    let (x1633, x1634) = fiat_p384_scalar_addcarryx_u32(x1632, x1563, x1609);
    let (x1635, x1636) = fiat_p384_scalar_addcarryx_u32(x1634, x1565, x1611);
    let (x1637, x1638) = fiat_p384_scalar_addcarryx_u32(x1636, x1567, x1613);
    let (x1639, x1640) = fiat_p384_scalar_addcarryx_u32(x1638, x1569, x1615);
    let (x1641, x1642) = fiat_p384_scalar_addcarryx_u32(x1640, x1571, x1617);
    let (x1643, x1644) = fiat_p384_scalar_mulx_u32(x1619, 0xe88fdc45);
    let (x1645, x1646) = fiat_p384_scalar_mulx_u32(x1643, 0xffffffff);
    let (x1647, x1648) = fiat_p384_scalar_mulx_u32(x1643, 0xffffffff);
    let (x1649, x1650) = fiat_p384_scalar_mulx_u32(x1643, 0xffffffff);
    let (x1651, x1652) = fiat_p384_scalar_mulx_u32(x1643, 0xffffffff);
    let (x1653, x1654) = fiat_p384_scalar_mulx_u32(x1643, 0xffffffff);
    let (x1655, x1656) = fiat_p384_scalar_mulx_u32(x1643, 0xffffffff);
    let (x1657, x1658) = fiat_p384_scalar_mulx_u32(x1643, 0xc7634d81);
    let (x1659, x1660) = fiat_p384_scalar_mulx_u32(x1643, 0xf4372ddf);
    let (x1661, x1662) = fiat_p384_scalar_mulx_u32(x1643, 0x581a0db2);
    let (x1663, x1664) = fiat_p384_scalar_mulx_u32(x1643, 0x48b0a77a);
    let (x1665, x1666) = fiat_p384_scalar_mulx_u32(x1643, 0xecec196a);
    let (x1667, x1668) = fiat_p384_scalar_mulx_u32(x1643, 0xccc52973);
    let (x1669, x1670) = fiat_p384_scalar_addcarryx_u32(0x0, x1668, x1665);
    let (x1671, x1672) = fiat_p384_scalar_addcarryx_u32(x1670, x1666, x1663);
    let (x1673, x1674) = fiat_p384_scalar_addcarryx_u32(x1672, x1664, x1661);
    let (x1675, x1676) = fiat_p384_scalar_addcarryx_u32(x1674, x1662, x1659);
    let (x1677, x1678) = fiat_p384_scalar_addcarryx_u32(x1676, x1660, x1657);
    let (x1679, x1680) = fiat_p384_scalar_addcarryx_u32(x1678, x1658, x1655);
    let (x1681, x1682) = fiat_p384_scalar_addcarryx_u32(x1680, x1656, x1653);
    let (x1683, x1684) = fiat_p384_scalar_addcarryx_u32(x1682, x1654, x1651);
    let (x1685, x1686) = fiat_p384_scalar_addcarryx_u32(x1684, x1652, x1649);
    let (x1687, x1688) = fiat_p384_scalar_addcarryx_u32(x1686, x1650, x1647);
    let (x1689, x1690) = fiat_p384_scalar_addcarryx_u32(x1688, x1648, x1645);
    let (x1691, x1692) = fiat_p384_scalar_addcarryx_u32(0x0, x1619, x1667);
    let (x1693, x1694) = fiat_p384_scalar_addcarryx_u32(x1692, x1621, x1669);
    let (x1695, x1696) = fiat_p384_scalar_addcarryx_u32(x1694, x1623, x1671);
    let (x1697, x1698) = fiat_p384_scalar_addcarryx_u32(x1696, x1625, x1673);
    let (x1699, x1700) = fiat_p384_scalar_addcarryx_u32(x1698, x1627, x1675);
    let (x1701, x1702) = fiat_p384_scalar_addcarryx_u32(x1700, x1629, x1677);
    let (x1703, x1704) = fiat_p384_scalar_addcarryx_u32(x1702, x1631, x1679);
    let (x1705, x1706) = fiat_p384_scalar_addcarryx_u32(x1704, x1633, x1681);
    let (x1707, x1708) = fiat_p384_scalar_addcarryx_u32(x1706, x1635, x1683);
    let (x1709, x1710) = fiat_p384_scalar_addcarryx_u32(x1708, x1637, x1685);
    let (x1711, x1712) = fiat_p384_scalar_addcarryx_u32(x1710, x1639, x1687);
    let (x1713, x1714) = fiat_p384_scalar_addcarryx_u32(x1712, x1641, x1689);
    let (x1715, x1716) = fiat_p384_scalar_addcarryx_u32(
        x1714,
        (((x1642 as u32) + (x1572 as u32)) + ((x1618 as u32) + x1574)),
        ((x1690 as u32) + x1646),
    );
    let (x1717, x1718) = fiat_p384_scalar_subborrowx_u32(0x0, x1693, 0xccc52973);
    let (x1719, x1720) = fiat_p384_scalar_subborrowx_u32(x1718, x1695, 0xecec196a);
    let (x1721, x1722) = fiat_p384_scalar_subborrowx_u32(x1720, x1697, 0x48b0a77a);
    let (x1723, x1724) = fiat_p384_scalar_subborrowx_u32(x1722, x1699, 0x581a0db2);
    let (x1725, x1726) = fiat_p384_scalar_subborrowx_u32(x1724, x1701, 0xf4372ddf);
    let (x1727, x1728) = fiat_p384_scalar_subborrowx_u32(x1726, x1703, 0xc7634d81);
    let (x1729, x1730) = fiat_p384_scalar_subborrowx_u32(x1728, x1705, 0xffffffff);
    let (x1731, x1732) = fiat_p384_scalar_subborrowx_u32(x1730, x1707, 0xffffffff);
    let (x1733, x1734) = fiat_p384_scalar_subborrowx_u32(x1732, x1709, 0xffffffff);
    let (x1735, x1736) = fiat_p384_scalar_subborrowx_u32(x1734, x1711, 0xffffffff);
    let (x1737, x1738) = fiat_p384_scalar_subborrowx_u32(x1736, x1713, 0xffffffff);
    let (x1739, x1740) = fiat_p384_scalar_subborrowx_u32(x1738, x1715, 0xffffffff);
    let (x1741, x1742) = fiat_p384_scalar_subborrowx_u32(x1740, (x1716 as u32), (0x0 as u32));
    let (x1743) = fiat_p384_scalar_cmovznz_u32(x1742, x1717, x1693);
    let (x1744) = fiat_p384_scalar_cmovznz_u32(x1742, x1719, x1695);
    let (x1745) = fiat_p384_scalar_cmovznz_u32(x1742, x1721, x1697);
    let (x1746) = fiat_p384_scalar_cmovznz_u32(x1742, x1723, x1699);
    let (x1747) = fiat_p384_scalar_cmovznz_u32(x1742, x1725, x1701);
    let (x1748) = fiat_p384_scalar_cmovznz_u32(x1742, x1727, x1703);
    let (x1749) = fiat_p384_scalar_cmovznz_u32(x1742, x1729, x1705);
    let (x1750) = fiat_p384_scalar_cmovznz_u32(x1742, x1731, x1707);
    let (x1751) = fiat_p384_scalar_cmovznz_u32(x1742, x1733, x1709);
    let (x1752) = fiat_p384_scalar_cmovznz_u32(x1742, x1735, x1711);
    let (x1753) = fiat_p384_scalar_cmovznz_u32(x1742, x1737, x1713);
    let (x1754) = fiat_p384_scalar_cmovznz_u32(x1742, x1739, x1715);
    out1[0] = x1743;
    out1[1] = x1744;
    out1[2] = x1745;
    out1[3] = x1746;
    out1[4] = x1747;
    out1[5] = x1748;
    out1[6] = x1749;
    out1[7] = x1750;
    out1[8] = x1751;
    out1[9] = x1752;
    out1[10] = x1753;
    out1[11] = x1754;
    out1
}
#[doc = " The function fiat_p384_scalar_nonzero outputs a single non-zero word if the input is non-zero and zero otherwise."]
#[doc = ""]
#[doc = " Preconditions:"]
#[doc = "   0 ≤ eval arg1 < m"]
#[doc = " Postconditions:"]
#[doc = "   out1 = 0 ↔ eval (from_montgomery arg1) mod m = 0"]
#[doc = ""]
#[doc = " Input Bounds:"]
#[doc = "   arg1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]"]
#[doc = " Output Bounds:"]
#[doc = "   out1: [0x0 ~> 0xffffffff]"]
#[inline]
pub const fn fiat_p384_scalar_nonzero(arg1: &[u32; 12]) -> u32 {
    let mut out1: u32 = 0;
    let x1: u32 = ((arg1[0])
        | ((arg1[1])
            | ((arg1[2])
                | ((arg1[3])
                    | ((arg1[4])
                        | ((arg1[5])
                            | ((arg1[6])
                                | ((arg1[7])
                                    | ((arg1[8]) | ((arg1[9]) | ((arg1[10]) | (arg1[11]))))))))))));
    out1 = x1;
    out1
}
#[doc = " The function fiat_p384_scalar_selectznz is a multi-limb conditional select."]
#[doc = ""]
#[doc = " Postconditions:"]
#[doc = "   out1 = (if arg1 = 0 then arg2 else arg3)"]
#[doc = ""]
#[doc = " Input Bounds:"]
#[doc = "   arg1: [0x0 ~> 0x1]"]
#[doc = "   arg2: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]"]
#[doc = "   arg3: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]"]
#[doc = " Output Bounds:"]
#[doc = "   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]"]
#[inline]
pub const fn fiat_p384_scalar_selectznz(
    arg1: fiat_p384_scalar_u1,
    arg2: &[u32; 12],
    arg3: &[u32; 12],
) -> [u32; 12] {
    let mut out1: [u32; 12] = [0; 12];
    let (x1) = fiat_p384_scalar_cmovznz_u32(arg1, (arg2[0]), (arg3[0]));
    let (x2) = fiat_p384_scalar_cmovznz_u32(arg1, (arg2[1]), (arg3[1]));
    let (x3) = fiat_p384_scalar_cmovznz_u32(arg1, (arg2[2]), (arg3[2]));
    let (x4) = fiat_p384_scalar_cmovznz_u32(arg1, (arg2[3]), (arg3[3]));
    let (x5) = fiat_p384_scalar_cmovznz_u32(arg1, (arg2[4]), (arg3[4]));
    let (x6) = fiat_p384_scalar_cmovznz_u32(arg1, (arg2[5]), (arg3[5]));
    let (x7) = fiat_p384_scalar_cmovznz_u32(arg1, (arg2[6]), (arg3[6]));
    let (x8) = fiat_p384_scalar_cmovznz_u32(arg1, (arg2[7]), (arg3[7]));
    let (x9) = fiat_p384_scalar_cmovznz_u32(arg1, (arg2[8]), (arg3[8]));
    let (x10) = fiat_p384_scalar_cmovznz_u32(arg1, (arg2[9]), (arg3[9]));
    let (x11) = fiat_p384_scalar_cmovznz_u32(arg1, (arg2[10]), (arg3[10]));
    let (x12) = fiat_p384_scalar_cmovznz_u32(arg1, (arg2[11]), (arg3[11]));
    out1[0] = x1;
    out1[1] = x2;
    out1[2] = x3;
    out1[3] = x4;
    out1[4] = x5;
    out1[5] = x6;
    out1[6] = x7;
    out1[7] = x8;
    out1[8] = x9;
    out1[9] = x10;
    out1[10] = x11;
    out1[11] = x12;
    out1
}
#[doc = " The function fiat_p384_scalar_to_bytes serializes a field element NOT in the Montgomery domain to bytes in little-endian order."]
#[doc = ""]
#[doc = " Preconditions:"]
#[doc = "   0 ≤ eval arg1 < m"]
#[doc = " Postconditions:"]
#[doc = "   out1 = map (λ x, ⌊((eval arg1 mod m) mod 2^(8 * (x + 1))) / 2^(8 * x)⌋) [0..47]"]
#[doc = ""]
#[doc = " Input Bounds:"]
#[doc = "   arg1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]"]
#[doc = " Output Bounds:"]
#[doc = "   out1: [[0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff]]"]
#[inline]
pub const fn fiat_p384_scalar_to_bytes(arg1: &[u32; 12]) -> [u8; 48] {
    let mut out1: [u8; 48] = [0; 48];
    let x1: u32 = (arg1[11]);
    let x2: u32 = (arg1[10]);
    let x3: u32 = (arg1[9]);
    let x4: u32 = (arg1[8]);
    let x5: u32 = (arg1[7]);
    let x6: u32 = (arg1[6]);
    let x7: u32 = (arg1[5]);
    let x8: u32 = (arg1[4]);
    let x9: u32 = (arg1[3]);
    let x10: u32 = (arg1[2]);
    let x11: u32 = (arg1[1]);
    let x12: u32 = (arg1[0]);
    let x13: u8 = ((x12 & (0xff as u32)) as u8);
    let x14: u32 = (x12 >> 8);
    let x15: u8 = ((x14 & (0xff as u32)) as u8);
    let x16: u32 = (x14 >> 8);
    let x17: u8 = ((x16 & (0xff as u32)) as u8);
    let x18: u8 = ((x16 >> 8) as u8);
    let x19: u8 = ((x11 & (0xff as u32)) as u8);
    let x20: u32 = (x11 >> 8);
    let x21: u8 = ((x20 & (0xff as u32)) as u8);
    let x22: u32 = (x20 >> 8);
    let x23: u8 = ((x22 & (0xff as u32)) as u8);
    let x24: u8 = ((x22 >> 8) as u8);
    let x25: u8 = ((x10 & (0xff as u32)) as u8);
    let x26: u32 = (x10 >> 8);
    let x27: u8 = ((x26 & (0xff as u32)) as u8);
    let x28: u32 = (x26 >> 8);
    let x29: u8 = ((x28 & (0xff as u32)) as u8);
    let x30: u8 = ((x28 >> 8) as u8);
    let x31: u8 = ((x9 & (0xff as u32)) as u8);
    let x32: u32 = (x9 >> 8);
    let x33: u8 = ((x32 & (0xff as u32)) as u8);
    let x34: u32 = (x32 >> 8);
    let x35: u8 = ((x34 & (0xff as u32)) as u8);
    let x36: u8 = ((x34 >> 8) as u8);
    let x37: u8 = ((x8 & (0xff as u32)) as u8);
    let x38: u32 = (x8 >> 8);
    let x39: u8 = ((x38 & (0xff as u32)) as u8);
    let x40: u32 = (x38 >> 8);
    let x41: u8 = ((x40 & (0xff as u32)) as u8);
    let x42: u8 = ((x40 >> 8) as u8);
    let x43: u8 = ((x7 & (0xff as u32)) as u8);
    let x44: u32 = (x7 >> 8);
    let x45: u8 = ((x44 & (0xff as u32)) as u8);
    let x46: u32 = (x44 >> 8);
    let x47: u8 = ((x46 & (0xff as u32)) as u8);
    let x48: u8 = ((x46 >> 8) as u8);
    let x49: u8 = ((x6 & (0xff as u32)) as u8);
    let x50: u32 = (x6 >> 8);
    let x51: u8 = ((x50 & (0xff as u32)) as u8);
    let x52: u32 = (x50 >> 8);
    let x53: u8 = ((x52 & (0xff as u32)) as u8);
    let x54: u8 = ((x52 >> 8) as u8);
    let x55: u8 = ((x5 & (0xff as u32)) as u8);
    let x56: u32 = (x5 >> 8);
    let x57: u8 = ((x56 & (0xff as u32)) as u8);
    let x58: u32 = (x56 >> 8);
    let x59: u8 = ((x58 & (0xff as u32)) as u8);
    let x60: u8 = ((x58 >> 8) as u8);
    let x61: u8 = ((x4 & (0xff as u32)) as u8);
    let x62: u32 = (x4 >> 8);
    let x63: u8 = ((x62 & (0xff as u32)) as u8);
    let x64: u32 = (x62 >> 8);
    let x65: u8 = ((x64 & (0xff as u32)) as u8);
    let x66: u8 = ((x64 >> 8) as u8);
    let x67: u8 = ((x3 & (0xff as u32)) as u8);
    let x68: u32 = (x3 >> 8);
    let x69: u8 = ((x68 & (0xff as u32)) as u8);
    let x70: u32 = (x68 >> 8);
    let x71: u8 = ((x70 & (0xff as u32)) as u8);
    let x72: u8 = ((x70 >> 8) as u8);
    let x73: u8 = ((x2 & (0xff as u32)) as u8);
    let x74: u32 = (x2 >> 8);
    let x75: u8 = ((x74 & (0xff as u32)) as u8);
    let x76: u32 = (x74 >> 8);
    let x77: u8 = ((x76 & (0xff as u32)) as u8);
    let x78: u8 = ((x76 >> 8) as u8);
    let x79: u8 = ((x1 & (0xff as u32)) as u8);
    let x80: u32 = (x1 >> 8);
    let x81: u8 = ((x80 & (0xff as u32)) as u8);
    let x82: u32 = (x80 >> 8);
    let x83: u8 = ((x82 & (0xff as u32)) as u8);
    let x84: u8 = ((x82 >> 8) as u8);
    out1[0] = x13;
    out1[1] = x15;
    out1[2] = x17;
    out1[3] = x18;
    out1[4] = x19;
    out1[5] = x21;
    out1[6] = x23;
    out1[7] = x24;
    out1[8] = x25;
    out1[9] = x27;
    out1[10] = x29;
    out1[11] = x30;
    out1[12] = x31;
    out1[13] = x33;
    out1[14] = x35;
    out1[15] = x36;
    out1[16] = x37;
    out1[17] = x39;
    out1[18] = x41;
    out1[19] = x42;
    out1[20] = x43;
    out1[21] = x45;
    out1[22] = x47;
    out1[23] = x48;
    out1[24] = x49;
    out1[25] = x51;
    out1[26] = x53;
    out1[27] = x54;
    out1[28] = x55;
    out1[29] = x57;
    out1[30] = x59;
    out1[31] = x60;
    out1[32] = x61;
    out1[33] = x63;
    out1[34] = x65;
    out1[35] = x66;
    out1[36] = x67;
    out1[37] = x69;
    out1[38] = x71;
    out1[39] = x72;
    out1[40] = x73;
    out1[41] = x75;
    out1[42] = x77;
    out1[43] = x78;
    out1[44] = x79;
    out1[45] = x81;
    out1[46] = x83;
    out1[47] = x84;
    out1
}
#[doc = " The function fiat_p384_scalar_from_bytes deserializes a field element NOT in the Montgomery domain from bytes in little-endian order."]
#[doc = ""]
#[doc = " Preconditions:"]
#[doc = "   0 ≤ bytes_eval arg1 < m"]
#[doc = " Postconditions:"]
#[doc = "   eval out1 mod m = bytes_eval arg1 mod m"]
#[doc = "   0 ≤ eval out1 < m"]
#[doc = ""]
#[doc = " Input Bounds:"]
#[doc = "   arg1: [[0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff]]"]
#[doc = " Output Bounds:"]
#[doc = "   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]"]
#[inline]
pub const fn fiat_p384_scalar_from_bytes(arg1: &[u8; 48]) -> [u32; 12] {
    let mut out1: [u32; 12] = [0; 12];
    let x1: u32 = (((arg1[47]) as u32) << 24);
    let x2: u32 = (((arg1[46]) as u32) << 16);
    let x3: u32 = (((arg1[45]) as u32) << 8);
    let x4: u8 = (arg1[44]);
    let x5: u32 = (((arg1[43]) as u32) << 24);
    let x6: u32 = (((arg1[42]) as u32) << 16);
    let x7: u32 = (((arg1[41]) as u32) << 8);
    let x8: u8 = (arg1[40]);
    let x9: u32 = (((arg1[39]) as u32) << 24);
    let x10: u32 = (((arg1[38]) as u32) << 16);
    let x11: u32 = (((arg1[37]) as u32) << 8);
    let x12: u8 = (arg1[36]);
    let x13: u32 = (((arg1[35]) as u32) << 24);
    let x14: u32 = (((arg1[34]) as u32) << 16);
    let x15: u32 = (((arg1[33]) as u32) << 8);
    let x16: u8 = (arg1[32]);
    let x17: u32 = (((arg1[31]) as u32) << 24);
    let x18: u32 = (((arg1[30]) as u32) << 16);
    let x19: u32 = (((arg1[29]) as u32) << 8);
    let x20: u8 = (arg1[28]);
    let x21: u32 = (((arg1[27]) as u32) << 24);
    let x22: u32 = (((arg1[26]) as u32) << 16);
    let x23: u32 = (((arg1[25]) as u32) << 8);
    let x24: u8 = (arg1[24]);
    let x25: u32 = (((arg1[23]) as u32) << 24);
    let x26: u32 = (((arg1[22]) as u32) << 16);
    let x27: u32 = (((arg1[21]) as u32) << 8);
    let x28: u8 = (arg1[20]);
    let x29: u32 = (((arg1[19]) as u32) << 24);
    let x30: u32 = (((arg1[18]) as u32) << 16);
    let x31: u32 = (((arg1[17]) as u32) << 8);
    let x32: u8 = (arg1[16]);
    let x33: u32 = (((arg1[15]) as u32) << 24);
    let x34: u32 = (((arg1[14]) as u32) << 16);
    let x35: u32 = (((arg1[13]) as u32) << 8);
    let x36: u8 = (arg1[12]);
    let x37: u32 = (((arg1[11]) as u32) << 24);
    let x38: u32 = (((arg1[10]) as u32) << 16);
    let x39: u32 = (((arg1[9]) as u32) << 8);
    let x40: u8 = (arg1[8]);
    let x41: u32 = (((arg1[7]) as u32) << 24);
    let x42: u32 = (((arg1[6]) as u32) << 16);
    let x43: u32 = (((arg1[5]) as u32) << 8);
    let x44: u8 = (arg1[4]);
    let x45: u32 = (((arg1[3]) as u32) << 24);
    let x46: u32 = (((arg1[2]) as u32) << 16);
    let x47: u32 = (((arg1[1]) as u32) << 8);
    let x48: u8 = (arg1[0]);
    let x49: u32 = (x47 + (x48 as u32));
    let x50: u32 = (x46 + x49);
    let x51: u32 = (x45 + x50);
    let x52: u32 = (x43 + (x44 as u32));
    let x53: u32 = (x42 + x52);
    let x54: u32 = (x41 + x53);
    let x55: u32 = (x39 + (x40 as u32));
    let x56: u32 = (x38 + x55);
    let x57: u32 = (x37 + x56);
    let x58: u32 = (x35 + (x36 as u32));
    let x59: u32 = (x34 + x58);
    let x60: u32 = (x33 + x59);
    let x61: u32 = (x31 + (x32 as u32));
    let x62: u32 = (x30 + x61);
    let x63: u32 = (x29 + x62);
    let x64: u32 = (x27 + (x28 as u32));
    let x65: u32 = (x26 + x64);
    let x66: u32 = (x25 + x65);
    let x67: u32 = (x23 + (x24 as u32));
    let x68: u32 = (x22 + x67);
    let x69: u32 = (x21 + x68);
    let x70: u32 = (x19 + (x20 as u32));
    let x71: u32 = (x18 + x70);
    let x72: u32 = (x17 + x71);
    let x73: u32 = (x15 + (x16 as u32));
    let x74: u32 = (x14 + x73);
    let x75: u32 = (x13 + x74);
    let x76: u32 = (x11 + (x12 as u32));
    let x77: u32 = (x10 + x76);
    let x78: u32 = (x9 + x77);
    let x79: u32 = (x7 + (x8 as u32));
    let x80: u32 = (x6 + x79);
    let x81: u32 = (x5 + x80);
    let x82: u32 = (x3 + (x4 as u32));
    let x83: u32 = (x2 + x82);
    let x84: u32 = (x1 + x83);
    out1[0] = x51;
    out1[1] = x54;
    out1[2] = x57;
    out1[3] = x60;
    out1[4] = x63;
    out1[5] = x66;
    out1[6] = x69;
    out1[7] = x72;
    out1[8] = x75;
    out1[9] = x78;
    out1[10] = x81;
    out1[11] = x84;
    out1
}
#[doc = " The function fiat_p384_scalar_set_one returns the field element one in the Montgomery domain."]
#[doc = ""]
#[doc = " Postconditions:"]
#[doc = "   eval (from_montgomery out1) mod m = 1 mod m"]
#[doc = "   0 ≤ eval out1 < m"]
#[doc = ""]
#[inline]
pub const fn fiat_p384_scalar_set_one() -> fiat_p384_scalar_montgomery_domain_field_element {
    let mut out1: fiat_p384_scalar_montgomery_domain_field_element = [0; 12];
    out1[0] = 0x333ad68d;
    out1[1] = 0x1313e695;
    out1[2] = 0xb74f5885;
    out1[3] = 0xa7e5f24d;
    out1[4] = 0xbc8d220;
    out1[5] = 0x389cb27e;
    out1[6] = (0x0 as u32);
    out1[7] = (0x0 as u32);
    out1[8] = (0x0 as u32);
    out1[9] = (0x0 as u32);
    out1[10] = (0x0 as u32);
    out1[11] = (0x0 as u32);
    out1
}
#[doc = " The function fiat_p384_scalar_msat returns the saturated representation of the prime modulus."]
#[doc = ""]
#[doc = " Postconditions:"]
#[doc = "   twos_complement_eval out1 = m"]
#[doc = "   0 ≤ eval out1 < m"]
#[doc = ""]
#[doc = " Output Bounds:"]
#[doc = "   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]"]
#[inline]
pub const fn fiat_p384_scalar_msat() -> [u32; 13] {
    let mut out1: [u32; 13] = [0; 13];
    out1[0] = 0xccc52973;
    out1[1] = 0xecec196a;
    out1[2] = 0x48b0a77a;
    out1[3] = 0x581a0db2;
    out1[4] = 0xf4372ddf;
    out1[5] = 0xc7634d81;
    out1[6] = 0xffffffff;
    out1[7] = 0xffffffff;
    out1[8] = 0xffffffff;
    out1[9] = 0xffffffff;
    out1[10] = 0xffffffff;
    out1[11] = 0xffffffff;
    out1[12] = (0x0 as u32);
    out1
}
#[doc = " The function fiat_p384_scalar_divstep computes a divstep."]
#[doc = ""]
#[doc = " Preconditions:"]
#[doc = "   0 ≤ eval arg4 < m"]
#[doc = "   0 ≤ eval arg5 < m"]
#[doc = " Postconditions:"]
#[doc = "   out1 = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then 1 - arg1 else 1 + arg1)"]
#[doc = "   twos_complement_eval out2 = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then twos_complement_eval arg3 else twos_complement_eval arg2)"]
#[doc = "   twos_complement_eval out3 = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then ⌊(twos_complement_eval arg3 - twos_complement_eval arg2) / 2⌋ else ⌊(twos_complement_eval arg3 + (twos_complement_eval arg3 mod 2) * twos_complement_eval arg2) / 2⌋)"]
#[doc = "   eval (from_montgomery out4) mod m = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then (2 * eval (from_montgomery arg5)) mod m else (2 * eval (from_montgomery arg4)) mod m)"]
#[doc = "   eval (from_montgomery out5) mod m = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then (eval (from_montgomery arg4) - eval (from_montgomery arg4)) mod m else (eval (from_montgomery arg5) + (twos_complement_eval arg3 mod 2) * eval (from_montgomery arg4)) mod m)"]
#[doc = "   0 ≤ eval out5 < m"]
#[doc = "   0 ≤ eval out5 < m"]
#[doc = "   0 ≤ eval out2 < m"]
#[doc = "   0 ≤ eval out3 < m"]
#[doc = ""]
#[doc = " Input Bounds:"]
#[doc = "   arg1: [0x0 ~> 0xffffffff]"]
#[doc = "   arg2: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]"]
#[doc = "   arg3: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]"]
#[doc = "   arg4: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]"]
#[doc = "   arg5: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]"]
#[doc = " Output Bounds:"]
#[doc = "   out1: [0x0 ~> 0xffffffff]"]
#[doc = "   out2: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]"]
#[doc = "   out3: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]"]
#[doc = "   out4: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]"]
#[doc = "   out5: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]"]
#[inline]
pub const fn fiat_p384_scalar_divstep(
    arg1: u32,
    arg2: &[u32; 13],
    arg3: &[u32; 13],
    arg4: &[u32; 12],
    arg5: &[u32; 12],
) -> (u32, [u32; 13], [u32; 13], [u32; 12], [u32; 12]) {
    let mut out1: u32 = 0;
    let mut out2: [u32; 13] = [0; 13];
    let mut out3: [u32; 13] = [0; 13];
    let mut out4: [u32; 12] = [0; 12];
    let mut out5: [u32; 12] = [0; 12];
    let (x1, x2) = fiat_p384_scalar_addcarryx_u32(0x0, (!arg1), (0x1 as u32));
    let x3: fiat_p384_scalar_u1 =
        (((x1 >> 31) as fiat_p384_scalar_u1) & (((arg3[0]) & (0x1 as u32)) as fiat_p384_scalar_u1));
    let (x4, x5) = fiat_p384_scalar_addcarryx_u32(0x0, (!arg1), (0x1 as u32));
    let (x6) = fiat_p384_scalar_cmovznz_u32(x3, arg1, x4);
    let (x7) = fiat_p384_scalar_cmovznz_u32(x3, (arg2[0]), (arg3[0]));
    let (x8) = fiat_p384_scalar_cmovznz_u32(x3, (arg2[1]), (arg3[1]));
    let (x9) = fiat_p384_scalar_cmovznz_u32(x3, (arg2[2]), (arg3[2]));
    let (x10) = fiat_p384_scalar_cmovznz_u32(x3, (arg2[3]), (arg3[3]));
    let (x11) = fiat_p384_scalar_cmovznz_u32(x3, (arg2[4]), (arg3[4]));
    let (x12) = fiat_p384_scalar_cmovznz_u32(x3, (arg2[5]), (arg3[5]));
    let (x13) = fiat_p384_scalar_cmovznz_u32(x3, (arg2[6]), (arg3[6]));
    let (x14) = fiat_p384_scalar_cmovznz_u32(x3, (arg2[7]), (arg3[7]));
    let (x15) = fiat_p384_scalar_cmovznz_u32(x3, (arg2[8]), (arg3[8]));
    let (x16) = fiat_p384_scalar_cmovznz_u32(x3, (arg2[9]), (arg3[9]));
    let (x17) = fiat_p384_scalar_cmovznz_u32(x3, (arg2[10]), (arg3[10]));
    let (x18) = fiat_p384_scalar_cmovznz_u32(x3, (arg2[11]), (arg3[11]));
    let (x19) = fiat_p384_scalar_cmovznz_u32(x3, (arg2[12]), (arg3[12]));
    let (x20, x21) = fiat_p384_scalar_addcarryx_u32(0x0, (0x1 as u32), (!(arg2[0])));
    let (x22, x23) = fiat_p384_scalar_addcarryx_u32(x21, (0x0 as u32), (!(arg2[1])));
    let (x24, x25) = fiat_p384_scalar_addcarryx_u32(x23, (0x0 as u32), (!(arg2[2])));
    let (x26, x27) = fiat_p384_scalar_addcarryx_u32(x25, (0x0 as u32), (!(arg2[3])));
    let (x28, x29) = fiat_p384_scalar_addcarryx_u32(x27, (0x0 as u32), (!(arg2[4])));
    let (x30, x31) = fiat_p384_scalar_addcarryx_u32(x29, (0x0 as u32), (!(arg2[5])));
    let (x32, x33) = fiat_p384_scalar_addcarryx_u32(x31, (0x0 as u32), (!(arg2[6])));
    let (x34, x35) = fiat_p384_scalar_addcarryx_u32(x33, (0x0 as u32), (!(arg2[7])));
    let (x36, x37) = fiat_p384_scalar_addcarryx_u32(x35, (0x0 as u32), (!(arg2[8])));
    let (x38, x39) = fiat_p384_scalar_addcarryx_u32(x37, (0x0 as u32), (!(arg2[9])));
    let (x40, x41) = fiat_p384_scalar_addcarryx_u32(x39, (0x0 as u32), (!(arg2[10])));
    let (x42, x43) = fiat_p384_scalar_addcarryx_u32(x41, (0x0 as u32), (!(arg2[11])));
    let (x44, x45) = fiat_p384_scalar_addcarryx_u32(x43, (0x0 as u32), (!(arg2[12])));
    let (x46) = fiat_p384_scalar_cmovznz_u32(x3, (arg3[0]), x20);
    let (x47) = fiat_p384_scalar_cmovznz_u32(x3, (arg3[1]), x22);
    let (x48) = fiat_p384_scalar_cmovznz_u32(x3, (arg3[2]), x24);
    let (x49) = fiat_p384_scalar_cmovznz_u32(x3, (arg3[3]), x26);
    let (x50) = fiat_p384_scalar_cmovznz_u32(x3, (arg3[4]), x28);
    let (x51) = fiat_p384_scalar_cmovznz_u32(x3, (arg3[5]), x30);
    let (x52) = fiat_p384_scalar_cmovznz_u32(x3, (arg3[6]), x32);
    let (x53) = fiat_p384_scalar_cmovznz_u32(x3, (arg3[7]), x34);
    let (x54) = fiat_p384_scalar_cmovznz_u32(x3, (arg3[8]), x36);
    let (x55) = fiat_p384_scalar_cmovznz_u32(x3, (arg3[9]), x38);
    let (x56) = fiat_p384_scalar_cmovznz_u32(x3, (arg3[10]), x40);
    let (x57) = fiat_p384_scalar_cmovznz_u32(x3, (arg3[11]), x42);
    let (x58) = fiat_p384_scalar_cmovznz_u32(x3, (arg3[12]), x44);
    let (x59) = fiat_p384_scalar_cmovznz_u32(x3, (arg4[0]), (arg5[0]));
    let (x60) = fiat_p384_scalar_cmovznz_u32(x3, (arg4[1]), (arg5[1]));
    let (x61) = fiat_p384_scalar_cmovznz_u32(x3, (arg4[2]), (arg5[2]));
    let (x62) = fiat_p384_scalar_cmovznz_u32(x3, (arg4[3]), (arg5[3]));
    let (x63) = fiat_p384_scalar_cmovznz_u32(x3, (arg4[4]), (arg5[4]));
    let (x64) = fiat_p384_scalar_cmovznz_u32(x3, (arg4[5]), (arg5[5]));
    let (x65) = fiat_p384_scalar_cmovznz_u32(x3, (arg4[6]), (arg5[6]));
    let (x66) = fiat_p384_scalar_cmovznz_u32(x3, (arg4[7]), (arg5[7]));
    let (x67) = fiat_p384_scalar_cmovznz_u32(x3, (arg4[8]), (arg5[8]));
    let (x68) = fiat_p384_scalar_cmovznz_u32(x3, (arg4[9]), (arg5[9]));
    let (x69) = fiat_p384_scalar_cmovznz_u32(x3, (arg4[10]), (arg5[10]));
    let (x70) = fiat_p384_scalar_cmovznz_u32(x3, (arg4[11]), (arg5[11]));
    let (x71, x72) = fiat_p384_scalar_addcarryx_u32(0x0, x59, x59);
    let (x73, x74) = fiat_p384_scalar_addcarryx_u32(x72, x60, x60);
    let (x75, x76) = fiat_p384_scalar_addcarryx_u32(x74, x61, x61);
    let (x77, x78) = fiat_p384_scalar_addcarryx_u32(x76, x62, x62);
    let (x79, x80) = fiat_p384_scalar_addcarryx_u32(x78, x63, x63);
    let (x81, x82) = fiat_p384_scalar_addcarryx_u32(x80, x64, x64);
    let (x83, x84) = fiat_p384_scalar_addcarryx_u32(x82, x65, x65);
    let (x85, x86) = fiat_p384_scalar_addcarryx_u32(x84, x66, x66);
    let (x87, x88) = fiat_p384_scalar_addcarryx_u32(x86, x67, x67);
    let (x89, x90) = fiat_p384_scalar_addcarryx_u32(x88, x68, x68);
    let (x91, x92) = fiat_p384_scalar_addcarryx_u32(x90, x69, x69);
    let (x93, x94) = fiat_p384_scalar_addcarryx_u32(x92, x70, x70);
    let (x95, x96) = fiat_p384_scalar_subborrowx_u32(0x0, x71, 0xccc52973);
    let (x97, x98) = fiat_p384_scalar_subborrowx_u32(x96, x73, 0xecec196a);
    let (x99, x100) = fiat_p384_scalar_subborrowx_u32(x98, x75, 0x48b0a77a);
    let (x101, x102) = fiat_p384_scalar_subborrowx_u32(x100, x77, 0x581a0db2);
    let (x103, x104) = fiat_p384_scalar_subborrowx_u32(x102, x79, 0xf4372ddf);
    let (x105, x106) = fiat_p384_scalar_subborrowx_u32(x104, x81, 0xc7634d81);
    let (x107, x108) = fiat_p384_scalar_subborrowx_u32(x106, x83, 0xffffffff);
    let (x109, x110) = fiat_p384_scalar_subborrowx_u32(x108, x85, 0xffffffff);
    let (x111, x112) = fiat_p384_scalar_subborrowx_u32(x110, x87, 0xffffffff);
    let (x113, x114) = fiat_p384_scalar_subborrowx_u32(x112, x89, 0xffffffff);
    let (x115, x116) = fiat_p384_scalar_subborrowx_u32(x114, x91, 0xffffffff);
    let (x117, x118) = fiat_p384_scalar_subborrowx_u32(x116, x93, 0xffffffff);
    let (x119, x120) = fiat_p384_scalar_subborrowx_u32(x118, (x94 as u32), (0x0 as u32));
    let x121: u32 = (arg4[11]);
    let x122: u32 = (arg4[10]);
    let x123: u32 = (arg4[9]);
    let x124: u32 = (arg4[8]);
    let x125: u32 = (arg4[7]);
    let x126: u32 = (arg4[6]);
    let x127: u32 = (arg4[5]);
    let x128: u32 = (arg4[4]);
    let x129: u32 = (arg4[3]);
    let x130: u32 = (arg4[2]);
    let x131: u32 = (arg4[1]);
    let x132: u32 = (arg4[0]);
    let (x133, x134) = fiat_p384_scalar_subborrowx_u32(0x0, (0x0 as u32), x132);
    let (x135, x136) = fiat_p384_scalar_subborrowx_u32(x134, (0x0 as u32), x131);
    let (x137, x138) = fiat_p384_scalar_subborrowx_u32(x136, (0x0 as u32), x130);
    let (x139, x140) = fiat_p384_scalar_subborrowx_u32(x138, (0x0 as u32), x129);
    let (x141, x142) = fiat_p384_scalar_subborrowx_u32(x140, (0x0 as u32), x128);
    let (x143, x144) = fiat_p384_scalar_subborrowx_u32(x142, (0x0 as u32), x127);
    let (x145, x146) = fiat_p384_scalar_subborrowx_u32(x144, (0x0 as u32), x126);
    let (x147, x148) = fiat_p384_scalar_subborrowx_u32(x146, (0x0 as u32), x125);
    let (x149, x150) = fiat_p384_scalar_subborrowx_u32(x148, (0x0 as u32), x124);
    let (x151, x152) = fiat_p384_scalar_subborrowx_u32(x150, (0x0 as u32), x123);
    let (x153, x154) = fiat_p384_scalar_subborrowx_u32(x152, (0x0 as u32), x122);
    let (x155, x156) = fiat_p384_scalar_subborrowx_u32(x154, (0x0 as u32), x121);
    let (x157) = fiat_p384_scalar_cmovznz_u32(x156, (0x0 as u32), 0xffffffff);
    let (x158, x159) = fiat_p384_scalar_addcarryx_u32(0x0, x133, (x157 & 0xccc52973));
    let (x160, x161) = fiat_p384_scalar_addcarryx_u32(x159, x135, (x157 & 0xecec196a));
    let (x162, x163) = fiat_p384_scalar_addcarryx_u32(x161, x137, (x157 & 0x48b0a77a));
    let (x164, x165) = fiat_p384_scalar_addcarryx_u32(x163, x139, (x157 & 0x581a0db2));
    let (x166, x167) = fiat_p384_scalar_addcarryx_u32(x165, x141, (x157 & 0xf4372ddf));
    let (x168, x169) = fiat_p384_scalar_addcarryx_u32(x167, x143, (x157 & 0xc7634d81));
    let (x170, x171) = fiat_p384_scalar_addcarryx_u32(x169, x145, x157);
    let (x172, x173) = fiat_p384_scalar_addcarryx_u32(x171, x147, x157);
    let (x174, x175) = fiat_p384_scalar_addcarryx_u32(x173, x149, x157);
    let (x176, x177) = fiat_p384_scalar_addcarryx_u32(x175, x151, x157);
    let (x178, x179) = fiat_p384_scalar_addcarryx_u32(x177, x153, x157);
    let (x180, x181) = fiat_p384_scalar_addcarryx_u32(x179, x155, x157);
    let (x182) = fiat_p384_scalar_cmovznz_u32(x3, (arg5[0]), x158);
    let (x183) = fiat_p384_scalar_cmovznz_u32(x3, (arg5[1]), x160);
    let (x184) = fiat_p384_scalar_cmovznz_u32(x3, (arg5[2]), x162);
    let (x185) = fiat_p384_scalar_cmovznz_u32(x3, (arg5[3]), x164);
    let (x186) = fiat_p384_scalar_cmovznz_u32(x3, (arg5[4]), x166);
    let (x187) = fiat_p384_scalar_cmovznz_u32(x3, (arg5[5]), x168);
    let (x188) = fiat_p384_scalar_cmovznz_u32(x3, (arg5[6]), x170);
    let (x189) = fiat_p384_scalar_cmovznz_u32(x3, (arg5[7]), x172);
    let (x190) = fiat_p384_scalar_cmovznz_u32(x3, (arg5[8]), x174);
    let (x191) = fiat_p384_scalar_cmovznz_u32(x3, (arg5[9]), x176);
    let (x192) = fiat_p384_scalar_cmovznz_u32(x3, (arg5[10]), x178);
    let (x193) = fiat_p384_scalar_cmovznz_u32(x3, (arg5[11]), x180);
    let x194: fiat_p384_scalar_u1 = ((x46 & (0x1 as u32)) as fiat_p384_scalar_u1);
    let (x195) = fiat_p384_scalar_cmovznz_u32(x194, (0x0 as u32), x7);
    let (x196) = fiat_p384_scalar_cmovznz_u32(x194, (0x0 as u32), x8);
    let (x197) = fiat_p384_scalar_cmovznz_u32(x194, (0x0 as u32), x9);
    let (x198) = fiat_p384_scalar_cmovznz_u32(x194, (0x0 as u32), x10);
    let (x199) = fiat_p384_scalar_cmovznz_u32(x194, (0x0 as u32), x11);
    let (x200) = fiat_p384_scalar_cmovznz_u32(x194, (0x0 as u32), x12);
    let (x201) = fiat_p384_scalar_cmovznz_u32(x194, (0x0 as u32), x13);
    let (x202) = fiat_p384_scalar_cmovznz_u32(x194, (0x0 as u32), x14);
    let (x203) = fiat_p384_scalar_cmovznz_u32(x194, (0x0 as u32), x15);
    let (x204) = fiat_p384_scalar_cmovznz_u32(x194, (0x0 as u32), x16);
    let (x205) = fiat_p384_scalar_cmovznz_u32(x194, (0x0 as u32), x17);
    let (x206) = fiat_p384_scalar_cmovznz_u32(x194, (0x0 as u32), x18);
    let (x207) = fiat_p384_scalar_cmovznz_u32(x194, (0x0 as u32), x19);
    let (x208, x209) = fiat_p384_scalar_addcarryx_u32(0x0, x46, x195);
    let (x210, x211) = fiat_p384_scalar_addcarryx_u32(x209, x47, x196);
    let (x212, x213) = fiat_p384_scalar_addcarryx_u32(x211, x48, x197);
    let (x214, x215) = fiat_p384_scalar_addcarryx_u32(x213, x49, x198);
    let (x216, x217) = fiat_p384_scalar_addcarryx_u32(x215, x50, x199);
    let (x218, x219) = fiat_p384_scalar_addcarryx_u32(x217, x51, x200);
    let (x220, x221) = fiat_p384_scalar_addcarryx_u32(x219, x52, x201);
    let (x222, x223) = fiat_p384_scalar_addcarryx_u32(x221, x53, x202);
    let (x224, x225) = fiat_p384_scalar_addcarryx_u32(x223, x54, x203);
    let (x226, x227) = fiat_p384_scalar_addcarryx_u32(x225, x55, x204);
    let (x228, x229) = fiat_p384_scalar_addcarryx_u32(x227, x56, x205);
    let (x230, x231) = fiat_p384_scalar_addcarryx_u32(x229, x57, x206);
    let (x232, x233) = fiat_p384_scalar_addcarryx_u32(x231, x58, x207);
    let (x234) = fiat_p384_scalar_cmovznz_u32(x194, (0x0 as u32), x59);
    let (x235) = fiat_p384_scalar_cmovznz_u32(x194, (0x0 as u32), x60);
    let (x236) = fiat_p384_scalar_cmovznz_u32(x194, (0x0 as u32), x61);
    let (x237) = fiat_p384_scalar_cmovznz_u32(x194, (0x0 as u32), x62);
    let (x238) = fiat_p384_scalar_cmovznz_u32(x194, (0x0 as u32), x63);
    let (x239) = fiat_p384_scalar_cmovznz_u32(x194, (0x0 as u32), x64);
    let (x240) = fiat_p384_scalar_cmovznz_u32(x194, (0x0 as u32), x65);
    let (x241) = fiat_p384_scalar_cmovznz_u32(x194, (0x0 as u32), x66);
    let (x242) = fiat_p384_scalar_cmovznz_u32(x194, (0x0 as u32), x67);
    let (x243) = fiat_p384_scalar_cmovznz_u32(x194, (0x0 as u32), x68);
    let (x244) = fiat_p384_scalar_cmovznz_u32(x194, (0x0 as u32), x69);
    let (x245) = fiat_p384_scalar_cmovznz_u32(x194, (0x0 as u32), x70);
    let (x246, x247) = fiat_p384_scalar_addcarryx_u32(0x0, x182, x234);
    let (x248, x249) = fiat_p384_scalar_addcarryx_u32(x247, x183, x235);
    let (x250, x251) = fiat_p384_scalar_addcarryx_u32(x249, x184, x236);
    let (x252, x253) = fiat_p384_scalar_addcarryx_u32(x251, x185, x237);
    let (x254, x255) = fiat_p384_scalar_addcarryx_u32(x253, x186, x238);
    let (x256, x257) = fiat_p384_scalar_addcarryx_u32(x255, x187, x239);
    let (x258, x259) = fiat_p384_scalar_addcarryx_u32(x257, x188, x240);
    let (x260, x261) = fiat_p384_scalar_addcarryx_u32(x259, x189, x241);
    let (x262, x263) = fiat_p384_scalar_addcarryx_u32(x261, x190, x242);
    let (x264, x265) = fiat_p384_scalar_addcarryx_u32(x263, x191, x243);
    let (x266, x267) = fiat_p384_scalar_addcarryx_u32(x265, x192, x244);
    let (x268, x269) = fiat_p384_scalar_addcarryx_u32(x267, x193, x245);
    let (x270, x271) = fiat_p384_scalar_subborrowx_u32(0x0, x246, 0xccc52973);
    let (x272, x273) = fiat_p384_scalar_subborrowx_u32(x271, x248, 0xecec196a);
    let (x274, x275) = fiat_p384_scalar_subborrowx_u32(x273, x250, 0x48b0a77a);
    let (x276, x277) = fiat_p384_scalar_subborrowx_u32(x275, x252, 0x581a0db2);
    let (x278, x279) = fiat_p384_scalar_subborrowx_u32(x277, x254, 0xf4372ddf);
    let (x280, x281) = fiat_p384_scalar_subborrowx_u32(x279, x256, 0xc7634d81);
    let (x282, x283) = fiat_p384_scalar_subborrowx_u32(x281, x258, 0xffffffff);
    let (x284, x285) = fiat_p384_scalar_subborrowx_u32(x283, x260, 0xffffffff);
    let (x286, x287) = fiat_p384_scalar_subborrowx_u32(x285, x262, 0xffffffff);
    let (x288, x289) = fiat_p384_scalar_subborrowx_u32(x287, x264, 0xffffffff);
    let (x290, x291) = fiat_p384_scalar_subborrowx_u32(x289, x266, 0xffffffff);
    let (x292, x293) = fiat_p384_scalar_subborrowx_u32(x291, x268, 0xffffffff);
    let (x294, x295) = fiat_p384_scalar_subborrowx_u32(x293, (x269 as u32), (0x0 as u32));
    let (x296, x297) = fiat_p384_scalar_addcarryx_u32(0x0, x6, (0x1 as u32));
    let x298: u32 = ((x208 >> 1) | ((x210 << 31) & 0xffffffff));
    let x299: u32 = ((x210 >> 1) | ((x212 << 31) & 0xffffffff));
    let x300: u32 = ((x212 >> 1) | ((x214 << 31) & 0xffffffff));
    let x301: u32 = ((x214 >> 1) | ((x216 << 31) & 0xffffffff));
    let x302: u32 = ((x216 >> 1) | ((x218 << 31) & 0xffffffff));
    let x303: u32 = ((x218 >> 1) | ((x220 << 31) & 0xffffffff));
    let x304: u32 = ((x220 >> 1) | ((x222 << 31) & 0xffffffff));
    let x305: u32 = ((x222 >> 1) | ((x224 << 31) & 0xffffffff));
    let x306: u32 = ((x224 >> 1) | ((x226 << 31) & 0xffffffff));
    let x307: u32 = ((x226 >> 1) | ((x228 << 31) & 0xffffffff));
    let x308: u32 = ((x228 >> 1) | ((x230 << 31) & 0xffffffff));
    let x309: u32 = ((x230 >> 1) | ((x232 << 31) & 0xffffffff));
    let x310: u32 = ((x232 & 0x80000000) | (x232 >> 1));
    let (x311) = fiat_p384_scalar_cmovznz_u32(x120, x95, x71);
    let (x312) = fiat_p384_scalar_cmovznz_u32(x120, x97, x73);
    let (x313) = fiat_p384_scalar_cmovznz_u32(x120, x99, x75);
    let (x314) = fiat_p384_scalar_cmovznz_u32(x120, x101, x77);
    let (x315) = fiat_p384_scalar_cmovznz_u32(x120, x103, x79);
    let (x316) = fiat_p384_scalar_cmovznz_u32(x120, x105, x81);
    let (x317) = fiat_p384_scalar_cmovznz_u32(x120, x107, x83);
    let (x318) = fiat_p384_scalar_cmovznz_u32(x120, x109, x85);
    let (x319) = fiat_p384_scalar_cmovznz_u32(x120, x111, x87);
    let (x320) = fiat_p384_scalar_cmovznz_u32(x120, x113, x89);
    let (x321) = fiat_p384_scalar_cmovznz_u32(x120, x115, x91);
    let (x322) = fiat_p384_scalar_cmovznz_u32(x120, x117, x93);
    let (x323) = fiat_p384_scalar_cmovznz_u32(x295, x270, x246);
    let (x324) = fiat_p384_scalar_cmovznz_u32(x295, x272, x248);
    let (x325) = fiat_p384_scalar_cmovznz_u32(x295, x274, x250);
    let (x326) = fiat_p384_scalar_cmovznz_u32(x295, x276, x252);
    let (x327) = fiat_p384_scalar_cmovznz_u32(x295, x278, x254);
    let (x328) = fiat_p384_scalar_cmovznz_u32(x295, x280, x256);
    let (x329) = fiat_p384_scalar_cmovznz_u32(x295, x282, x258);
    let (x330) = fiat_p384_scalar_cmovznz_u32(x295, x284, x260);
    let (x331) = fiat_p384_scalar_cmovznz_u32(x295, x286, x262);
    let (x332) = fiat_p384_scalar_cmovznz_u32(x295, x288, x264);
    let (x333) = fiat_p384_scalar_cmovznz_u32(x295, x290, x266);
    let (x334) = fiat_p384_scalar_cmovznz_u32(x295, x292, x268);
    out1 = x296;
    out2[0] = x7;
    out2[1] = x8;
    out2[2] = x9;
    out2[3] = x10;
    out2[4] = x11;
    out2[5] = x12;
    out2[6] = x13;
    out2[7] = x14;
    out2[8] = x15;
    out2[9] = x16;
    out2[10] = x17;
    out2[11] = x18;
    out2[12] = x19;
    out3[0] = x298;
    out3[1] = x299;
    out3[2] = x300;
    out3[3] = x301;
    out3[4] = x302;
    out3[5] = x303;
    out3[6] = x304;
    out3[7] = x305;
    out3[8] = x306;
    out3[9] = x307;
    out3[10] = x308;
    out3[11] = x309;
    out3[12] = x310;
    out4[0] = x311;
    out4[1] = x312;
    out4[2] = x313;
    out4[3] = x314;
    out4[4] = x315;
    out4[5] = x316;
    out4[6] = x317;
    out4[7] = x318;
    out4[8] = x319;
    out4[9] = x320;
    out4[10] = x321;
    out4[11] = x322;
    out5[0] = x323;
    out5[1] = x324;
    out5[2] = x325;
    out5[3] = x326;
    out5[4] = x327;
    out5[5] = x328;
    out5[6] = x329;
    out5[7] = x330;
    out5[8] = x331;
    out5[9] = x332;
    out5[10] = x333;
    out5[11] = x334;
    (out1, out2, out3, out4, out5)
}
#[doc = " The function fiat_p384_scalar_divstep_precomp returns the precomputed value for Bernstein-Yang-inversion (in montgomery form)."]
#[doc = ""]
#[doc = " Postconditions:"]
#[doc = "   eval (from_montgomery out1) = ⌊(m - 1) / 2⌋^(if ⌊log2 m⌋ + 1 < 46 then ⌊(49 * (⌊log2 m⌋ + 1) + 80) / 17⌋ else ⌊(49 * (⌊log2 m⌋ + 1) + 57) / 17⌋)"]
#[doc = "   0 ≤ eval out1 < m"]
#[doc = ""]
#[doc = " Output Bounds:"]
#[doc = "   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]"]
#[inline]
pub const fn fiat_p384_scalar_divstep_precomp() -> [u32; 12] {
    let mut out1: [u32; 12] = [0; 12];
    out1[0] = 0xe6045b6a;
    out1[1] = 0x49589ae0;
    out1[2] = 0x870040ed;
    out1[3] = 0x3c9a5352;
    out1[4] = 0x977dc242;
    out1[5] = 0xdacb097e;
    out1[6] = 0xd1ecbe36;
    out1[7] = 0xb5ab30a6;
    out1[8] = 0x1f959973;
    out1[9] = 0x97d7a108;
    out1[10] = 0xd27192bc;
    out1[11] = 0x2ba012f8;
    out1
}
